/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityClassContainer;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TD;
import gregapi.item.CreativeTab;
import gregapi.item.IItemColorableRGB;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemReactorRod;
import gregapi.item.IItemRottable;
import gregapi.item.IItemUpdatable;
import gregapi.oredict.IOreDictItemDataOverrideItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.util.OM;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.energy.reactors.MultiTileEntityReactorCore;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.SubTileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2"), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2"), @Optional.Interface(iface="micdoodle8.mods.galacticraft.api.item.IItemElectric", modid="GalacticraftCore"), @Optional.Interface(iface="vazkii.botania.api.item.IFlowerPlaceable", modid="Botania")})
public class MultiTileEntityItemInternal
extends ItemBlock
implements IEdible,
IItemReactorRod,
IItemUpdatable,
IItemColorableRGB,
IOreDictItemDataOverrideItem,
IItemGT,
IItemNoGTOverride,
IFluidContainerItem,
ISpecialElectricItem,
IElectricItemManager,
IItemEnergy,
IItemElectric,
IItemRottable,
IFlowerPlaceable {
    public final MultiTileEntityBlockInternal mBlock;

    public MultiTileEntityItemInternal(Block aBlock) {
        super(aBlock);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.mBlock = (MultiTileEntityBlockInternal)aBlock;
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetItemName) {
            return ((IMultiTileEntity.IMTE_GetItemName)tTileEntityContainer.mTileEntity).getItemName(aStack, super.getItemStackDisplayName(aStack));
        }
        return StatCollector.translateToLocal((String)this.getUnlocalizedName(aStack));
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        float tResistance;
        CoverData tCoverData;
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer == null) {
            aList.add("INVALID ITEM! THIS IS A BUG IF ACQUIRED IN A LEGIT WAY!");
            return;
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_AddToolTips) {
            try {
                ((IMultiTileEntity.IMTE_AddToolTips)tTileEntityContainer.mTileEntity).addToolTips(aList, aStack, aF3_H);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetFlammability ? ((IMultiTileEntity.IMTE_GetFlammability)tTileEntityContainer.mTileEntity).getFlammability((byte)6, tTileEntityContainer.mBlock.getMaterial().getCanBurn()) > 0 : tTileEntityContainer.mBlock.getMaterial().getCanBurn()) {
            aList.add(LH.Chat.RED + LH.get("gt.lang.flammable"));
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetEnchantPowerBonus) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.enchantment.bonus"));
        }
        if (tTileEntityContainer.mTileEntity instanceof ITileEntityCoverable && (tCoverData = ((ITileEntityCoverable)tTileEntityContainer.mTileEntity).getCoverData()) != null) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (tCoverData.mBehaviours[tSide] == null) continue;
                aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.crowbar.to.uncover"));
                break;
            }
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetExplosionResistance && (tResistance = ((IMultiTileEntity.IMTE_GetExplosionResistance)tTileEntityContainer.mTileEntity).getExplosionResistance()) >= 4.0f) {
            aList.add(LH.getToolTipBlastResistance(this.mBlock, tResistance));
        }
        aList.add(LH.getToolTipHarvest(tTileEntityContainer.mBlock.getMaterial(), tTileEntityContainer.mBlock.getHarvestTool(tTileEntityContainer.mBlockMetaData), tTileEntityContainer.mBlock.getHarvestLevel(tTileEntityContainer.mBlockMetaData)));
        while (aList.remove(null)) {
        }
    }

    public int onDespawn(EntityItem aEntity, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnDespawn) {
            try {
                return ((IMultiTileEntity.IMTE_OnDespawn)tTileEntityContainer.mTileEntity).onDespawn(aEntity, aStack);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return 0;
    }

    public int getEntityLifespan(ItemStack aStack, World aWorld) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetLifeSpan) {
            try {
                return ((IMultiTileEntity.IMTE_GetLifeSpan)tTileEntityContainer.mTileEntity).getLifeSpan(aWorld, aStack);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return super.getEntityLifespan(aStack, aWorld);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item aItem, CreativeTabs aTab, List aList) {
        if (aTab instanceof CreativeTab) {
            for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
                if (tClass.mHidden && !CS.SHOW_HIDDEN_ITEMS || ((CreativeTab)aTab).mMetaData != tClass.mCreativeTabID || tClass.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_GetSubItems && !((IMultiTileEntity.IMTE_GetSubItems)tClass.mCanonicalTileEntity).getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
                aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
            }
        } else {
            for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
                if (tClass.mHidden && !CS.SHOW_HIDDEN_ITEMS || tClass.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_GetSubItems && !((IMultiTileEntity.IMTE_GetSubItems)tClass.mCanonicalTileEntity).getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
                aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
            }
        }
    }

    public CreativeTabs[] getCreativeTabs() {
        return this.mBlock.mMultiTileEntityRegistry.mCreativeTabs.values().toArray(new CreativeTabs[this.mBlock.mMultiTileEntityRegistry.mCreativeTabs.size()]);
    }

    public boolean onItemUse(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        block22: {
            if (aY < 0 || aY > aWorld.getHeight()) {
                return false;
            }
            try {
                Block tClickedBlock = aWorld.getBlock(aX, aY, aZ);
                if (tClickedBlock instanceof BlockSnow && (aWorld.getBlockMetadata(aX, aY, aZ) & 7) < 1) {
                    aSide = 1;
                } else if (tClickedBlock != Blocks.vine && tClickedBlock != Blocks.tallgrass && tClickedBlock != Blocks.deadbush && !tClickedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
                    aX += CS.OFFX[aSide];
                    aY += CS.OFFY[aSide];
                    aZ += CS.OFFZ[aSide];
                }
                Block tReplacedBlock = aWorld.getBlock(aX, aY, aZ);
                if (!tReplacedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ) || !this.mBlock.canReplace(aWorld, aX, aY, aZ, aSide, aStack)) {
                    return false;
                }
                if (aStack.stackSize == 0 || aPlayer != null && !aPlayer.canPlayerEdit(aX, aY, aZ, aSide, aStack)) {
                    return false;
                }
                MultiTileEntityContainer aMTEContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aWorld, aX, aY, aZ, aStack);
                if (aMTEContainer == null || aPlayer != null && !aPlayer.isSneaking() && aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking && ((IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking)aMTEContainer.mTileEntity).onlyPlaceableWhenSneaking() || (!(aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing) || !((IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing)aMTEContainer.mTileEntity).ignorePlayerCollisionWhenPlacing(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) && !aWorld.checkNoEntityCollision(AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1))) || aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_CanPlace && !((IMultiTileEntity.IMTE_CanPlace)aMTEContainer.mTileEntity).canPlace(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ) || !aWorld.setBlock(aX, aY, aZ, (Block)aMTEContainer.mBlock, 15 - aMTEContainer.mBlockMetaData, 2)) break block22;
                ((IMultiTileEntity)aMTEContainer.mTileEntity).setShouldRefresh(false);
                WD.te(aWorld, aX, aY, aZ, aMTEContainer.mTileEntity, false);
                WD.set(aWorld, aX, aY, aZ, aMTEContainer.mBlock, aMTEContainer.mBlockMetaData, 0L, false);
                ((IMultiTileEntity)aMTEContainer.mTileEntity).setShouldRefresh(true);
                WD.te(aWorld, aX, aY, aZ, aMTEContainer.mTileEntity, true);
                try {
                    if (!(aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnPlaced) || ((IMultiTileEntity.IMTE_OnPlaced)aMTEContainer.mTileEntity).onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) {
                        aWorld.playSoundEffect((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, aMTEContainer.mBlock.stepSound.func_150496_b(), (aMTEContainer.mBlock.stepSound.getVolume() + 1.0f) / 2.0f, aMTEContainer.mBlock.stepSound.getPitch() * 0.8f);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && ((IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)aMTEContainer.mTileEntity).hasMultiBlockMachineRelevantData()) {
                        ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(aWorld, aX, aY, aZ, aMTEContainer.mBlock, aMTEContainer.mBlockMetaData, false);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (!aWorld.isRemote) {
                        aWorld.notifyBlockChange(aX, aY, aZ, tReplacedBlock);
                        aWorld.func_147453_f(aX, aY, aZ, (Block)aMTEContainer.mBlock);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aMTEContainer.mTileEntity instanceof ITileEntity) {
                        ((ITileEntity)aMTEContainer.mTileEntity).onTileEntityPlaced();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    aWorld.func_147451_t(aX, aY, aZ);
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                --aStack.stackSize;
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemUpdatable) {
            ((IItemUpdatable)tTileEntityContainer.mTileEntity).updateItemStack(aStack);
        }
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemUpdatable) {
            ((IItemUpdatable)tTileEntityContainer.mTileEntity).updateItemStack(aStack, aWorld, aX, aY, aZ);
        }
    }

    public int getItemStackLimit(ItemStack aStack) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return 1;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetMaxStackSize) {
            return UT.Code.bindStack(((IMultiTileEntity.IMTE_GetMaxStackSize)tTileEntityContainer.mTileEntity).getMaxStackSize(aStack, tContainer.mStackSize));
        }
        return tContainer.mStackSize;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnCrafted) {
            this.updateItemStack(aStack);
            ((IMultiTileEntity.IMTE_OnCrafted)tTileEntityContainer.mTileEntity).onCrafted(aPlayer, aWorld, aStack);
        }
        this.updateItemStack(aStack);
    }

    @Override
    public OreDictItemData getOreDictItemData(ItemStack aStack) {
        CoverData tCoverData;
        List<OreDictItemData> rList = new ArrayListNoNulls<OreDictItemData>(false, OM.data(aStack));
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof ITileEntityCoverable && (tCoverData = ((ITileEntityCoverable)tTileEntityContainer.mTileEntity).getCoverData()) != null) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                rList.add(OM.anydata(tCoverData.getCoverItem(tSide)));
            }
        }
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof ITileEntityFoamable && ((ITileEntityFoamable)tTileEntityContainer.mTileEntity).hasFoam((byte)6)) {
            rList.add(new OreDictItemData(MT.ConstructionFoam, 648648000L, new OreDictMaterialStack[0]));
            if (((ITileEntityFoamable)tTileEntityContainer.mTileEntity).ownedFoam((byte)6)) {
                rList.add(new OreDictItemData(MT.Pd, 162162000L, new OreDictMaterialStack[0]));
            }
        }
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetOreDictItemData) {
            rList = ((IMultiTileEntity.IMTE_GetOreDictItemData)tTileEntityContainer.mTileEntity).getOreDictItemData(rList);
        }
        return rList.isEmpty() ? null : (rList.size() > 1 ? new OreDictItemData(rList) : (OreDictItemData)rList.get(0));
    }

    public FluidStack getFluid(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getFluid(aStack);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return CS.NF;
    }

    public int getCapacity(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int rCapacity = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getCapacity(aStack);
            this.updateItemStack(aStack);
            return rCapacity;
        }
        return 0;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int tFilled = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).fill(aStack, aFluid, aDoFill);
            this.updateItemStack(aStack);
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).drain(aStack, aMaxDrain, aDoDrain);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return CS.NF;
    }

    @Override
    public boolean canRecolorItem(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemColorableRGB) {
            return ((IItemColorableRGB)tTileEntityContainer.mTileEntity).canRecolorItem(aStack);
        }
        return false;
    }

    @Override
    public boolean recolorItem(ItemStack aStack, int aRGB) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemColorableRGB && ((IItemColorableRGB)tTileEntityContainer.mTileEntity).recolorItem(aStack, aRGB)) {
            this.updateItemStack(aStack);
            return true;
        }
        return false;
    }

    @Override
    public boolean canDecolorItem(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemColorableRGB) {
            return ((IItemColorableRGB)tTileEntityContainer.mTileEntity).canDecolorItem(aStack);
        }
        return false;
    }

    @Override
    public boolean decolorItem(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemColorableRGB && ((IItemColorableRGB)tTileEntityContainer.mTileEntity).decolorItem(aStack)) {
            this.updateItemStack(aStack);
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnItemUseFirst) {
            boolean rReturn = ((IMultiTileEntity.IMTE_OnItemUseFirst)tTileEntityContainer.mTileEntity).onItemUseFirst(this, aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, hitX, hitY, hitZ);
            this.updateItemStack(aStack);
            return rReturn;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnItemRightClick) {
            ItemStack rStack = ((IMultiTileEntity.IMTE_OnItemRightClick)tTileEntityContainer.mTileEntity).onItemRightClick(this, aStack, aWorld, aPlayer);
            if (aStack != rStack) {
                this.updateItemStack(aStack);
            }
            this.updateItemStack(rStack);
            return rStack;
        }
        return aStack;
    }

    public int getMaxItemUseDuration(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetMaxItemUseDuration) {
            int rDuration = ((IMultiTileEntity.IMTE_GetMaxItemUseDuration)tTileEntityContainer.mTileEntity).getMaxItemUseDuration(this, aStack);
            this.updateItemStack(aStack);
            return rDuration;
        }
        return 0;
    }

    public EnumAction getItemUseAction(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetItemUseAction) {
            EnumAction rAction = ((IMultiTileEntity.IMTE_GetItemUseAction)tTileEntityContainer.mTileEntity).getItemUseAction(this, aStack);
            this.updateItemStack(aStack);
            return rAction;
        }
        return EnumAction.none;
    }

    public ItemStack onEaten(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnEaten) {
            ItemStack rStack = ((IMultiTileEntity.IMTE_OnEaten)tTileEntityContainer.mTileEntity).onEaten(this, aStack, aWorld, aPlayer);
            if (aStack != rStack) {
                this.updateItemStack(aStack);
            }
            this.updateItemStack(rStack);
            return rStack;
        }
        return aStack;
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetFoodValues) {
            return ((IMultiTileEntity.IMTE_GetFoodValues)tTileEntityContainer.mTileEntity).getFoodValues(this, aStack);
        }
        return null;
    }

    @Override
    public ItemStack getRotten(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemRottable) {
            return ((IItemRottable)tTileEntityContainer.mTileEntity).getRotten(aStack);
        }
        return IItemRottable.RottingUtil.rotting(aStack, this);
    }

    @Override
    public ItemStack getRotten(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemRottable) {
            return ((IItemRottable)tTileEntityContainer.mTileEntity).getRotten(aStack, aWorld, aX, aY, aZ);
        }
        return IItemRottable.RottingUtil.rotting(aStack, this);
    }

    @Override
    public boolean isReactorRod(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).isReactorRod(aStack);
        }
        return false;
    }

    @Override
    public boolean isModerated(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).isModerated(aReactor, aSlot, aStack);
        }
        return false;
    }

    @Override
    public void updateModeration(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            ((IItemReactorRod)tTileEntityContainer.mTileEntity).updateModeration(aReactor, aSlot, aStack);
        }
    }

    @Override
    public int getReactorRodNeutronEmission(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodNeutronEmission(aReactor, aSlot, aStack);
        }
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodNeutronReaction(aReactor, aSlot, aStack);
        }
        return false;
    }

    @Override
    public int getReactorRodNeutronReflection(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, int aNeutrons, boolean aModerated) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodNeutronReflection(aReactor, aSlot, aStack, aNeutrons, aModerated);
        }
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodNeutronMaximum(aReactor, aSlot, aStack);
        }
        return 0;
    }

    @Override
    public ITexture getReactorRodTextureSides(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, boolean aActive) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodTextureSides(aReactor, aSlot, aStack, aActive);
        }
        return BlockTextureCopied.get(Blocks.cobblestone);
    }

    @Override
    public ITexture getReactorRodTextureTop(MultiTileEntityReactorCore aReactor, int aSlot, ItemStack aStack, boolean aActive) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemReactorRod) {
            return ((IItemReactorRod)tTileEntityContainer.mTileEntity).getReactorRodTextureTop(aReactor, aSlot, aStack, aActive);
        }
        return BlockTextureCopied.get(Blocks.cobblestone);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).isEnergyType(aEnergyType, aStack, aEmitting);
        }
        return false;
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergyTypes(aStack);
        }
        return Collections.emptyList();
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).doEnergyInjection(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoInject);
        }
        return 0L;
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).canEnergyInjection(aEnergyType, aStack, aSize);
        }
        return false;
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).doEnergyExtraction(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoExtract);
        }
        return 0L;
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).canEnergyExtraction(aEnergyType, aStack, aSize);
        }
        return false;
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).useEnergy(aEnergyType, aStack, aEnergyAmount, aPlayer, aInventory, aWorld, aX, aY, aZ, aDoUse);
        }
        return false;
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).setEnergyStored(aEnergyType, aStack, aAmount);
        }
        return aStack;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergyStored(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergyCapacity(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeInputMin(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeOutputMin(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeInputRecommended(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeOutputRecommended(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeInputMax(aEnergyType, aStack);
        }
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IItemEnergy) {
            return ((IItemEnergy)tTileEntityContainer.mTileEntity).getEnergySizeOutputMax(aEnergyType, aStack);
        }
        return 0L;
    }

    public double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        byte by = UT.Code.bind4(aTier);
        aTier = by;
        if (aCharge < (double)CS.V[by]) {
            return 0.0;
        }
        return CS.V[aTier] * this.doEnergyInjection(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    public double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        byte by = UT.Code.bind4(aTier);
        aTier = by;
        if (aCharge < (double)CS.V[by]) {
            return 0.0;
        }
        return CS.V[aTier] * this.doEnergyExtraction(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    public float discharge(ItemStack aStack, float aEnergy, boolean aDoExtract) {
        if (aEnergy <= 0.0f) {
            return 0.0f;
        }
        long tMaxOut = this.getEnergySizeOutputMax(TD.Energy.EU, aStack);
        if (!this.canEnergyExtraction(TD.Energy.EU, aStack, tMaxOut)) {
            return 0.0f;
        }
        long tAmount = UT.Code.bind(1L, tMaxOut, (long)(aEnergy / EnergyConfigHandler.IC2_RATIO));
        return this.useEnergy(TD.Energy.EU, aStack, tAmount, null, null, null, 0, 0, 0, false) && this.useEnergy(TD.Energy.EU, aStack, tAmount, null, null, null, 0, 0, 0, true) ? (float)tAmount * EnergyConfigHandler.IC2_RATIO : 0.0f;
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }

    @Optional.Method(modid="Botania")
    public Block getBlockToPlaceByFlower(ItemStack aStack, SubTileEntity aFlower, int aX, int aY, int aZ) {
        return null;
    }

    @Optional.Method(modid="Botania")
    public void onBlockPlacedByFlower(ItemStack aStack, SubTileEntity aFlower, int aX, int aY, int aZ) {
    }

    public boolean func_150936_a(World aWorld, int aX, int aY, int aZ, int aSide, EntityPlayer aPlayer, ItemStack aStack) {
        return true;
    }

    public String getToolTip(ItemStack aStack) {
        return null;
    }

    public void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
    }

    public float getElectricityStored(ItemStack aStack) {
        return (float)this.getEnergyStored(TD.Energy.EU, aStack) * EnergyConfigHandler.IC2_RATIO;
    }

    public float getMaxElectricityStored(ItemStack aStack) {
        return (float)this.getEnergyCapacity(TD.Energy.EU, aStack) * EnergyConfigHandler.IC2_RATIO;
    }

    public void setElectricity(ItemStack aStack, float joules) {
    }

    public float recharge(ItemStack aStack, float aEnergy, boolean aDoInject) {
        return 0.0f;
    }

    public float getTransfer(ItemStack aStack) {
        return 0.0f;
    }

    public int getTierGC(ItemStack aStack) {
        return 1;
    }

    public double getCharge(ItemStack aStack) {
        return this.getEnergyStored(TD.Energy.EU, aStack);
    }

    public boolean canUse(ItemStack aStack, double aAmount) {
        return this.useEnergy(TD.Energy.EU, aStack, (long)aAmount, null, null, null, 0, 0, 0, false);
    }

    public boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        return this.useEnergy(TD.Energy.EU, aStack, (long)aAmount, aPlayer, null, null, 0, 0, 0, true);
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        return true;
    }

    public double getMaxCharge(ItemStack aStack) {
        return this.getEnergyCapacity(TD.Energy.EU, aStack);
    }

    public double getTransferLimit(ItemStack aStack) {
        return this.getEnergySizeInputRecommended(TD.Energy.EU, aStack);
    }

    public int getTier(ItemStack aStack) {
        return UT.Code.tierMax(this.getEnergySizeInputMax(TD.Energy.EU, aStack));
    }

    public final String getUnlocalizedName() {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal;
    }

    public final String getUnlocalizedName(ItemStack aStack) {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal + "." + this.getDamage(aStack);
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int aMeta) {
        this.itemIcon = Items.bread.getIconFromDamage(0);
        return this.itemIcon;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public final boolean getShareTag() {
        return true;
    }
}

