/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import gregapi.block.IBlock;
import gregapi.block.IBlockDebugable;
import gregapi.block.IBlockErrorable;
import gregapi.block.IBlockMaterial;
import gregapi.block.IBlockOnWalkOver;
import gregapi.block.IBlockRetrievable;
import gregapi.block.IBlockSyncData;
import gregapi.block.IBlockToolable;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockWithCompat;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.item.IItemGT;
import gregapi.network.INetworkHandler;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.ITileEntitySynchronising;
import gregapi.tileentity.inventories.ITileEntityBookShelf;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mekanism.api.MekanismAPI;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class MultiTileEntityBlock
extends Block
implements IBlock,
IItemGT,
IBlockDebugable,
IBlockErrorable,
IBlockOnWalkOver,
IBlockSyncData.IBlockSyncDataAndCoversAndIDs,
IRenderedBlock,
ITileEntityProvider,
IBlockToolable,
IBlockRetrievable,
IBlockMaterial {
    private static final Map<String, MultiTileEntityBlock> MULTITILEENTITYBLOCKMAP = new HashMap<String, MultiTileEntityBlock>();
    private final int mHarvestLevelOffset;
    private final int mHarvestLevelMinimum;
    private final int mHarvestLevelMaximum;
    private final String mNameInternal;
    private final String mTool;
    private final boolean mOpaque;
    private final boolean mNormalCube;
    public MapColor mMapColor = null;
    private static boolean LOCK = false;

    public static String getName(String aNameOfVanillaMaterialField, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        return "gt.block.multitileentity." + aNameOfVanillaMaterialField + "." + aSoundType.soundName + "." + aTool + "." + aHarvestLevelOffset + "." + aHarvestLevelMinimum + "." + aHarvestLevelMaximum + "." + aOpaque + "." + aNormalCube;
    }

    public static MultiTileEntityBlock getOrCreate(String aModID, String aNameOfVanillaMaterialField, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        aTool = aTool.toLowerCase();
        MultiTileEntityBlock rBlock = MULTITILEENTITYBLOCKMAP.get(aModID + ":" + MultiTileEntityBlock.getName(aNameOfVanillaMaterialField, aVanillaMaterial, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube));
        return rBlock == null ? MultiTileEntityBlockWithCompat.create(aModID, aNameOfVanillaMaterialField, aVanillaMaterial, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube) : rBlock;
    }

    protected MultiTileEntityBlock(String aModID, String aNameOfVanillaMaterialField, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aOpaque, boolean aNormalCube) {
        super(aVanillaMaterial);
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("Blocks can only be initialised within preInit!");
        }
        this.mNameInternal = MultiTileEntityBlock.getName(aNameOfVanillaMaterialField, aVanillaMaterial, aSoundType, aTool, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aOpaque, aNormalCube);
        ST.register(this, this.mNameInternal, ItemBlock.class);
        MULTITILEENTITYBLOCKMAP.put(aModID + ":" + this.mNameInternal, this);
        this.setStepSound(aSoundType);
        this.mOpaque = aOpaque;
        this.mNormalCube = aNormalCube;
        this.mTool = aTool.toLowerCase();
        this.mHarvestLevelOffset = aHarvestLevelOffset;
        this.mHarvestLevelMinimum = Math.max(0, aHarvestLevelMinimum);
        this.mHarvestLevelMaximum = Math.max(aHarvestLevelMinimum, aHarvestLevelMaximum);
        this.opaque = this.isOpaqueCube();
        int n = this.lightOpacity = this.isOpaqueCube() ? 255 : 0;
        if (MD.Mek.mLoaded) {
            try {
                MekanismAPI.addBoxBlacklist((Block)this, (int)Short.MAX_VALUE);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        ST.hide(this);
    }

    public final void breakBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetaData) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            CS.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        if (aTileEntity == null || !aTileEntity.shouldRefresh((Block)this, aBlock, aMetaData, aMetaData, aWorld, aX, aY, aZ)) {
            return;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_BreakBlock && ((IMultiTileEntity.IMTE_BreakBlock)aTileEntity).breakBlock()) {
            return;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && ((IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)aTileEntity).hasMultiBlockMachineRelevantData()) {
            ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(aWorld, aX, aY, aZ, this, (byte)aMetaData, true);
        }
        aWorld.removeTileEntity(aX, aY, aZ);
    }

    public MapColor getMapColor(int aMeta) {
        return this.mMapColor == null ? super.getMapColor(aMeta) : this.mMapColor;
    }

    public MultiTileEntityBlock setMapColor(MapColor aMapColor) {
        this.mMapColor = aMapColor;
        return this;
    }

    @Override
    public final void receiveDataName(IBlockAccess aWorld, int aX, int aY, int aZ, String aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity) {
            ((IMultiTileEntity)aTileEntity).setCustomName(aData);
        }
    }

    @Override
    public final void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByte && ((IMultiTileEntity.IMTE_SyncDataByte)aTileEntity).receiveDataByte(aData, aNetworkHandler)) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public final void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataShort && ((IMultiTileEntity.IMTE_SyncDataShort)aTileEntity).receiveDataShort(aData, aNetworkHandler)) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public final void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataInteger && ((IMultiTileEntity.IMTE_SyncDataInteger)aTileEntity).receiveDataInteger(aData, aNetworkHandler)) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public final void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataLong && ((IMultiTileEntity.IMTE_SyncDataLong)aTileEntity).receiveDataLong(aData, aNetworkHandler)) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public final void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByteArray && ((IMultiTileEntity.IMTE_SyncDataByteArray)aTileEntity).receiveDataByteArray(aData, aNetworkHandler)) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public final void receiveData(IBlockAccess aWorld, int aX, int aY, int aZ, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByte) {
            ((IMultiTileEntity.IMTE_SyncDataByte)aTileEntity).receiveDataByte(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataShort) {
            ((IMultiTileEntity.IMTE_SyncDataShort)aTileEntity).receiveDataShort(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataInteger) {
            ((IMultiTileEntity.IMTE_SyncDataInteger)aTileEntity).receiveDataInteger(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataLong) {
            ((IMultiTileEntity.IMTE_SyncDataLong)aTileEntity).receiveDataLong(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler, short aID1, short aID2) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByteArray) {
            ((IMultiTileEntity.IMTE_SyncDataByteArray)aTileEntity).receiveDataByteArray(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveData(IBlockAccess aWorld, int aX, int aY, int aZ, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByte) {
            ((IMultiTileEntity.IMTE_SyncDataByte)aTileEntity).receiveDataByte(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataShort) {
            ((IMultiTileEntity.IMTE_SyncDataShort)aTileEntity).receiveDataShort(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataInteger) {
            ((IMultiTileEntity.IMTE_SyncDataInteger)aTileEntity).receiveDataInteger(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataLong) {
            ((IMultiTileEntity.IMTE_SyncDataLong)aTileEntity).receiveDataLong(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler, short aID1, short aID2, short[] aCoverIDs, short[] aCoverMetas, short[] aCoverVisuals) {
        if (!(aWorld instanceof World)) {
            return;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aID1);
        if (tRegistry == null) {
            return;
        }
        TileEntity aTileEntity = tRegistry.getNewTileEntity((World)aWorld, aX, aY, aZ, aID2);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverIDs, aCoverMetas, aNetworkHandler);
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, CS.TRUE_6, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByteArray) {
            ((IMultiTileEntity.IMTE_SyncDataByteArray)aTileEntity).receiveDataByteArray(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveData(IBlockAccess aWorld, int aX, int aY, int aZ, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByte) {
            ((IMultiTileEntity.IMTE_SyncDataByte)aTileEntity).receiveDataByte(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataShort) {
            ((IMultiTileEntity.IMTE_SyncDataShort)aTileEntity).receiveDataShort(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataInteger) {
            ((IMultiTileEntity.IMTE_SyncDataInteger)aTileEntity).receiveDataInteger(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataLong) {
            ((IMultiTileEntity.IMTE_SyncDataLong)aTileEntity).receiveDataLong(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    @Override
    public final void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler, short[] aCoverVisuals, boolean[] aVisualsToSync) {
        if (!(aWorld instanceof World)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null) {
            return;
        }
        WD.te((World)aWorld, aX, aY, aZ, aTileEntity, false);
        if (aTileEntity instanceof ITileEntitySynchronising) {
            ((ITileEntitySynchronising)aTileEntity).processPacket(aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataCovers) {
            ((IMultiTileEntity.IMTE_SyncDataCovers)aTileEntity).receiveDataCovers(aCoverVisuals, aVisualsToSync, aNetworkHandler);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SyncDataByteArray) {
            ((IMultiTileEntity.IMTE_SyncDataByteArray)aTileEntity).receiveDataByteArray(aData, aNetworkHandler);
        }
        WD.update(aWorld, aX, aY, aZ);
    }

    public final boolean getBlocksMovement(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return !(aTileEntity instanceof IMultiTileEntity.IMTE_GetBlocksMovement) || ((IMultiTileEntity.IMTE_GetBlocksMovement)aTileEntity).getBlocksMovement();
    }

    public final void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB aAABB, List aList, Entity aEntity) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_AddCollisionBoxesToList) {
            ((IMultiTileEntity.IMTE_AddCollisionBoxesToList)aTileEntity).addCollisionBoxesToList(aAABB, aList, aEntity);
        } else if (aTileEntity != null) {
            super.addCollisionBoxesToList(aWorld, aX, aY, aZ, aAABB, aList, aEntity);
        }
    }

    public final AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool ? ((IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool)aTileEntity).getCollisionBoundingBoxFromPool() : (aTileEntity == null ? null : AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)));
    }

    public final void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_UpdateTick) {
            ((IMultiTileEntity.IMTE_UpdateTick)aTileEntity).updateTick(aRandom);
        }
    }

    public final void onBlockDestroyedByPlayer(World aWorld, int aX, int aY, int aZ, int aRandom) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockDestroyedByPlayer) {
            ((IMultiTileEntity.IMTE_OnBlockDestroyedByPlayer)aTileEntity).onBlockDestroyedByPlayer(aRandom);
        }
    }

    public final void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockAdded) {
            ((IMultiTileEntity.IMTE_OnBlockAdded)aTileEntity).onBlockAdded();
        }
    }

    public final void dropXpOnBlockBreak(World aWorld, int aX, int aY, int aZ, int aXP) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_DropXpOnBlockBreak) {
            ((IMultiTileEntity.IMTE_DropXpOnBlockBreak)aTileEntity).dropXpOnBlockBreak(aXP);
        } else {
            super.dropXpOnBlockBreak(aWorld, aX, aY, aZ, aXP);
        }
    }

    public final MovingObjectPosition collisionRayTrace(World aWorld, int aX, int aY, int aZ, Vec3 aVectorA, Vec3 aVectorB) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CollisionRayTrace ? ((IMultiTileEntity.IMTE_CollisionRayTrace)aTileEntity).collisionRayTrace(aVectorA, aVectorB) : super.collisionRayTrace(aWorld, aX, aY, aZ, aVectorA, aVectorB);
    }

    public final boolean onBlockActivated(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float aHitX, float aHitY, float aHitZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (!(aPlayer == null || !IL.TC_Thaumometer.equal(aPlayer.getHeldItem(), true, true) || aTileEntity instanceof ITileEntityBookShelf && ((ITileEntityBookShelf)aTileEntity).isShelfFace(UT.Code.side(aSide)))) {
            return false;
        }
        return aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockActivated && ((IMultiTileEntity.IMTE_OnBlockActivated)aTileEntity).onBlockActivated(aPlayer, UT.Code.side(aSide), aHitX, aHitY, aHitZ);
    }

    public final void onEntityWalking(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnEntityWalking) {
            ((IMultiTileEntity.IMTE_OnEntityWalking)aTileEntity).onEntityWalking(aEntity);
        }
    }

    public final void onBlockClicked(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockClicked) {
            ((IMultiTileEntity.IMTE_OnBlockClicked)aTileEntity).onBlockClicked(aPlayer);
        } else {
            super.onBlockClicked(aWorld, aX, aY, aZ, aPlayer);
        }
    }

    public final void velocityToAddToEntity(World aWorld, int aX, int aY, int aZ, Entity aEntity, Vec3 aVector) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_VelocityToAddToEntity) {
            ((IMultiTileEntity.IMTE_VelocityToAddToEntity)aTileEntity).velocityToAddToEntity(aEntity, aVector);
        } else {
            super.velocityToAddToEntity(aWorld, aX, aY, aZ, aEntity, aVector);
        }
    }

    public final int isProvidingWeakPower(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingWeakPower ? ((IMultiTileEntity.IMTE_IsProvidingWeakPower)aTileEntity).isProvidingWeakPower(UT.Code.side(aSide)) : super.isProvidingWeakPower(aWorld, aX, aY, aZ, aSide);
    }

    public final void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnEntityCollidedWithBlock) {
            ((IMultiTileEntity.IMTE_OnEntityCollidedWithBlock)aTileEntity).onEntityCollidedWithBlock(aEntity);
        } else {
            super.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, aEntity);
        }
    }

    public final int isProvidingStrongPower(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower ? ((IMultiTileEntity.IMTE_IsProvidingStrongPower)aTileEntity).isProvidingStrongPower(UT.Code.side(aSide)) : super.isProvidingStrongPower(aWorld, aX, aY, aZ, aSide);
    }

    public final boolean canBlockStay(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return !(aTileEntity instanceof IMultiTileEntity.IMTE_CanBlockStay) || ((IMultiTileEntity.IMTE_CanBlockStay)aTileEntity).canBlockStay();
    }

    public final void onFallenUpon(World aWorld, int aX, int aY, int aZ, Entity aEntity, float aFallDistance) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnFallenUpon) {
            ((IMultiTileEntity.IMTE_OnFallenUpon)aTileEntity).onFallenUpon(aEntity, aFallDistance);
        } else {
            super.onFallenUpon(aWorld, aX, aY, aZ, aEntity, aFallDistance);
        }
    }

    public final void onBlockHarvested(World aWorld, int aX, int aY, int aZ, int aMetaData, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockHarvested) {
            ((IMultiTileEntity.IMTE_OnBlockHarvested)aTileEntity).onBlockHarvested(aMetaData, aPlayer);
        } else {
            super.onBlockHarvested(aWorld, aX, aY, aZ, aMetaData, aPlayer);
        }
    }

    public final void onBlockPreDestroy(World aWorld, int aX, int aY, int aZ, int aMetaData) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockPreDestroy) {
            ((IMultiTileEntity.IMTE_OnBlockPreDestroy)aTileEntity).onBlockPreDestroy(aMetaData);
        } else {
            super.onBlockPreDestroy(aWorld, aX, aY, aZ, aMetaData);
        }
    }

    public final void fillWithRain(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_FillWithRain) {
            ((IMultiTileEntity.IMTE_FillWithRain)aTileEntity).fillWithRain();
        } else {
            super.fillWithRain(aWorld, aX, aY, aZ);
        }
    }

    public final boolean hasComparatorInputOverride() {
        return true;
    }

    public final int getComparatorInputOverride(World aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetComparatorInputOverride ? ((IMultiTileEntity.IMTE_GetComparatorInputOverride)aTileEntity).getComparatorInputOverride(UT.Code.side(aSide)) : (aTileEntity instanceof IMultiTileEntity.IMTE_IsProvidingWeakPower ? ((IMultiTileEntity.IMTE_IsProvidingWeakPower)aTileEntity).isProvidingWeakPower(CS.OPOS[aSide]) : super.getComparatorInputOverride(aWorld, aX, aY, aZ, aSide));
    }

    public final int getLightValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetLightValue ? UT.Code.bind4(((IMultiTileEntity.IMTE_GetLightValue)aTileEntity).getLightValue()) : super.getLightValue(aWorld, aX, aY, aZ);
    }

    public final boolean isLadder(IBlockAccess aWorld, int aX, int aY, int aZ, EntityLivingBase aEntity) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsLadder && ((IMultiTileEntity.IMTE_IsLadder)aTileEntity).isLadder(aEntity);
    }

    public final boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsNormalCube ? ((IMultiTileEntity.IMTE_IsNormalCube)aTileEntity).isNormalCube() : this.mNormalCube;
    }

    public final boolean isReplaceable(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsReplaceable ? ((IMultiTileEntity.IMTE_IsReplaceable)aTileEntity).isReplaceable() : this.blockMaterial.isReplaceable();
    }

    public final boolean isBurning(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsBurning && ((IMultiTileEntity.IMTE_IsBurning)aTileEntity).isBurning();
    }

    public final boolean isAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld == null) {
            return false;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsAir && ((IMultiTileEntity.IMTE_IsAir)aTileEntity).isAir();
    }

    public final boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, boolean aWillHarvest) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            CS.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        return aTileEntity instanceof IMultiTileEntity.IMTE_RemovedByPlayer ? ((IMultiTileEntity.IMTE_RemovedByPlayer)aTileEntity).removedByPlayer(aWorld, aPlayer, aWillHarvest) : super.removedByPlayer(aWorld, aPlayer, aX, aY, aZ, aWillHarvest);
    }

    public final boolean canCreatureSpawn(EnumCreatureType aType, IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanCreatureSpawn && ((IMultiTileEntity.IMTE_CanCreatureSpawn)aTileEntity).canCreatureSpawn(aType);
    }

    public final boolean isBed(IBlockAccess aWorld, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsBed && ((IMultiTileEntity.IMTE_IsBed)aTileEntity).isBed(aPlayer);
    }

    public final ChunkCoordinates getBedSpawnPosition(IBlockAccess aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_VelocityToAddToEntity ? ((IMultiTileEntity.IMTE_GetBedSpawnPosition)aTileEntity).getBedSpawnPosition(aPlayer) : null;
    }

    public final void setBedOccupied(IBlockAccess aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, boolean aOccupied) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SetBedOccupied) {
            ((IMultiTileEntity.IMTE_SetBedOccupied)aTileEntity).setBedOccupied(aPlayer, aOccupied);
        }
    }

    public final int getBedDirection(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetBedDirection ? ((IMultiTileEntity.IMTE_GetBedDirection)aTileEntity).getBedDirection() : 0;
    }

    public final boolean isBedFoot(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsBedFoot && ((IMultiTileEntity.IMTE_IsBedFoot)aTileEntity).isBedFoot();
    }

    public final void beginLeavesDecay(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_BeginLeavesDecay) {
            ((IMultiTileEntity.IMTE_BeginLeavesDecay)aTileEntity).beginLeavesDecay();
        } else {
            super.beginLeavesDecay(aWorld, aX, aY, aZ);
        }
    }

    public final boolean canSustainLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanSustainLeaves ? ((IMultiTileEntity.IMTE_CanSustainLeaves)aTileEntity).canSustainLeaves() : super.canSustainLeaves(aWorld, aX, aY, aZ);
    }

    public final boolean isLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsLeaves && ((IMultiTileEntity.IMTE_IsLeaves)aTileEntity).isLeaves();
    }

    public final boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanBeReplacedByLeaves && ((IMultiTileEntity.IMTE_CanBeReplacedByLeaves)aTileEntity).canBeReplacedByLeaves();
    }

    public final boolean isWood(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsWood ? ((IMultiTileEntity.IMTE_IsWood)aTileEntity).isWood() : super.isWood(aWorld, aX, aY, aZ);
    }

    public final boolean isReplaceableOreGen(World aWorld, int aX, int aY, int aZ, Block aTarget) {
        if (CS.GAPI.mStartedServerStarted < 1) {
            return false;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsReplaceableOreGen ? ((IMultiTileEntity.IMTE_IsReplaceableOreGen)aTileEntity).isReplaceableOreGen(aTarget) : super.isReplaceableOreGen(aWorld, aX, aY, aZ, aTarget);
    }

    public final boolean canConnectRedstone(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanConnectRedstone ? ((IMultiTileEntity.IMTE_CanConnectRedstone)aTileEntity).canConnectRedstone(UT.Code.side(aSide)) : super.canConnectRedstone(aWorld, aX, aY, aZ, aSide);
    }

    public final boolean canPlaceTorchOnTop(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanPlaceTorchOnTop ? ((IMultiTileEntity.IMTE_CanPlaceTorchOnTop)aTileEntity).canPlaceTorchOnTop() : this.isSideSolid((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[1]);
    }

    public final boolean isFoliage(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsFoliage ? ((IMultiTileEntity.IMTE_IsFoliage)aTileEntity).isFoliage() : super.isFoliage(aWorld, aX, aY, aZ);
    }

    public final boolean canSustainPlant(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide, IPlantable aPlantable) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_CanSustainPlant ? ((IMultiTileEntity.IMTE_CanSustainPlant)aTileEntity).canSustainPlant(UT.Code.side(aSide), aPlantable) : super.canSustainPlant(aWorld, aX, aY, aZ, aSide, aPlantable);
    }

    public final void onPlantGrow(World aWorld, int aX, int aY, int aZ, int sX, int sY, int sZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnPlantGrow) {
            ((IMultiTileEntity.IMTE_OnPlantGrow)aTileEntity).onPlantGrow(sX, sY, sZ);
        } else {
            super.onPlantGrow(aWorld, aX, aY, aZ, sX, sY, sZ);
        }
    }

    public final boolean isFertile(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsFertile && ((IMultiTileEntity.IMTE_IsFertile)aTileEntity).isFertile();
    }

    public final boolean rotateBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_RotateBlock && ((IMultiTileEntity.IMTE_RotateBlock)aTileEntity).rotateBlock(UT.Code.side(aSide));
    }

    public final ForgeDirection[] getValidRotations(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetValidRotations ? ((IMultiTileEntity.IMTE_GetValidRotations)aTileEntity).getValidRotations() : CS.ZL_FORGEDIRECTION;
    }

    public final float getEnchantPowerBonus(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetEnchantPowerBonus ? ((IMultiTileEntity.IMTE_GetEnchantPowerBonus)aTileEntity).getEnchantPowerBonus() : 0.0f;
    }

    public final boolean recolourBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide, int aColor) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_RecolourBlock && ((IMultiTileEntity.IMTE_RecolourBlock)aTileEntity).recolourBlock(UT.Code.side(aSide), (byte)aColor);
    }

    public final boolean shouldCheckWeakPower(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_ShouldCheckWeakPower ? ((IMultiTileEntity.IMTE_ShouldCheckWeakPower)aTileEntity).shouldCheckWeakPower(UT.Code.side(aSide)) : this.isNormalCube(aWorld, aX, aY, aZ);
    }

    public final boolean getWeakChanges(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetWeakChanges ? ((IMultiTileEntity.IMTE_GetWeakChanges)aTileEntity).getWeakChanges() : super.getWeakChanges(aWorld, aX, aY, aZ);
    }

    public final boolean addHitEffects(World aWorld, MovingObjectPosition aTarget, EffectRenderer aRenderer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aTarget.blockX, aTarget.blockY, aTarget.blockZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_AddHitEffects && ((IMultiTileEntity.IMTE_AddHitEffects)aTileEntity).addHitEffects(aWorld, aTarget, aRenderer);
    }

    public final boolean addDestroyEffects(World aWorld, int aX, int aY, int aZ, int aMetaData, EffectRenderer aRenderer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_AddDestroyEffects && ((IMultiTileEntity.IMTE_AddDestroyEffects)aTileEntity).addDestroyEffects(aMetaData, aRenderer);
    }

    public final boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX - CS.OFFX[aSide], aY - CS.OFFY[aSide], aZ - CS.OFFZ[aSide]);
        return aTileEntity instanceof IMultiTileEntity.IMTE_ShouldSideBeRendered ? ((IMultiTileEntity.IMTE_ShouldSideBeRendered)aTileEntity).shouldSideBeRendered(UT.Code.side(aSide)) : super.shouldSideBeRendered(aWorld, aX, aY, aZ, aSide);
    }

    public final void setBlockBoundsBasedOnState(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState) {
            ((IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState)aTileEntity).setBlockBoundsBasedOnState(this);
        } else if (aTileEntity == null) {
            this.setBlockBounds(-999.0f, -999.0f, -999.0f, -998.0f, -998.0f, -998.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public final AxisAlignedBB getSelectedBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity == null ? AxisAlignedBB.getBoundingBox((double)-999.0, (double)-999.0, (double)-999.0, (double)-998.0, (double)-998.0, (double)-998.0) : (aTileEntity instanceof IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool ? ((IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool)aTileEntity).getSelectedBoundingBoxFromPool() : AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)));
    }

    public final void randomDisplayTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_RandomDisplayTick) {
            ((IMultiTileEntity.IMTE_RandomDisplayTick)aTileEntity).randomDisplayTick(aRandom);
        } else {
            super.randomDisplayTick(aWorld, aX, aY, aZ, aRandom);
        }
    }

    public final void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        if (aWorld.isRemote) {
            return;
        }
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity != null) {
            CS.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnBlockExploded) {
            ((IMultiTileEntity.IMTE_OnBlockExploded)aTileEntity).onExploded(aExplosion);
        } else {
            aWorld.setBlockToAir(aX, aY, aZ);
        }
    }

    public final ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetPickBlock ? ((IMultiTileEntity.IMTE_GetPickBlock)aTileEntity).getPickBlock(aTarget) : null;
    }

    public final ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetPickBlock ? ((IMultiTileEntity.IMTE_GetPickBlock)aTileEntity).getPickBlock(aTarget) : null;
    }

    @Override
    public final ItemStack getItemStackFromBlock(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetStackFromBlock ? ((IMultiTileEntity.IMTE_GetStackFromBlock)aTileEntity).getStackFromBlock(aSide) : null;
    }

    public final int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetFlammability ? ((IMultiTileEntity.IMTE_GetFlammability)aTileEntity).getFlammability(UT.Code.side(aSide), this.getMaterial().getCanBurn()) : (this.getMaterial().getCanBurn() ? 150 : 0);
    }

    public final int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetFireSpreadSpeed ? ((IMultiTileEntity.IMTE_GetFireSpreadSpeed)aTileEntity).getFireSpreadSpeed(UT.Code.side(aSide), this.getMaterial().getCanBurn()) : (this.getMaterial().getCanBurn() ? 150 : 0);
    }

    public final boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsFireSource && ((IMultiTileEntity.IMTE_IsFireSource)aTileEntity).isFireSource(UT.Code.side(aSide));
    }

    public final boolean canEntityDestroy(IBlockAccess aWorld, int aX, int aY, int aZ, Entity aEntity) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return !(aTileEntity instanceof IMultiTileEntity.IMTE_CanEntityDestroy) || ((IMultiTileEntity.IMTE_CanEntityDestroy)aTileEntity).canEntityDestroy(aEntity);
    }

    @Override
    public final long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_OnToolClick ? ((IMultiTileEntity.IMTE_OnToolClick)aTileEntity).onToolClick(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ) : 0L;
    }

    @Override
    public final OreDictMaterialStack getMaterialAtSide(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetMaterialAtSide ? ((IMultiTileEntity.IMTE_GetMaterialAtSide)aTileEntity).getMaterialAtSide(aSide) : null;
    }

    @Override
    public final boolean removeMaterialFromSide(World aWorld, int aX, int aY, int aZ, byte aSide, OreDictMaterialStack aMaterial) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_RemoveMaterialFromSide && ((IMultiTileEntity.IMTE_RemoveMaterialFromSide)aTileEntity).removeMaterialFromSide(aSide, aMaterial);
    }

    public final void dropBlockAsItemWithChance(World aWorld, int aX, int aY, int aZ, int aMeta, float aChance, int aFortune) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_GetDrops) {
            ArrayListNoNulls<ItemStack> tList = ((IMultiTileEntity.IMTE_GetDrops)aTileEntity).getDrops(aFortune, false);
            aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)aMeta, (int)aFortune, (float)aChance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack tStack : tList) {
                if (!(CS.RNGSUS.nextFloat() <= aChance)) continue;
                this.dropBlockAsItem(aWorld, aX, aY, aZ, tStack);
            }
        }
    }

    public final void harvestBlock(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        if (aPlayer == null) {
            aPlayer = (EntityPlayer)this.harvesters.get();
        }
        aPlayer.addStat(StatList.mineBlockStatArray[MultiTileEntityBlock.getIdFromBlock((Block)this)], 1);
        UT.Entities.exhaust(aPlayer, 0.025f);
        boolean aSilkTouch = EnchantmentHelper.getSilkTouchModifier((EntityLivingBase)aPlayer);
        int aFortune = EnchantmentHelper.getFortuneModifier((EntityLivingBase)aPlayer);
        float aChance = 1.0f;
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_GetDrops) {
            ArrayListNoNulls<ItemStack> tList = ((IMultiTileEntity.IMTE_GetDrops)aTileEntity).getDrops(aFortune, aSilkTouch);
            aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)aMeta, (int)aFortune, (float)aChance, (boolean)aSilkTouch, (EntityPlayer)aPlayer);
            for (ItemStack tStack : tList) {
                if (!(CS.RNGSUS.nextFloat() <= aChance)) continue;
                this.dropBlockAsItem(aWorld, aX, aY, aZ, tStack);
            }
        }
    }

    public final ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aUnusableMetaData, int aFortune) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_GetDrops) {
            return ((IMultiTileEntity.IMTE_GetDrops)aTileEntity).getDrops(aFortune, false);
        }
        return ST.arraylist(new ItemStack[0]);
    }

    @Override
    public final ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, int aScanLevel) {
        TileEntity aTileEntity = aPlayer.worldObj.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetDebugInfo ? ((IMultiTileEntity.IMTE_GetDebugInfo)aTileEntity).getDebugInfo(aScanLevel) : null;
    }

    public final boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsSideSolid ? ((IMultiTileEntity.IMTE_IsSideSolid)aTileEntity).isSideSolid(UT.Code.side(aSide)) : this.mOpaque;
    }

    public final boolean isBeaconBase(IBlockAccess aWorld, int aX, int aY, int aZ, int aBeaconX, int aBeaconY, int aBeaconZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_IsBeaconBase && ((IMultiTileEntity.IMTE_IsBeaconBase)aTileEntity).isBeaconBase(aBeaconX, aBeaconY, aBeaconZ);
    }

    public final int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetLightOpacity ? ((IMultiTileEntity.IMTE_GetLightOpacity)aTileEntity).getLightOpacity() : (this.mOpaque ? 255 : 0);
    }

    public final boolean isOpaqueCube() {
        return this.mOpaque;
    }

    public final boolean func_149730_j() {
        return this.mOpaque;
    }

    public final boolean renderAsNormalBlock() {
        return this.mOpaque || this.mNormalCube;
    }

    public final boolean isNormalCube() {
        return this.mNormalCube;
    }

    public final boolean canProvidePower() {
        return !this.mNormalCube;
    }

    @Override
    public final Block getBlock() {
        return this;
    }

    public final String getUnlocalizedName() {
        return this.mNameInternal;
    }

    public final String getLocalizedName() {
        return StatCollector.translateToLocal((String)this.mNameInternal);
    }

    public final String getHarvestTool(int aMeta) {
        return this.mTool;
    }

    public final boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public final int getHarvestLevel(int aMeta) {
        return (int)UT.Code.bind_(this.mHarvestLevelMinimum, this.mHarvestLevelMaximum, this.mHarvestLevelOffset + aMeta);
    }

    public final boolean canHarvestBlock(EntityPlayer aPlayer, int aMeta) {
        return super.canHarvestBlock(aPlayer, aMeta);
    }

    public final boolean hasTileEntity(int aMeta) {
        return true;
    }

    public final boolean canSilkHarvest() {
        return false;
    }

    public final int getRenderBlockPass() {
        return ITexture.Util.MC_ALPHA_BLENDING ? 1 : 0;
    }

    public final TileEntity createNewTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public final TileEntity createTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public final void getSubBlocks(Item aItem, CreativeTabs aCreativeTab, List aList) {
    }

    @Override
    public final ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return null;
    }

    @Override
    public final boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public final int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 0;
    }

    @Override
    public final ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return null;
    }

    @Override
    public final boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public final int getRenderPasses(ItemStack aStack) {
        return 0;
    }

    @Override
    public final IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return null;
    }

    public final void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public final IIcon getIcon(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return Textures.BlockIcons.CFOAM_HARDENED.getIcon(0);
    }

    public final IIcon getIcon(int aSide, int aMetaData) {
        return Textures.BlockIcons.CFOAM_HARDENED.getIcon(0);
    }

    public final int getRenderType() {
        return RendererBlockTextured.INSTANCE == null ? super.getRenderType() : RendererBlockTextured.INSTANCE.mRenderID;
    }

    @Override
    public final IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IRenderedBlockObject ? (IRenderedBlockObject)tTileEntity : null;
    }

    public final boolean onBlockEventReceived(World aWorld, int aX, int aY, int aZ, int aID, int aData) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity == null || aTileEntity.receiveClientEvent(aID, aData);
    }

    public final float getPlayerRelativeBlockHardness(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness ? ((IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness)aTileEntity).getPlayerRelativeBlockHardness(aPlayer, super.getPlayerRelativeBlockHardness(aPlayer, aWorld, aX, aY, aZ)) : super.getPlayerRelativeBlockHardness(aPlayer, aWorld, aX, aY, aZ);
    }

    public final float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetBlockHardness ? ((IMultiTileEntity.IMTE_GetBlockHardness)aTileEntity).getBlockHardness() : 1.0f;
    }

    public final float getExplosionResistance(Entity aExploder, World aWorld, int aX, int aY, int aZ, double aExplosionX, double aExplosionY, double aExplosionZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity instanceof IMultiTileEntity.IMTE_GetExplosionResistance ? ((IMultiTileEntity.IMTE_GetExplosionResistance)aTileEntity).getExplosionResistance(aExploder, aExplosionX, aExplosionY, aExplosionZ) : 1.0f;
    }

    public final void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (!LOCK) {
            LOCK = true;
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
            }
            LOCK = false;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnNeighborChange) {
            ((IMultiTileEntity.IMTE_OnNeighborChange)aTileEntity).onNeighborChange(aWorld, aTileX, aTileY, aTileZ);
        }
    }

    public final void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (!LOCK) {
            LOCK = true;
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aX, aY, aZ);
            }
            LOCK = false;
        }
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnNeighborBlockChange) {
            ((IMultiTileEntity.IMTE_OnNeighborBlockChange)aTileEntity).onNeighborBlockChange(aWorld, aBlock);
        }
        if (aTileEntity == null) {
            aWorld.setBlockToAir(aX, aY, aZ);
        }
    }

    @Override
    public final boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return true;
    }

    @Override
    public final boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public final void receiveBlockError(IBlockAccess aWorld, int aX, int aY, int aZ, String aError) {
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof ITileEntity) {
            ((ITileEntity)tTileEntity).setError(aError);
            WD.update(aWorld, aX, aY, aZ);
            UT.Sounds.play(CS.SFX.GT_BEEP, 100, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public final void onWalkOver(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IMultiTileEntity.IMTE_OnWalkOver) {
            ((IMultiTileEntity.IMTE_OnWalkOver)aTileEntity).onWalkOver(aEntity);
        }
    }
}

