/*
 * Decompiled with CFR 0.152.
 */
package gregapi;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.gui.ContainerClient;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEI_RecipeMap
extends TemplateRecipeHandler {
    protected final Recipe.RecipeMap mRecipeMap;
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;

    public NEI_RecipeMap(Recipe.RecipeMap aRecipeMap) {
        this.mRecipeMap = aRecipeMap;
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public NEI_RecipeMap init() {
        if (CS.NEI_NH) {
            API.registerRecipeHandler((ICraftingHandler)this);
            API.registerUsageHandler((IUsageHandler)this);
            NBTTagCompound tNBT = UT.NBT.make();
            tNBT.setString("modId", MD.GT.mID);
            tNBT.setString("modName", MD.GT.mName);
            tNBT.setString("handler", this.mRecipeMap.mNameNEI);
            tNBT.setString("itemName", ST.regMeta(this.mRecipeMap.mRecipeMachineList.isEmpty() ? ST.make(Blocks.lit_furnace, 1L, 0L) : this.mRecipeMap.mRecipeMachineList.get(0)));
            tNBT.setInteger("handlerHeight", 135);
            tNBT.setInteger("handlerWidth", 166);
            tNBT.setInteger("maxRecipesPerPage", 2);
            tNBT.setInteger("yShift", 6);
            tNBT.setBoolean("modRequired", true);
            FMLInterModComms.sendMessage((String)"NotEnoughItems", (String)"registerHandlerInfo", (NBTTagCompound)tNBT);
        } else {
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
        FMLInterModComms.sendRuntimeMessage((Object)CS.GAPI, (String)"NEIPlugins", (String)"register-crafting-handler", (String)(MD.GAPI.mID + "@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
        return this;
    }

    public TemplateRecipeHandler newInstance() {
        return new NEI_RecipeMap(this.mRecipeMap);
    }

    public void sortRecipes() {
        if (this.arecipes.size() > 1000) {
            return;
        }
        Collections.sort(this.arecipes, new Comparator<TemplateRecipeHandler.CachedRecipe>(){

            @Override
            public int compare(TemplateRecipeHandler.CachedRecipe aRecipe1, TemplateRecipeHandler.CachedRecipe aRecipe2) {
                Recipe tRecipe1 = ((CachedDefaultRecipe)aRecipe1).mRecipe;
                Recipe tRecipe2 = ((CachedDefaultRecipe)aRecipe2).mRecipe;
                int tCompare = Long.compare(tRecipe1.mEUt, tRecipe2.mEUt);
                if (tCompare != 0) {
                    return tCompare;
                }
                tCompare = Integer.compare(tRecipe1.mFluidInputs.length, tRecipe2.mFluidInputs.length);
                if (tCompare != 0) {
                    return tCompare;
                }
                if (tRecipe1.mFluidInputs.length > 0 && (tCompare = FL.regName(tRecipe1.mFluidInputs[0]).compareTo(FL.regName(tRecipe2.mFluidInputs[0]))) != 0) {
                    return tCompare;
                }
                tCompare = Integer.compare(tRecipe1.mInputs.length, tRecipe2.mInputs.length);
                if (tCompare != 0) {
                    return tCompare;
                }
                if (tRecipe1.mInputs.length > 0) {
                    ItemStack tInput1 = tRecipe1.mInputs[0];
                    ItemStack tInput2 = tRecipe2.mInputs[0];
                    if (ST.valid(tInput1)) {
                        if (ST.invalid(tInput2)) {
                            return -1;
                        }
                        OreDictItemData tData1 = OM.anydata_(tInput1);
                        OreDictItemData tData2 = OM.anydata_(tInput2);
                        if (tData1 != null && tData1.validMaterial()) {
                            if (tData2 == null || !tData2.validMaterial()) {
                                return -1;
                            }
                            tCompare = tData1.mMaterial.mMaterial.mNameInternal.compareTo(tData2.mMaterial.mMaterial.mNameInternal);
                            if (tCompare != 0) {
                                return tCompare;
                            }
                            tCompare = Long.compare(tData1.mMaterial.mAmount, tData2.mMaterial.mAmount);
                            if (tCompare != 0) {
                                return tCompare;
                            }
                        } else if (tData2 != null && tData2.validMaterial()) {
                            return 1;
                        }
                        if ((tCompare = Long.compare(tRecipe1.mDuration, tRecipe2.mDuration)) != 0) {
                            return tCompare;
                        }
                        tCompare = ST.regName(tInput1).compareTo(ST.regName(tInput2));
                        if (tCompare != 0) {
                            return tCompare;
                        }
                        return Short.compare(ST.meta_(tInput1), ST.meta_(tInput2));
                    }
                    if (ST.valid(tInput2)) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    public void loadCraftingRecipes(String aID, Object ... aResults) {
        if (!CS.CODE_CLIENT) {
            return;
        }
        if (aID.equals(this.getOverlayIdentifier())) {
            for (Recipe tRecipe : this.mRecipeMap.getNEIAllRecipes()) {
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
            this.sortRecipes();
        } else {
            super.loadCraftingRecipes(aID, aResults);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        if (!CS.CODE_CLIENT) {
            return;
        }
        if (ST.invalid(aResult)) {
            return;
        }
        try {
            FluidStack tFluid;
            OreDictItemData tPrefixMaterial = OM.association_(aResult);
            ArrayListNoNulls<ItemStack> tResults = ST.arraylist(aResult, OM.get_(aResult));
            ArrayList tRedirects = CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aResult));
            if (tRedirects != null) {
                ((ArrayList)tResults).addAll(tRedirects);
            }
            if ((tRedirects = (ArrayList)CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aResult, 32767L))) != null) {
                ((ArrayList)tResults).addAll(tRedirects);
            }
            if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed) {
                if (tPrefixMaterial.mMaterial.mMaterial.mID > 0 && CS.BlocksGT.ore != null && CS.BlocksGT.oreBroken != null && tPrefixMaterial.mPrefix.containsAny(TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_BASED)) {
                    ((ArrayList)tResults).add(ST.make((Block)CS.BlocksGT.ore, 1L, (long)tPrefixMaterial.mMaterial.mMaterial.mID));
                    ((ArrayList)tResults).add(ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)tPrefixMaterial.mMaterial.mMaterial.mID));
                }
                for (OreDictPrefix tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                    ((ArrayList)tResults).add(tPrefix.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                }
                if (tPrefixMaterial.mPrefix.containsAny(TD.Prefix.DUST_BASED) && tPrefixMaterial.mMaterial.mMaterial.mTargetPulver.mMaterial == tPrefixMaterial.mMaterial.mMaterial) {
                    ((ArrayList)tResults).add(OP.crushed.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                    ((ArrayList)tResults).add(OP.crushedTiny.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                    ((ArrayList)tResults).add(OP.crushedPurified.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                    ((ArrayList)tResults).add(OP.crushedPurifiedTiny.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                    ((ArrayList)tResults).add(OP.crushedCentrifuged.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                    ((ArrayList)tResults).add(OP.crushedCentrifugedTiny.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                }
            }
            if (!CS.ItemsGT.NEI_DONT_SHOW_FLUIDS.contains(aResult, true) && (tFluid = FL.getFluid(aResult, true)) != null) {
                ((ArrayList)tResults).add(FL.display(tFluid, false, false));
                for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!tData.fluid.isFluidEqual(tFluid)) continue;
                    ((ArrayList)tResults).add(ST.copy(tData.filledContainer));
                }
            }
            ArrayListNoNulls<Recipe> tRecipes = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeMap.getNEIRecipes(tResults.toArray(CS.ZL_IS))) {
                if (tRecipes.contains(tRecipe)) continue;
                ((ArrayList)tRecipes).add(tRecipe);
            }
            for (Recipe tRecipe : tRecipes) {
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
            this.sortRecipes();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        if (!CS.CODE_CLIENT) {
            return;
        }
        if (ST.invalid(aInput)) {
            return;
        }
        try {
            FluidStack tFluid;
            OreDictItemData tPrefixMaterial = OM.association_(aInput);
            ArrayListNoNulls<ItemStack> tInputs = ST.arraylist(aInput, OreDictManager.INSTANCE.getStack_(false, aInput));
            ArrayList tRedirects = CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aInput));
            if (tRedirects != null) {
                ((ArrayList)tInputs).addAll(tRedirects);
            }
            if ((tRedirects = (ArrayList)CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aInput, 32767L))) != null) {
                ((ArrayList)tInputs).addAll(tRedirects);
            }
            if (tPrefixMaterial != null) {
                for (OreDictPrefix tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                    ((ArrayList)tInputs).add(tPrefix.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
                }
            }
            if (!CS.ItemsGT.NEI_DONT_SHOW_FLUIDS.contains(aInput, true) && (tFluid = FL.getFluid(aInput, true)) != null) {
                ((ArrayList)tInputs).add(FL.display(tFluid, false, false));
                for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!tData.fluid.isFluidEqual(tFluid)) continue;
                    ((ArrayList)tInputs).add(ST.copy(tData.filledContainer));
                }
            }
            ArrayListNoNulls<Recipe> tRecipes = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeMap.getNEIUsages(tInputs.toArray(CS.ZL_IS))) {
                if (tRecipes.contains(tRecipe)) continue;
                ((ArrayList)tRecipes).add(tRecipe);
            }
            for (Recipe tRecipe : tRecipes) {
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
            this.sortRecipes();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNameNEI;
    }

    public String getHandlerId() {
        return this.mRecipeMap.mNameNEI;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)(CS.RES_PATH_GUI + "machines/NEI.png"));
        GuiDraw.drawTexturedModalRect((int)-5, (int)-16, (int)0, (int)0, (int)176, (int)166);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)-8, (int)0, (int)3, (int)176, (int)79);
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.getMinecraft().fontRenderer.drawString(aString, aX, aY, aColor);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return LanguageHandler.translate(this.mRecipeMap.mNameInternal, this.mRecipeMap.mNameInternal);
    }

    public String getGuiTexture() {
        return UT.Code.stringValid(this.mRecipeMap.mGUIPath) ? this.mRecipeMap.mGUIPath : CS.RES_PATH_GUI + this.mRecipeMap.mNameInternal + ".png";
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        if (!CS.CODE_CLIENT) {
            return currenttip;
        }
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == ((FixedPositionedStack)tStack).mMaxChance) break;
                long tChance = UT.Code.units(((FixedPositionedStack)tStack).mChance, ((FixedPositionedStack)tStack).mMaxChance, 10000L, false);
                currenttip.add(1, LH.Chat.BLINKING_CYAN + "Chance: " + tChance / 100L + "." + (tChance % 100L < 10L ? "0" + tChance % 100L : Long.valueOf(tChance % 100L)) + "%" + (tStack.item.stackSize > 1 ? " each" : ""));
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (IL.Display_Fluid.equal(tStack.item, true, true) || tStack.item.stackSize != 0) break;
                currenttip.add(1, LH.Chat.BLINKING_CYAN + "Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        long tGUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
        long tDuration = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
        if (tGUt == 0L) {
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                NEI_RecipeMap.drawText(10, 93, "Tier: unspecified", -16777216);
            }
        } else if (tGUt > 0L) {
            NEI_RecipeMap.drawText(10, 73, "Costs: " + UT.Code.makeString(tGUt * tDuration) + " GU", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                if (!this.mRecipeMap.mCombinePower) {
                    NEI_RecipeMap.drawText(10, 83, "Usage: " + UT.Code.makeString(tGUt) + " GU/t", -16777216);
                }
                NEI_RecipeMap.drawText(10, 93, "Tier: " + UT.Code.makeString(tGUt / this.mRecipeMap.mPower) + " GU", -16777216);
                NEI_RecipeMap.drawText(10, 103, "Power: " + UT.Code.makeString(this.mRecipeMap.mPower), -16777216);
            } else if (tGUt != 1L && !this.mRecipeMap.mCombinePower) {
                NEI_RecipeMap.drawText(10, 83, "Usage: " + UT.Code.makeString(tGUt) + " GU/t", -16777216);
            }
        } else {
            NEI_RecipeMap.drawText(10, 73, "Gain: " + UT.Code.makeString((tGUt *= -1L) * tDuration) + " GU", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                if (!this.mRecipeMap.mCombinePower) {
                    NEI_RecipeMap.drawText(10, 83, "Output: " + UT.Code.makeString(tGUt) + " GU/t", -16777216);
                }
                NEI_RecipeMap.drawText(10, 93, "Tier: " + UT.Code.makeString(tGUt / this.mRecipeMap.mPower) + " GU", -16777216);
                NEI_RecipeMap.drawText(10, 103, "Power: " + UT.Code.makeString(this.mRecipeMap.mPower), -16777216);
            } else if (tGUt != 1L && !this.mRecipeMap.mCombinePower) {
                NEI_RecipeMap.drawText(10, 83, "Output: " + UT.Code.makeString(tGUt) + " GU/t", -16777216);
            }
        }
        if (tDuration > 0L) {
            NEI_RecipeMap.drawText(10, 113, "Time: " + (tDuration < 1200L ? UT.Code.makeString(tDuration) + " ticks" : (tDuration < 36000L ? UT.Code.makeString(tDuration / 20L) + " secs" : UT.Code.makeString(tDuration / 1200L) + " mins")), -16777216);
        }
        if (UT.Code.stringValid(this.mRecipeMap.mNEISpecialValuePre) || UT.Code.stringValid(this.mRecipeMap.mNEISpecialValuePost)) {
            NEI_RecipeMap.drawText(10, 123, this.mRecipeMap.mNEISpecialValuePre + UT.Code.makeString(((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue * this.mRecipeMap.mNEISpecialValueMultiplier) + this.mRecipeMap.mNEISpecialValuePost, -16777216);
        }
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            if (this.canHandle(gui)) {
                if (button == 0) {
                    return this.transferRect(gui, false);
                }
                if (button == 1) {
                    return this.transferRect(gui, true);
                }
            }
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof ContainerClient && UT.Code.stringValid(((ContainerClient)gui).mNEI);
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            if (this.canHandle(gui) && currenttip.isEmpty() && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((ContainerClient)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((ContainerClient)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]))) {
                currenttip.add("Recipes");
            }
            return currenttip;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            return this.canHandle(gui) && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((ContainerClient)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((ContainerClient)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((ContainerClient)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((ContainerClient)gui).mNEI, (Object[])new Object[0]));
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEI_RecipeMap.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }

        public CachedDefaultRecipe(Recipe aRecipe) {
            int i;
            super((TemplateRecipeHandler)NEI_RecipeMap.this);
            this.mOutputs = new ArrayListNoNulls<PositionedStack>();
            this.mInputs = new ArrayListNoNulls<PositionedStack>();
            this.mRecipe = aRecipe;
            int tStartIndex = 0;
            switch (NEI_RecipeMap.this.mRecipeMap.mInputItemsCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 9: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 10: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                    break;
                }
                case 11: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 80, 43));
            }
            if (!NEI_RecipeMap.this.mRecipeMap.mRecipeMachineList.isEmpty()) {
                this.mInputs.add(new FixedPositionedStack(NEI_RecipeMap.this.mRecipeMap.mRecipeMachineList, 152, 83));
            }
            tStartIndex = 0;
            switch (NEI_RecipeMap.this.mRecipeMap.mOutputItemsCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 9: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 10: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 11: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                }
            }
            for (i = 0; i < aRecipe.mFluidInputs.length && i < NEI_RecipeMap.this.mRecipeMap.mInputFluidCount; ++i) {
                if (aRecipe.mFluidInputs[i] == null || aRecipe.mFluidInputs[i].getFluid() == null) continue;
                this.mInputs.add(new FixedPositionedStack(FL.display(aRecipe.mFluidInputs[i], true, false, NEI_RecipeMap.this.mRecipeMap.mUseBucketSizeIn), 53 - i % 3 * 18, 63 - i / 3 * 18));
            }
            for (i = 0; i < aRecipe.mFluidOutputs.length && i < NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount; ++i) {
                if (aRecipe.mFluidOutputs[i] == null || aRecipe.mFluidOutputs[i].getFluid() == null) continue;
                this.mOutputs.add(new FixedPositionedStack(FL.display(aRecipe.mFluidOutputs[i], true, false, NEI_RecipeMap.this.mRecipeMap.mUseBucketSizeOut), 107 + i % 3 * 18, 63 - i / 3 * 18));
            }
        }
    }

    public class FixedPositionedStack
    extends PositionedStack {
        public boolean permutated;
        public final int mChance;
        public final int mMaxChance;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance, int aMaxChance) {
            super(object, x - 5, y - 11, true);
            this.permutated = false;
            this.mMaxChance = aMaxChance;
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayListNoNulls<ItemStack> tDisplayStacks = ST.arraylist(new ItemStack[0]);
            for (ItemStack tStack : this.items) {
                if (!ST.valid(tStack)) continue;
                if (ST.meta_(tStack) == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.getItem());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            ((ArrayList)tDisplayStacks).add(ST.amount(tStack.stackSize, stack));
                        }
                        continue;
                    }
                    ItemStack base = ST.make(tStack.getItem(), (long)tStack.stackSize, 0L);
                    base.stackTagCompound = tStack.stackTagCompound;
                    ((ArrayList)tDisplayStacks).add(base);
                    continue;
                }
                ((ArrayList)tDisplayStacks).add(ST.copy(tStack));
            }
            this.items = tDisplayStacks.toArray(CS.ZL_IS);
            if (this.items.length == 0) {
                this.items = ST.array(ST.make((Block)Blocks.fire, 1L, 0L));
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }
}

