/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.ITileEntityTapFillable;
import gregapi.tileentity.base.TileEntityBase11AttachmentSmall;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.food.MultiTileEntitySandwich;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import openblocks.common.LiquidXpUtils;
import openmods.utils.EnchantmentUtils;

public class MultiTileEntityFluidTap
extends TileEntityBase11AttachmentSmall {
    public boolean mAcidProof = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.liquid"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            FluidStack aFluid;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityTapAccessible && !FL.gas(aFluid = ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, Integer.MAX_VALUE, false), true) && aFluid.amount > 0 && (this.mAcidProof || !FL.acid(aFluid))) {
                ItemStack aStack = aPlayer.func_71045_bC();
                if (aStack == null) {
                    DelegatorTileEntity<TileEntity> tDelegator2 = this.getAdjacentTileEntity((byte)0);
                    if (tDelegator2.mTileEntity == null) {
                        if (tDelegator2.getBlock() instanceof BlockCauldron) {
                            byte tMeta = tDelegator2.getMetaData();
                            if (tMeta < 3 && FL.water(aFluid) && aFluid.amount >= 334) {
                                if (aFluid.amount >= 1000 && tMeta <= 0) {
                                    ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, 1000, true);
                                    tDelegator2.setMetaData((byte)(tMeta + 3));
                                } else if (aFluid.amount >= 667 && tMeta <= 1) {
                                    ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, 667, true);
                                    tDelegator2.setMetaData((byte)(tMeta + 2));
                                } else if (tMeta <= 2) {
                                    ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, 334, true);
                                    tDelegator2.setMetaData((byte)(tMeta + 1));
                                }
                                UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 2.0f, this, false);
                                UT.Sounds.send("liquid.water", this, false);
                            }
                            return true;
                        }
                    } else {
                        if (tDelegator2.mTileEntity instanceof ITileEntityTapFillable) {
                            OreDictMaterialStack tMaterial = OreDictMaterial.FLUID_MAP.get(aFluid.getFluid().getName());
                            aFluid = aFluid.copy();
                            aFluid.amount = Math.min(aFluid.amount, FL.lava(aFluid) ? 1000 : (!FL.water(aFluid) && tMaterial != null && tMaterial.mAmount > 0L ? UT.Code.bindInt(tMaterial.mAmount) : 250));
                            if (FL.nonzero(((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, UT.Code.bindInt(((ITileEntityTapFillable)tDelegator2.mTileEntity).tapFill(tDelegator2.mSideOfTileEntity, aFluid, true)), true))) {
                                UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 2.0f, this, false);
                                UT.Sounds.send("liquid.water", this, false);
                            }
                            return true;
                        }
                        if (tDelegator2.mTileEntity instanceof MultiTileEntitySandwich) {
                            FluidStack tFluid;
                            ItemStack tStack = FL.fill(aFluid, IL.Bottle_Empty.get(1L, new Object[0]), false, false);
                            if (ST.valid(tStack) && (tFluid = FL.mul(FL.getFluid(tStack, true), ((MultiTileEntitySandwich)tDelegator2.mTileEntity).getIngredientCount(), 4L, true)) != null && tFluid.amount <= aFluid.amount && ((MultiTileEntitySandwich)tDelegator2.mTileEntity).addIngredient(tStack) > 0) {
                                ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tFluid.amount, true);
                                UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 2.0f, this, false);
                                return true;
                            }
                            return true;
                        }
                    }
                    if (FL.XP.is(aFluid)) {
                        if (MD.OB.mLoaded) {
                            try {
                                int tXP = Math.min(LiquidXpUtils.liquidToXpRatio((int)aFluid.amount), Math.max(10, UT.Code.roundUp((float)EnchantmentUtils.getExperienceForLevel((int)(aPlayer.field_71068_ca + 1)) - ((float)EnchantmentUtils.getExperienceForLevel((int)aPlayer.field_71068_ca) + aPlayer.field_71106_cc * (float)aPlayer.func_71050_bK()))));
                                int tDrain = LiquidXpUtils.xpToLiquidRatio((int)tXP);
                                if (tDrain > 0 && tXP > 0) {
                                    ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tDrain, true);
                                    this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace(CS.ERR);
                            }
                            return true;
                        }
                        int tXP = Math.min(50, aFluid.amount / 20);
                        if (tXP > 0) {
                            ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tXP * 20, true);
                            this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                        }
                        return true;
                    }
                    if (FL.Mob.is(aFluid)) {
                        int tXP = Math.min(50, aFluid.amount * 3 / 200);
                        if (tXP > 0) {
                            ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, tXP * 200 / 3, true);
                            this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.2, (double)this.field_145849_e + 0.5, tXP));
                        }
                        return true;
                    }
                    return true;
                }
                FluidStack tNewFluid = aFluid.copy();
                ItemStack tStack = FL.fill(tNewFluid, ST.amount(1L, aStack), true, true, true, true);
                if (aFluid.amount > tNewFluid.amount && ((ITileEntityTapAccessible)tDelegator.mTileEntity).tapDrain(tDelegator.mSideOfTileEntity, aFluid.amount - tNewFluid.amount, true) != null) {
                    UT.Sounds.send(CS.SFX.IC_SPRAY, 1.0f, 2.0f, this, false);
                    --aStack.field_77994_a;
                    ST.give((Entity)aPlayer, tStack, true);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[6], CS.PX_P[2], CS.PX_N[6], CS.PX_N[9], CS.PX_N[12]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[6], CS.PX_P[12], CS.PX_N[6], CS.PX_N[9], CS.PX_N[2]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[2], CS.PX_P[6], CS.PX_P[6], CS.PX_N[12], CS.PX_N[9], CS.PX_N[6]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[12], CS.PX_P[6], CS.PX_P[6], CS.PX_N[2], CS.PX_N[9], CS.PX_N[6]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[0], CS.PX_N[7], CS.PX_N[10], CS.PX_N[12]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[12], CS.PX_N[7], CS.PX_N[10], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[4], CS.PX_P[7], CS.PX_N[12], CS.PX_N[10], CS.PX_N[7]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[12], CS.PX_P[4], CS.PX_P[7], CS.PX_N[0], CS.PX_N[10], CS.PX_N[7]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[3], CS.PX_P[4], CS.PX_N[7], CS.PX_N[10], CS.PX_N[10]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[3], CS.PX_P[10], CS.PX_N[7], CS.PX_N[10], CS.PX_N[4]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[4], CS.PX_P[3], CS.PX_P[7], CS.PX_N[10], CS.PX_N[10], CS.PX_N[7]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[10], CS.PX_P[3], CS.PX_P[7], CS.PX_N[4], CS.PX_N[10], CS.PX_N[7]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 1 && (aSide == this.mFacing ? !aShouldSideBeRendered[aSide] : aSide == CS.OPOS[this.mFacing]) ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
            }
            default: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
            }
            case 5: 
        }
        return this.box(CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
                break;
            }
            default: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
                break;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
            }
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tap";
    }
}

