/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.GT_API_Proxy;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.TagData;
import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentLogistics;
import gregapi.cover.covers.CoverLogisticsDisplayCPUControl;
import gregapi.cover.covers.CoverLogisticsDisplayCPUConversion;
import gregapi.cover.covers.CoverLogisticsDisplayCPULogic;
import gregapi.cover.covers.CoverLogisticsDisplayCPUStorage;
import gregapi.cover.covers.CoverLogisticsFluidExport;
import gregapi.cover.covers.CoverLogisticsFluidImport;
import gregapi.cover.covers.CoverLogisticsFluidStorage;
import gregapi.cover.covers.CoverLogisticsGenericDump;
import gregapi.cover.covers.CoverLogisticsGenericExport;
import gregapi.cover.covers.CoverLogisticsGenericImport;
import gregapi.cover.covers.CoverLogisticsGenericStorage;
import gregapi.cover.covers.CoverLogisticsItemExport;
import gregapi.cover.covers.CoverLogisticsItemImport;
import gregapi.cover.covers.CoverLogisticsItemStorage;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.tileentity.ITileEntityServerTickPre;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.logistics.ITileEntityLogistics;
import gregapi.tileentity.logistics.ITileEntityLogisticsSemiFilteredItem;
import gregapi.tileentity.logistics.ITileEntityLogisticsStorage;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityLogisticsCore
extends TileEntityBase10MultiBlockBase
implements ITileEntityEnergy,
ITileEntityLogistics,
ITileEntityServerTickPre,
ITileEntityEnergyDataCapacitor,
IMultiBlockEnergy,
IMultiBlockFluidHandler,
IFluidHandler {
    public static final int MAX_STORAGE_CPU_COUNT = 108;
    public long mEnergy = 0L;
    public TagData mEnergyTypeAccepted = TD.Energy.EU;
    public int mCPU_Logic = 0;
    public int mCPU_Control = 0;
    public int mCPU_Storage = 0;
    public int mCPU_Conversion = 0;
    public int oCPU_Logic = 0;
    public int oCPU_Control = 0;
    public int oCPU_Storage = 0;
    public int oCPU_Conversion = 0;
    public FluidTankGT[] mTanks = new FluidTankGT[108];
    private boolean mHasToAddTimer = true;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        this.mCPU_Logic = aNBT.func_74762_e("gt.cpu.logic");
        this.mCPU_Control = aNBT.func_74762_e("gt.cpu.control");
        this.mCPU_Storage = aNBT.func_74762_e("gt.cpu.storage");
        this.mCPU_Conversion = aNBT.func_74762_e("gt.cpu.conversion");
        this.oCPU_Logic = aNBT.func_74762_e("gt.cpu.logic.used");
        this.oCPU_Control = aNBT.func_74762_e("gt.cpu.control.used");
        this.oCPU_Storage = aNBT.func_74762_e("gt.cpu.storage.used");
        this.oCPU_Conversion = aNBT.func_74762_e("gt.cpu.conversion.used");
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i] = new FluidTankGT(16000L).readFromNBT(aNBT, "gt.tank." + i);
        }
        if (this.field_145850_b != null && this.isServerSide() && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PRE.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.cpu.logic", this.mCPU_Logic);
        UT.NBT.setNumber(aNBT, "gt.cpu.control", this.mCPU_Control);
        UT.NBT.setNumber(aNBT, "gt.cpu.storage", this.mCPU_Storage);
        UT.NBT.setNumber(aNBT, "gt.cpu.conversion", this.mCPU_Conversion);
        UT.NBT.setNumber(aNBT, "gt.cpu.logic.used", this.oCPU_Logic);
        UT.NBT.setNumber(aNBT, "gt.cpu.control.used", this.oCPU_Control);
        UT.NBT.setNumber(aNBT, "gt.cpu.storage.used", this.oCPU_Storage);
        UT.NBT.setNumber(aNBT, "gt.cpu.conversion.used", this.oCPU_Conversion);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing, 2);
        if (this.field_145850_b.func_72899_e(tX - 2, tY = this.getOffsetYN(this.mFacing, 2), (tZ = this.getOffsetZN(this.mFacing, 2)) - 2) && this.field_145850_b.func_72899_e(tX + 2, tY, tZ - 2) && this.field_145850_b.func_72899_e(tX - 2, tY, tZ + 2) && this.field_145850_b.func_72899_e(tX + 2, tY, tZ + 2)) {
            boolean tSuccess = true;
            this.mCPU_Logic = 0;
            this.mCPU_Control = 0;
            this.mCPU_Storage = 0;
            this.mCPU_Conversion = 0;
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    for (int k = -2; k <= 2; ++k) {
                        if (i * i + j * j + k * k < 4) {
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18200, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                                ++this.mCPU_Logic;
                                ++this.mCPU_Control;
                                ++this.mCPU_Storage;
                                ++this.mCPU_Conversion;
                                continue;
                            }
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18201, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                                this.mCPU_Logic += 4;
                                continue;
                            }
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18202, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                                this.mCPU_Control += 4;
                                continue;
                            }
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18203, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                                this.mCPU_Storage += 4;
                                continue;
                            }
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18204, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                                this.mCPU_Conversion += 4;
                                continue;
                            }
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18008, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) continue;
                            tSuccess = false;
                            continue;
                        }
                        if (i * i + j * j + k * k > 6) {
                            if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18008, this.getMultiTileEntityRegistryID(), 0, -67, aCoordinates, aPlayer, aInventory)) continue;
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18299, this.getMultiTileEntityRegistryID(), 0, -65, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            if (this.mCPU_Storage > 108) {
                this.mCPU_Storage = 108;
            }
            return tSuccess && this.mCPU_Logic > 0 && this.mCPU_Control > 0 && this.mCPU_Storage > 0 && this.mCPU_Conversion > 0;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.logisticscore.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.logisticscore.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.logisticscore.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.logisticscore.4"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.5"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.6"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.7"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.8"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.9"));
        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.multiblock.logisticscore.10"));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + "256 to 1024 " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing, 2);
        int tY = this.getOffsetYN(this.mFacing, 2);
        int tZ = this.getOffsetZN(this.mFacing, 2);
        return aX >= tX - 2 && aY >= tY - 2 && aZ >= tZ - 2 && aX <= tX + 2 && aY <= tY + 2 && aZ <= tZ + 2;
    }

    @Override
    public void onUnregisterPre() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_PRE.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_PRE.remove(this);
        this.onUnregisterPre();
    }

    @Override
    public void onServerTickPre(boolean aFirst) {
        if (CS.SYNC_SECOND) {
            int tCPU_Logic = this.oCPU_Logic;
            int tCPU_Control = this.oCPU_Control;
            int tCPU_Storage = this.oCPU_Storage;
            int tCPU_Conversion = this.oCPU_Conversion;
            this.oCPU_Logic = 0;
            this.oCPU_Control = 0;
            this.oCPU_Storage = 0;
            this.oCPU_Conversion = 0;
            if (this.checkStructure(false) && this.mEnergy >= 128L + (long)this.mCPU_Logic * 64L * (long)this.mCPU_Conversion) {
                int tX = this.getOffsetXN(this.mFacing, 2);
                int tY = this.getOffsetYN(this.mFacing, 2);
                int tZ = this.getOffsetZN(this.mFacing, 2);
                ItemStackSet<ItemStackContainer> tFilteredFor = ST.hashset(new ItemStack[0]);
                ArrayListNoNulls<LogisticsData> tStackImportsGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackImportsSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackImportsFiltered = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackExportsGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackExportsSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackExportsFiltered = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackStorageGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackStorageSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackStorageFiltered = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tStackDumps = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidImportsGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidImportsSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidImportsFiltered = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidExportsGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidExportsSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidExportsFiltered = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidStorageGeneric = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidStorageSemi = new ArrayListNoNulls<LogisticsData>();
                ArrayListNoNulls<LogisticsData> tFluidStorageFiltered = new ArrayListNoNulls<LogisticsData>();
                List[][] tExports1 = new List[][]{{tFluidExportsFiltered, tStackExportsFiltered}, {tFluidExportsSemi, tStackExportsSemi}, {tFluidExportsGeneric, tStackExportsGeneric}, {tFluidStorageFiltered, tStackStorageFiltered}, {tFluidStorageSemi, tStackStorageSemi}, {tFluidStorageGeneric, tStackStorageGeneric}};
                List[][] tExports2 = new List[][]{{tFluidExportsFiltered, tStackExportsFiltered}, {tFluidExportsSemi, tStackExportsSemi}, {tFluidExportsGeneric, tStackExportsGeneric}};
                List[][] tImports1 = new List[][]{{tFluidImportsGeneric, tStackImportsGeneric}, {tFluidImportsSemi, tStackImportsSemi}, {tFluidImportsFiltered, tStackImportsFiltered}};
                List[][] tImports2 = new List[][]{{tFluidStorageGeneric, tStackStorageGeneric}, {tFluidStorageSemi, tStackStorageSemi}, {tFluidStorageFiltered, tStackStorageFiltered}};
                HashSetNoNulls<ITileEntityLogistics> tScanning = new HashSetNoNulls<ITileEntityLogistics>();
                HashSetNoNulls<ITileEntityLogistics> tScanningNext = new HashSetNoNulls<ITileEntityLogistics>();
                HashSetNoNulls<Object> tScanned = new HashSetNoNulls<Object>();
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        for (int k = -2; k <= 2; ++k) {
                            TileEntity tTileEntity = WD.te(this.field_145850_b, tX + i, tY + j, tZ + k, true);
                            if (!tScanned.add(tTileEntity) || !(tTileEntity instanceof ITileEntityLogistics)) continue;
                            tScanning.add((ITileEntityLogistics)tTileEntity);
                        }
                    }
                }
                while (!tScanning.isEmpty()) {
                    for (ITileEntityLogistics tLogistics : tScanning) {
                        CoverData tCovers;
                        if (tLogistics instanceof ITileEntityLogisticsStorage) {
                            tFilteredFor.add(((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterItem());
                            if (tLogistics instanceof ITileEntityLogisticsSemiFilteredItem) {
                                tFilteredFor.addAll((Collection<ItemStackContainer>)((ITileEntityLogisticsSemiFilteredItem)((Object)tLogistics)).getLogisticsFilter((byte)6));
                            }
                            switch (((ITileEntityLogisticsStorage)tLogistics).getLogisticsPriorityFluid()) {
                                case 1: {
                                    tFluidStorageGeneric.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterFluid()));
                                    break;
                                }
                                case 2: {
                                    tFluidStorageSemi.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterFluid()));
                                    break;
                                }
                                case 3: {
                                    tFluidStorageFiltered.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterFluid()));
                                }
                            }
                            switch (((ITileEntityLogisticsStorage)tLogistics).getLogisticsPriorityItem()) {
                                case 1: {
                                    tStackStorageGeneric.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterItem()));
                                    break;
                                }
                                case 2: {
                                    tStackStorageSemi.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterItem()));
                                    break;
                                }
                                case 3: {
                                    tStackStorageFiltered.add(new LogisticsData(new DelegatorTileEntity<TileEntity>((TileEntity)tLogistics, 6), ((ITileEntityLogisticsStorage)tLogistics).getLogisticsFilterItem()));
                                }
                            }
                        }
                        if ((tCovers = tLogistics.getCoverData()) != null && !tCovers.mStopped) {
                            block51: for (byte tSide : CS.ALL_SIDES_VALID) {
                                ItemStack tStack;
                                FluidStack tFluid;
                                if (!(tCovers.mBehaviours[tSide] instanceof AbstractCoverAttachmentLogistics)) continue;
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsDisplayCPULogic.INSTANCE) {
                                    tCovers.value(tSide, (short)(tCPU_Logic <= 0 ? 0 : (tCPU_Logic >= this.mCPU_Logic ? 15 : 14 - (int)Math.max(0L, Math.min(13L, (long)(this.mCPU_Logic - tCPU_Logic) * 14L / (long)this.mCPU_Logic)))), true);
                                    tCovers.visual(tSide, (short)(tCPU_Logic <= 0 ? 0 : (tCPU_Logic >= this.mCPU_Logic ? 10 : 9 - (int)Math.max(0L, Math.min(8L, (long)(this.mCPU_Logic - tCPU_Logic) * 9L / (long)this.mCPU_Logic)))));
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsDisplayCPUControl.INSTANCE) {
                                    tCovers.value(tSide, (short)(tCPU_Control <= 0 ? 0 : (tCPU_Control >= this.mCPU_Control ? 15 : 14 - (int)Math.max(0L, Math.min(13L, (long)(this.mCPU_Control - tCPU_Control) * 14L / (long)this.mCPU_Control)))), true);
                                    tCovers.visual(tSide, (short)(tCPU_Control <= 0 ? 0 : (tCPU_Control >= this.mCPU_Control ? 10 : 9 - (int)Math.max(0L, Math.min(8L, (long)(this.mCPU_Control - tCPU_Control) * 9L / (long)this.mCPU_Control)))));
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsDisplayCPUStorage.INSTANCE) {
                                    tCovers.value(tSide, (short)(tCPU_Storage <= 0 ? 0 : (tCPU_Storage >= this.mCPU_Storage ? 15 : 14 - (int)Math.max(0L, Math.min(13L, (long)(this.mCPU_Storage - tCPU_Storage) * 14L / (long)this.mCPU_Storage)))), true);
                                    tCovers.visual(tSide, (short)(tCPU_Storage <= 0 ? 0 : (tCPU_Storage >= this.mCPU_Storage ? 10 : 9 - (int)Math.max(0L, Math.min(8L, (long)(this.mCPU_Storage - tCPU_Storage) * 9L / (long)this.mCPU_Storage)))));
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsDisplayCPUConversion.INSTANCE) {
                                    tCovers.value(tSide, (short)(tCPU_Conversion <= 0 ? 0 : (tCPU_Conversion >= this.mCPU_Conversion ? 15 : 14 - (int)Math.max(0L, Math.min(13L, (long)(this.mCPU_Conversion - tCPU_Conversion) * 14L / (long)this.mCPU_Conversion)))), true);
                                    tCovers.visual(tSide, (short)(tCPU_Conversion <= 0 ? 0 : (tCPU_Conversion >= this.mCPU_Conversion ? 10 : 9 - (int)Math.max(0L, Math.min(8L, (long)(this.mCPU_Conversion - tCPU_Conversion) * 9L / (long)this.mCPU_Conversion)))));
                                    continue;
                                }
                                DelegatorTileEntity<TileEntity> tAdjacent = tLogistics.getAdjacentTileEntity(tSide);
                                if (tAdjacent.mTileEntity instanceof ITileEntityLogistics && ((ITileEntityLogistics)tAdjacent.mTileEntity).canLogistics((byte)6)) continue;
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsFluidExport.INSTANCE) {
                                    tFluid = FL.load(tCovers.mNBTs[tSide], "gt.filter.fluid");
                                    if (tFluid == null || tFluid.getFluid() == null) continue;
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tFluidExportsGeneric.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        case 2: {
                                            tFluidExportsSemi.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        default: {
                                            tFluidExportsFiltered.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsFluidImport.INSTANCE) {
                                    tFluid = FL.load(tCovers.mNBTs[tSide], "gt.filter.fluid");
                                    if (tFluid == null || tFluid.getFluid() == null) continue;
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tFluidImportsGeneric.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        case 2: {
                                            tFluidImportsSemi.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        default: {
                                            tFluidImportsFiltered.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsFluidStorage.INSTANCE) {
                                    tFluid = FL.load(tCovers.mNBTs[tSide], "gt.filter.fluid");
                                    if (tFluid == null || tFluid.getFluid() == null) continue;
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tFluidStorageGeneric.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        case 2: {
                                            tFluidStorageSemi.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                        default: {
                                            tFluidStorageFiltered.add(new LogisticsData(tAdjacent, tFluid.getFluid()));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsItemExport.INSTANCE) {
                                    tStack = ST.load(tCovers.mNBTs[tSide], "gt.filter.item");
                                    if (!ST.valid(tStack)) continue;
                                    tFilteredFor.add(tStack);
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tStackExportsGeneric.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        case 2: {
                                            tStackExportsSemi.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        default: {
                                            tStackExportsFiltered.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsItemImport.INSTANCE) {
                                    tStack = ST.load(tCovers.mNBTs[tSide], "gt.filter.item");
                                    if (!ST.valid(tStack)) continue;
                                    tFilteredFor.add(tStack);
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tStackImportsGeneric.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        case 2: {
                                            tStackImportsSemi.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        default: {
                                            tStackImportsFiltered.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsItemStorage.INSTANCE) {
                                    tStack = ST.load(tCovers.mNBTs[tSide], "gt.filter.item");
                                    if (!ST.valid(tStack)) continue;
                                    tFilteredFor.add(tStack);
                                    switch (tCovers.mValues[tSide] & 3) {
                                        case 1: {
                                            tStackStorageGeneric.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        case 2: {
                                            tStackStorageSemi.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                        default: {
                                            tStackStorageFiltered.add(new LogisticsData(tAdjacent, tStack, tCovers.mValues[tSide] >> 2 & 0x7F));
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                LogisticsData tTarget = new LogisticsData(tAdjacent, tCovers.mValues[tSide] >> 2 & 0x7F);
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsGenericDump.INSTANCE) {
                                    tStackDumps.add(tTarget);
                                    continue;
                                }
                                int tDefault = tCovers.mValues[tSide] & 3;
                                boolean aAllowFluids = true;
                                if (tAdjacent.mTileEntity instanceof ITileEntityLogisticsSemiFilteredItem) {
                                    aAllowFluids = false;
                                    ItemStackSet<ItemStackContainer> tFilter = ((ITileEntityLogisticsSemiFilteredItem)tAdjacent.mTileEntity).getLogisticsFilter(tAdjacent.mSideOfTileEntity);
                                    if (tFilter != null) {
                                        tFilteredFor.addAll((Collection<ItemStackContainer>)tFilter);
                                        if (tDefault == 0) {
                                            tDefault = 2;
                                        }
                                    }
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsGenericExport.INSTANCE) {
                                    switch (tDefault) {
                                        default: {
                                            if (aAllowFluids) {
                                                tFluidExportsGeneric.add(tTarget);
                                            }
                                            tStackExportsGeneric.add(tTarget);
                                            break;
                                        }
                                        case 2: {
                                            if (aAllowFluids) {
                                                tFluidExportsSemi.add(tTarget);
                                            }
                                            tStackExportsSemi.add(tTarget);
                                            break;
                                        }
                                        case 3: {
                                            if (aAllowFluids) {
                                                tFluidExportsFiltered.add(tTarget);
                                            }
                                            tStackExportsFiltered.add(tTarget);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] == CoverLogisticsGenericImport.INSTANCE) {
                                    switch (tDefault) {
                                        default: {
                                            if (aAllowFluids) {
                                                tFluidImportsGeneric.add(tTarget);
                                            }
                                            tStackImportsGeneric.add(tTarget);
                                            break;
                                        }
                                        case 2: {
                                            if (aAllowFluids) {
                                                tFluidImportsSemi.add(tTarget);
                                            }
                                            tStackImportsSemi.add(tTarget);
                                            break;
                                        }
                                        case 3: {
                                            if (aAllowFluids) {
                                                tFluidImportsFiltered.add(tTarget);
                                            }
                                            tStackImportsFiltered.add(tTarget);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (tCovers.mBehaviours[tSide] != CoverLogisticsGenericStorage.INSTANCE) continue;
                                switch (tDefault) {
                                    default: {
                                        if (aAllowFluids) {
                                            tFluidStorageGeneric.add(tTarget);
                                        }
                                        tStackStorageGeneric.add(tTarget);
                                        continue block51;
                                    }
                                    case 2: {
                                        if (aAllowFluids) {
                                            tFluidStorageSemi.add(tTarget);
                                        }
                                        tStackStorageSemi.add(tTarget);
                                        continue block51;
                                    }
                                    case 3: {
                                        if (aAllowFluids) {
                                            tFluidStorageFiltered.add(tTarget);
                                        }
                                        tStackStorageFiltered.add(tTarget);
                                        continue block51;
                                    }
                                }
                            }
                        }
                        if (tLogistics.getWorld() != this.field_145850_b) continue;
                        for (byte tSide : CS.ALL_SIDES_VALID) {
                            int tMaxDistance;
                            if (!tLogistics.canLogistics(tSide) || (tMaxDistance = Math.max(Math.abs(tLogistics.getOffsetX(tSide) - tX), Math.max(Math.abs(tLogistics.getOffsetY(tSide) - tY), Math.abs(tLogistics.getOffsetZ(tSide) - tZ)))) > this.mCPU_Control + 2) continue;
                            this.oCPU_Control = Math.max(this.oCPU_Control, tMaxDistance - 2);
                            DelegatorTileEntity<TileEntity> tAdjacent = tLogistics.getAdjacentTileEntity(tSide);
                            if (!(tAdjacent.mTileEntity instanceof ITileEntityLogistics) || !((ITileEntityLogistics)tAdjacent.mTileEntity).canLogistics(tAdjacent.mSideOfTileEntity) || !tScanned.add(tAdjacent.mTileEntity)) continue;
                            tScanningNext.add((ITileEntityLogistics)tAdjacent.mTileEntity);
                        }
                    }
                    tScanning.clear();
                    tScanning.addAll(tScanningNext);
                    tScanningNext.clear();
                }
                while (++this.oCPU_Logic <= this.mCPU_Logic) {
                    List[] tImports;
                    int n;
                    boolean tBreak = false;
                    for (List[] tExports : tExports1) {
                        List[][] listArrayArray = tImports1;
                        int tSide = listArrayArray.length;
                        for (n = 0; n < tSide; ++n) {
                            tImports = listArrayArray[n];
                            if (this.moveFluids(tImports[0], tExports[0])) {
                                tBreak = true;
                                break;
                            }
                            if (!this.moveStacks(tImports[1], tExports[1])) continue;
                            tBreak = true;
                            break;
                        }
                        if (tBreak) break;
                    }
                    if (tBreak) continue;
                    for (List[] tExports : tExports2) {
                        List[][] listArrayArray = tImports2;
                        int tSide = listArrayArray.length;
                        for (n = 0; n < tSide; ++n) {
                            tImports = listArrayArray[n];
                            if (this.moveFluids(tImports[0], tExports[0])) {
                                tBreak = true;
                                break;
                            }
                            if (!this.moveStacks(tImports[1], tExports[1])) continue;
                            tBreak = true;
                            break;
                        }
                        if (tBreak) break;
                    }
                    if (tBreak || this.moveFluids(tFluidStorageGeneric, tFluidStorageFiltered) || this.moveStacks(tStackStorageGeneric, tStackStorageFiltered) || this.moveFluids(tFluidStorageGeneric, tFluidStorageSemi) || this.moveStacks(tStackStorageGeneric, tStackStorageSemi)) continue;
                    for (LogisticsData tImport : tStackStorageGeneric) {
                        for (LogisticsData tExport : tStackDumps) {
                            long tMoved;
                            for (int j = 0; j < this.mCPU_Conversion && (tMoved = (long)ST.move(tImport.mTarget, tExport.mTarget, tFilteredFor, false, false, true, false, 64, 1, 64, 1)) > 0L; ++j) {
                                this.oCPU_Conversion = Math.max(this.oCPU_Conversion, j + 1);
                                this.mEnergy -= tMoved;
                                tBreak = true;
                            }
                            if (!tBreak) continue;
                            break;
                        }
                        if (!tBreak) continue;
                        break;
                    }
                    if (tBreak) continue;
                    --this.oCPU_Logic;
                    break;
                }
            }
        }
        this.mEnergy -= (long)(20 + this.mCPU_Logic + this.mCPU_Control + this.mCPU_Storage + this.mCPU_Conversion);
        if (this.mEnergy < 0L) {
            this.mEnergy = 0L;
        }
    }

    public boolean moveFluids(List<LogisticsData> aImports, List<LogisticsData> aExports) {
        for (LogisticsData aImport : aImports) {
            for (LogisticsData aExport : aExports) {
                if (!this.moveFluids(aImport, aExport)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean moveStacks(List<LogisticsData> aImports, List<LogisticsData> aExports) {
        for (LogisticsData aImport : aImports) {
            for (LogisticsData aExport : aExports) {
                if (!this.moveStacks(aImport, aExport)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean moveFluids(LogisticsData aImport, LogisticsData aExport) {
        if (aImport.mFluidFilter != null) {
            if (aExport.mFluidFilter != null) {
                long tMoved;
                if (aImport.mFluidFilter == aExport.mFluidFilter && (tMoved = FL.move(aImport.mTarget, aExport.mTarget, FL.make(aImport.mFluidFilter, 16000L * (long)this.mCPU_Conversion))) > 0L) {
                    this.oCPU_Conversion = (int)Math.max((long)this.oCPU_Conversion, UT.Code.divup(tMoved, 16000L));
                    this.mEnergy -= UT.Code.divup(tMoved, 250L);
                    return true;
                }
            } else {
                long tMoved = FL.move(aImport.mTarget, aExport.mTarget, FL.make(aImport.mFluidFilter, 16000L * (long)this.mCPU_Conversion));
                if (tMoved > 0L) {
                    this.oCPU_Conversion = (int)Math.max((long)this.oCPU_Conversion, UT.Code.divup(tMoved, 16000L));
                    this.mEnergy -= UT.Code.divup(tMoved, 250L);
                    return true;
                }
            }
        } else if (aExport.mFluidFilter != null) {
            long tMoved = FL.move(aImport.mTarget, aExport.mTarget, FL.make(aExport.mFluidFilter, 16000L * (long)this.mCPU_Conversion));
            if (tMoved > 0L) {
                this.oCPU_Conversion = (int)Math.max((long)this.oCPU_Conversion, UT.Code.divup(tMoved, 16000L));
                this.mEnergy -= UT.Code.divup(tMoved, 250L);
                return true;
            }
        } else {
            long tMoved = FL.move(aImport.mTarget, aExport.mTarget, 16000L * (long)this.mCPU_Conversion);
            if (tMoved > 0L) {
                this.oCPU_Conversion = (int)Math.max((long)this.oCPU_Conversion, UT.Code.divup(tMoved, 16000L));
                this.mEnergy -= UT.Code.divup(tMoved, 250L);
                return true;
            }
        }
        return false;
    }

    public boolean moveStacks(LogisticsData aImport, LogisticsData aExport) {
        boolean tReturn = false;
        if (aImport.mItemFilter != null) {
            if (aExport.mItemFilter != null) {
                if (ST.equal(aImport.mItemFilter, aExport.mItemFilter, true)) {
                    long tMoved;
                    for (int j = 0; j < this.mCPU_Conversion && (tMoved = (long)ST.move(aImport.mTarget, aExport.mTarget, ST.hashset(aImport.mItemFilter), false, false, false, false, aExport.mStackSize == 0 ? 64 : aExport.mStackSize, aExport.mStackSize == 0 ? 1 : aExport.mStackSize, aImport.mStackSize == 0 ? 64 : aImport.mStackSize, aImport.mStackSize == 0 ? 1 : aImport.mStackSize)) > 0L; ++j) {
                        this.oCPU_Conversion = Math.max(this.oCPU_Conversion, j + 1);
                        this.mEnergy -= tMoved;
                        tReturn = true;
                        if (aImport.mStackSize == 0 && aExport.mStackSize == 0) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                long tMoved;
                for (int j = 0; j < this.mCPU_Conversion && (tMoved = (long)ST.move(aImport.mTarget, aExport.mTarget, ST.hashset(aImport.mItemFilter), false, false, false, false, aExport.mStackSize == 0 ? 64 : aExport.mStackSize, aExport.mStackSize == 0 ? 1 : aExport.mStackSize, aImport.mStackSize == 0 ? 64 : aImport.mStackSize, aImport.mStackSize == 0 ? 1 : aImport.mStackSize)) > 0L; ++j) {
                    this.oCPU_Conversion = Math.max(this.oCPU_Conversion, j + 1);
                    this.mEnergy -= tMoved;
                    tReturn = true;
                    if (aImport.mStackSize == 0 && aExport.mStackSize == 0) {
                        continue;
                    }
                    break;
                }
            }
        } else if (aExport.mItemFilter != null) {
            long tMoved;
            for (int j = 0; j < this.mCPU_Conversion && (tMoved = (long)ST.move(aImport.mTarget, aExport.mTarget, ST.hashset(aExport.mItemFilter), false, false, false, false, aExport.mStackSize == 0 ? 64 : aExport.mStackSize, aExport.mStackSize == 0 ? 1 : aExport.mStackSize, aImport.mStackSize == 0 ? 64 : aImport.mStackSize, aImport.mStackSize == 0 ? 1 : aImport.mStackSize)) > 0L; ++j) {
                this.oCPU_Conversion = Math.max(this.oCPU_Conversion, j + 1);
                this.mEnergy -= tMoved;
                tReturn = true;
                if (aImport.mStackSize == 0 && aExport.mStackSize == 0) {
                    continue;
                }
                break;
            }
        } else {
            long tMoved;
            for (int j = 0; j < this.mCPU_Conversion && (tMoved = (long)ST.move(aImport.mTarget, aExport.mTarget, null, false, false, false, false, aExport.mStackSize == 0 ? 64 : aExport.mStackSize, aExport.mStackSize == 0 ? 1 : aExport.mStackSize, aImport.mStackSize == 0 ? 64 : aImport.mStackSize, aImport.mStackSize == 0 ? 1 : aImport.mStackSize)) > 0L; ++j) {
                this.oCPU_Conversion = Math.max(this.oCPU_Conversion, j + 1);
                this.mEnergy -= tMoved;
                tReturn = true;
                if (aImport.mStackSize == 0 && aExport.mStackSize == 0) {
                    continue;
                }
                break;
            }
        }
        return tReturn;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && aPlayer != null && this.checkStructure(false)) {
            ArrayListNoNulls<String> tChat = new ArrayListNoNulls<String>();
            tChat.add("Power: " + this.mEnergy + " EU");
            tChat.add("Comsumption: " + (20 + this.mCPU_Logic + this.mCPU_Control + this.mCPU_Storage + this.mCPU_Conversion) + " EU/t, plus more per moved Item/Fluid");
            tChat.add(this.mCPU_Logic + " Logic Processors");
            tChat.add(this.mCPU_Control + " Control Processors (Range: " + (2 + this.mCPU_Control) + "m, Cubic AoE)");
            tChat.add(this.mCPU_Storage + " Storage Processors (Note: For now useless)");
            tChat.add(this.mCPU_Conversion + " Conversion Processors");
            UT.Entities.sendchat((Object)aPlayer, tChat, false);
        }
        return true;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (this.mEnergy > 128L + (long)this.mCPU_Logic * 256L * (long)this.mCPU_Conversion) {
            return 0L;
        }
        aSize = Math.abs(aSize);
        if (!aDoInject) {
            return aAmount;
        }
        if (aSize > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            this.explode(6.0);
            return aAmount;
        }
        this.mEnergy += aAmount * aSize;
        return aAmount;
    }

    @Override
    public boolean canLogistics(byte aSide) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return 1024L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return 1024L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 512L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 256L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? 128L + (long)this.mCPU_Logic * 256L * (long)this.mCPU_Conversion : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.mTanks;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[108];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.logisticscore";
    }

    static {
        LH.add("gt.tooltip.multiblock.logisticscore.1", "5x5x5 Frame made out of 44 Galvanized Steel Walls (Power Input Here)");
        LH.add("gt.tooltip.multiblock.logisticscore.2", "3x3x3 Core of 27 of any Multiblock Processor Units (Customizable)");
        LH.add("gt.tooltip.multiblock.logisticscore.3", "The Six 3x3 Walls need to be 53 Ventilation Units");
        LH.add("gt.tooltip.multiblock.logisticscore.4", "Main centered at any Side facing outwards");
        LH.add("gt.tooltip.multiblock.logisticscore.5", "At least one of each Processor Type needed (Or use a Versatile one)");
        LH.add("gt.tooltip.multiblock.logisticscore.6", "You can replace CPUs with Walls should you not be able to afford that many.");
        LH.add("gt.tooltip.multiblock.logisticscore.7", "Logic Processors increase Operation Count by 1");
        LH.add("gt.tooltip.multiblock.logisticscore.8", "Control Processors increase Maximum Network Range by 1m (Cubic AoE)");
        LH.add("gt.tooltip.multiblock.logisticscore.9", "Storage Processors increase Buffer Size by 1 Stack or 16000L");
        LH.add("gt.tooltip.multiblock.logisticscore.10", "Conversion Processors increase Throughput by 1 Stack or 16000L");
    }

    static class LogisticsData {
        public final DelegatorTileEntity<TileEntity> mTarget;
        public final Fluid mFluidFilter;
        public final ItemStack mItemFilter;
        public final int mStackSize;

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, Fluid aFluidFilter, ItemStack aItemFilter, int aStackSize) {
            this.mTarget = aTarget;
            this.mFluidFilter = aFluidFilter;
            this.mItemFilter = aItemFilter;
            this.mStackSize = aStackSize;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, Fluid aFluidFilter, ItemStack aItemFilter) {
            this.mTarget = aTarget;
            this.mFluidFilter = aFluidFilter;
            this.mItemFilter = aItemFilter;
            this.mStackSize = 0;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, ItemStack aItemFilter, int aStackSize) {
            this.mTarget = aTarget;
            this.mFluidFilter = null;
            this.mItemFilter = aItemFilter;
            this.mStackSize = aStackSize;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, ItemStack aItemFilter) {
            this.mTarget = aTarget;
            this.mFluidFilter = null;
            this.mItemFilter = aItemFilter;
            this.mStackSize = 0;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, Fluid aFluidFilter) {
            this.mTarget = aTarget;
            this.mFluidFilter = aFluidFilter;
            this.mItemFilter = null;
            this.mStackSize = 0;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget, int aStackSize) {
            this.mTarget = aTarget;
            this.mFluidFilter = null;
            this.mItemFilter = null;
            this.mStackSize = aStackSize;
        }

        public LogisticsData(DelegatorTileEntity<TileEntity> aTarget) {
            this.mTarget = aTarget;
            this.mFluidFilter = null;
            this.mItemFilter = null;
            this.mStackSize = 0;
        }
    }
}

