/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityLargeBoiler
extends TileEntityBase10MultiBlockBase
implements ITileEntityEnergy,
ITileEntityGibbl,
ITileEntityEnergyDataCapacitor,
IMultiBlockEnergy,
IMultiBlockFluidHandler,
IFluidHandler,
IMultiTileEntity.IMTE_RemovedByPlayer {
    public short mBoilerWalls = (short)18002;
    public byte mBarometer = 0;
    public byte oBarometer = 0;
    public short mEfficiency = (short)10000;
    public short mCoolDownResetTimer = (short)128;
    public long mEnergy = 0L;
    public long mCapacity = 20480000L;
    public long mOutput = 204800L;
    public TagData mEnergyTypeAccepted = TD.Energy.HU;
    public FluidTankGT[] mTanks = new FluidTankGT[]{new FluidTankGT(128000L), new FluidTankGT(2048000L)};
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.design")) {
            this.mBoilerWalls = aNBT.func_74765_d("gt.design");
        }
        if (aNBT.func_74764_b("gt.visual")) {
            this.mBarometer = aNBT.func_74771_c("gt.visual");
        }
        if (aNBT.func_74764_b("gt.capacity")) {
            this.mCapacity = aNBT.func_74763_f("gt.capacity");
        }
        if (aNBT.func_74764_b("gt.capacity.su")) {
            this.mTanks[1].setCapacity(aNBT.func_74763_f("gt.capacity.su"));
        }
        if (aNBT.func_74764_b("gt.output.su")) {
            this.mOutput = aNBT.func_74763_f("gt.output.su");
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].readFromNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        if (this.mEfficiency != 10000) {
            aNBT.func_74777_a("gt.eff", this.mEfficiency);
        }
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.field_145850_b.func_72899_e(tX - 1, tY = this.field_145848_d, (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ - 1) && this.field_145850_b.func_72899_e(tX - 1, tY, tZ + 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            if (this.getAir(tX, tY + 1, tZ)) {
                this.field_145850_b.func_147468_f(tX, tY + 1, tZ);
            } else {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY - 1, tZ - 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY - 1, tZ - 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY - 1, tZ - 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY - 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY - 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY - 1, tZ, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY - 1, tZ + 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY - 1, tZ + 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY - 1, tZ + 1, 18101, this.getMultiTileEntityRegistryID(), 0, -3, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + 2, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 1, -5, aCoordinates, aPlayer, aInventory)) {
                tSuccess = false;
            }
            for (int i = 1; i < 3; ++i) {
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY + i, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + i, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), i == 1 ? 1 : 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + i, tZ - 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY + i, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), i == 1 ? 1 : 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + i, tZ, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), i == 1 ? 1 : 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX - 1, tY + i, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY + i, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), i == 1 ? 1 : 0, -5, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + 1, tY + i, tZ + 1, this.mBoilerWalls, this.getMultiTileEntityRegistryID(), 0, -5, aCoordinates, aPlayer, aInventory)) continue;
                tSuccess = false;
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.largeboiler.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.largeboiler.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.largeboiler.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.largeboiler.4"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " 1 L " + FL.name(FluidRegistry.WATER, true) + " " + LH.get("gt.lang.energy.convert.to") + " 160 L " + FL.name(FL.Steam.make(0L), true) + " " + LH.get("gt.lang.energy.convert.using") + " 80 " + this.mEnergyTypeAccepted.getLocalisedNameShort());
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + this.mOutput / (long)CS.STEAM_PER_EU + " " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t (Heat Transmitters)");
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE);
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + UT.Code.units(this.mOutput, 10000L, this.mEfficiency, false) + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE + "/t (Pipe Holes)");
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.water.pure"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.explosion.steam"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.chisel.to.decalcify"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.field_145848_d;
        int tZ = this.getOffsetZN(this.mFacing);
        return aX >= tX - 1 && aY >= tY - 1 && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 2 && aZ <= tZ + 1;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            FluidStack tDrainableSteam;
            long tAmount;
            long tConversions = Math.min(this.mTanks[1].capacity() / 2560L, Math.min(this.mEnergy / 80L, this.mTanks[0].amount()));
            if (tConversions > 0L) {
                this.mTanks[0].remove(tConversions);
                if (this.rng(10) == 0 && this.mEfficiency > 5000 && this.mTanks[0].has() && !FL.distw(this.mTanks[0])) {
                    this.mEfficiency = (short)((long)this.mEfficiency - tConversions);
                    if (this.mEfficiency < 5000) {
                        this.mEfficiency = (short)5000;
                    }
                }
                this.mTanks[1].setFluid(FL.Steam.make(this.mTanks[1].amount() + UT.Code.units(tConversions, 10000L, this.mEfficiency * 160, false)));
                this.mEnergy -= tConversions * 80L;
                this.mCoolDownResetTimer = (short)128;
            }
            short s = this.mCoolDownResetTimer;
            this.mCoolDownResetTimer = (short)(s - 1);
            if (s <= 0) {
                this.mCoolDownResetTimer = 0;
                this.mEnergy -= this.mOutput * 64L / (long)CS.STEAM_PER_EU;
                CS.GarbageGT.trash(this.mTanks[1], this.mOutput * 64L);
                if (this.mEnergy <= 0L) {
                    this.mEnergy = 0L;
                    this.mCoolDownResetTimer = (short)128;
                }
            }
            if ((tAmount = this.mTanks[1].amount() - this.mTanks[1].capacity() / 2L) > 0L && (tDrainableSteam = this.mTanks[1].drain(UT.Code.bindInt(Math.min(tAmount > this.mTanks[1].capacity() / 4L ? this.mOutput * 2L : this.mOutput, tAmount)), false)) != null) {
                int i;
                int tTargets = 0;
                DelegatorTileEntity[] tDelegators = new DelegatorTileEntity[]{WD.te(this.field_145850_b, this.getOffsetXN(this.mFacing, 1), this.field_145848_d + 3, this.getOffsetZN(this.mFacing, 1), (byte)0, false), WD.te(this.field_145850_b, this.getOffsetXN(this.mFacing, 1) - 2, this.field_145848_d + 1, this.getOffsetZN(this.mFacing, 1), (byte)5, false), WD.te(this.field_145850_b, this.getOffsetXN(this.mFacing, 1) + 2, this.field_145848_d + 1, this.getOffsetZN(this.mFacing, 1), (byte)4, false), WD.te(this.field_145850_b, this.getOffsetXN(this.mFacing, 1), this.field_145848_d + 1, this.getOffsetZN(this.mFacing, 1) - 2, (byte)3, false), WD.te(this.field_145850_b, this.getOffsetXN(this.mFacing, 1), this.field_145848_d + 1, this.getOffsetZN(this.mFacing, 1) + 2, (byte)2, false)};
                long[] tTargetAmounts = new long[tDelegators.length];
                for (i = 0; i < tDelegators.length; ++i) {
                    if (tDelegators[i].mTileEntity instanceof IFluidHandler && (tTargetAmounts[i] = FL.fill_(tDelegators[i], tDrainableSteam, false)) > 0L) {
                        ++tTargets;
                        continue;
                    }
                    tDelegators[i] = null;
                }
                if (tTargets == 1) {
                    for (i = 0; i < tDelegators.length; ++i) {
                        if (tDelegators[i] == null) continue;
                        FL.move_(this.mTanks[1], tDelegators[i], (long)tDrainableSteam.amount);
                        break;
                    }
                } else if (tTargets > 1 && tDrainableSteam.amount >= tTargets) {
                    if (UT.Code.sum(tTargetAmounts) > (long)tDrainableSteam.amount) {
                        int i2;
                        int tMoveable = tDrainableSteam.amount;
                        int tOriginalTargets = tTargets;
                        for (i2 = 0; i2 < tDelegators.length; ++i2) {
                            if (tDelegators[i2] == null || tTargetAmounts[i2] > (long)(tDrainableSteam.amount / tOriginalTargets)) continue;
                            tMoveable = (int)((long)tMoveable - FL.move_(this.mTanks[1], tDelegators[i2], (long)(tDrainableSteam.amount / tOriginalTargets)));
                            tDelegators[i2] = null;
                            if (--tTargets < 2) break;
                        }
                        if (tTargets == 1) {
                            for (i2 = 0; i2 < tDelegators.length; ++i2) {
                                if (tDelegators[i2] == null) continue;
                                FL.move_(this.mTanks[1], tDelegators[i2], (long)tMoveable);
                                break;
                            }
                        } else if (tTargets > 1 && tMoveable >= tTargets) {
                            for (i2 = 0; i2 < tDelegators.length; ++i2) {
                                if (tDelegators[i2] == null) continue;
                                tMoveable = (int)((long)tMoveable - FL.move_(this.mTanks[1], tDelegators[i2], (long)(tMoveable / tTargets)));
                                if (--tTargets >= 1) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        for (i = 0; i < tDelegators.length; ++i) {
                            if (tDelegators[i] == null) continue;
                            FL.move_(this.mTanks[1], tDelegators[i], tTargetAmounts[i]);
                        }
                    }
                }
            }
            this.mBarometer = (byte)UT.Code.scale(this.mTanks[1].amount(), this.mTanks[1].capacity(), 31L, false);
            if (this.mBarometer > 4 && !this.checkStructure(false) || this.mEnergy > this.mCapacity || this.mTanks[1].isFull()) {
                this.explode(false);
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[0].has()) {
                return CS.GarbageGT.trash(this.mTanks[0]);
            }
            return CS.GarbageGT.trash(this.mTanks[1]);
        }
        if (aTool.equals("chisel")) {
            int rResult = 10000 - this.mEfficiency;
            if (rResult > 0) {
                if (this.mBarometer > 15) {
                    this.explode(false);
                } else {
                    if (this.mEnergy + this.mTanks[1].amount() / (long)CS.STEAM_PER_EU > 2000L) {
                        UT.Entities.applyHeatDamage(aPlayer, (float)(this.mEnergy + this.mTanks[1].amount() / 2L) / 2000.0f);
                    }
                    this.mTanks[1].setEmpty();
                    this.mEfficiency = (short)10000;
                    this.mEnergy = 0L;
                    return rResult;
                }
            }
            return 0L;
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Stored Heat Units: " + this.mEnergy + " / " + this.mCapacity + " HU");
            }
            return 10000L;
        }
        return 0L;
    }

    @Override
    public void onMagnifyingGlass2(List<String> aChatReturn) {
        if (this.mEfficiency < 10000) {
            aChatReturn.add("Calcification: " + LH.percent(10000 - this.mEfficiency) + "%");
        } else {
            aChatReturn.add("No Calcification in this Boiler");
        }
        aChatReturn.add(this.mTanks[0].content("WARNING: NO WATER!!!"));
    }

    @Override
    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, boolean aWillHarvest) {
        if (this.isServerSide() && !UT.Entities.isCreative(aPlayer) && this.mBarometer > 4) {
            this.explode(true);
        }
        return this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        super.onExploded(aExplosion);
        if (this.isServerSide() && this.mBarometer > 4) {
            this.explode(true);
        }
    }

    @Override
    public void explode(boolean aInstant) {
        this.explode(2.0 + Math.max(1.0, Math.sqrt(this.mTanks[1].amount()) / 1000.0));
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mBarometer = UT.Code.bind5(this.mBarometer);
        return this.mBarometer != this.oBarometer || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oBarometer = this.mBarometer;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mBarometer = (byte)(aData & 0x1F);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        ITexture rTexture = super.getTexture2(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        return aSide != this.mFacing || rTexture == null ? rTexture : BlockTextureMulti.get(rTexture, BlockTextureDefault.get(BI.BAROMETER), BlockTextureDefault.get(BI.BAROMETER_SCALE[this.mBarometer], CS.CA_RED_64));
    }

    @Override
    public byte getVisualData() {
        return this.mBarometer;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mEnergy += Math.abs(aAmount * aSize);
            this.mCoolDownResetTimer = (short)Math.max(this.mCoolDownResetTimer, 32);
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput / 2L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 1L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mCapacity : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return FL.water(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.mTanks;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return FL.water(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public long getGibblValue(byte aSide) {
        return this.mTanks[1].amount();
    }

    @Override
    public long getGibblMax(byte aSide) {
        return this.mTanks[1].capacity();
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.boiler.steam";
    }

    static {
        LH.add("gt.tooltip.multiblock.largeboiler.1", "3x3 Base of Heat Transmitters");
        LH.add("gt.tooltip.multiblock.largeboiler.2", "3x3x3 Hollow of the Block you crafted this one with");
        LH.add("gt.tooltip.multiblock.largeboiler.3", "Main centered on Side-Bottom of Boiler facing outwards");
        LH.add("gt.tooltip.multiblock.largeboiler.4", "Input only possible at Bottom Layer of Boiler");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tanks/boiler_steam/overlay/side")};
    }
}

