/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.extenders;

import gregapi.GT_API;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase10FacingDouble;
import gregapi.tileentity.connectors.ITileEntityItemPipe;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityExtender
extends TileEntityBase10FacingDouble
implements ITileEntityDelegating,
ITileEntityAdjacentInventoryUpdatable,
IFluidHandler,
IMultiTileEntity.IMTE_GetComparatorInputOverride {
    public byte mComparator = 0;
    public byte mRedstoneIn = 0;
    public byte mRedstoneOut = 0;
    public byte mModes = 0;
    protected IIconContainer[] mTextures = CS.L6_IICONCONTAINER;
    public byte mLastSide = (byte)6;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode")) {
            this.mModes = aNBT.func_74771_c("gt.mode");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                String tTextureName = aNBT.func_74779_i("gt.texture");
                this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/colored/in"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/colored/out"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/overlay/in"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/overlay/out"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/overlay/side")};
            } else {
                TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), (int)this.getMultiTileEntityID());
                if (tCanonicalTileEntity instanceof MultiTileEntityExtender) {
                    this.mTextures = ((MultiTileEntityExtender)tCanonicalTileEntity).mTextures;
                }
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if ((this.mModes & 0x1F) == 31) {
            aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_ALL));
        } else {
            if ((this.mModes & 1) == 1) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_INVENTORY));
            }
            if ((this.mModes & 2) == 2) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_TANK));
            }
            if ((this.mModes & 4) == 4) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_REDSTONE));
            }
            if ((this.mModes & 0x10) == 16) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_CONTROL));
            }
            if ((this.mModes & 8) == 8) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_OTHER));
            }
        }
        aList.add(LH.Chat.ORANGE + LH.get(TOOLTIP_EXTENDER_EXCLUSIVE));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            byte oRedstoneIn = this.mRedstoneIn;
            byte oRedstoneOut = this.mRedstoneOut;
            byte oComparator = this.mComparator;
            if ((this.mModes & 4) == 0) {
                this.mRedstoneOut = 0;
                this.mRedstoneIn = 0;
                this.mComparator = 0;
            } else {
                this.mRedstoneIn = this.getRedstoneIncoming(this.mFacing);
                this.mComparator = this.getComparatorIncoming(this.mFacing);
                this.mRedstoneOut = 0;
                for (byte tSide : CS.ALL_SIDES_VALID_BUT[this.mFacing]) {
                    this.mRedstoneOut = (byte)Math.max(this.mRedstoneOut, this.getRedstoneIncoming(tSide));
                }
            }
            if (oRedstoneIn != this.mRedstoneIn || oRedstoneOut != this.mRedstoneOut || oComparator != this.mComparator) {
                this.causeBlockUpdate();
            }
        }
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        if (aSide == this.mFacing) {
            return BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[0], this.mRGBa), BlockTextureDefault.get(this.mTextures[3]));
        }
        if (aSide == this.mSecondFacing) {
            return BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[1], this.mRGBa), BlockTextureDefault.get(this.mTextures[4]));
        }
        return BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[2], this.mRGBa), BlockTextureDefault.get(this.mTextures[5]));
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tDelegate.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable) {
                ((ITileEntityAdjacentInventoryUpdatable)tDelegate.mTileEntity).adjacentInventoryUpdated(tDelegate.mSideOfTileEntity, aTileEntity);
            }
        }
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.extender";
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        if ((this.mModes & 0x1F) == 31) {
            return this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
        }
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<TileEntity> rDelegator = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (rDelegator.mTileEntity instanceof ITileEntityItemPipe) {
                return rDelegator;
            }
        }
        return this.delegator(aSide);
    }

    @Override
    public boolean isExtender(byte aSide) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return this.mComparator;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return CS.OPOS[aSide] == this.mFacing ? this.mRedstoneOut : this.mRedstoneIn;
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70298_a(aSlot, aDecrement);
            }
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int aSlot) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70304_b(aSlot);
            }
        }
        return null;
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70301_a(aSlot);
            }
        }
        return null;
    }

    @Override
    public String func_145825_b() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145825_b();
            }
        }
        return super.func_145825_b();
    }

    @Override
    public int func_70302_i_() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70302_i_();
            }
        }
        return 0;
    }

    @Override
    public int func_70297_j_() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70297_j_();
            }
        }
        return 0;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                ((IInventory)tTileEntity.mTileEntity).func_70299_a(aSlot, aStack);
            }
        }
    }

    @Override
    public boolean func_145818_k_() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145818_k_();
            }
        }
        return this.getCustomName() != null;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_94128_d((int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return UT.Code.getAscendingArray(((IInventory)tTileEntity.mTileEntity).func_70302_i_());
            }
        }
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102008_b(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluid)) {
                return 0;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), aFluid, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean doDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluid)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aFluid, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, null)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), maxDrain, doDrain);
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        if ((this.mModes & 2) != 0) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(UT.Code.side(aDirection)), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).getTankInfo(tTileEntity.getForgeSideOfTileEntity());
            }
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    public boolean getStateRunningPossible() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningPossible) {
                return ((ITileEntityRunningPossible)tTileEntity.mTileEntity).getStateRunningPossible();
            }
        }
        return false;
    }

    public boolean getStateRunningPassively() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningPassively) {
                return ((ITileEntityRunningPassively)tTileEntity.mTileEntity).getStateRunningPassively();
            }
        }
        return false;
    }

    public boolean getStateRunningActively() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningActively) {
                return ((ITileEntityRunningActively)tTileEntity.mTileEntity).getStateRunningActively();
            }
        }
        return false;
    }

    public boolean getStateRunningSuccessfully() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningSuccessfully) {
                return ((ITileEntityRunningSuccessfully)tTileEntity.mTileEntity).getStateRunningSuccessfully();
            }
        }
        return false;
    }

    public boolean getStateOnOff() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableOnOff) {
                return ((ITileEntitySwitchableOnOff)tTileEntity.mTileEntity).getStateOnOff();
            }
        }
        return false;
    }

    public byte getStateMode() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableMode) {
                return ((ITileEntitySwitchableMode)tTileEntity.mTileEntity).getStateMode();
            }
        }
        return 0;
    }

    public boolean setStateOnOff(boolean aOnOff) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableOnOff) {
                return ((ITileEntitySwitchableOnOff)tTileEntity.mTileEntity).setStateOnOff(aOnOff);
            }
        }
        return false;
    }

    public byte setStateMode(byte aMode) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableMode) {
                return ((ITileEntitySwitchableMode)tTileEntity.mTileEntity).setStateMode(aMode);
            }
        }
        return 0;
    }

    public long getProgressValue(byte aSide) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityProgress) {
                return ((ITileEntityProgress)tTileEntity.mTileEntity).getProgressValue(tTileEntity.mSideOfTileEntity);
            }
        }
        return 0L;
    }

    public long getProgressMax(byte aSide) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityProgress) {
                return ((ITileEntityProgress)tTileEntity.mTileEntity).getProgressMax(tTileEntity.mSideOfTileEntity);
            }
        }
        return 0L;
    }

    public byte getExtenderTargetSide(byte aSide) {
        return aSide == this.mFacing ? this.mSecondFacing : this.mFacing;
    }

    @Override
    public boolean func_70300_a(EntityPlayer aPlayer) {
        return aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }
}

