/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.converters;

import buildcraft.api.power.ILaserTarget;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityLaserBuildcraft
extends TileEntityBase10EnergyConverter
implements ITileEntityAdjacentOnOff,
ITileEntityEnergyElectricityAcceptor,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;
    public static IIconContainer[] sLasers;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.assemblylaser"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void doConversion(long aTimer) {
        if (EnergyCompat.BC_LASER) {
            long tOutput = UT.Code.units(this.mStorage.mEnergy, this.mConverter.mEnergyIN.mRec, this.mConverter.mEnergyOUT.mRec, false);
            DelegatorTileEntity<TileEntity> tLaser = this.getAdjacentTileEntity(this.mFacing, false, false);
            boolean bl = this.mActivity.mActive = tOutput >= this.mConverter.mEnergyOUT.mMin && tLaser.mTileEntity instanceof ILaserTarget && ((ILaserTarget)tLaser.mTileEntity).requiresLaserEnergy();
            if (this.mActivity.mActive) {
                if (tOutput > this.mConverter.mEnergyOUT.mMax && this.mConverter.mLimitConsumption) {
                    tOutput = this.mConverter.mEnergyOUT.mMax;
                }
                if (tOutput > this.mConverter.mEnergyOUT.mMax) {
                    this.overload(this.mStorage.mEnergy, this.mConverter.mEnergyOUT.mType);
                } else {
                    ((ILaserTarget)tLaser.mTileEntity).receiveLaserEnergy(UT.Code.bindInt(tOutput));
                }
                this.mStorage.mEnergy = Math.max(0L, this.mStorage.mEnergy - this.mConverter.mEnergyIN.mMax);
                this.mConverter.mEmitsEnergy = true;
                this.mConverter.mCanEmitEnergy = true;
            }
        }
    }

    @Override
    public byte getDefaultSide() {
        return 1;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM;
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.back");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return aSide == CS.OPOS[this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return aSide == CS.OPOS[this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? 0.5f : 0.0f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[this.mFacing == 4 ? 8 : 0], CS.PX_P[this.mFacing == 0 ? 8 : 0], CS.PX_P[this.mFacing == 2 ? 8 : 0], CS.PX_N[this.mFacing == 5 ? 8 : 0], CS.PX_N[this.mFacing == 1 ? 8 : 0], CS.PX_N[this.mFacing == 3 ? 8 : 0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[this.mFacing == 4 ? 8 : 0], CS.PX_P[this.mFacing == 0 ? 8 : 0], CS.PX_P[this.mFacing == 2 ? 8 : 0], CS.PX_N[this.mFacing == 5 ? 8 : 0], CS.PX_N[this.mFacing == 1 ? 8 : 0], CS.PX_N[this.mFacing == 3 ? 8 : 0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[this.mFacing == 4 ? 8 : 0], CS.PX_P[this.mFacing == 0 ? 8 : 0], CS.PX_P[this.mFacing == 2 ? 8 : 0], CS.PX_N[this.mFacing == 5 ? 8 : 0], CS.PX_N[this.mFacing == 1 ? 8 : 0], CS.PX_N[this.mFacing == 3 ? 8 : 0]);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 5;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return this.mActivity.mState != 0 || aRenderPass < 2;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[this.mFacing == 4 ? 8 : 0], CS.PX_P[this.mFacing == 0 ? 8 : 0], CS.PX_P[this.mFacing == 2 ? 8 : 0], CS.PX_N[this.mFacing == 5 ? 8 : 0], CS.PX_N[this.mFacing == 1 ? 8 : 0], CS.PX_N[this.mFacing == 3 ? 8 : 0]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[4], CS.PX_P[4], CS.PX_P[4], CS.PX_N[4], CS.PX_N[4], CS.PX_N[4]);
                return true;
            }
            case 2: {
                this.box(aBlock, this.mFacing == 4 ? (double)-0.99f : (double)CS.PX_P[5], this.mFacing == 0 ? (double)-0.99f : (double)CS.PX_P[5], this.mFacing == 2 ? (double)-0.99f : (double)CS.PX_P[5], this.mFacing == 5 ? (double)1.99f : (double)CS.PX_N[5], this.mFacing == 1 ? (double)1.99f : (double)CS.PX_N[5], this.mFacing == 3 ? (double)1.99f : (double)CS.PX_N[5]);
                return true;
            }
            case 3: {
                this.box(aBlock, this.mFacing == 4 ? (double)-0.99f : (double)CS.PX_P[6], this.mFacing == 0 ? (double)-0.99f : (double)CS.PX_P[6], this.mFacing == 2 ? (double)-0.99f : (double)CS.PX_P[6], this.mFacing == 5 ? (double)1.99f : (double)CS.PX_N[6], this.mFacing == 1 ? (double)1.99f : (double)CS.PX_N[6], this.mFacing == 3 ? (double)1.99f : (double)CS.PX_N[6]);
                return true;
            }
            case 4: {
                this.box(aBlock, this.mFacing == 4 ? (double)-0.99f : (double)CS.PX_P[7], this.mFacing == 0 ? (double)-0.99f : (double)CS.PX_P[7], this.mFacing == 2 ? (double)-0.99f : (double)CS.PX_P[7], this.mFacing == 5 ? (double)1.99f : (double)CS.PX_N[7], this.mFacing == 1 ? (double)1.99f : (double)CS.PX_N[7], this.mFacing == 3 ? (double)1.99f : (double)CS.PX_N[7]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                int tIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[tIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[tIndex]));
            }
            case 1: {
                if (aSide == CS.OPOS[this.mFacing]) break;
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aSide == this.mFacing ? 3 : 4], MT.Diamond.fRGBaSolid), BlockTextureDefault.get(sOverlays[aSide == this.mFacing ? 3 : 4]));
            }
        }
        if (!CS.ALONG_AXIS[aSide][this.mFacing]) {
            return BlockTextureDefault.get(sLasers[aRenderPass - 2], MT.Diamond.fRGBaSolid);
        }
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.lasers.buildcraft_electric";
    }

    static {
        LH.add("gt.tooltip.assemblylaser", "Place directly ontop of the Laser powered BC Device");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/back"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/side"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/laser_front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/colored/laser_side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/laser_front"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/overlay/laser_side")};
        sLasers = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser3"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser2"), new Textures.BlockIcons.CustomIcon("machines/lasers/laser_buildcraft/laser1")};
    }
}

