/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen.dungeon;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.dungeon.DungeonChunkBarracks;
import gregapi.worldgen.dungeon.DungeonChunkCorridor;
import gregapi.worldgen.dungeon.DungeonChunkCorridor3;
import gregapi.worldgen.dungeon.DungeonChunkCorridor4;
import gregapi.worldgen.dungeon.DungeonChunkDoorPiston;
import gregapi.worldgen.dungeon.DungeonChunkEntrance;
import gregapi.worldgen.dungeon.DungeonChunkPillar;
import gregapi.worldgen.dungeon.DungeonChunkRoomEmpty;
import gregapi.worldgen.dungeon.DungeonChunkRoomFarmCrop;
import gregapi.worldgen.dungeon.DungeonChunkRoomFarmFish;
import gregapi.worldgen.dungeon.DungeonChunkRoomFarmMobs;
import gregapi.worldgen.dungeon.DungeonChunkRoomLibraryMystcraft;
import gregapi.worldgen.dungeon.DungeonChunkRoomLibraryNormal;
import gregapi.worldgen.dungeon.DungeonChunkRoomLibraryThaumcraft;
import gregapi.worldgen.dungeon.DungeonChunkRoomMiningBedrock;
import gregapi.worldgen.dungeon.DungeonChunkRoomPortalAether;
import gregapi.worldgen.dungeon.DungeonChunkRoomPortalEnd;
import gregapi.worldgen.dungeon.DungeonChunkRoomPortalMyst;
import gregapi.worldgen.dungeon.DungeonChunkRoomPortalNether;
import gregapi.worldgen.dungeon.DungeonChunkRoomPortalTwilight;
import gregapi.worldgen.dungeon.DungeonChunkRoomStorage;
import gregapi.worldgen.dungeon.DungeonChunkRoomWorkshop;
import gregapi.worldgen.dungeon.DungeonData;
import gregapi.worldgen.dungeon.IDungeonChunk;
import gregtech.tileentity.placeables.MultiTileEntityCoin;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenDungeonGT
extends WorldgenObject {
    public static IDungeonChunk PILLAR = new DungeonChunkPillar();
    public static IDungeonChunk ROOM_EMPTY = new DungeonChunkRoomEmpty();
    public static IDungeonChunk DOOR_PISTON = new DungeonChunkDoorPiston();
    public static IDungeonChunk CORRIDOR = new DungeonChunkCorridor();
    public static IDungeonChunk CORRIDOR3 = new DungeonChunkCorridor3();
    public static IDungeonChunk CORRIDOR4 = new DungeonChunkCorridor4();
    public static IDungeonChunk ENTRANCE = new DungeonChunkEntrance();
    public static IDungeonChunk BARRACKS = new DungeonChunkBarracks();
    public static final TagData TAG_PORTAL_NETHER = TagData.createTagData("gt.dungeon.portal.nether");
    public static final TagData TAG_PORTAL_END = TagData.createTagData("gt.dungeon.portal.end");
    public static final TagData TAG_PORTAL_TWILIGHT = TagData.createTagData("gt.dungeon.portal.twilight");
    public static final TagData TAG_PORTAL_AETHER = TagData.createTagData("gt.dungeon.portal.aether");
    public static final TagData TAG_PORTAL_MYST = TagData.createTagData("gt.dungeon.portal.myst");
    public static final TagData TAG_WORKSHOP = TagData.createTagData("gt.dungeon.workshop");
    public static final TagData TAG_MINING_BEDROCK = TagData.createTagData("gt.dungeon.mining.bedrock");
    public static final TagData TAG_LIBRARY = TagData.createTagData("gt.dungeon.library");
    public static final TagData TAG_LIBRARY_NORMAL = TagData.createTagData("gt.dungeon.library.normal");
    public static final TagData TAG_LIBRARY_THAUM = TagData.createTagData("gt.dungeon.library.thaumcraft");
    public static final TagData TAG_LIBRARY_MYST = TagData.createTagData("gt.dungeon.library.mystcraft");
    public static final TagData TAG_FARM_MOBS = TagData.createTagData("gt.dungeon.farm.mobs");
    public static final TagData TAG_FARM_CROP = TagData.createTagData("gt.dungeon.farm.crop");
    public static final TagData TAG_FARM_FISH = TagData.createTagData("gt.dungeon.farm.fish");
    public static final List<IDungeonChunk> ROOMS = new ArrayListNoNulls<IDungeonChunk>(false, new DungeonChunkRoomWorkshop(), new DungeonChunkRoomMiningBedrock(), new DungeonChunkRoomLibraryNormal(), new DungeonChunkRoomLibraryMystcraft(), new DungeonChunkRoomLibraryThaumcraft(), new DungeonChunkRoomFarmMobs(), new DungeonChunkRoomFarmCrop(), new DungeonChunkRoomFarmFish());
    public static final List<IDungeonChunk> DEAD_END = new ArrayListNoNulls<IDungeonChunk>(false, new DungeonChunkRoomStorage(), new DungeonChunkRoomPortalNether(), new DungeonChunkRoomPortalEnd(), new DungeonChunkRoomPortalTwilight(), new DungeonChunkRoomPortalAether(), new DungeonChunkRoomPortalMyst());
    public int mProbability;
    public int mMinSize;
    public int mMaxSize;
    public int mMinY;
    public int mMaxY;
    public int mRoomChance;
    public boolean mPortalNether;
    public boolean mPortalEnd;
    public boolean mPortalTwilight;
    public boolean mPortalAether;
    public boolean mPortalMyst;
    public boolean mZPM;
    public HashSetNoNulls<TagData> mTags = new HashSetNoNulls();
    public static final int ROOM_ID_COUNT = 1;
    public static final int IMPORTANT_ROOM_COUNT = 2;

    @SafeVarargs
    public WorldgenDungeonGT(String aName, boolean aDefault, int aProbability, int aMinSize, int aMaxSize, int aMinY, int aMaxY, int aRoomChance, boolean aOverworld, boolean aNether, boolean aEnd, boolean aPortalNether, boolean aPortalEnd, boolean aPortalTwilight, boolean aPortalAether, boolean aPortalMyst, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mProbability = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Probability", (long)aProbability));
        this.mMinSize = Math.max(2, this.getConfigFile().get((Object)this.mCategory, "MinSize", (long)aMinSize));
        this.mMaxSize = Math.max(this.mMinSize, this.getConfigFile().get((Object)this.mCategory, "MaxSize", (long)aMaxSize));
        this.mMinY = Math.max(5, this.getConfigFile().get((Object)this.mCategory, "MinY", (long)aMinY));
        this.mMaxY = Math.max(this.mMinY, this.getConfigFile().get((Object)this.mCategory, "MaxY", (long)aMaxY));
        this.mRoomChance = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "RoomChance", (long)aRoomChance));
        this.mPortalNether = this.getConfigFile().get((Object)this.mCategory, "PortalNether", aPortalNether);
        this.mPortalEnd = this.getConfigFile().get((Object)this.mCategory, "PortalEnd", aPortalEnd);
        this.mPortalTwilight = this.getConfigFile().get((Object)this.mCategory, "PortalTwilight", aPortalTwilight);
        this.mPortalAether = this.getConfigFile().get((Object)this.mCategory, "PortalAether", aPortalAether);
        this.mPortalMyst = this.getConfigFile().get((Object)this.mCategory, "PortalMyst", aPortalMyst);
        this.mZPM = this.getConfigFile().get((Object)this.mCategory, "ZPMs", true);
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Workshop", true)) {
            this.mTags.add(TAG_WORKSHOP);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Mining.Bedrock", true)) {
            this.mTags.add(TAG_MINING_BEDROCK);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Library.Normal", true)) {
            this.mTags.add(TAG_LIBRARY_NORMAL);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Library.Thaumcraft", true)) {
            this.mTags.add(TAG_LIBRARY_THAUM);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Library.Mystcraft", true)) {
            this.mTags.add(TAG_LIBRARY_MYST);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Farming.Mobs", true)) {
            this.mTags.add(TAG_FARM_MOBS);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Farming.Crop", true)) {
            this.mTags.add(TAG_FARM_CROP);
        }
        if (!this.getConfigFile().get((Object)this.mCategory, "Room.Farming.Fish", true)) {
            this.mTags.add(TAG_FARM_FISH);
        }
    }

    public WorldgenDungeonGT() {
        this(null, false, 100, 3, 7, 20, 20, 6, false, false, false, false, false, false, false, false, new List[0]);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        int tConnectionCount;
        int j;
        int i;
        int i2;
        if (aRandom.nextInt(this.mProbability) != 0 || this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        if (Math.abs(aMinZ) < 256 + this.mMaxSize * 16 && Math.abs(aMinX) < 256 + this.mMaxSize * 16) {
            return false;
        }
        if (CS.GENERATE_STREETS && aWorld.field_73011_w.field_76574_g == 0 && (Math.abs(aMinX) < 256 + this.mMaxSize * 16 || Math.abs(aMinZ) < 256 + this.mMaxSize * 16)) {
            return false;
        }
        if (Math.abs(aMinX / 16) % (this.mMaxSize + 4) != (this.mMaxSize + 4) / 2 || Math.abs(aMinZ / 16) % (this.mMaxSize + 4) != (this.mMaxSize + 4) / 2 || !WD.bedrock(aWorld, aMinX + 8, 0, aMinZ + 8)) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        int tOffsetY = this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY));
        int tColor = aRandom.nextInt(16);
        BlockStones tPrimaryBlock = (BlockStones)CS.BlocksGT.stones[aRandom.nextInt(CS.BlocksGT.stones.length)];
        BlockStones tSecondaryBlock = (BlockStones)CS.BlocksGT.stones[aRandom.nextInt(CS.BlocksGT.stones.length)];
        HashSetNoNulls<ChunkCoordinates> tLightUpdateCoords = new HashSetNoNulls<ChunkCoordinates>();
        HashSetNoNulls<TagData> tTags = new HashSetNoNulls<TagData>(this.mTags);
        byte[][] tRoomLayout = new byte[2 + this.mMinSize + aRandom.nextInt(1 + this.mMaxSize - this.mMinSize)][2 + this.mMinSize + aRandom.nextInt(1 + this.mMaxSize - this.mMinSize)];
        boolean[] tGeneratedKeys = new boolean[5];
        if (!this.mPortalNether || aWorld.field_73011_w.field_76574_g != 0 && aWorld.field_73011_w.field_76574_g != -1) {
            tTags.add(TAG_PORTAL_NETHER);
        }
        if (!this.mPortalEnd || aWorld.field_73011_w.field_76574_g != 0 && aWorld.field_73011_w.field_76574_g != 1) {
            tTags.add(TAG_PORTAL_END);
        }
        if (!this.mPortalTwilight || !MD.TF.mLoaded || aWorld.field_73011_w.field_76574_g != 0 && !WD.dimTF(aWorld)) {
            tTags.add(TAG_PORTAL_TWILIGHT);
        }
        if (!this.mPortalAether || !MD.AETHER.mLoaded && !MD.AETHEL.mLoaded || aWorld.field_73011_w.field_76574_g != 0 && !WD.dimAETHER(aWorld)) {
            tTags.add(TAG_PORTAL_AETHER);
        }
        if (!this.mPortalMyst || !MD.MYST.mLoaded) {
            tTags.add(TAG_PORTAL_MYST);
        }
        long[] tKeyIDs = new long[tGeneratedKeys.length];
        tKeyIDs[0] = 1L + Math.max((long)CS.RNGSUS.nextInt(1000000), System.nanoTime());
        for (int i4 = 1; i4 < tKeyIDs.length; ++i4) {
            tKeyIDs[i4] = tKeyIDs[i4 - 1] - 1L;
        }
        ItemStack[] tKeyStacks = new ItemStack[tKeyIDs.length];
        for (int i3 = 0; i3 < tKeyIDs.length; ++i3) {
            tKeyStacks[i3] = IL.KEYS[aRandom.nextInt(IL.KEYS.length)].getWithNameAndNBT(1L, "Key #" + (i3 + 1), UT.NBT.makeLong("gt.key", tKeyIDs[i3]), new Object[0]);
        }
        aMinX -= tRoomLayout.length / 2 * 16;
        aMinZ -= tRoomLayout[0].length / 2 * 16;
        for (i2 = 0; i2 < tRoomLayout.length; ++i2) {
            for (int j3 = 0; j3 < tRoomLayout[i2].length; ++j3) {
                aWorld.func_147465_d(aMinX + 8 + i2 * 16, 254, aMinZ + 8 + j3 * 16, CS.NB, 0, 3);
            }
        }
        i2 = 0;
        int j2 = 0;
        int k = -1;
        for (int l = 0; k >= -2 && l < 10000; ++l) {
            i2 = 1 + aRandom.nextInt(tRoomLayout.length - 2);
            if (tRoomLayout[i2][j2 = 1 + aRandom.nextInt(tRoomLayout[i2].length - 2)] != 0) continue;
            tRoomLayout[i2][j2] = (byte)k--;
        }
        int tRoomCount = 0;
        while (tRoomCount < 2) {
            for (int i22 = 1; i22 < tRoomLayout.length - 1; ++i22) {
                for (int j22 = 1; j22 < tRoomLayout[i22].length - 1; ++j22) {
                    if (tRoomLayout[i22][j22] != 0 || aRandom.nextInt(this.mRoomChance) != 0) continue;
                    tRoomLayout[i22][j22] = (byte)(1 + aRandom.nextInt(1));
                    ++tRoomCount;
                }
            }
        }
        for (int i3 = 1; i3 < tRoomLayout.length - 1; ++i3) {
            for (int j3 = 1; j3 < tRoomLayout[i3].length - 1; ++j3) {
                if (tRoomLayout[i3][j3] == 0) continue;
                int a = i3;
                int b = j3;
                while (a != tRoomLayout.length / 2 && tRoomLayout[a += a > tRoomLayout.length / 2 ? -1 : 1][b] == 0) {
                    tRoomLayout[a][b] = -128;
                }
                while (b != tRoomLayout[a].length / 2 && tRoomLayout[a][b += b > tRoomLayout[a].length / 2 ? -1 : 1] == 0) {
                    tRoomLayout[a][b] = -128;
                }
            }
        }
        NBTTagCompound tCoin = MultiTileEntityCoin.COIN_MAP.get(UT.Code.select(MT.NULL, MT.Cu, MT.Cu, MT.Cu, MT.Ag, MT.Ag, MT.Au, MT.Au, MT.Pt)).func_77978_p();
        tCoin = tCoin == null ? UT.NBT.make() : (NBTTagCompound)tCoin.func_74737_b();
        boolean temp = true;
        while (temp) {
            temp = false;
            for (i = 1; i < tRoomLayout.length - 1; ++i) {
                for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                    if (tRoomLayout[i][j] != -128 || tRoomLayout[i + 1][j] != 0 && tRoomLayout[i - 1][j] != 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i][j + 1] == 0 || tRoomLayout[i + 1][j] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i][j + 1] != 0) continue;
                    tConnectionCount = 0;
                    for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                        if (tRoomLayout[i + CS.OFFX[tSide]][j + CS.OFFZ[tSide]] == 0) continue;
                        ++tConnectionCount;
                    }
                    if (tConnectionCount <= 1) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j - 1] != 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j + 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] != 0 && tRoomLayout[i - 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] == 0 || tRoomLayout[i - 1][j - 1] == 0 || tRoomLayout[i][j - 1] == 0 || tRoomLayout[i + 1][j] != 0 || tRoomLayout[i][j + 1] != 0) continue;
                    tRoomLayout[i][j] = 0;
                    temp = true;
                }
            }
        }
        temp = true;
        while (temp) {
            temp = false;
            for (i = 1; i < tRoomLayout.length - 1; ++i) {
                for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                    if (tRoomLayout[i][j] != -128 || tRoomLayout[i + 1][j] != 0 && tRoomLayout[i - 1][j] != 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i][j + 1] == 0 || tRoomLayout[i + 1][j] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i][j + 1] != 0) continue;
                    tConnectionCount = 0;
                    for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                        if (tRoomLayout[i + CS.OFFX[tSide]][j + CS.OFFZ[tSide]] == 0) continue;
                        ++tConnectionCount;
                    }
                    if (tConnectionCount <= 1) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i + 1][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tConnectionCount >= 7) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tConnectionCount == 5) {
                        if (tRoomLayout[i + 1][j - 1] == 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i + 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j - 1] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i - 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j + 1] == 0 && tRoomLayout[i][j + 1] == 0 && tRoomLayout[i + 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j - 1] == 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i + 1][j - 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j - 1] != 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j + 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] != 0 && tRoomLayout[i - 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] == 0 || tRoomLayout[i - 1][j - 1] == 0 || tRoomLayout[i][j - 1] == 0 || tRoomLayout[i + 1][j] != 0 || tRoomLayout[i][j + 1] != 0) continue;
                    tRoomLayout[i][j] = 0;
                    temp = true;
                }
            }
        }
        for (i = 1; i < tRoomLayout.length - 1; ++i) {
            for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                if (tRoomLayout[i][j] <= 0) continue;
                aWorld.func_72964_e((aMinX >> 4) + i, (aMinZ >> 4) + j).func_76630_e();
                tConnectionCount = 0;
                for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                    if (tRoomLayout[i + CS.OFFX[tSide]][j + CS.OFFZ[tSide]] == 0) continue;
                    ++tConnectionCount;
                }
                DungeonData dungeonData = new DungeonData(aWorld, aMinX + i * 16, tOffsetY, aMinZ + j * 16, this, tPrimaryBlock, tSecondaryBlock, tRegistry, tLightUpdateCoords, tTags, tKeyIDs, tKeyStacks, tGeneratedKeys, tRoomLayout, i, j, tConnectionCount, tColor, aRandom, tCoin);
                block7 : switch (tRoomLayout[i][j]) {
                    case 1: {
                        if (dungeonData.mConnectionCount == 1) {
                            ArrayListNoNulls<IDungeonChunk> tList = new ArrayListNoNulls<IDungeonChunk>(DEAD_END);
                            while (true) {
                                try {
                                    if (((IDungeonChunk)tList.remove(aRandom.nextInt(tList.size()))).generate(dungeonData)) {
                                        break block7;
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace(CS.ERR);
                                }
                                try {
                                    if (!tList.isEmpty() || !ROOM_EMPTY.generate(dungeonData)) continue;
                                    break block7;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace(CS.ERR);
                                    continue;
                                }
                                break;
                            }
                        }
                        ArrayListNoNulls<IDungeonChunk> tList = new ArrayListNoNulls<IDungeonChunk>(ROOMS);
                        while (true) {
                            try {
                                if (((IDungeonChunk)tList.remove(aRandom.nextInt(tList.size()))).generate(dungeonData)) {
                                    break block7;
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace(CS.ERR);
                            }
                            try {
                                if (!tList.isEmpty() || !ROOM_EMPTY.generate(dungeonData)) continue;
                                break block7;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(CS.ERR);
                                continue;
                            }
                            break;
                        }
                    }
                }
                aWorld.func_72964_e((aMinX >> 4) + i, (aMinZ >> 4) + j).func_76630_e();
            }
        }
        for (i = 1; i < tRoomLayout.length - 1; ++i) {
            for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                if (tRoomLayout[i][j] >= 0) continue;
                aWorld.func_72964_e((aMinX >> 4) + i, (aMinZ >> 4) + j).func_76630_e();
                tConnectionCount = 0;
                for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                    if (tRoomLayout[i + CS.OFFX[tSide]][j + CS.OFFZ[tSide]] == 0) continue;
                    ++tConnectionCount;
                }
                DungeonData dungeonData = new DungeonData(aWorld, aMinX + i * 16, tOffsetY, aMinZ + j * 16, this, tPrimaryBlock, tSecondaryBlock, tRegistry, tLightUpdateCoords, tTags, tKeyIDs, tKeyStacks, tGeneratedKeys, tRoomLayout, i, j, tConnectionCount, tColor, aRandom, tCoin);
                switch (tRoomLayout[i][j]) {
                    case -128: {
                        try {
                            if (tConnectionCount == 4) {
                                CORRIDOR4.generate(dungeonData);
                                break;
                            }
                            if (tConnectionCount == 3) {
                                CORRIDOR3.generate(dungeonData);
                                break;
                            }
                            CORRIDOR.generate(dungeonData);
                        }
                        catch (Throwable e) {
                            e.printStackTrace(CS.ERR);
                        }
                        break;
                    }
                    case -2: {
                        try {
                            ENTRANCE.generate(dungeonData);
                        }
                        catch (Throwable e) {
                            e.printStackTrace(CS.ERR);
                        }
                        break;
                    }
                    case -1: {
                        try {
                            BARRACKS.generate(dungeonData);
                            break;
                        }
                        catch (Throwable e) {
                            e.printStackTrace(CS.ERR);
                        }
                    }
                }
                aWorld.func_72964_e((aMinX >> 4) + i, (aMinZ >> 4) + j).func_76630_e();
            }
        }
        for (ChunkCoordinates tCoords : tLightUpdateCoords) {
            aWorld.func_72915_b(EnumSkyBlock.Block, tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, 15);
            for (byte tSide : CS.ALL_SIDES_MIDDLE) {
                aWorld.func_147451_t(tCoords.field_71574_a + CS.OFFX[tSide], tCoords.field_71572_b + CS.OFFY[tSide], tCoords.field_71573_c + CS.OFFZ[tSide]);
                WD.update((IBlockAccess)aWorld, tCoords.field_71574_a + CS.OFFX[tSide], tCoords.field_71572_b + CS.OFFY[tSide], tCoords.field_71573_c + CS.OFFZ[tSide]);
            }
        }
        return true;
    }

    public static boolean setRandomBricks(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 3 + aRandom.nextInt(3), 2);
    }

    public static boolean setStandardBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 3, 2);
    }

    public static boolean setRedstoneBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 9, 3);
    }

    public static boolean setCrackedBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 4, 2);
    }

    public static boolean setMossyBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 5, 2);
    }

    public static boolean setChiseledStone(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 6, 2);
    }

    public static boolean setStoneTiles(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 10, 2);
    }

    public static boolean setSmallTiles(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 11, 2);
    }

    public static boolean setSmallBricks(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 12, 2);
    }

    public static boolean setSmoothBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mY + 2 ? aSecondary : aPrimary, 7, 2);
    }

    public static boolean setAirBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
    }

    public static boolean setRandomBricks(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 3 + aRandom.nextInt(3), 2);
    }

    public static boolean setStandardBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 3, 2);
    }

    public static boolean setRedstoneBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 9, 3);
    }

    public static boolean setCrackedBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 4, 2);
    }

    public static boolean setMossyBrick(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 5, 2);
    }

    public static boolean setChiseledStone(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 6, 2);
    }

    public static boolean setStoneTiles(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 10, 2);
    }

    public static boolean setSmallTiles(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 11, 2);
    }

    public static boolean setSmallBricks(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 12, 2);
    }

    public static boolean setSmoothBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mY + 2 ? aData.mSecondary : aData.mPrimary), 7, 2);
    }

    public static boolean setAirBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
    }

    public static boolean setGlass(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Glass, (int)aData.mColor, 2);
    }

    public static boolean setGlowGlass(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.GlowGlass, (int)aData.mColor, 2);
    }

    public static boolean setColored(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Concrete, (int)aData.mColor, 2);
    }

    public static boolean setLampBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Block aPrimary, Block aSecondary, Random aRandom, int aGenerateRedstoneBrick) {
        aData.mLightUpdateCoords.add(new ChunkCoordinates(aX, aY, aZ));
        if (aGenerateRedstoneBrick != 0) {
            WorldgenDungeonGT.setRedstoneBrick(aWorld, aX, aY + aGenerateRedstoneBrick, aZ, aData, aRandom);
        }
        aWorld.func_147465_d(aX, aY, aZ, aGenerateRedstoneBrick == 0 ? Blocks.field_150379_bu : Blocks.field_150374_bv, 0, 2);
        return true;
    }

    public static boolean setLampBlock(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom, int aGenerateRedstoneBrick) {
        aData.mLightUpdateCoords.add(new ChunkCoordinates(aX, aY, aZ));
        if (aGenerateRedstoneBrick != 0) {
            WorldgenDungeonGT.setRedstoneBrick(aWorld, aX, aY + aGenerateRedstoneBrick, aZ, aData, aRandom);
        }
        aWorld.func_147465_d(aX, aY, aZ, aGenerateRedstoneBrick == 0 ? Blocks.field_150379_bu : Blocks.field_150374_bv, 0, 2);
        return true;
    }

    public static boolean setCoins(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        for (int i = 0; i < 16; ++i) {
            aData.mCoin.func_74774_a("gt.coin.stacksize." + i, (byte)(aRandom.nextInt(3) == 0 ? aRandom.nextInt(8) : 0));
        }
        aData.mCoin.func_74774_a("gt.coin.stacksize." + aRandom.nextInt(16), (byte)(1 + aRandom.nextInt(8)));
        aData.mMTERegistryGT.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, (short)32700, aData.mCoin, true, true);
        return true;
    }

    public static boolean setFlower(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        int tIndex = aRandom.nextInt(CS.BlocksGT.FLOWER_TILES.length);
        aWorld.func_147465_d(aX, aY, aZ, CS.BlocksGT.FLOWER_TILES[tIndex], (int)CS.BlocksGT.FLOWER_METAS[tIndex], 2);
        return true;
    }

    public static boolean setFlowerPot(World aWorld, int aX, int aY, int aZ, DungeonData aData, Random aRandom) {
        int tIndex = aRandom.nextInt(CS.BlocksGT.POT_FLOWER_TILES.length);
        aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150457_bL, 0, 2);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof TileEntityFlowerPot) {
            ((TileEntityFlowerPot)tTileEntity).func_145964_a(Item.func_150898_a((Block)CS.BlocksGT.POT_FLOWER_TILES[tIndex]), (int)CS.BlocksGT.POT_FLOWER_METAS[tIndex]);
        }
        return true;
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
        aWorld.func_147465_d(aX, aY, aZ, aBlock, aMeta, aFlags);
        return true;
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags, int aRotationCount) {
        aWorld.func_147465_d(aX, aY, aZ, aBlock, aMeta, aFlags);
        while (aRotationCount-- > 0) {
            aBlock.rotateBlock(aWorld, aX, aY, aZ, CS.FORGE_DIR[1]);
        }
        return true;
    }
}

