/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import gregapi.GT_API;
import gregapi.block.IBlockDebugable;
import gregapi.block.IBlockExtendedMetaData;
import gregapi.block.IBlockPlacable;
import gregapi.block.IBlockTileEntity;
import gregapi.block.metatype.BlockMetaType;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.TD;
import gregapi.event.BlockScanningEvent;
import gregapi.item.IItemGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.blocks.fluids.BlockWaterlike;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.nodes.INode;
import twilightforest.TwilightForestMod;

public class WD {
    public static byte WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD = 0;

    public static ItemStack suck(IHasWorldAndCoords aCoordinates) {
        return WD.suck(aCoordinates.getWorld(), aCoordinates.getX(), aCoordinates.getY(), aCoordinates.getZ());
    }

    public static ItemStack suck(World aWorld, double aX, double aY, double aZ) {
        return WD.suck(aWorld, aX, aY, aZ, 1.0, 1.0, 1.0);
    }

    public static ItemStack suck(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        for (EntityItem tItem : aWorld.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
            if (tItem.field_70128_L) continue;
            aWorld.func_72900_e((Entity)tItem);
            ItemStack rStack = tItem.func_92059_d();
            tItem.func_92058_a(ST.amount(0L, rStack));
            tItem.func_70106_y();
            return rStack;
        }
        return null;
    }

    public static List<ItemStack> suckAll(IHasWorldAndCoords aCoordinates) {
        return WD.suckAll(aCoordinates.getWorld(), aCoordinates.getX(), aCoordinates.getY(), aCoordinates.getZ());
    }

    public static List<ItemStack> suckAll(World aWorld, double aX, double aY, double aZ) {
        return WD.suckAll(aWorld, aX, aY, aZ, 1.0, 1.0, 1.0);
    }

    public static List<ItemStack> suckAll(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        List tList = aWorld.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)));
        if (tList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayListNoNulls<ItemStack> rOutput = ST.arraylist(new ItemStack[0]);
        for (EntityItem tItem : tList) {
            if (tItem.field_70128_L) continue;
            aWorld.func_72900_e((Entity)tItem);
            ItemStack rStack = tItem.func_92059_d();
            tItem.func_92058_a(ST.amount(0L, rStack));
            tItem.func_70106_y();
            rOutput.add(rStack);
        }
        return rOutput;
    }

    public static boolean obstructed(World aWorld, int aX, int aY, int aZ, byte aSide) {
        Block tBlock;
        if (!CS.OBSTRUCTION_CHECKS) {
            return false;
        }
        TileEntity tTileEntity = WD.te(aWorld, aX += CS.OFFX[aSide], aY += CS.OFFY[aSide], aZ += CS.OFFZ[aSide], true);
        if (tTileEntity != null) {
            if (tTileEntity instanceof ITileEntityQuickObstructionCheck) {
                return ((ITileEntityQuickObstructionCheck)tTileEntity).isObstructingBlockAt(CS.OPOS[aSide]);
            }
            if (MD.TC.mLoaded && tTileEntity instanceof INode) {
                return false;
            }
        }
        if ((tBlock = aWorld.func_147439_a(aX, aY, aZ)) instanceof BlockTrapDoor || tBlock instanceof BlockDoor || tBlock instanceof BlockLadder) {
            return false;
        }
        AxisAlignedBB tBoundingBox = tBlock.func_149668_a(aWorld, aX, aY, aZ);
        if (tBoundingBox == null) {
            return false;
        }
        switch (aSide) {
            case 0: {
                return tBoundingBox.field_72337_e - (double)aY > (double)CS.PX_N[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PX_P[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PX_N[2] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PX_N[2];
            }
            case 1: {
                return tBoundingBox.field_72338_b - (double)aY < (double)CS.PX_P[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PX_P[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PX_N[2] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PX_N[2];
            }
            case 2: {
                return tBoundingBox.field_72334_f - (double)aZ > (double)CS.PX_N[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PX_P[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PX_N[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PX_P[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PX_N[2];
            }
            case 3: {
                return tBoundingBox.field_72339_c - (double)aZ < (double)CS.PX_P[4] && tBoundingBox.field_72336_d - (double)aX > (double)CS.PX_P[2] && tBoundingBox.field_72340_a - (double)aX < (double)CS.PX_N[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PX_P[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PX_N[2];
            }
            case 4: {
                return tBoundingBox.field_72336_d - (double)aX > (double)CS.PX_N[4] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PX_N[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PX_P[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PX_N[2];
            }
            case 5: {
                return tBoundingBox.field_72340_a - (double)aX < (double)CS.PX_P[4] && tBoundingBox.field_72334_f - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.field_72339_c - (double)aZ < (double)CS.PX_N[2] && tBoundingBox.field_72337_e - (double)aY > (double)CS.PX_P[2] && tBoundingBox.field_72338_b - (double)aY < (double)CS.PX_N[2];
            }
        }
        return false;
    }

    public static MovingObjectPosition getMOP(World aWorld, EntityPlayer aPlayer, boolean aFlag) {
        Vec3 vec3 = Vec3.func_72443_a((double)(aPlayer.field_70169_q + (aPlayer.field_70165_t - aPlayer.field_70169_q)), (double)(aPlayer.field_70167_r + (aPlayer.field_70163_u - aPlayer.field_70167_r) + (double)(aWorld.field_72995_K ? aPlayer.func_70047_e() - aPlayer.getDefaultEyeHeight() : aPlayer.func_70047_e())), (double)(aPlayer.field_70166_s + (aPlayer.field_70161_v - aPlayer.field_70166_s)));
        float tPitch = aPlayer.field_70127_C + (aPlayer.field_70125_A - aPlayer.field_70127_C);
        float tYaw = aPlayer.field_70126_B + (aPlayer.field_70177_z - aPlayer.field_70126_B);
        float tZ = MathHelper.func_76134_b((float)(-tYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float tX = MathHelper.func_76126_a((float)(-tYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float tW = -MathHelper.func_76134_b((float)(-tPitch * ((float)Math.PI / 180)));
        float tY = MathHelper.func_76126_a((float)(-tPitch * ((float)Math.PI / 180)));
        double tReach = aPlayer instanceof EntityPlayerMP ? ((EntityPlayerMP)aPlayer).field_71134_c.getBlockReachDistance() : 5.0;
        return aWorld.func_147447_a(vec3, vec3.func_72441_c((double)(tX * tW) * tReach, (double)tY * tReach, (double)(tZ * tW) * tReach), aFlag, !aFlag, false);
    }

    public static boolean dimOverworldLike(World aWorld) {
        return aWorld != null && WD.dimOverworldLike(aWorld.field_73011_w);
    }

    public static boolean dimOverworldLike(WorldProvider aProvider) {
        return aProvider.field_76574_g == 0 || WD.dimOverworldLike(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimOverworldLike(WorldProvider aProvider, String aProviderClassName) {
        return aProvider.field_76574_g == 0 || WD.dimENVM(aProvider, aProviderClassName) || WD.dimA97(aProvider, aProviderClassName) || WD.dimWTCH(aProvider, aProviderClassName) || WD.dimMYST(aProvider, aProviderClassName) || WD.dimCW2(aProvider, aProviderClassName);
    }

    public static boolean dimPlanet(World aWorld) {
        return aWorld != null && WD.dimPlanet(aWorld.field_73011_w);
    }

    public static boolean dimPlanet(WorldProvider aProvider) {
        return Math.abs(aProvider.field_76574_g) > 1 && WD.dimPlanet(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimPlanet(WorldProvider aProvider, String aProviderClassName) {
        return Math.abs(aProvider.field_76574_g) > 1 && !WD.dimMYST(aProvider, aProviderClassName) && !WD.dimATUM(aProvider, aProviderClassName) && !WD.dimWTCH(aProvider, aProviderClassName) && !WD.dimA97(aProvider, aProviderClassName) && !WD.dimCW2(aProvider, aProviderClassName) && !WD.dimTF(aProvider, aProviderClassName) && !WD.dimERE(aProvider, aProviderClassName) && !WD.dimBTL(aProvider, aProviderClassName) && !WD.dimENVM(aProvider, aProviderClassName) && !WD.dimDD(aProvider, aProviderClassName) && !WD.dimLM(aProvider, aProviderClassName) && !WD.dimAETHER(aProvider, aProviderClassName) && !WD.dimALF(aProvider, aProviderClassName) && !WD.dimTROPIC(aProvider, aProviderClassName) && !WD.dimCANDY(aProvider, aProviderClassName);
    }

    public static boolean dimMYST(World aWorld) {
        return aWorld != null && WD.dimMYST(aWorld.field_73011_w);
    }

    public static boolean dimMYST(WorldProvider aProvider) {
        return MD.MYST.mLoaded && aProvider.getClass().getName().toLowerCase().contains("com.xcompwiz.mystcraft");
    }

    public static boolean dimMYST(WorldProvider aProvider, String aProviderClassName) {
        return MD.MYST.mLoaded && aProvider.getClass().getName().toLowerCase().contains("com.xcompwiz.mystcraft");
    }

    public static boolean dimCANDY(World aWorld) {
        return aWorld != null && WD.dimCANDY(aWorld.field_73011_w);
    }

    public static boolean dimCANDY(WorldProvider aProvider) {
        return MD.CANDY.mLoaded && WD.dimCANDY(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCANDY(WorldProvider aProvider, String aProviderClassName) {
        return MD.CANDY.mLoaded && "WorldProviderCandy".equalsIgnoreCase(UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimTROPIC(World aWorld) {
        return aWorld != null && WD.dimTROPIC(aWorld.field_73011_w);
    }

    public static boolean dimTROPIC(WorldProvider aProvider) {
        return MD.TROPIC.mLoaded && WD.dimTROPIC(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimTROPIC(WorldProvider aProvider, String aProviderClassName) {
        return MD.TROPIC.mLoaded && "WorldProviderTropicraft".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimATUM(World aWorld) {
        return aWorld != null && WD.dimATUM(aWorld.field_73011_w);
    }

    public static boolean dimATUM(WorldProvider aProvider) {
        return MD.ATUM.mLoaded && WD.dimATUM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimATUM(WorldProvider aProvider, String aProviderClassName) {
        return MD.ATUM.mLoaded && "AtumWorldProvider".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimTF(World aWorld) {
        return aWorld != null && WD.dimTF(aWorld.field_73011_w);
    }

    public static boolean dimTF(WorldProvider aProvider) {
        return MD.TF.mLoaded && aProvider.field_76574_g == TwilightForestMod.dimensionID;
    }

    public static boolean dimTF(WorldProvider aProvider, String aProviderClassName) {
        return MD.TF.mLoaded && aProvider.field_76574_g == TwilightForestMod.dimensionID;
    }

    public static boolean dimBTL(World aWorld) {
        return aWorld != null && WD.dimBTL(aWorld.field_73011_w);
    }

    public static boolean dimBTL(WorldProvider aProvider) {
        return MD.BTL.mLoaded && WD.dimBTL(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimBTL(WorldProvider aProvider, String aProviderClassName) {
        return MD.BTL.mLoaded && "WorldProviderBetweenlands".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimERE(World aWorld) {
        return aWorld != null && WD.dimERE(aWorld.field_73011_w);
    }

    public static boolean dimERE(WorldProvider aProvider) {
        return MD.ERE.mLoaded && WD.dimERE(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimERE(WorldProvider aProvider, String aProviderClassName) {
        return MD.ERE.mLoaded && "WorldProviderErebus".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimALF(World aWorld) {
        return aWorld != null && WD.dimALF(aWorld.field_73011_w);
    }

    public static boolean dimALF(WorldProvider aProvider) {
        return MD.ALF.mLoaded && WD.dimALF(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimALF(WorldProvider aProvider, String aProviderClassName) {
        return MD.ALF.mLoaded && "WorldProviderAlfheim".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimDD(World aWorld) {
        return aWorld != null && WD.dimDD(aWorld.field_73011_w);
    }

    public static boolean dimDD(WorldProvider aProvider) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && WD.dimDD(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimDD(WorldProvider aProvider, String aProviderClassName) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && "WorldProviderUnderdark".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimLM(World aWorld) {
        return aWorld != null && WD.dimLM(aWorld.field_73011_w);
    }

    public static boolean dimLM(WorldProvider aProvider) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && WD.dimLM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimLM(WorldProvider aProvider, String aProviderClassName) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && "WorldProviderEndOfTime".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimENVM(World aWorld) {
        return aWorld != null && WD.dimENVM(aWorld.field_73011_w);
    }

    public static boolean dimENVM(WorldProvider aProvider) {
        return MD.ENVM.mLoaded && WD.dimENVM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimENVM(WorldProvider aProvider, String aProviderClassName) {
        return MD.ENVM.mLoaded && "WorldProviderCaves".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimA97(World aWorld) {
        return aWorld != null && WD.dimA97(aWorld.field_73011_w);
    }

    public static boolean dimA97(WorldProvider aProvider) {
        return MD.A97_MINING.mLoaded && WD.dimA97(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimA97(WorldProvider aProvider, String aProviderClassName) {
        return MD.A97_MINING.mLoaded && "WorldProviderMiner".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2(World aWorld) {
        return aWorld != null && WD.dimCW2(aWorld.field_73011_w);
    }

    public static boolean dimCW2(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2(WorldProvider aProvider, String aProviderClassName) {
        return WD.dimCW2AquaCavern(aProvider, aProviderClassName) || WD.dimCW2Caveland(aProvider, aProviderClassName) || WD.dimCW2Cavenia(aProvider, aProviderClassName) || WD.dimCW2Cavern(aProvider, aProviderClassName) || WD.dimCW2Caveworld(aProvider, aProviderClassName);
    }

    public static boolean dimCW2AquaCavern(World aWorld) {
        return aWorld != null && WD.dimCW2AquaCavern(aWorld.field_73011_w);
    }

    public static boolean dimCW2AquaCavern(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2AquaCavern(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2AquaCavern(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderAquaCavern".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Caveland(World aWorld) {
        return aWorld != null && WD.dimCW2Caveland(aWorld.field_73011_w);
    }

    public static boolean dimCW2Caveland(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Caveland(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Caveland(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCaveland".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Cavenia(World aWorld) {
        return aWorld != null && WD.dimCW2Cavenia(aWorld.field_73011_w);
    }

    public static boolean dimCW2Cavenia(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Cavenia(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Cavenia(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCavenia".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Cavern(World aWorld) {
        return aWorld != null && WD.dimCW2Cavern(aWorld.field_73011_w);
    }

    public static boolean dimCW2Cavern(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Cavern(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Cavern(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCavern".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Caveworld(World aWorld) {
        return aWorld != null && WD.dimCW2Caveworld(aWorld.field_73011_w);
    }

    public static boolean dimCW2Caveworld(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Caveworld(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Caveworld(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCaveworld".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimWTCH(World aWorld) {
        return aWorld != null && WD.dimWTCH(aWorld.field_73011_w);
    }

    public static boolean dimWTCH(WorldProvider aProvider) {
        return MD.WTCH.mLoaded && WD.dimWTCH(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimWTCH(WorldProvider aProvider, String aProviderClassName) {
        return MD.WTCH.mLoaded && "WorldProviderDreamWorld".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimAETHER(World aWorld) {
        return aWorld != null && WD.dimAETHER(aWorld.field_73011_w);
    }

    public static boolean dimAETHER(WorldProvider aProvider) {
        return (MD.AETHER.mLoaded || MD.AETHEL.mLoaded) && WD.dimAETHER(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimAETHER(WorldProvider aProvider, String aProviderClassName) {
        return MD.AETHEL.mLoaded ? "AetherWorldProvider".equalsIgnoreCase(aProviderClassName) : MD.AETHER.mLoaded && "WorldProviderAether".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean move(Entity aEntity, int aDimension, double aX, double aY, double aZ) {
        WorldServer tTargetWorld = DimensionManager.getWorld((int)aDimension);
        WorldServer tOriginalWorld = DimensionManager.getWorld((int)aEntity.field_70170_p.field_73011_w.field_76574_g);
        if (tTargetWorld != null && tOriginalWorld != null && tTargetWorld != tOriginalWorld) {
            if (aEntity.field_70154_o != null) {
                aEntity.func_70078_a(null);
            }
            if (aEntity.field_70153_n != null) {
                aEntity.field_70153_n.func_70078_a(null);
            }
            if (aEntity instanceof EntityPlayerMP) {
                EntityPlayerMP aPlayer = (EntityPlayerMP)aEntity;
                aPlayer.field_71093_bK = aDimension;
                aPlayer.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(aPlayer.field_71093_bK, aPlayer.field_70170_p.field_73013_u, aPlayer.field_70170_p.func_72912_H().func_76067_t(), aPlayer.field_71134_c.func_73081_b()));
                tOriginalWorld.func_72973_f((Entity)aPlayer);
                aPlayer.field_70128_L = false;
                aPlayer.func_70029_a((World)tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72375_a(aPlayer, tOriginalWorld);
                aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                aPlayer.field_71134_c.func_73080_a(tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72354_b(aPlayer, tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72385_f(aPlayer);
                for (PotionEffect potioneffect : aPlayer.func_70651_bq()) {
                    aPlayer.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(aPlayer.func_145782_y(), potioneffect));
                }
                aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)aPlayer, tOriginalWorld.field_73011_w.field_76574_g, aDimension);
            } else {
                aEntity.func_70107_b(aX + 0.5, aY + 0.5, aZ + 0.5);
                aEntity.field_70170_p.func_72900_e(aEntity);
                aEntity.field_71093_bK = aDimension;
                aEntity.field_70128_L = false;
                Entity tNewEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)aEntity), (World)tTargetWorld);
                if (tNewEntity != null) {
                    tNewEntity.func_82141_a(aEntity, true);
                    aEntity.func_70106_y();
                    tNewEntity.field_70128_L = false;
                    boolean temp = tNewEntity.field_98038_p;
                    tNewEntity.field_98038_p = true;
                    tTargetWorld.func_72838_d(tNewEntity);
                    tNewEntity.field_98038_p = temp;
                    tNewEntity.field_70128_L = false;
                    aEntity = tNewEntity;
                }
            }
            if (aEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)aEntity).func_70634_a(aX, aY, aZ);
            } else {
                aEntity.func_70107_b(aX, aY, aZ);
            }
            tOriginalWorld.func_82742_i();
            tTargetWorld.func_82742_i();
            return true;
        }
        return false;
    }

    public static boolean mark(World aWorld, int aX, int aZ) {
        if (aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        Chunk aChunk = aWorld.func_72938_d(aX, aZ);
        if (aChunk == null) {
            aWorld.func_72805_g(aX, 0, aZ);
            aChunk = aWorld.func_72938_d(aX, aZ);
            if (aChunk == null) {
                CS.ERR.println("Some important Chunk does not exist for some reason at Coordinates X: " + aX + " and Z: " + aZ);
                return false;
            }
        }
        aChunk.func_76630_e();
        return true;
    }

    public static boolean mark(Object aTileEntity) {
        return aTileEntity instanceof TileEntity && WD.mark(((TileEntity)aTileEntity).func_145831_w(), ((TileEntity)aTileEntity).field_145851_c, ((TileEntity)aTileEntity).field_145849_e);
    }

    public static DelegatorTileEntity<TileEntity> te(World aWorld, ChunkCoordinates aCoords, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.te(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, aSide, aLoadUnloadedChunks);
    }

    public static DelegatorTileEntity<TileEntity> te(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, aLoadUnloadedChunks);
        return aTileEntity instanceof ITileEntityDelegating ? ((ITileEntityDelegating)aTileEntity).getDelegateTileEntity(aSide) : new DelegatorTileEntity<TileEntity>(aTileEntity, aWorld, aX, aY, aZ, aSide);
    }

    public static TileEntity te(World aWorld, ChunkCoordinates aCoords, boolean aLoadUnloadedChunks) {
        return WD.te(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, aLoadUnloadedChunks);
    }

    public static TileEntity te(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        if (aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ)) {
            TileEntity rTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (rTileEntity instanceof ITileEntityUnloadable && ((ITileEntityUnloadable)rTileEntity).isDead()) {
                return null;
            }
            if (rTileEntity != null) {
                return rTileEntity;
            }
            rTileEntity = CS.LAST_BROKEN_TILEENTITY.get();
            if (rTileEntity != null && rTileEntity.field_145851_c == aX && rTileEntity.field_145848_d == aY && rTileEntity.field_145849_e == aZ) {
                return rTileEntity;
            }
            Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
            return tBlock instanceof IBlockTileEntity ? ((IBlockTileEntity)tBlock).getTileEntity((IBlockAccess)aWorld, aX, aY, aZ) : null;
        }
        return null;
    }

    public static TileEntity invalidateTileEntityWithNegativeYCoord(int aX, int aY, int aZ, TileEntity aTileEntity) {
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD == 0) {
            UT.Entities.chat(null, "Please provide the gregtech.log File to Greg, there was a weird Error");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD < 10) {
            CS.ERR.println("===============================");
            CS.ERR.println("X:" + aX);
            CS.ERR.println("Y:" + aY);
            CS.ERR.println("Z:" + aZ);
            CS.ERR.println("Class:" + aTileEntity.getClass());
            new Throwable().printStackTrace(CS.ERR);
            CS.ERR.println("===============================");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD == 9) {
            UT.Entities.chat(null, "Please provide the gregtech.log File to Greg, there was a LOT of weird Errors");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD < 99) {
            WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD = (byte)(WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD + 1);
        }
        aTileEntity.func_145843_s();
        aTileEntity.field_145848_d = 0;
        return aTileEntity;
    }

    public static TileEntity te(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
        if (aY < 0) {
            return WD.invalidateTileEntityWithNegativeYCoord(aX, aY, aZ, aTileEntity);
        }
        if (aCauseTileEntityUpdates) {
            aWorld.func_147455_a(aX, aY, aZ, aTileEntity);
        } else {
            Chunk tChunk = aWorld.func_72964_e(aX >> 4, aZ >> 4);
            if (tChunk != null) {
                aWorld.addTileEntity(aTileEntity);
                tChunk.func_150812_a(aX & 0xF, aY, aZ & 0xF, aTileEntity);
                tChunk.func_76630_e();
            }
        }
        return aTileEntity;
    }

    public static boolean oxygen(World aWorld, int aX, int aY, int aZ) {
        return !MD.GC.mLoaded || !(aWorld.field_73011_w instanceof IGalacticraftWorldProvider) || OxygenUtil.checkTorchHasOxygen((World)aWorld, (Block)CS.NB, (int)aX, (int)aY, (int)aZ);
    }

    public static boolean collectable_air(World aWorld, int aX, int aY, int aZ) {
        return (!MD.GC.mLoaded || !(aWorld.field_73011_w instanceof IGalacticraftWorldProvider)) && !WD.hasCollide(aWorld, aX, aY, aZ) && !WD.liquid(aWorld, aX, aY, aZ);
    }

    public static long envTemp(World aWorld, int aX, int aY, int aZ) {
        return WD.envTemp(aWorld.func_72807_a(aX, aZ), aX, aY, aZ);
    }

    public static long envTemp(BiomeGenBase aBiome, int aX, int aY, int aZ) {
        return Math.max(1L, aBiome == null ? 293L : (long)(270.0f + aBiome.func_150564_a(aX, aY, aZ) * 20.0f));
    }

    public static long envTemp(BiomeGenBase aBiome) {
        return Math.max(1L, aBiome == null ? 293L : (long)(270.0f + aBiome.field_76750_F * 20.0f));
    }

    public static int waterLevel(World aWorld) {
        return WD.waterLevel(aWorld.field_73011_w, 62);
    }

    public static int waterLevel(WorldProvider aProvider) {
        return WD.waterLevel(aProvider, 62);
    }

    public static int waterLevel(World aWorld, int aDefaultOverworld) {
        return WD.waterLevel(aWorld.field_73011_w, aDefaultOverworld);
    }

    public static int waterLevel(WorldProvider aProvider, int aDefaultOverworld) {
        return aProvider.field_76574_g == 0 ? WD.waterLevel(aDefaultOverworld) : (aProvider.field_76576_e || WD.dimTF(aProvider) ? 31 : 62);
    }

    public static int waterLevel(int aDefaultOverworld) {
        return MD.TFC.mLoaded || MD.TFCP.mLoaded ? 143 : aDefaultOverworld;
    }

    public static int waterLevel() {
        return WD.waterLevel(62);
    }

    public static long temperature(World aWorld, int aX, int aY, int aZ) {
        long rTemperature = WD.envTemp(aWorld, aX, aY, aZ);
        if (WD.burning(aWorld, aX, aY, aZ)) {
            rTemperature = Math.max(rTemperature, 473L);
        }
        for (ChunkCoordinates tCoords : new ChunkCoordinates[]{new ChunkCoordinates(aX, aY, aZ), new ChunkCoordinates(aX + 1, aY, aZ), new ChunkCoordinates(aX - 1, aY, aZ), new ChunkCoordinates(aX, aY + 1, aZ), new ChunkCoordinates(aX, aY - 1, aZ), new ChunkCoordinates(aX, aY, aZ + 1), new ChunkCoordinates(aX, aY, aZ - 1)}) {
            Block tBlock = WD.block(aWorld, tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, false);
            if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                rTemperature = Math.max(rTemperature, 773L);
                continue;
            }
            if (!(tBlock instanceof BlockFire)) continue;
            rTemperature = Math.max(rTemperature, 473L);
        }
        return rTemperature;
    }

    public static ItemStack stack(World aWorld, int aX, int aY, int aZ) {
        Block tBlock;
        return ST.make(tBlock, 1L, (tBlock = aWorld.func_147439_a(aX, aY, aZ)) instanceof IBlockExtendedMetaData ? (long)((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX, aY, aZ) : (long)aWorld.func_72805_g(aX, aY, aZ));
    }

    public static void update(IBlockAccess aWorld, int aX, int aY, int aZ) {
        EntityPlayer tPlayer;
        ((World)aWorld).func_147471_g(aX, aY, aZ);
        if (CS.CLIENT_BLOCKUPDATE_SOUNDS && CS.CODE_CLIENT && CS.CLIENT_TIME > 100L && (tPlayer = GT_API.api_proxy.getThePlayer()) != null && Math.abs(tPlayer.field_70165_t - (double)aX) < 16.0 && Math.abs(tPlayer.field_70163_u - (double)aY) < 16.0 && Math.abs(tPlayer.field_70161_v - (double)aZ) < 16.0) {
            UT.Sounds.play("fireworks.launch", 1, 1.0f, 1.0f, aX, aY, aZ);
        }
    }

    public static Block block(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ);
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? aWorld.func_147439_a(aX, aY, aZ) : CS.NB;
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.block(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.block((IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static byte meta(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return UT.Code.bind4(aWorld.func_72805_g(aX, aY, aZ));
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? UT.Code.bind4(aWorld.func_72805_g(aX, aY, aZ)) : (byte)0;
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.meta(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.meta((IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static byte meta(long aBitAnd, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return UT.Code.bind4((long)aWorld.func_72805_g(aX, aY, aZ) & aBitAnd);
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? UT.Code.bind4((long)aWorld.func_72805_g(aX, aY, aZ) & aBitAnd) : (byte)0;
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.meta(aBitAnd, aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.meta(aBitAnd, (IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta, long aFlags) {
        return WD.set(aWorld, aX, aY, aZ, aBlock, aMeta, aFlags, aBlock.func_149662_c());
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta, long aFlags, boolean aRemoveGrassBelow) {
        Block tBlock;
        if (aRemoveGrassBelow && ((tBlock = aWorld.func_147439_a(aX, aY - 1, aZ)) == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh)) {
            aWorld.func_147465_d(aX, aY - 1, aZ, Blocks.field_150346_d, 0, (int)((byte)aFlags));
        }
        return aWorld.func_147465_d(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)), (int)((byte)aFlags));
    }

    public static boolean set(Chunk aChunk, int aX, int aY, int aZ, Block aBlock, long aMeta) {
        return aChunk.func_150807_a(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)));
    }

    public static boolean set(Chunk aChunk, int aX, int aY, int aZ, Block aBlock, long aMeta, boolean aRemoveGrassBelow) {
        Block tBlock;
        if (aRemoveGrassBelow && ((tBlock = aChunk.func_150810_a(aX, aY - 1, aZ)) == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh)) {
            aChunk.func_150807_a(aX, aY - 1, aZ, Blocks.field_150346_d, 0);
        }
        return aChunk.func_150807_a(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)));
    }

    public static boolean replace(World aWorld, int aX, int aY, int aZ, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        if (aTargetBlock == null || aReplaceBlock == null) {
            return false;
        }
        if (aReplaceBlock != WD.block((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (aReplaceMeta != 32767L && aReplaceMeta != (long)WD.meta((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        return aWorld.func_147465_d(aX, aY, aZ, aTargetBlock, (int)UT.Code.bind4(aTargetMeta), 2);
    }

    public static boolean replace(World aWorld, ChunkCoordinates aCoords, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        return WD.replace(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta);
    }

    public static boolean replaceAll(World aWorld, int aX, int aY, int aZ, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        return WD.replaceAll(aWorld, new ChunkCoordinates(aX, aY, aZ), aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta);
    }

    public static boolean replaceAll(World aWorld, ChunkCoordinates aCoords, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        if (!WD.replace(aWorld, aCoords, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta)) {
            return false;
        }
        HashSetNoNulls<ChunkCoordinates> tDone = new HashSetNoNulls<ChunkCoordinates>(false, aCoords);
        HashSetNoNulls<Object> tCheck = new HashSetNoNulls<ChunkCoordinates>(false, aCoords);
        HashSetNoNulls<Object> tNext = new HashSetNoNulls();
        while (!tCheck.isEmpty() && tDone.size() < 32768) {
            tNext.clear();
            for (ChunkCoordinates tChecking : tCheck) {
                if (Math.abs(tChecking.field_71574_a - aCoords.field_71574_a) >= 128 || Math.abs(tChecking.field_71573_c - aCoords.field_71573_c) >= 128) continue;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            ChunkCoordinates tCoords = new ChunkCoordinates(tChecking.field_71574_a + i, tChecking.field_71572_b + j, tChecking.field_71573_c + k);
                            if (!tDone.add(tCoords) || !WD.replace(aWorld, tCoords, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta)) continue;
                            tNext.add(tCoords);
                        }
                    }
                }
            }
            HashSetNoNulls tSwap = tNext;
            tNext = tCheck;
            tCheck = tSwap;
        }
        return true;
    }

    public static boolean sign(World aWorld, int aX, int aY, int aZ, byte aSide, long aFlags, String aLine1, String aLine2, String aLine3, String aLine4) {
        aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150444_as, (int)aSide, (int)((byte)aFlags));
        TileEntity tSign = WD.te(aWorld, aX, aY, aZ, true);
        if (!(tSign instanceof TileEntitySign)) {
            return false;
        }
        ((TileEntitySign)tSign).field_145915_a[0] = aLine1;
        ((TileEntitySign)tSign).field_145915_a[1] = aLine2;
        ((TileEntitySign)tSign).field_145915_a[2] = aLine3;
        ((TileEntitySign)tSign).field_145915_a[3] = aLine4;
        return true;
    }

    public static Random random(World aWorld, long aChunkX, long aChunkZ) {
        return WD.random(aWorld.func_72905_C() ^ (long)aWorld.field_73011_w.field_76574_g, aChunkX >> 4, aChunkZ >> 4);
    }

    public static Random random(long aSeed, long aChunkX, long aChunkZ) {
        int i;
        Random rRandom = new Random(aSeed);
        for (i = 0; i < 50; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        rRandom = new Random(aSeed ^ (rRandom.nextLong() >> 3) * aChunkX + (rRandom.nextLong() >> 3) * aChunkZ);
        for (i = 0; i < 50; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        return rRandom;
    }

    public static int random(World aWorld, int aX, int aY, int aZ, int aBound) {
        return WD.random(aWorld.func_72905_C() ^ (long)aWorld.field_73011_w.field_76574_g, aX, aY, aZ, aBound);
    }

    public static int random(long aSeed, int aX, int aY, int aZ, int aBound) {
        int i;
        Random rRandom = new Random(aSeed ^ (long)aY);
        for (i = 0; i < 10; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        rRandom = new Random(aSeed ^ (rRandom.nextLong() >> 3) * (long)aX + (rRandom.nextLong() >> 3) * (long)aZ);
        for (i = 0; i < 10; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        return rRandom.nextInt(aBound);
    }

    public static Random random(TileEntity aTileEntity) {
        return new Random(aTileEntity.field_145851_c ^ aTileEntity.field_145848_d ^ aTileEntity.field_145849_e);
    }

    public static int random(TileEntity aTileEntity, int aBound) {
        return WD.random(aTileEntity).nextInt(aBound);
    }

    public static boolean random(TileEntity aTileEntity, int aBound, long aTime) {
        return (long)WD.random(aTileEntity, aBound) == aTime % (long)aBound;
    }

    public static boolean border(int aFromX, int aFromZ, int aToX, int aToZ) {
        return aFromX >> 4 != aToX >> 4 || aFromZ >> 4 != aToZ >> 4;
    }

    public static boolean even(TileEntity aTileEntity) {
        return WD.even(aTileEntity.field_145851_c, aTileEntity.field_145848_d, aTileEntity.field_145849_e);
    }

    public static boolean even(ChunkCoordinates aCoords) {
        return WD.even(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    public static boolean even(int ... aCoords) {
        int i = 0;
        for (int tCoord : aCoords) {
            if (tCoord % 2 != 0) continue;
            ++i;
        }
        return i % 2 == 0;
    }

    public static int evenness(TileEntity aTileEntity) {
        return WD.evenness(aTileEntity.field_145851_c, aTileEntity.field_145848_d, aTileEntity.field_145849_e);
    }

    public static int evenness(ChunkCoordinates aCoords) {
        return WD.evenness(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    public static int evenness(int ... aCoords) {
        int i = 0;
        for (int tCoord : aCoords) {
            i <<= 1;
            if (tCoord % 2 == 0) continue;
            ++i;
        }
        return i;
    }

    public static boolean setIfDiff(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
        return (aWorld.func_147439_a(aX, aY, aZ) != aBlock || aWorld.func_72805_g(aX, aY, aZ) != aMeta) && aWorld.func_147465_d(aX, aY, aZ, aBlock, aMeta, aFlags);
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        Block tBlock = ST.block(aStack);
        if (tBlock == CS.NB) {
            return false;
        }
        if (tBlock instanceof IBlockPlacable) {
            return ((IBlockPlacable)tBlock).placeBlock(aWorld, aX, aY, aZ, (byte)6, ST.meta_(aStack), aStack.func_77978_p(), true, false);
        }
        if (ST.meta_(aStack) < 16) {
            return aWorld.func_147465_d(aX, aY, aZ, tBlock, (int)ST.meta_(aStack), 3);
        }
        return false;
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.leafdecay(aWorld, aX, aY, aZ, aBlock, false, false);
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock, boolean aOnlyTopArea) {
        return WD.leafdecay(aWorld, aX, aY, aZ, aBlock, aOnlyTopArea, false);
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock, boolean aOnlyTopArea, boolean aTreeCapitator) {
        if (aBlock == null || aBlock.canSustainLeaves((IBlockAccess)aWorld, aX, aY, aZ)) {
            int j;
            int n = j = aOnlyTopArea ? 0 : -7;
            while (j <= 7) {
                for (int i = -7; i <= 7; ++i) {
                    for (int k = -7; k <= 7; ++k) {
                        Block tBlock = aWorld.func_147439_a(aX + i, aY + j, aZ + k);
                        if (tBlock == CS.NB) continue;
                        if (tBlock == Blocks.field_150420_aW || tBlock == Blocks.field_150419_aX) {
                            if (!aTreeCapitator || Math.abs(i) > 4 || Math.abs(k) > 4 || j > 0 || j < -2) continue;
                            aWorld.func_147480_a(aX + i, aY + j, aZ + k, true);
                            continue;
                        }
                        if (IL.NeLi_Wart_Block_Crimson.equal(tBlock) || IL.NeLi_ShroomLight.equal(tBlock)) {
                            if (!aTreeCapitator || Math.abs(i) > 4 || Math.abs(k) > 4) continue;
                            aWorld.func_147480_a(aX + i, aY + j, aZ + k, true);
                            continue;
                        }
                        if (!tBlock.isLeaves((IBlockAccess)aWorld, aX + i, aY + j, aZ + k)) continue;
                        aWorld.func_147464_a(aX + i, aY + j, aZ + k, tBlock, 1 + CS.RNGSUS.nextInt(100));
                    }
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public static boolean liquid(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid(aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean liquid(Block aBlock) {
        return aBlock instanceof BlockLiquid || aBlock instanceof IFluidBlock;
    }

    public static boolean liquid_classic(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_classic(aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean liquid_classic(Block aBlock) {
        return aBlock instanceof BlockLiquid || aBlock instanceof BlockFluidClassic;
    }

    public static boolean liquid_finite(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_finite(aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean liquid_finite(Block aBlock) {
        return aBlock instanceof BlockFluidFinite;
    }

    public static boolean liquid_borken(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_borken(aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean liquid_borken(Block aBlock) {
        return !(aBlock instanceof IItemGT) && WD.liquid_classic(aBlock);
    }

    public static boolean stone(Block aBlock, short aMeta) {
        if (aBlock == CS.NB) {
            return false;
        }
        if (aBlock == Blocks.field_150343_Z) {
            return true;
        }
        ItemStackContainer tStack = new ItemStackContainer(aBlock, 1L, (long)aMeta);
        return CS.BlocksGT.stoneToNormalOres.containsKey(tStack) || CS.BlocksGT.stoneToBrokenOres.containsKey(tStack) || CS.BlocksGT.stoneToSmallOres.containsKey(tStack);
    }

    public static boolean floor(World aWorld, int aX, int aY, int aZ) {
        return WD.floor(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean floor(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock.isSideSolid((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[1]) || WD.floor(aBlock);
    }

    public static boolean floor(Block aBlock) {
        return aBlock.func_149662_c() || aBlock instanceof BlockSlab || aBlock instanceof BlockStairs || aBlock instanceof BlockMetaType;
    }

    public static boolean ore(Block aBlock, short aMeta) {
        return aBlock instanceof IBlockPlacable && (CS.BlocksGT.stoneToBrokenOres.containsValue(aBlock) || CS.BlocksGT.stoneToNormalOres.containsValue(aBlock) || CS.BlocksGT.stoneToSmallOres.containsValue(aBlock)) || OM.prefixcontains(ST.make(aBlock, 1L, (long)aMeta), TD.Prefix.ORE);
    }

    public static boolean ore_stone(Block aBlock, short aMeta) {
        return WD.ore(aBlock, aMeta) || WD.stone(aBlock, aMeta);
    }

    public static boolean visOcc(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return WD.visOpq(aWorld, aX + 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX + 1, aZ), aDefault) && WD.visOpq(aWorld, aX - 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX - 1, aZ), aDefault) && WD.visOpq(aWorld, aX, aY + 1, aZ, true, aDefault) && WD.visOpq(aWorld, aX, aY - 1, aZ, true, aDefault) && WD.visOpq(aWorld, aX, aY, aZ + 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ + 1), aDefault) && WD.visOpq(aWorld, aX, aY, aZ - 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ - 1), aDefault);
    }

    public static boolean visOpq(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? WD.visOpq(aWorld.func_147439_a(aX, aY, aZ)) : aDefault;
    }

    public static boolean visOpq(Block aBlock) {
        return aBlock.func_149662_c() || CS.VISUALLY_OPAQUE_BLOCKS.contains(aBlock);
    }

    public static boolean occ(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return WD.opq(aWorld, aX + 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX + 1, aZ), aDefault) && WD.opq(aWorld, aX - 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX - 1, aZ), aDefault) && WD.opq(aWorld, aX, aY + 1, aZ, true, aDefault) && WD.opq(aWorld, aX, aY - 1, aZ, true, aDefault) && WD.opq(aWorld, aX, aY, aZ + 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ + 1), aDefault) && WD.opq(aWorld, aX, aY, aZ - 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ - 1), aDefault);
    }

    public static boolean opq(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return aLoadUnloadedChunks || aWorld.func_72899_e(aX, aY, aZ) ? WD.opq(aWorld.func_147439_a(aX, aY, aZ)) : aDefault;
    }

    public static boolean opq(Block aBlock) {
        return aBlock.func_149662_c() && !(aBlock instanceof BlockLeaves);
    }

    public static boolean air(World aWorld, int aX, int aY, int aZ) {
        return WD.air(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean air(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == CS.NB || aBlock.isAir((IBlockAccess)aWorld, aX, aY, aZ) && (!MD.TC.mLoaded || aBlock.func_149662_c() || !(WD.te(aWorld, aX, aY, aZ, true) instanceof INode));
    }

    public static boolean air(Block aBlock) {
        return aBlock == CS.NB;
    }

    public static boolean lava(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.lava(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean lava(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k;
    }

    public static boolean lava(Block aBlock) {
        return aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k;
    }

    public static boolean water(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.water(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean water(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i;
    }

    public static boolean water(Block aBlock) {
        return aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i;
    }

    public static boolean waterstream(Block aBlock) {
        return MD.Streams.mLoaded && UT.Code.stringValidate(ST.regName(aBlock)).startsWith("streams:river/tile.water");
    }

    public static boolean anywater(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.anywater(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean anywater(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock instanceof BlockWaterlike || WD.water(aWorld, aX, aY, aZ, aBlock) || WD.waterstream(aBlock);
    }

    public static boolean anywater(Block aBlock) {
        return aBlock instanceof BlockWaterlike || WD.water(aBlock) || WD.waterstream(aBlock);
    }

    public static boolean bedrock(World aWorld, int aX, int aY, int aZ) {
        return WD.bedrock(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean bedrock(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.bedrock(aBlock);
    }

    public static boolean bedrock(Block aBlock) {
        return aBlock == Blocks.field_150357_h || IL.BTL_Bedrock.equal(aBlock);
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return WD.grass(WD.block(aWorld, aX, aY, aZ, aLoadUnloadedChunks), WD.meta(aWorld, aX, aY, aZ, aLoadUnloadedChunks));
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ) {
        return WD.grass(WD.block((IBlockAccess)aWorld, aX, aY, aZ), WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta) {
        return WD.grass(aBlock, aMeta);
    }

    public static boolean grass(Block aBlock, long aMeta) {
        if (aBlock == Blocks.field_150329_H) {
            return true;
        }
        if (aBlock == Blocks.field_150398_cm) {
            return aMeta == 2L || aMeta == 3L;
        }
        if (IL.TF_Tall_Grass.equal(aBlock)) {
            return aMeta == 8L || aMeta == 10L;
        }
        return IL.AETHER_Tall_Grass.equal(aBlock);
    }

    public static boolean irrelevant(World aWorld, int aX, int aY, int aZ) {
        return WD.irrelevant(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean irrelevant(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.air(aWorld, aX, aY, aZ, aBlock) || aBlock == Blocks.field_150395_bd || aBlock == Blocks.field_150431_aC || aBlock == Blocks.field_150480_ab || WD.grass(aWorld, aX, aY, aZ) || WD.anywater(aBlock);
    }

    public static boolean easyRep(World aWorld, int aX, int aY, int aZ) {
        return WD.easyRep(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean easyRep(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.air(aWorld, aX, aY, aZ, aBlock) || aBlock instanceof BlockBush || aBlock instanceof BlockSnow || aBlock instanceof BlockFire || aBlock.isLeaves((IBlockAccess)aWorld, aX, aY, aZ) || aBlock.canBeReplacedByLeaves((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public static boolean infiniteWater(World aWorld, int aX, int aY, int aZ) {
        int tLevel = WD.waterLevel(aWorld);
        return UT.Code.inside(tLevel - 15, tLevel, aY) && CS.BIOMES_RIVER_LAKE.contains(aWorld.func_72807_a((int)aX, (int)aZ).field_76791_y);
    }

    public static boolean infiniteWater(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        int tLevel = WD.waterLevel(aWorld);
        return WD.waterstream(aBlock) || (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i) && UT.Code.inside(tLevel - 15, tLevel, aY) && CS.BIOMES_RIVER_LAKE.contains(aWorld.func_72807_a((int)aX, (int)aZ).field_76791_y);
    }

    public static boolean hasCollide(World aWorld, int aX, int aY, int aZ) {
        return WD.hasCollide(aWorld, aX, aY, aZ, aWorld.func_147439_a(aX, aY, aZ));
    }

    public static boolean hasCollide(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock.func_149662_c() || aBlock.func_149668_a(aWorld, aX, aY, aZ) != null;
    }

    public static boolean hasCollide(World aWorld, ChunkCoordinates aCoords) {
        return WD.hasCollide(aWorld, aCoords, aWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c));
    }

    public static boolean hasCollide(World aWorld, ChunkCoordinates aCoords, Block aBlock) {
        return aBlock.func_149662_c() || aBlock.func_149668_a(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) != null;
    }

    public static boolean flaming(World aWorld, int aX, int aY, int aZ) {
        return WD.block(aWorld, aX, aY, aZ, false) instanceof BlockFire;
    }

    public static boolean burning(World aWorld, int aX, int aY, int aZ) {
        return WD.flaming(aWorld, aX, aY, aZ) || WD.flaming(aWorld, aX + 1, aY, aZ) || WD.flaming(aWorld, aX - 1, aY, aZ) || WD.flaming(aWorld, aX, aY + 1, aZ) || WD.flaming(aWorld, aX, aY - 1, aZ) || WD.flaming(aWorld, aX, aY, aZ + 1) || WD.flaming(aWorld, aX, aY, aZ - 1);
    }

    public static void burn(World aWorld, ChunkCoordinates aCoords, boolean aReplaceCenter, boolean aCheckFlammability) {
        for (byte tSide : aReplaceCenter ? CS.ALL_SIDES_MIDDLE_UP : CS.ALL_SIDES_VALID) {
            WD.fire(aWorld, aCoords.field_71574_a + CS.OFFX[tSide], aCoords.field_71572_b + CS.OFFY[tSide], aCoords.field_71573_c + CS.OFFZ[tSide], aCheckFlammability);
        }
    }

    public static void burn(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter, boolean aCheckFlammability) {
        for (byte tSide : aReplaceCenter ? CS.ALL_SIDES_MIDDLE_UP : CS.ALL_SIDES_VALID) {
            WD.fire(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], aCheckFlammability);
        }
    }

    public static boolean fire(World aWorld, ChunkCoordinates aCoords, boolean aCheckFlammability) {
        return WD.fire(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, aCheckFlammability);
    }

    public static boolean fire(World aWorld, int aX, int aY, int aZ, boolean aCheckFlammability) {
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (tBlock.func_149688_o() == Material.field_151587_i || tBlock.func_149688_o() == Material.field_151581_o) {
            return false;
        }
        if (tBlock.func_149688_o() == Material.field_151593_r || tBlock.func_149668_a(aWorld, aX, aY, aZ) == null) {
            if (MD.TC.mLoaded && WD.te(aWorld, aX, aY, aZ, true) instanceof INode) {
                return false;
            }
            if (tBlock.getFlammability((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[6]) > 0) {
                return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150480_ab, 0, 3);
            }
            if (tBlock instanceof IItemGT) {
                return false;
            }
            if (aCheckFlammability) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    Block tAdjacent = WD.block(aWorld, aX, aY, aZ, tSide);
                    if (tAdjacent == Blocks.field_150486_ae || tAdjacent == Blocks.field_150447_bR) {
                        return aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                    }
                    if (tAdjacent.getFlammability((IBlockAccess)aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], CS.FORGE_DIR_OPPOSITES[tSide]) <= 0) continue;
                    return aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                }
            } else {
                return aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150480_ab, 0, 3);
            }
        }
        return false;
    }

    public static boolean oreGenReplaceable(World aWorld, int aX, int aY, int aZ, boolean aAllowAir) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return aAllowAir;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        if (CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return true;
        }
        if (Blocks.field_150348_b != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
            return true;
        }
        if (Blocks.field_150351_n != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
            return true;
        }
        if (Blocks.field_150354_m != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
            return true;
        }
        if (Blocks.field_150424_aL != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
            return true;
        }
        return Blocks.field_150377_bs != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs);
    }

    public static boolean setOre(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && WD.setOre(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setOre(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        IBlockPlacable tBlock = CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(aBlock, 1L, (long)aMeta));
        if (tBlock == null) {
            if (Blocks.field_150348_b != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                tBlock = CS.BlocksGT.ore;
            } else if (Blocks.field_150351_n != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
                tBlock = CS.BlocksGT.oreGravel;
            } else if (Blocks.field_150354_m != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
                tBlock = CS.BlocksGT.oreSand;
            } else if (Blocks.field_150424_aL != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                tBlock = CS.BlocksGT.oreNetherrack;
            } else if (Blocks.field_150377_bs != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                tBlock = CS.BlocksGT.oreEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean setSmallOre(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && WD.setSmallOre(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setSmallOre(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB || WD.bedrock(aBlock)) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        IBlockPlacable tBlock = CS.BlocksGT.stoneToSmallOres.get(new ItemStackContainer(aBlock, 1L, (long)aMeta));
        if (tBlock == null) {
            if (Blocks.field_150348_b != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                tBlock = CS.BlocksGT.oreSmall;
            } else if (Blocks.field_150351_n != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150351_n)) {
                tBlock = CS.BlocksGT.oreSmallGravel;
            } else if (Blocks.field_150354_m != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m)) {
                tBlock = CS.BlocksGT.oreSmallSand;
            } else if (Blocks.field_150424_aL != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                tBlock = CS.BlocksGT.oreSmallNetherrack;
            } else if (Blocks.field_150377_bs != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                tBlock = CS.BlocksGT.oreSmallEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean removeBedrock(World aWorld, int aX, int aY, int aZ) {
        Block tStone;
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block block = tStone = aWorld.field_73011_w.field_76574_g == -1 ? Blocks.field_150424_aL : Blocks.field_150348_b;
        if (tBlock == CS.NB || WD.bedrock(tBlock)) {
            for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                for (int i = 1; i < 7; ++i) {
                    int tMetaData;
                    tBlock = aWorld.func_147439_a(aX + CS.OFFX[tSide] * i, aY + CS.OFFY[tSide] * i, aZ + CS.OFFZ[tSide] * i);
                    if (tBlock == CS.NB || tBlock == tStone || WD.bedrock(tBlock) || !CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(tBlock, 1L, (long)(tMetaData = aWorld.func_72805_g(aX + CS.OFFX[tSide] * i, aY + CS.OFFY[tSide] * i, aZ + CS.OFFZ[tSide] * i))))) continue;
                    return aWorld.func_147465_d(aX, aY, aZ, tBlock, tMetaData, 0);
                }
            }
            return aWorld.func_147465_d(aX, aY, aZ, tStone, 0, 0);
        }
        return false;
    }

    public static List<ChunkCoordinates> line(Vec3 aStart, Vec3 aEnd) {
        ArrayListNoNulls<ChunkCoordinates> rList = new ArrayListNoNulls<ChunkCoordinates>();
        if (Double.isNaN(aStart.field_72450_a) || Double.isNaN(aStart.field_72448_b) || Double.isNaN(aStart.field_72449_c) || Double.isNaN(aEnd.field_72450_a) || Double.isNaN(aEnd.field_72448_b) || Double.isNaN(aEnd.field_72449_c)) {
            return rList;
        }
        Vec3 tPoint = Vec3.func_72443_a((double)aStart.field_72450_a, (double)aStart.field_72448_b, (double)aStart.field_72449_c);
        int sx = UT.Code.roundDown(tPoint.field_72450_a);
        int sy = UT.Code.roundDown(tPoint.field_72448_b);
        int sz = UT.Code.roundDown(tPoint.field_72449_c);
        int ex = UT.Code.roundDown(aEnd.field_72450_a);
        int ey = UT.Code.roundDown(aEnd.field_72448_b);
        int ez = UT.Code.roundDown(aEnd.field_72449_c);
        rList.add(new ChunkCoordinates(sx, sy, sz));
        int maxAttempts = 2000;
        while (maxAttempts-- >= 0) {
            int whereTo;
            if (Double.isNaN(tPoint.field_72450_a) || Double.isNaN(tPoint.field_72448_b) || Double.isNaN(tPoint.field_72449_c)) {
                return rList;
            }
            if (sx == ex && sy == ey && sz == ez) {
                return rList;
            }
            boolean performx = true;
            boolean performy = true;
            boolean performz = true;
            double nx = 999.0;
            double ny = 999.0;
            double nz = 999.0;
            double ndx = 999.0;
            double ndy = 999.0;
            double ndz = 999.0;
            double distx = aEnd.field_72450_a - tPoint.field_72450_a;
            double disty = aEnd.field_72448_b - tPoint.field_72448_b;
            double distz = aEnd.field_72449_c - tPoint.field_72449_c;
            if (ex > sx) {
                nx = (double)sx + 1.0;
            } else if (ex < sx) {
                nx = (double)sx + 0.0;
            } else {
                performx = false;
            }
            if (ey > sy) {
                ny = (double)sy + 1.0;
            } else if (ey < sy) {
                ny = (double)sy + 0.0;
            } else {
                performy = false;
            }
            if (ez > sz) {
                nz = (double)sz + 1.0;
            } else if (ez < sz) {
                nz = (double)sz + 0.0;
            } else {
                performz = false;
            }
            if (performx) {
                ndx = (nx - tPoint.field_72450_a) / distx;
            }
            if (performy) {
                ndy = (ny - tPoint.field_72448_b) / disty;
            }
            if (performz) {
                ndz = (nz - tPoint.field_72449_c) / distz;
            }
            if (ndx < ndy && ndx < ndz) {
                whereTo = ex > sx ? 4 : 5;
                tPoint.field_72450_a = nx;
                tPoint.field_72448_b += disty * ndx;
                tPoint.field_72449_c += distz * ndx;
            } else if (ndy < ndz) {
                whereTo = ey > sy ? 0 : 1;
                tPoint.field_72450_a += distx * ndy;
                tPoint.field_72448_b = ny;
                tPoint.field_72449_c += distz * ndy;
            } else {
                whereTo = ez > sz ? 2 : 3;
                tPoint.field_72450_a += distx * ndz;
                tPoint.field_72448_b += disty * ndz;
                tPoint.field_72449_c = nz;
            }
            sx = UT.Code.roundDown(tPoint.field_72450_a);
            sy = UT.Code.roundDown(tPoint.field_72448_b);
            sz = UT.Code.roundDown(tPoint.field_72449_c);
            if (whereTo == 5) {
                --sx;
            }
            if (whereTo == 1) {
                --sy;
            }
            if (whereTo == 3) {
                --sz;
            }
            rList.add(new ChunkCoordinates(sx, sy, sz));
        }
        return rList;
    }

    public static long scan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, byte aSide, float aClickX, float aClickY, float aClickZ) {
        if (aList == null) {
            return 0L;
        }
        ArrayListNoNulls<String> rList = new ArrayListNoNulls<String>();
        long rEUAmount = 0L;
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        ((ArrayList)rList).add("--- X: " + aX + " Y: " + aY + " Z: " + aZ + " ---");
        try {
            ((ArrayList)rList).add("Name: " + (aTileEntity instanceof IInventory && UT.Code.stringValid(((IInventory)aTileEntity).func_145825_b()) ? ((IInventory)aTileEntity).func_145825_b() : aBlock.func_149739_a()) + "  MetaData: " + aMeta);
            ((ArrayList)rList).add("Registry: " + ST.regName(aBlock));
            if (aScanLevel >= 10) {
                ((ArrayList)rList).add("Block Class: " + aBlock.getClass());
                if (aTileEntity != null) {
                    ((ArrayList)rList).add("TileEntity Class: " + aTileEntity.getClass());
                }
            }
            float tResistance = aBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v);
            ((ArrayList)rList).add("Hardness: " + aBlock.func_149712_f(aWorld, aX, aY, aZ) + " - " + LH.getToolTipBlastResistance(aBlock, tResistance));
            int tHarvestLevel = aBlock.getHarvestLevel((int)aMeta);
            String tHarvestTool = aBlock.getHarvestTool((int)aMeta);
            ((ArrayList)rList).add(tHarvestLevel == 0 && aBlock.func_149688_o().func_85157_q() ? "Hand-Harvestable, but " + (UT.Code.stringValid(tHarvestTool) ? UT.Code.capitalise(tHarvestTool) : "None") + " is faster" : "Tool to Harvest: " + (UT.Code.stringValid(tHarvestTool) ? UT.Code.capitalise(tHarvestTool) : "None") + " (" + tHarvestLevel + ")");
            if (aBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                ((ArrayList)rList).add("Is usable for Beacon Pyramids");
            }
            if (MD.GC.mLoaded && aBlock instanceof IPartialSealableBlock) {
                ((ArrayList)rList).add(((IPartialSealableBlock)aBlock).isSealed(aWorld, aX, aY, aZ, CS.FORGE_DIR[aSide ^ 1]) ? "Is Sealable on this Side" : "Is not Sealable on this Side");
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aTileEntity != null) {
            try {
                if (aTileEntity instanceof ITileEntityWeight && ((ITileEntityWeight)aTileEntity).getWeightValue(aSide) > 0.0) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Weight: " + ((ITileEntityWeight)aTileEntity).getWeightValue(aSide) + " kg");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityTemperature && ((ITileEntityTemperature)aTileEntity).getTemperatureMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Temperature: " + ((ITileEntityTemperature)aTileEntity).getTemperatureValue(aSide) + " / " + ((ITileEntityTemperature)aTileEntity).getTemperatureMax(aSide) + " K");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityGibbl && ((ITileEntityGibbl)aTileEntity).getGibblMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Pressure: " + ((ITileEntityGibbl)aTileEntity).getGibblValue(aSide) + " / " + ((ITileEntityGibbl)aTileEntity).getGibblMax(aSide) + " Gibbl");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityProgress && ((ITileEntityProgress)aTileEntity).getProgressMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Progress: " + ((ITileEntityProgress)aTileEntity).getProgressValue(aSide) + " / " + ((ITileEntityProgress)aTileEntity).getProgressMax(aSide));
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            String rState = "";
            try {
                if (aTileEntity instanceof ITileEntitySwitchableOnOff) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "State: " + (((ITileEntitySwitchableOnOff)aTileEntity).getStateOnOff() ? "ON" : "OFF");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntitySwitchableMode) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Mode: " + ((ITileEntitySwitchableMode)aTileEntity).getStateMode();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityRunningSuccessfully) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningSuccessfully() ? "Successfully" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningActively() ? "Actively" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible"))));
                } else if (aTileEntity instanceof ITileEntityRunningActively) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningActively)aTileEntity).getStateRunningActively() ? "Actively" : (((ITileEntityRunningActively)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningActively)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible")));
                } else if (aTileEntity instanceof ITileEntityRunningPassively) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningPassively)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningPassively)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible"));
                } else if (aTileEntity instanceof ITileEntityRunningPossible) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningPossible)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (UT.Code.stringValid(rState)) {
                ((ArrayList)rList).add(rState);
            }
            try {
                if (aTileEntity instanceof ITileEntityEnergy) {
                    rEUAmount += CS.V[3];
                    for (TagData tEnergyType : ((ITileEntityEnergy)aTileEntity).getEnergyTypes(aSide)) {
                        ((ArrayList)rList).add("Input: " + ((ITileEntityEnergy)aTileEntity).getEnergySizeInputMin(tEnergyType, aSide) + " to " + ((ITileEntityEnergy)aTileEntity).getEnergySizeInputMax(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                        ((ArrayList)rList).add("Output: " + ((ITileEntityEnergy)aTileEntity).getEnergySizeOutputMin(tEnergyType, aSide) + " to " + ((ITileEntityEnergy)aTileEntity).getEnergySizeOutputMax(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityEnergyDataCapacitor) {
                    rEUAmount += CS.V[3];
                    for (TagData tEnergyType : ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyCapacitorTypes(aSide)) {
                        ((ArrayList)rList).add("Stored: " + ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyStored(tEnergyType, aSide) + " of " + ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyCapacity(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof IFluidHandler) {
                    rEUAmount += CS.V[3];
                    FluidTankInfo[] tTanks = ((IFluidHandler)aTileEntity).getTankInfo(CS.FORGE_DIR[aSide]);
                    if (tTanks != null) {
                        for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                            ((ArrayList)rList).add("Tank " + i + ": " + (tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + " / " + tTanks[i].capacity + " " + FL.name(tTanks[i].fluid, true));
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (!(aTileEntity instanceof ITileEntity)) {
                try {
                    if (aTileEntity instanceof IReactorChamber) {
                        rEUAmount += CS.V[4];
                        aTileEntity = (TileEntity)((IReactorChamber)aTileEntity).getReactor();
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IReactor) {
                        rEUAmount += CS.V[4];
                        ((ArrayList)rList).add("Heat: " + ((IReactor)aTileEntity).getHeat() + "/" + ((IReactor)aTileEntity).getMaxHeat() + "  HEM: " + ((IReactor)aTileEntity).getHeatEffectModifier() + "  Base IC2-EU Output: " + ((IReactor)aTileEntity).getReactorEUEnergyOutput());
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IWrenchable) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Facing: " + ((IWrenchable)aTileEntity).getFacing() + " / IC2 Wrench Drop Chance: " + (((IWrenchable)aTileEntity).wrenchCanRemove(aPlayer) ? ((IWrenchable)aTileEntity).getWrenchDropRate() * 100.0f : 0.0f) + "%");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergySink) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Demanded Energy: " + ((IEnergySink)aTileEntity).getDemandedEnergy() + " IC2-EU");
                        ((ArrayList)rList).add("Max Safe Input: " + CS.V[((IEnergySink)aTileEntity).getSinkTier()] + " IC2-EU/t");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergySource) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Max Energy Output: " + CS.V[((IEnergySource)aTileEntity).getSourceTier()] + " IC2-EU/t");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergyConductor) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Conduction Loss: " + ((IEnergyConductor)aTileEntity).getConductionLoss() + " IC2-EU/m");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergyStorage) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Contained Energy: " + ((IEnergyStorage)aTileEntity).getStored() + " of " + ((IEnergyStorage)aTileEntity).getCapacity() + " IC2-EU");
                        ((ArrayList)rList).add(((IEnergyStorage)aTileEntity).isTeleporterCompatible(CS.FORGE_DIR[aSide]) ? "Teleporter Compatible" : "Not Teleporter Compatible");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        try {
            if (aBlock instanceof IBlockDebugable) {
                rEUAmount += CS.V[3];
                ArrayList<String> temp = ((IBlockDebugable)aBlock).getDebugInfo(aPlayer, aX, aY, aZ, aScanLevel);
                if (temp != null) {
                    ((ArrayList)rList).addAll(temp);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, aSide, aScanLevel, aBlock, aTileEntity, rList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount;
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(rList);
        }
        return tEvent.mEUCost;
    }
}

