/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.connectors.TileEntityBase09Connector;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileEntityBase10ConnectorRendered
extends TileEntityBase09Connector
implements ITileEntityFoamable,
IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public float mDiameter = 1.0f;
    public boolean mTransparent = false;
    public boolean mIsGlowing = false;
    public boolean mContactDamage = false;
    public boolean mFoam = false;
    public boolean mFoamDried = false;
    public boolean mOwnable = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.diameter")) {
            this.mDiameter = Math.max(CS.PX_P[2], Math.min(CS.PX_N[0], (float)aNBT.func_74769_h("gt.diameter")));
        }
        if (aNBT.func_74764_b("gt.transparent")) {
            this.mTransparent = aNBT.func_74767_n("gt.transparent");
        }
        if (aNBT.func_74764_b("gt.contactdamage")) {
            this.mContactDamage = aNBT.func_74767_n("gt.contactdamage");
        }
        if (aNBT.func_74764_b("gt.foamdried")) {
            this.mFoamDried = aNBT.func_74767_n("gt.foamdried");
        }
        if (aNBT.func_74764_b("gt.foamed")) {
            this.mFoam = aNBT.func_74767_n("gt.foamed");
        }
        if (aNBT.func_74764_b("gt.ownable")) {
            this.mOwnable = aNBT.func_74767_n("gt.ownable");
        }
        if (aNBT.func_74764_b("gt.owner") && !CS.OWNERSHIP_RESET) {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("gt.owner"));
        }
        this.mIsGlowing = this.mMaterial.contains(TD.Properties.GLOWING);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamed", this.mFoam);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        UT.NBT.setBoolean(aNBT, "gt.ownable", this.mOwnable);
        if (this.mOwner != null) {
            aNBT.func_74778_a("gt.owner", this.mOwner.toString());
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.foamed", this.mFoam);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        UT.NBT.setBoolean(aNBT, "gt.ownable", this.mOwnable);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.mOwnable) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer >= 100L && this.mFoam && !this.mFoamDried && this.rng(5900) == 0) {
            this.mFoamDried = true;
            this.updateClientData();
        }
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        if (this.field_145850_b == null && !this.hasCovers()) {
            this.mConnections = (byte)12;
        }
        return this.mFoamDried || this.mDiameter >= 1.0f ? 1 : (this.mFoam ? 8 : (this.mConnections == 0 ? 1 : 7));
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            if (this.mFoamDried || this.mDiameter >= 1.0f) {
                return false;
            }
            this.box(aBlock, (1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f);
            return true;
        }
        if (aRenderPass <= 6) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity((byte)(aRenderPass - 1), false, false);
            float tDiameter = this.getConnectorDiameter((byte)(aRenderPass - 1), tDelegator);
            float tLength = this.getConnectorLength((byte)(aRenderPass - 1), tDelegator);
            switch (aRenderPass - 1) {
                case 4: {
                    this.box(aBlock, 0.0f - tLength, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 0: {
                    this.box(aBlock, (1.0f - tDiameter) / 2.0f, 0.0f - tLength, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 2: {
                    this.box(aBlock, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 0.0f - tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 5: {
                    this.box(aBlock, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 1: {
                    this.box(aBlock, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f);
                    return true;
                }
                case 3: {
                    this.box(aBlock, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 7) {
            return aShouldSideBeRendered[aSide] ? this.getTextureCFoam(aSide, this.mConnections, this.mDiameter, aRenderPass) : null;
        }
        if (aRenderPass == 0) {
            return this.mFoamDried ? (aShouldSideBeRendered[aSide] ? this.getTextureCFoamDry(aSide, this.mConnections, this.mDiameter, aRenderPass) : null) : (this.mConnections == 0 || this.mDiameter >= 1.0f && this.connected(aSide) ? this.getTextureConnected(aSide, this.mConnections, this.mDiameter, aRenderPass) : this.getTextureSide(aSide, this.mConnections, this.mDiameter, aRenderPass));
        }
        return aSide == CS.OPOS[aRenderPass - 1] ? null : (aSide == aRenderPass - 1 ? (aShouldSideBeRendered[aSide] ? this.getTextureConnected(aSide, this.mConnections, this.mDiameter, aRenderPass) : null) : this.getTextureSide(aSide, this.mConnections, this.mDiameter, aRenderPass));
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 0 || aRenderPass == 7 || this.connected((byte)(aRenderPass - 1));
    }

    @Override
    public int getLightOpacity() {
        return this.mFoamDried ? 255 : (this.mTransparent ? (this.mDiameter >= 1.0f ? 3 : (this.mDiameter > 0.5f ? 1 : 0)) : (this.mDiameter >= 1.0f ? 255 : (this.mDiameter > 0.5f ? 3 : 1)));
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return !this.mFoam && this.mDiameter < 1.0f;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.mOwnable && aPlayer != null && !CS.OWNERSHIP_RESET) {
            this.mOwner = aPlayer.func_110124_au();
        }
        return super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return !this.mOwnable || !this.mFoamDried || super.allowInteraction(aEntity);
    }

    @Override
    public boolean applyFoam(byte aSide, Entity aPlayer, short[] aCFoamRGB, byte aVanillaColor, boolean aOwned) {
        if (this.mDiameter >= 1.0f || this.mFoam || this.mFoamDried || this.isClientSide() || !this.allowInteraction(aPlayer)) {
            return false;
        }
        this.mFoam = true;
        this.mFoamDried = false;
        this.mIsPainted = true;
        this.mOwnable = aOwned;
        if (this.mOwnable && aPlayer != null && !CS.OWNERSHIP_RESET) {
            this.mOwner = aPlayer.func_110124_au();
        }
        this.mRGBa = UT.Code.getRGBInt(aCFoamRGB);
        this.updateClientData();
        return true;
    }

    @Override
    public boolean dryFoam(byte aSide, Entity aPlayer) {
        if (!this.mFoam || this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoam = true;
        this.mFoamDried = true;
        this.updateClientData();
        return true;
    }

    @Override
    public boolean removeFoam(byte aSide, Entity aPlayer) {
        if (!this.mFoam || !this.mFoamDried || this.isClientSide() || !this.allowInteraction(aPlayer)) {
            return false;
        }
        this.mFoam = false;
        this.mFoamDried = false;
        this.mOwnable = false;
        this.mOwner = null;
        this.unpaint();
        this.updateClientData();
        return true;
    }

    @Override
    public float getExplosionResistance2() {
        return Math.max(this.mFoam ? (this.mFoamDried ? CS.BlocksGT.CFoam : CS.BlocksGT.CFoamFresh).func_149638_a(null) : 0.0f, super.getExplosionResistance2());
    }

    @Override
    public byte getDirectionData() {
        return (byte)((byte)(this.mConnections & 0x3F) | (byte)((this.mFoamDried ? this.mOwnable : this.mFoam) ? 64 : 0) | (byte)(this.mFoamDried ? 128 : 0));
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mConnections = (byte)(aData & 0x3F);
        boolean bl = this.mFoamDried = (aData & 0xFFFFFF80) != 0;
        if (this.mFoamDried) {
            this.mOwnable = (aData & 0x40) != 0;
            this.mFoam = true;
        } else {
            this.mOwnable = this.mOwner != null;
            this.mFoam = (aData & 0x40) != 0;
        }
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return this.mFoam ? 0 : super.getFireSpreadSpeed(aSide, aDefault);
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return this.mFoam ? 0 : super.getFlammability(aSide, aDefault);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return this.mFoamDried ? 1.0f : this.mDiameter;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return this.mDiameter;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return this.mFoamDried || this.connected(aSide) ? 0.0f : (1.0f - this.mDiameter) / 2.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f && !this.mTransparent;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return this.mFoamDried || this.mDiameter == 1.0f;
    }

    @Override
    public boolean isSealable2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean usePipePlacementMode(byte aSide) {
        return true;
    }

    @Override
    public boolean hasFoam(byte aSide) {
        return this.mFoam;
    }

    @Override
    public boolean driedFoam(byte aSide) {
        return this.mFoam && this.mFoamDried;
    }

    @Override
    public boolean ownedFoam(byte aSide) {
        return this.mFoam && this.mOwnable;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return this.mDiameter >= 1.0f || this.mFoamDried;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.mContactDamage && !this.mFoamDried ? this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[2], CS.PX_N[2], CS.PX_N[2], CS.PX_N[2]) : super.getCollisionBoundingBoxFromPool();
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        if (!this.addDefaultCollisionBoxToList()) {
            float tLength;
            float tDiameter;
            DelegatorTileEntity<TileEntity> tDelegator;
            this.box(aAABB, aList, (1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f, 1.0f - (1.0f - this.mDiameter) / 2.0f);
            byte tSide = 4;
            if (this.connected((byte)4)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, 0.0f - tLength, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
            }
            tSide = 0;
            if (this.connected((byte)0)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, (1.0f - tDiameter) / 2.0f, 0.0f - tLength, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
            }
            tSide = 2;
            if (this.connected((byte)2)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 0.0f - tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f);
            }
            tSide = 5;
            if (this.connected((byte)5)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f);
            }
            tSide = 1;
            if (this.connected((byte)1)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength, 1.0f - (1.0f - tDiameter) / 2.0f);
            }
            tSide = 3;
            if (this.connected((byte)3)) {
                tDelegator = this.getAdjacentTileEntity(tSide, false, false);
                tDiameter = this.getConnectorDiameter(tSide, tDelegator);
                tLength = this.mContactDamage ? -CS.PX_P[2] : 0.0f;
                this.box(aAABB, aList, (1.0f - tDiameter) / 2.0f, (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f - (1.0f - tDiameter) / 2.0f, 1.0f + tLength);
            }
        }
    }

    @Override
    public float[] shrunkBox() {
        if (this.mFoam || this.mDiameter >= 1.0f || this.hasCovers()) {
            return CS.PX_BOX;
        }
        float tDiameter = (1.0f - this.mDiameter) / 2.0f;
        return new float[]{this.connected((byte)4) ? 0.0f : tDiameter, this.connected((byte)0) ? 0.0f : tDiameter, this.connected((byte)2) ? 0.0f : tDiameter, this.connected((byte)5) ? 1.0f : 1.0f - tDiameter, this.connected((byte)1) ? 1.0f : 1.0f - tDiameter, this.connected((byte)3) ? 1.0f : 1.0f - tDiameter};
    }

    public float getConnectorLength(byte aConnectorSide, DelegatorTileEntity<TileEntity> aDelegator) {
        float tDistance;
        float rLength;
        float f = this.mDiameter != 1.0f && this.hasCovers() && this.mCovers.mBehaviours[aConnectorSide] != null ? (this.mCovers.mBehaviours[aConnectorSide].showsConnectorFront(aConnectorSide, this.mCovers) ? 0.001f : -0.001f) : (rLength = 0.0f);
        if (aDelegator.mTileEntity instanceof ITileEntitySurface && (tDistance = ((ITileEntitySurface)aDelegator.mTileEntity).getSurfaceDistance(aDelegator.mSideOfTileEntity)) > 0.0f) {
            return Math.max(rLength, tDistance);
        }
        return rLength;
    }

    public float getConnectorDiameter(byte aConnectorSide, DelegatorTileEntity<TileEntity> aDelegator) {
        float rDiameter = this.mDiameter;
        if (aDelegator.mTileEntity instanceof ITileEntitySurface) {
            rDiameter = ((ITileEntitySurface)aDelegator.mTileEntity).getSurfaceSizeAttachable(aDelegator.mSideOfTileEntity);
        }
        if (rDiameter <= 0.0f || rDiameter > this.mDiameter) {
            rDiameter = this.mDiameter;
        } else if (rDiameter < CS.PX_P[2]) {
            rDiameter = CS.PX_P[2];
        }
        return rDiameter;
    }

    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
    }

    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
    }

    public ITexture getTextureCFoam(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)(this.mOwnable ? Textures.BlockIcons.CFOAM_FRESH_OWNED : Textures.BlockIcons.CFOAM_FRESH), this.mRGBa);
    }

    public ITexture getTextureCFoamDry(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)(this.mOwnable ? Textures.BlockIcons.CFOAM_HARDENED_OWNED : Textures.BlockIcons.CFOAM_HARDENED), this.mRGBa);
    }

    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return CS.IconsGT.INDEX_BLOCK_PIPE_SIDE;
    }

    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return aDiameter < 0.37f ? OP.pipeTiny.mIconIndexBlock : (aDiameter < 0.49f ? OP.pipeSmall.mIconIndexBlock : (aDiameter < 0.74f ? OP.pipeMedium.mIconIndexBlock : (aDiameter < 0.99f ? OP.pipeLarge.mIconIndexBlock : OP.pipeHuge.mIconIndexBlock)));
    }
}

