/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.connectors.TileEntityBase11ConnectorStraight;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataConductor;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityAxle
extends TileEntityBase11ConnectorStraight
implements ITileEntityQuickObstructionCheck,
ITileEntityEnergy,
ITileEntityEnergyDataConductor,
ITileEntityProgress,
IMultiTileEntity.IMTE_GetDebugInfo {
    public long mTransferredPower = 0L;
    public long mTransferredSpeed = 0L;
    public long mTransferredEnergy = 0L;
    public long mTransferredLast = 0L;
    public long mPower = 1L;
    public long mSpeed = 32L;
    public byte mRotationDir = 0;
    public byte oRotationDir = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.active.data")) {
            this.mRotationDir = aNBT.func_74771_c("gt.active.data");
        }
        if (aNBT.func_74764_b("gt.pipesize")) {
            this.mSpeed = Math.max(1L, aNBT.func_74763_f("gt.pipesize"));
        }
        if (aNBT.func_74764_b("gt.pipebandwidth")) {
            this.mPower = Math.max(1L, aNBT.func_74763_f("gt.pipebandwidth"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.active.data", this.mRotationDir);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.axle.stats.speed") + this.mSpeed + " " + TD.Energy.RU.getLocalisedNameShort());
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.axle.stats.power") + this.mPower);
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("tachometer") && this.isServerSide()) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mTransferredLast + " RU/t");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mTransferredSpeed == 0L && aTimer > 5L) {
                this.mRotationDir = 0;
            }
            this.mTransferredLast = this.mTransferredEnergy;
            this.mTransferredPower = 0L;
            this.mTransferredSpeed = 0L;
            this.mTransferredEnergy = 0L;
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mRotationDir != this.oRotationDir || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oRotationDir = this.mRotationDir;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mRotationDir = aData;
    }

    @Override
    public byte getVisualData() {
        return this.mRotationDir;
    }

    public long transferRotations(byte aSide, long aSpeed, long aPower, long aChannel, HashSetNoNulls<TileEntity> aAlreadyPassed) {
        if (this.mTimer < 1L) {
            return 0L;
        }
        this.mRotationDir = (byte)(aSpeed < 0L ? 1 + (aSide & 1) : 2 - (aSide & 1));
        if (this.oRotationDir == 0) {
            return this.addToEnergyTransferred(aSpeed, aPower, aPower);
        }
        if (!this.canEmitEnergyTo(CS.OPOS[aSide])) {
            return this.addToEnergyTransferred(aSpeed, aPower, 0L);
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(CS.OPOS[aSide]);
        return this.addToEnergyTransferred(aSpeed, aPower, aAlreadyPassed.add((TileEntity)tDelegator.mTileEntity) ? (tDelegator.mTileEntity instanceof MultiTileEntityAxle ? (((MultiTileEntityAxle)tDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.RU, tDelegator.mSideOfTileEntity, false) ? ((MultiTileEntityAxle)tDelegator.mTileEntity).transferRotations(tDelegator.mSideOfTileEntity, aSpeed, aPower, aChannel, aAlreadyPassed) : 0L) : ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.RU, aSpeed, aPower, this, tDelegator)) : 0L);
    }

    public long addToEnergyTransferred(long aSpeed, long aOriginalPower, long aPower) {
        this.mTransferredSpeed += aSpeed;
        this.mTransferredPower += aPower;
        this.mTransferredEnergy += Math.abs(aSpeed * aPower);
        if (Math.abs(aSpeed) > this.mSpeed || this.mTransferredPower > this.mPower) {
            UT.Sounds.send("random.break", this, false);
            this.popOff();
            return aOriginalPower;
        }
        return aPower;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof ITileEntityEnergy) {
            return ((ITileEntityEnergy)aDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.RU, aDelegator.mSideOfTileEntity, true) || ((ITileEntityEnergy)aDelegator.mTileEntity).isEnergyEmittingTo(TD.Energy.RU, aDelegator.mSideOfTileEntity, true);
        }
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEnergyType == TD.Energy.RU;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.RU.AS_LIST;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, true) && this.canEmitEnergyTo(aSide);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false) && this.canAcceptEnergyFrom(aSide);
    }

    @Override
    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return 0L;
    }

    @Override
    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return aSize != 0L && this.isEnergyAcceptingFrom(aEnergyType, aSide, false) ? (aDoInject ? this.transferRotations(aSide, aSize, aAmount, -1L, new HashSetNoNulls<TileEntity>(false, this)) : aAmount) : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mSpeed;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mSpeed;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mSpeed;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mSpeed;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return true;
    }

    @Override
    public boolean isEnergyConducting(TagData aEnergyType) {
        return aEnergyType == TD.Energy.RU;
    }

    @Override
    public long getEnergyMaxSize(TagData aEnergyType) {
        return aEnergyType == TD.Energy.RU ? this.mSpeed : 0L;
    }

    @Override
    public long getEnergyMaxPackets(TagData aEnergyType) {
        return aEnergyType == TD.Energy.RU ? this.mPower : 0L;
    }

    @Override
    public long getEnergyLossPerMeter(TagData aEnergyType) {
        return 0L;
    }

    @Override
    public OreDictMaterial getEnergyConductorMaterial() {
        return this.mMaterial;
    }

    @Override
    public OreDictMaterial getEnergyConductorInsulation() {
        return MT.NULL;
    }

    public boolean canEmitEnergyTo(byte aSide) {
        return this.connected(aSide);
    }

    public boolean canAcceptEnergyFrom(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mTransferredPower;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mPower;
    }

    @Override
    public ArrayList<String> getDebugInfo(int aScanLevel) {
        return aScanLevel > 0 ? new ArrayListNoNulls<String>(false, "Transferred Power: " + this.mTransferredLast) : null;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(Textures.BlockIcons.AXLES[(this.mConnections & 0xC) != 0 ? 0 : ((this.mConnections & 0x30) != 0 ? 2 : 1)][aSide][this.mRotationDir], this.mRGBa);
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(Textures.BlockIcons.AXLES[(this.mConnections & 0xC) != 0 ? 0 : ((this.mConnections & 0x30) != 0 ? 2 : 1)][aSide][this.mRotationDir], this.mRGBa);
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.AXLE_ROTATION.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.axle.rotation";
    }
}

