/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.handlers;

import gregapi.code.ICondition;
import gregapi.data.FL;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.recipes.Recipe;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapHandlerMaterial
extends IRecipeMapHandler.RecipeMapHandler {
    private ICondition mCondition;
    private final OreDictMaterial mInputMaterial;
    private final OreDictMaterial mOutputMaterial;
    private final ItemStack mAdditionalInput;
    private final FluidStack mFluidInputPerUnit;
    private final FluidStack mFluidOutputPerUnit;
    private final long mEUt;
    private final long mDuration;
    private final boolean mAllowToGenerateAllRecipesAtOnce;
    private boolean mAlreadyAddedAllRecipes = false;

    public RecipeMapHandlerMaterial(OreDictMaterial aInputMaterial, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, FluidStack aFluidOutputPerUnit, OreDictMaterial aOutputMaterial, ItemStack aAdditionalInput, boolean aAllowToGenerateAllRecipesAtOnce, ICondition aCondition) {
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition == null ? ICondition.TRUE : aCondition;
        this.mInputMaterial = aInputMaterial;
        this.mOutputMaterial = aOutputMaterial;
        this.mAdditionalInput = aAdditionalInput;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        if (ST.equal(aStack, this.mAdditionalInput)) {
            return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
        }
        return aData != null && aData.validData() && aData.mMaterial.mMaterial == this.mInputMaterial && this.addRecipeForPrefix(aMap, aData.mPrefix);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        return aData != null && aData.validData() && aData.mMaterial.mMaterial == this.mOutputMaterial && this.addRecipeForPrefix(aMap, aData.mPrefix);
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return aNEI && this.mAllowToGenerateAllRecipesAtOnce && this.mFluidOutputPerUnit != null && this.mFluidOutputPerUnit.getFluid() == aFluid && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, Fluid aFluid) {
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid;
    }

    @Override
    public boolean addAllRecipes(Recipe.RecipeMap aMap) {
        return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    public boolean addAllRecipesInternal(Recipe.RecipeMap aMap) {
        if (this.isDone()) {
            return false;
        }
        aMap.mConfigFile.mSaveOnEdit = false;
        for (OreDictPrefix tPrefix : OreDictPrefix.VALUES) {
            this.addRecipeForPrefix(aMap, tPrefix);
        }
        this.mAlreadyAddedAllRecipes = true;
        aMap.mConfigFile.mSaveOnEdit = true;
        aMap.mConfigFile.mConfig.save();
        return true;
    }

    @Override
    public boolean isDone() {
        return this.mAlreadyAddedAllRecipes;
    }

    @Override
    public boolean onAddedToMap(Recipe.RecipeMap aMap) {
        if (this.mFluidInputPerUnit != null) {
            aMap.mMaxFluidInputSize = Math.max(this.mFluidInputPerUnit.amount * 16, aMap.mMaxFluidInputSize);
            Long tSize = aMap.mMinInputTankSizes.get(this.mFluidInputPerUnit.getFluid().getName());
            if (tSize == null || tSize < (long)this.mFluidInputPerUnit.amount) {
                aMap.mMinInputTankSizes.put(this.mFluidInputPerUnit.getFluid().getName(), Long.valueOf(this.mFluidInputPerUnit.amount));
            }
        }
        if (this.mFluidOutputPerUnit != null) {
            aMap.mMaxFluidOutputSize = Math.max(this.mFluidOutputPerUnit.amount * 16, aMap.mMaxFluidOutputSize);
        }
        return true;
    }

    public boolean addRecipeForPrefix(Recipe.RecipeMap aMap, OreDictPrefix aPrefix) {
        if (!this.mCondition.isTrue(aPrefix) || aPrefix.mAmount <= 0L) {
            return false;
        }
        ItemStack[] tInputs = new ItemStack[this.mAdditionalInput == null ? 1 : 2];
        if (this.mAdditionalInput != null) {
            tInputs[tInputs.length - 1] = this.mAdditionalInput;
        }
        tInputs[0] = aPrefix.mat(this.mInputMaterial, 1L);
        for (ItemStack tInput : tInputs) {
            if (!ST.invalid(tInput)) continue;
            return false;
        }
        ItemStack tOutput = aPrefix.mat(this.mOutputMaterial, 1L);
        if (ST.invalid(tOutput)) {
            return false;
        }
        return aMap.addRecipeX(false, true, false, false, true, this.mEUt, Math.max(1L, this.getCosts(aPrefix)), tInputs, FL.mul(this.mFluidInputPerUnit, aPrefix.mAmount, 648648000L, true), FL.mul(this.mFluidOutputPerUnit, aPrefix.mAmount, 648648000L, false), tOutput) != null;
    }

    public long getCosts(OreDictPrefix aPrefix) {
        return UT.Code.units(aPrefix.mAmount, 648648000L, this.mDuration, true);
    }
}

