/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ICondition;
import gregapi.code.ITagDataContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.item.IPrefixItem;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.event.IOreDictListenerEvent;
import gregapi.oredict.listeners.IOreDictListenerItem;
import gregapi.recipes.AdvancedCrafting1ToY;
import gregapi.recipes.AdvancedCraftingXToY;
import gregapi.render.TextureSet;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public final class OreDictPrefix
implements IOreDictListenerEvent,
ITagDataContainer<OreDictPrefix>,
ICondition<ITagDataContainer<?>> {
    public static final List<OreDictPrefix> VALUES_SORTED = new ArrayListNoNulls<OreDictPrefix>();
    private static final List<OreDictPrefix> VALUES_SORTED_INTERNAL = new ArrayListNoNulls<OreDictPrefix>();
    public static final List<OreDictPrefix> VALUES = new ArrayListNoNulls<OreDictPrefix>();
    public static final Map<String, OreDictPrefix> sPrefixes = new HashMap<String, OreDictPrefix>();
    public static final Map<String, OreDictPrefix> sParsed = new HashMap<String, OreDictPrefix>();
    private final Set<TagData> mTags = new HashSetNoNulls<TagData>();
    private final Set<OreDictMaterial> mItemGeneratorBlackList = new HashSetNoNulls<OreDictMaterial>();
    private final Set<OreDictMaterial> mIgnoredRegistrations = new HashSetNoNulls<OreDictMaterial>();
    private final Set<OreDictMaterial> mItemGeneratorForced = new HashSetNoNulls<OreDictMaterial>();
    private final Set<IOreDictListenerEvent> mListenersOre = new HashSetNoNulls<IOreDictListenerEvent>();
    public final Set<IOreDictListenerItem> mListenersItem = new HashSetNoNulls<IOreDictListenerItem>();
    public final String mNameInternal;
    public OreDictPrefix mTargetRegistration = this;
    public CreativeTabs mCreativeTab = null;
    public ItemStack mContainerItem = null;
    private ICondition mCondition = ICondition.TRUE;
    public int mIconIndexBlock = -1;
    public int mIconIndexItem = -1;
    public byte mConfigStackSize = (byte)64;
    public byte mDefaultStackSize = (byte)64;
    public byte mMinimumStackSize = 1;
    public byte mState = 0;
    public long mAmount = -1L;
    public long mWeight = 648648000L;
    public List<AdvancedCrafting1ToY> mShapelessManagersSingle = new ArrayListNoNulls<AdvancedCrafting1ToY>();
    public List<AdvancedCraftingXToY> mShapelessManagers = new ArrayListNoNulls<AdvancedCraftingXToY>();
    public float mHeatDamage = 0.0f;
    public String mNameLocal;
    public String mMaterialPre;
    public String mMaterialPost;
    public String mNameCategory;
    public String mNameTextureSet;
    public final Set<OreDictPrefix> mFamiliarPrefixes = new HashSetNoNulls<OreDictPrefix>();
    public final List<OreDictMaterialStack> mByProducts = new ArrayListNoNulls<OreDictMaterialStack>();
    public final List<TC.TC_AspectStack> mAspects = new ArrayListNoNulls<TC.TC_AspectStack>(1);
    private final List<IOreDictListenerEvent.OreDictRegistrationContainer> mRegistrations = new ArrayListNoNulls<IOreDictListenerEvent.OreDictRegistrationContainer>();
    private final Set<IOreDictListenerEvent> mBufferedListeners = new HashSetNoNulls<IOreDictListenerEvent>();
    public final ItemStackSet<ItemStackContainer> mRegisteredItems = ST.hashset(new ItemStack[0]);
    public final List<IPrefixItem> mRegisteredPrefixItems = new ArrayListNoNulls<IPrefixItem>();
    public final Set<OreDictMaterial> mRegisteredMaterials = new HashSetNoNulls<OreDictMaterial>();
    public final ICondition<ITagDataContainer> NOT = new ICondition.Not<ITagDataContainer>(this);

    public static OreDictPrefix createPrefix(String aName) {
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("Prefixes have to be initialised in PreInit or earlier!");
        }
        String tName = aName.replaceAll(" ", "").replaceAll("-", "");
        OreDictPrefix rPrefix = sPrefixes.get(tName);
        return rPrefix == null ? new OreDictPrefix(tName, aName) : rPrefix;
    }

    private OreDictPrefix(String aNameInternal, String aNameLocal) {
        this.mNameTextureSet = this.mNameInternal = aNameInternal;
        this.mNameCategory = this.mNameLocal = aNameLocal;
        if (this.mNameInternal.contains("|") || this.mNameInternal.contains("*") || this.mNameInternal.contains(":") || this.mNameInternal.contains(".") || this.mNameInternal.contains("$")) {
            throw new IllegalArgumentException("The Prefix Name contains invalid Characters!");
        }
        if (this.mNameInternal.length() < 3) {
            throw new IllegalArgumentException("A Prefix must have at least 3 Characters, otherwise it would break other Prefixes way to easily.");
        }
        VALUES.add(this);
        if (VALUES_SORTED_INTERNAL.isEmpty()) {
            VALUES_SORTED_INTERNAL.add(this);
            VALUES_SORTED.add(this);
        } else {
            int j = VALUES_SORTED_INTERNAL.size();
            for (int i = 0; i < j; ++i) {
                if (this.mNameInternal.length() < OreDictPrefix.VALUES_SORTED_INTERNAL.get((int)i).mNameInternal.length()) continue;
                VALUES_SORTED_INTERNAL.add(i, this);
                VALUES_SORTED.add(i, this);
                break;
            }
        }
        sPrefixes.put(this.mNameInternal, this);
        this.mFamiliarPrefixes.add(this);
    }

    public static OreDictPrefix get(String aOre) {
        OreDictPrefix rPrefix = sParsed.get(aOre);
        if (rPrefix != null) {
            return rPrefix;
        }
        if (sParsed.containsKey(aOre)) {
            return null;
        }
        int j = VALUES_SORTED_INTERNAL.size();
        for (int i = 0; i < j; ++i) {
            rPrefix = VALUES_SORTED_INTERNAL.get(i);
            if (!aOre.startsWith(rPrefix.mNameInternal)) continue;
            sParsed.put(aOre, rPrefix);
            return rPrefix;
        }
        sParsed.put(aOre, null);
        return null;
    }

    public OreDictPrefix addIdenticalNames(String ... aNames) {
        for (String aName : aNames) {
            OreDictPrefix.createPrefix(aName).setRegistration(this);
        }
        return this;
    }

    public OreDictPrefix addFamiliarPrefix(OreDictPrefix aPrefix) {
        this.mFamiliarPrefixes.add(aPrefix);
        return this;
    }

    public OreDictPrefix addFamiliarPrefixWithReversal(OreDictPrefix aPrefix) {
        return this.addFamiliarPrefix(aPrefix.addFamiliarPrefix(this));
    }

    public OreDictPrefix setRegistration(OreDictPrefix aPrefix) {
        if (aPrefix != null) {
            this.mTargetRegistration = aPrefix;
            this.add(TD.Prefix.PREFIX_UNUSED);
        }
        return this;
    }

    public OreDictPrefix setMaterialStats(long aMaterialAmount) {
        this.add(TD.Prefix.MATERIAL_BASED);
        this.mAmount = aMaterialAmount;
        this.mWeight = aMaterialAmount;
        this.setStacksize(this.mAmount < 1297296000L ? 64L : 64L / (this.mAmount / 648648000L));
        return this;
    }

    public OreDictPrefix setMaterialStats(long aMaterialAmount, long aMaterialWeight) {
        this.add(TD.Prefix.MATERIAL_BASED);
        this.mAmount = aMaterialAmount;
        this.mWeight = aMaterialWeight;
        this.setStacksize(this.mAmount < 1297296000L ? 64L : 64L / (this.mAmount / 648648000L));
        return this;
    }

    public OreDictPrefix setOreStats(long aMaterialWeight) {
        this.add(TD.Prefix.MATERIAL_BASED, TD.Prefix.UNIFICATABLE, TD.Prefix.ORE, TD.Prefix.TOOLTIP_ENCHANTS);
        this.mAmount = -1L;
        this.mWeight = aMaterialWeight;
        this.setCondition(TD.ItemGenerator.ORES);
        return this;
    }

    public OreDictPrefix setConfigStacksize(long aStacksize) {
        this.mConfigStackSize = (byte)UT.Code.bind_(this.mMinimumStackSize, 64L, aStacksize);
        this.mDefaultStackSize = (byte)UT.Code.bind_(this.mMinimumStackSize, 64L, aStacksize);
        return this;
    }

    public OreDictPrefix setStacksize(long aStacksize) {
        this.mDefaultStackSize = (byte)UT.Code.bind_(this.mMinimumStackSize, 64L, aStacksize);
        return this;
    }

    public OreDictPrefix setStacksize(long aStacksize, long aMinimumStacksize) {
        this.mMinimumStackSize = (byte)UT.Code.bind_(1L, 64L, aMinimumStacksize);
        this.mDefaultStackSize = (byte)UT.Code.bind_(this.mMinimumStackSize, 64L, aStacksize);
        return this;
    }

    public OreDictPrefix setMinStacksize(long aMinimumStacksize) {
        this.mMinimumStackSize = (byte)UT.Code.bind_(1L, 64L, aMinimumStacksize);
        this.mDefaultStackSize = (byte)UT.Code.bind_(this.mMinimumStackSize, 64L, this.mDefaultStackSize);
        return this;
    }

    public static void applyAllStackSizes() {
        for (OreDictPrefix tPrefix : VALUES) {
            tPrefix.applyStackSizes();
        }
    }

    public OreDictPrefix applyStackSizes() {
        if (this.contains(TD.Prefix.PREFIX_UNUSED)) {
            return this;
        }
        if (this != OP.block && this != OP.stone && this != OP.scrapGt) {
            this.addListener(new IOreDictListenerEvent(){

                @Override
                public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
                    if (!aEvent.mStack.func_77973_b().func_77645_m() && aEvent.mStack.func_77976_d() > 1 && !ST.isGT_(aEvent.mStack)) {
                        aEvent.mStack.func_77973_b().func_77625_d((int)aEvent.mPrefix.mDefaultStackSize);
                    }
                }
            });
        }
        Items.field_151086_cn.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151096_cd.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151094_cf.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151093_ce.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151091_cg.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151092_ch.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151089_ci.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151090_cj.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151087_ck.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151088_cl.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151084_co.func_77625_d((int)OP.record.mDefaultStackSize);
        Items.field_151085_cm.func_77625_d((int)OP.record.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150403_cj).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150432_aD).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150425_aM).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150426_aN).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150431_aC).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150433_aE).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150435_aG).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150379_bu).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150346_d).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150349_c).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150391_bh).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150351_n).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150354_m).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150325_L).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150440_ba).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150423_aK).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150428_aP).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150367_z).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150331_J).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150320_F).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150462_ai).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150421_aI).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150467_bQ).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150486_ae).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150447_bR).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150323_B).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150474_ac).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150342_X).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150460_al).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150470_am).func_77625_d((int)OP.block.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150322_A).func_77625_d((int)OP.stone.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150343_Z).func_77625_d((int)OP.stone.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150348_b).func_77625_d((int)OP.stone.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150333_U).func_77625_d((int)OP.slab.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150334_T).func_77625_d((int)OP.slab.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150376_bx).func_77625_d((int)OP.slab.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150373_bw).func_77625_d((int)OP.slab.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150390_bg).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150389_bf).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150387_bl).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150372_bz).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150446_ar).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150476_ad).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150481_bH).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150487_bG).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150485_bF).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150400_ck).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150401_cl).func_77625_d((int)OP.stair.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150359_w).func_77625_d((int)OP.glass.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150399_cn).func_77625_d((int)OP.glass.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150410_aZ).func_77625_d((int)OP.paneGlass.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150397_co).func_77625_d((int)OP.paneGlass.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150405_ch).func_77625_d((int)OP.stainedClay.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150406_ce).func_77625_d((int)OP.stainedClay.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150347_e).func_77625_d((int)OP.stoneCobble.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150422_aJ).func_77625_d((int)OP.fence.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150396_be).func_77625_d((int)OP.fence.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150463_bK).func_77625_d((int)OP.fence.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150386_bk).func_77625_d((int)OP.fence.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150341_Y).func_77625_d((int)OP.stoneMossy.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150417_aV).func_77625_d((int)OP.stoneBricks.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150336_V).func_77625_d((int)OP.stoneBricks.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150385_bj).func_77625_d((int)OP.stoneBricks.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150345_g).func_77625_d((int)OP.treeSapling.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150362_t).func_77625_d((int)OP.treeLeaves.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150361_u).func_77625_d((int)OP.treeLeaves.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150364_r).func_77625_d((int)OP.log.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150363_s).func_77625_d((int)OP.log.mDefaultStackSize);
        Item.func_150898_a((Block)Blocks.field_150344_f).func_77625_d((int)OP.plank.mDefaultStackSize);
        ST.forceProperMaxStacksizes();
        return this;
    }

    public OreDictPrefix setCategoryName(String aCategoryName) {
        this.mNameCategory = aCategoryName;
        return this;
    }

    public OreDictPrefix setTextureSetName(String aTextureSetName) {
        this.mNameTextureSet = aTextureSetName;
        return this;
    }

    public OreDictPrefix setState(long aState) {
        this.mState = UT.Code.bind2(aState);
        return this;
    }

    public OreDictPrefix setCondition(ICondition<?> aCondition) {
        this.mCondition = aCondition == null ? ICondition.FALSE : aCondition;
        return this;
    }

    public OreDictPrefix setLocalItemName(String aPreMaterial, String aPostMaterial) {
        this.mMaterialPre = aPreMaterial;
        this.mMaterialPost = aPostMaterial;
        return this;
    }

    public OreDictPrefix setLocalPrefixName(String aLocalName) {
        this.mNameLocal = aLocalName;
        return this;
    }

    public OreDictPrefix ignoreMaterials(OreDictMaterial ... aMaterials) {
        if (aMaterials != null) {
            for (OreDictMaterial aMaterial : aMaterials) {
                if (aMaterial == null || this.mIgnoredRegistrations.contains(aMaterial)) continue;
                this.mIgnoredRegistrations.add(aMaterial);
            }
        }
        return this;
    }

    public OreDictPrefix disableItemGeneration(OreDictMaterial ... aMaterials) {
        if (aMaterials != null) {
            for (OreDictMaterial aMaterial : aMaterials) {
                if (aMaterial == null || this.mItemGeneratorBlackList.contains(aMaterial)) continue;
                this.mItemGeneratorBlackList.add(aMaterial);
            }
        }
        return this;
    }

    public OreDictPrefix forceItemGeneration(OreDictMaterial ... aMaterials) {
        if (aMaterials != null) {
            for (OreDictMaterial aMaterial : aMaterials) {
                if (aMaterial == null || this.mItemGeneratorForced.contains(aMaterial)) continue;
                this.mItemGeneratorForced.add(aMaterial);
            }
        }
        return this;
    }

    public boolean isGeneratingItem(OreDictMaterial aMaterial) {
        return aMaterial != null && (this.mItemGeneratorForced.contains(aMaterial) || !this.mItemGeneratorBlackList.contains(aMaterial) && this.mCondition.isTrue(aMaterial));
    }

    public boolean canGenerateItem(OreDictMaterial aMaterial) {
        return aMaterial != null && (this.mItemGeneratorForced.contains(aMaterial) || this.mCondition.isTrue(aMaterial));
    }

    public OreDictPrefix addListener(IOreDictListenerEvent aListener) {
        if (CS.GAPI.mStartedPostInit) {
            this.addListenerInternal(aListener);
        } else {
            this.mBufferedListeners.add(aListener);
        }
        return this;
    }

    private void addListenerInternal(IOreDictListenerEvent aListener) {
        if (this.mListenersOre.add(aListener)) {
            for (IOreDictListenerEvent.OreDictRegistrationContainer tEvent : this.mRegistrations) {
                aListener.onOreRegistration(tEvent);
            }
        }
    }

    public void onPostLoad() {
        if (CS.GAPI.mStartedPostInit) {
            for (IOreDictListenerEvent aListener : this.mBufferedListeners) {
                this.addListenerInternal(aListener);
            }
        }
    }

    public OreDictPrefix addListener(IOreDictListenerItem aListener) {
        this.mListenersItem.add(aListener);
        return this;
    }

    public OreDictPrefix addTextureSet(String aModID, boolean aIsItem) {
        if (aIsItem) {
            this.mIconIndexItem = TextureSet.addToAll(aModID, aIsItem, this.mNameTextureSet);
        } else {
            this.mIconIndexBlock = TextureSet.addToAll(aModID, aIsItem, this.mNameTextureSet);
        }
        return this;
    }

    public OreDictPrefix addTextureSet(ModData aModID, boolean aIsItem) {
        if (aIsItem) {
            this.mIconIndexItem = TextureSet.addToAll(aModID.mID, aIsItem, this.mNameTextureSet);
        } else {
            this.mIconIndexBlock = TextureSet.addToAll(aModID.mID, aIsItem, this.mNameTextureSet);
        }
        return this;
    }

    public OreDictPrefix addAspects(TC.TC_AspectStack ... aAspects) {
        for (TC.TC_AspectStack tAspect : aAspects) {
            tAspect.addToAspectList(this.mAspects);
        }
        return this;
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1) {
        return this.addAspects(TC.stack(aAspect1, aAmount1));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9));
    }

    public OreDictPrefix aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9, TC aAspect0, long aAmount0) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9), TC.stack(aAspect0, aAmount0));
    }

    public ItemStack mat(OreDictMaterialStack aMaterial) {
        return OreDictManager.INSTANCE.getStack(this, aMaterial.mMaterial, CS.NI, aMaterial.mAmount / this.mAmount);
    }

    public ItemStack mat(OreDictMaterialStack aMaterial, long aStackSize) {
        return OreDictManager.INSTANCE.getStack(this, aMaterial.mMaterial, CS.NI, aStackSize);
    }

    public ItemStack mat(OreDictMaterial aMaterial, long aStackSize) {
        return OreDictManager.INSTANCE.getStack(this, aMaterial, CS.NI, aStackSize);
    }

    public ItemStack mat(OreDictMaterial aMaterial, long aStackSize, ItemStack aReplacement) {
        return OreDictManager.INSTANCE.getStack(this, aMaterial, aReplacement, aStackSize);
    }

    public ItemStack mat(OreDictMaterial aMaterial, ItemStack aReplacement, long aStackSize) {
        return OreDictManager.INSTANCE.getStack(this, aMaterial, aReplacement, aStackSize);
    }

    public OreDictMaterialStack byproduct(int aIndex) {
        return aIndex < this.mByProducts.size() ? this.mByProducts.get(aIndex) : null;
    }

    @Override
    public void onOreRegistration(IOreDictListenerEvent.OreDictRegistrationContainer aEvent) {
        if (aEvent.mMaterial == MT.NULL) {
            if (!this.contains(TD.Prefix.MATERIAL_BASED)) {
                if (!(CS.COMPAT_TC == null || aEvent.mStack.func_77973_b() instanceof IEssentiaContainerItem || aEvent.mStack.func_77973_b() instanceof MultiItemRandom || MD.MC.owns(aEvent.mRegName) || MD.TC.owns(aEvent.mRegName))) {
                    ArrayListNoNulls tAspects = new ArrayListNoNulls();
                    for (TC.TC_AspectStack tAspect : this.mAspects) {
                        tAspect.addToAspectList(tAspects);
                    }
                    CS.COMPAT_TC.registerThaumcraftAspectsToItem(ST.amount(1L, aEvent.mStack), (List<TC.TC_AspectStack>)tAspects, false);
                }
                for (IOreDictListenerEvent iOreDictListenerEvent : this.mListenersOre) {
                    if (CS.D2) {
                        CS.ORD.println("Processing '" + aEvent.mOreDictName + "' with the Prefix '" + this.mNameInternal + "' and without Material at " + UT.Reflection.getClassName(iOreDictListenerEvent));
                    }
                    iOreDictListenerEvent.onOreRegistration(aEvent);
                }
                this.mRegistrations.add(aEvent);
                if (!this.mRegisteredItems.contains(new ItemStackContainer(aEvent.mStack, 32767L))) {
                    this.mRegisteredItems.add(aEvent.mStack);
                }
            }
        } else if (!this.mIgnoredRegistrations.contains(aEvent.mMaterial)) {
            if (!aEvent.mMaterial.contains(TD.Properties.INVALID_MATERIAL)) {
                if (!(CS.COMPAT_TC == null || aEvent.mStack.func_77973_b() instanceof IEssentiaContainerItem || aEvent.mStack.func_77973_b() instanceof MultiItemRandom || MD.MC.owns(aEvent.mRegName) || MD.TC.owns(aEvent.mRegName))) {
                    ArrayListNoNulls<TC.TC_AspectStack> tAspects = new ArrayListNoNulls<TC.TC_AspectStack>();
                    for (TC.TC_AspectStack tAspect : this.mAspects) {
                        if (tAspect.mAspect == TC.METALLUM && !aEvent.mMaterial.mHasMetallum) {
                            TC.stack(TC.ORDO, tAspect.mAmount).addToAspectList(tAspects);
                            continue;
                        }
                        tAspect.addToAspectList(tAspects);
                    }
                    if (this.mAmount >= 648648000L || this.mAmount < 0L) {
                        for (TC.TC_AspectStack tAspect : aEvent.mMaterial.mAspects) {
                            tAspect.addToAspectList(tAspects);
                        }
                    }
                    CS.COMPAT_TC.registerThaumcraftAspectsToItem(ST.amount(1L, aEvent.mStack), tAspects, false);
                }
                for (IOreDictListenerEvent iOreDictListenerEvent : this.mListenersOre) {
                    if (CS.D2) {
                        CS.ORD.println("Processing '" + aEvent.mOreDictName + "' with the Prefix '" + this.mNameInternal + "' and the Material '" + aEvent.mMaterial.mNameInternal + "' at " + UT.Reflection.getClassName(iOreDictListenerEvent));
                    }
                    iOreDictListenerEvent.onOreRegistration(aEvent);
                }
                this.mRegistrations.add(aEvent);
            }
            aEvent.mMaterial.mRegisteredItems.add(new ItemStackContainer(aEvent.mStack));
            this.mRegisteredMaterials.add(aEvent.mMaterial);
            if (!this.mRegisteredItems.contains(new ItemStackContainer(aEvent.mStack, 32767L))) {
                this.mRegisteredItems.add(aEvent.mStack);
            }
        }
    }

    public boolean contains(ItemStack ... aStacks) {
        if (aStacks == null) {
            return false;
        }
        for (ItemStack aStack : aStacks) {
            if (!ST.valid(aStack) || !this.mRegisteredItems.contains(aStack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TagData aTag) {
        return this.mTags.contains(aTag);
    }

    public boolean containsAny(TagData ... aTags) {
        for (TagData aTag : aTags) {
            if (!this.mTags.contains(aTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TagData ... aTags) {
        return this.mTags.containsAll(Arrays.asList(aTags));
    }

    @Override
    public boolean containsAll(Collection<TagData> aTags) {
        return this.mTags.containsAll(aTags);
    }

    @Override
    public OreDictPrefix add(TagData ... aTags) {
        if (aTags != null) {
            for (TagData aTag : aTags) {
                this.mTags.add(aTag);
            }
        }
        return this;
    }

    @Override
    public boolean remove(TagData aTag) {
        return this.mTags.remove(aTag);
    }

    public OreDictItemData dat(OreDictMaterial aMaterial) {
        return new OreDictItemData(this, aMaterial);
    }

    @Deprecated
    public OreDictItemData get(OreDictMaterial aMaterial) {
        return new OreDictItemData(this, aMaterial);
    }

    public String toString() {
        return this.mNameInternal;
    }

    @Override
    public boolean isTrue(ITagDataContainer<?> aMaterial) {
        return aMaterial instanceof OreDictMaterial && this.canGenerateItem((OreDictMaterial)aMaterial);
    }
}

