/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ICondition;
import gregapi.code.ITagDataContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.oredict.configurations.OreDictConfigurationComponent;
import gregapi.oredict.listeners.IOreDictListenerItem;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.render.TextureSet;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.fluids.FluidStack;

public final class OreDictMaterial
implements ITagDataContainer<OreDictMaterial>,
ICondition<OreDictMaterial> {
    public static final Map<String, OreDictMaterial> MATERIAL_MAP = new HashMap<String, OreDictMaterial>();
    public static final Map<String, OreDictMaterialStack> FLUID_MAP = new HashMap<String, OreDictMaterialStack>();
    public static final OreDictMaterial[] MATERIAL_ARRAY = new OreDictMaterial[Short.MAX_VALUE];
    public static final Set<OreDictMaterial> ALLOYS = new HashSetNoNulls<OreDictMaterial>();
    public static int sHashID = 0;
    private static final Set<String> INVALID_STRINGS_TO_START_A_MATERIAL_NAME = new HashSetNoNulls<String>(Arrays.asList("Mul", "Div", "Rich", "Poor", "Raw", "Impure", "Pure", "Dirty", "Refined", "Tiny", "Small", "Normal", "Medium", "Large", "Huge", "Dense", "Alloy", "Head", "Tool", "Helmet", "Chestplate", "Leggings", "Boots", "Centrifuged", "Purified", "Quintuple", "Quadruple", "Triple", "Double", "Hot", "Uncut", "Polished", "Chipped", "Flawed", "Flawless", "Exquisite", "Gt", "Long", "Plasma", "Gas", "Liquid", "Solid", "Gem", "Dust", "Ingot", "Plate", "Block", "Leaves", "Sapling", "Mossy", "Brick", "Crack", "Chisel", "Broken", "Compact", "Curve", "Mixed", "Mixable"));
    public final short mID;
    private final int mHashID;
    public final String mNameInternal;
    public String mNameLocal;
    public ModData mOriginalMod = null;
    public ItemStack mDictionaryBook = null;
    public String[] mDescription = null;
    public String mTooltipChemical = null;
    public byte mOreMultiplier = 1;
    public byte mOreProcessingMultiplier = 1;
    public long mFurnaceBurnTime = 0L;
    public byte mToolTypes = 0;
    public byte mToolQuality = 0;
    public long mToolDurability = 0L;
    public float mToolSpeed = 1.0f;
    public float mHeatDamage = 0.0f;
    public boolean mHidden = false;
    public boolean mHasMetallum = false;
    public double mGramPerCubicCentimeter = 1.0;
    public final short[] mRGBaSolid = new short[]{255, 255, 255, 255};
    public final short[] mRGBaLiquid = new short[]{255, 255, 255, 255};
    public final short[] mRGBaGas = new short[]{255, 255, 255, 255};
    public final short[] mRGBaPlasma = new short[]{255, 255, 255, 255};
    public final short[][] mRGBa = new short[][]{this.mRGBaSolid, this.mRGBaLiquid, this.mRGBaGas, this.mRGBaPlasma};
    public final short[] fRGBaSolid = new short[]{255, 255, 255, 255};
    public final short[] fRGBaLiquid = new short[]{255, 255, 255, 255};
    public final short[] fRGBaGas = new short[]{255, 255, 255, 255};
    public final short[] fRGBaPlasma = new short[]{255, 255, 255, 255};
    public final short[][] fRGBa = new short[][]{this.fRGBaSolid, this.fRGBaLiquid, this.fRGBaGas, this.fRGBaPlasma};
    public long mMeltingPoint = 1000L;
    public long mBoilingPoint = 3000L;
    public long mPlasmaPoint = 10000L;
    public long mNeutrons = 55L;
    public long mProtons = 43L;
    public long mElectrons = 43L;
    public long mMass = this.mNeutrons + this.mProtons;
    public List<IIconContainer> mTextureSetsBlock;
    public List<IIconContainer> mTextureSetsItems;
    public ITexture mTextureSolid;
    public ITexture mTextureSmooth;
    public ITexture mTextureMolten;
    public ITexture mTextureDust;
    public ITexture mTextureGem;
    public final List<TC.TC_AspectStack> mAspects;
    public IOreDictConfigurationComponent mComponents;
    public final Set<OreDictMaterial> mReRegistrations;
    public final Set<OreDictMaterial> mToThis;
    public final List<OreDictMaterial> mByProducts;
    public final Set<OreDictMaterial> mAlloyComponentReferences;
    public final Set<OreDictMaterial> mSourceOf;
    public final List<IOreDictConfigurationComponent> mAlloyCreationRecipes;
    public final List<Achievement> mAchievementsForCreation;
    public int mPriorityPrefixIndex;
    public OreDictPrefix mPriorityPrefix;
    public OreDictMaterial mTargetReversing;
    public OreDictMaterial mTargetRegistration;
    public OreDictMaterial mHandleMaterial;
    public OreDictMaterialStack mTargetCrushing;
    public OreDictMaterialStack mTargetPulver;
    public OreDictMaterialStack mTargetSmelting;
    public OreDictMaterialStack mTargetSolidifying;
    public OreDictMaterialStack mTargetSmashing;
    public OreDictMaterialStack mTargetCutting;
    public OreDictMaterialStack mTargetWorking;
    public OreDictMaterialStack mTargetForging;
    public OreDictMaterialStack mTargetBurning;
    public OreDictMaterialStack mTargetBending;
    public OreDictMaterialStack mTargetCompressing;
    public final Set<OreDictMaterial> mTargetedCrushing;
    public final Set<OreDictMaterial> mTargetedPulver;
    public final Set<OreDictMaterial> mTargetedSmelting;
    public final Set<OreDictMaterial> mTargetedSolidifying;
    public final Set<OreDictMaterial> mTargetedSmashing;
    public final Set<OreDictMaterial> mTargetedCutting;
    public final Set<OreDictMaterial> mTargetedWorking;
    public final Set<OreDictMaterial> mTargetedForging;
    public final Set<OreDictMaterial> mTargetedBurning;
    public final Set<OreDictMaterial> mTargetedBending;
    public final Set<OreDictMaterial> mTargetedCompressing;
    public long mLiquidUnit;
    public long mGasUnit;
    public long mPlasmaUnit;
    public FluidStack mLiquid;
    public FluidStack mGas;
    public FluidStack mPlasma;
    private final Set<TagData> mTags;
    public final List<ObjectStack<Enchantment>> mEnchantmentTools;
    public final List<ObjectStack<Enchantment>> mEnchantmentWeapons;
    public final List<ObjectStack<Enchantment>> mEnchantmentAmmo;
    public final List<ObjectStack<Enchantment>> mEnchantmentRanged;
    public final List<ObjectStack<Enchantment>> mEnchantmentFishing;
    public final List<ObjectStack<Enchantment>> mEnchantmentArmors;
    public final List<IOreDictListenerItem> mListenersItem;
    public final ItemStackSet<ItemStackContainer> mRegisteredItems;
    public final ICondition<ITagDataContainer> NOT;

    public static OreDictMaterial createMaterial(int aID, String aNameOreDict, String aLocalName) {
        OreDictMaterial rMaterial1;
        aID = aID < 0 || aID >= MATERIAL_ARRAY.length || aID == Short.MAX_VALUE ? -1 : aID;
        if ((aNameOreDict = UT.Code.capitalise(aNameOreDict.replaceAll(" ", "").replaceAll("-", "").replaceAll("'", "").replaceAll("/", ""))).isEmpty()) {
            throw new IllegalArgumentException("This OreDict Name is not usable, due to being an empty String, after stripping all the minuses and spaces.");
        }
        if (aNameOreDict.contains("|") || aNameOreDict.contains("*") || aNameOreDict.contains(":") || aNameOreDict.contains(".") || aNameOreDict.contains("$")) {
            throw new IllegalArgumentException("The Material Name contains at least one of the following five invalid Characters '|', '*', ':', '.' or '$'");
        }
        if (aID >= 0) {
            if (CS.GAPI.mStartedInit) {
                throw new IllegalStateException("Materials with a valid ID have to be initialised in PreInit or earlier!");
            }
            if (CS.Ch_N.contains(Character.valueOf(aNameOreDict.charAt(0)))) {
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material. Choose a different one, which doesn't happen to start with a Numeral. You can always set the Local Name to your liking, but the internal Name must always be a proper one.");
            }
            if (INVALID_STRINGS_TO_START_A_MATERIAL_NAME.contains(aNameOreDict)) {
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material. Choose a different one, which doesn't happen to be a blacklisted Adjective. You can always set the Local Name to your liking, but the internal Name must always be a proper one.");
            }
            for (String tInvalidString : INVALID_STRINGS_TO_START_A_MATERIAL_NAME) {
                if (!aNameOreDict.startsWith(tInvalidString)) continue;
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material, as it conflicts with OreDict Prefixes. A better Name for your Material would be '" + UT.Code.capitalise(aNameOreDict.replaceFirst(tInvalidString, "")) + tInvalidString + "' with the '" + tInvalidString + "' at the end of the Material Name instead of the beginning.");
            }
        }
        if ((rMaterial1 = MATERIAL_MAP.get(aNameOreDict)) == null) {
            return new OreDictMaterial((short)aID, aNameOreDict, aLocalName);
        }
        if (aID < 0) {
            return rMaterial1;
        }
        if (rMaterial1.mID == aID) {
            CS.ERR.println("NOTICE: Two Materials used the same ID: " + aID + " - Names: " + aNameOreDict + " and " + rMaterial1.mNameInternal);
            return rMaterial1;
        }
        OreDictMaterial rMaterial2 = new OreDictMaterial((short)aID, aNameOreDict, aLocalName);
        rMaterial1.setRegistration(rMaterial2);
        return rMaterial2;
    }

    public static OreDictMaterial createAutoInvalidMaterial(String aNameOreDict) {
        OreDictMaterial rMaterial = OreDictMaterial.createMaterial(-1, aNameOreDict, aNameOreDict);
        if (rMaterial.mID < 0) {
            rMaterial.put(TD.Properties.INVALID_MATERIAL, TD.Properties.UNUSED_MATERIAL, TD.Properties.AUTO_BLACKLIST, TD.Properties.AUTO_MATERIAL);
        }
        return rMaterial;
    }

    public static OreDictMaterial get(String aMaterialName, OreDictMaterial aDefault) {
        OreDictMaterial rMaterial = MATERIAL_MAP.get(aMaterialName);
        return rMaterial == null ? aDefault : OreDictMaterial.get(rMaterial);
    }

    public static OreDictMaterial get(String aMaterialName) {
        return OreDictMaterial.get(aMaterialName, MT.NULL);
    }

    public static OreDictMaterial get(long aMaterialID, OreDictMaterial aDefault) {
        if (aMaterialID < 0L || aMaterialID >= (long)MATERIAL_ARRAY.length || aMaterialID == 32767L) {
            return aDefault;
        }
        OreDictMaterial rMaterial = MATERIAL_ARRAY[(int)aMaterialID];
        return rMaterial == null ? aDefault : OreDictMaterial.get(rMaterial);
    }

    public static OreDictMaterial get(long aMaterialID) {
        return OreDictMaterial.get(aMaterialID, MT.NULL);
    }

    public static OreDictMaterial get(OreDictMaterial aMaterial) {
        while (aMaterial != aMaterial.mTargetRegistration) {
            aMaterial = aMaterial.mTargetRegistration;
        }
        return aMaterial;
    }

    private OreDictMaterial(short aID, String aNameInternal, String aNameLocal) {
        this.mTextureSetsBlock = TextureSet.SET_NONE[0].mList;
        this.mTextureSetsItems = TextureSet.SET_NONE[1].mList;
        this.mTextureSolid = null;
        this.mTextureSmooth = null;
        this.mTextureMolten = null;
        this.mTextureDust = null;
        this.mTextureGem = null;
        this.mAspects = new ArrayListNoNulls<TC.TC_AspectStack>(1);
        this.mComponents = null;
        this.mReRegistrations = new HashSetNoNulls<OreDictMaterial>();
        this.mToThis = new HashSetNoNulls<OreDictMaterial>();
        this.mByProducts = new ArrayListNoNulls<OreDictMaterial>();
        this.mAlloyComponentReferences = new HashSetNoNulls<OreDictMaterial>();
        this.mSourceOf = new HashSetNoNulls<OreDictMaterial>();
        this.mAlloyCreationRecipes = new ArrayListNoNulls<IOreDictConfigurationComponent>();
        this.mAchievementsForCreation = new ArrayListNoNulls<Achievement>();
        this.mPriorityPrefixIndex = 0;
        this.mPriorityPrefix = null;
        this.mTargetReversing = this;
        this.mTargetRegistration = this;
        this.mHandleMaterial = this;
        this.mTargetCrushing = OM.stack(this, 648648000L);
        this.mTargetPulver = OM.stack(this, 648648000L);
        this.mTargetSmelting = OM.stack(this, 648648000L);
        this.mTargetSolidifying = OM.stack(this, 648648000L);
        this.mTargetSmashing = OM.stack(this, 648648000L);
        this.mTargetCutting = OM.stack(this, 648648000L);
        this.mTargetWorking = OM.stack(this, 648648000L);
        this.mTargetForging = OM.stack(this, 648648000L);
        this.mTargetBurning = OM.stack(this, 0L);
        this.mTargetBending = OM.stack(this, 648648000L);
        this.mTargetCompressing = OM.stack(this, 648648000L);
        this.mTargetedCrushing = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedPulver = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedSmelting = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedSolidifying = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedSmashing = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedCutting = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedWorking = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedForging = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedBurning = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedBending = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mTargetedCompressing = new HashSetNoNulls<OreDictMaterial>(false, this);
        this.mLiquidUnit = 648648000L;
        this.mGasUnit = 648648000L;
        this.mPlasmaUnit = 648648000L;
        this.mTags = new HashSetNoNulls<TagData>();
        this.mEnchantmentTools = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentWeapons = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentAmmo = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentRanged = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentFishing = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentArmors = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mListenersItem = new ArrayListNoNulls<IOreDictListenerItem>();
        this.mRegisteredItems = ST.hashset(new ItemStack[0]);
        this.NOT = new ICondition.Not<OreDictMaterial>(this);
        this.mID = aID;
        this.mNameInternal = aNameInternal;
        this.mNameLocal = aNameLocal;
        MATERIAL_MAP.put(this.mNameInternal, this);
        if (this.mID >= 0) {
            OreDictMaterial.MATERIAL_ARRAY[this.mID] = this;
        }
        this.mHashID = sHashID++;
    }

    public OreDictMaterial setLocal(String aNameLocal) {
        this.mNameLocal = aNameLocal == null ? this.mNameInternal : aNameLocal;
        return this;
    }

    public String getLocal() {
        return LanguageHandler.translate("gt.material." + this.mNameInternal, this.mNameLocal);
    }

    public OreDictMaterial setOriginalMod(ModData aOriginalMod) {
        this.mOriginalMod = aOriginalMod == null ? this.mOriginalMod : aOriginalMod;
        return this;
    }

    public OreDictMaterial setOriginalMod(String aModID, String aModName) {
        this.mOriginalMod = new ModData(aModID, aModName);
        return this;
    }

    public OreDictMaterial addIdenticalNames(String ... aNames) {
        for (String aName : aNames) {
            this.addReRegistrations(OreDictMaterial.createMaterial(-1, aName, aName).setRegistration(this));
        }
        return this;
    }

    public OreDictMaterial addReRegistrations(OreDictMaterial ... aMaterials) {
        for (OreDictMaterial aMaterial : aMaterials) {
            if (!this.mReRegistrations.add(aMaterial)) continue;
            aMaterial.mToThis.add(this);
        }
        return this;
    }

    public OreDictMaterial addReRegistrationToThis(OreDictMaterial ... aMaterials) {
        for (OreDictMaterial aMaterial : aMaterials) {
            aMaterial.addReRegistrations(this);
        }
        return this;
    }

    public OreDictMaterial setRegistration(OreDictMaterial aMaterial) {
        this.mTargetRegistration = aMaterial == null ? this : aMaterial.mTargetRegistration;
        this.put(TD.Properties.INVALID_MATERIAL);
        return this;
    }

    public OreDictMaterial addSourceOf(OreDictMaterial ... aMaterials) {
        this.mSourceOf.addAll(Arrays.asList(aMaterials));
        return this;
    }

    public OreDictMaterial hide() {
        this.mHidden = true;
        return this;
    }

    public OreDictMaterial hide(boolean aHidden) {
        this.mHidden = aHidden;
        return this;
    }

    public OreDictMaterial visName(String ... aOreDictNames) {
        for (String tName : aOreDictNames) {
            OreDictManager.INSTANCE.addVisibilityTrigger(tName, this);
        }
        return this;
    }

    public OreDictMaterial visPrefix(String ... aOreDictNames) {
        for (String tName : aOreDictNames) {
            OreDictManager.INSTANCE.addVisibilityTrigger(tName + this.mNameInternal, this);
        }
        return this;
    }

    public OreDictMaterial visDefault(OreDictMaterial ... aMaterials) {
        if (this.mOriginalMod != null && this.mOriginalMod != MD.GAPI && this.mOriginalMod.mLoaded) {
            return this;
        }
        this.hide();
        this.visName("ore" + this.mNameInternal, "dust" + this.mNameInternal, "gem" + this.mNameInternal, "ingot" + this.mNameInternal, "plate" + this.mNameInternal, "stick" + this.mNameInternal);
        for (OreDictMaterial tMaterial : aMaterials) {
            this.visName("ore" + tMaterial.mNameInternal, "dust" + tMaterial.mNameInternal, "gem" + tMaterial.mNameInternal, "ingot" + tMaterial.mNameInternal, "plate" + tMaterial.mNameInternal, "stick" + tMaterial.mNameInternal);
        }
        return this;
    }

    public OreDictMaterial lens(byte aColor) {
        this.put(TD.ItemGenerator.LENSES);
        OreDictManager.INSTANCE.addReRegistration("lens" + this.mNameInternal, "craftingLens" + CS.DYE_OREDICTS_POST[aColor]);
        return this;
    }

    public OreDictMaterial alloyCentrifuge() {
        return this.put(TD.Processing.CENTRIFUGE).alloySimple();
    }

    public OreDictMaterial alloyElectrolyzer() {
        return this.put(TD.Processing.ELECTROLYSER).alloySimple();
    }

    public OreDictMaterial alloySimple() {
        this.mAlloyCreationRecipes.add(this.mComponents);
        return this.put(TD.Compounds.ALLOY, TD.Compounds.DECOMPOSABLE, TD.Processing.CRUCIBLE_ALLOY);
    }

    public OreDictMaterial alloyCentrifuge(long aMelt) {
        return this.put(TD.Processing.CENTRIFUGE).alloySimple(aMelt);
    }

    public OreDictMaterial alloyElectrolyzer(long aMelt) {
        return this.put(TD.Processing.ELECTROLYSER).alloySimple(aMelt);
    }

    public OreDictMaterial alloySimple(long aMelt) {
        this.mAlloyCreationRecipes.add(this.mComponents);
        return this.put(TD.Compounds.ALLOY, TD.Compounds.DECOMPOSABLE, TD.Processing.CRUCIBLE_ALLOY).heat(aMelt);
    }

    public OreDictMaterial alloyCentrifuge(long aMelt, long aBoil) {
        return this.put(TD.Processing.CENTRIFUGE).alloySimple(aMelt, aBoil);
    }

    public OreDictMaterial alloyElectrolyzer(long aMelt, long aBoil) {
        return this.put(TD.Processing.ELECTROLYSER).alloySimple(aMelt, aBoil);
    }

    public OreDictMaterial alloySimple(long aMelt, long aBoil) {
        this.mAlloyCreationRecipes.add(this.mComponents);
        return this.put(TD.Compounds.ALLOY, TD.Compounds.DECOMPOSABLE, TD.Processing.CRUCIBLE_ALLOY).heat(aMelt, aBoil);
    }

    public OreDictMaterial alloyCentrifuge(OreDictMaterial aHeat) {
        return this.put(TD.Processing.CENTRIFUGE).alloySimple(aHeat);
    }

    public OreDictMaterial alloyElectrolyzer(OreDictMaterial aHeat) {
        return this.put(TD.Processing.ELECTROLYSER).alloySimple(aHeat);
    }

    public OreDictMaterial alloySimple(OreDictMaterial aHeat) {
        return this.put(TD.Compounds.ALLOY, TD.Compounds.DECOMPOSABLE, TD.Processing.CRUCIBLE_ALLOY).heat(aHeat);
    }

    public OreDictMaterial addAlloyingRecipe(IOreDictConfigurationComponent aConfiguration) {
        ALLOYS.add(this);
        for (OreDictMaterialStack tMaterial : aConfiguration.getUndividedComponents()) {
            if (tMaterial.mMaterial != MT.Air) {
                if (this.mMeltingPoint >= tMaterial.mMaterial.mBoilingPoint) {
                    this.mMeltingPoint = Math.max(293L, tMaterial.mMaterial.mBoilingPoint - 20L);
                }
                if (this.mMeltingPoint >= tMaterial.mMaterial.mBoilingPoint) {
                    CS.ERR.println("The Alloy '" + this.mNameInternal + "' cannot be created due to the Melting Point being higher than the Boiling Point of its Component '" + tMaterial.mMaterial.mNameInternal + "'");
                }
            }
            tMaterial.mMaterial.mAlloyComponentReferences.add(this);
        }
        this.mAlloyCreationRecipes.add(aConfiguration);
        return this;
    }

    public OreDictMaterial setMoleculeConfiguration(IOreDictConfigurationComponent aComponents) {
        this.mComponents = aComponents;
        double tDivider = 0.0;
        double tProtons = 0.0;
        double tElectrons = 0.0;
        double tNeutrons = 0.0;
        double tMass = 0.0;
        double tGramPerCubicCentimeter = 0.0;
        double tMeltingPoint = 0.0;
        double tBoilingPoint = 0.0;
        double tPlasmaPoint = 0.0;
        for (OreDictMaterialStack tMaterial : aComponents.getComponents()) {
            tDivider += (double)tMaterial.mAmount;
        }
        for (OreDictMaterialStack tMaterial : aComponents.getComponents()) {
            tProtons += (double)(tMaterial.mMaterial.mProtons * tMaterial.mAmount) / 6.48648E8;
            tElectrons += (double)(tMaterial.mMaterial.mElectrons * tMaterial.mAmount) / 6.48648E8;
            tNeutrons += (double)(tMaterial.mMaterial.mNeutrons * tMaterial.mAmount) / 6.48648E8;
            tMass += (double)(tMaterial.mMaterial.mMass * tMaterial.mAmount) / 6.48648E8;
            tGramPerCubicCentimeter += tMaterial.mMaterial.mGramPerCubicCentimeter * (double)tMaterial.mAmount / 6.48648E8;
            tMeltingPoint += (double)(tMaterial.mMaterial.mMeltingPoint * tMaterial.mAmount) / tDivider;
            tBoilingPoint += (double)(tMaterial.mMaterial.mBoilingPoint * tMaterial.mAmount) / tDivider;
            tPlasmaPoint += (double)(tMaterial.mMaterial.mPlasmaPoint * tMaterial.mAmount) / tDivider;
        }
        this.mProtons = (long)tProtons;
        this.mElectrons = (long)tElectrons;
        this.mNeutrons = (long)tNeutrons;
        this.mMass = (long)tMass;
        this.mMeltingPoint = Math.max(1L, (long)tMeltingPoint);
        this.mBoilingPoint = Math.max(this.mMeltingPoint + 1L, (long)tBoilingPoint);
        this.mPlasmaPoint = Math.max(this.mBoilingPoint + 1L, (long)tPlasmaPoint);
        this.mGramPerCubicCentimeter = tGramPerCubicCentimeter;
        if (!this.contains(TD.Compounds.APPROXIMATE) && this.containsAny(TD.Processing.UUM, TD.Compounds.DECOMPOSABLE)) {
            this.mTooltipChemical = "";
            ArrayListNoNulls<OreDictMaterialStack> tComponents = aComponents.getUndividedComponents();
            if (tComponents.size() == 1 && ((OreDictMaterialStack)tComponents.get((int)0)).mAmount == 648648000L) {
                this.mTooltipChemical = ((OreDictMaterialStack)tComponents.get((int)0)).mMaterial.mTooltipChemical;
            } else {
                for (OreDictMaterialStack tMaterial : tComponents) {
                    this.mTooltipChemical = UT.Code.stringValid(tMaterial.mMaterial.mTooltipChemical) && !tMaterial.mMaterial.contains(TD.Compounds.APPROXIMATE) ? (tMaterial.mMaterial.contains(TD.Atomic.ELEMENT) || tMaterial.mMaterial.mComponents == null || tMaterial.mMaterial.mComponents.getUndividedComponents().size() == 1 && ((OreDictMaterialStack)tMaterial.mMaterial.mComponents.getComponents().get((int)0)).mAmount == 648648000L ? this.mTooltipChemical + tMaterial.mMaterial.mTooltipChemical : this.mTooltipChemical + "(" + tMaterial.mMaterial.mTooltipChemical + ")") : this.mTooltipChemical + "(" + tMaterial.mMaterial.mNameLocal + ")";
                    if (tMaterial.mAmount <= 648648000L) continue;
                    if (tMaterial.mMaterial.mComponents == null) {
                        this.mTooltipChemical = this.mTooltipChemical + CS.NUM_SUB[(int)UT.Code.bind(0L, CS.NUM_SUB.length - 1, tMaterial.mAmount / 648648000L)];
                        continue;
                    }
                    if (tMaterial.mAmount / 648648000L % tMaterial.mMaterial.mComponents.getCommonDivider() == 0L) {
                        if (tMaterial.mAmount / 648648000L / tMaterial.mMaterial.mComponents.getCommonDivider() <= 1L) continue;
                        this.mTooltipChemical = this.mTooltipChemical + CS.NUM_SUB[(int)UT.Code.bind(0L, CS.NUM_SUB.length - 1, tMaterial.mAmount / 648648000L / tMaterial.mMaterial.mComponents.getCommonDivider())];
                        continue;
                    }
                    this.mTooltipChemical = this.mTooltipChemical + CS.NUM_SUB[(int)UT.Code.bind(0L, CS.NUM_SUB.length - 1, tMaterial.mAmount / 648648000L)] + "," + CS.NUM_SUB[(int)UT.Code.bind(0L, CS.NUM_SUB.length - 1, tMaterial.mMaterial.mComponents.getCommonDivider())];
                }
            }
        }
        return this;
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1;
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2;
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3;
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4;
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5;
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6) {
        long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5 + aAmount6;
        if (aCommonDivider == 0L) {
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5), OM.stack(aMaterial6, aAmount6)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7) {
        long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5 + aAmount6 + aAmount7;
        if (aCommonDivider == 0L) {
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5), OM.stack(aMaterial6, aAmount6), OM.stack(aMaterial7, aAmount7)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8) {
        long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5 + aAmount6 + aAmount7 + aAmount8;
        if (aCommonDivider == 0L) {
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5), OM.stack(aMaterial6, aAmount6), OM.stack(aMaterial7, aAmount7), OM.stack(aMaterial8, aAmount8)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8, OreDictMaterial aMaterial9, long aAmount9) {
        long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5 + aAmount6 + aAmount7 + aAmount8 + aAmount9;
        if (aCommonDivider == 0L) {
            aCommonDivider = tAmount / 648648000L;
            if (tAmount % 648648000L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5), OM.stack(aMaterial6, aAmount6), OM.stack(aMaterial7, aAmount7), OM.stack(aMaterial8, aAmount8), OM.stack(aMaterial9, aAmount9)));
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1) {
        if (aMaterial1.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM) && aMaterial5.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM) && aMaterial5.contains(TD.Processing.UUM) && aMaterial6.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM) && aMaterial5.contains(TD.Processing.UUM) && aMaterial6.contains(TD.Processing.UUM) && aMaterial7.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM) && aMaterial5.contains(TD.Processing.UUM) && aMaterial6.contains(TD.Processing.UUM) && aMaterial7.contains(TD.Processing.UUM) && aMaterial8.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8);
    }

    public OreDictMaterial uumMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8, OreDictMaterial aMaterial9, long aAmount9) {
        if (aMaterial1.contains(TD.Processing.UUM) && aMaterial2.contains(TD.Processing.UUM) && aMaterial3.contains(TD.Processing.UUM) && aMaterial4.contains(TD.Processing.UUM) && aMaterial5.contains(TD.Processing.UUM) && aMaterial6.contains(TD.Processing.UUM) && aMaterial7.contains(TD.Processing.UUM) && aMaterial8.contains(TD.Processing.UUM) && aMaterial9.contains(TD.Processing.UUM)) {
            this.put(TD.Processing.UUM);
        } else {
            CS.ERR.println("WARNING: " + this.mNameInternal + " has a UUM Config with impossible Materials.");
        }
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8, aMaterial9, aAmount9);
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8).alloyCentrifuge();
    }

    public OreDictMaterial setAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8, OreDictMaterial aMaterial9, long aAmount9) {
        return this.setMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8, aMaterial9, aAmount9).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8).alloyCentrifuge();
    }

    public OreDictMaterial uumAloy(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6, OreDictMaterial aMaterial7, long aAmount7, OreDictMaterial aMaterial8, long aAmount8, OreDictMaterial aMaterial9, long aAmount9) {
        return this.uumMcfg(aCommonDivider, aMaterial1, aAmount1, aMaterial2, aAmount2, aMaterial3, aAmount3, aMaterial4, aAmount4, aMaterial5, aAmount5, aMaterial6, aAmount6, aMaterial7, aAmount7, aMaterial8, aAmount8, aMaterial9, aAmount9).alloyCentrifuge();
    }

    @Deprecated
    public OreDictMaterial setTooltip(String aTooltip) {
        this.mTooltipChemical = aTooltip;
        return this;
    }

    public OreDictMaterial tooltip(String aTooltip) {
        this.mTooltipChemical = aTooltip;
        return this;
    }

    public OreDictMaterial handle(OreDictMaterial aHandle) {
        this.mHandleMaterial = aHandle;
        return this;
    }

    public OreDictMaterial setAllToTheOutputOf(OreDictMaterial aMaterial) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.setPulver(aMaterial.mTargetPulver.mMaterial, aMaterial.mTargetPulver.mAmount);
        this.setSmelting(aMaterial.mTargetSmelting.mMaterial, aMaterial.mTargetSmelting.mAmount);
        this.setSolidifying(aMaterial.mTargetSolidifying.mMaterial, aMaterial.mTargetSolidifying.mAmount);
        this.setSmashing(aMaterial.mTargetSmashing.mMaterial, aMaterial.mTargetSmashing.mAmount);
        this.setCutting(aMaterial.mTargetCutting.mMaterial, aMaterial.mTargetCutting.mAmount);
        this.setWorking(aMaterial.mTargetWorking.mMaterial, aMaterial.mTargetWorking.mAmount);
        this.setForging(aMaterial.mTargetForging.mMaterial, aMaterial.mTargetForging.mAmount);
        this.setBurning(aMaterial.mTargetBurning.mMaterial, aMaterial.mTargetBurning.mAmount);
        this.setBending(aMaterial.mTargetBending.mMaterial, aMaterial.mTargetBending.mAmount);
        this.setCompressing(aMaterial.mTargetCompressing.mMaterial, aMaterial.mTargetCompressing.mAmount);
        return this;
    }

    public OreDictMaterial setAllToTheOutputOf(OreDictMaterial aMaterial, long aMultiplier, long aDivider) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.setPulver(aMaterial.mTargetPulver.mMaterial, aMaterial.mTargetPulver.mAmount * aMultiplier / aDivider);
        this.setSmelting(aMaterial.mTargetSmelting.mMaterial, aMaterial.mTargetSmelting.mAmount * aMultiplier / aDivider);
        this.setSolidifying(aMaterial.mTargetSolidifying.mMaterial, aMaterial.mTargetSolidifying.mAmount * aMultiplier / aDivider);
        this.setSmashing(aMaterial.mTargetSmashing.mMaterial, aMaterial.mTargetSmashing.mAmount * aMultiplier / aDivider);
        this.setCutting(aMaterial.mTargetCutting.mMaterial, aMaterial.mTargetCutting.mAmount * aMultiplier / aDivider);
        this.setWorking(aMaterial.mTargetWorking.mMaterial, aMaterial.mTargetWorking.mAmount * aMultiplier / aDivider);
        this.setForging(aMaterial.mTargetForging.mMaterial, aMaterial.mTargetForging.mAmount * aMultiplier / aDivider);
        this.setBurning(aMaterial.mTargetBurning.mMaterial, aMaterial.mTargetBurning.mAmount * aMultiplier / aDivider);
        this.setBending(aMaterial.mTargetBending.mMaterial, aMaterial.mTargetBending.mAmount * aMultiplier / aDivider);
        this.setCompressing(aMaterial.mTargetCompressing.mMaterial, aMaterial.mTargetCompressing.mAmount * aMultiplier / aDivider);
        this.setCrushing(aMaterial.mTargetCrushing.mMaterial, aMaterial.mTargetCrushing.mAmount * aMultiplier / aDivider);
        return this;
    }

    public OreDictMaterial setCrushing(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetCrushing.mMaterial.mTargetedCrushing.remove(this);
        this.mTargetCrushing = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedCrushing.add(this);
        return this;
    }

    public OreDictMaterial setPulver(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetPulver.mMaterial.mTargetedPulver.remove(this);
        this.mTargetPulver = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedPulver.add(this);
        return this;
    }

    public OreDictMaterial setSmelting(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetSmelting.mMaterial.mTargetedSmelting.remove(this);
        this.mTargetSmelting = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedSmelting.add(this);
        if (aAmount > 0L) {
            this.put(TD.Processing.MELTING);
        }
        return this;
    }

    public OreDictMaterial setSolidifying(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetSolidifying.mMaterial.mTargetedSolidifying.remove(this);
        this.mTargetSolidifying = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedSolidifying.add(this);
        return this;
    }

    public OreDictMaterial setSmashing(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetSmashing.mMaterial.mTargetedSmashing.remove(this);
        this.mTargetSmashing = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedSmashing.add(this);
        return this;
    }

    public OreDictMaterial setCutting(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetCutting.mMaterial.mTargetedCutting.remove(this);
        this.mTargetCutting = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedCutting.add(this);
        return this;
    }

    public OreDictMaterial setWorking(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetWorking.mMaterial.mTargetedWorking.remove(this);
        this.mTargetWorking = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedWorking.add(this);
        return this;
    }

    public OreDictMaterial setForging(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetForging.mMaterial.mTargetedForging.remove(this);
        this.mTargetForging = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedForging.add(this);
        return this;
    }

    public OreDictMaterial setBurning(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetBurning.mMaterial.mTargetedBurning.remove(this);
        this.mTargetBurning = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedBurning.add(this);
        return this;
    }

    public OreDictMaterial setBending(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetBending.mMaterial.mTargetedBending.remove(this);
        this.mTargetBending = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedBending.add(this);
        return this;
    }

    public OreDictMaterial setCompressing(OreDictMaterial aMaterial, long aAmount) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.mTargetCompressing.mMaterial.mTargetedCompressing.remove(this);
        this.mTargetCompressing = OM.stack(aMaterial, aAmount);
        aMaterial.mTargetedCompressing.add(this);
        return this;
    }

    @Deprecated
    public OreDictMaterial setQuality(float aToolSpeed, long aToolDurability, long aToolQuality) {
        return this.qual(3L, aToolSpeed, aToolDurability, aToolQuality);
    }

    public OreDictMaterial qual(long aHarvestLevel) {
        return this.qual(this.mToolTypes, this.mToolSpeed, this.mToolDurability, aHarvestLevel);
    }

    public OreDictMaterial qual(float aSpeed, long aDurability, long aQuality) {
        return this.qual(3L, aSpeed, aDurability, aQuality);
    }

    public OreDictMaterial qual(long aType, double aSpeed, long aDurability, long aQuality) {
        this.mToolTypes = UT.Code.bind2(aType);
        this.mToolDurability = Math.max(1L, aDurability);
        this.mToolQuality = UT.Code.bind4(aQuality);
        this.mToolSpeed = (float)aSpeed;
        if (aType > 0L) {
            this.put(TD.Properties.HAS_TOOL_STATS, TD.ItemGenerator.PARTS, TD.ItemGenerator.STICKS, TD.ItemGenerator.PLATES);
        }
        if (aType < 3L) {
            this.put(TD.Properties.NO_ADVANCED_TOOLS);
        }
        return this;
    }

    @Deprecated
    public OreDictMaterial setMeltingPoint(long aMeltingPoint) {
        return this.heat(aMeltingPoint);
    }

    public OreDictMaterial heat(long aMeltingPoint) {
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = this.mMeltingPoint * 2L;
        this.mPlasmaPoint = this.mBoilingPoint * 100L;
        return this;
    }

    @Deprecated
    public OreDictMaterial setStatsEnergetic(long aMeltingPoint, long aBoilingPoint) {
        return this.heat(aMeltingPoint, aBoilingPoint);
    }

    public OreDictMaterial heat(long aMeltingPoint, long aBoilingPoint) {
        if (aMeltingPoint > aBoilingPoint) {
            throw new IllegalArgumentException("The Melting Point cannot be above the Boiling Point.");
        }
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = aBoilingPoint;
        this.mPlasmaPoint = aBoilingPoint * 100L;
        return this;
    }

    @Deprecated
    public OreDictMaterial setStatsEnergetic(long aMeltingPoint, long aBoilingPoint, long aPlasmaPoint) {
        return this.heat(aMeltingPoint, aBoilingPoint, aPlasmaPoint);
    }

    public OreDictMaterial heat(long aMeltingPoint, long aBoilingPoint, long aPlasmaPoint) {
        if (aMeltingPoint > aBoilingPoint) {
            throw new IllegalArgumentException("The Melting Point cannot be above the Boiling Point.");
        }
        if (aBoilingPoint > aPlasmaPoint) {
            throw new IllegalArgumentException("The Boiling Point cannot be above the Plasmafication Point.");
        }
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = aBoilingPoint;
        this.mPlasmaPoint = aPlasmaPoint;
        return this;
    }

    public OreDictMaterial setStats(long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter) {
        this.heat(aMeltingPoint, aBoilingPoint);
        this.mProtons = aProtonsAndElectrons;
        this.mElectrons = aProtonsAndElectrons;
        this.mNeutrons = aNeutrons;
        this.mMass = aProtonsAndElectrons + aNeutrons;
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setStatsElement(long aProtons, long aElectrons, long aNeutrons, long aAdditionalMass, double aGramPerCubicCentimeter) {
        this.mProtons = aProtons;
        this.mElectrons = aElectrons;
        this.mNeutrons = aNeutrons;
        this.mMass = aProtons + aNeutrons + aAdditionalMass;
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public ITexture getTextureSolid() {
        if (this.mTextureSolid == null) {
            this.mTextureSolid = this.getTextureSolid(this.mRGBaSolid, false);
        }
        return this.mTextureSolid;
    }

    public ITexture getTextureSolid(int aRGBA, boolean aEnableAO) {
        return this.getTextureSolid(UT.Code.getRGBaArray(aRGBA), aEnableAO);
    }

    public ITexture getTextureSolid(short[] aRGBA, boolean aEnableAO) {
        return BlockTextureDefault.get(this, OP.blockSolid, aRGBA, this.contains(TD.Properties.GLOWING), aEnableAO);
    }

    public ITexture getTextureSmooth() {
        if (this.mTextureSmooth == null) {
            this.mTextureSmooth = this.mTextureSolid;
        }
        if (this.mTextureSmooth == null) {
            this.mTextureSmooth = this.getTextureSmooth(this.mRGBaSolid, false);
        }
        return this.mTextureSmooth;
    }

    public ITexture getTextureSmooth(int aRGBA, boolean aEnableAO) {
        return this.getTextureSmooth(UT.Code.getRGBaArray(aRGBA), aEnableAO);
    }

    public ITexture getTextureSmooth(short[] aRGBA, boolean aEnableAO) {
        return this.getTextureSolid(aRGBA, aEnableAO);
    }

    public ITexture getTextureMolten() {
        if (this.mTextureMolten == null) {
            this.mTextureMolten = this.getTextureMolten(this.mRGBaLiquid, false);
        }
        return this.mTextureMolten;
    }

    public ITexture getTextureMolten(int aRGBA, boolean aEnableAO) {
        return this.getTextureMolten(UT.Code.getRGBaArray(aRGBA), aEnableAO);
    }

    public ITexture getTextureMolten(short[] aRGBA, boolean aEnableAO) {
        return BlockTextureDefault.get(this, CS.IconsGT.INDEX_BLOCK_MOLTEN, aRGBA, true, aEnableAO);
    }

    public ITexture getTextureDust() {
        if (this.mTextureDust == null) {
            this.mTextureDust = this.getTextureDust(this.mRGBaSolid, false);
        }
        return this.mTextureDust;
    }

    public ITexture getTextureDust(int aRGBA, boolean aEnableAO) {
        return this.getTextureDust(UT.Code.getRGBaArray(aRGBA), aEnableAO);
    }

    public ITexture getTextureDust(short[] aRGBA, boolean aEnableAO) {
        return BlockTextureDefault.get(this, OP.blockDust, aRGBA, this.contains(TD.Properties.GLOWING), aEnableAO);
    }

    public ITexture getTextureGem() {
        if (this.mTextureGem == null) {
            this.mTextureGem = this.getTextureGem(this.mRGBaSolid, false);
        }
        return this.mTextureGem;
    }

    public ITexture getTextureGem(int aRGBA, boolean aEnableAO) {
        return this.getTextureGem(UT.Code.getRGBaArray(aRGBA), aEnableAO);
    }

    public ITexture getTextureGem(short[] aRGBA, boolean aEnableAO) {
        return BlockTextureDefault.get(this, OP.blockGem, aRGBA, this.contains(TD.Properties.GLOWING), aEnableAO);
    }

    public OreDictMaterial setTextures(TextureSet ... aSets) {
        if (aSets == null || aSets.length < 2) {
            return this.setTextures(new TextureSet[0]);
        }
        this.mTextureSetsBlock = aSets[0].mList;
        this.mTextureSetsItems = aSets[1].mList;
        return this;
    }

    public OreDictMaterial setRGBa(long aR, long aG, long aB, long aA) {
        this.mRGBaGas[0] = this.mRGBaPlasma[0] = UT.Code.bind8(aR);
        this.mRGBaLiquid[0] = this.mRGBaPlasma[0];
        this.mRGBaSolid[0] = this.mRGBaPlasma[0];
        this.mRGBaGas[1] = this.mRGBaPlasma[1] = UT.Code.bind8(aG);
        this.mRGBaLiquid[1] = this.mRGBaPlasma[1];
        this.mRGBaSolid[1] = this.mRGBaPlasma[1];
        this.mRGBaGas[2] = this.mRGBaPlasma[2] = UT.Code.bind8(aB);
        this.mRGBaLiquid[2] = this.mRGBaPlasma[2];
        this.mRGBaSolid[2] = this.mRGBaPlasma[2];
        this.mRGBaGas[3] = this.mRGBaPlasma[3] = UT.Code.bind8(aA);
        this.mRGBaLiquid[3] = this.mRGBaPlasma[3];
        this.mRGBaSolid[3] = this.mRGBaPlasma[3];
        this.fRGBaGas[0] = this.fRGBaPlasma[0] = UT.Code.bind8(aR);
        this.fRGBaLiquid[0] = this.fRGBaPlasma[0];
        this.fRGBaSolid[0] = this.fRGBaPlasma[0];
        this.fRGBaGas[1] = this.fRGBaPlasma[1] = UT.Code.bind8(aG);
        this.fRGBaLiquid[1] = this.fRGBaPlasma[1];
        this.fRGBaSolid[1] = this.fRGBaPlasma[1];
        this.fRGBaGas[2] = this.fRGBaPlasma[2] = UT.Code.bind8(aB);
        this.fRGBaLiquid[2] = this.fRGBaPlasma[2];
        this.fRGBaSolid[2] = this.fRGBaPlasma[2];
        this.fRGBaGas[3] = this.fRGBaPlasma[3] = UT.Code.bind8(aA);
        this.fRGBaLiquid[3] = this.fRGBaPlasma[3];
        this.fRGBaSolid[3] = this.fRGBaPlasma[3];
        return this;
    }

    public OreDictMaterial setRGBaSolid(long aR, long aG, long aB, long aA) {
        this.mRGBaSolid[0] = UT.Code.bind8(aR);
        this.mRGBaSolid[1] = UT.Code.bind8(aG);
        this.mRGBaSolid[2] = UT.Code.bind8(aB);
        this.mRGBaSolid[3] = UT.Code.bind8(aA);
        this.fRGBaSolid[0] = UT.Code.bind8(aR);
        this.fRGBaSolid[1] = UT.Code.bind8(aG);
        this.fRGBaSolid[2] = UT.Code.bind8(aB);
        this.fRGBaSolid[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaLiquid(long aR, long aG, long aB, long aA) {
        this.mRGBaLiquid[0] = UT.Code.bind8(aR);
        this.mRGBaLiquid[1] = UT.Code.bind8(aG);
        this.mRGBaLiquid[2] = UT.Code.bind8(aB);
        this.mRGBaLiquid[3] = UT.Code.bind8(aA);
        this.fRGBaLiquid[0] = UT.Code.bind8(aR);
        this.fRGBaLiquid[1] = UT.Code.bind8(aG);
        this.fRGBaLiquid[2] = UT.Code.bind8(aB);
        this.fRGBaLiquid[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaGas(long aR, long aG, long aB, long aA) {
        this.mRGBaGas[0] = UT.Code.bind8(aR);
        this.mRGBaGas[1] = UT.Code.bind8(aG);
        this.mRGBaGas[2] = UT.Code.bind8(aB);
        this.mRGBaGas[3] = UT.Code.bind8(aA);
        this.fRGBaGas[0] = UT.Code.bind8(aR);
        this.fRGBaGas[1] = UT.Code.bind8(aG);
        this.fRGBaGas[2] = UT.Code.bind8(aB);
        this.fRGBaGas[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaPlasma(long aR, long aG, long aB, long aA) {
        this.mRGBaPlasma[0] = UT.Code.bind8(aR);
        this.mRGBaPlasma[1] = UT.Code.bind8(aG);
        this.mRGBaPlasma[2] = UT.Code.bind8(aB);
        this.mRGBaPlasma[3] = UT.Code.bind8(aA);
        this.fRGBaPlasma[0] = UT.Code.bind8(aR);
        this.fRGBaPlasma[1] = UT.Code.bind8(aG);
        this.fRGBaPlasma[2] = UT.Code.bind8(aB);
        this.fRGBaPlasma[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial steal(OreDictMaterial aStatsToCopy) {
        this.heat(aStatsToCopy);
        this.stealStatsElement(aStatsToCopy);
        this.qual(aStatsToCopy);
        return this;
    }

    public OreDictMaterial stealLooks(OreDictMaterial aStatsToCopy) {
        this.mTextureSetsItems = aStatsToCopy.mTextureSetsItems;
        this.mTextureSetsBlock = aStatsToCopy.mTextureSetsBlock;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            this.mRGBa[i] = aStatsToCopy.mRGBa[i];
            this.mRGBaSolid[i] = aStatsToCopy.mRGBaSolid[i];
            this.mRGBaLiquid[i] = aStatsToCopy.mRGBaLiquid[i];
            this.mRGBaGas[i] = aStatsToCopy.mRGBaGas[i];
            this.mRGBaPlasma[i] = aStatsToCopy.mRGBaPlasma[i];
            this.fRGBa[i] = aStatsToCopy.fRGBa[i];
            this.fRGBaSolid[i] = aStatsToCopy.fRGBaSolid[i];
            this.fRGBaLiquid[i] = aStatsToCopy.fRGBaLiquid[i];
            this.fRGBaGas[i] = aStatsToCopy.fRGBaGas[i];
            this.fRGBaPlasma[i] = aStatsToCopy.fRGBaPlasma[i];
        }
        return this;
    }

    @Deprecated
    public OreDictMaterial stealStatsEnergetic(OreDictMaterial aStatsToCopy) {
        return this.heat(aStatsToCopy);
    }

    public OreDictMaterial heat(OreDictMaterial aStatsToCopy) {
        return this.heat(aStatsToCopy.mMeltingPoint, aStatsToCopy.mBoilingPoint, aStatsToCopy.mPlasmaPoint);
    }

    @Deprecated
    public OreDictMaterial stealQuality(OreDictMaterial aStatsToCopy) {
        return this.qual(aStatsToCopy);
    }

    public OreDictMaterial qual(OreDictMaterial aStatsToCopy) {
        return this.qual(aStatsToCopy.mToolTypes, aStatsToCopy.mToolSpeed, aStatsToCopy.mToolDurability, aStatsToCopy.mToolQuality);
    }

    public OreDictMaterial stealStatsElement(OreDictMaterial aStatsToCopy) {
        this.mProtons = aStatsToCopy.mProtons;
        this.mElectrons = aStatsToCopy.mElectrons;
        this.mNeutrons = aStatsToCopy.mNeutrons;
        this.mMass = aStatsToCopy.mMass;
        this.mGramPerCubicCentimeter = aStatsToCopy.mGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setDensity(double aGramPerCubicCentimeter) {
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial addAspects(TC.TC_AspectStack ... aAspects) {
        for (TC.TC_AspectStack tAspect : aAspects) {
            if (tAspect.mAspect == TC.METALLUM) {
                this.mHasMetallum = true;
            }
            tAspect.addToAspectList(this.mAspects);
        }
        return this;
    }

    public OreDictMaterial aspects_met_rad(long aMetallum, long aRadio) {
        return this.addAspects(TC.stack(TC.METALLUM, aMetallum), TC.stack(TC.RADIO, aRadio));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1) {
        return this.addAspects(TC.stack(aAspect1, aAmount1));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9, TC aAspect0, long aAmount0) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9), TC.stack(aAspect0, aAmount0));
    }

    public OreDictMaterial setOreMultiplier(int aMultiplier) {
        this.mOreMultiplier = (byte)Math.max(1, aMultiplier);
        return this;
    }

    public OreDictMaterial setFurnaceBurnTime(long aValue) {
        this.mFurnaceBurnTime = Math.max(0L, aValue);
        return this;
    }

    public OreDictMaterial addEnchantmentForTools(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentTools.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForDamage(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.addEnchantmentForWeapons(aEnchantment, aEnchantmentLevel);
        this.addEnchantmentForAmmo(aEnchantment, aEnchantmentLevel);
        return this;
    }

    public OreDictMaterial addEnchantmentForWeapons(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentWeapons.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForAmmo(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentAmmo.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForRanged(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentRanged.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForFishing(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentFishing.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantment == Enchantment.field_151369_A ? (long)Math.min(5, aEnchantmentLevel) : (long)aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForArmors(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentArmors.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial ores(OreDictMaterial ... aMaterials) {
        this.mByProducts.addAll(Arrays.asList(aMaterials));
        return this;
    }

    public void addOreByProducts(OreDictMaterial ... aMaterials) {
        this.mByProducts.addAll(Arrays.asList(aMaterials));
    }

    public OreDictMaterial liquid(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mLiquid = aFluidStack.copy();
            this.mLiquidUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 648648000L, true)));
        }
        return this;
    }

    public OreDictMaterial gas(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mGas = aFluidStack.copy();
            this.mGasUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 648648000L, true)));
        }
        return this;
    }

    public OreDictMaterial plasma(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mPlasma = aFluidStack.copy();
            this.mPlasmaUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 648648000L, true)));
        }
        return this;
    }

    public OreDictMaterial liquid(FluidStack aFluidStack) {
        return this.liquid(aFluidStack, this.mLiquidUnit);
    }

    public OreDictMaterial gas(FluidStack aFluidStack) {
        return this.gas(aFluidStack, this.mGasUnit);
    }

    public OreDictMaterial plasma(FluidStack aFluidStack) {
        return this.plasma(aFluidStack, this.mPlasmaUnit);
    }

    public FluidStack fluid(long aMaterialAmount, boolean aRoundUp) {
        return this.fluid(293L, aMaterialAmount, aRoundUp);
    }

    public FluidStack fluid(long aTemperature, long aMaterialAmount, boolean aRoundUp) {
        if (aTemperature >= this.mPlasmaPoint) {
            return this.plasma(aMaterialAmount, aRoundUp);
        }
        if (aTemperature >= this.mBoilingPoint) {
            return this.gas(aMaterialAmount, aRoundUp);
        }
        if (aTemperature >= this.mMeltingPoint) {
            return this.liquid(aMaterialAmount, aRoundUp);
        }
        return FL.Error.make(1000L);
    }

    public FluidStack liquid(long aMaterialAmount, boolean aRoundUp) {
        if (this.mLiquid == null) {
            return FL.Error.make(1L);
        }
        FluidStack rFluid = this.mLiquid.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mLiquidUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public FluidStack gas(long aMaterialAmount, boolean aRoundUp) {
        if (this.mGas == null) {
            return FL.Error.make(1L);
        }
        FluidStack rFluid = this.mGas.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mGasUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public FluidStack plasma(long aMaterialAmount, boolean aRoundUp) {
        if (this.mPlasma == null) {
            return FL.Error.make(1L);
        }
        FluidStack rFluid = this.mPlasma.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mPlasmaUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public OreDictMaterial setPriorityPrefix(int aIndex) {
        this.mPriorityPrefixIndex = aIndex;
        if (!this.mNameInternal.startsWith("Clay") && !"Gravel".equalsIgnoreCase(this.mNameInternal)) {
            switch (this.mPriorityPrefixIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockGem" + this.mNameInternal);
                    break;
                }
                case 2: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockDust" + this.mNameInternal);
                    break;
                }
                case 3: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockIngot" + this.mNameInternal);
                    break;
                }
                case 4: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockIngot" + this.mNameInternal);
                    break;
                }
            }
        }
        return this;
    }

    public OreDictMaterial setPriorityPrefix(int aIndex, OreDictPrefix aPrefix) {
        this.mPriorityPrefixIndex = aIndex;
        if (!this.mNameInternal.startsWith("Clay")) {
            switch (this.mPriorityPrefixIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockGem" + this.mNameInternal);
                    break;
                }
                case 2: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockDust" + this.mNameInternal);
                    break;
                }
                case 3: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockIngot" + this.mNameInternal);
                    break;
                }
                case 4: {
                    OreDictManager.INSTANCE.addReRegistrationWithReversal("block" + this.mNameInternal, "blockIngot" + this.mNameInternal);
                    break;
                }
            }
        }
        this.mPriorityPrefix = aPrefix;
        return this;
    }

    public long getNeutrons() {
        return this.mNeutrons;
    }

    public long getProtons() {
        return this.mProtons;
    }

    public long getElectrons() {
        return this.mElectrons;
    }

    public long getMass() {
        return this.mMass;
    }

    public double getWeight(long aAmount) {
        return this.mGramPerCubicCentimeter * 111.111111 * (double)aAmount / 6.48648E8;
    }

    public String toString() {
        return this.mNameInternal;
    }

    public int hashCode() {
        return this.mHashID;
    }

    public boolean addListener(IOreDictListenerItem aListener) {
        if (this.mListenersItem.contains(aListener)) {
            return false;
        }
        this.mListenersItem.add(aListener);
        return true;
    }

    public boolean contains(ItemStack ... aStacks) {
        if (aStacks == null) {
            return false;
        }
        for (ItemStack aStack : aStacks) {
            if (!this.mRegisteredItems.contains(aStack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TagData aTag) {
        return this.mTags.contains(aTag);
    }

    public boolean containsAny(TagData ... aTags) {
        for (TagData aTag : aTags) {
            if (!this.mTags.contains(aTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TagData ... aTags) {
        return this.mTags.containsAll(Arrays.asList(aTags));
    }

    @Override
    public boolean containsAll(Collection<TagData> aTags) {
        return this.mTags.containsAll(aTags);
    }

    public OreDictMaterial put(TagData ... aObjects) {
        return this.add(aObjects);
    }

    public OreDictMaterial put(Object ... aObjects) {
        if (aObjects != null) {
            for (Object aObject : aObjects) {
                if (aObject == null) continue;
                if (aObject.getClass().isArray()) {
                    this.put((Object[])aObject);
                    continue;
                }
                if (aObject instanceof TagData) {
                    this.mTags.add((TagData)aObject);
                    continue;
                }
                if (aObject instanceof ModData) {
                    this.setOriginalMod((ModData)aObject);
                    continue;
                }
                if (aObject instanceof String) {
                    this.addIdenticalNames((String)aObject);
                    continue;
                }
                if (aObject instanceof Number) {
                    this.setFurnaceBurnTime(((Number)aObject).longValue());
                    continue;
                }
                if (aObject instanceof OreDictMaterial) {
                    this.addReRegistrations((OreDictMaterial)aObject);
                    continue;
                }
                if (aObject instanceof Achievement) {
                    this.mAchievementsForCreation.add((Achievement)aObject);
                    continue;
                }
                if (!(aObject instanceof Iterable)) continue;
                for (Object aIterated : (Iterable)aObject) {
                    this.put(aIterated);
                }
            }
        }
        return this;
    }

    public OreDictMaterial add(TagData[] aTags1, TagData ... aTags2) {
        this.put(aTags1);
        this.put(aTags2);
        return this;
    }

    @Override
    public OreDictMaterial add(TagData ... aTags) {
        if (aTags != null) {
            for (TagData aTag : aTags) {
                this.mTags.add(aTag);
            }
        }
        return this;
    }

    @Override
    public boolean remove(TagData aTag) {
        return this.mTags.remove(aTag);
    }

    @Override
    public boolean isTrue(OreDictMaterial aObject) {
        return aObject == this;
    }
}

