/*
 * Decompiled with CFR 0.152.
 */
package gregapi.old;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.util.ST;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GT_BaseCrop
extends CropCard {
    private String mName = "";
    private String mDiscoveredBy = "Gregorius Techneticies";
    private String[] mAttributes;
    private int mTier = 0;
    private int mMaxSize = 0;
    private int mAfterHarvestSize = 0;
    private int mHarvestSize = 0;
    private int[] mStats = new int[5];
    private ItemStack mDrop = null;
    private ItemStack[] mSpecialDrops = null;
    public static ArrayList<GT_BaseCrop> sCropList = new ArrayListNoNulls<GT_BaseCrop>();

    public GT_BaseCrop(String aCropName, String aDiscoveredBy, ItemStack aDrop, ItemStack[] aSpecialDrops, ItemStack aBaseSeed, int aTier, int aMaxSize, int aGrowthSpeed, int aAfterHarvestSize, int aHarvestSize, int aStatChemical, int aStatFood, int aStatDefensive, int aStatColor, int aStatWeed, String[] aAttributes) {
        this.mName = aCropName.toLowerCase().replaceAll(" ", "");
        if (aDiscoveredBy != null && !aDiscoveredBy.equals("")) {
            this.mDiscoveredBy = aDiscoveredBy;
        }
        if (aDrop != null) {
            LH.add("gt.crop." + this.mName, aCropName);
            this.mDrop = ST.copy(aDrop);
            this.mSpecialDrops = aSpecialDrops;
            this.mTier = Math.max(1, aTier);
            this.mMaxSize = Math.max(3, aMaxSize);
            this.mHarvestSize = Math.min(Math.max(aHarvestSize, 2), this.mMaxSize);
            this.mAfterHarvestSize = Math.min(Math.max(aAfterHarvestSize, 1), this.mMaxSize - 1);
            this.mStats[0] = aStatChemical;
            this.mStats[1] = aStatFood;
            this.mStats[2] = aStatDefensive;
            this.mStats[3] = aStatColor;
            this.mStats[4] = aStatWeed;
            this.mAttributes = aAttributes;
            Crops.instance.registerCrop((CropCard)this);
            if (aBaseSeed != null) {
                Crops.instance.registerBaseSeed(aBaseSeed, (CropCard)this, 1, 1, 1, 1);
            }
            sCropList.add(this);
        }
    }

    public String displayName() {
        return LH.get("gt.crop." + this.mName);
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return (byte)this.mAfterHarvestSize;
    }

    public String[] attributes() {
        return this.mAttributes;
    }

    public String discoveredBy() {
        return this.mDiscoveredBy;
    }

    public final boolean canGrow(ICropTile aCrop) {
        return aCrop.getSize() < this.maxSize();
    }

    public final boolean canBeHarvested(ICropTile aCrop) {
        return aCrop.getSize() >= this.mHarvestSize;
    }

    public boolean canCross(ICropTile aCrop) {
        return aCrop.getSize() + 2 > this.maxSize();
    }

    public int stat(int n) {
        if (n < 0 || n >= this.mStats.length) {
            return 0;
        }
        return this.mStats[n];
    }

    public String name() {
        return this.mName;
    }

    public int tier() {
        return this.mTier;
    }

    public int maxSize() {
        return this.mMaxSize;
    }

    public ItemStack getGain(ICropTile aCrop) {
        int tDrop = 0;
        if (this.mSpecialDrops != null && (tDrop = CS.RNGSUS.nextInt(this.mSpecialDrops.length + 4)) < this.mSpecialDrops.length && this.mSpecialDrops[tDrop] != null) {
            return ST.copy(this.mSpecialDrops[tDrop]);
        }
        return ST.copy(this.mDrop);
    }

    public boolean rightclick(ICropTile aCrop, EntityPlayer aPlayer) {
        if (!this.canBeHarvested(aCrop)) {
            return false;
        }
        return aCrop.harvest(aPlayer == null ? false : aPlayer instanceof EntityPlayerMP);
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
        this.textures = new IIcon[this.maxSize()];
        for (int i = 1; i <= this.textures.length; ++i) {
            this.textures[i - 1] = iconRegister.func_94245_a(CS.RES_PATH_BLOCK + "crop/" + this.name() + "/" + i);
        }
    }
}

