/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import gregapi.util.UT;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSound
extends PacketCoordinates {
    private String mSound;
    private float mVolume;
    private float mPitch;

    public PacketSound(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSound(String aSound, float aVolume, float aPitch, ChunkCoordinates aCoords) {
        super(aCoords);
        this.mSound = aSound;
        this.mVolume = aVolume;
        this.mPitch = aPitch;
    }

    public PacketSound(String aSound, float aVolume, float aPitch, int aX, int aY, int aZ) {
        super(aX, aY, aZ);
        this.mSound = aSound;
        this.mVolume = aVolume;
        this.mPitch = aPitch;
    }

    @Override
    public byte getPacketIDOffset() {
        return -128;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeUTF(this.mSound);
        aData.writeFloat(this.mVolume);
        aData.writeFloat(this.mPitch);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSound(aData.readUTF(), aData.readFloat(), aData.readFloat(), aX, aY, aZ);
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        UT.Sounds.play(this.mSound, 2, this.mVolume, this.mPitch, this.mX, this.mY, this.mZ);
    }
}

