/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Optional;
import forestry.api.arboriculture.IToolGrafter;
import gregapi.data.TD;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.util.UT;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.IWarpingGear;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IWarpingGear", modid="Thaumcraft"), @Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="Forestry"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="Railcraft"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core"), @Optional.Interface(iface="ic2.api.item.IBoxable", modid="IC2"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2"), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2"), @Optional.Interface(iface="micdoodle8.mods.galacticraft.api.item.IItemElectric", modid="GalacticraftCore")})
public class MultiItemToolWithCompat
extends MultiItemTool
implements IWarpingGear,
IToolGrafter,
IToolCrowbar,
IToolWrench,
IBoxable,
ISpecialElectricItem,
IElectricItemManager,
IItemElectric {
    public MultiItemToolWithCompat(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
    }

    public int getWarp(ItemStack aStack, EntityPlayer aPlayer) {
        return MultiItemToolWithCompat.getPrimaryMaterial(aStack).contains(TD.Properties.WARPING) || MultiItemToolWithCompat.getSecondaryMaterial(aStack).contains(TD.Properties.WARPING) ? 1 : 0;
    }

    public float getSaplingModifier(ItemStack aStack, World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isGrafter() ? Math.min(100.0f, (float)(1 + UT.Code.bind4(this.getHarvestLevel(aStack, ""))) * 20.0f) : 0.0f;
    }

    public boolean canWrench(EntityPlayer aPlayer, int aX, int aY, int aZ) {
        ItemStack aStack = aPlayer.func_71045_bC();
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isWrench();
    }

    public void wrenchUsed(EntityPlayer aPlayer, int aX, int aY, int aZ) {
        ItemStack aStack = aPlayer.func_71045_bC();
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, 100L, (EntityLivingBase)aPlayer, true);
        }
    }

    public boolean canWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, 100L, (EntityLivingBase)aPlayer, true);
        }
    }

    public boolean canLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack(), (EntityLivingBase)aPlayer, true);
        }
    }

    public boolean canBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack(), (EntityLivingBase)aPlayer, true);
        }
    }

    public boolean canBeStoredInToolbox(ItemStack aStack) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }
}

