/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.config.ConfigCategories;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.fluid.FluidGT;
import gregapi.item.IItemGT;
import gregapi.item.IItemUpdatable;
import gregapi.old.GT_BaseCrop;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidDisplay
extends Item
implements IFluidContainerItem,
IItemUpdatable,
IItemGT {
    protected IIcon mIcon;
    private final String mName;

    public ItemFluidDisplay() {
        this.mName = "gt.display.fluid";
        LH.add(this.mName, "Fluid Display");
        GameRegistry.registerItem((Item)this, (String)this.mName, (String)MD.GAPI.mID);
        if (CS.ConfigsGT.CLIENT.get((Object)ConfigCategories.visibility, "HiddenGTFluidDisplay", false)) {
            ST.hide(this);
        }
        CS.ItemsGT.DEBUG_ITEMS.add(this);
        CS.ItemsGT.ILLEGAL_DROPS.add(this);
        CS.GarbageGT.BLACKLIST.add(this);
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (!aWorld.field_72995_K && UT.Entities.hasInfiniteItems(aPlayer)) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (FL.fill(WD.te(aWorld, aX, aY, aZ, tSide, true), FL.make(FL.fluid(ST.meta_(aStack)), Integer.MAX_VALUE), true) <= 0L) continue;
                return true;
            }
        }
        return !aWorld.field_72995_K;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        Fluid aFluid = FL.fluid(ST.meta_(aStack));
        if (aFluid == null) {
            aList.add(LH.Chat.BLINKING_RED + "CLIENTSIDE FLUID IS NULL!!!");
        } else if (FL.Error.is(aFluid)) {
            aList.add(LH.Chat.BLINKING_RED + "THIS IS AN ERROR AND SHOULD NEVER BE OBTAINABLE!!!");
        } else {
            int tViscosity;
            OreDictMaterialStack tMaterial;
            String aName = aFluid.getName();
            if (CS.SHOW_INTERNAL_NAMES || aF3_H) {
                aList.add("Registry: " + aName);
            }
            if (CS.FluidsGT.FLUID_RENAMINGS.containsKey(aName) || CS.FluidsGT.NONSTANDARD.contains(aName)) {
                aList.add(LH.Chat.BLINKING_RED + "NON-STANDARD FLUID!");
            }
            long tAmount = 0L;
            long tTemperature = 293L;
            FluidStack tFluid = CS.NF;
            boolean tGas = false;
            if (aNBT == null) {
                tAmount = 0L;
                tFluid = FL.make(aFluid, (long)((int)tAmount));
                tGas = FL.gas(tFluid);
                tTemperature = FL.temperature(tFluid);
            } else {
                tAmount = aNBT.func_74763_f("a");
                tFluid = FL.make(aFluid, (long)((int)tAmount));
                tGas = aNBT.func_74767_n("s");
                tTemperature = aNBT.func_74763_f("h");
            }
            if (tAmount > 0L) {
                aList.add(LH.Chat.BLUE + "Amount: " + UT.Code.makeString(tAmount) + " L");
            }
            if ((tMaterial = OreDictMaterial.FLUID_MAP.get(aName)) != null) {
                long tMatAmount;
                if (tMaterial.mAmount > 0L && tAmount > 0L && (tMatAmount = UT.Code.units(tAmount, tMaterial.mAmount, 648648000L, false)) > 0L) {
                    int tDigits = (int)((double)(tMatAmount % 648648000L) / 6.48648E8 * 1000.0);
                    aList.add(LH.Chat.BLUE + "Worth: " + tMatAmount / 648648000L + "." + (tDigits < 1 ? "000" : (tDigits < 10 ? "00" + tDigits : (tDigits < 100 ? "0" + tDigits : Integer.valueOf(tDigits)))) + " Units of " + tMaterial.mMaterial.getLocal());
                }
                if (UT.Code.stringValid(tMaterial.mMaterial.mTooltipChemical)) {
                    aList.add(LH.Chat.YELLOW + tMaterial.mMaterial.mTooltipChemical);
                }
            }
            aList.add(LH.Chat.RED + "Temperature: " + tTemperature + " K (" + (tTemperature - 273L) + "\u00b0C)");
            if (FL.plasma(tFluid)) {
                aList.add(LH.Chat.GREEN + "State: " + LH.Chat.YELLOW + "Plasma" + (!aFluid.isGaseous(tFluid) ? LH.Chat.RED + " (Warning: Considered a Liquid by Mods other than GT!)" : LH.Chat.ORANGE + " (Note: Considered a Gas by Mods other than GT!)"));
            } else if (tGas) {
                aList.add(LH.Chat.GREEN + "State: " + LH.Chat.CYAN + "Gas" + (!aFluid.isGaseous(tFluid) ? LH.Chat.RED + " (Warning: Considered a Liquid by Mods other than GT!)" : ""));
            } else {
                aList.add(LH.Chat.GREEN + "State: " + LH.Chat.BLUE + "Liquid" + (tMaterial != null && ST.valid(OP.ingot.mat(tMaterial.mMaterial, 1L)) ? LH.Chat.CYAN + " (Might able to cast into Molds)" : ""));
                if (aFluid.isGaseous(tFluid)) {
                    aList.add(LH.Chat.BLINKING_RED + " (Warning: Considered a Gas by Mods other than GT!)");
                }
            }
            int tDensity = aFluid.getDensity(tFluid);
            if (tDensity > 0) {
                aList.add(LH.Chat.GREEN + "Density: " + tDensity + " ; Heavier than Air (typically moves down)");
            } else if (tDensity < 0) {
                aList.add(LH.Chat.GREEN + "Density: " + tDensity + " ; Lighter than Air (typically moves up)");
            } else {
                aList.add(LH.Chat.GREEN + "Density: 0 ; As dense as Air (typically still moves down)");
            }
            int tLuminosity = aFluid.getLuminosity(tFluid);
            if (tLuminosity != 0) {
                aList.add(LH.Chat.YELLOW + "Luminosity: " + tLuminosity);
            }
            if ((tViscosity = aFluid.getViscosity(tFluid)) != 0) {
                aList.add(LH.Chat.BLUE + "Viscosity: " + tViscosity);
            }
            if (CS.FluidsGT.COOKING_OIL.contains(aName)) {
                aList.add(LH.Chat.DGREEN + "Usable as Cooking Oil in a GT Oven to duplicate Meat and Fish");
            }
            if (FL.simple(aFluid)) {
                aList.add(LH.Chat.DGREEN + "This is a simple Fluid that is easy to handle");
            }
            if (FL.powerconducting(aFluid)) {
                aList.add(LH.Chat.DGREEN + "This is a Power Conducting Fluid");
                aList.add(LH.Chat.ORANGE + "Cannot be stored in any normal GT6 Storage Tanks!");
            }
            if (FL.acid(aFluid)) {
                aList.add(LH.Chat.ORANGE + "Acidic! Handle with Care!");
            }
            if (FL.magic(aFluid)) {
                aList.add(LH.Chat.ORANGE + "Magical! Handle with Care!");
            }
            if (FL.Lubricant.is(aFluid) || FL.LubRoCant.is(aFluid)) {
                aList.add(LH.Chat.ORANGE + "Industrial Use ONLY!");
                aList.add(LH.Chat.RED + "Not Flammable!");
            } else {
                for (Recipe.RecipeMap tMap : Recipe.RecipeMap.FUEL_MAP_LIST) {
                    Collection<Recipe> tRecipes = tMap.mRecipeFluidMap.get(aName);
                    if (tRecipes == null || tRecipes.isEmpty()) continue;
                    long tFuelValue = 0L;
                    for (Recipe tRecipe : tRecipes) {
                        if (!tRecipe.mEnabled || tRecipe.mFluidInputs[0] == null) continue;
                        tFuelValue = Math.max(tFuelValue, tRecipe.getAbsoluteTotalPower() * 648648000L / (long)tRecipe.mFluidInputs[0].amount);
                    }
                    if (tFuelValue <= 0L) continue;
                    if (tAmount > 1L) {
                        aList.add(LH.Chat.RED + LH.get(tMap.mNameInternal) + ": " + LH.Chat.WHITE + UT.Code.makeString(tFuelValue / 648648000L) + LH.Chat.YELLOW + " GU/L; " + LH.Chat.WHITE + UT.Code.makeString(tFuelValue * tAmount / 648648000L) + LH.Chat.YELLOW + " GU total");
                        continue;
                    }
                    aList.add(LH.Chat.RED + LH.get(tMap.mNameInternal) + ": " + LH.Chat.WHITE + UT.Code.makeString(tFuelValue / 648648000L) + LH.Chat.YELLOW + " GU/L ");
                }
            }
            if (aFluid instanceof FluidGT) {
                aList.add(LH.Chat.DGRAY + "Fluid owned by GT6");
            } else if (FL.Water.is(aFluid) || FL.Lava.is(aFluid)) {
                aList.add(LH.Chat.DGRAY + "Fluid owned by vanilla Minecraft");
            } else {
                aList.add(LH.Chat.DGRAY + "Fluid NOT owned by GT6");
            }
        }
        if (UT.Entities.hasInfiniteItems(aPlayer)) {
            aList.add(LH.Chat.RAINBOW_SLOW + "Rightclick Blocks to fill their Tanks with this Fluid!");
        }
        while (aList.remove(null)) {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI) {
            GT_API.sBlockIcons = aIconRegister;
            for (Runnable tRunnable : GT_API.sBlockIconload) {
                try {
                    tRunnable.run();
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            if (MD.IC2.mLoaded) {
                try {
                    for (GT_BaseCrop tCrop : GT_BaseCrop.sCropList) {
                        tCrop.registerSprites(aIconRegister);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int aMeta) {
        Fluid aFluid = FluidRegistry.getFluid((int)aMeta);
        if (aFluid == null) {
            return FluidRegistry.WATER.getStillIcon();
        }
        Block tBlock = aFluid.getBlock();
        return tBlock != null && tBlock != CS.NB ? tBlock.func_149691_a(0, 0) : aFluid.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        Fluid aFluid = FL.fluid(ST.meta_(aStack));
        if (aFluid == null) {
            return 0xFFFFFF;
        }
        Block tBlock = aFluid.getBlock();
        return tBlock != null && tBlock != CS.NB ? tBlock.func_149741_i(0) : aFluid.getColor();
    }

    public int func_94901_k() {
        return 0;
    }

    public String func_77667_c(ItemStack aStack) {
        if (aStack != null) {
            return FL.name(FL.fluid(ST.meta_(aStack)), false);
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        if (aStack == null) {
            return "";
        }
        Fluid tFluid = FL.fluid(ST.meta_(aStack));
        return tFluid == null ? "INVALID FLUID ID!!!" : FL.name(tFluid, true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack aStack, int aRenderPass) {
        Fluid aFluid = FL.fluid(ST.meta_(aStack));
        return aFluid != null && CS.FluidsGT.ENCHANTED_EFFECT.contains(aFluid.getName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List aList) {
        int j = FluidRegistry.getMaxID();
        for (int i = 0; i <= j; ++i) {
            ItemStack tStack;
            Fluid tFluid = FL.fluid(i);
            if (tFluid == null || CS.FluidsGT.HIDDEN.contains(tFluid.getName()) || (tStack = FL.display(tFluid)) == null) continue;
            aList.add(tStack);
        }
        for (String tName : UT.Books.BOOK_LIST) {
            aList.add(ST.book(tName));
        }
    }

    public final Item func_77655_b(String aName) {
        return this;
    }

    public final String func_77658_a() {
        return this.mName;
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && aNBT.func_74764_b("f")) {
            Fluid tFluid;
            String aName = aNBT.func_74779_i("f");
            if (UT.Code.stringInvalid(aName)) {
                return;
            }
            String tName = CS.FluidsGT.FLUID_RENAMINGS.get(aName);
            if (UT.Code.stringValid(tName)) {
                aName = tName;
            }
            if ((tFluid = FL.fluid_(aName)) != null) {
                ST.meta_(aStack, tFluid.getID());
            }
            return;
        }
        Fluid tFluid = FL.fluid(ST.meta_(aStack));
        if (tFluid == null) {
            ST.meta_(aStack, 32767L);
        } else {
            aStack.func_77982_d(UT.NBT.makeString("f", tFluid.getName()));
        }
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        this.updateItemStack(aStack);
    }

    public FluidStack getFluid(ItemStack aStack) {
        long tAmount;
        Fluid tFluid = FL.fluid(ST.meta_(aStack));
        if (tFluid == null) {
            return null;
        }
        FluidStack rFluid = null;
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (tAmount = aNBT.func_74763_f("a")) > 0L) {
            rFluid = FL.make(tFluid, tAmount);
        }
        return rFluid == null ? FL.make(tFluid, 0L) : rFluid;
    }

    public int getCapacity(ItemStack aStack) {
        return Integer.MAX_VALUE;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aDrain, boolean aDoDrain) {
        return this.getFluid(aStack);
    }
}

