/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover;

import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class CoverData {
    public short[] mIDs;
    public short[] mMetas;
    public short[] mVisuals;
    public short[] mValues;
    public boolean[] mVisualsToSync = new boolean[]{false, false, false, false, false, false};
    public boolean mStopped = false;
    public NBTTagCompound[] mNBTs;
    public ICover[] mBehaviours = new ICover[6];
    public ITileEntityCoverable mTileEntity;

    public CoverData(ITileEntityCoverable aTileEntity) {
        this.mIDs = new short[6];
        this.mMetas = new short[6];
        this.mVisuals = new short[6];
        this.mValues = new short[6];
        this.mNBTs = new NBTTagCompound[6];
        this.mTileEntity = aTileEntity;
    }

    public CoverData(short[] aIDs, short[] aMetas, short[] aVisuals, short[] aValues, NBTTagCompound[] aNBTs, boolean aStopped, ITileEntityCoverable aTileEntity) {
        this.mVisuals = aVisuals;
        this.mValues = aValues;
        this.mNBTs = aNBTs;
        for (int i = 0; i < this.mNBTs.length; ++i) {
            if (this.mNBTs[i] == null || !this.mNBTs[i].func_82582_d()) continue;
            this.mNBTs[i] = null;
        }
        this.setIDs(aIDs, aMetas);
        this.mStopped = aStopped;
        this.mTileEntity = aTileEntity;
        if (this.mTileEntity != null) {
            try {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (this.mBehaviours[tSide] == null) continue;
                    this.mBehaviours[tSide].onCoverLoaded(tSide, this);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
                this.mTileEntity.setError("Cover Loaded:" + e);
            }
        }
    }

    public CoverData(ITileEntityCoverable aTileEntity, NBTTagCompound aNBT) {
        this(new short[]{aNBT.func_74765_d("a"), aNBT.func_74765_d("b"), aNBT.func_74765_d("c"), aNBT.func_74765_d("d"), aNBT.func_74765_d("e"), aNBT.func_74765_d("f")}, new short[]{aNBT.func_74765_d("g"), aNBT.func_74765_d("h"), aNBT.func_74765_d("i"), aNBT.func_74765_d("j"), aNBT.func_74765_d("k"), aNBT.func_74765_d("l")}, new short[]{aNBT.func_74765_d("m"), aNBT.func_74765_d("n"), aNBT.func_74765_d("o"), aNBT.func_74765_d("p"), aNBT.func_74765_d("q"), aNBT.func_74765_d("r")}, new short[]{aNBT.func_74765_d("0"), aNBT.func_74765_d("1"), aNBT.func_74765_d("2"), aNBT.func_74765_d("3"), aNBT.func_74765_d("4"), aNBT.func_74765_d("5")}, new NBTTagCompound[]{aNBT.func_74775_l("s"), aNBT.func_74775_l("t"), aNBT.func_74775_l("u"), aNBT.func_74775_l("v"), aNBT.func_74775_l("w"), aNBT.func_74775_l("x")}, aNBT.func_74767_n("y"), aTileEntity);
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(UT.NBT.make(), true);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT, boolean aIncludeVisuals) {
        byte i = 0;
        if (this.mIDs[i] != 0) {
            aNBT.func_74777_a("a", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("g", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("0", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("s", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("m", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.func_74777_a("b", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("h", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("1", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("t", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("n", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.func_74777_a("c", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("i", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("2", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("u", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("o", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.func_74777_a("d", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("j", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("3", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("v", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("p", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)((byte)(i + 1))] != 0) {
            aNBT.func_74777_a("e", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("k", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("4", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("w", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("q", this.mVisuals[i]);
            }
        }
        if (this.mIDs[i = (byte)(i + 1)] != 0) {
            aNBT.func_74777_a("f", this.mIDs[i]);
            if (this.mMetas[i] != 0) {
                aNBT.func_74777_a("l", this.mMetas[i]);
            }
            if (this.mValues[i] != 0) {
                aNBT.func_74777_a("5", this.mValues[i]);
            }
            if (this.mNBTs[i] != null && !this.mNBTs[i].func_82582_d()) {
                aNBT.func_74782_a("x", (NBTBase)this.mNBTs[i]);
            }
            if (this.mVisuals[i] != 0 && (aIncludeVisuals || this.mBehaviours[i] != null && this.mBehaviours[i].needsVisualsSaved(i, this))) {
                aNBT.func_74777_a("r", this.mVisuals[i]);
            }
        }
        if (this.mStopped) {
            aNBT.func_74757_a("y", this.mStopped);
        }
        return aNBT;
    }

    public CoverData setIDs(short[] aIDs, short[] aMetas) {
        this.mIDs = aIDs;
        this.mMetas = aMetas;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            this.mBehaviours[tSide] = this.mIDs[tSide] == 0 ? null : CoverRegistry.get(this.mIDs[tSide], this.mMetas[tSide]);
        }
        return this;
    }

    public CoverData set(byte aSide, ItemStack aStack) {
        return aStack == null ? this.set(aSide, (short)0, (short)0, null) : this.set(aSide, ST.id(aStack), ST.meta_(aStack), aStack.func_77978_p());
    }

    public CoverData set(byte aSide, short aID, short aMeta, NBTTagCompound aNBT) {
        this.mIDs[aSide] = aID;
        this.mMetas[aSide] = aMeta;
        this.mBehaviours[aSide] = aID == 0 ? null : CoverRegistry.get(aID, aMeta);
        this.mNBTs[aSide] = (NBTTagCompound)(aNBT == null || aNBT.func_82582_d() ? null : aNBT.func_74737_b());
        return this;
    }

    public CoverData value(byte aSide, short aValue) {
        return this.value(aSide, aValue, false);
    }

    public CoverData value(byte aSide, short aValue, boolean aBlockUpdate) {
        if (this.mValues[aSide] != aValue) {
            this.mValues[aSide] = aValue;
            if (aBlockUpdate) {
                this.mTileEntity.sendBlockUpdateFromCover();
            }
        }
        return this;
    }

    public CoverData visual(byte aSide, short aVisual) {
        return this.visual(aSide, aVisual, false);
    }

    public CoverData visual(byte aSide, short aVisual, boolean aBlockUpdate) {
        if (this.mVisuals[aSide] != aVisual) {
            this.mVisuals[aSide] = aVisual;
            this.mVisualsToSync[aSide] = true;
            this.mTileEntity.updateCoverVisuals();
            if (aBlockUpdate) {
                this.mTileEntity.sendBlockUpdateFromCover();
            }
        }
        return this;
    }

    public boolean setStopped(boolean aStopped) {
        if (aStopped == this.mStopped) {
            return false;
        }
        this.mStopped = aStopped;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.mBehaviours[tSide] == null) continue;
            this.mBehaviours[tSide].onStoppedUpdate(tSide, this, this.mStopped);
        }
        return true;
    }

    public boolean onBlockUpdate() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.mBehaviours[tSide] == null) continue;
            this.mBehaviours[tSide].onBlockUpdate(tSide, this);
        }
        return true;
    }

    public ItemStack getCoverItem(byte aSide) {
        return this.mIDs[aSide] == 0 ? null : (this.mBehaviours[aSide] == null ? ST.make((long)this.mIDs[aSide], 1L, (long)this.mMetas[aSide], this.mNBTs[aSide] == null || this.mNBTs[aSide].func_82582_d() ? null : this.mNBTs[aSide]) : this.mBehaviours[aSide].getCoverItem(aSide, this));
    }

    public DelegatorTileEntity<ITileEntityCoverable> delegator(byte aSide) {
        return new DelegatorTileEntity<ITileEntityCoverable>(this.mTileEntity, aSide);
    }

    public boolean requiresSync() {
        return UT.Code.containsBoolean(true, this.mVisualsToSync);
    }

    public void resetSync() {
        for (int i = 0; i < this.mVisualsToSync.length; ++i) {
            this.mVisualsToSync[i] = false;
        }
    }

    public void tickPre(long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        try {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mBehaviours[tSide] == null) continue;
                this.mBehaviours[tSide].onTickPre(tSide, this, aTimer, aIsServerSide, aReceivedBlockUpdate, aReceivedInventoryUpdate);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            this.mTileEntity.setError("Cover Pre Tick - " + (aIsServerSide ? "Serverside: " : "Clientside: ") + e);
        }
    }

    public void tickPost(long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        try {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mBehaviours[tSide] == null) continue;
                this.mBehaviours[tSide].onTickPost(tSide, this, aTimer, aIsServerSide, aReceivedBlockUpdate, aReceivedInventoryUpdate);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            this.mTileEntity.setError("Cover Post Tick - " + (aIsServerSide ? "Serverside: " : "Clientside: ") + e);
        }
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.func_72330_a((double)((double)this.mTileEntity.getX() + aMinX), (double)((double)this.mTileEntity.getY() + aMinY), (double)((double)this.mTileEntity.getZ() + aMinZ), (double)((double)this.mTileEntity.getX() + aMaxX), (double)((double)this.mTileEntity.getY() + aMaxY), (double)((double)this.mTileEntity.getZ() + aMaxZ));
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((double)this.mTileEntity.getX() + aBox[0]), (double)((double)this.mTileEntity.getY() + aBox[1]), (double)((double)this.mTileEntity.getZ() + aBox[2]), (double)((double)this.mTileEntity.getX() + aBox[3]), (double)((double)this.mTileEntity.getY() + aBox[4]), (double)((double)this.mTileEntity.getZ() + aBox[5]));
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((float)this.mTileEntity.getX() + aBox[0]), (double)((float)this.mTileEntity.getY() + aBox[1]), (double)((float)this.mTileEntity.getZ() + aBox[2]), (double)((float)this.mTileEntity.getX() + aBox[3]), (double)((float)this.mTileEntity.getY() + aBox[4]), (double)((float)this.mTileEntity.getZ() + aBox[5]));
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.func_72330_a((double)this.mTileEntity.getX(), (double)this.mTileEntity.getY(), (double)this.mTileEntity.getZ(), (double)(this.mTileEntity.getX() + 1), (double)(this.mTileEntity.getY() + 1), (double)(this.mTileEntity.getZ() + 1));
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        AxisAlignedBB tBox = this.box(aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, float[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        AxisAlignedBB tBox = this.box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aBox, AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        return aBox != null && aBox.func_72326_a(aAABB) && aList.add(aBox);
    }
}

