/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.GT_API;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.code.ModData;
import gregapi.util.ST;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackSet<E extends ItemStackContainer>
extends AbstractSet<ItemStackContainer> {
    private final ItemStackMap<ItemStackContainer, Object> mMap = new ItemStackMap();
    private static final Object OBJECT = new Object();

    public ItemStackSet() {
        GT_API.STACKMAPS.add(this.mMap);
    }

    public ItemStackSet(ItemStack ... aStacks) {
        for (ItemStack aStack : aStacks) {
            this.add(aStack);
        }
        GT_API.STACKMAPS.add(this.mMap);
    }

    @Override
    public Iterator<ItemStackContainer> iterator() {
        return this.mMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean contains(Object aObject) {
        return this.mMap.containsKey(aObject);
    }

    public boolean contains(ItemStack aStack, boolean aWildCard) {
        return this.mMap.containsKey(aStack, aWildCard);
    }

    public boolean contains(ItemStackContainer aStack, boolean aWildCard) {
        return this.mMap.containsKey(aStack, aWildCard);
    }

    public boolean add(ModData aMod, String aName, long aMeta) {
        return this.add(ST.make(aMod, aName, 1L, aMeta));
    }

    @Override
    public boolean add(ItemStack aStack) {
        return ST.valid(aStack) && this.mMap.put(aStack, OBJECT) == null;
    }

    public boolean add(Block aBlock, long aMeta) {
        return aBlock != null && this.mMap.put(aBlock, aMeta, OBJECT) == null;
    }

    @Override
    public boolean add(Block aBlock) {
        return aBlock != null && this.mMap.put(aBlock, 32767L, OBJECT) == null;
    }

    public boolean add(Item aItem, long aMeta) {
        return aItem != null && this.mMap.put(aItem, aMeta, OBJECT) == null;
    }

    @Override
    public boolean add(Item aItem) {
        return aItem != null && this.mMap.put(aItem, 32767L, OBJECT) == null;
    }

    @Override
    public boolean add(ItemStackContainer aStack) {
        return aStack != null && this.mMap.put(aStack, OBJECT) == null;
    }

    @Override
    public boolean addAll(Collection<? extends ItemStackContainer> c) {
        return c != null && super.addAll(c);
    }

    @Override
    public boolean remove(Object aStack) {
        return this.mMap.remove(aStack) == OBJECT;
    }

    @Override
    public boolean equals(Object aObject) {
        return this == aObject;
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }
}

