/**
 * Copyright (c) 2025 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregapi.load;

import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.oredict.OreDictManager;
import gregapi.util.ST;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

/**
 * @author Gregorius Techneticies
 */
public class LoaderUnificationTargets implements Runnable {
	@Override public String toString() {return "Unification Target Loader";}
	
	@Override
	public void run() {
		// Because most Mods (and vanilla MC) are not OreDict Compatible and need to be set as Target manually.
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Au_198                 , MD.HBM, "item.powder_au198"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Au_198                 , MD.HBM, "item.nugget_au198"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Au_198                 , MD.HBM, "item.ingot_au198"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Au_198                 , MD.HBM, "item.billet_au198"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Au_198                 , MD.HBM, "tile.sand_gold198"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Au                     , MD.HBM, "tile.sand_gold"                  , 0);
		OreDictManager.INSTANCE.setTarget(OP.wireFine       , MT.Au                     , MD.HBM, "item.wire_gold"                  , 0);
		OreDictManager.INSTANCE.setTarget(OP.wireFine       , MT.Cu                     , MD.HBM, "item.wire_copper"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.wireFine       , MT.Al                     , MD.HBM, "item.wire_aluminium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.wireFine       , MT.W                      , MD.HBM, "item.wire_tungsten"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.wireFine       , MT.Mingrade               , MD.HBM, "item.wire_red_copper"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Mingrade               , MD.HBM, "item.powder_red_copper"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mingrade               , MD.HBM, "item.ingot_red_copper"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Mingrade               , MD.HBM, "tile.block_red_copper"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.scrapGt        , MT.MeteoricIron           , MD.HBM, "item.fragment_meteorite"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.MeteoricIron           , MD.HBM, "item.powder_meteorite_tiny"      , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.MeteoricIron           , MD.HBM, "item.powder_meteorite"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.Al2O3                  , MD.HBM, "tile.ore_meteor_aluminium"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.Cu                     , MD.HBM, "tile.ore_meteor_copper"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.Pb                     , MD.HBM, "tile.ore_meteor_lead"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.UNUSED.Starmetal       , MD.HBM, "tile.ore_meteor_starmetal"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.TiO2                   , MD.HBM, "tile.ore_meteor_titanium"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.W                      , MD.HBM, "tile.ore_meteor_tungsten"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.Cu                     , MD.HBM, "tile.ore_gneiss_copper"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.Au                     , MD.HBM, "tile.ore_gneiss_gold"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.Fe2O3                  , MD.HBM, "tile.ore_gneiss_iron"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.RareEarth              , MD.HBM, "tile.ore_gneiss_rare"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNether      , MT.Coal                   , MD.HBM, "tile.ore_nether_coal"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.OREMATS.Cobaltite      , MD.HBM, "tile.ore_nether_cobalt"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Pu                     , MD.HBM, "tile.ore_nether_plutonium"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.OREMATS.Scheelite      , MD.HBM, "tile.ore_nether_tungsten"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Bauxite        , MD.HBM, "tile.ore_aluminium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Australium      , MD.HBM, "tile.ore_australium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Be                     , MD.HBM, "tile.ore_beryllium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Cobaltite      , MD.HBM, "tile.ore_cobalt"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.HBM, "tile.ore_copper"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Daffergon       , MD.HBM, "tile.ore_daffergon"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pb                     , MD.HBM, "tile.ore_lead"                   , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Lignite                , MD.HBM, "tile.ore_lignite"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.RareEarth              , MD.HBM, "tile.ore_rare"                   , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Reiium          , MD.HBM, "tile.ore_reiium"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.TiO2                   , MD.HBM, "tile.ore_titanium"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Scheelite      , MD.HBM, "tile.ore_tungsten"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Unobtainium     , MD.HBM, "tile.ore_unobtainium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Verticium       , MD.HBM, "tile.ore_verticium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Weidanium       , MD.HBM, "tile.ore_weidanium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.UNUSED.Schrabidium     , MD.HBM, "tile.ore_gneiss_schrabidium"     , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.UNUSED.Schrabidium     , MD.HBM, "tile.ore_nether_schrabidium"     , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.UNUSED.Schrabidium     , MD.HBM, "tile.ore_schrabidium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_uranium"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_uranium_scorched"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_nether_uranium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_nether_uranium_scorched", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_gneiss_uranium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.OREMATS.Uraninite      , MD.HBM, "tile.ore_gneiss_uranium_scorched", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.OREMATS.Uraninite      , MD.HBM, "item.powder_uranium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.OREMATS.Uraninite      , MD.HBM, "item.nugget_uranium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.OREMATS.Uraninite      , MD.HBM, "item.billet_uranium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.OREMATS.Uraninite      , MD.HBM, "item.ingot_uranium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.U_238                  , MD.HBM, "tile.ore_meteor_uranium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteWhite          , MD.HBM, "tile.ore_fluorite"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.FluoriteWhite          , MD.HBM, "tile.basalt_fluorite"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.FluoriteWhite          , MD.HBM, "item.fluorite"                   , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Alexandrite            , MD.HBM, "item.gem_alexandrite"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Asbestos               , MD.HBM, "tile.ore_asbestos"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.Asbestos               , MD.HBM, "tile.basalt_asbestos"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.Asbestos               , MD.HBM, "tile.ore_gneiss_asbestos"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Asbestos               , MD.HBM, "item.powder_asbestos"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Asbestos               , MD.HBM, "item.ingot_asbestos"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Asbestos               , MD.HBM, "tile.block_asbestos"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.OREMATS.Borax          , MD.HBM, "item.powder_borax"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.S                      , MD.HBM, "tile.basalt_sulfur"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.S                      , MD.HBM, "tile.ore_meteor_sulfur"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.S                      , MD.HBM, "tile.ore_nether_sulfur"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.S                      , MD.HBM, "tile.ore_sulfur"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Niter                  , MD.HBM, "tile.ore_niter"                  , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Niter                  , MD.HBM, "item.niter"                      , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Niter                  , MD.HBM, "tile.block_niter"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.PhosphorusRed          , MD.HBM, "tile.ore_nether_fire"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.PhosphorusRed          , MD.HBM, "item.powder_fire"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.PhosphorusRed          , MD.HBM, "tile.block_red_phosphorus"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.PhosphorusWhite        , MD.HBM, "item.ingot_phosphorus"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.PhosphorusWhite        , MD.HBM, "tile.block_white_phosphorus"     , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Cinnabar       , MD.HBM, "tile.ore_cinnebar"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.OREMATS.Cinnabar       , MD.HBM, "item.cinnebar"                   , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Coltan         , MD.HBM, "tile.ore_coltan"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.OREMATS.Coltan         , MD.HBM, "item.powder_coltan_ore"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.OREMATS.Coltan         , MD.HBM, "item.fragment_coltan"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.OREMATS.Coltan         , MD.HBM, "tile.block_coltan"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.OREMATS.Tantalite      , MD.HBM, "item.powder_coltan"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ta                     , MD.HBM, "item.powder_tantalium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Ta                     , MD.HBM, "item.gem_tantalium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Ta                     , MD.HBM, "item.nugget_tantalium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ta                     , MD.HBM, "item.ingot_tantalium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ta                     , MD.HBM, "tile.block_tantalium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.As                     , MD.HBM, "item.nugget_arsenic"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.As                     , MD.HBM, "item.ingot_arsenic"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Zr                     , MD.HBM, "item.powder_zirconium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Zr                     , MD.HBM, "item.nugget_zirconium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Zr                     , MD.HBM, "item.billet_zirconium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Zr                     , MD.HBM, "item.ingot_zirconium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Be                     , MD.HBM, "item.powder_beryllium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Be                     , MD.HBM, "item.nugget_beryllium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Be                     , MD.HBM, "item.billet_beryllium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Be                     , MD.HBM, "item.ingot_beryllium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Be                     , MD.HBM, "tile.block_beryllium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Bi                     , MD.HBM, "item.nugget_bismuth"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Bi                     , MD.HBM, "item.billet_bismuth"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Bi                     , MD.HBM, "item.ingot_bismuth"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Bi                     , MD.HBM, "tile.block_bismuth"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Co_60                  , MD.HBM, "item.powder_co60"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Co_60                  , MD.HBM, "item.nugget_co60"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Co_60                  , MD.HBM, "item.billet_co60"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Co_60                  , MD.HBM, "item.ingot_co60"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Co                     , MD.HBM, "item.powder_cobalt_tiny"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Co                     , MD.HBM, "item.powder_cobalt"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Co                     , MD.HBM, "item.ingot_cobalt"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ti                     , MD.HBM, "item.powder_titanium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ti                     , MD.HBM, "item.ingot_titanium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Ti                     , MD.HBM, "item.plate_titanium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Osmiridium             , MD.HBM, "item.nugget_osmiridium"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Osmiridium             , MD.HBM, "item.ingot_osmiridium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.TungstenCarbide        , MD.HBM, "item.neutron_reflector"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.DeshAlloy              , MD.HBM, "item.powder_desh"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.DeshAlloy              , MD.HBM, "item.nugget_desh"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DeshAlloy              , MD.HBM, "item.ingot_desh"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.DeshAlloy              , MD.HBM, "tile.block_desh"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Np                     , MD.HBM, "item.powder_neptunium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Np                     , MD.HBM, "item.nugget_neptunium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Np                     , MD.HBM, "item.billet_neptunium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Np                     , MD.HBM, "item.ingot_neptunium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.Th                     , MD.HBM, "tile.ore_meteor_thorium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Th                     , MD.HBM, "tile.ore_thorium"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Th                     , MD.HBM, "item.powder_thorium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Th                     , MD.HBM, "item.nugget_th232"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Th                     , MD.HBM, "item.billet_th232"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Th                     , MD.HBM, "item.ingot_th232"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ra                     , MD.HBM, "item.powder_ra226"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Ra                     , MD.HBM, "item.nugget_ra226"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Ra                     , MD.HBM, "item.billet_ra226"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ra                     , MD.HBM, "item.ingot_ra226"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ra                     , MD.HBM, "tile.block_ra226"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.U_233                  , MD.HBM, "item.nugget_u233"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.U_233                  , MD.HBM, "item.billet_u233"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.U_233                  , MD.HBM, "item.ingot_u233"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.U_235                  , MD.HBM, "item.nugget_u235"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.U_235                  , MD.HBM, "item.billet_u235"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.U_235                  , MD.HBM, "item.ingot_u235"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.U_238                  , MD.HBM, "item.nugget_u238"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.U_238                  , MD.HBM, "item.billet_u238"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.U_238                  , MD.HBM, "item.ingot_u238"                 , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Pu_238                 , MD.HBM, "item.nugget_pu238"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Pu_238                 , MD.HBM, "item.billet_pu238"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pu_238                 , MD.HBM, "item.ingot_pu238"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Pu_239                 , MD.HBM, "item.nugget_pu239"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Pu_239                 , MD.HBM, "item.billet_pu239"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pu_239                 , MD.HBM, "item.ingot_pu239"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Pu_240                 , MD.HBM, "item.nugget_pu240"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Pu_240                 , MD.HBM, "item.billet_pu240"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pu_240                 , MD.HBM, "item.ingot_pu240"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Pu_241                 , MD.HBM, "item.nugget_pu241"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Pu_241                 , MD.HBM, "item.billet_pu241"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pu_241                 , MD.HBM, "item.ingot_pu241"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Pu                     , MD.HBM, "item.powder_plutonium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Pu                     , MD.HBM, "item.nugget_plutonium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Pu                     , MD.HBM, "item.billet_plutonium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pu                     , MD.HBM, "item.ingot_plutonium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Am_241                 , MD.HBM, "item.nugget_am241"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Am_241                 , MD.HBM, "item.billet_am241"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Am_241                 , MD.HBM, "item.ingot_am241"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Am_242                 , MD.HBM, "item.nugget_am242"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.billet         , MT.Am_242                 , MD.HBM, "item.billet_am242"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Am_242                 , MD.HBM, "item.ingot_am242"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.At                     , MD.HBM, "item.powder_at209"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Ac                     , MD.HBM, "item.powder_actinium_tiny"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ac                     , MD.HBM, "item.powder_actinium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Ac                     , MD.HBM, "item.fragment_actinium"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ac                     , MD.HBM, "item.ingot_actinium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Steel                  , MD.HBM, "item.powder_steel_tiny"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Steel                  , MD.HBM, "item.powder_steel"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Coal                   , MD.HBM, "item.powder_coal_tiny"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Coal                   , MD.HBM, "item.powder_coal"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CoalCoke               , MD.HBM, "item.coke"                       , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Lignite                , MD.HBM, "item.powder_lignite"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Lignite                , MD.HBM, "item.lignite"                    , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.LigniteCoke            , MD.HBM, "item.coke"                       , 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.PetCoke                , MD.HBM, "item.coke"                       , 2);
		OreDictManager.INSTANCE.setTarget(OP.oreGneiss      , MT.LiCl                   , MD.HBM, "tile.ore_gneiss_lithium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSpace       , MT.Li                     , MD.HBM, "tile.ore_meteor_lithium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Li                     , MD.HBM, "item.powder_lithium_tiny"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Li                     , MD.HBM, "item.powder_lithium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Li                     , MD.HBM, "item.lithium"                    , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Li                     , MD.HBM, "tile.block_lithium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.B                      , MD.HBM, "item.powder_boron_tiny"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.B                      , MD.HBM, "item.powder_boron"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.B                      , MD.HBM, "item.fragment_boron"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.B                      , MD.HBM, "item.ingot_boron"                , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.La                     , MD.HBM, "item.powder_lanthanium_tiny"     , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.La                     , MD.HBM, "item.powder_lanthanium"          , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.La                     , MD.HBM, "item.fragment_lanthanium"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.La                     , MD.HBM, "item.ingot_lanthanium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Nb                     , MD.HBM, "item.powder_niobium_tiny"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Nb                     , MD.HBM, "item.powder_niobium"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Nb                     , MD.HBM, "item.fragment_niobium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Nb                     , MD.HBM, "item.ingot_niobium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Nb                     , MD.HBM, "tile.block_niobium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Nd                     , MD.HBM, "item.powder_neodymium_tiny"      , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Nd                     , MD.HBM, "item.powder_neodymium"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Nd                     , MD.HBM, "item.fragment_neodymium"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Ce                     , MD.HBM, "item.powder_cerium_tiny"         , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ce                     , MD.HBM, "item.powder_cerium"              , 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Ce                     , MD.HBM, "item.fragment_cerium"            , 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Br                     , MD.HBM, "item.powder_bromine"             , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Adamantine             , MD.MET, "adamantine.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Alduorite              , MD.MET, "alduorite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Amordrine              , MD.MET, "amordrine.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Angmallen              , MD.MET, "angmallen.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.AstralSilver           , MD.MET, "astral.silver.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Atl                    , MD.MET, "atlarus.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.BlackSteel             , MD.MET, "black.steel.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Brass                  , MD.MET, "brass.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Bronze                 , MD.MET, "bronze.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Carmot                 , MD.MET, "carmot.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Celenegil              , MD.MET, "celenegil.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ceruclase              , MD.MET, "ceruclase.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Cu                     , MD.MET, "copper.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DamascusSteel          , MD.MET, "damascus.steel.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DeepIron               , MD.MET, "deep.iron.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Desichalkos            , MD.MET, "desichalkos.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Electrum               , MD.MET, "electrum.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Eximite                , MD.MET, "eximite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Haderoth               , MD.MET, "haderoth.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Hepatizon              , MD.MET, "hepatizon.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ignatius               , MD.MET, "ignatius.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Infuscolium            , MD.MET, "infuscolium.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Inolashite             , MD.MET, "inolashite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Kalendrite             , MD.MET, "kalendrite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Lemurite               , MD.MET, "lemurite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mn                     , MD.MET, "manganese.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Meutoite               , MD.MET, "meutoite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Midasium               , MD.MET, "midasium.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mithril                , MD.MET, "mithril.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Orichalcum             , MD.MET, "orichalcum.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Oureclase              , MD.MET, "oureclase.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pt                     , MD.MET, "platinum.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Prometheum             , MD.MET, "prometheum.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Hg                     , MD.MET, "quicksilver.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Rubracium              , MD.MET, "rubracium.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Sanguinite             , MD.MET, "sanguinite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ShadowIron             , MD.MET, "shadow.iron.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ShadowSteel            , MD.MET, "shadow.steel.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ag                     , MD.MET, "silver.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Steel                  , MD.MET, "steel.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Tartarite              , MD.MET, "tartarite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Sn                     , MD.MET, "tin.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Vulcanite              , MD.MET, "vulcanite.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Zn                     , MD.MET, "zinc.ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteWhite          , MD.NeLi, "CrystalShard", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteBlue           , MD.NeLi, "CrystalShard", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteGreen          , MD.NeLi, "CrystalShard", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteYellow         , MD.NeLi, "CrystalShard", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteMagenta        , MD.NeLi, "CrystalShard", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.KCl                    , MD.PFAA, "weakOreRock", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteMagenta        , MD.PFAA, "mediumOreRock", 13);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.MilkyQuartz            , MD.PFAA, "strongOreRock", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Oilshale               , MD.PFAA, "crudeLump", 31);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Coal                   , MD.PFAA, "crudeLump", 32);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Lignite                , MD.PFAA, "crudeLump", 33);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Anthracite             , MD.PFAA, "crudeLump", 34);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CoalCoke               , MD.PFAA, "crudeLump", 35);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Peat                   , MD.PFAA, "earthyClump", 36);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Bone                   , MD.Fossil, "fossil", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Amber                  , MD.Fossil, "amberOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Amber                  , MD.Fossil, "amber", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.AmberDominican         , MD.Fossil, "DominicanAmber", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.IronCompressed         , MD.PnC, "ingotIronCompressed", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.IronCompressed         , MD.PnC, "compressedIronBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.gearGt         , MT.IronCompressed         , MD.PnC, "compressedIronGear", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDense       , MT.Coal                   , MD.MF2, "oreCoalRich", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Niter                  , MD.MF2, "oreNitre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.S                      , MD.MF2, "oreSulfur", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , MD.MF2, "oreTin", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.MF2, "oreCopper", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ag                     , MD.MF2, "oreSilver", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.W                      , MD.MF2, "oreTungsten", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Borax          , MD.MF2, "oreBorax", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Kaolinite              , MD.MF2, "oreKaolinite", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.EnderPearl             , MD.MF2, "ender_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ad                     , MD.MF2, "adamantium_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Mithril                , MD.MF2, "mithril_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.BlackSteel             , MD.MF2, "blacksteel_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.BlueSteel              , MD.MF2, "bluesteel_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.RedSteel               , MD.MF2, "redsteel_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Steel                  , MD.MF2, "steel_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Bronze                 , MD.MF2, "bronze_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Cu                     , MD.MF2, "copper_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Sn                     , MD.MF2, "tin_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ag                     , MD.MF2, "silver_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.PigIron                , MD.MF2, "pigiron_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.S                      , MD.MF2, "MF_Com_sulfur", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Niter                  , MD.MF2, "MF_Com_nitre", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Kaolinite              , MD.MF2, "MF_Com_kaolinite", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.OREMATS.Borax          , MD.MF2, "MF_Com_flux_strong", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.STONES.Limestone       , MD.MF2, "MF_Com_flux", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Meteorite              , MD.FM, "MeteoriteIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.FrozenIron             , MD.FM, "FrozenIron", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Kreknorite             , MD.FM, "KreknoriteIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Frezarite              , MD.FM, "FrezaCrystal", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.RedMeteor              , MD.FM, "RedMeteorGem", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.RedMeteor              , MD.FM, "BlockRedMeteorGem", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Meteorite              , MD.FM, "BlockMeteorDecoration", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.FrozenIron             , MD.FM, "BlockMeteorDecoration", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Kreknorite             , MD.FM, "BlockMeteorDecoration", 2);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Cu                     , MD.GC, "item.basicItem", 6);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Sn                     , MD.GC, "item.basicItem", 7);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Al                     , MD.GC, "item.basicItem", 8);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Steel                  , MD.GC, "item.basicItem", 9);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Bronze                 , MD.GC, "item.basicItem",10);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Fe                     , MD.GC, "item.basicItem",11);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.MeteoricIron           , MD.GC, "item.meteoricIronIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.MeteoricIron           , MD.GC, "item.meteoricIronIngot", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.MeteoricIron           , MD.GC, "tile.gcBlockCore", 12);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Desh                   , MD.GC_PLANETS, "item.null", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Desh                   , MD.GC_PLANETS, "item.null", 2);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Desh                   , MD.GC_PLANETS, "item.null", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Desh                   , MD.GC_PLANETS, "tile.mars", 8);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Ti                     , MD.GC_PLANETS, "item.itemBasicAsteroids", 6);
		if (MD.GC_GALAXYSPACE.mLoaded) if (ST.valid(ST.make(MD.GC_GALAXYSPACE, "dungeonglowstone", 0))) {
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Co                     , MD.GC_GALAXYSPACE, "ores", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ni                     , MD.GC_GALAXYSPACE, "ores", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.BlueSapphire           , MD.GC_GALAXYSPACE, "ores", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , MD.GC_GALAXYSPACE, "ores", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.BlueSapphire           , MD.GC_GALAXYSPACE, "ores", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.BlueSapphire           , MD.GC_GALAXYSPACE, "item.BasicItems", 6);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Dolomite               , MD.GC_GALAXYSPACE, "item.BasicItems", 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Co                     , MD.GC_GALAXYSPACE, "item.Ingots", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mg                     , MD.GC_GALAXYSPACE, "item.Ingots", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ni                     , MD.GC_GALAXYSPACE, "item.Ingots", 2);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Co                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 0);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Mg                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 1);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Ni                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 2);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Coal                   , MD.GC_GALAXYSPACE, "item.CompressedPlates", 3);
		} else {
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Adamantite             , MD.GC_GALAXYSPACE, "item.Ingots", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Duralumin              , MD.GC_GALAXYSPACE, "item.Ingots", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Oriharukon             , MD.GC_GALAXYSPACE, "item.Ingots", 7);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Adamantite             , MD.GC_GALAXYSPACE, "item.CompressedPlates", 0);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Co                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 1);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Duralumin              , MD.GC_GALAXYSPACE, "item.CompressedPlates", 2);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Pb                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 3);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Mg                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 4);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Mithril                , MD.GC_GALAXYSPACE, "item.CompressedPlates", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Ni                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 6);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Oriharukon             , MD.GC_GALAXYSPACE, "item.CompressedPlates", 7);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Pt                     , MD.GC_GALAXYSPACE, "item.CompressedPlates", 8);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.W                      , MD.GC_GALAXYSPACE, "item.CompressedPlates", 9);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Pb                     , MD.GC_GALAXYSPACE, "metalsblock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Adamantite             , MD.GC_GALAXYSPACE, "metalsblock", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Co                     , MD.GC_GALAXYSPACE, "metalsblock", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Mg                     , MD.GC_GALAXYSPACE, "metalsblock", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Mithril                , MD.GC_GALAXYSPACE, "metalsblock", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ni                     , MD.GC_GALAXYSPACE, "metalsblock", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Oriharukon             , MD.GC_GALAXYSPACE, "metalsblock", 6);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Pt                     , MD.GC_GALAXYSPACE, "metalsblock", 7);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.W                      , MD.GC_GALAXYSPACE, "metalsblock", 8);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Duralumin              , MD.GC_GALAXYSPACE, "metalsblock", 9);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GlowstoneCeres         , MD.GC_GALAXYSPACE, "item.GlowstoneDusts", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GlowstoneIo            , MD.GC_GALAXYSPACE, "item.GlowstoneDusts", 1);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GlowstoneEnceladus     , MD.GC_GALAXYSPACE, "item.GlowstoneDusts", 2);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GlowstoneProteus       , MD.GC_GALAXYSPACE, "item.GlowstoneDusts", 3);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GlowstonePluto         , MD.GC_GALAXYSPACE, "item.GlowstoneDusts", 4);
		}
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pb                     , MD.GC_EXTRAPLANETS, "item.ingotLead", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.U_238                  , MD.GC_EXTRAPLANETS, "ingotUranium", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Hg                     , MD.GC_EXTRAPLANETS, "ingotMercury", 0);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Hg                     , MD.GC_EXTRAPLANETS, "compressedMercury", 0);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.C                      , MD.GC_EXTRAPLANETS, "tier4Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.C                      , MD.GC_EXTRAPLANETS, "tier4Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Pd                     , MD.GC_EXTRAPLANETS, "tier5Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pd                     , MD.GC_EXTRAPLANETS, "tier5Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Ni                     , MD.GC_EXTRAPLANETS, "tier5Items", 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ni                     , MD.GC_EXTRAPLANETS, "tier5Items", 7);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Mg                     , MD.GC_EXTRAPLANETS, "tier6Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mg                     , MD.GC_EXTRAPLANETS, "tier6Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Zn                     , MD.GC_EXTRAPLANETS, "tier8Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Zn                     , MD.GC_EXTRAPLANETS, "tier8Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.W                      , MD.GC_EXTRAPLANETS, "tier9Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.W                      , MD.GC_EXTRAPLANETS, "tier9Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.DarkIron               , MD.GC_EXTRAPLANETS, "tier10Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DarkIron               , MD.GC_EXTRAPLANETS, "tier10Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondBlue            , MD.GC_EXTRAPLANETS, "tier11Items", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondRed             , MD.GC_EXTRAPLANETS, "tier11Items", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondPurple          , MD.GC_EXTRAPLANETS, "tier11Items", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondYellow          , MD.GC_EXTRAPLANETS, "tier11Items", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondGreen           , MD.GC_EXTRAPLANETS, "tier11Items", 4);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 5);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 6);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 7);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 8);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 9);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Maple            , MD.GC_EXTRAPLANETS, "tier11Items", 10);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Pt                     , MD.GC_EXTRAPLANETS, "tier11Items", 11);
		OreDictManager.INSTANCE.setTarget(OP.compressed     , MT.Pt                     , MD.GC_EXTRAPLANETS, "tier11Items", 12);
		OreDictManager.INSTANCE.setTarget(OP.gearGt         , MT.TitaniumAluminide      , MD.GC_ADV_ROCKETRY, "advancedRocketryproductgear", 0);
		OreDictManager.INSTANCE.setTarget(OP.gearGt         , MT.Iritanium              , MD.GC_ADV_ROCKETRY, "advancedRocketryproductgear", 1);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.TitaniumAluminide      , MD.GC_ADV_ROCKETRY, "advancedRocketryproductsheet", 0);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Iritanium              , MD.GC_ADV_ROCKETRY, "advancedRocketryproductsheet", 1);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Fe                     , MD.VULPES, "libVulpesproductsheet", 1);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Cu                     , MD.VULPES, "libVulpesproductsheet", 4);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Steel                  , MD.VULPES, "libVulpesproductsheet", 6);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Ti                     , MD.VULPES, "libVulpesproductsheet", 7);
		OreDictManager.INSTANCE.setTarget(OP.sheetGt        , MT.Al                     , MD.VULPES, "libVulpesproductsheet", 9);
		OreDictManager.INSTANCE.setTarget(OP.gearGt         , MT.Steel                  , MD.VULPES, "libVulpesproductgear", 6);
		OreDictManager.INSTANCE.setTarget(OP.gearGt         , MT.Ti                     , MD.VULPES, "libVulpesproductgear", 7);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Dilithium              , MD.VULPES, "libVulpesproductdust", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Dilithium              , MD.VULPES, "libVulpesproductcrystal", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.EnderAmethyst          , MD.BoP, "gemOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.EnderAmethyst          , MD.BoP, "gemOre", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ruby                   , MD.BoP, "gemOre", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Ruby                   , MD.BoP, "gemOre", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Peridot                , MD.BoP, "gemOre", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Peridot                , MD.BoP, "gemOre", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Topaz                  , MD.BoP, "gemOre", 6);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Topaz                  , MD.BoP, "gemOre", 7);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Tanzanite              , MD.BoP, "gemOre", 8);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Tanzanite              , MD.BoP, "gemOre", 9);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Malachite      , MD.BoP, "gemOre",10);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.OREMATS.Malachite      , MD.BoP, "gemOre",11);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sapphire               , MD.BoP, "gemOre",12);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Sapphire               , MD.BoP, "gemOre",13);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Amber                  , MD.BoP, "gemOre",14);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Amber                  , MD.BoP, "gemOre",15);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.EnderAmethyst          , MD.BoP, "gems"  , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Ruby                   , MD.BoP, "gems"  , 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Peridot                , MD.BoP, "gems"  , 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Topaz                  , MD.BoP, "gems"  , 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Tanzanite              , MD.BoP, "gems"  , 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.OREMATS.Malachite      , MD.BoP, "gems"  , 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Sapphire               , MD.BoP, "gems"  , 6);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Amber                  , MD.BoP, "gems"  , 7);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Manasteel              , MD.TCFM, "FMResource", 2);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.ElvenElementium        , MD.TCFM, "FMResource", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.NetherStar             , MD.TCFM, "StarBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Carminite              , MD.TF, "item.carminite", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Mazestone       , MD.TF, "tile.TFMazestone", 2);
		OreDictManager.INSTANCE.setTarget(OP.scrapGt        , MT.Knightmetal            , MD.TF, "item.armorShards", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.FierySteel             , MD.TF, "item.fieryIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Knightmetal            , MD.TF, "item.knightMetal", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Steeleaf               , MD.TF, "item.steeleafIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.IronWood               , MD.TF, "item.ironwoodIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Knightmetal            , MD.TF, "tile.KnightmetalBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.An                     , MD.ABYSSAL, "abyblock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Cor                    , MD.ABYSSAL, "corblock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Dr                     , MD.ABYSSAL, "dreadiumblock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Etx                    , MD.ABYSSAL, "ethaxiumblock", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.An                     , MD.ABYSSAL, "abyingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Cor                    , MD.ABYSSAL, "cingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Dr                     , MD.ABYSSAL, "dreadumingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Etx                    , MD.ABYSSAL, "ethaxiumingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.An                     , MD.ABYSSAL, "ingotnugget", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Cor                    , MD.ABYSSAL, "ingotnugget", 1);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Dr                     , MD.ABYSSAL, "ingotnugget", 2);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Etx                    , MD.ABYSSAL, "ingotnugget", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Cor                    , MD.ABYSSAL, "coralium", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Redstone               , MD.ABYSSAL, "crystal", 11);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Niter                  , MD.ABYSSAL, "nitreore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.An                     , MD.ABYSSAL, "abyore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cor                    , MD.ABYSSAL, "coraliumore", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Jade                   , MD.ERE, "blockJade", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Jade                   , MD.ERE, "materials", 1);
		OreDictManager.INSTANCE.setTarget(OP.gemFlawless    , MT.Redstone               , MD.ERE, "materials",12);
		OreDictManager.INSTANCE.setTarget(OP.rockGt         , MT.STONES.Gneiss          , MD.ERE, "materials",48);
		OreDictManager.INSTANCE.setTarget(OP.rockGt         , MT.PetrifiedWood          , MD.ERE, "materials", 7);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.PetrifiedWood          , MD.ERE, "petrifiedWoodPlanks", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.PetrifiedWood          , MD.ERE, "orePetrifiedWood", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.STONES.Gneiss          , MD.ERE, "oreGneiss", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Bone                   , MD.ERE, "oreFossil", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Fe                     , MD.ERE, "oreIron", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Au                     , MD.ERE, "oreGold", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Ag                     , MD.ERE, "oreSilver", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Cu                     , MD.ERE, "oreCopper", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Sn                     , MD.ERE, "oreTin", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Pb                     , MD.ERE, "oreLead", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Al                     , MD.ERE, "oreAluminium", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Coal                   , MD.ERE, "oreCoal", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Emerald                , MD.ERE, "oreEmerald", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Diamond                , MD.ERE, "oreDiamond", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.NetherQuartz           , MD.ERE, "oreQuartz", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Lapis                  , MD.ERE, "oreLapis", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreUmberstone  , MT.Jade                   , MD.ERE, "oreJade", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Umber           , MD.ERE, "umberstone", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Gneiss          , MD.ERE, "gneiss", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Scabyst                , MD.BTL, "unknownGeneric", 42);
		OreDictManager.INSTANCE.setTarget(OP.orePitstone    , MT.Scabyst                , MD.BTL, "scabystOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.SlimyBone              , MD.BTL, "unknownGeneric", 17);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.SlimyBone              , MD.BTL, "slimyBoneBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBetweenstone, MT.SlimyBone              , MD.BTL, "boneOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Weedwood               , MD.BTL, "unknownGeneric", 23);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.CrimsonMiddle          , MD.BTL, "groundStuff", 28);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CrimsonMiddle          , MD.BTL, "crimsonMiddleGem", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.CrimsonMiddle          , MD.BTL, "crimsonMiddleGemBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreMud         , MT.CrimsonMiddle          , MD.BTL, "crimsonMiddleGemOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.GreenMiddle            , MD.BTL, "groundStuff", 32);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.GreenMiddle            , MD.BTL, "greenMiddleGem", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.GreenMiddle            , MD.BTL, "greenMiddleGemBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreMud         , MT.GreenMiddle            , MD.BTL, "greenMiddleGemOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.AquaMiddle             , MD.BTL, "groundStuff", 45);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.AquaMiddle             , MD.BTL, "aquaMiddleGem", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.AquaMiddle             , MD.BTL, "aquaMiddleGemBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreMud         , MT.AquaMiddle             , MD.BTL, "aquaMiddleGemOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Valonite               , MD.BTL, "unknownGeneric", 22);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Valonite               , MD.BTL, "valoniteBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.orePitstone    , MT.Valonite               , MD.BTL, "valoniteOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.S                      , MD.BTL, "unknownGeneric", 21);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.S                      , MD.BTL, "sulphurBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBetweenstone, MT.S                      , MD.BTL, "sulfurOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Syrmorite              , MD.BTL, "unknownGeneric", 14);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Syrmorite              , MD.BTL, "syrmoriteBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBetweenstone, MT.Syrmorite              , MD.BTL, "syrmoriteOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Octine                 , MD.BTL, "unknownGeneric", 15);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Octine                 , MD.BTL, "octineBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBetweenstone, MT.Octine                 , MD.BTL, "octineOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Betweenstone    , MD.BTL, "smoothBetweenstone", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Pitstone        , MD.BTL, "smoothPitstone", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Cragrock        , MD.BTL, "smoothCragrock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Templerock      , MD.BTL, "smoothTempleBrick", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Limestone       , MD.BTL, "limestone", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Blaze                  , MD.GaNe, "blazeIngot", 1);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Blaze                  , MD.GaNe, "blazeIngot", 2);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Endstone               , MD.GaEn, "endstoneRod", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.Endium                 , MD.GaEn, "rawEndium", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Endium                 , MD.GaEn, "endiumIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Endium                 , MD.GaEn, "endiumIngot", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Endium                 , MD.GaEn, "endiumBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreHolystone   , MT.Zanite                 , MD.AETHER, "zaniteOre"     ,  0);
		OreDictManager.INSTANCE.setTarget(OP.oreHolystone   , MT.Ambrosium              , MD.AETHER, "ambrosiumOre"  ,  0);
		OreDictManager.INSTANCE.setTarget(OP.oreHolystone   , MT.Gravitite              , MD.AETHER, "gravititeOre"  ,  0);
		OreDictManager.INSTANCE.setTarget(OP.oreHolystone   , MT.Continuum              , MD.AETHER, "continuumOre"  ,  0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Zanite                 , MD.AETHER, "zaniteGemstone",  0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Ambrosium              , MD.AETHER, "ambrosiumShard",  0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.AmberGolden            , MD.AETHER, "goldenAmber"   ,  0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Continuum              , MD.AETHER, "continuumOrb"  ,  0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Zanite                 , MD.AETHER, "zaniteBlock"   ,  0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Continuum              , MD.AETHER, "continuumBomb" ,  0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Skyroot                , MD.AETHER, "skyrootStick"  ,  0);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.Skyroot                , MD.AETHER, "skyrootRing"   ,  0);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.Fe                     , MD.AETHER, "ironRing"      ,  0);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.Au                     , MD.AETHER, "goldenRing"    ,  0);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.Zanite                 , MD.AETHER, "zaniteRing"    ,  0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Cinnabar       , MD.TC, "blockCustomOre"    ,  0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedAir             , MD.TC, "blockCustomOre"    ,  1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedFire            , MD.TC, "blockCustomOre"    ,  2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedWater           , MD.TC, "blockCustomOre"    ,  3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedEarth           , MD.TC, "blockCustomOre"    ,  4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedOrder           , MD.TC, "blockCustomOre"    ,  5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.InfusedEntropy         , MD.TC, "blockCustomOre"    ,  6);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Amber                  , MD.TC, "blockCustomOre"    ,  7);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedAir             , MD.TC, "ItemShard"         ,  0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedFire            , MD.TC, "ItemShard"         ,  1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedWater           , MD.TC, "ItemShard"         ,  2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedEarth           , MD.TC, "ItemShard"         ,  3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedOrder           , MD.TC, "ItemShard"         ,  4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedEntropy         , MD.TC, "ItemShard"         ,  5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.InfusedBalance         , MD.TC, "ItemShard"         ,  6);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.Au                     , MD.TC, "ItemBaubleBlanks"  ,  1);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedAir             , MD.TC, "ItemBaubleBlanks"  ,  3);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedEarth           , MD.TC, "ItemBaubleBlanks"  ,  4);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedFire            , MD.TC, "ItemBaubleBlanks"  ,  5);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedWater           , MD.TC, "ItemBaubleBlanks"  ,  6);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedOrder           , MD.TC, "ItemBaubleBlanks"  ,  7);
		OreDictManager.INSTANCE.setTarget(OP.ring           , MT.InfusedEntropy         , MD.TC, "ItemBaubleBlanks"  ,  8);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Hg                     , MD.TC, "ItemNugget"        ,  5);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Thaumium               , MD.TC, "ItemNugget"        ,  6);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.VoidMetal              , MD.TC, "ItemNugget"        ,  7);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Fe2O3                  , MD.TC, "ItemNugget"        , 16);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Cu                     , MD.TC, "ItemNugget"        , 17);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Sn                     , MD.TC, "ItemNugget"        , 18);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Ag                     , MD.TC, "ItemNugget"        , 19);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Pb                     , MD.TC, "ItemNugget"        , 20);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.OREMATS.Cinnabar       , MD.TC, "ItemNugget"        , 21);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Au                     , MD.TC, "ItemNugget"        , 31);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Thaumium               , MD.TC, "blockCosmeticSolid",  4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Thaumium               , MD.TC, "ItemResource"      ,  2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.VoidMetal              , MD.TC, "ItemResource"      , 16);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Hg                     , MD.TC, "ItemResource"      ,  3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Amber                  , MD.TC, "ItemResource"      ,  6);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DarkMatter             , MD.PE, "item.pe_matter", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.RedMatter              , MD.PE, "item.pe_matter", 1);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxMagic               , MD.FRMB, "wax", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxSoulful             , MD.FRMB, "wax", 1);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxAmnesic             , MD.FRMB, "wax", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.SmokeyQuartz           , MD.BOTA, "quartz", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.ManaQuartz             , MD.BOTA, "quartz", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.BlazeQuartz            , MD.BOTA, "quartz", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.LavenderQuartz         , MD.BOTA, "quartz", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.RedQuartz              , MD.BOTA, "quartz", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.ElvenQuartz            , MD.BOTA, "quartz", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.SunnyQuartz            , MD.BOTA, "quartz", 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Manasteel              , MD.BOTA, "manaResource", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.ManaDiamond            , MD.BOTA, "manaResource", 2);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Livingwood             , MD.BOTA, "manaResource", 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Terrasteel             , MD.BOTA, "manaResource", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ElvenElementium        , MD.BOTA, "manaResource", 7);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.ElvenDragonstone       , MD.BOTA, "manaResource", 9);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Dreamwood              , MD.BOTA, "manaResource",13);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.GaiaSpirit             , MD.BOTA, "manaResource",14);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Manasteel              , MD.BOTA, "manaResource",17);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Terrasteel             , MD.BOTA, "manaResource",18);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.ElvenElementium        , MD.BOTA, "manaResource",19);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Manasteel              , MD.BOTA, "storage", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Terrasteel             , MD.BOTA, "storage", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.ElvenElementium        , MD.BOTA, "storage", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.ManaDiamond            , MD.BOTA, "storage", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.ElvenDragonstone       , MD.BOTA, "storage", 4);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Livingwood             , MD.BOTA, "livingwood", 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Dreamwood              , MD.BOTA, "dreamwood", 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Shimmerwood            , MD.BOTA, "shimmerwoodPlanks", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreLivingrock  , MT.ElvenDragonstone       , MD.ALF, "ElvenOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreLivingrock  , MT.ElvenElementium        , MD.ALF, "ElvenOre", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreLivingrock  , MT.ElvenQuartz            , MD.ALF, "ElvenOre", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreLivingrock  , MT.Au                     , MD.ALF, "ElvenOre", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreLivingrock  , MT.Iffesal                , MD.ALF, "ElvenOre", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Mauftrium              , MD.ALF, "MauftriumBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Elvorium               , MD.ALF, "ElvoriumBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Elvorium               , MD.ALF, "ElvenItems", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Mauftrium              , MD.ALF, "ElvenItems", 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.MuspelheimPower        , MD.ALF, "ElvenItems", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.NiflheimPower          , MD.ALF, "ElvenItems", 5);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Elvorium               , MD.ALF, "ElvenItems", 6);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Mauftrium              , MD.ALF, "ElvenItems", 7);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Iffesal                , MD.ALF, "ElvenItems", 10);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Ag                     , MD.WTCH, "ingredient", 157);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Gypsum                 , MD.WTCH, "ingredient", 17);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Bedrockium             , MD.ExS, "block_bedrockium", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Bedrockium             , MD.ExS, "bedrockiumIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Bedrockium             , MD.ExU, "block_bedrockium", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Bedrockium             , MD.ExU, "bedrockiumIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Chocolate              , MD.AA, "itemFood", 9);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.BlackQuartz            , MD.AA, "itemDust", 7);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.BlackQuartz            , MD.AA, "itemMisc", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Redstonia              , MD.AA, "itemCrystal", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Palis                  , MD.AA, "itemCrystal", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Diamantine             , MD.AA, "itemCrystal", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.VoidCrystal            , MD.AA, "itemCrystal", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Emeradic               , MD.AA, "itemCrystal", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Enori                  , MD.AA, "itemCrystal", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Redstonia              , MD.AA, "blockCrystal", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Palis                  , MD.AA, "blockCrystal", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Diamantine             , MD.AA, "blockCrystal", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.VoidCrystal            , MD.AA, "blockCrystal", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Emeradic               , MD.AA, "blockCrystal", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Enori                  , MD.AA, "blockCrystal", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.BlackQuartz            , MD.AA, "blockMisc", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Charcoal               , MD.AA, "blockMisc", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.HexoriumRed            , MD.HEX, "itemHexoriumCrystalRed"     , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.HexoriumGreen          , MD.HEX, "itemHexoriumCrystalGreen"   , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.HexoriumBlue           , MD.HEX, "itemHexoriumCrystalBlue"    , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.HexoriumBlack          , MD.HEX, "itemHexoriumCrystalBlack"   , 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.HexoriumWhite          , MD.HEX, "itemHexoriumCrystalWhite"   , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.HexoriumRed            , MD.HEX, "blockOfHexoriumCrystalRed"  , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.HexoriumGreen          , MD.HEX, "blockOfHexoriumCrystalGreen", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.HexoriumBlue           , MD.HEX, "blockOfHexoriumCrystalBlue" , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.HexoriumBlack          , MD.HEX, "blockOfHexoriumCrystalBlack", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.HexoriumWhite          , MD.HEX, "blockOfHexoriumCrystalWhite", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.HexoriumRed            , MD.HEX, "blockHexoriumOreRed"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.HexoriumGreen          , MD.HEX, "blockHexoriumOreGreen"      , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.HexoriumBlue           , MD.HEX, "blockHexoriumOreBlue"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.HexoriumBlack          , MD.HEX, "blockHexoriumOreBlack"      , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.HexoriumWhite          , MD.HEX, "blockHexoriumOreWhite"      , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.HexoriumRed            , MD.HEX, "blockHexoriumNetherOreRed"  , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.HexoriumGreen          , MD.HEX, "blockHexoriumNetherOreGreen", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.HexoriumBlue           , MD.HEX, "blockHexoriumNetherOreBlue" , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.HexoriumBlack          , MD.HEX, "blockHexoriumNetherOreBlack", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.HexoriumWhite          , MD.HEX, "blockHexoriumNetherOreWhite", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.CoalCoke               , MD.RC, "cube", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CoalCoke               , MD.RC, "fuel.coke", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Firestone              , MD.RC, "firestone.raw", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.S                      , MD.RC, "ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreSandstone   , MT.KNO3                   , MD.RC, "ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.Diamond                , MD.RC, "ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.Emerald                , MD.RC, "ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreBasalt      , MT.Lapis                  , MD.RC, "ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Firestone              , MD.RC, "ore", 5);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Fe                     , MD.RC, "part.plate", 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Steel                  , MD.RC, "part.plate", 1);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.TinAlloy               , MD.RC, "part.plate", 2);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Cu                     , MD.RC, "part.plate", 3);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Pb                     , MD.RC, "part.plate", 4);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Al                     , MD.MaCu, "crafting", 7);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Au                     , MD.MaCu, "crafting",13);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Ti                     , MD.MaCu, "crafting",17);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.MeatRaw                , MD.MFR, "meat.nugget.raw", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.MeatCooked             , MD.MFR, "meat.nugget.cooked", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.MeatRaw                , MD.MFR, "meat.ingot.raw", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.MeatCooked             , MD.MFR, "meat.ingot.cooked", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.FishRaw                , MD.MaCu, "materials", 14);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WoodPolished           , MD.MaCu, "crafting", 3);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.WoodPolished           , MD.MaCu, "woods", 1);
//      OreDictManager.INSTANCE.setTarget(OP.plate          , MT.WoodTreated            , MD.IE, "treatedWood", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WoodTreated            , MD.IE, "material", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CoalCoke               , MD.IE, "material", 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Steel                  , MD.IE, "metal",  7);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.CoalCoke               , MD.IE, "metal", 17);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.NetherQuartz           , MD.IE, "metal", 18);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.IE, "ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Bauxite        , MD.IE, "ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pb                     , MD.IE, "ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ag                     , MD.IE, "ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ni                     , MD.IE, "ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.FSP, "steamcraftOre",  0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Zn                     , MD.FSP, "steamcraftOre",  1);
		OreDictManager.INSTANCE.setTarget(OP.orePoor        , MT.Zn                     , MD.FSP, "steamcraftOre",  2);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Fe2O3                  , MD.FSP, "smashedOre",  0);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Au                     , MD.FSP, "smashedOre",  1);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Cu                     , MD.FSP, "smashedOre",  2);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Zn                     , MD.FSP, "smashedOre",  3);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Sn                     , MD.FSP, "smashedOre",  4);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Ni                     , MD.FSP, "smashedOre",  5);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Ag                     , MD.FSP, "smashedOre",  6);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Pb                     , MD.FSP, "smashedOre",  7);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Al2O3                  , MD.FSP, "smashedOre",  8);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Ge                     , MD.FSP, "smashedOre",  9);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Co                     , MD.FSP, "smashedOre", 10);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Ardite                 , MD.FSP, "smashedOre", 11);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.OREMATS.Cinnabar       , MD.FSP, "smashedOre", 12);
		OreDictManager.INSTANCE.setTarget(OP.crushedTiny    , MT.Fe2O3                  , MD.FSP, "smashedOre", 13);
		OreDictManager.INSTANCE.setTarget(OP.crushedTiny    , MT.Au                     , MD.FSP, "smashedOre", 14);
		OreDictManager.INSTANCE.setTarget(OP.crushedTiny    , MT.Cu                     , MD.FSP, "smashedOre", 15);
		OreDictManager.INSTANCE.setTarget(OP.crushedTiny    , MT.Zn                     , MD.FSP, "smashedOre", 16);
		OreDictManager.INSTANCE.setTarget(OP.crushedTiny    , MT.Sn                     , MD.FSP, "smashedOre", 17);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.GildedIron             , MD.FSP, "steamcraftIngot",  3);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Ceramic                , MD.FSP, "blankMold", 0);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Cu                     , MD.FSP, "steamcraftPlate", 0);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Zn                     , MD.FSP, "steamcraftPlate", 1);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Fe                     , MD.FSP, "steamcraftPlate", 2);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Au                     , MD.FSP, "steamcraftPlate", 3);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Brass                  , MD.FSP, "steamcraftPlate", 4);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Thaumium               , MD.FSP, "steamcraftPlate", 5);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Terrasteel             , MD.FSP, "steamcraftPlate", 6);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.ElvenElementium        , MD.FSP, "steamcraftPlate", 7);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.FierySteel             , MD.FSP, "steamcraftPlate", 8);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Pb                     , MD.FSP, "steamcraftPlate", 9);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.VibrantAlloy           , MD.FSP, "steamcraftPlate",10);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.Enderium               , MD.FSP, "steamcraftPlate",11);
		OreDictManager.INSTANCE.setTarget(OP.plateSteamcraft, MT.GildedIron             , MD.FSP, "steamcraftPlate",12);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Al2O3                  , MD.SC2, "BlockSteamcraftOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.SC2, "BlockSteamcraftOre", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , MD.SC2, "BlockSteamcraftOre", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Zn                     , MD.SC2, "BlockSteamcraftOre", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , MD.SC2, "BlockSteamcraftOre", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.S                      , MD.SC2, "BlockSteamcraftOre", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.PO4                    , MD.SC2, "BlockSteamcraftOre", 6);
		OreDictManager.INSTANCE.setTarget(OP.spring         , MT.Fe                     , MD.SC2, "ItemIronParts" , 2);
		OreDictManager.INSTANCE.setTarget(OP.bolt           , MT.Fe                     , MD.SC2, "ItemIronParts" , 5);
		OreDictManager.INSTANCE.setTarget(OP.round          , MT.Fe                     , MD.SC2, "ItemIronParts" , 7);
		OreDictManager.INSTANCE.setTarget(OP.screw          , MT.Fe                     , MD.SC2, "ItemIronParts" , 8);
		OreDictManager.INSTANCE.setTarget(OP.spring         , MT.Steel                  , MD.SC2, "ItemSteelParts", 2);
		OreDictManager.INSTANCE.setTarget(OP.bolt           , MT.Steel                  , MD.SC2, "ItemSteelParts", 5);
		OreDictManager.INSTANCE.setTarget(OP.round          , MT.Steel                  , MD.SC2, "ItemSteelParts", 7);
		OreDictManager.INSTANCE.setTarget(OP.screw          , MT.Steel                  , MD.SC2, "ItemSteelParts", 8);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.IronMagnetic           , MD.SC2, "ItemMachinePart", 3);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.IronCast               , MD.SC2, "ItemMetalNugget", 7);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.IronCast               , MD.SC2, "ItemIngot", 7);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.IronCast               , MD.SC2, "BlockMetal", 7);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.IronCast               , MD.SC2, "ItemMetalSheet", 7);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.IronCast               , MD.SC2, "ItemMachinePart", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.PO4                    , MD.SC2, "ItemResource", 1);
		OreDictManager.INSTANCE.setTarget(OP.bottle         , MT.H2SO4                  , MD.SC2, "ItemResource", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.U_238                  , MD.SC2, "ItemResource", 3);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.U_238                  , MD.SC2, "ItemResource", 4);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Al2O3                  , MD.SC2, "ItemSteamcraftCluster", 0);
		OreDictManager.INSTANCE.setTarget(OP.cluster        , MT.Zn                     , MD.SC2, "ItemSteamcraftCluster", 1);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.PetrifiedWood          , MD.SC2, "ItemPetrifiedStick", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Willow           , MD.SC2, "ItemWillowStick", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Redwood          , MD.SC2, "ItemRedwoodStick", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.WOODS.Mangrove         , MD.SC2, "ItemMangroveStick", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreLimestone   , MT.Phosphorus             , MD.MIN, "phosphorous_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDense       , MT.Gypsum                 , MD.MIN, "gypsum", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDense       , MT.S                      , MD.MIN, "sulfur_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDense       , MT.Niter                  , MD.MIN, "nitrate_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.SkyStone        , MD.AE, "tile.BlockSkyStone", 1);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.STONES.SkyStone        , MD.AE, "item.ItemMultiMaterial", 45);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.ChargedCertusQuartz    , MD.AE, "item.ItemMultiMaterial", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.ChargedCertusQuartz    , MD.AE, "tile.OreQuartzCharged" , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.CertusQuartz           , MD.AE, "tile.OreQuartz"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Draconium              , MD.DE, "draconiumOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.crushed        , MT.Draconium              , MD.DE, "draconiumBlend", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Draconium              , MD.DE, "draconiumDust", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Draconium              , MD.DE, "nugget", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Draconium              , MD.DE, "draconiumIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Draconium              , MD.DE, "draconium", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.DraconiumAwakened      , MD.DE, "nugget", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DraconiumAwakened      , MD.DE, "draconicIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.DraconiumAwakened      , MD.DE, "draconicBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.CrystalMatrix          , MD.AV, "Resource", 1);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.CosmicNeutronium       , MD.AV, "Resource", 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.CosmicNeutronium       , MD.AV, "Resource", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Infinity               , MD.AV, "Resource", 6);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.CosmicNeutronium       , MD.AV, "Resource_Block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Infinity               , MD.AV, "Resource_Block", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.CrystalMatrix          , MD.AV, "Crystal_Matrix", 0);
		OreDictManager.INSTANCE.setTarget(OP.bottle         , MT.H2SO4                  , MD.FZ, "acid"           , 0);
		OreDictManager.INSTANCE.setTarget(OP.bottle         , MT.AquaRegia              , MD.FZ, "acid"           , 1);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Netherrack             , MD.FZ, "nether_powder"  , 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.DarkIron               , MD.FZ, "dark_iron_ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.gemFlawed      , MT.Diamond                , MD.FZ, "diamond_shard"  , 0);
		OreDictManager.INSTANCE.setTarget(OP.gemChipped     , MT.EnderPearl             , MD.RT, "ingredient", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.SpectreIron            , MD.RT, "ingredient", 4);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ectoplasm              , MD.RT, "ingredient", 3);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ectoplasm              , MD.HEE, "endoplasm", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Endium                 , MD.HEE, "endium_ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Endium                 , MD.HEE, "endium_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.Endium                 , MD.HEE, "endium_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.OREMATS.Sphalerite     , MD.HEE, "sphalerite", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.OREMATS.Sphalerite     , MD.HEE, "sphalerite", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.EnderiumBase           , MD.EIO, "itemPowderIngot"         , 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ElectricalSteel        , MD.EIO, "itemAlloy"               , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.EnergeticAlloy         , MD.EIO, "itemAlloy"               , 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.VibrantAlloy           , MD.EIO, "itemAlloy"               , 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.RedstoneAlloy          , MD.EIO, "itemAlloy"               , 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ConductiveIron         , MD.EIO, "itemAlloy"               , 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.PulsatingIron          , MD.EIO, "itemAlloy"               , 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ObsidianSteel          , MD.EIO, "itemAlloy"               , 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Soularium              , MD.EIO, "itemAlloy"               , 7);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.EndSteel               , MD.EIO, "itemAlloy"               , 8);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.PulsatingIron          , MD.EIO, "itemMaterial"            , 3);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.VibrantAlloy           , MD.EIO, "itemMaterial"            , 4);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.EndSteel               , MD.EIO, "itemMaterial"            ,11);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.ElectricalSteel        , MD.EIO, "blockIngotStorage"       , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.EnergeticAlloy         , MD.EIO, "blockIngotStorage"       , 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.VibrantAlloy           , MD.EIO, "blockIngotStorage"       , 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.RedstoneAlloy          , MD.EIO, "blockIngotStorage"       , 3);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.ConductiveIron         , MD.EIO, "blockIngotStorage"       , 4);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.PulsatingIron          , MD.EIO, "blockIngotStorage"       , 5);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.ObsidianSteel          , MD.EIO, "blockIngotStorage"       , 6);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Soularium              , MD.EIO, "blockIngotStorage"       , 7);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.EndSteel               , MD.EIO, "blockIngotStorage"       , 8);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.CrudeSteel             , MD.EIO, "itemAlloyEndergy"        , 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.CrystallineAlloy       , MD.EIO, "itemAlloyEndergy"        , 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.MelodicAlloy           , MD.EIO, "itemAlloyEndergy"        , 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.StellarAlloy           , MD.EIO, "itemAlloyEndergy"        , 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.CrystallinePinkSlime   , MD.EIO, "itemAlloyEndergy"        , 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.EnergeticSilver        , MD.EIO, "itemAlloyEndergy"        , 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.VividAlloy             , MD.EIO, "itemAlloyEndergy"        , 6);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.CrudeSteel             , MD.EIO, "blockIngotStorageEndergy", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.CrystallineAlloy       , MD.EIO, "blockIngotStorageEndergy", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.MelodicAlloy           , MD.EIO, "blockIngotStorageEndergy", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.StellarAlloy           , MD.EIO, "blockIngotStorageEndergy", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.CrystallinePinkSlime   , MD.EIO, "blockIngotStorageEndergy", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.EnergeticSilver        , MD.EIO, "blockIngotStorageEndergy", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.VividAlloy             , MD.EIO, "blockIngotStorageEndergy", 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.ObsidianSteel          , MD.TG, "TechgunsAmmo", 40);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.ObsidianSteel          , MD.TG, "TechgunsAmmo", 65);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.C                      , MD.TG, "TechgunsAmmo", 62);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Plastic                , MD.TG, "TechgunsAmmo", 72);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Plastic                , MD.TG, "TechgunsAmmo", 71);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.U_235                  , MD.TG, "TechgunsAmmo",102);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Bark                   , MD.BINNIE_TREE, "misc", 2);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.Ash                    , MD.BINNIE_BOTANY, "misc", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.Wood                   , MD.BINNIE_BOTANY, "misc", 1);
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.S                      , MD.BINNIE_BOTANY, "misc", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.NaCl                   , MD.Salt, "saltLake", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.NaCl                   , MD.Salt, "saltOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.NaCl                   , MD.Salt, "saltDeepslateOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreLimestone   , MT.NaCl                   , MD.HaC, "salt", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.NaCl                   , MD.HaC, "spamcompressedsaltBlockalt", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.NaCl                   , MD.HaC, "saltItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.NaCl                   , MD.Salt, "salt", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.NaCl                   , MD.Salt, "saltPinch", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.NaCl                   , MD.Salt, "saltBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Sugar                  , MD.Salt, "sugarPinch", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.NaHCO3                 , MD.Salt, "soda", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Milk                   , MD.Salt, "powderedMilk", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Nutmeg                 , MD.HaC, "groundnutmegItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Cinnamon               , MD.HaC, "groundcinnamonItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Cocoa                  , MD.HaC, "cocoapowderItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Curry                  , MD.HaC, "currypowderItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxPlant               , MD.HaC, "waxItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxBee                 , MD.HaC, "beeswaxItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Aquamarine             , MD.CW2, "gem_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Aquamarine             , MD.CW2, "gem_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Aquamarine             , MD.CW2, "gem", 0);
		OreDictManager.INSTANCE.setTarget(OP.gemOre         , MT.Goshenite              , MD.VOLTZ, "gems",   10);
		OreDictManager.INSTANCE.setTarget(OP.gemRaw         , MT.Goshenite              , MD.VOLTZ, "gems", 1010);
		OreDictManager.INSTANCE.setTarget(OP.gemUncut       , MT.Goshenite              , MD.VOLTZ, "gems", 2010);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Goshenite              , MD.VOLTZ, "gems", 3010);
		OreDictManager.INSTANCE.setTarget(OP.gemPolished    , MT.Goshenite              , MD.VOLTZ, "gems", 4010);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.TungstenCarbide        , MD.MgC, "item.ingotCarbide", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Yellorite              , MD.BR, "YelloriteOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Yellorium              , MD.BR, "BRMetalBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Cyanite                , MD.BR, "BRMetalBlock", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Graphite               , MD.BR, "BRMetalBlock", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Blutonium              , MD.BR, "BRMetalBlock", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ludicrite              , MD.BR, "BRMetalBlock", 4);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Yellorium              , MD.BR, "BRIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Cyanite                , MD.BR, "BRIngot", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Graphite               , MD.BR, "BRIngot", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Blutonium              , MD.BR, "BRIngot", 3);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Yellorium              , MD.BR, "BRIngot", 4);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Cyanite                , MD.BR, "BRIngot", 5);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Graphite               , MD.BR, "BRIngot", 6);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Blutonium              , MD.BR, "BRIngot", 7);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ludicrite              , MD.BR, "BRIngot", 8);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ludicrite              , MD.BR, "BRIngot", 9);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , MD.ElC, "electricraft_block_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ag                     , MD.ElC, "electricraft_block_ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ni                     , MD.ElC, "electricraft_block_ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Al                     , MD.ElC, "electricraft_block_ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pt                     , MD.ElC, "electricraft_block_ore", 5);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.HydrogenFluoride       , MD.ReC, "reactorcraft_item_raw", 0);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.UraniumEnriched        , MD.ReC, "reactorcraft_item_raw", 1);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.UraniumDepleted        , MD.ReC, "reactorcraft_item_raw", 2);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.AmmoniumChloride       , MD.ReC, "reactorcraft_item_raw", 3); // registered as dustAmmonium
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Quicklime              , MD.ReC, "reactorcraft_item_raw", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CaCO3                  , MD.ReC, "reactorcraft_item_raw", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.OREMATS.Magnetite      , MD.ReC, "reactorcraft_item_raw", 6);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Th                     , MD.ReC, "reactorcraft_item_raw", 7);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Emerald                , MD.ReC, "reactorcraft_item_raw", 8);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Cd_In_Ag_Alloy         , MD.ReC, "reactorcraft_item_crafting", 3);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.SteelMagnetic          , MD.ReC, "reactorcraft_item_crafting", 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.SteelMagnetic          , MD.ReC, "reactorcraft_item_crafting",10);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.U_238                  , MD.ReC, "reactorcraft_item_crafting",14);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.TungstenCarbide        , MD.ReC, "reactorcraft_item_crafting",17);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.CaCO3                  , MD.ReC, "reactorcraft_block_mats", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Pitchblende    , MD.ReC, "reactorcraft_block_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cd                     , MD.ReC, "reactorcraft_block_ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.In                     , MD.ReC, "reactorcraft_block_ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ag                     , MD.ReC, "reactorcraft_block_ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.OREMATS.Pitchblende    , MD.ReC, "reactorcraft_block_ore", 5);
//      OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.AmmoniumChloride       , MD.ReC, "reactorcraft_block_ore", 6); // registered as oreAmmonium
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.CaCO3                  , MD.ReC, "reactorcraft_block_ore", 7);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Magnetite      , MD.ReC, "reactorcraft_block_ore", 8);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Th                     , MD.ReC, "reactorcraft_block_ore", 9);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteBlue           , MD.ReC, "reactorcraft_block_fluoriteore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoritePink           , MD.ReC, "reactorcraft_block_fluoriteore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteOrange         , MD.ReC, "reactorcraft_block_fluoriteore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteMagenta        , MD.ReC, "reactorcraft_block_fluoriteore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteGreen          , MD.ReC, "reactorcraft_block_fluoriteore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteRed            , MD.ReC, "reactorcraft_block_fluoriteore", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteWhite          , MD.ReC, "reactorcraft_block_fluoriteore", 6);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.FluoriteYellow         , MD.ReC, "reactorcraft_block_fluoriteore", 7);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteBlue           , MD.ReC, "reactorcraft_block_fluorite", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoritePink           , MD.ReC, "reactorcraft_block_fluorite", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteOrange         , MD.ReC, "reactorcraft_block_fluorite", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteMagenta        , MD.ReC, "reactorcraft_block_fluorite", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteGreen          , MD.ReC, "reactorcraft_block_fluorite", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteRed            , MD.ReC, "reactorcraft_block_fluorite", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteWhite          , MD.ReC, "reactorcraft_block_fluorite", 6);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.FluoriteYellow         , MD.ReC, "reactorcraft_block_fluorite", 7);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteBlue           , MD.ReC, "reactorcraft_item_fluorite", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoritePink           , MD.ReC, "reactorcraft_item_fluorite", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteOrange         , MD.ReC, "reactorcraft_item_fluorite", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteMagenta        , MD.ReC, "reactorcraft_item_fluorite", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteGreen          , MD.ReC, "reactorcraft_item_fluorite", 4);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteRed            , MD.ReC, "reactorcraft_item_fluorite", 5);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteWhite          , MD.ReC, "reactorcraft_item_fluorite", 6);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.FluoriteYellow         , MD.ReC, "reactorcraft_item_fluorite", 7);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CaF2                   , MD.RoC, "rotarycraft_item_modingots", 52);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Netherrack             , MD.RoC, "rotarycraft_item_powders", 0);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Tar                    , MD.RoC, "rotarycraft_item_powders", 1);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.SludgeOrganic          , MD.RoC, "rotarycraft_item_powders", 2); smelts into ethanol
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.Wood                   , MD.RoC, "rotarycraft_item_powders", 3);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Bedrock                , MD.RoC, "rotarycraft_item_powders", 4);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.NaCl                   , MD.RoC, "rotarycraft_item_powders", 5);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.AmmoniumNitrate        , MD.RoC, "rotarycraft_item_powders", 6); Salt + Coal + Gunpowder + Redstone = 4 (180, 150, 200)
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.AgI                    , MD.RoC, "rotarycraft_item_powders", 7);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Al                     , MD.RoC, "rotarycraft_item_powders", 8); No Target needed
		OreDictManager.INSTANCE.setTarget(OP.dustSmall      , MT.Wheat                  , MD.RoC, "rotarycraft_item_powders", 9);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Coal                   , MD.RoC, "rotarycraft_item_powders",10);
//      OreDictManager.INSTANCE.setTarget(OP.dust           , MT.DryIce                 , MD.RoC, "rotarycraft_item_powders",11);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.InductiveAlloy         , MD.RoC, "rotarycraft_item_powders",12);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Si                     , MD.RoC, "rotarycraft_item_powders",14);
//      OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Ethanol                , MD.RoC, "rotarycraft_item_ethanol", 0); burns for 400 furnace time
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Anthracite             , MD.RoC, "rotarycraft_item_compacts", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Prismane               , MD.RoC, "rotarycraft_item_compacts", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Lonsdaleite            , MD.RoC, "rotarycraft_item_compacts", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Bedrock_HSLA_Alloy     , MD.RoC, "rotarycraft_item_compacts", 3);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.TungstenSintered       , MD.RoC, "rotarycraft_item_compacts", 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.InductiveAlloy         , MD.RoC, "rotarycraft_item_compacts", 6);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.CoalCoke               , MD.RoC, "rotarycraft_item_compacts", 8);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.SpringSteel            , MD.RoC, "rotarycraft_item_compacts", 9);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Si                     , MD.RoC, "rotarycraft_item_compacts",10);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.AluminiumAlloy         , MD.RoC, "rotarycraft_item_compacts",11);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.TungstenAlloy          , MD.RoC, "rotarycraft_item_compacts",12);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.HSLA                   , MD.RoC, "rotarycraft_item_shaftcraft", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.HSLA                   , MD.RoC, "rotarycraft_item_shaftcraft", 1);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.HSLA                   , MD.RoC, "rotarycraft_item_shaftcraft", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.HSLA                   , MD.RoC, "rotarycraft_block_deco", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Anthracite             , MD.RoC, "rotarycraft_block_deco", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Lonsdaleite            , MD.RoC, "rotarycraft_block_deco", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Bedrock_HSLA_Alloy     , MD.RoC, "rotarycraft_block_deco", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.CoalCoke               , MD.RoC, "rotarycraft_block_deco", 5);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Stone                  , MD.RoC, "rotarycraft_item_borecraft", 13);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Diamond                , MD.RoC, "rotarycraft_item_borecraft", 14);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Livingwood             , MD.RoC, "rotarycraft_item_modinterface", 17);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.STONES.Livingrock      , MD.RoC, "rotarycraft_item_modinterface", 18);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.HSLA                   , MD.RoC, "rotarycraft_item_gearcraft",  0);
//      OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Wood                   , MD.RoC, "rotarycraft_item_gearcraft", 16); // This one does not really exist!
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Stone                  , MD.RoC, "rotarycraft_item_gearcraft", 32);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Diamond                , MD.RoC, "rotarycraft_item_gearcraft", 48); // 64 would be Bedrock
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Livingwood             , MD.RoC, "rotarycraft_item_gearcraft", 80);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.STONES.Livingrock      , MD.RoC, "rotarycraft_item_gearcraft", 96);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.TungstenAlloy          , MD.RoC, "rotarycraft_item_gearcraft",112);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Corn                   , MD.PMP, "foodCornFlour", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Rice                   , MD.PMP, "foodCookedRice", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.PhosphorusBlue         , MD.FR, "phosphor", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Wood                   , MD.FR, "woodPulp", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxBee                 , MD.FR, "beeswax", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.WaxRefractory          , MD.FR, "refractoryWax", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Peat                   , MD.FR, "peat", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingotDouble    , MT.PeatBituminous         , MD.FR, "bituminousPeat", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Fe                     , MD.Mek, "DirtyDust", 0);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Au                     , MD.Mek, "DirtyDust", 1);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Ge                     , MD.Mek, "DirtyDust", 2);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Cu                     , MD.Mek, "DirtyDust", 3);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Sn                     , MD.Mek, "DirtyDust", 4);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Ag                     , MD.Mek, "DirtyDust", 5);
		OreDictManager.INSTANCE.setTarget(OP.dustImpure     , MT.Pb                     , MD.Mek, "DirtyDust", 6);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Graphene               , MD.Mek, "CompressedCarbon", 0);
		OreDictManager.INSTANCE.setTarget(OP.plateGem       , MT.DiamondIndustrial      , MD.Mek, "CompressedDiamond", 0);
		OreDictManager.INSTANCE.setTarget(OP.plateGem       , MT.Redstone               , MD.Mek, "CompressedRedstone", 0);
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.RefinedObsidian        , MD.Mek, "CompressedObsidian", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.RefinedObsidian        , MD.Mek, "OtherDust", 5);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.RefinedObsidian        , MD.Mek, "Ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.RefinedObsidian        , MD.Mek, "BasicBlock", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.RefinedGlowstone       , MD.Mek, "Ingot", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.RefinedGlowstone       , MD.Mek, "BasicBlock", 4);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Ge                     , MD.Mek, "Dust", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Ge                     , MD.Mek, "Ingot", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Ge                     , MD.Mek, "BasicBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ge                     , MD.Mek, "OreBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.Mek, "OreBlock", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , MD.Mek, "OreBlock", 2);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.WaxBee                 , MD.GrC_Bees, "grcbees.BeesWax", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Eudialyte              , MD.TROPIC, "tile.oreEudialyte", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Zircon                 , MD.TROPIC, "tile.oreZircon", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Azurite                , MD.TROPIC, "tile.oreAzurite", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Eudialyte              , MD.TROPIC, "tile.blockOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Zircon                 , MD.TROPIC, "tile.blockOre", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Azurite                , MD.TROPIC, "tile.blockOre", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Zr                     , MD.TROPIC, "tile.blockOre", 3);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Eudialyte              , MD.TROPIC, "ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Zircon                 , MD.TROPIC, "ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Azurite                , MD.TROPIC, "ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Zr                     , MD.TROPIC, "ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Marshmallow            , MD.CANDY, "I21", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Sugar                  , MD.CANDY, "I69", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Honey                  , MD.CANDY, "I23", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Honey                  , MD.CANDY, "B59", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Honey                  , MD.CANDY, "B57", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.PEZ                    , MD.CANDY, "I49", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.PEZ                    , MD.CANDY, "I48", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.PEZ                    , MD.CANDY, "B62", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.PEZ                    , MD.CANDY, "B61", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Licorice               , MD.CANDY, "I0" , 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Licorice               , MD.CANDY, "B12", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Licorice               , MD.CANDY, "B14", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Nougat                 , MD.CANDY, "I84", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Nougat                 , MD.CANDY, "B94", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Nougat                 , MD.CANDY, "B91", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.TE_FOUNDATION, "Ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , MD.TE_FOUNDATION, "Ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ag                     , MD.TE_FOUNDATION, "Ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pb                     , MD.TE_FOUNDATION, "Ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Ni                     , MD.TE_FOUNDATION, "Ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pt                     , MD.TE_FOUNDATION, "Ore", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Mithril                , MD.TE_FOUNDATION, "Ore", 6);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.OREMATS.Cinnabar       , MD.TE_FOUNDATION, "material",   20);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Pyrotheum              , MD.TE_FOUNDATION, "material",  512);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Cryotheum              , MD.TE_FOUNDATION, "material",  513);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Aerotheum              , MD.TE_FOUNDATION, "material",  514);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Petrotheum             , MD.TE_FOUNDATION, "material",  515);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Blizz                  , MD.TE_FOUNDATION, "material", 1024);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Blizz                  , MD.TE_FOUNDATION, "material", 1025);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Blitz                  , MD.TE_FOUNDATION, "material", 1026);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Blitz                  , MD.TE_FOUNDATION, "material", 1027);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Basalz                 , MD.TE_FOUNDATION, "material", 1028);
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Basalz                 , MD.TE_FOUNDATION, "material", 1029);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Lignite                , MD.UB, "ligniteCoal", 0);
		OreDictManager.INSTANCE.setTarget(OP.cell           , MT.Creosote               , MD.RC, "fluid.creosote.cell", 1);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooAsperPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooFargesiaRobustaPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooGiantTimberPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooGoldenPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooMosoPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooShortTassledPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooTimorBlackPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooTropicalBluePole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.PMP, "bambooWetForestPole", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.GrC_Bamboo, "grc.bamboo", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.BoP, "bamboo", 0);
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Bamboo                 , MD.TROPIC, "bambooStick", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.ELN, "Eln.Ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pb                     , MD.ELN, "Eln.Ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.W                      , MD.ELN, "Eln.Ore", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Cinnabar       , MD.ELN, "Eln.Ore", 6);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.W                      , MD.ELN, "Eln.sharedItem",  517);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Li2Fe2O4               , MD.ELN, "Eln.sharedItem",  518);
		OreDictManager.INSTANCE.setTarget(OP.chunkGt        , MT.Hg                     , MD.ELN, "Eln.sharedItem",  520);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Lapis                  , MD.ELN, "Eln.sharedItem",  579);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Diamond                , MD.ELN, "Eln.sharedItem",  580);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Rubber                 , MD.ELN, "Eln.sharedItem", 4097);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondIndustrial      , MD.ELN, "Eln.sharedItem", 4420);
		OreDictManager.INSTANCE.setTarget(OP.plateQuadruple , MT.Coal                   , MD.ELN, "Eln.sharedItem", 7692);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Si                     , MD.ELN, "Eln.sharedItem", 7697);
		OreDictManager.INSTANCE.setTarget(OP.plateDouble    , MT.Paper                  , MD.BTRS, "cardboardSheet", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Netherite              , MD.NePl, "NetheriteIngot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Netherite              , MD.NePl, "NetheriteBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.AncientDebris          , MD.NePl, "NetheriteScrap", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.AncientDebris          , MD.NePl, "AncientDebris", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Au                     , MD.NePl, "GoldOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBlackstone  , MT.Au                     , MD.NePl, "GildedBlackstone", 0);
//      OreDictManager.INSTANCE.setTarget(OP.oreBlackstone  , MT.Au                     , MD.NeLi, "Blackstone", 5); // DONT! This thing is crafted with 4 Nuggets and a Blackstone!
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Au                     , MD.NeLi, "NetherGoldOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Fe2O3                  , MD.NeLi, "NetherIronOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreBlackstone  , MT.VoidQuartz             , MD.NeLi, "VoidQuartzOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.VoidQuartz             , MD.NeLi, "VoidQuartzOre", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Efrine                 , MD.NeLi, "EfrineOre", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Efrine                 , MD.NeLi, "Nugget", 1);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Efrine                 , MD.NeLi, "Ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Efrine                 , MD.NeLi, "EfrineBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Gloomstone             , MD.NeLi, "GloomstoneDust", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.VoidQuartz             , MD.NeLi, "VoidQuartzItem", 0);
		OreDictManager.INSTANCE.setTarget(OP.chain          , MT.Fe                     , MD.NeLi, "Chain", 0);
		OreDictManager.INSTANCE.setTarget(OP.chain          , MT.Au                     , MD.NeLi, "ChainGold", 0);
		OreDictManager.INSTANCE.setTarget(OP.chain          , MT.Efrine                 , MD.NeLi, "ChainEfrine", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Bone                   , MD.NeLi, "BoneBlock", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Bone                   , MD.NeLi, "BoneBlock", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreEndstone    , MT.Sugilite               , MD.EnLi, "OreSugilite", 0);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Sugilite               , MD.EnLi, "material", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Sugilite               , MD.EnLi, "BlockMaterial", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.EndSandWhite           , MD.EnLi, "EndSand", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.EndSandBlack           , MD.EnLi, "EndSand", 1);
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Amethyst               , MD.EtFu, "amethyst_shard", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Cu                     , MD.EtFu, "raw_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Fe                     , MD.EtFu, "raw_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Au                     , MD.EtFu, "raw_ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.OREMATS.Bauxite        , MD.EtFu, "modded_raw_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Sn                     , MD.EtFu, "modded_raw_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Ag                     , MD.EtFu, "modded_raw_ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Pb                     , MD.EtFu, "modded_raw_ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Ni                     , MD.EtFu, "modded_raw_ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Pt                     , MD.EtFu, "modded_raw_ore", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Mithril                , MD.EtFu, "modded_raw_ore", 6);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.OREMATS.Uraninite      , MD.EtFu, "modded_raw_ore", 7);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Th                     , MD.EtFu, "modded_raw_ore", 8);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.OREMATS.Scheelite      , MD.EtFu, "modded_raw_ore", 9);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.TiO2                   , MD.EtFu, "modded_raw_ore",10);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.Zn                     , MD.EtFu, "modded_raw_ore",11);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.MgCO3                  , MD.EtFu, "modded_raw_ore",12);
		OreDictManager.INSTANCE.setTarget(OP.oreRaw         , MT.OREMATS.Borax          , MD.EtFu, "modded_raw_ore",13);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Cu                     , MD.EtFu, "raw_ore_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Fe                     , MD.EtFu, "raw_ore_block", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Au                     , MD.EtFu, "raw_ore_block", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.OREMATS.Bauxite        , MD.EtFu, "modded_raw_ore_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Sn                     , MD.EtFu, "modded_raw_ore_block", 1);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Ag                     , MD.EtFu, "modded_raw_ore_block", 2);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Pb                     , MD.EtFu, "modded_raw_ore_block", 3);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Ni                     , MD.EtFu, "modded_raw_ore_block", 4);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Pt                     , MD.EtFu, "modded_raw_ore_block", 5);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Mithril                , MD.EtFu, "modded_raw_ore_block", 6);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.OREMATS.Uraninite      , MD.EtFu, "modded_raw_ore_block", 7);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Th                     , MD.EtFu, "modded_raw_ore_block", 8);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.OREMATS.Scheelite      , MD.EtFu, "modded_raw_ore_block", 9);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.TiO2                   , MD.EtFu, "modded_raw_ore_block",10);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.Zn                     , MD.EtFu, "modded_raw_ore_block",11);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.MgCO3                  , MD.EtFu, "modded_raw_ore_block",12);
		OreDictManager.INSTANCE.setTarget(OP.blockRaw       , MT.OREMATS.Borax          , MD.EtFu, "modded_raw_ore_block",13);
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Bone                   , MD.EtFu, "bone", 0);
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Fe                     , MD.EtFu, "nugget_iron", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Cu                     , MD.EtFu, "copper_ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Cu                     , MD.EtFu, "copper_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Netherite              , MD.EtFu, "netherite_ingot", 0);
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Netherite              , MD.EtFu, "netherite_block", 0);
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.AncientDebris          , MD.EtFu, "netherite_scrap", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.AncientDebris          , MD.EtFu, "ancient_debris", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.Au                     , MD.EtFu, "nether_gold_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , MD.EtFu, "copper_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Coal                   , MD.EtFu, "deepslate_coal_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Fe                     , MD.EtFu, "deepslate_iron_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Au                     , MD.EtFu, "deepslate_gold_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Cu                     , MD.EtFu, "deepslate_copper_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Diamond                , MD.EtFu, "deepslate_diamond_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Lapis                  , MD.EtFu, "deepslate_lapis_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Lapis                  , MD.EtFu, "deepslate_lapis_ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Redstone               , MD.EtFu, "deepslate_redstone_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Emerald                , MD.EtFu, "deepslate_emerald_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Bauxite        , MD.EtFu, "modded_deepslate_ore", 0);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Sn                     , MD.EtFu, "modded_deepslate_ore", 1);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Ag                     , MD.EtFu, "modded_deepslate_ore", 2);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Pb                     , MD.EtFu, "modded_deepslate_ore", 3);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Ni                     , MD.EtFu, "modded_deepslate_ore", 4);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Pt                     , MD.EtFu, "modded_deepslate_ore", 5);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Mithril                , MD.EtFu, "modded_deepslate_ore", 6);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Uraninite      , MD.EtFu, "modded_deepslate_ore", 7);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Th                     , MD.EtFu, "modded_deepslate_ore", 8);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Scheelite      , MD.EtFu, "modded_deepslate_ore", 9);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.TiO2                   , MD.EtFu, "modded_deepslate_ore",10);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Zn                     , MD.EtFu, "modded_deepslate_ore",11);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.MgCO3                  , MD.EtFu, "modded_deepslate_ore",12);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Borax          , MD.EtFu, "modded_deepslate_ore",13);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.CertusQuartz           , MD.EtFu, "deepslate_certus_quartz_ore", 0, MD.AE);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.ChargedCertusQuartz    , MD.EtFu, "deepslate_certus_quartz_ore", 1, MD.AE);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Ruby                   , MD.EtFu, "deepslate_projred_ore", 0, MD.PR);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.BlueSapphire           , MD.EtFu, "deepslate_projred_ore", 1, MD.PR);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Peridot                , MD.EtFu, "deepslate_projred_ore", 2, MD.PR);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Nikolite               , MD.EtFu, "deepslate_projred_ore", 3, MD.PR);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Nikolite               , MD.EtFu, "deepslate_bluepower_ore", 0, MD.BP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Ruby                   , MD.EtFu, "deepslate_bluepower_ore", 1, MD.BP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.BlueSapphire           , MD.EtFu, "deepslate_bluepower_ore", 2, MD.BP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Amethyst               , MD.EtFu, "deepslate_bluepower_ore", 3, MD.BP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Ruby                   , MD.EtFu, "deepslate_bop_ore", 0, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Peridot                , MD.EtFu, "deepslate_bop_ore", 1, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Topaz                  , MD.EtFu, "deepslate_bop_ore", 2, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Tanzanite              , MD.EtFu, "deepslate_bop_ore", 3, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Malachite      , MD.EtFu, "deepslate_bop_ore", 4, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.BlueSapphire           , MD.EtFu, "deepslate_bop_ore", 5, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Amber                  , MD.EtFu, "deepslate_bop_ore", 6, MD.BoP);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Vinteum                , MD.EtFu, "deepslate_am2_ore", 0, MD.ARS);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Chimerite              , MD.EtFu, "deepslate_am2_ore", 1, MD.ARS);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.BlueTopaz              , MD.EtFu, "deepslate_am2_ore", 2, MD.ARS);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.OREMATS.Cinnabar       , MD.EtFu, "deepslate_thaumcraft_ore", 0, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedAir             , MD.EtFu, "deepslate_thaumcraft_ore", 1, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedFire            , MD.EtFu, "deepslate_thaumcraft_ore", 2, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedWater           , MD.EtFu, "deepslate_thaumcraft_ore", 3, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedEarth           , MD.EtFu, "deepslate_thaumcraft_ore", 4, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedOrder           , MD.EtFu, "deepslate_thaumcraft_ore", 5, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.InfusedEntropy         , MD.EtFu, "deepslate_thaumcraft_ore", 6, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Amber                  , MD.EtFu, "deepslate_thaumcraft_ore", 7, MD.TC);
		OreDictManager.INSTANCE.setTarget(OP.oreDeepslate   , MT.Draconium              , MD.EtFu, "deepslate_draconium_ore", 0, MD.DE);
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.STONES.Deepslate       , MD.EtFu, "polished_deepslate", 0);
		OreDictManager.INSTANCE.setTarget(OP.bottle         , MT.Empty                  , ST.make(Items.glass_bottle, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.bottle         , MT.H2O                    , ST.make(Items.potionitem, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Coal                   , ST.make(Blocks.coal_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Fe                     , ST.make(Blocks.iron_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Lapis                  , ST.make(Blocks.lapis_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Lapis                  , ST.make(Blocks.lapis_ore, 1, 4));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Redstone               , ST.make(Blocks.redstone_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Au                     , ST.make(Blocks.gold_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Diamond                , ST.make(Blocks.diamond_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Emerald                , ST.make(Blocks.emerald_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreNetherrack  , MT.NetherQuartz           , ST.make(Blocks.quartz_ore, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Lapis                  , ST.make(Items.dye, 1, 4));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.EnderEye               , ST.make(Items.ender_eye, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.EnderPearl             , ST.make(Items.ender_pearl, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Diamond                , ST.make(Items.diamond, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Emerald                , ST.make(Items.emerald, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Coal                   , ST.make(Items.coal, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.Charcoal               , ST.make(Items.coal, 1, 1));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.NetherQuartz           , ST.make(Items.quartz, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.NetherStar             , ST.make(Items.nether_star, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.nugget         , MT.Au                     , ST.make(Items.gold_nugget, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Au                     , ST.make(Items.gold_ingot, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Fe                     , ST.make(Items.iron_ingot, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.Brick                  , ST.make(Items.brick, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.ingot          , MT.NetherBrick            , ST.make(Items.netherbrick, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Paper                  , ST.make(Items.paper, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.plate          , MT.Glass                  , ST.make(Blocks.glass_pane, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.plateGem       , MT.Glass                  , ST.make(Blocks.glass_pane, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Sugar                  , ST.make(Items.sugar, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Bone                   , ST.make(Items.dye, 1, 15));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Redstone               , ST.make(Items.redstone, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Gunpowder              , ST.make(Items.gunpowder, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Glowstone              , ST.make(Items.glowstone_dust, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dustTiny       , MT.Blaze                  , ST.make(Items.blaze_powder, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Blaze                  , ST.make(Items.blaze_rod, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Wood                   , ST.make(Items.stick, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Stone                  , ST.make(Blocks.gravel, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.SoulSand               , ST.make(Blocks.soul_sand, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Sand                   , ST.make(Blocks.sand, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.RedSand                , ST.make(Blocks.sand, 1, 1));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Sand                   , ST.make(Blocks.sandstone, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Glass                  , ST.make(Blocks.glass, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Stone                  , ST.make(Blocks.double_stone_slab, 1, 8));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Netherrack             , ST.make(Blocks.netherrack, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Endstone               , ST.make(Blocks.end_stone, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockSolid     , MT.Obsidian               , ST.make(Blocks.obsidian, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Fe                     , ST.make(Blocks.iron_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockIngot     , MT.Au                     , ST.make(Blocks.gold_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Diamond                , ST.make(Blocks.diamond_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Emerald                , ST.make(Blocks.emerald_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Lapis                  , ST.make(Blocks.lapis_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockGem       , MT.Coal                   , ST.make(Blocks.coal_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.blockDust      , MT.Redstone               , ST.make(Blocks.redstone_block, 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.Coffee                 , ST.mkic("coffeePowder", 1));
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.HydratedCoal           , ST.mkic("hydratedCoalDust", 1));
		OreDictManager.INSTANCE.setTarget(OP.gem            , MT.DiamondIndustrial      , ST.mkic("industrialDiamond", 1));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , ST.make(MD.IC2, "blockOreCopper", 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Pb                     , ST.make(MD.IC2, "blockOreLead"  , 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , ST.make(MD.IC2, "blockOreTin"   , 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , ST.make(MD.IC2, "blockOreUran"  , 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Cu                     , ST.make(MD.IC2, "copperOre"     , 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.Sn                     , ST.make(MD.IC2, "tinOre"        , 1, 0));
		OreDictManager.INSTANCE.setTarget(OP.oreVanillastone, MT.OREMATS.Uraninite      , ST.make(MD.IC2, "uraniumOre"    , 1, 0));
		if (MD.IC2C.mLoaded) {
		OreDictManager.INSTANCE.setTarget(OP.plateDense     , MT.Cu                     , MD.IC2, "item.itemPartDCP", 0);
		} else {
		OreDictManager.INSTANCE.setTarget(OP.dust           , MT.EnergiumRed            , ST.mkic("energiumDust", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Fe                     , ST.mkic("casingiron", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Au                     , ST.mkic("casinggold", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Cu                     , ST.mkic("casingcopper", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Sn                     , ST.mkic("casingtin", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Pb                     , ST.mkic("casinglead", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Bronze                 , ST.mkic("casingbronze", 1));
		OreDictManager.INSTANCE.setTarget(OP.casingSmall    , MT.Steel                  , ST.mkic("casingadviron", 1));
		}
		OreDictManager.INSTANCE.setTarget(OP.stick          , MT.Wood                   , MD.TFCP.mLoaded?MD.TFCP:MD.TFC, "item.stick", 0);
		OreDictManager.INSTANCE.setTarget(OP.stickLong      , MT.Wood                   , MD.TFCP.mLoaded?MD.TFCP:MD.TFC, "item.pole", 0);
	}
}
