/**
 * Copyright (c) 2025 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregapi.load;

import gregapi.data.*;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;

import static gregapi.data.CS.*;

/**
 * @author Gregorius Techneticies
 * 
 * Loads the Re-Registrations for several OreDictNames.
 * This happens during the PreInitPhase.
 */
public class LoaderOreDictReRegistrations implements Runnable {
	@Override
	public void run() {
		OreDictManager.INSTANCE.addAutoBlackListing("stoneBowl");
		OreDictManager.INSTANCE.addAutoBlackListing("shardNether");
		OreDictManager.INSTANCE.addAutoBlackListing("gemCoal");
		OreDictManager.INSTANCE.addAutoBlackListing("gemCharcoal");
		OreDictManager.INSTANCE.addAutoBlackListing("gemDiamond");
		OreDictManager.INSTANCE.addAutoBlackListing("gemEmerald");
		OreDictManager.INSTANCE.addAutoBlackListing("gemLapis");
		OreDictManager.INSTANCE.addAutoBlackListing("gemEnderEye");
		OreDictManager.INSTANCE.addAutoBlackListing("gemEnderPearl");
		OreDictManager.INSTANCE.addAutoBlackListing("gemNetherStar");
		OreDictManager.INSTANCE.addAutoBlackListing("gemNetherQuartz");
		OreDictManager.INSTANCE.addAutoBlackListing("gemQuartz");
		OreDictManager.INSTANCE.addAutoBlackListing("ingotBrick");
		OreDictManager.INSTANCE.addAutoBlackListing("ingotNetherBrick");
		OreDictManager.INSTANCE.addAutoBlackListing("ingotIron");
		OreDictManager.INSTANCE.addAutoBlackListing("ingotGold");
		OreDictManager.INSTANCE.addAutoBlackListing("nuggetGold");
		OreDictManager.INSTANCE.addAutoBlackListing("plateWood");
		OreDictManager.INSTANCE.addAutoBlackListing("plankWood");
		OreDictManager.INSTANCE.addAutoBlackListing("stickWood");
		OreDictManager.INSTANCE.addAutoBlackListing("stickBamboo");
		OreDictManager.INSTANCE.addAutoBlackListing("stickBlaze");
		OreDictManager.INSTANCE.addAutoBlackListing("dustBone");
		OreDictManager.INSTANCE.addAutoBlackListing("dustSugar");
		OreDictManager.INSTANCE.addAutoBlackListing("dustTinyBlaze");
		OreDictManager.INSTANCE.addAutoBlackListing("dustRedstone");
		OreDictManager.INSTANCE.addAutoBlackListing("dustGlowstone");
		OreDictManager.INSTANCE.addAutoBlackListing("dustGunpowder");
		OreDictManager.INSTANCE.addAutoBlackListing("bottleEmpty");
		OreDictManager.INSTANCE.addAutoBlackListing("bottleWater");
		OreDictManager.INSTANCE.addAutoBlackListing("bucketEmpty");
		OreDictManager.INSTANCE.addAutoBlackListing("bucketWater");
		OreDictManager.INSTANCE.addAutoBlackListing("bucketLava");
		OreDictManager.INSTANCE.addAutoBlackListing("bucketMilk");
		OreDictManager.INSTANCE.addAutoBlackListing("ingotEnrichedUranium");
		OreDictManager.INSTANCE.addAutoBlackListing("IngotEnrichedUranium");
		OreDictManager.INSTANCE.addAutoBlackListing("blockSolidGlass");
		OreDictManager.INSTANCE.addAutoBlackListing(OD.blockGlassColorless);
		OreDictManager.INSTANCE.addAutoBlackListing(OD.paneGlassColorless);
		OreDictManager.INSTANCE.addAutoBlackListing(OD.glassColorless);
		OreDictManager.INSTANCE.addAutoBlackListing(OD.blockGlass);
		OreDictManager.INSTANCE.addAutoBlackListing(OD.paneGlass);
		OreDictManager.INSTANCE.addAutoBlackListing(OD.glass);
		
		OreDictManager.INSTANCE.addAutoBlackListingForMod(MD.TFC.mID);
		OreDictManager.INSTANCE.addAutoBlackListingForMod(MD.TFCP.mID);
		
		
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemTar                   , "tar");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.craftingChest             , "chest");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.craftingWorkBench         , "craftingTable");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.craftingWireCopper        , "itemCopperWire");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemFertilizer            , "itemFertiliser");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemFertilizer            , "fertiliser");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemFertilizer            , "fertilizer");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemFeather               , "feather");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemLeather               , "leather");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemLeather               , "materialLeather");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemLeatherHardened       , "materialHardenedleather");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemFur                   , "fur");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemPelt                  , "pelt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemRubber                , "ingotRubber");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemResin                 , "itemRawRubber");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemResin                 , "materialResin");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OD.itemGlue                  , "glue");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OP.stone                     , "stoneSmooth");
		OreDictManager.INSTANCE.addReRegistrationWithReversal(OP.cobblestone               , "stoneCobble");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("gravel"                     , "Gravel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("gravel"                     , "blockGravel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("ingotNetherite"             , "NetheriteIngot");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("itemAnthracite"             , "gemAnthracite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("obsidianRod"                , "stickObsidian");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("sheetPlastic"               , "platePlastic");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("sheetRubber"                , "plateRubber");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardAir"                   , "gemInfusedAir");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardWater"                 , "gemInfusedWater");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardFire"                  , "gemInfusedFire");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardEarth"                 , "gemInfusedEarth");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardOrder"                 , "gemInfusedOrder");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("shardEntropy"               , "gemInfusedEntropy");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("actAddCrystalRed"           , "gemRedstonia");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("elvenDragonstone"           , "gemElvenDragonstone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("manaDiamond"                , "gemManaDiamond");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateLivingwood"            , "livingwood");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateDreamwood"             , "dreamwood");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stickLivingwood"            , "livingwoodTwig");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stickDreamwood"             , "dreamwoodTwig");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stickWood"                  , "woodStick");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stickWoodSealed"            , "treatedStick");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateWoodSealed"            , "plankTreatedWood");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("fieryIngot"                 , "ingotFierySteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("ironwood"                   , "ingotIronWood");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("steeleaf"                   , "ingotSteeleaf");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("knightmetal"                , "ingotKnightmetal");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("brickPeat"                  , "ingotPeat");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("tofuKinu"                   , "ingotTofu");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("woodRubber"                 , "logRubber");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("pulpWood"                   , "dustWood");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustBrick"                  , "dustCeramic");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustWaxBee"                 , "itemBeeswax");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustWaxBee"                 , OD.materialWax);
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustWaxPlant"               , OD.materialWax);
		OreDictManager.INSTANCE.addReRegistrationWithReversal("hambone"                    , "foodHamraw");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("bacon"                      , "foodBaconraw");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("itemBacon"                  , "foodBaconraw");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("slimeball"                  , "itemSlimeball");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustTinyBlaze"              , "powderBlaze");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("dustWheat"                  , "flour");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("wheat"                      , "cropWheat");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("itemWheat"                  , "cropWheat");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropCurrant"                , "cropCurrants");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropBeet"                   , "cropBeetroot");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropHop"                    , "cropHops");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("seedHop"                    , "seedHops");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("seedGrape"                  , "seedGrapes");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGrape"                  , "cropGrape");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGrape"                  , "cropGrapes");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGrape"                  , "foodGrapes");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodTomato"                 , "cropTomato");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodRice"                   , "dustRice");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodSilkentofu"             , "dustTofu");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodFirmtofu"               , "ingotTofu");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodChocolatebar"           , "ingotChocolate");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodCocoapowder"            , "dustCocoa");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGroundcinnamon"         , "dustCinnamon");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGroundCinnamon"         , "dustCinnamon");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGroundnutmeg"           , "dustNutmeg");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGroundNutmeg"           , "dustNutmeg");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodLemonaide"              , "foodLemonade");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodSake"                   , "foodRicewine");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropBambooshoot"            , "foodBambooshoot");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropPineapple"              , "cropAnanas");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropAvacado"                , "cropAvocado");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropStaranise"              , "cropStarAnise");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineapplejuice"         , "foodAnanasjuice");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineappleicecream"      , "foodAnanasicecream");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineapplesmoothie"      , "foodAnanassmoothie");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineappleyogurt"        , "foodAnanasyogurt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineapplecider"         , "foodAnanascider");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodPineapplewine"          , "foodAnanaswine");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodGrapefruitsmoothie"     , "foodGrapefruitjellysmoothie");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodBarbecuesauce"          , "foodBBQsauce");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodBarbecuesauce"          , "foodBbqsauce");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("leafTobacco"                , "cropTobacco");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("leafCoca"                   , "cropCoca");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("foodCoffeeBeans"            , "cropCoffee");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropCoffeebeans"            , "cropCoffee");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropCoffeeBeans"            , "cropCoffee");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropCocoabeans"             , "cropCocoa");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropCocoaBeans"             , "cropCocoa");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropOat"                    , "cropOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("baleOat"                    , "baleOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("seedOat"                    , "seedOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropAbyssalOat"             , "cropAbyssalOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("baleAbyssalOat"             , "baleAbyssalOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("seedAbyssalOat"             , "seedAbyssalOats");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropHellderberry"           , "cropHellderBerry");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("seedHellderberry"           , "seedHellderBerry");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("cropMaplesyrup"             , "foodMaplesyrup");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("crystalCertusQuartz"        , "gemCertusQuartz");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("crystalNetherQuartz"        , "gemNetherQuartz");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("crystalFluix"               , "gemFluix");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateLapis"                 , "plateGemLapis");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateLazurite"              , "plateGemLazurite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("plateSodalite"              , "plateGemSodalite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneAndesitePolished"      , "stonePolishedAndesite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneAndesiteChiseled"      , "stoneChiseledAndesite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneAndesiteBricks"        , "stoneBricksAndesite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneDioriteBricks"         , "stoneBricksDiorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneDioritePolished"       , "stonePolishedDiorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneDioriteChiseled"       , "stoneChiseledDiorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneBasaltChiseled"        , "stoneChiseledBasalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneBasaltBricks"          , "stoneBricksBasalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneBasaltPolished"        , "stonePolishedBasalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneGraniteChiseled"       , "stoneChiseledGranite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneGranitePolished"       , "stonePolishedGranite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("stoneGraniteBricks"         , "stoneBricksGranite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("livingrock"                 , "stoneLivingrock");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("marble"                     , "stoneMarble");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("basalt"                     , "stoneBasalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("granite"                    , "stoneGranite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("diorite"                    , "stoneDiorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("andesite"                   , "stoneAndesite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("concrete"                   , "stoneConcrete");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("netherrack"                 , "stoneNetherrack");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("limestone"                  , "stoneLimestone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLimestone"             , "stoneLimestone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMarble"                , "stoneMarble");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBasalt"                , "stoneBasalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockGranite"               , "stoneGranite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDiorite"               , "stoneDiorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAndesite"              , "stoneAndesite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockNikolite"              , "blockDustNikolite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTeslatite"             , "blockDustTeslatite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockElectrotine"           , "blockDustElectrotine");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockVinteum"               , "blockDustVinteum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockVinteumPurified"       , "blockDustVinteumPurified");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLapis"                 , "blockGemLapis");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMalachite"             , "blockGemMalachite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockApatite"               , "blockGemApatite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockChargedCertusQuartz"   , "blockGemChargedCertusQuartz");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCertusQuartz"          , "blockGemCertusQuartz");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockNetherQuartz"          , "blockGemNetherQuartz");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockFuelCoke"              , "blockGemCoalCoke");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockChimerite"             , "blockGemChimerite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockSunstone"              , "blockGemSunstone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMoonstone"             , "blockGemMoonstone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockRedMeteorGem"          , "blockGemRedMeteor");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockNetherite"             , "blockIngotNetherite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockIron"                  , "blockIngotIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockSteel"                 , "blockIngotSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBronze"                , "blockIngotBronze");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBrass"                 , "blockIngotBrass");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCopper"                , "blockIngotCopper");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTin"                   , "blockIngotTin");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockZinc"                  , "blockIngotZinc");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLead"                  , "blockIngotLead");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockThorium"               , "blockIngotThorium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockUranium"               , "blockIngotUranium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockPlutonium"             , "blockIngotPlutonium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockYellorium"             , "blockIngotYellorium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCyanite"               , "blockIngotCyanite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockGraphite"              , "blockIngotGraphite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBlutonium"             , "blockIngotBlutonium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLudicrite"             , "blockIngotLudicrite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBoron"                 , "blockIngotBoron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockNiobium"               , "blockIngotNiobium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBismuth"               , "blockIngotBismuth");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLithium"               , "blockIngotLithium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCobalt"                , "blockIngotCobalt");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockChrome"                , "blockIngotChrome");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockChromium"              , "blockIngotChromium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockSilver"                , "blockIngotSilver");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockGold"                  , "blockIngotGold");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockPlatinum"              , "blockIngotPlatinum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockOsmium"                , "blockIngotOsmium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockRefinedGlowstone"      , "blockIngotRefinedGlowstone");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockRefinedObsidian"       , "blockIngotRefinedObsidian");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAnyIron"               , "blockIngotAnyIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAnyIronSteel"          , "blockIngotAnyIronSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAnySteel"              , "blockIngotAnySteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAnyCopper"             , "blockIngotAnyCopper");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAnyBronze"             , "blockIngotAnyBronze");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMeat"                  , "blockIngotMeat");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAlduorite"             , "blockIngotAlduorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockInfuscolium"           , "blockIngotInfuscolium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockRubracium"             , "blockIngotRubracium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMeutoite"              , "blockIngotMeutoite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLemurite"              , "blockIngotLemurite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCeruclase"             , "blockIngotCeruclase");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAtlarus"               , "blockIngotAtlarus");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockOureclase"             , "blockIngotOureclase");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockKalendrite"            , "blockIngotKalendrite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockOrichalcum"            , "blockIngotOrichalcum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCarmot"                , "blockIngotCarmot");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockSanguinite"            , "blockIngotSanguinite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockVyroxeres"             , "blockIngotVyroxeres");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockEximite"               , "blockIngotEximite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockPrometheum"            , "blockIngotPrometheum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockIgnatius"              , "blockIngotIgnatius");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockVulcanite"             , "blockIngotVulcanite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockShadowIron"            , "blockIngotShadowIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAstralSilver"          , "blockIngotAstralSilver");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMidasium"              , "blockIngotMidasium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMithril"               , "blockIngotMithril");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockShadowSteel"           , "blockIngotShadowSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockInolashite"            , "blockIngotInolashite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockHaderoth"              , "blockIngotHaderoth");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCelenegil"             , "blockIngotCelenegil");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDesichalkos"           , "blockIngotDesichalkos");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTartarite"             , "blockIngotTartarite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAmordrine"             , "blockIngotAmordrine");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAngmallen"             , "blockIngotAngmallen");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockHepatizon"             , "blockIngotHepatizon");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBlackSteel"            , "blockIngotBlackSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockRedSteel"              , "blockIngotRedSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBlueSteel"             , "blockIngotBlueSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDamascusSteel"         , "blockIngotDamascusSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDeepIron"              , "blockIngotDeepIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockSignalum"              , "blockIngotSignalum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockLumium"                , "blockIngotLumium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockEnderium"              , "blockIngotEnderium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDarkSteel"             , "blockIngotDarkSteel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDarkIron"              , "blockIngotDarkIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockFzDarkIron"            , "blockIngotDarkIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAluminum"              , "blockIngotAluminium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockAluminium"             , "blockIngotAluminium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTungsten"              , "blockIngotTungsten");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockNickel"                , "blockIngotNickel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockCupronickel"           , "blockIngotCupronickel");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockConstantan"            , "blockIngotConstantan");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockElectrum"              , "blockIngotElectrum");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTitaniumIridium"       , "blockIngotTitaniumIridium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockTitaniumAluminide"     , "blockIngotTitaniumAluminide");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockEndium"                , "blockIngotEndium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockDesh"                  , "blockIngotDesh");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockMeteorite"             , "blockIngotMeteorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockFrezarite"             , "blockIngotFrozenIron");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockKreknorite"            , "blockIngotKreknorite");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("blockBedrockium"            , "blockIngotBedrockium");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("oreAquaMiddleGem"           , "oreAquaMiddle");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("oreGreenMiddleGem"          , "oreGreenMiddle");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("oreCrimsonMiddleGem"        , "oreCrimsonMiddle");
		OreDictManager.INSTANCE.addReRegistrationWithReversal("oreEndium"                  , "oreEndEndium");
		
		
		
		
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[1]                  , "gt:autocrafterblueprintitem");
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[1]                  , "gt:autocrafterblueprintitem");
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[1]                  , OD_USB_STICKS[0]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[2]                  , OD_USB_STICKS[1]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[3]                  , OD_USB_STICKS[2]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[4]                  , OD_USB_STICKS[3]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[5]                  , OD_USB_STICKS[4]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[6]                  , OD_USB_STICKS[5]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[7]                  , OD_USB_STICKS[6]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[8]                  , OD_USB_STICKS[7]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_STICKS[9]                  , OD_USB_STICKS[8]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[1]                  , OD_USB_CABLES[0]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[2]                  , OD_USB_CABLES[1]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[3]                  , OD_USB_CABLES[2]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[4]                  , OD_USB_CABLES[3]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[5]                  , OD_USB_CABLES[4]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[6]                  , OD_USB_CABLES[5]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[7]                  , OD_USB_CABLES[6]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[8]                  , OD_USB_CABLES[7]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_CABLES[9]                  , OD_USB_CABLES[8]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[1]                  , OD_USB_DRIVES[0]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[2]                  , OD_USB_DRIVES[1]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[3]                  , OD_USB_DRIVES[2]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[4]                  , OD_USB_DRIVES[3]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[5]                  , OD_USB_DRIVES[4]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[6]                  , OD_USB_DRIVES[5]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[7]                  , OD_USB_DRIVES[6]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[8]                  , OD_USB_DRIVES[7]);
		OreDictManager.INSTANCE.addReRegistration(OD_USB_DRIVES[9]                  , OD_USB_DRIVES[8]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[1]                    , OD_CIRCUITS[0]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[2]                    , OD_CIRCUITS[1]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[3]                    , OD_CIRCUITS[2]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[4]                    , OD_CIRCUITS[3]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[5]                    , OD_CIRCUITS[4]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[6]                    , OD_CIRCUITS[5]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[7]                    , OD_CIRCUITS[6]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[8]                    , OD_CIRCUITS[7]);
		OreDictManager.INSTANCE.addReRegistration(OD_CIRCUITS[9]                    , OD_CIRCUITS[8]);
		OreDictManager.INSTANCE.addReRegistration("compressedCopper"                , "gt:complateCopper"       );
		OreDictManager.INSTANCE.addReRegistration("compressedTin"                   , "gt:complateTin"          );
		OreDictManager.INSTANCE.addReRegistration("compressedAluminium"             , "gt:complateAluminium"    );
		OreDictManager.INSTANCE.addReRegistration("compressedBronze"                , "gt:complateBronze"       );
		OreDictManager.INSTANCE.addReRegistration("compressedIron"                  , "gt:complateIron"         );
		OreDictManager.INSTANCE.addReRegistration("compressedMeteoricIron"          , "gt:complateMeteoricIron" );
		OreDictManager.INSTANCE.addReRegistration("compressedDesh"                  , "gt:complateDesh"         );
		OreDictManager.INSTANCE.addReRegistration("compressedTitanium"              , "gt:complateTitanium"     );
		OreDictManager.INSTANCE.addReRegistration("compressedSteel"                 , "gt:complateSteel"        );
		OreDictManager.INSTANCE.addReRegistration("plateAnyCopper"                  , "gt:complateCopper"       );
		OreDictManager.INSTANCE.addReRegistration("plateTin"                        , "gt:complateTin"          );
		OreDictManager.INSTANCE.addReRegistration("plateAluminium"                  , "gt:complateAluminium"    );
		OreDictManager.INSTANCE.addReRegistration("plateBronze"                     , "gt:complateBronze"       );
		OreDictManager.INSTANCE.addReRegistration("plateAnyIron"                    , "gt:complateIron"         );
		OreDictManager.INSTANCE.addReRegistration("plateMeteoricIron"               , "gt:complateMeteoricIron" );
		OreDictManager.INSTANCE.addReRegistration("plateDesh"                       , "gt:complateDesh"         );
		OreDictManager.INSTANCE.addReRegistration("plateTitanium"                   , "gt:complateTitanium"     );
		OreDictManager.INSTANCE.addReRegistration("plateAnyIronSteel"               , "gt:complateSteel"        );
		OreDictManager.INSTANCE.addReRegistration("plateAnyIronSteel"               , "sheetMetal");
		OreDictManager.INSTANCE.addReRegistration("wireGt01Tin"                     , "wireTin");
		OreDictManager.INSTANCE.addReRegistration("wireGt01Lead"                    , "wireLead");
		OreDictManager.INSTANCE.addReRegistration("wireGt01Silver"                  , "wireSilver");
		OreDictManager.INSTANCE.addReRegistration("wireGt01Gold"                    , "wireGold");
		OreDictManager.INSTANCE.addReRegistration("wireGt01AnyIron"                 , "wireIron");
		OreDictManager.INSTANCE.addReRegistration("wireGt01AnyIronSteel"            , "wireSteel");
		OreDictManager.INSTANCE.addReRegistration("wireGt01AnyCopper"               , "wireCopper");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyWood"                   , "gearWood");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyWood"                   , "gearAnyWood");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyStone"                  , "gearStone");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyStone"                  , "gearAnyStone");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyIron"                   , "gearIron");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyIron"                   , "gearAnyIron");
		OreDictManager.INSTANCE.addReRegistration("gearGtSteel"                     , "gearSteel");
		OreDictManager.INSTANCE.addReRegistration("gearGtGold"                      , "gearGold");
		OreDictManager.INSTANCE.addReRegistration("gearGtDiamond"                   , "gearDiamond");
		OreDictManager.INSTANCE.addReRegistration("gearGtDiamond"                   , "gearAnyDiamond");
		OreDictManager.INSTANCE.addReRegistration("gearGtTin"                       , "gearTin");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyCopper"                 , "gearCopper");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyCopper"                 , "gearAnyCopper");
		OreDictManager.INSTANCE.addReRegistration("gearGtBronze"                    , "gearBronze");
		OreDictManager.INSTANCE.addReRegistration("gearGtSilver"                    , "gearSilver");
		OreDictManager.INSTANCE.addReRegistration("gearGtLead"                      , "gearLead");
		OreDictManager.INSTANCE.addReRegistration("gearGtNickel"                    , "gearNickel");
		OreDictManager.INSTANCE.addReRegistration("gearGtPlatinum"                  , "gearPlatinum");
		OreDictManager.INSTANCE.addReRegistration("gearGtMithril"                   , "gearMithril");
		OreDictManager.INSTANCE.addReRegistration("gearGtElectrum"                  , "gearElectrum");
		OreDictManager.INSTANCE.addReRegistration("gearGtInvar"                     , "gearInvar");
		OreDictManager.INSTANCE.addReRegistration("gearGtSignalum"                  , "gearSignalum");
		OreDictManager.INSTANCE.addReRegistration("gearGtLumium"                    , "gearLumium");
		OreDictManager.INSTANCE.addReRegistration("gearGtEnderium"                  , "gearEnderium");
		OreDictManager.INSTANCE.addReRegistration("gearGtThaumium"                  , "gearThaumium");
		OreDictManager.INSTANCE.addReRegistration("gearGtTitanium"                  , "gearTitanium");
		OreDictManager.INSTANCE.addReRegistration("aetherRecord"                    , OD.record);
		OreDictManager.INSTANCE.addReRegistration("slimeRod"                        , "stickSlime");
		OreDictManager.INSTANCE.addReRegistration("blueslimeRod"                    , "stickBlueslime");
		OreDictManager.INSTANCE.addReRegistration("boneRod"                         , "stickBone");
		OreDictManager.INSTANCE.addReRegistration("steelRod"                        , "stickSteel");
		OreDictManager.INSTANCE.addReRegistration("bronzeRod"                       , "stickBronze");
		OreDictManager.INSTANCE.addReRegistration("copperRod"                       , "stickCopper");
		OreDictManager.INSTANCE.addReRegistration("flintRod"                        , "stickFlint");
		OreDictManager.INSTANCE.addReRegistration("netherrackRod"                   , "stickNetherrack");
		OreDictManager.INSTANCE.addReRegistration("alumiteRod"                      , "stickAlumite");
		OreDictManager.INSTANCE.addReRegistration("thaumiumRod"                     , "stickThaumium");
		OreDictManager.INSTANCE.addReRegistration("ironRod"                         , "stickIron");
		OreDictManager.INSTANCE.addReRegistration("cobaltRod"                       , "stickCobalt");
		OreDictManager.INSTANCE.addReRegistration("arditeRod"                       , "stickArdite");
		OreDictManager.INSTANCE.addReRegistration("manyullynRod"                    , "stickManyullyn");
		OreDictManager.INSTANCE.addReRegistration("stickWoodRubber"                 , OD.stickWood);
		OreDictManager.INSTANCE.addReRegistration("seedIndustrialHemp"              , "seedHemp");
		OreDictManager.INSTANCE.addReRegistration("nuggetThorium232"                , "tinyTh232");
		OreDictManager.INSTANCE.addReRegistration("nuggetUranium233"                , "tinyU233");
		OreDictManager.INSTANCE.addReRegistration("nuggetUranium235"                , "tinyU235");
		OreDictManager.INSTANCE.addReRegistration("nuggetUranium238"                , "tinyU238");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium238"              , "tinyPu238");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium239"              , "tinyPu239");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium240"              , "tinyPu240");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium241"              , "tinyPu241");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium242"              , "tinyPu242");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium243"              , "tinyPu243");
		OreDictManager.INSTANCE.addReRegistration("nuggetPlutonium244"              , "tinyPu244");
		OreDictManager.INSTANCE.addReRegistration("ingotThorium232"                 , "Th232");
		OreDictManager.INSTANCE.addReRegistration("ingotUranium233"                 , "U233");
		OreDictManager.INSTANCE.addReRegistration("ingotUranium235"                 , "U235");
		OreDictManager.INSTANCE.addReRegistration("ingotUranium238"                 , "U238");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium238"               , "Pu238");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium239"               , "Pu239");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium240"               , "Pu240");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium241"               , "Pu241");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium242"               , "Pu242");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium243"               , "Pu243");
		OreDictManager.INSTANCE.addReRegistration("ingotPlutonium244"               , "Pu244");
		OreDictManager.INSTANCE.addReRegistration("gemPinkDiamond"                  , "gemDiamond");
		OreDictManager.INSTANCE.addReRegistration("gemDiamondIndustrial"            , "gemDiamond");
		OreDictManager.INSTANCE.addReRegistration("gemDiamond"                      , "diamond");
		OreDictManager.INSTANCE.addReRegistration("dustSulfur"                      , "sulfur");
		OreDictManager.INSTANCE.addReRegistration("dustAnyGlowstone"                , "dustGlowstone");
		OreDictManager.INSTANCE.addReRegistration("oreRawRedstone"                  , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("gemFlawlessRedstone"             , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("gemRedstone"                     , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("gemRedstonia"                    , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("dustRedstone"                    , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("dustRedstonia"                   , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("plateRedstone"                   , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("plateRedstonia"                  , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("plateGemRedstone"                , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("plateGemRedstonia"               , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("crystalRedstone"                 , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("redstoneCrystal"                 , OD.itemRedstone);
		OreDictManager.INSTANCE.addReRegistration("oreRawMercury"                   , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("gemFlawlessMercury"              , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("gemMercury"                      , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("dustMercury"                     , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("ingotMercury"                    , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("plateMercury"                    , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("plateGemMercury"                 , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration("crystalMercury"                  , OD.itemQuicksilver);
		OreDictManager.INSTANCE.addReRegistration(OD.itemQuicksilver                , "quicksilver");
		OreDictManager.INSTANCE.addReRegistration(OD.paperEmpty                     , OD.itemInsulator);
		OreDictManager.INSTANCE.addReRegistration(OD.itemRubber                     , OD.itemInsulator);
		OreDictManager.INSTANCE.addReRegistration("gearAnyIronOrSteel"              , "Gear");
		OreDictManager.INSTANCE.addReRegistration("gearGtAnyIronOrSteel"            , "Gear");
		OreDictManager.INSTANCE.addReRegistration("sprocketAnyIronOrSteel"          , "Sprocket");
		OreDictManager.INSTANCE.addReRegistration("boltAnyIronOrSteel"              , "Bolt");
		OreDictManager.INSTANCE.addReRegistration("screwAnyIronOrSteel"             , "Screw");
		OreDictManager.INSTANCE.addReRegistration("springAnyIronOrSteel"            , "Spring");
		OreDictManager.INSTANCE.addReRegistration("roundAnyIronOrSteel"             , "Bearing");
		OreDictManager.INSTANCE.addReRegistration(OD.buttonWood                     , OD.button);
		OreDictManager.INSTANCE.addReRegistration(OD.buttonStone                    , OD.button);
		OreDictManager.INSTANCE.addReRegistration("blockSolidObsidian"              , OD.obsidian);
		OreDictManager.INSTANCE.addReRegistration(OD.obsidian                       , "stoneObsidian");
		OreDictManager.INSTANCE.addReRegistration(OD.cryingObsidian                 , OD.obsidian);
		OreDictManager.INSTANCE.addReRegistration("stoneSand"                       , OD.sandstone);
		OreDictManager.INSTANCE.addReRegistration("stoneSoulSand"                   , OD.sandstone);
		OreDictManager.INSTANCE.addReRegistration("oreRawCoalCoke"                  , "fuelCoke");
		OreDictManager.INSTANCE.addReRegistration("oreRawCoalCoke"                  , "coalCoke");
		OreDictManager.INSTANCE.addReRegistration("oreRawCoalCoke"                  , "coke");
		OreDictManager.INSTANCE.addReRegistration("oreRawCoal"                      , "coal");
		OreDictManager.INSTANCE.addReRegistration("oreRawCharcoal"                  , "charcoal");
		OreDictManager.INSTANCE.addReRegistration("gemCoalCoke"                     , "fuelCoke");
		OreDictManager.INSTANCE.addReRegistration("gemCoalCoke"                     , "coalCoke");
		OreDictManager.INSTANCE.addReRegistration("gemCoalCoke"                     , "coke");
		OreDictManager.INSTANCE.addReRegistration("gemCoal"                         , "coal");
		OreDictManager.INSTANCE.addReRegistration("gemCharcoal"                     , "charcoal");
		OreDictManager.INSTANCE.addReRegistration("ingotCoalCoke"                   , "fuelCoke");
		OreDictManager.INSTANCE.addReRegistration("ingotCoalCoke"                   , "coalCoke");
		OreDictManager.INSTANCE.addReRegistration("ingotCoalCoke"                   , "coke");
		OreDictManager.INSTANCE.addReRegistration("ingotCoal"                       , "coal");
		OreDictManager.INSTANCE.addReRegistration("ingotCharcoal"                   , "charcoal");
		OreDictManager.INSTANCE.addReRegistration("gemChargedCertusQuartz"          , OD.itemCertusQuartz);
		OreDictManager.INSTANCE.addReRegistration("gemCertusQuartz"                 , OD.itemCertusQuartz);
		OreDictManager.INSTANCE.addReRegistration("gemNetherQuartz"                 , OD.itemNetherQuartz);
		OreDictManager.INSTANCE.addReRegistration("oreRawQuartz"                    , OD.craftingQuartz);
		OreDictManager.INSTANCE.addReRegistration("gemQuartz"                       , OD.craftingQuartz);
		OreDictManager.INSTANCE.addReRegistration(OD.itemCertusQuartz               , OD.craftingQuartz);
		OreDictManager.INSTANCE.addReRegistration(OD.itemNetherQuartz               , OD.craftingQuartz);
		OreDictManager.INSTANCE.addReRegistration(OD.itemTar                        , "dyeBlack");
		OreDictManager.INSTANCE.addReRegistration("gemMalachite"                    , "dyeMixableGreen");
		OreDictManager.INSTANCE.addReRegistration("gemLazurite"                     , "dyeMixableCyan");
		OreDictManager.INSTANCE.addReRegistration("gemLapis"                        , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("gemSodalite"                     , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("dustAzurite"                     , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("dustLapis"                       , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("dustSodalite"                    , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("dustLazurite"                    , "dyeMixableCyan");
		OreDictManager.INSTANCE.addReRegistration("dustMalachite"                   , "dyeMixableGreen");
		OreDictManager.INSTANCE.addReRegistration("dustSalt"                        , OD.itemSalt);
		OreDictManager.INSTANCE.addReRegistration(OD.itemSalt                       , "foodSalt");
		OreDictManager.INSTANCE.addReRegistration("dustWheat"                       , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustBarley"                      , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustRye"                         , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustOat"                         , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustAbyssalOats"                 , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustRice"                        , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustPotato"                      , "foodFlour");
		OreDictManager.INSTANCE.addReRegistration("dustCorn"                        , "foodCornmeal");
		OreDictManager.INSTANCE.addReRegistration("dustPepperBlack"                 , "foodBlackpepper");
		OreDictManager.INSTANCE.addReRegistration("dustGraphite"                    , "dyeGray");
		OreDictManager.INSTANCE.addReRegistration("dustCarbon"                      , "dyeBlack");
		OreDictManager.INSTANCE.addReRegistration("dustVolcanicAsh"                 , "dyeMixableBlack");
		OreDictManager.INSTANCE.addReRegistration("dustDarkAsh"                     , "dyeMixableGray");
		OreDictManager.INSTANCE.addReRegistration("dustAsh"                         , "dyeMixableLightGray");
		OreDictManager.INSTANCE.addReRegistration("dustCocoa"                       , "dyeMixableBrown");
		OreDictManager.INSTANCE.addReRegistration("dustCoffee"                      , "dyeMixableBrown");
		OreDictManager.INSTANCE.addReRegistration("dustChocolate"                   , "dyeMixableBrown");
		OreDictManager.INSTANCE.addReRegistration("dustBrownLimonite"               , "dyeMixableBrown");
		OreDictManager.INSTANCE.addReRegistration("dustYellowLimonite"              , "dyeMixableYellow");
		OreDictManager.INSTANCE.addReRegistration("dustBlack"                       , "dyeMixableBlack");
		OreDictManager.INSTANCE.addReRegistration("dustRed"                         , "dyeMixableRed");
		OreDictManager.INSTANCE.addReRegistration("dustGreen"                       , "dyeMixableGreen");
		OreDictManager.INSTANCE.addReRegistration("dustBrown"                       , "dyeMixableBrown");
		OreDictManager.INSTANCE.addReRegistration("dustBlue"                        , "dyeMixableBlue");
		OreDictManager.INSTANCE.addReRegistration("dustPurple"                      , "dyeMixablePurple");
		OreDictManager.INSTANCE.addReRegistration("dustCyan"                        , "dyeMixableCyan");
		OreDictManager.INSTANCE.addReRegistration("dustLightGray"                   , "dyeMixableLightGray");
		OreDictManager.INSTANCE.addReRegistration("dustGray"                        , "dyeMixableGray");
		OreDictManager.INSTANCE.addReRegistration("dustPink"                        , "dyeMixablePink");
		OreDictManager.INSTANCE.addReRegistration("dustLime"                        , "dyeMixableLime");
		OreDictManager.INSTANCE.addReRegistration("dustYellow"                      , "dyeMixableYellow");
		OreDictManager.INSTANCE.addReRegistration("dustLightBlue"                   , "dyeMixableLightBlue");
		OreDictManager.INSTANCE.addReRegistration("dustMagenta"                     , "dyeMixableMagenta");
		OreDictManager.INSTANCE.addReRegistration("dustOrange"                      , "dyeMixableOrange");
		OreDictManager.INSTANCE.addReRegistration("dustWhite"                       , "dyeMixableWhite");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableBlack"                 , "dyeBlack");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableRed"                   , "dyeRed");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableGreen"                 , "dyeGreen");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableBrown"                 , "dyeBrown");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableBlue"                  , "dyeBlue");
		OreDictManager.INSTANCE.addReRegistration("dyeMixablePurple"                , "dyePurple");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableCyan"                  , "dyeCyan");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableLightGray"             , "dyeLightGray");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableGray"                  , "dyeGray");
		OreDictManager.INSTANCE.addReRegistration("dyeMixablePink"                  , "dyePink");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableLime"                  , "dyeLime");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableYellow"                , "dyeYellow");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableLightBlue"             , "dyeLightBlue");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableMagenta"               , "dyeMagenta");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableOrange"                , "dyeOrange");
		OreDictManager.INSTANCE.addReRegistration("dyeMixableWhite"                 , "dyeWhite");
		OreDictManager.INSTANCE.addReRegistration("dustWaxMagic"                    , "waxMagical");
		OreDictManager.INSTANCE.addReRegistration("dustWaxAmnesic"                  , "waxMagical");
		OreDictManager.INSTANCE.addReRegistration("dustAnyWax"                      , "materialPressedwax");
		OreDictManager.INSTANCE.addReRegistration("ingotAnyWax"                     , "materialPressedwax");
		OreDictManager.INSTANCE.addReRegistration("cableGt01Tin"                    , OD.craftingWireTin);
		OreDictManager.INSTANCE.addReRegistration("cableGt01AnyCopper"              , OD.craftingWireCopper);
		OreDictManager.INSTANCE.addReRegistration("cableGt01Gold"                   , OD.craftingWireGold);
		OreDictManager.INSTANCE.addReRegistration("cableGt01AnyIron"                , OD.craftingWireIron);
		OreDictManager.INSTANCE.addReRegistration(OD.bookEmptyBig                   , OD.bookEmpty);
		OreDictManager.INSTANCE.addReRegistration(OD.bookWrittenBig                 , OD.bookWritten);
		OreDictManager.INSTANCE.addReRegistration(OD.bookWritableBig                , OD.bookWritable);
		OreDictManager.INSTANCE.addReRegistration(OD.bookEmptySmall                 , OD.bookEmpty);
		OreDictManager.INSTANCE.addReRegistration(OD.bookWrittenSmall               , OD.bookWritten);
		OreDictManager.INSTANCE.addReRegistration(OD.bookWritableSmall              , OD.bookWritable);
		OreDictManager.INSTANCE.addReRegistration(OD.itemLeather                    , OD.craftingLeather);
		OreDictManager.INSTANCE.addReRegistration(OD.itemLeatherTreated             , OD.craftingLeather);
		OreDictManager.INSTANCE.addReRegistration(OD.itemLeatherHardened            , OD.craftingLeather);
		OreDictManager.INSTANCE.addReRegistration(OD.itemLeatherImpregnated         , OD.craftingLeather);
		OreDictManager.INSTANCE.addReRegistration(OD.itemFeather                    , OD.craftingFeather);
		OreDictManager.INSTANCE.addReRegistration(OD.chocobofeather                 , OD.itemFeather);
		OreDictManager.INSTANCE.addReRegistration(OD.itemFur                        , OD.craftingFur);
		OreDictManager.INSTANCE.addReRegistration(OD.itemPelt                       , OD.craftingFur);
		OreDictManager.INSTANCE.addReRegistration(OD.itemGrassTall                  , OD.itemGrass);
		OreDictManager.INSTANCE.addReRegistration("cropWheat"                       , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("cropRice"                        , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("cropOats"                        , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("cropAbyssalOats"                 , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("cropRye"                         , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("cropBarley"                      , OD.cropGrain);
		OreDictManager.INSTANCE.addReRegistration("bouleGtAnySilicon"               , "bouleSilicon");
		OreDictManager.INSTANCE.addReRegistration("plateGemAnySilicon"              , OD.itemSilicon);
		OreDictManager.INSTANCE.addReRegistration("plateAnySilicon"                 , OD.itemSilicon);
		OreDictManager.INSTANCE.addReRegistration("plateCeramic"                    , OD.craftingHardenedClay);
		OreDictManager.INSTANCE.addReRegistration("plateWood"                       , OD.plankWood);
		OreDictManager.INSTANCE.addReRegistration("plankWood"                       , OD.plankAnyWood);
		OreDictManager.INSTANCE.addReRegistration("plateAnyWood"                    , OD.plankAnyWood);
		OreDictManager.INSTANCE.addReRegistration(OD.blockGlassColorless            , OD.glassColorless);
		OreDictManager.INSTANCE.addReRegistration(OD.blockGlassColorless            , OD.blockGlass);
		OreDictManager.INSTANCE.addReRegistration(OD.paneGlassColorless             , OD.glassColorless);
		OreDictManager.INSTANCE.addReRegistration(OD.paneGlassColorless             , OD.paneGlass);
		OreDictManager.INSTANCE.addReRegistration(OD.glassColorless                 , OD.glass);
		OreDictManager.INSTANCE.addReRegistration(OD.blockGlass                     , OD.glass);
		OreDictManager.INSTANCE.addReRegistration(OD.paneGlass                      , OD.glass);
		OreDictManager.INSTANCE.addReRegistration(OreDictToolNames.axe              , OreDictToolNames.sawaxe);
		OreDictManager.INSTANCE.addReRegistration(OreDictToolNames.saw              , OreDictToolNames.sawaxe);
		OreDictManager.INSTANCE.addReRegistration("wireFineTin"                     , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration("wireFineLead"                    , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration("wireFineSolderingAlloy"          , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration("stickTin"                        , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration("stickLead"                       , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration("stickSolderingAlloy"             , OreDictToolNames.solderingmetal);
		OreDictManager.INSTANCE.addReRegistration(OD.itemTar                        , OD.itemGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.itemGlue                       , OD.craftingPistonGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.itemResin                      , OD.craftingPistonGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.slimeball                      , OD.craftingPistonGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.slimeballPink                  , OD.craftingPistonGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.slimeballSwet                  , OD.craftingPistonGlue);
		OreDictManager.INSTANCE.addReRegistration("ingotAnyIron"                    , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotAnySteel"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotAnyBronze"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotAlumite"                    , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotAluminium"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotAluminiumAlloy"             , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotBronze"                     , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotNickel"                     , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotInvar"                      , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotTitanium"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotTungsten"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotThaumium"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotVoidMetal"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotHSLASpringSteel"            , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotIronWood"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotMagnalium"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotUltimet"                    , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotManasteel"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotTerrasteel"                 , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotElvorium"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotMauftrium"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotDuranium"                   , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotTritanium"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotSyrmorite"                  , OD.craftingPistonIngot);
		OreDictManager.INSTANCE.addReRegistration("ingotTarPitch"                   , OD.itemTar);
		OreDictManager.INSTANCE.addReRegistration("nuggetTarPitch"                  , OD.itemTar);
		OreDictManager.INSTANCE.addReRegistration("stoneBowl"                       , "bowlStone");
		OreDictManager.INSTANCE.addReRegistration("stoneRod"                        , "stickStone");
		OreDictManager.INSTANCE.addReRegistration("budCannabis"                     , "cropCannabis");
		OreDictManager.INSTANCE.addReRegistration("leafCannabis"                    , "cropCannabis");
		OreDictManager.INSTANCE.addReRegistration("plantGtBlossomTea"               , "cropTea");
		OreDictManager.INSTANCE.addReRegistration("plantGtBlossomMint"              , "cropMint");
		OreDictManager.INSTANCE.addReRegistration("plantGtBlossomIndigo"            , "cropIndigo");
		OreDictManager.INSTANCE.addReRegistration("foodRaisincookies"               , "foodCookie");
		OreDictManager.INSTANCE.addReRegistration("foodChaoscookie"                 , "foodCookie");
		OreDictManager.INSTANCE.addReRegistration("foodPeanutbuttercookies"         , "foodCookie");
		OreDictManager.INSTANCE.addReRegistration("foodCreamcookie"                 , "foodCookie");
		OreDictManager.INSTANCE.addReRegistration("foodCracker"                     , "foodCookie");
		OreDictManager.INSTANCE.addReRegistration("foodRibeyesteakcooked"           , "listAllbeefcooked");
		OreDictManager.INSTANCE.addReRegistration("foodRibeyesteakraw"              , "listAllbeefraw");
		OreDictManager.INSTANCE.addReRegistration("foodRibcooked"                   , "listAllribcooked");
		OreDictManager.INSTANCE.addReRegistration("foodRibraw"                      , "listAllribraw");
		OreDictManager.INSTANCE.addReRegistration("foodHamcooked"                   , "listAllhamcooked");
		OreDictManager.INSTANCE.addReRegistration("foodHamraw"                      , "listAllhamraw");
		OreDictManager.INSTANCE.addReRegistration("foodBaconcooked"                 , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("foodBaconraw"                    , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("foodVenisoncooked"               , "listAllvenisoncooked");
		OreDictManager.INSTANCE.addReRegistration("foodVenisonraw"                  , "listAllvenisonraw");
		OreDictManager.INSTANCE.addReRegistration("foodTitancooked"                 , "listAlltitancooked");
		OreDictManager.INSTANCE.addReRegistration("foodTitanraw"                    , "listAlltitanraw");
		OreDictManager.INSTANCE.addReRegistration("foodTurkeycooked"                , "listAllturkeycooked");
		OreDictManager.INSTANCE.addReRegistration("foodTurkeyraw"                   , "listAllturkeyraw");
		OreDictManager.INSTANCE.addReRegistration("foodRatcooked"                   , "listAllratcooked");
		OreDictManager.INSTANCE.addReRegistration("foodRatraw"                      , "listAllratrraw");
		OreDictManager.INSTANCE.addReRegistration("foodCrabcooked"                  , "listAllcrabcooked");
		OreDictManager.INSTANCE.addReRegistration("foodCrabraw"                     , "listAllcrabraw");
		OreDictManager.INSTANCE.addReRegistration("foodTurtlecooked"                , "listAllturtlecooked");
		OreDictManager.INSTANCE.addReRegistration("foodTurtleraw"                   , "listAllturtleraw");
		OreDictManager.INSTANCE.addReRegistration("foodOstrichcooked"               , "listAllostrichcooked");
		OreDictManager.INSTANCE.addReRegistration("foodOstrichraw"                  , "listAllostrichraw");
		OreDictManager.INSTANCE.addReRegistration("foodHorsecooked"                 , "listAllhorsecooked");
		OreDictManager.INSTANCE.addReRegistration("foodHorseraw"                    , "listAllhorseraw");
		OreDictManager.INSTANCE.addReRegistration("foodMulecooked"                  , "listAllhorsecooked");
		OreDictManager.INSTANCE.addReRegistration("foodMuleraw"                     , "listAllhorseraw");
		OreDictManager.INSTANCE.addReRegistration("foodDonkeycooked"                , "listAllhorsecooked");
		OreDictManager.INSTANCE.addReRegistration("foodDonkeyraw"                   , "listAllhorseraw");
		OreDictManager.INSTANCE.addReRegistration("foodDogcooked"                   , "listAlldogcooked");
		OreDictManager.INSTANCE.addReRegistration("foodDograw"                      , "listAlldograw");
		OreDictManager.INSTANCE.addReRegistration("foodMuttoncooked"                , "listAllmuttoncooked");
		OreDictManager.INSTANCE.addReRegistration("foodMuttonraw"                   , "listAllmuttonraw");
		OreDictManager.INSTANCE.addReRegistration("foodRabbitcooked"                , "listAllrabbitcooked");
		OreDictManager.INSTANCE.addReRegistration("foodRabbitraw"                   , "listAllrabbitraw");
		OreDictManager.INSTANCE.addReRegistration("fish"                            , "listAllfishraw");
		OreDictManager.INSTANCE.addReRegistration("listAllhorsecooked"              , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllhorseraw"                 , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAlldogcooked"                , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAlldograw"                   , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllhydracooked"              , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllhydraraw"                 , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllribcooked"                , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllribraw"                   , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllhamcooked"                , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllhamraw"                   , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllbeefcooked"               , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllbeefraw"                  , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllchickencooked"            , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllchickenraw"               , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllfishcooked"               , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllfishraw"                  , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllmuttoncooked"             , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllmuttonraw"                , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllporkcooked"               , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllporkraw"                  , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllrabbitcooked"             , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllrabbitraw"                , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllturkeycooked"             , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllturkeyraw"                , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllvenisoncooked"            , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllvenisonraw"               , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAlltitanncooked"             , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAlltitanraw"                 , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllratcooked"                , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllratraw"                   , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllcrabcooked"               , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllcrabraw"                  , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllostrichcooked"            , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllostrichraw"               , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("listAllturtlecooked"             , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("listAllturtleraw"                , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , OD.listAllmeatsubstitute);
		OreDictManager.INSTANCE.addReRegistration("plateSoylentGreen"               , OD.listAllmeatsubstitute);
		OreDictManager.INSTANCE.addReRegistration("dustSoylentGreen"                , OD.listAllmeatsubstitute);
		OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , OD.listAllmeatsubstitute);
		OreDictManager.INSTANCE.addReRegistration("plateTofu"                       , OD.listAllmeatsubstitute);
		OreDictManager.INSTANCE.addReRegistration("dustTofu"                        , OD.listAllmeatsubstitute);
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllribcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllribraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllhamcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllhamraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllbeefcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllbeefraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllchickencooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllchickenraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllfishcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllfishraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllmuttoncooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllmuttonraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllporkcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllporkraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllrabbitcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllrabbitraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllturkeycooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllturkeyraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllvenisoncooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotSoylentGreen"               , "listAllvenisonraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllribcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllribraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllhamcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllhamraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllbeefcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllbeefraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllchickencooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllchickenraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllfishcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllfishraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllmuttoncooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllmuttonraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllporkcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllporkraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllrabbitcooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllrabbitraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllturkeycooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllturkeyraw");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllvenisoncooked");
	//  OreDictManager.INSTANCE.addReRegistration("ingotTofu"                       , "listAllvenisonraw");
		OreDictManager.INSTANCE.addReRegistration("ingotMeatCooked"                 , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("ingotMeatRaw"                    , "listAllmeatraw");
		OreDictManager.INSTANCE.addReRegistration("dustMeatCooked"                  , "listAllmeatcooked");
		OreDictManager.INSTANCE.addReRegistration("dustMeatRaw"                     , "listAllmeatraw");
	//  OreDictManager.INSTANCE.addReRegistration("dustSoylentGreen"                , "listAllegg");
	//  OreDictManager.INSTANCE.addReRegistration("dustTofu"                        , "listAllegg");
		OreDictManager.INSTANCE.addReRegistration(OD.itemEgg                        , "listAllegg");
		OreDictManager.INSTANCE.addReRegistration(OD.itemEggBig                     , OD.itemEgg);
		OreDictManager.INSTANCE.addReRegistration(OD.container250seedoil            , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration(OD.container1000seedoil           , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodWhaleoil"                    , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodFishoil"                     , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodSeedoil"                     , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodHempoil"                     , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodLinoil"                      , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodOliveoil"                    , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodSunfloweroil"                , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodNutoil"                      , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodCoconutmilk"                 , "listAllcookingoil");
		OreDictManager.INSTANCE.addReRegistration("foodPeanutbutter"                , "listAllnutbutter");
		OreDictManager.INSTANCE.addReRegistration("foodAlmondbutter"                , "listAllnutbutter");
		OreDictManager.INSTANCE.addReRegistration("foodCashewbutter"                , "listAllnutbutter");
		OreDictManager.INSTANCE.addReRegistration("foodChestnutbutter"              , "listAllnutbutter");
		OreDictManager.INSTANCE.addReRegistration("foodPistachiobutter"             , "listAllnutbutter");
		OreDictManager.INSTANCE.addReRegistration("listAllsugar"                    , "honeyEqualssugar");
		OreDictManager.INSTANCE.addReRegistration("foodHoneydrop"                   , "honeyEqualssugar");
		OreDictManager.INSTANCE.addReRegistration("foodFlour"                       , "flourEqualswheat");
		OreDictManager.INSTANCE.addReRegistration("cropWheat"                       , "flourEqualswheat");
		OreDictManager.INSTANCE.addReRegistration("listAllberry"                    , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCandleberry"                 , "cropCandle");
		OreDictManager.INSTANCE.addReRegistration("cropCurrantsBlack"               , "cropCurrants");
		OreDictManager.INSTANCE.addReRegistration("cropCurrantsWhite"               , "cropCurrants");
		OreDictManager.INSTANCE.addReRegistration("cropCurrantsRed"                 , "cropCurrants");
		OreDictManager.INSTANCE.addReRegistration("cropGrapeRed"                    , "cropGrape");
		OreDictManager.INSTANCE.addReRegistration("cropGrapeWhite"                  , "cropGrape");
		OreDictManager.INSTANCE.addReRegistration("cropGrapePurple"                 , "cropGrape");
		OreDictManager.INSTANCE.addReRegistration("cropGrapeGreen"                  , "cropGrape");
		OreDictManager.INSTANCE.addReRegistration("cropAppleGreen"                  , "cropApple");
		OreDictManager.INSTANCE.addReRegistration("cropAppleYellow"                 , "cropApple");
		OreDictManager.INSTANCE.addReRegistration("cropAppleRed"                    , "cropApple");
		OreDictManager.INSTANCE.addReRegistration("cropAppleDarkRed"                , "cropApple");
		OreDictManager.INSTANCE.addReRegistration("cropAppleWhite"                  , "cropApple");
		OreDictManager.INSTANCE.addReRegistration("ingotButter"                     , "foodButter");
		OreDictManager.INSTANCE.addReRegistration("ingotSaltedButter"               , "foodButter");
		OreDictManager.INSTANCE.addReRegistration("ingotCheese"                     , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseCheddar"               , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseGorgonzola"            , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseSwiss"                 , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseAppenzeller"           , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseAsiago"                , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseParmesan"              , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseMonterey"              , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("foodCheeseRicotta"               , "foodCheese");
		OreDictManager.INSTANCE.addReRegistration("gemHoney"                        , OD.dropHoney);
		OreDictManager.INSTANCE.addReRegistration(OD.dropHoney                      , "foodHoneydrop");
		OreDictManager.INSTANCE.addReRegistration("bottleHoney"                     , "foodHoneydrop");
		OreDictManager.INSTANCE.addReRegistration("bottleCream"                     , "foodHeavycream");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.OliveOil)        , "foodOliveoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.SunflowerOil)    , "foodSunfloweroil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.NutOil)          , "foodNutoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.SeedOil)         , "foodSeedoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.HempOil)         , "foodHempoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.LinOil)          , "foodLinoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.FishOil)         , "foodFishoil");
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.WhaleOil)        , "foodWhaleoil");
		OreDictManager.INSTANCE.addReRegistration("foodApplecider"                  , "foodCider");
		OreDictManager.INSTANCE.addReRegistration("foodPeachcider"                  , "foodCider");
		OreDictManager.INSTANCE.addReRegistration("foodPearcider"                   , "foodCider");
		OreDictManager.INSTANCE.addReRegistration("foodPineapplecider"              , "foodCider");
		OreDictManager.INSTANCE.addReRegistration("foodApricotwine"                 , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodBananawine"                  , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodCherrywine"                  , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodElderberrywine"              , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodPlumwine"                    , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodBeetwine"                    , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodCarrotwine"                  , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodGrapewine"                   , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodLemonwine"                   , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodAgavewine"                   , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodCitruswine"                  , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodCranberrywine"               , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodTomatowine"                  , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodRicewine"                    , "foodWine");
		OreDictManager.INSTANCE.addReRegistration("foodBourbon"                     , "foodWhiskey");
		OreDictManager.INSTANCE.addReRegistration("foodAle"                         , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodBeer"                        , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodBrandy"                      , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodCachaca"                     , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodCider"                       , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodGin"                         , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodLiquor"                      , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodLiqueur"                     , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodMead"                        , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodRum"                         , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodTequila"                     , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodVinegar"                     , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodVodka"                       , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodWhiskey"                     , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodWine"                        , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("bottleHoneydew"                  , "listAllbeverage");
		OreDictManager.INSTANCE.addReRegistration("foodBarbecuesauce"               , "listAllcondiment");
		OreDictManager.INSTANCE.addReRegistration("foodHotsauce"                    , "listAllcondiment");
		OreDictManager.INSTANCE.addReRegistration("foodMayo"                        , "listAllcondiment");
		OreDictManager.INSTANCE.addReRegistration("foodKetchup"                     , "listAllcondiment");
		OreDictManager.INSTANCE.addReRegistration("foodMaplesyrup"                  , "listAllcondiment");
		OreDictManager.INSTANCE.addReRegistration("gemSugar"                        , "listAllsugar");
		OreDictManager.INSTANCE.addReRegistration("dustSugar"                       , "listAllsugar");
		OreDictManager.INSTANCE.addReRegistration("bottleAquaRegia"                 , OD.aquaRegia);
		OreDictManager.INSTANCE.addReRegistration("bucketAquaRegia"                 , OD.aquaRegia);
		OreDictManager.INSTANCE.addReRegistration("cellAquaRegia"                   , OD.aquaRegia);
		OreDictManager.INSTANCE.addReRegistration("bottleSulfuricAcid"              , OD.sulfuricAcid);
		OreDictManager.INSTANCE.addReRegistration("bucketSulfuricAcid"              , OD.sulfuricAcid);
		OreDictManager.INSTANCE.addReRegistration("cellSulfuricAcid"                , OD.sulfuricAcid);
		OreDictManager.INSTANCE.addReRegistration("bottleTar"                       , OD.container250tar);
		OreDictManager.INSTANCE.addReRegistration("bottleGlue"                      , OD.container250glue);
		OreDictManager.INSTANCE.addReRegistration("bottleWater"                     , OD.container250water);
		OreDictManager.INSTANCE.addReRegistration("bottleLava"                      , OD.container250lava);
		OreDictManager.INSTANCE.addReRegistration("bottleMilk"                      , OD.container250milk);
		OreDictManager.INSTANCE.addReRegistration("bottleSoymilk"                   , OD.container250soymilk);
		OreDictManager.INSTANCE.addReRegistration("bottleSoyMilk"                   , OD.container250soymilk);
		OreDictManager.INSTANCE.addReRegistration("bottleLatex"                     , OD.container250latex);
		OreDictManager.INSTANCE.addReRegistration("bottleLubricant"                 , OD.container250lubricant);
		OreDictManager.INSTANCE.addReRegistration("bottlePoison"                    , OD.container250poison);
		OreDictManager.INSTANCE.addReRegistration("itemBucketFreshWater"            , OD.container1000water);
		OreDictManager.INSTANCE.addReRegistration("itemBucketWater"                 , OD.container1000water);
		OreDictManager.INSTANCE.addReRegistration("bucketWater"                     , OD.container1000water);
		OreDictManager.INSTANCE.addReRegistration("bucketLava"                      , OD.container1000lava);
		OreDictManager.INSTANCE.addReRegistration("bucketTar"                       , OD.container1000tar);
		OreDictManager.INSTANCE.addReRegistration("bucketHoney"                     , OD.container1000honey);
		OreDictManager.INSTANCE.addReRegistration("bucketJuice"                     , OD.container1000juice);
		OreDictManager.INSTANCE.addReRegistration("bucketMilk"                      , OD.container1000milk);
		OreDictManager.INSTANCE.addReRegistration("bucketSoymilk"                   , OD.container1000soymilk);
		OreDictManager.INSTANCE.addReRegistration("bucketSoyMilk"                   , OD.container1000soymilk);
		OreDictManager.INSTANCE.addReRegistration("bucketLatex"                     , OD.container1000latex);
		OreDictManager.INSTANCE.addReRegistration("bucketSeedoil"                   , OD.container1000seedoil);
		OreDictManager.INSTANCE.addReRegistration("bucketCreosote"                  , OD.container1000creosote);
		OreDictManager.INSTANCE.addReRegistration("bucketLubricant"                 , OD.container1000lubricant);
		OreDictManager.INSTANCE.addReRegistration("bucketPoison"                    , OD.container1000poison);
		OreDictManager.INSTANCE.addReRegistration("cellWater"                       , OD.container1000water);
		OreDictManager.INSTANCE.addReRegistration("cellLava"                        , OD.container1000lava);
		OreDictManager.INSTANCE.addReRegistration("cellHoney"                       , OD.container1000honey);
		OreDictManager.INSTANCE.addReRegistration("cellJuice"                       , OD.container1000juice);
		OreDictManager.INSTANCE.addReRegistration("cellMilk"                        , OD.container1000milk);
		OreDictManager.INSTANCE.addReRegistration("cellSoymilk"                     , OD.container1000soymilk);
		OreDictManager.INSTANCE.addReRegistration("cellSoyMilk"                     , OD.container1000soymilk);
		OreDictManager.INSTANCE.addReRegistration("cellLatex"                       , OD.container1000latex);
		OreDictManager.INSTANCE.addReRegistration("cellSeedoil"                     , OD.container1000seedoil);
		OreDictManager.INSTANCE.addReRegistration("cellCreosote"                    , OD.container1000creosote);
		OreDictManager.INSTANCE.addReRegistration("cellLubricant"                   , OD.container1000lubricant);
		OreDictManager.INSTANCE.addReRegistration(OD.container250slimeblue          , OD.container250slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container250slimepink          , OD.container250slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container250slimegreen         , OD.container250slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000slimeblue         , OD.container1000slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000slimepink         , OD.container1000slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000slimegreen        , OD.container1000slime);
		OreDictManager.INSTANCE.addReRegistration(OD.container250slime              , OD.itemGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000slime             , OD.itemGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.container250glue               , OD.itemGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000glue              , OD.itemGlue);
		OreDictManager.INSTANCE.addReRegistration(OD.container250tar                , OD.itemTar);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000tar               , OD.itemTar);
		OreDictManager.INSTANCE.addReRegistration(OD.container250poison             , OD.itemPoison);
		OreDictManager.INSTANCE.addReRegistration(OD.container500poison             , OD.itemPoison);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000poison            , OD.itemPoison);
		OreDictManager.INSTANCE.addReRegistration(OD.container250lubricant          , OD.itemLubricant);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000lubricant         , OD.itemLubricant);
		OreDictManager.INSTANCE.addReRegistration(OD.container250seedoil            , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000seedoil           , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OD.itemLubricant                  , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.OliveOil)        , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.SunflowerOil)    , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.NutOil)          , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.SeedOil)         , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.HempOil)         , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.LinOil)          , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.FishOil)         , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OP.bottle.dat(MT.WhaleOil)        , OD.itemLubricantEarly);
		OreDictManager.INSTANCE.addReRegistration(OD.container1000water             , "fz.waterBucketLike");
		OreDictManager.INSTANCE.addReRegistration("fz.waterBucketLike"              , "listAllwater");
		OreDictManager.INSTANCE.addReRegistration(OD.container1000lava              , "listAlllava");
		OreDictManager.INSTANCE.addReRegistration(OD.container1000milk              , "listAllmilk");
		OreDictManager.INSTANCE.addReRegistration(OD.container1000soymilk           , "listAllmilk");
		OreDictManager.INSTANCE.addReRegistration(OD.container250water              , "listAllwater");
		OreDictManager.INSTANCE.addReRegistration(OD.container250lava               , "listAlllava");
		OreDictManager.INSTANCE.addReRegistration(OD.container250milk               , "listAllmilk");
		OreDictManager.INSTANCE.addReRegistration(OD.container250soymilk            , "listAllmilk");
		OreDictManager.INSTANCE.addReRegistration("foodSoymilk"                     , "listAllmilk");
		OreDictManager.INSTANCE.addReRegistration("foodCoconutcream"                , "listAllheavycream");
		OreDictManager.INSTANCE.addReRegistration("foodHeavycream"                  , "listAllheavycream");
		OreDictManager.INSTANCE.addReRegistration(OD.container1000juice             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration(OD.container250juice              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodAnanasjuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodApplejuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodApricotjuice"                , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodBananajuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodBlackberryjuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodBlueberryjuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCactusfruitjuice"            , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCantaloupejuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodBeetjuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCarrotjuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCherryjuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCoconutmilk"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCurrantjuice"                , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodCranberryjuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodDatejuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodDragonfruitjuice"            , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodElderberryjuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodHellderberryjuice"           , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodFigjuice"                    , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodGooseberryjuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodGrapejuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodGrapefruitjuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodKiwijuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodLemonjuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodLemonade"                    , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodLimejuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodMangojuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodMelonjuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodJuice"                       , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodOrangejuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPapayajuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPeachjuice"                  , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPearjuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPersimmonjuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPineapplejuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPlumjuice"                   , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPomegranatejuice"            , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodRaspberryjuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodStrawberryjuice"             , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodStarfruitjuice"              , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodTomatojuice"                 , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodPumpkinjuice"                , "listAlljuice");
		OreDictManager.INSTANCE.addReRegistration("foodFruitsmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCactusfruitsmoothie"         , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCantaloupesmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodBeetsmoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCarrotsmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCurrantsmoothie"             , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodDatesmoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodDragonfruitsmoothie"         , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodElderberrysmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodTomatosmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodAnanassmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodApplesmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodApricotsmoothie"             , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodBananasmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodBlackberrysmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodBlueberrysmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCherrysmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCoconutsmoothie"             , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodCranberrysmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodFigsmoothie"                 , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodGooseberrysmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodGrapefruitjellysmoothie"     , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodGrapefruitsmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodGrapesmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodKiwismoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodLemonsmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodLimesmoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodMangosmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodMelonsmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodOrangesmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPapayasmoothie"              , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPeachsmoothie"               , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPearsmoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPersimmonsmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPineapplesmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPlumsmoothie"                , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPomegranatesmoothie"         , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodRaspberrysmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodStarfruitsmoothie"           , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodStrawberrysmoothie"          , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodPumpkinsmoothie"             , "listAllsmoothie");
		OreDictManager.INSTANCE.addReRegistration("foodFruityogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCactusfruityogurt"           , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCantaloupeyogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodBeetyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCarrotyogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCurrantyogurt"               , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodDateyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodDragonfruityogurt"           , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodElderberryyogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodTomatoyogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodAnanasyogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodAppleyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodApricotyogurt"               , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodBananayogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodBlackberryyogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodBlueberryyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCherryyogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCoconutyogurt"               , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodCranberryyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodFigyogurt"                   , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodGooseberryyogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodGrapefruityogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodGrapeyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodKiwiyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodLemonyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodLimeyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodMangoyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodMelonyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodOrangeyogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPapayayogurt"                , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPeachyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPearyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPersimmonyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPineappleyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPlumyogurt"                  , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPomegranateyogurt"           , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodRaspberryyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodStarfruityogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodStrawberryyogurt"            , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPlainyogurt"                 , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodChocolateyogurt"             , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodVanillayogurt"               , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodPumpkinyogurt"               , "listAllyogurt");
		OreDictManager.INSTANCE.addReRegistration("foodFruit"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropFruit"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropAvocado"                     , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropAnanas"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropApple"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCrabapple"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropApricot"                     , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropBanana"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPlantain"                    , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCitron"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCactusfruit"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPricklyPair"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCantaloupe"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropBlackCherry"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropSourCherry"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropWildCherry"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCherry"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropDate"                        , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropDarkFruit"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropDragonfruit"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropFig"                         , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropGrape"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropGrapefruit"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropKiwi"                        , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropKumquat"                     , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropLemon"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropLime"                        , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropKeyLime"                     , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropFingerLime"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropMango"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropMelon"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropTangerine"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropOrange"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropSatsuma"                     , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropManderin"                    , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropOsangeOrange"                , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPapaya"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropNectarine"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPeach"                       , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropSandPear"                    , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPear"                        , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPersimmon"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPineapple"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPlum"                        , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCherryPlum"                  , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPomegranate"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropStarAnise"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropStarfruit"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropPomelo"                      , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropAllspice"                    , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropCandleberry"                 , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("fruitsAcresia"                   , "listAllfruit");
		OreDictManager.INSTANCE.addReRegistration("cropRowanberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropWyndberry"                   , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropJuniper"                     , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropSwampberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropHeartberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropElderberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropHellderberry"                , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropBlackberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropBlackthorn"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropBlueberry"                   , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropCranberry"                   , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropCurrants"                    , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropGooseberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropRaspberry"                   , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropStrawberry"                  , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropBerry"                       , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropAllspice"                    , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("cropCandleberry"                 , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("fruitsAcresia"                   , "listAllberry");
		OreDictManager.INSTANCE.addReRegistration("foodGrapejelly"                  , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodBlackberryjelly"             , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodMangojelly"                  , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPapayajelly"                 , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPeachjelly"                  , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPomegranatejelly"            , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodRaspberryjelly"              , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodStarfruitjelly"              , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodStrawberryjelly"             , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodWatermelonjelly"             , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodBlueberryjelly"              , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodApricotjelly"                , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodFigjelly"                    , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPersimmonjelly"              , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodGrapefruitjelly"             , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodLimejelly"                   , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodLemonjelly"                  , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodOrangejelly"                 , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodApplejelly"                  , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodCranberryjelly"              , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodKiwijelly"                   , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodCherryjelly"                 , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPearjelly"                   , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodPlumjelly"                   , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("foodGooseberryjelly"             , "listAlljelly");
		OreDictManager.INSTANCE.addReRegistration("cropGrapefruit"                  , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropLemon"                       , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropLime"                        , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropKeyLime"                     , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropFingerLime"                  , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropOrange"                      , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropSatsuma"                     , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropManderin"                    , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropTangerine"                   , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropCitron"                      , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropKiwi"                        , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropPomelo"                      , "listAllcitrus");
		OreDictManager.INSTANCE.addReRegistration("cropAsparagus"                   , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSpinach"                     , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBroccoli"                    , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCelery"                      , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropLettuce"                     , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSpiceleaf"                   , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropArtichoke"                   , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBrusselsprout"               , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCabbage"                     , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCucumber"                    , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropOkra"                        , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropPeas"                        , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSeaweed"                     , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropZucchini"                    , "listAllgreenveggie");
		OreDictManager.INSTANCE.addReRegistration("cropParsnip"                     , "listAllrootveggie");
		OreDictManager.INSTANCE.addReRegistration("cropRadish"                      , "listAllrootveggie");
		OreDictManager.INSTANCE.addReRegistration("cropRutabaga"                    , "listAllrootveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSweetpotato"                 , "listAllrootveggie");
		OreDictManager.INSTANCE.addReRegistration("cropTurnip"                      , "listAllrootveggie");
		OreDictManager.INSTANCE.addReRegistration("cropWhitemushroom"               , "listAllmushroom");
		OreDictManager.INSTANCE.addReRegistration("foodGrilledmushroom"             , "listAllmushroom");
		OreDictManager.INSTANCE.addReRegistration("cropBellpepper"                  , "listAllpepper");
		OreDictManager.INSTANCE.addReRegistration("cropChilipepper"                 , "listAllpepper");
		OreDictManager.INSTANCE.addReRegistration("cropWaterchestnut"               , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropAsparagus"                   , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSpinach"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBroccoli"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCelery"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropLettuce"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSpiceleaf"                   , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropArtichoke"                   , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBrusselsprout"               , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCabbage"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCucumber"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropOkra"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropPeas"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSeaweed"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropZucchini"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCarrot"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropPotato"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropPumpkin"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBean"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBeet"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBeetroot"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCauliflower"                 , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropLeek"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropOnion"                       , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropParsnip"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropRadish"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropRutabaga"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropScallion"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSoybean"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropSweetpotato"                 , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropTurnip"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropWhitemushroom"               , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBellpepper"                  , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropCorn"                        , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropEggplant"                    , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropRhubarb"                     , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropTomato"                      , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropWintersquash"                , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropBambooshoot"                 , "listAllveggie");
		OreDictManager.INSTANCE.addReRegistration("cropWheat"                       , "listAllwheats");
		OreDictManager.INSTANCE.addReRegistration("cropRye"                         , "listAllwheats");
		OreDictManager.INSTANCE.addReRegistration("cropBarley"                      , "listAllwheats");
		OreDictManager.INSTANCE.addReRegistration("cropOats"                        , "listAllwheats");
		OreDictManager.INSTANCE.addReRegistration("cropAbyssalOats"                 , "listAllwheats");
		OreDictManager.INSTANCE.addReRegistration("listAllseed"                     , "seeds");
		OreDictManager.INSTANCE.addReRegistration("listAllwheats"                   , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("dustWheat"                       , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("dustBarley"                      , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("dustOats"                        , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("dustAbyssalOats"                 , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("dustRye"                         , "listAllgrain");
		OreDictManager.INSTANCE.addReRegistration("cropSpiceleaf"                   , "listAllspice");
		OreDictManager.INSTANCE.addReRegistration("cropMustard"                     , "listAllspice");
		OreDictManager.INSTANCE.addReRegistration("cropGinger"                      , "listAllspice");
		OreDictManager.INSTANCE.addReRegistration("dustCurry"                       , "listAllspice");
		OreDictManager.INSTANCE.addReRegistration("cropGarlic"                      , "listAllherb");
		OreDictManager.INSTANCE.addReRegistration("cropAcorn"                       , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropHazelnut"                    , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropPecan"                       , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropPeanut"                      , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropWalnut"                      , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropAlmond"                      , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropCashew"                      , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropChestnut"                    , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropPistachio"                   , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropNutmeg"                      , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropBrazilNut"                   , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropBeechnut"                    , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropButternut"                   , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropGingkoNut"                   , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("cropCandlenut"                   , "listAllnut");
		OreDictManager.INSTANCE.addReRegistration("seedMisc"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedsAcresia"                    , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedAspectrus"                   , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedPurplePear"                  , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCamellia"                    , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedWitherShrub"                 , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedGhost"                       , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedQuartzBerry"                 , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedHellBush"                    , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedFlower"                      , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedDarkFruit"                   , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCabbage"                     , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedApple"                       , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedThistle"                     , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedTobacco"                     , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCannabis"                    , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCoca"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedHops"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedHemp"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedTea"                         , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedRice"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedOats"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedAbyssalOats"                 , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedHellderberry"                , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedWheat"                       , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedBarley"                      , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedMelon"                       , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedPumpkin"                     , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedFlax"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCanola"                      , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCotton"                      , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedStrawberry"                  , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCoffee"                      , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedBeet"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCrop"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedGrape"                       , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("seedCorn"                        , "listAllseed");
		OreDictManager.INSTANCE.addReRegistration("foodIcecream"                    , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodHoneyicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodNutellaicecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodStracciatellaicecream"       , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodChocolateicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodMochaicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodCaramelicecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodMinticecream"                , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodMintchocolatechipicecream"   , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodStrawberryicecream"          , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodVanillaicecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodCherryicecream"              , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodPistachioicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodNeapolitanicecream"          , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodSpumoniicecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodRainbowicecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodBlueberryicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodCurranticecream"             , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodBlackberryicecream"          , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodRaspberryicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodCranberryicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodGooseberryicecream"          , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodRaisinicecream"              , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodLemonicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodMapleicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodSupermanicecream"            , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodBaconicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodKiwiicecream"                , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodMelonicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodBananaicecream"              , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodGrapeicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodAppleicecream"               , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodPeanutbuttericecream"        , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodPineappleicecream"           , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodAnanasicecream"              , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodChumicecream"                , "listAllicecream");
		OreDictManager.INSTANCE.addReRegistration("foodBearicecream"                , "listAllicecream");
		
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetRed"      , new OreDictItemData(MT.Redstone, U));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetIron"     , new OreDictItemData(MT.Redstone, U, ANY.Fe, U));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetGold"     , new OreDictItemData(MT.Redstone, U, MT.Au, U));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetDiamond"  , new OreDictItemData(MT.Redstone, U, ANY.Diamond, U));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetPulsating", new OreDictItemData(MT.Redstone, U2, MT.EnderPearl, U2));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetQuartz"   , new OreDictItemData(MT.Redstone, U, ANY.SiO2, U));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetComp"     , new OreDictItemData(MT.Redstone, U*4));
		OreDictManager.INSTANCE.setAutomaticItemData("chipsetEmerald"  , new OreDictItemData(MT.Redstone, U, ANY.Emerald, U));
		OreDictManager.INSTANCE.setAutomaticItemData("ForciciumItem", new OreDictItemData(MT.Forcicium, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.itemFlint, new OreDictItemData(MT.Flint, U));
		OreDictManager.INSTANCE.setAutomaticItemData("flint", new OreDictItemData(MT.Flint, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.itemLeather, new OreDictItemData(MT.Leather, 1*U));
		OreDictManager.INSTANCE.setAutomaticItemData("leather", new OreDictItemData(MT.Leather, 1*U));
		OreDictManager.INSTANCE.setAutomaticItemData("bone", new OreDictItemData(MT.Bone, 3*U));
		OreDictManager.INSTANCE.setAutomaticItemData("hambone", new OreDictItemData(MT.MeatRaw, 2*U));
		OreDictManager.INSTANCE.setAutomaticItemData("livingRoot", new OreDictItemData(MT.LiveRoot, U));
		OreDictManager.INSTANCE.setAutomaticItemData("silicon", new OreDictItemData(MT.Si, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.blockGlassColorless, new OreDictItemData(MT.Glass, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.blockGlass         , new OreDictItemData(MT.Glass, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.paneGlassColorless , new OreDictItemData(MT.Glass, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.paneGlass          , new OreDictItemData(MT.Glass, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.glassColorless     , new OreDictItemData(MT.Glass, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.glass              , new OreDictItemData(MT.Glass, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.glowstone          , new OreDictItemData(ANY.Glowstone, 4*U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.soulsand           , new OreDictItemData(MT.SoulSand, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedWheat", new OreDictItemData(MT.Wheat, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedRye", new OreDictItemData(MT.Rye, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedOats", new OreDictItemData(MT.Oat, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedAbyssalOats", new OreDictItemData(MT.OatAbyssal, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedBarley", new OreDictItemData(MT.Barley, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedRice", new OreDictItemData(MT.Rice, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("seedCorn", new OreDictItemData(MT.Corn, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleWheat", new OreDictItemData(MT.Wheat, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleRye", new OreDictItemData(MT.Rye, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleOats", new OreDictItemData(MT.Oat, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleAbyssalOats", new OreDictItemData(MT.OatAbyssal, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleBarley", new OreDictItemData(MT.Barley, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("baleRice", new OreDictItemData(MT.Rice, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData("leafCocaDried", new OreDictItemData(MT.UNUSED.Cocaine, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropCurryleaf", new OreDictItemData(MT.Curry, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropCinnamon", new OreDictItemData(MT.Cinnamon, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropHazelnut", new OreDictItemData(MT.Hazelnut, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropPistachio", new OreDictItemData(MT.Pistachio, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropAlmond", new OreDictItemData(MT.Almond, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropPeanut", new OreDictItemData(MT.Peanut, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropNutmeg", new OreDictItemData(MT.Nutmeg, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropCoffee", new OreDictItemData(MT.Coffee, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropChilipepper", new OreDictItemData(MT.Chili, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropCocoa", new OreDictItemData(MT.Cocoa, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropWheat", new OreDictItemData(MT.Wheat, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropPotato", new OreDictItemData(MT.Potato, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropRye", new OreDictItemData(MT.Rye, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropBarley", new OreDictItemData(MT.Barley, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropOats", new OreDictItemData(MT.Oat, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropAbyssalOats", new OreDictItemData(MT.OatAbyssal, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropRice", new OreDictItemData(MT.Rice, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropCorn", new OreDictItemData(MT.Corn, U));
		OreDictManager.INSTANCE.setAutomaticItemData("cropTea", new OreDictItemData(MT.Tea, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("cropIndigo", new OreDictItemData(MT.Indigo, U9));
		OreDictManager.INSTANCE.setAutomaticItemData("cropPeppercorn", new OreDictItemData(MT.PepperBlack, U));
		OreDictManager.INSTANCE.setAutomaticItemData("foodBlackpepper", new OreDictItemData(MT.PepperBlack, U));
		OreDictManager.INSTANCE.setAutomaticItemData("foodVanilla", new OreDictItemData(MT.Vanilla, U));
		OreDictManager.INSTANCE.setAutomaticItemData("foodChocolatebar", new OreDictItemData(MT.Chocolate, U));
		OreDictManager.INSTANCE.setAutomaticItemData("foodCheese", new OreDictItemData(MT.Cheese, U));
		OreDictManager.INSTANCE.setAutomaticItemData("fuelCoke", new OreDictItemData(MT.CoalCoke, U));
		OreDictManager.INSTANCE.setAutomaticItemData("coalCoke", new OreDictItemData(MT.CoalCoke, U));
		OreDictManager.INSTANCE.setAutomaticItemData("itemCoke", new OreDictItemData(MT.CoalCoke, U));
		OreDictManager.INSTANCE.setAutomaticItemData("coke", new OreDictItemData(MT.CoalCoke, U));
		OreDictManager.INSTANCE.setAutomaticItemData("crystalCinnabar", new OreDictItemData(MT.OREMATS.Cinnabar, U));
		OreDictManager.INSTANCE.setAutomaticItemData("slabAnyWood", new OreDictItemData(ANY.Wood, U2));
		OreDictManager.INSTANCE.setAutomaticItemData("slabWood", new OreDictItemData(ANY.Wood, U2));
		OreDictManager.INSTANCE.setAutomaticItemData("stairAnyWood", new OreDictItemData(ANY.Wood, 3*U4));
		OreDictManager.INSTANCE.setAutomaticItemData("stairWood", new OreDictItemData(ANY.Wood, 3*U4));
		OreDictManager.INSTANCE.setAutomaticItemData("logAnyWood", new OreDictItemData(ANY.Wood, U*8, MT.Bark, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.logWood, new OreDictItemData(ANY.Wood, U*8, MT.Bark, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.logRubber, new OreDictItemData(MT.WoodRubber, U*8, MT.Bark, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.crateGtEmpty, new OreDictItemData(ANY.Wood, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.plankWood, new OreDictItemData(ANY.Wood, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.plankAnyWood, new OreDictItemData(ANY.Wood, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.plankWeedwood, new OreDictItemData(MT.Weedwood, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.plankSkyroot, new OreDictItemData(MT.Skyroot, U));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingChest, new OreDictItemData(ANY.Wood, U * 4));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingPiston, new OreDictItemData(MT.Stone, U * 4, ANY.Wood, U * 3));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingFurnace, new OreDictItemData(MT.Stone, U * 8));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingAnvil, new OreDictItemData(MT.Fe, U * 10));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingRedstoneTorch, new OreDictItemData(MT.Redstone, U, ANY.Wood, U2));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.craftingHardenedClay, new OreDictItemData(MT.Ceramic, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.itemRedstone, new OreDictItemData(MT.Redstone, U));
		OreDictManager.INSTANCE.setAutomaticItemData("claystone", new OreDictItemData(MT.ClayBrown, U*2));
		OreDictManager.INSTANCE.setAutomaticItemData("rocksalt", new OreDictItemData(MT.KCl, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("conglomerate", new OreDictItemData(MT.Stone, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("slate", new OreDictItemData(MT.Stone, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("phyllite", new OreDictItemData(MT.Stone, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("schist", new OreDictItemData(MT.STONES.Blueschist, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("diorite", new OreDictItemData(MT.STONES.Diorite, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData("ingotRefinedIron", new OreDictItemData(MT.Fe, U*1));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.obsidian, new OreDictItemData(MT.Obsidian, U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OD.cryingObsidian, new OreDictItemData(MT.Obsidian, U*9));
		
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Sand            ), new OreDictItemData(MT.Sand            , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.RedSand         ), new OreDictItemData(MT.RedSand         , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.SoulSand        ), new OreDictItemData(MT.SoulSand        , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.EndSandWhite    ), new OreDictItemData(MT.EndSandWhite    , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.EndSandBlack    ), new OreDictItemData(MT.EndSandBlack    , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Bedrock         ), new OreDictItemData(MT.Bedrock         , U*1));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Flint           ), new OreDictItemData(MT.Flint           , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.CaCO3           ), new OreDictItemData(MT.CaCO3           , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Talc            ), new OreDictItemData(MT.Talc            , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Chalk           ), new OreDictItemData(MT.Chalk           , U*9));
		OreDictManager.INSTANCE.setAutomaticItemData(OP.stone.dat(MT.Lignite         ), new OreDictItemData(MT.Lignite         , U  ));
	}
}
