/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import gregtech.worldgen.NoiseGenerator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenBushes
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenBushes(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (CS.BIOMES_FROZEN.contains(tName) || !CS.BIOMES_PLAINS.contains(tName) && !CS.BIOMES_WOODS.contains(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        if (!CS.BlocksGT.plantableGreens.contains(aContact) || !WD.easyRep(aWorld, aX, aY + 1, aZ)) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        ItemStack tBerry = UT.Code.select((long)new NoiseGenerator(aWorld).get(aX / 2, 300.0f, aZ / 2, CS.BushesGT.MAP.size()), new ItemStackContainer(IL.Food_Candleberry.get(1L, new Object[0])), CS.BushesGT.MAP.keySet().toArray(CS.ZL_ISC)).toStack();
        if (this.placeBushCore(aWorld, aX, aY, aZ, tRegistry, tBerry, 3)) {
            if (aRandom.nextBoolean() && this.placeBushCore(aWorld, aX - 1, aY, aZ, tRegistry, tBerry, 3)) {
                this.placeBushSides(aWorld, aX - 1, aY, aZ, tRegistry, tBerry, 3);
            }
            if (aRandom.nextBoolean() && this.placeBushCore(aWorld, aX + 1, aY, aZ, tRegistry, tBerry, 3)) {
                this.placeBushSides(aWorld, aX + 1, aY, aZ, tRegistry, tBerry, 3);
            }
            if (aRandom.nextBoolean() && this.placeBushCore(aWorld, aX, aY, aZ - 1, tRegistry, tBerry, 3)) {
                this.placeBushSides(aWorld, aX, aY, aZ - 1, tRegistry, tBerry, 3);
            }
            if (aRandom.nextBoolean() && this.placeBushCore(aWorld, aX, aY, aZ + 1, tRegistry, tBerry, 3)) {
                this.placeBushSides(aWorld, aX, aY, aZ + 1, tRegistry, tBerry, 3);
            }
            this.placeBushSides(aWorld, aX, aY, aZ, tRegistry, tBerry, 3);
            return true;
        }
        return false;
    }

    public boolean placeBushCore(World aWorld, int aX, int aY, int aZ, MultiTileEntityRegistry aRegistry, ItemStack aBerry, int aStage) {
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        if (!CS.BlocksGT.plantableGreens.contains(tBlock) || !WD.easyRep(aWorld, aX, aY + 1, aZ)) {
            return false;
        }
        if (tBlock == Blocks.grass) {
            WD.set(aWorld, aX, aY, aZ, Blocks.dirt, 0L, 3L);
        }
        return aRegistry.mBlock.placeBlock(aWorld, aX, aY + 1, aZ, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)6, "gt.state", aStage), "gt.value", aBerry), true, true);
    }

    public boolean placeBushSides(World aWorld, int aX, int aY, int aZ, MultiTileEntityRegistry aRegistry, ItemStack aBerry, int aStage) {
        if (WD.easyRep(aWorld, aX + 1, aY + 1, aZ)) {
            aRegistry.mBlock.placeBlock(aWorld, aX + 1, aY + 1, aZ, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)4, "gt.state", aStage), "gt.value", aBerry), true, true);
        }
        if (WD.easyRep(aWorld, aX - 1, aY + 1, aZ)) {
            aRegistry.mBlock.placeBlock(aWorld, aX - 1, aY + 1, aZ, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)5, "gt.state", aStage), "gt.value", aBerry), true, true);
        }
        if (WD.easyRep(aWorld, aX, aY + 1, aZ + 1)) {
            aRegistry.mBlock.placeBlock(aWorld, aX, aY + 1, aZ + 1, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)2, "gt.state", aStage), "gt.value", aBerry), true, true);
        }
        if (WD.easyRep(aWorld, aX, aY + 1, aZ - 1)) {
            aRegistry.mBlock.placeBlock(aWorld, aX, aY + 1, aZ - 1, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)3, "gt.state", aStage), "gt.value", aBerry), true, true);
        }
        if (WD.easyRep(aWorld, aX, aY + 2, aZ)) {
            aRegistry.mBlock.placeBlock(aWorld, aX, aY + 2, aZ, (byte)6, (short)32759, ST.save(UT.NBT.make("gt.facing", (Object)0, "gt.state", aStage), "gt.value", aBerry), true, true);
        }
        return true;
    }
}

