/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityLuminometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.luminometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        return aDelegator.mWorld.getBlockLightValue(aDelegator.mX, aDelegator.mY, aDelegator.mZ);
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        return 15L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_LIGHT_YELLOW_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_LUMIN;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.luminometer";
    }

    static {
        LH.add("gt.tooltip.sensor.luminometer", "Measures Light (0 - 15)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/luminometer/overlay/side");
    }
}

