/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.portals;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.WD;
import gregtech.tileentity.portals.MultiTileEntityMiniPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MultiTileEntityMiniPortalAroma
extends MultiTileEntityMiniPortal {
    public static List<MultiTileEntityMiniPortal> sListAromaSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public static List<MultiTileEntityMiniPortal> sListWorldSide = new ArrayListNoNulls<MultiTileEntityMiniPortal>();
    public ITexture sAromaPortal = BlockTextureCopied.get(ST.block(MD.A97_MINING, "aromicPortal", (Block)Blocks.portal), 6, 0, CS.UNCOLOURED, false, true, true);
    public ITexture sAromaPortalFrame = BlockTextureCopied.get(ST.block(MD.A97_MINING, "portalFrame", Blocks.stonebrick), 6, 0);

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListA() {
        return sListWorldSide;
    }

    @Override
    public List<MultiTileEntityMiniPortal> getPortalListB() {
        return sListAromaSide;
    }

    @Override
    public void addToolTips2(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.aroma.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tileentity.portal.aroma.tooltip.2"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
    }

    @Override
    public void findTargetPortal() {
        block4: {
            block5: {
                this.mTarget = null;
                if (this.worldObj == null || !this.isServerSide()) break block4;
                if (this.worldObj.provider.dimensionId != 0) break block5;
                long tShortestDistance = 16384L;
                for (MultiTileEntityMiniPortal tTarget : sListAromaSide) {
                    if (tTarget == this || tTarget.isDead()) continue;
                    long tXDifference = this.xCoord - tTarget.xCoord;
                    long tZDifference = this.zCoord - tTarget.zCoord;
                    long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                    if (tTempDist < tShortestDistance) {
                        tShortestDistance = tTempDist;
                        this.mTarget = tTarget;
                        continue;
                    }
                    if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                    this.mTarget = tTarget;
                }
                break block4;
            }
            if (!WD.dimA97(this.worldObj)) break block4;
            long tShortestDistance = 16384L;
            for (MultiTileEntityMiniPortal tTarget : sListWorldSide) {
                if (tTarget == this || tTarget.isDead()) continue;
                long tXDifference = tTarget.xCoord - this.xCoord;
                long tZDifference = tTarget.zCoord - this.zCoord;
                long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                if (tTempDist < tShortestDistance) {
                    tShortestDistance = tTempDist;
                    this.mTarget = tTarget;
                    continue;
                }
                if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.yCoord - this.yCoord) >= Math.abs(this.mTarget.yCoord - this.yCoord)) continue;
                this.mTarget = tTarget;
            }
        }
    }

    @Override
    public void addThisPortalToLists() {
        if (this.worldObj != null && this.isServerSide()) {
            if (this.worldObj.provider.dimensionId == 0) {
                if (!sListWorldSide.contains(this)) {
                    sListWorldSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListAromaSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else if (WD.dimA97(this.worldObj)) {
                if (!sListAromaSide.contains(this)) {
                    sListAromaSide.add(this);
                }
                for (MultiTileEntityMiniPortal tPortal : sListWorldSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else {
                this.setPortalInactive();
            }
        }
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("igniter")) {
            if (this.mActive) {
                this.setPortalInactive();
            } else {
                this.setPortalActive();
            }
            if (this.mTarget != null && aChatReturn != null) {
                aChatReturn.add("X: " + this.mTarget.xCoord + "   Y: " + this.mTarget.yCoord + "   Z: " + this.mTarget.zCoord);
            }
            return 10000L;
        }
        if (aTool.equals("extinguisher")) {
            if (this.mActive) {
                this.setPortalInactive();
            }
            return 10000L;
        }
        return super.onToolClick(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public float getBlockHardness() {
        return Blocks.stonebrick.getBlockHardness(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public float getExplosionResistance2() {
        return Blocks.stonebrick.getExplosionResistance(null);
    }

    @Override
    public ITexture getPortalTexture() {
        return this.sAromaPortal;
    }

    @Override
    public ITexture getFrameTexture() {
        return this.sAromaPortalFrame;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.portal.aroma";
    }

    static {
        LH.add("gt.tileentity.portal.aroma.tooltip.1", "Only works between Aroma's Mining Dimension and the Overworld!");
        LH.add("gt.tileentity.portal.aroma.tooltip.2", "Margin of Error to still work: 128 Meters.");
    }
}

