/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.plants;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.old.Textures;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.misc.MultiTileEntityTreeHole;
import gregapi.util.ST;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntitySapHoleRainbowood
extends MultiTileEntityTreeHole {
    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && !this.mHasResin && aTimer % 600L == 0L) {
            int j;
            int i;
            int tTreeHeight = this.yCoord + 1;
            int tLeavesCount = 0;
            for (i = 1; i < 12 && (this.getBlockAtSideAndDistance((byte)1, i) == CS.BlocksGT.LogB || this.getMetaDataAtSideAndDistance((byte)1, i) == 3); ++i) {
                ++tTreeHeight;
            }
            for (i = -2; i <= 2; ++i) {
                for (j = -2; j <= 2; ++j) {
                    if (this.checkLeaves(this.xCoord + i, tTreeHeight + 2, this.zCoord + j)) {
                        ++tLeavesCount;
                    }
                    if (i == 0 && j == 0 || !this.checkLeaves(this.xCoord + i, tTreeHeight - 4, this.zCoord + j)) continue;
                    ++tLeavesCount;
                }
            }
            for (i = -3; i <= 3; ++i) {
                for (j = -3; j <= 3; ++j) {
                    if (Math.abs(i * j) >= 9) continue;
                    if (i != 0 || j != 0) {
                        if (this.checkLeaves(this.xCoord + i, tTreeHeight - 1, this.zCoord + j)) {
                            ++tLeavesCount;
                        }
                        if (this.checkLeaves(this.xCoord + i, tTreeHeight - 2, this.zCoord + j)) {
                            ++tLeavesCount;
                        }
                        if (this.checkLeaves(this.xCoord + i, tTreeHeight - 3, this.zCoord + j)) {
                            ++tLeavesCount;
                        }
                    }
                    if (this.checkLeaves(this.xCoord + i, tTreeHeight, this.zCoord + j)) {
                        ++tLeavesCount;
                    }
                    if (!this.checkLeaves(this.xCoord + i, tTreeHeight + 1, this.zCoord + j)) continue;
                    ++tLeavesCount;
                }
            }
            if (tLeavesCount > 250 && this.rng(420) < tLeavesCount - 250) {
                this.mHasResin = true;
                this.updateClientData();
            }
        }
    }

    private boolean checkLeaves(int aX, int aY, int aZ) {
        return this.getBlock(aX, aY, aZ) == CS.BlocksGT.Leaves_AB && this.getMetaData(aX, aY, aZ) == 15;
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return this.isClientSide() ? super.getDrops(aFortune, aSilkTouch) : ST.arraylist(ST.make(CS.BlocksGT.LogB, 1L, 3L));
    }

    @Override
    public ItemStack getResinItem(byte aSide) {
        return null;
    }

    @Override
    public FluidStack getResinFluid(byte aSide) {
        return FL.Sap_Rainbow.make(250L);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? (aSide != this.mFacing ? BlockTextureCopied.get(CS.BlocksGT.LogB, 6, 3) : BlockTextureDefault.get(this.mHasResin ? Textures.BlockIcons.LOG_SAP_RAINBOWOOD : Textures.BlockIcons.LOG_HOLE_RAINBOWOOD)) : null;
    }

    @Override
    public float getExplosionResistance2() {
        return CS.BlocksGT.LogB.getExplosionResistance((byte)3);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tree.rainbowood.saphole";
    }
}

