/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.placeables;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.notick.TileEntityBase03MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiTileEntityRock
extends TileEntityBase03MultiTileEntities
implements IMultiTileEntity.IMTE_CanPlaceSnowLayerOnRemoval,
IMultiTileEntity.IMTE_CanEntityDestroy,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_OnToolClick,
IMultiTileEntity.IMTE_OnNeighborBlockChange,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_GetExplosionResistance,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public static final ITexture sStoneTexture = BlockTextureCopied.get(Blocks.stone);
    public ITexture mTexture = sStoneTexture;
    public ItemStack mRock;
    public float mMinX = CS.PX_P[5];
    public float mMinZ = CS.PX_P[5];
    public float mMaxX = CS.PX_N[5];
    public float mMaxY = CS.PX_P[2];
    public float mMaxZ = CS.PX_N[5];

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        Random tRandom = WD.random(this);
        this.mMinX = CS.PX_P[4 + tRandom.nextInt(4)];
        this.mMinZ = CS.PX_P[4 + tRandom.nextInt(4)];
        this.mMaxX = CS.PX_N[4 + tRandom.nextInt(4)];
        this.mMaxZ = CS.PX_N[4 + tRandom.nextInt(4)];
        this.mMaxY = CS.PX_P[1 + tRandom.nextInt(4)];
        this.mRock = ST.load(aNBT, "gt.value");
        super.readFromNBT2(aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        ST.save(aNBT, "gt.value", this.mRock);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return ST.arraylist(this.getRock(1 + this.rng(1 + aFortune)));
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && aTool.equals("magnifyingglass")) {
            if (aPlayer instanceof EntityPlayer && aSneaking) {
                ST.give(aPlayer, this.getRock(1), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                this.playCollect();
                this.setToAir();
                return 0L;
            }
            if (aChatReturn == null) {
                return 1L;
            }
            if (this.mRock == null) {
                if (this.worldObj.provider.dimensionId == -1) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely a Rack");
                    return 1L;
                }
                if (this.worldObj.provider.dimensionId == 0) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely a Rock");
                    return 1L;
                }
                if (this.worldObj.provider.dimensionId == 1) {
                    aChatReturn.add(LH.Chat.GRAY + "There is definitely an End");
                    return 1L;
                }
                if (WD.dimAETHER(this.worldObj)) {
                    aChatReturn.add(LH.Chat.GRAY + "Holy $#!T, it's a Rock..");
                    return 1L;
                }
                if (WD.dimALF(this.worldObj)) {
                    aChatReturn.add(LH.Chat.GRAY + "Wait that Rock is alive?!");
                    return 1L;
                }
                if (WD.dimTROPIC(this.worldObj)) {
                    aChatReturn.add(LH.Chat.GRAY + "Seems to be a Chunk o'Head");
                    return 1L;
                }
                if (CS.BIOMES_MOON.contains(this.getBiome().biomeName)) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely not made of Cheese");
                    return 1L;
                }
                if (CS.BIOMES_MARS.contains(this.getBiome().biomeName)) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely from Mars");
                    return 1L;
                }
                if (CS.BIOMES_SPACE.contains(this.getBiome().biomeName)) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely a Space Rock");
                    return 1L;
                }
                aChatReturn.add(LH.Chat.GRAY + "This definitely is a Rock");
                return 1L;
            }
            if (OD.itemFlint.is_(this.mRock)) {
                aChatReturn.add(LH.Chat.GRAY + (CS.APRIL_FOOLS || this.rng(CS.WOODMANS_BDAY ? 10 : (CS.XMAS_IN_JULY ? 100 : 1000)) == 0 ? "Flintstones, meet the Flintstones, they're the modern Stone Age family" : "It's a Flint"));
                return 1L;
            }
            OreDictItemData tData = OM.anydata_(this.mRock);
            if (tData != null && tData.nonemptyMaterial()) {
                if (tData.mMaterial.mMaterial == MT.MeteoricIron || tData.mMaterial.mMaterial == MT.Meteorite) {
                    aChatReturn.add(LH.Chat.ORANGE + "Looks like it fell from the Sky!");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial == MT.AncientDebris) {
                    aChatReturn.add(LH.Chat.PINK + "Looks quite old and broken");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial == MT.Stone) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely a Rock");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial == MT.Netherrack) {
                    aChatReturn.add(LH.Chat.GRAY + "This is definitely a Rack");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial == MT.Endstone) {
                    aChatReturn.add(LH.Chat.GRAY + "There is definitely an End");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial == MT.PetrifiedWood) {
                    aChatReturn.add(LH.Chat.GRAY + "Looks like a nice piece of Wood" + LH.Chat._BLACK + ">:]");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial.contains(TD.Properties.GLOWING)) {
                    aChatReturn.add(LH.Chat.YELLOW + "Glows a little");
                    return 1L;
                }
                if (tData.mMaterial.mMaterial.contains(TD.Properties.STONE)) {
                    aChatReturn.add(LH.Chat.GRAY + "This Rock consists out of " + LH.Chat.WHITE + tData.mMaterial.mMaterial.getLocal());
                    return 1L;
                }
                aChatReturn.add(LH.Chat.GRAY + "This Rock is bearing " + LH.Chat.CYAN + tData.mMaterial.mMaterial.getLocal());
                return 1L;
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ST.give((Entity)aPlayer, this.getRock(1), true, this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
        this.playCollect();
        return this.setToAir();
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        if (this.isServerSide()) {
            if (!this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord).isSideSolid((IBlockAccess)this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, CS.FORGE_DIR[1])) {
                ST.drop(this.worldObj, this.getCoords(), this.getRock(1));
                this.setToAir();
                return;
            }
            for (byte tSide : CS.ALL_SIDES_HORIZONTAL_UP) {
                if (!WD.liquid(this.getBlockAtSide(tSide))) continue;
                ST.drop(this.worldObj, this.getCoords(), this.getRock(1));
                this.setToAir();
                return;
            }
        }
    }

    public ItemStack getRock(int aAmount) {
        return this.mRock == null ? this.getDefaultRock(aAmount) : ST.amount(aAmount, this.mRock);
    }

    public ItemStack getDefaultRock(int aAmount) {
        if (this.worldObj == null || this.isClientSide()) {
            return OP.rockGt.mat(MT.Stone, (long)aAmount);
        }
        if (this.worldObj.provider.dimensionId == -1) {
            return OP.rockGt.mat(MT.Netherrack, (long)aAmount);
        }
        if (this.worldObj.provider.dimensionId == 0) {
            return OP.rockGt.mat(MT.Stone, (long)aAmount);
        }
        if (this.worldObj.provider.dimensionId == 1) {
            return OP.rockGt.mat(MT.Endstone, (long)aAmount);
        }
        if (WD.dimAETHER(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Holystone, (long)aAmount);
        }
        if (WD.dimERE(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Umber, (long)aAmount);
        }
        if (WD.dimBTL(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Betweenstone, (long)aAmount);
        }
        if (WD.dimATUM(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Limestone, (long)aAmount);
        }
        if (WD.dimTROPIC(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Basalt, (long)aAmount);
        }
        if (WD.dimALF(this.worldObj)) {
            return OP.rockGt.mat(MT.STONES.Livingrock, (long)aAmount);
        }
        if (WD.dimTF(this.worldObj)) {
            return OP.rockGt.mat(MT.Stone, (long)aAmount);
        }
        if (CS.BIOMES_MOON.contains(this.getBiome().biomeName)) {
            return OP.rockGt.mat(MT.STONES.MoonRock, (long)aAmount);
        }
        if (CS.BIOMES_MARS.contains(this.getBiome().biomeName)) {
            return OP.rockGt.mat(MT.STONES.MarsRock, (long)aAmount);
        }
        if (CS.BIOMES_SPACE.contains(this.getBiome().biomeName)) {
            return OP.rockGt.mat(MT.STONES.SpaceRock, (long)aAmount);
        }
        return OP.rockGt.mat(MT.Stone, (long)aAmount);
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] || CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTexture : null;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        if (this.worldObj == null) {
            this.mTexture = sStoneTexture;
            return 1;
        }
        if (this.hasSnow()) {
            this.mTexture = SNOW_TEXTURE;
            return 2;
        }
        Block tBlock = this.getBlockAtSide((byte)0);
        if (tBlock == CS.BlocksGT.Diggables) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.Kimberlite, 6, 0);
            return 1;
        }
        if (tBlock instanceof BlockStones || tBlock == Blocks.snow || tBlock == Blocks.stone || tBlock == Blocks.end_stone || tBlock == Blocks.obsidian) {
            this.mTexture = BlockTextureCopied.get(tBlock, 6, 0);
            return 1;
        }
        if (tBlock == Blocks.netherrack || tBlock == Blocks.nether_brick || tBlock == Blocks.soul_sand) {
            this.mTexture = BlockTextureCopied.get(Blocks.netherrack, 6, 0);
            return 1;
        }
        if (tBlock == Blocks.sandstone || tBlock == Blocks.sand || IL.AETHER_Sand.equal(tBlock)) {
            this.mTexture = BlockTextureCopied.get(Blocks.sandstone, 3, 0);
            return 1;
        }
        if (tBlock == Blocks.cobblestone || tBlock == Blocks.gravel) {
            this.mTexture = BlockTextureCopied.get(Blocks.cobblestone, 6, 0);
            return 1;
        }
        if (IL.NeLi_Gravel.equal(tBlock)) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.GraniteBlack, 6, 0);
            return 1;
        }
        if (this.worldObj.provider.dimensionId == -1) {
            this.mTexture = BlockTextureCopied.get(Blocks.netherrack);
            return 1;
        }
        if (this.worldObj.provider.dimensionId == 0) {
            this.mTexture = BlockTextureCopied.get(Blocks.stone);
            return 1;
        }
        if (this.worldObj.provider.dimensionId == 1) {
            this.mTexture = BlockTextureCopied.get(Blocks.end_stone);
            return 1;
        }
        if (WD.dimTF(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(Blocks.stone);
            return 1;
        }
        if (WD.dimERE(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(Blocks.stone, 6, 0, 9465936, false, false, false);
            return 1;
        }
        if (WD.dimBTL(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(Blocks.stone, 6, 0, 0x308030, false, false, false);
            return 1;
        }
        if (WD.dimALF(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.Marble);
            return 1;
        }
        if (WD.dimATUM(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.Limestone);
            return 1;
        }
        if (WD.dimAETHER(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.Andesite);
            return 1;
        }
        if (WD.dimTROPIC(this.worldObj)) {
            this.mTexture = BlockTextureCopied.get(CS.BlocksGT.Basalt);
            return 1;
        }
        if (CS.BIOMES_SPACE.contains(this.getBiome().biomeName)) {
            if (tBlock.getMaterial() == Material.rock) {
                this.mTexture = BlockTextureCopied.get(tBlock, this.getMetaDataAtSide((byte)0));
                return 1;
            }
            this.mTexture = BlockTextureCopied.get(Blocks.obsidian);
            return 1;
        }
        this.mTexture = BlockTextureCopied.get(Blocks.stone);
        return 1;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        this.box(aBlock, aRenderPass == 0 ? (double)this.mMinX : 0.0, 0.0, aRenderPass == 0 ? (double)this.mMinZ : 0.0, aRenderPass == 0 ? (double)this.mMaxX : 1.0, aRenderPass == 0 ? (double)this.mMaxY : (double)CS.PX_P[1], aRenderPass == 0 ? (double)this.mMaxZ : 1.0);
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, this.mMinX, 0.0, this.mMinZ, this.mMaxX, this.mMaxY, this.mMaxZ);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(this.mMinX, 0.0, this.mMinZ, this.mMaxX, this.mMaxY, this.mMaxZ);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity aEntity) {
        return !(aEntity instanceof EntityDragon);
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    public float getBlockHardness() {
        return 0.25f;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.rock";
    }
}

