/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregtech.tileentity.inventories.MultiTileEntityEnderGarbageBin;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityEnderGarbageDump
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityTapAccessible,
IMultiTileEntity.IMTE_AddToolTips {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.2"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.3"));
        aList.add(LH.Chat.RED + LH.get("gt.lang.admin.only.creation"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity((byte)0, true, false);
            if (!(tDelegate.mTileEntity instanceof MultiTileEntityEnderGarbageBin)) {
                if (!CS.GarbageGT.GARBAGE_ITEMS.isEmpty()) {
                    ST.move(this.delegator((byte)0), tDelegate);
                }
                if (!CS.GarbageGT.GARBAGE_FLUIDS.isEmpty() && tDelegate.mTileEntity instanceof IFluidHandler) {
                    FL.move_(CS.GarbageGT.GARBAGE_FLUIDS, tDelegate);
                }
            }
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < CS.GarbageGT.GARBAGE_FLUIDS.size(); ++i) {
                if (!((FluidTankGT)CS.GarbageGT.GARBAGE_FLUIDS.get(i)).has()) continue;
                return (IFluidTank)CS.GarbageGT.GARBAGE_FLUIDS.get(i);
            }
        } else {
            for (int i = 0; i < CS.GarbageGT.GARBAGE_FLUIDS.size(); ++i) {
                if (!((FluidTankGT)CS.GarbageGT.GARBAGE_FLUIDS.get(i)).contains(aFluidToDrain)) continue;
                return (IFluidTank)CS.GarbageGT.GARBAGE_FLUIDS.get(i);
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return CS.GarbageGT.GARBAGE_FLUIDS.isEmpty() ? new FluidTankGT().AS_ARRAY : (IFluidTank[])CS.GarbageGT.GARBAGE_FLUIDS.toArray(CS.ZL_FT);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return ST.arraylist(new ItemStack[0]);
    }

    @Override
    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        ItemStack tStack = (ItemStack)CS.GarbageGT.GARBAGE_ITEMS.get(aSlot);
        if (tStack == null) {
            return null;
        }
        if ((aDecrement = Math.min(tStack.stackSize, aDecrement)) <= 0) {
            return null;
        }
        ItemStack rStack = ST.amount(aDecrement, tStack);
        tStack.stackSize -= aDecrement;
        this.updateInventory();
        return rStack;
    }

    @Override
    public ItemStack getStackInSlot(int aSlot) {
        return (ItemStack)CS.GarbageGT.GARBAGE_ITEMS.get(aSlot);
    }

    @Override
    public int getSizeInventory() {
        return CS.GarbageGT.GARBAGE_ITEMS.size();
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        ((ItemStack)CS.GarbageGT.GARBAGE_ITEMS.get((int)aSlot)).stackSize = aStack == null ? 0 : aStack.stackSize;
        this.updateInventory();
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return ((ItemStack)CS.GarbageGT.GARBAGE_ITEMS.get((int)aSlot)).stackSize > 0;
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        for (FluidTankGT tTank : CS.GarbageGT.GARBAGE_FLUIDS) {
            if (!tTank.has() || FL.gas(tTank)) continue;
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : CS.GarbageGT.GARBAGE_FLUIDS) {
            if (!tTank.has()) continue;
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        return CS.NF;
    }

    @Override
    public FluidStack nozzleDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        for (FluidTankGT tTank : CS.GarbageGT.GARBAGE_FLUIDS) {
            if (!tTank.has() || !FL.gas(tTank)) continue;
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : CS.GarbageGT.GARBAGE_FLUIDS) {
            if (!tTank.has()) continue;
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        return CS.NF;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.ender.garbage.dump";
    }

    @Override
    public int getInventoryStackLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_IS;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    static {
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.1", "This is where all the Trash Bin Items & Fluids go to");
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.2", "Accesses the Garbage Dimension to retrieve Trash.");
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.3", "If used properly, people could for example 'donate' Resources.");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/side")};
    }
}

