/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityEnderGarbageBin
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityFunnelAccessible,
IMultiTileEntity.IMTE_AddToolTips {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.2"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.3"));
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && (aTimer % 100L == 50L || this.mBlockUpdated) && !this.hasRedstoneIncoming()) {
            CS.GarbageGT.trash(this.getInventory());
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        if (this.hasRedstoneIncoming()) {
            return null;
        }
        for (int i = 0; i < CS.GarbageGT.GARBAGE_FLUIDS.size(); ++i) {
            if (!((FluidTankGT)CS.GarbageGT.GARBAGE_FLUIDS.get(i)).contains(aFluidToFill)) continue;
            return (IFluidTank)CS.GarbageGT.GARBAGE_FLUIDS.get(i);
        }
        FluidTankGT tTank = new FluidTankGT().setPreventDraining().setVoidExcess();
        CS.GarbageGT.GARBAGE_FLUIDS.add(tTank);
        return tTank;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return new FluidTankGT().AS_ARRAY;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] ? 0 : this.fill(CS.FORGE_DIR[aSide], aFluid, aDoFill);
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? 0.0f : CS.PX_P[1];
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? 1.0f : CS.PX_P[14];
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return this.getSurfaceSize(aSide);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 2;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
        } else {
            this.box(aBlock, CS.PX_P[1], CS.PX_P[0], CS.PX_P[1], CS.PX_N[1], CS.PX_N[4], CS.PX_N[1]);
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return (aRenderPass == 0 ? aSide == 0 || aShouldSideBeRendered[aSide] : aSide != 1 && (aSide != 0 || aShouldSideBeRendered[aSide])) ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.ender.garbage.bin";
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[9];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.inventory, this, aGUIID, CS.RES_PATH_GUI + "machines/Trash.png");
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.inventory, this, aGUIID);
    }

    static {
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.1", "Trash Bin deleting Items & Fluids, or moving them to the Servers Garbage Dump");
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.2", "Items & Fluids entering this will be dumped inside the Garbage Dimension");
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.3", "You can stop this from operating using a simple Redstone Signal");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/side")};
    }
}

