/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.extenders;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Holo;
import gregapi.oredict.OreDictItemData;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.logistics.ITileEntityLogisticsSemiFilteredItem;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.extenders.MultiTileEntityExtender;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;

public class MultiTileEntityFilter
extends MultiTileEntityExtender
implements ITileEntityLogisticsSemiFilteredItem {
    public ItemStack[] mFilter = new ItemStack[54];
    public boolean mInverted = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.inverted")) {
            this.mInverted = aNBT.getBoolean("gt.inverted");
        }
        for (int i = 0; i < this.mFilter.length; ++i) {
            this.mFilter[i] = ST.load(aNBT, "gt.invfilter." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.inverted", this.mInverted);
        for (int i = 0; i < this.mFilter.length; ++i) {
            ST.save(aNBT, "gt.invfilter." + i, this.mFilter[i]);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.inverted", this.mInverted);
        for (int i = 0; i < this.mFilter.length; ++i) {
            ST.save(aNBT, "gt.invfilter." + i, this.mFilter[i]);
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        return this.delegator(aSide);
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUIClientFilter(aPlayer.inventory, this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUICommonFilter(aPlayer.inventory, this, aGUIID);
    }

    @Override
    public int getSizeInventoryGUI() {
        return this.mFilter == null ? 0 : this.mFilter.length;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mFilter[aSlot];
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        this.mInventoryChanged = true;
        if (this.mFilter[aSlot] != null) {
            if (this.mFilter[aSlot].stackSize <= aDecrement) {
                ItemStack tStack = this.mFilter[aSlot];
                this.mFilter[aSlot] = null;
                return tStack;
            }
            ItemStack rStack = this.mFilter[aSlot].splitStack(aDecrement);
            if (this.mFilter[aSlot].stackSize <= 0) {
                this.mFilter[aSlot] = null;
            }
            return rStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        ItemStack rStack = this.mFilter[aSlot];
        this.mFilter[aSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.mInventoryChanged = true;
        this.mFilter[aSlot] = OM.get(aStack);
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return 1;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.filter";
    }

    public boolean allowInput(ItemStack aStack) {
        for (ItemStack tStack : this.mFilter) {
            if (!ST.valid(tStack) || !ST.equal_(tStack, aStack, !tStack.hasTagCompound() || ST.meta_(tStack) == Short.MAX_VALUE)) continue;
            return !this.mInverted;
        }
        return this.mInverted;
    }

    public boolean allowInput(FluidStack aFluid) {
        return aFluid != null && this.allowInput(aFluid.getFluid());
    }

    public boolean allowInput(Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        for (ItemStack tStack : this.mFilter) {
            if (!IL.Display_Fluid.equal(tStack, true, true) || FL.id(aFluid) != ST.meta_(tStack)) continue;
            return !this.mInverted;
        }
        return this.mInverted;
    }

    @Override
    public ItemStackSet<ItemStackContainer> getLogisticsFilter(byte aSide) {
        return this.mInverted ? null : ST.hashset(this.mFilter);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("screwdriver")) {
            boolean bl = this.mInverted = !this.mInverted;
            if (aChatReturn != null) {
                aChatReturn.add(this.mInverted ? "Blacklist Filter" : "Whitelist Filter");
            }
            return 2000L;
        }
        if (aTool.equals("softhammer")) {
            this.mInverted = false;
            for (int i = 0; i < this.mFilter.length; ++i) {
                this.mFilter[i] = null;
            }
            if (aChatReturn != null) {
                aChatReturn.add("Cleared the Filter");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mInverted ? "Blacklist Filter" : "Whitelist Filter");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).isItemValidForSlot(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).canInsertItem(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).canExtractItem(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluid)) {
                return 0;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluid)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aToDrain, boolean aDoDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, null)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return aSide == this.mFacing || this.allowInput(((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, false)) ? ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, aDoDrain) : null;
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientFilter
    extends ContainerClient {
        private int mRows;

        public MultiTileEntityGUIClientFilter(InventoryPlayer aInventoryPlayer, MultiTileEntityFilter aTileEntity, int aGUIID) {
            super(new MultiTileEntityGUICommonFilter(aInventoryPlayer, aTileEntity, aGUIID), CS.RES_PATH_GUI + "machines/Filter.png");
            this.mRows = this.mContainer.mTileEntity.getSizeInventoryGUI() / 9 + (this.mContainer.mTileEntity.getSizeInventoryGUI() % 9 == 0 ? 0 : 1);
            this.ySize = 114 + this.mRows * 18;
        }

        @Override
        protected void drawGuiContainerForegroundLayer(int p_146979_1_, int p_146979_2_) {
            this.fontRendererObj.drawString(this.mContainer.mTileEntity.getInventoryNameGUI(), 8, 6, 0x404040);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 94, 0x404040);
        }

        @Override
        protected void drawGuiContainerBackgroundLayer2(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k = (this.width - this.xSize) / 2;
            int l = (this.height - this.ySize) / 2;
            this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.mRows * 18 + 17);
            this.drawTexturedModalRect(k, l + this.mRows * 18 + 17, 0, 126, this.xSize, 96);
        }
    }

    public class MultiTileEntityGUICommonFilter
    extends ContainerCommon {
        public MultiTileEntityGUICommonFilter(InventoryPlayer aInventoryPlayer, MultiTileEntityFilter aTileEntity, int aGUIID) {
            super(aInventoryPlayer, aTileEntity, aGUIID);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            int tSize = this.mTileEntity.getSizeInventoryGUI();
            int tRows = tSize / 9 + (tSize % 9 == 0 ? 0 : 1);
            int i = 0;
            for (int y = 0; y < tRows; ++y) {
                for (int x = 0; x < 9 && i < tSize; ++x) {
                    this.addSlotToContainer(new Slot_Holo(this.mTileEntity, i++, 8 + x * 18, 18 + y * 18, true, false, 1));
                }
            }
            return 103 + (tRows - 4) * 18;
        }

        @Override
        public int getSlotCount() {
            return 0;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 0;
        }

        @Override
        public ItemStack slotClick(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
            if (aSlotIndex < 0 || aSlotIndex >= this.inventorySlots.size()) {
                return super.slotClick(aSlotIndex, aMouseclick, aShifthold, aPlayer);
            }
            if (aSlotIndex >= this.mTileEntity.getSizeInventoryGUI()) {
                ItemStack tStack;
                if (aShifthold != 1) {
                    return super.slotClick(aSlotIndex, aMouseclick, aShifthold, aPlayer);
                }
                Slot tSlot = (Slot)this.inventorySlots.get(aSlotIndex);
                if (tSlot != null && (tStack = tSlot.getStack()) != null) {
                    if ((((MultiTileEntityFilter)this.mTileEntity).mModes & 1) == 0) {
                        FluidStack tFluid = FL.getFluid(tStack, true);
                        if (tFluid != null && ((MultiTileEntityFilter)this.mTileEntity).allowInput(tFluid) == ((MultiTileEntityFilter)this.mTileEntity).mInverted) {
                            for (int i = 0; i < ((MultiTileEntityFilter)this.mTileEntity).mFilter.length; ++i) {
                                if (!ST.invalid(((MultiTileEntityFilter)this.mTileEntity).mFilter[i])) continue;
                                ((MultiTileEntityFilter)this.mTileEntity).mFilter[i] = FL.display(tFluid.getFluid());
                                this.detectAndSendChanges();
                                return null;
                            }
                        }
                    } else if (((MultiTileEntityFilter)this.mTileEntity).allowInput(tStack) == ((MultiTileEntityFilter)this.mTileEntity).mInverted) {
                        for (int i = 0; i < ((MultiTileEntityFilter)this.mTileEntity).mFilter.length; ++i) {
                            if (!ST.invalid(((MultiTileEntityFilter)this.mTileEntity).mFilter[i])) continue;
                            ((MultiTileEntityFilter)this.mTileEntity).mFilter[i] = ST.amount(1L, tStack);
                            this.detectAndSendChanges();
                            return null;
                        }
                    }
                }
                return null;
            }
            Slot tSlot = (Slot)this.inventorySlots.get(aSlotIndex);
            if (tSlot != null) {
                ItemStack tStack = aPlayer.inventory.getItemStack();
                if (tStack == null) {
                    tStack = tSlot.getStack();
                    if (aMouseclick == 0) {
                        tSlot.putStack(null);
                    } else if (tStack != null && !IL.Display_Fluid.equal(tStack, true, true)) {
                        OreDictItemData tData;
                        FluidStack tFluid = null;
                        if ((((MultiTileEntityFilter)this.mTileEntity).mModes & 2) != 0 && (tFluid = FL.getFluid(tStack, true)) == null && (tData = OM.anyassociation_(tStack)) != null && tData.mPrefix.contains(TD.Prefix.IS_CONTAINER) && !tData.mPrefix.contains(TD.Prefix.IS_CRATE)) {
                            tFluid = tData.mMaterial.mMaterial.fluid(648648000L, true);
                        }
                        if (FL.valid(tFluid)) {
                            tSlot.putStack(FL.display(tFluid.getFluid()));
                        } else if (tStack.hasTagCompound()) {
                            tStack.setTagCompound(null);
                        } else {
                            ST.meta(tStack, 32767L);
                        }
                    }
                } else if ((((MultiTileEntityFilter)this.mTileEntity).mModes & 1) != 0) {
                    tSlot.putStack(ST.amount(1L, tStack));
                } else {
                    OreDictItemData tData;
                    FluidStack tFluid = FL.getFluid(tStack, true);
                    if (tFluid == null && (tData = OM.anyassociation_(tStack)) != null) {
                        tFluid = tData.mMaterial.mMaterial.fluid(648648000L, true);
                    }
                    if (FL.valid(tFluid)) {
                        tSlot.putStack(FL.display(tFluid.getFluid()));
                    }
                }
            }
            return null;
        }
    }
}

