/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.extenders;

import gregapi.GT_API;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.connectors.ITileEntityItemPipe;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityBridge
extends TileEntityBase07Paintable
implements ITileEntityDelegating,
ITileEntityAdjacentInventoryUpdatable,
IFluidHandler,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_AddToolTips {
    public byte mModes = 0;
    protected IIconContainer[] mTextures = CS.L6_IICONCONTAINER;
    public byte mLastSide = (byte)6;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mode")) {
            this.mModes = aNBT.getByte("gt.mode");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.hasKey("gt.texture")) {
                String tTextureName = aNBT.getString("gt.texture");
                this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/extenders/" + tTextureName + "/overlay/side")};
            } else {
                TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), (int)this.getMultiTileEntityID());
                if (tCanonicalTileEntity instanceof MultiTileEntityBridge) {
                    this.mTextures = ((MultiTileEntityBridge)tCanonicalTileEntity).mTextures;
                }
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if ((this.mModes & 0x1F) == 31) {
            aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_ALL));
        } else {
            if ((this.mModes & 1) == 1) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_INVENTORY));
            }
            if ((this.mModes & 2) == 2) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_TANK));
            }
            if ((this.mModes & 4) == 4) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_REDSTONE));
            }
            if ((this.mModes & 0x10) == 16) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_CONTROL));
            }
            if ((this.mModes & 8) == 8) {
                aList.add(LH.Chat.CYAN + LH.get(TOOLTIP_EXTENDER_OTHER));
            }
        }
        aList.add(LH.Chat.ORANGE + LH.get(TOOLTIP_EXTENDER_EXCLUSIVE));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && this.mBlockUpdated && (this.mModes & 4) == 0) {
            this.causeBlockUpdate();
        }
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        return BlockTextureMulti.get(BlockTextureDefault.get(this.mTextures[0], this.mRGBa), BlockTextureDefault.get(this.mTextures[1]));
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tDelegate.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable) {
                ((ITileEntityAdjacentInventoryUpdatable)tDelegate.mTileEntity).adjacentInventoryUpdated(tDelegate.mSideOfTileEntity, aTileEntity);
            }
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bridge";
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        if ((this.mModes & 0x1F) == 31) {
            return this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
        }
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<TileEntity> rDelegator = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (rDelegator.mTileEntity instanceof ITileEntityItemPipe) {
                return rDelegator;
            }
        }
        return this.delegator(aSide);
    }

    @Override
    public boolean isExtender(byte aSide) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return (this.mModes & 4) == 0 ? 0 : (int)this.getComparatorIncoming(CS.OPOS[aSide]);
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (this.mModes & 4) == 0 ? (byte)0 : this.getRedstoneIncoming(CS.OPOS[aSide]);
    }

    @Override
    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).decrStackSize(aSlot, aDecrement);
            }
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int aSlot) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).getStackInSlotOnClosing(aSlot);
            }
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlot(int aSlot) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).getStackInSlot(aSlot);
            }
        }
        return null;
    }

    @Override
    public String getInventoryName() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).getInventoryName();
            }
        }
        return super.getInventoryName();
    }

    @Override
    public int getSizeInventory() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).getSizeInventory();
            }
        }
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).getInventoryStackLimit();
            }
        }
        return 0;
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                ((IInventory)tTileEntity.mTileEntity).setInventorySlotContents(aSlot, aStack);
            }
        }
    }

    @Override
    public boolean hasCustomInventoryName() {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).hasCustomInventoryName();
            }
        }
        return this.getCustomName() != null;
    }

    @Override
    public boolean isItemValidForSlot(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).isItemValidForSlot(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).getAccessibleSlotsFromSide((int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return UT.Code.getAscendingArray(((IInventory)tTileEntity.mTileEntity).getSizeInventory());
            }
        }
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).canInsertItem(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).canExtractItem(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluid)) {
                return 0;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), aFluid, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean doDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluid)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aFluid, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, null)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), maxDrain, doDrain);
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        if ((this.mModes & 2) != 0) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(UT.Code.side(aDirection)), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).getTankInfo(tTileEntity.getForgeSideOfTileEntity());
            }
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    public boolean getStateRunningPossible() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningPossible) {
                return ((ITileEntityRunningPossible)tTileEntity.mTileEntity).getStateRunningPossible();
            }
        }
        return false;
    }

    public boolean getStateRunningPassively() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningPassively) {
                return ((ITileEntityRunningPassively)tTileEntity.mTileEntity).getStateRunningPassively();
            }
        }
        return false;
    }

    public boolean getStateRunningActively() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningActively) {
                return ((ITileEntityRunningActively)tTileEntity.mTileEntity).getStateRunningActively();
            }
        }
        return false;
    }

    public boolean getStateRunningSuccessfully() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityRunningSuccessfully) {
                return ((ITileEntityRunningSuccessfully)tTileEntity.mTileEntity).getStateRunningSuccessfully();
            }
        }
        return false;
    }

    public boolean getStateOnOff() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableOnOff) {
                return ((ITileEntitySwitchableOnOff)tTileEntity.mTileEntity).getStateOnOff();
            }
        }
        return false;
    }

    public byte getStateMode() {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableMode) {
                return ((ITileEntitySwitchableMode)tTileEntity.mTileEntity).getStateMode();
            }
        }
        return 0;
    }

    public boolean setStateOnOff(boolean aOnOff) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableOnOff) {
                return ((ITileEntitySwitchableOnOff)tTileEntity.mTileEntity).setStateOnOff(aOnOff);
            }
        }
        return false;
    }

    public byte setStateMode(byte aMode) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide((byte)6), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntitySwitchableMode) {
                return ((ITileEntitySwitchableMode)tTileEntity.mTileEntity).setStateMode(aMode);
            }
        }
        return 0;
    }

    public long getProgressValue(byte aSide) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityProgress) {
                return ((ITileEntityProgress)tTileEntity.mTileEntity).getProgressValue(tTileEntity.mSideOfTileEntity);
            }
        }
        return 0L;
    }

    public long getProgressMax(byte aSide) {
        if ((this.mModes & 0x10) != 0) {
            DelegatorTileEntity<TileEntity> tTileEntity = this.getAdjacentTileEntity(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity instanceof ITileEntityProgress) {
                return ((ITileEntityProgress)tTileEntity.mTileEntity).getProgressMax(tTileEntity.mSideOfTileEntity);
            }
        }
        return 0L;
    }

    public byte getExtenderTargetSide(byte aSide) {
        return CS.OPOS[aSide];
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer aPlayer) {
        return aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openInventory() {
    }

    @Override
    public void closeInventory() {
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }
}

