/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.generators;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.FM;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityGeneratorLiquid
extends TileEntityBase09FacingSingle
implements IFluidHandler,
ITileEntityTapAccessible,
ITileEntityEnergy,
ITileEntityRunningActively,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    private static int FLAME_RANGE = 2;
    protected byte mCooldown = 0;
    protected short mEfficiency = (short)10000;
    protected long mEnergy = 0L;
    protected long mRate = 1L;
    protected boolean mBurning = false;
    protected boolean oBurning = false;
    protected TagData mEnergyTypeEmitted = TD.Energy.HU;
    protected Recipe.RecipeMap mRecipes = FM.Burn;
    protected Recipe mLastRecipe = null;
    protected FluidTankGT mTank = new FluidTankGT(1000L);
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/colored/back")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay/back")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/top"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/left"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/right"), new Textures.BlockIcons.CustomIcon("machines/generators/burning_liquid/overlay_active/back")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        this.mBurning = aNBT.getBoolean("gt.active");
        if (aNBT.hasKey("gt.cooldown")) {
            this.mCooldown = aNBT.getByte("gt.cooldown");
        }
        if (aNBT.hasKey("gt.output")) {
            this.mRate = aNBT.getLong("gt.output");
        }
        if (aNBT.hasKey("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.getString("gt.fuelmap"));
        }
        if (aNBT.hasKey("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.getShort("gt.eff"));
        }
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
        this.mTank.setCapacity(this.mRate * 10L);
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.cooldown", this.mCooldown);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mBurning);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        LH.addEnergyToolTips(this, aList, null, this.mEnergyTypeEmitted, null, LH.get("gt.lang.face.top"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.air.front"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.inventory") + " (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.fire") + " (" + (FLAME_RANGE + 1) + "m)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mBurning || this.mCooldown > 0) {
                if (this.mEnergy >= this.mRate) {
                    ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, 1L, Math.min(this.mRate, this.mEnergy), this);
                    this.mEnergy -= this.mRate;
                    if (this.mEfficiency < 1 || this.rng(this.mEfficiency) == 0) {
                        WD.fire(this.worldObj, this.xCoord - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.yCoord - 1 + this.rng(2 + FLAME_RANGE), this.zCoord - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), true);
                    }
                }
                if (this.mEnergy < this.mRate * 2L) {
                    this.mBurning = false;
                    WD.burn(this.worldObj, this.getOffset(this.mFacing, 1), true, true);
                    if (!WD.hasCollide(this.worldObj, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing)) && !this.getBlockAtSide(this.mFacing).getMaterial().isLiquid() && WD.oxygen(this.worldObj, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing))) {
                        Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, true, Long.MAX_VALUE, CS.NI, this.mTank.AS_ARRAY, CS.ZL_IS);
                        if (tRecipe != null && tRecipe.isRecipeInputEqual(true, false, this.mTank.AS_ARRAY, CS.ZL_IS)) {
                            this.mBurning = true;
                            this.mCooldown = (byte)100;
                            this.mLastRecipe = tRecipe;
                            this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                            while (this.mEnergy < this.mRate * 2L && tRecipe.isRecipeInputEqual(true, false, this.mTank.AS_ARRAY, CS.ZL_IS)) {
                                this.mEnergy += UT.Code.units(tRecipe.getAbsoluteTotalPower(), 10000L, this.mEfficiency, false);
                                if (!this.mTank.isEmpty()) continue;
                                break;
                            }
                        } else {
                            this.mTank.setEmpty();
                        }
                    } else {
                        this.mCooldown = 0;
                    }
                }
                if (this.mEnergy < this.mRate) {
                    this.mBurning = false;
                }
            } else if (this.rng(200) == 0 && WD.flaming(this.worldObj, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing))) {
                this.mBurning = true;
            }
            if (this.mEnergy < 0L) {
                this.mEnergy = 0L;
            }
            if (this.mCooldown > 0) {
                this.mCooldown = (byte)(this.mCooldown - 1);
            }
        } else if (this.mBurning && this.rng(5) == 0) {
            this.spawnBurningParticles((double)this.xCoord + 0.5 + (double)CS.OFFX[this.mFacing] * 0.55 + (CS.SIDES_AXIS_X[this.mFacing] ? 0.0 : (double)CS.RNGSUS.nextFloat() * 0.6 - 0.3), (double)this.yCoord + (double)CS.RNGSUS.nextFloat() * 0.375, (double)this.zCoord + 0.5 + (double)CS.OFFZ[this.mFacing] * 0.55 + (CS.SIDES_AXIS_Z[this.mFacing] ? 0.0 : (double)CS.RNGSUS.nextFloat() * 0.6 - 0.3));
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("igniter") && (aSide == this.mFacing || aPlayer == null)) {
            this.mBurning = true;
            this.mCooldown = (byte)100;
            return 10000L;
        }
        if (aTool.equals("extinguisher") && (aSide == this.mFacing || aPlayer == null)) {
            this.mBurning = false;
            this.mCooldown = 0;
            return 10000L;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mTank.content());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mBurning != this.oBurning || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oBurning = this.mBurning;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mBurning = (aData & 1) != 0;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mBurning ? 1 : 0);
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return this.mBurning ? CS.SIDES_THIS[this.mFacing] : CS.SIDES_HORIZONTAL;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, CS.NI) && !FL.gas(aFluidToFill) ? this.mTank : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mBurning || this.mCooldown > 0 ? null : this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        this.updateInventory();
        return this.mTank.drain(aMaxDrain, aDoDrain);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACING_ROTATIONS[this.mFacing][aSide]], this.mRGBa), BlockTextureDefault.get((this.mBurning ? sOverlaysActive : sOverlays)[CS.FACING_ROTATIONS[this.mFacing][aSide]])) : null;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mBurning || this.mCooldown > 0) {
            UT.Entities.applyHeatDamage(aEntity, Math.min(10.0f, (float)this.mRate / 10.0f));
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_IS;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return CS.SIDES_TOP[aSide] && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return Math.min(this.mRate, this.mEnergy);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mRate;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mBurning;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mBurning || this.mTank.has() && !WD.hasCollide(this.worldObj, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing)) && !this.getBlockAtSide(this.mFacing).getMaterial().isLiquid() && WD.oxygen(this.worldObj, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing));
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mBurning;
    }

    @Override
    public float getBlockHardness() {
        return this.mBurning ? super.getBlockHardness() * 16.0f : super.getBlockHardness();
    }

    protected void spawnBurningParticles(double aX, double aY, double aZ) {
        this.worldObj.spawnParticle("smoke", aX, aY, aZ, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("flame", aX, aY, aZ, 0.0, 0.0, 0.0);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.burning_liquid";
    }
}

