/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.converters;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyFluxHandler;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityEngineSteam
extends TileEntityBase09FacingSingle
implements ITileEntityAdjacentOnOff,
ITileEntityEnergyFluxHandler,
ITileEntityRunningActively,
IFluidHandler {
    public static final int[] sEngineColors = new int[]{255, 4590, 8925, 13260, 17595, 21930, 26265, 30600, 34935, 39270, 43605, 47940, 52275, 56610, 60945, 65280, 65280, 0x11EE00, 0x22DD00, 0x33CC00, 0x44BB00, 0x55AA00, 0x669900, 0x778800, 0x887700, 0x996600, 0xAA5500, 0xBB4400, 0xCC3300, 0xDD2200, 0xEE1100, 0xFF0000};
    public static final int STEAM_PER_WATER = 200;
    protected boolean mEmitsEnergy = false;
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected boolean oActive = false;
    protected byte mState = 0;
    protected byte oState = 0;
    protected byte mPiston = 0;
    protected short mEfficiency = (short)10000;
    protected long mEnergy = 0L;
    protected long mCapacity = 640000L;
    protected long mOutput = 64L;
    protected TagData mEnergyTypeEmitted = TD.Energy.KU;
    protected FluidTankGT mTank = new FluidTankGT(640L);
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/front"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/back"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/cage"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/pipe_side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/pipe"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/engine"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/colored/engine_hull")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/cage"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/pipe_side"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/pipe"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/engine"), new Textures.BlockIcons.CustomIcon("machines/engines/kinetic_steam/overlay/engine_hull")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        if (aNBT.hasKey("gt.visual")) {
            this.mState = aNBT.getByte("gt.visual");
        }
        if (aNBT.hasKey("gt.piston")) {
            this.mPiston = aNBT.getByte("gt.piston");
        }
        if (aNBT.hasKey("gt.active")) {
            this.mActive = aNBT.getBoolean("gt.active");
        }
        if (aNBT.hasKey("gt.stopped")) {
            this.mStopped = aNBT.getBoolean("gt.stopped");
        }
        if (aNBT.hasKey("gt.capacity")) {
            this.mCapacity = aNBT.getLong("gt.capacity");
        }
        if (aNBT.hasKey("gt.active.energy")) {
            this.mEmitsEnergy = aNBT.getBoolean("gt.active.energy");
        }
        if (aNBT.hasKey("gt.output")) {
            this.mOutput = aNBT.getLong("gt.output");
        }
        if (aNBT.hasKey("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.getShort("gt.eff"));
        }
        if (aNBT.hasKey("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.getString("gt.energy.emitted"));
        }
        this.mTank.readFromNBT(aNBT, "gt.tank.0").setCapacity(200L * this.mOutput * 2L);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        aNBT.setByte("gt.visual", this.mState);
        aNBT.setByte("gt.piston", this.mPiston);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
        aNBT.setShort("gt.eff", this.mEfficiency);
        this.mTank.writeToNBT(aNBT, "gt.tank.0");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " " + 200 + " L " + FL.name(FL.Steam.make(0L), true) + " " + LH.get("gt.lang.energy.convert.to") + " " + 200 / CS.STEAM_PER_EU + " " + this.mEnergyTypeEmitted.getLocalisedNameShort());
        aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + UT.Code.units(this.mOutput * (long)CS.STEAM_PER_EU, this.mEfficiency * 2, 10000L, false) + " - " + UT.Code.units(this.mOutput * 2L * (long)CS.STEAM_PER_EU, this.mEfficiency, 10000L, false) + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.back") + ")");
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mTank.capacity() + " " + TD.Energy.STEAM.getLocalisedChatNameLong() + LH.Chat.WHITE);
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.output") + ": " + LH.Chat.WHITE + this.mOutput / 2L + " - " + this.mOutput * 2L + " " + this.mEnergyTypeEmitted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t (" + LH.get("gt.lang.face.front") + ")");
        aList.add(LH.Chat.RED + LH.get("gt.lang.energy.capacity") + ": " + LH.Chat.WHITE + this.mCapacity + " " + this.mEnergyTypeEmitted.getLocalisedChatNameShort() + LH.Chat.WHITE);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.emits.used.steam") + " (" + LH.get("gt.lang.face.sides") + ", 80%)");
        aList.add(LH.getToolTipRedstoneFluxEmit(this.mEnergyTypeEmitted));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (this.mActive && aTimer % (long)(32 - this.mState) == 0L) {
            this.mPiston = (byte)(this.mPiston + 1);
            this.mPiston = (byte)(this.mPiston & 3);
        }
        if (aIsServerSide) {
            long tConversions;
            if (!this.mStopped && (tConversions = this.mTank.amount() / 200L) > 0L) {
                this.mEnergy += UT.Code.units(tConversions * 200L / (long)CS.STEAM_PER_EU, 10000L, this.mEfficiency, false);
                this.mTank.remove(tConversions * 200L);
                FluidStack tDistilledWater = FL.DistW.make(tConversions);
                for (byte tDir : CS.FACING_SIDES[this.mFacing]) {
                    if (tDistilledWater.amount <= 0) break;
                    tDistilledWater.amount = (int)((long)tDistilledWater.amount - FL.fill(this.getAdjacentTileEntity(tDir), tDistilledWater.copy(), true));
                }
                CS.GarbageGT.trash(tDistilledWater);
            }
            if (CS.SYNC_SECOND) {
                this.mState = (byte)Math.min(31L, UT.Code.scale(this.mEnergy, this.mCapacity, 32L, false));
            }
            long tOutput = this.mOutput * (long)(this.mState + 1) / 16L;
            this.mActive = !this.mStopped && this.mEnergy > tOutput && tOutput * 2L > this.mOutput;
            this.mEmitsEnergy = false;
            if (this.mActive) {
                this.mEmitsEnergy = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyTypeEmitted, this.mPiston > 1 ? -tOutput : tOutput, 1L, this) > 0L;
                this.mEnergy -= tOutput;
                if (this.mTimer % 600L == 5L) {
                    this.doDefaultStructuralChecks();
                }
            }
            if (this.mEnergy >= this.mCapacity) {
                this.mEnergy = this.mCapacity - 1L;
                if (this.mState > 30) {
                    this.mStopped = true;
                    this.mTank.setEmpty();
                    UT.Sounds.send("random.fizz", this, false);
                } else {
                    this.mState = (byte)31;
                }
            }
            if (this.mStopped && this.mEnergy > 0L) {
                this.mEnergy = Math.max(0L, this.mEnergy - Math.max(1L, this.mCapacity / 64L));
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            this.mStopped = !this.mStopped;
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.mStopped) {
                    aChatReturn.add("Stopped");
                } else if (this.mActive) {
                    aChatReturn.add("Running");
                } else {
                    aChatReturn.add("Capable of Running");
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mState = UT.Code.bind5(this.mState);
        return this.mActive != this.oActive || this.mState != this.oState || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oState = this.mState;
        this.oActive = this.mActive;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mPiston = (byte)(aData & 3);
        this.mActive = (aData & 4) != 0;
        this.mState = (byte)(aData >>> 3 & 0x1F);
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mPiston & 3 | (this.mActive ? 4 : 0) | this.mState << 3);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 0.5f : 0.25f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mEmitsEnergy;
    }

    @Override
    public boolean setAdjacentOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeEmitted ? this.mCapacity : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeEmitted.AS_LIST;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return !this.mStopped && aSide == CS.OPOS[this.mFacing] && FL.Steam.is(aFluidToFill) ? this.mTank : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 14 : 0], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? 14 : 0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 14 : 0]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 14 : 0], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? 14 : 0], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 14 : 0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 6], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 6], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 6]);
            }
            case 4: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 6], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 6], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 6], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 6]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 4], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 4], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 4], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 4], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 4], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 4]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 3], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 3], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 3], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 0 : 3], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? 0 : 3], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 0 : 3]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return CS.ALONG_AXIS[aSide][this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[3], this.mRGBa), BlockTextureDefault.get(sOverlays[3]));
            }
            case 1: 
            case 2: {
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2)], this.mRGBa), BlockTextureDefault.get(sOverlays[aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2)]));
            }
            case 3: {
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.ALONG_AXIS_1[aSide][this.mFacing] ? 4 : 5], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.ALONG_AXIS_1[aSide][this.mFacing] ? 4 : 5]));
            }
            case 4: {
                return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.ALONG_AXIS_2[aSide][this.mFacing] ? 4 : 5], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.ALONG_AXIS_2[aSide][this.mFacing] ? 4 : 5]));
            }
            case 5: {
                return aSide == CS.OPOS[this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[6], sEngineColors[this.mState]), BlockTextureDefault.get(sOverlays[6]));
            }
            case 6: {
                return CS.ALONG_AXIS[aSide][this.mFacing] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[7], this.mRGBa), BlockTextureDefault.get(sOverlays[7]));
            }
        }
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.engine.kinetic_steam";
    }
}

