/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.tools.machine;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.RM;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.Behavior_Tool;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.item.multiitem.tools.ToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Crowbar
extends ToolStats {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 100;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 2.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return "random.break";
    }

    @Override
    public String getEntityHitSound() {
        return "random.break";
    }

    @Override
    public String getMiningSound() {
        return "random.break";
    }

    @Override
    public boolean canCollect() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean isCrowbar() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        if (aBlock instanceof BlockRailBase || aBlock.getMaterial() == Material.circuits || IL.TC_Block_Air.equal(aBlock) || IL.TG_Ore_Cluster_1.equal(aBlock) || IL.TG_Ore_Cluster_2.equal(aBlock) || CS.BlocksGT.openableCrowbar.contains(aBlock)) {
            return true;
        }
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        if (UT.Code.stringValid(tTool)) {
            return "crowbar".equalsIgnoreCase(tTool);
        }
        for (IToolStats tStat : CS.ToolsGT.sMetaTool.mToolStats.values()) {
            if (tStat instanceof GT_Tool_Crowbar || !tStat.isMinableBlock(aBlock, aMetaData)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        return IL.TG_Ore_Cluster_1.equal(aBlock) || IL.TG_Ore_Cluster_2.equal(aBlock) ? Float.MAX_VALUE : super.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, aWorld, aX, aY, aZ);
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (CS.BlocksGT.openableCrowbar.contains(aBlock)) {
            ArrayListNoNulls<ItemStack> tDrops = ST.arraylist(new ItemStack[0]);
            for (int i = 0; i < aDrops.size(); ++i) {
                Recipe tRecipe = RM.Unboxinator.findRecipe(null, null, true, Integer.MAX_VALUE, CS.NI, CS.ZL_FS, ST.amount(1L, aDrops.get(i)));
                if (tRecipe == null) continue;
                int tStackSize = aDrops.get((int)i).stackSize;
                aDrops.remove(i--);
                if (tRecipe.mOutputs.length <= 0) continue;
                for (int j = 0; j < tStackSize; ++j) {
                    ItemStack[] tOutput = tRecipe.getOutputs();
                    for (int k = 0; k < tOutput.length; ++k) {
                        tDrops.add(tOutput[k]);
                    }
                }
            }
            aDrops.addAll(tDrops);
        }
        return 0;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.CROWBAR : Textures.ItemIcons.VOID;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mRGBaSolid : CS.UNCOLOURED;
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behavior_Tool("crowbar", "random.break", 100L, !this.canBlock(), CS.SFX.RANDOM_PITCH));
    }

    @Override
    public String getDeathMessage() {
        return "[VICTIM] lost Half a Life to [KILLER]";
    }
}

