/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IPrefixBlock;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntity;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Behavior_Worldgen_Debugger
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Worldgen_Debugger();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.isRemote) {
            return false;
        }
        int eX = (aX & 0xFFFFFFF0) + 16;
        for (int tX = aX & 0xFFFFFFF0; tX < eX; ++tX) {
            int eZ = (aZ & 0xFFFFFFF0) + 16;
            for (int tZ = aZ & 0xFFFFFFF0; tZ < eZ; ++tZ) {
                for (int tY = 1; tY < 250; ++tY) {
                    Block tBlock = WD.block((IBlockAccess)aWorld, tX, tY, tZ);
                    if (tBlock instanceof IPrefixBlock) {
                        TileEntity aTileEntity = aWorld.getTileEntity(tX, tY, tZ);
                        if (!(aTileEntity instanceof ITileEntity)) continue;
                        ((ITileEntity)aTileEntity).onAdjacentBlockChange(tX, tY, tZ);
                        continue;
                    }
                    WD.set(aWorld, tX, tY, tZ, CS.NB, 0L, 2L);
                }
            }
        }
        return true;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.worldgendebug"));
        aList.add("Currently deletes a single Chunk, except for bottom most Bedrock and GT6 Ores");
        return aList;
    }

    static {
        LH.add("gt.behaviour.worldgendebug", "Testing Tool for executing Code based on Coordinates");
    }
}

