/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Behavior_Scanner
extends IBehavior.AbstractBehaviorDefault {
    public final int mScanLevel;

    public Behavior_Scanner(int aScanLevel) {
        this.mScanLevel = aScanLevel;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aPlayer instanceof EntityPlayerMP) {
            ArrayListNoNulls<String> tList = new ArrayListNoNulls<String>();
            if (aItem.useEnergy(TD.Energy.EU, aStack, WD.scan(tList, aPlayer, aWorld, this.mScanLevel, aX, aY, aZ, aSide, hitX, hitY, hitZ), (EntityLivingBase)aPlayer, (IInventory)aPlayer.inventory, aWorld, aX, aY, aZ, true)) {
                UT.Entities.sendchat((Object)aPlayer, tList, false);
            }
            return true;
        }
        UT.Sounds.play(CS.SFX.IC_SCANNER, 20, 1.0f, aX, aY, aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (this.mScanLevel > 100) {
            UT.Entities.sendchat((Object)aPlayer, aEntity.getClass().getName());
            UT.Sounds.play(CS.SFX.IC_SCANNER, 20, 1.0f, aEntity);
        }
        return true;
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (this.mScanLevel > 100) {
            UT.Entities.sendchat((Object)aPlayer, aEntity.getClass().getName());
            UT.Sounds.play(CS.SFX.IC_SCANNER, 20, 1.0f, aEntity);
        }
        return true;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.scanning"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.scanning", "Can scan Blocks in World");
    }
}

