/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.item.CreativeTab;
import gregapi.item.bumble.IItemBumbleBee;
import gregapi.item.multiitem.MultiItemRandomWithCompat;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.BlockDiggable;
import gregtech.tileentity.plants.MultiTileEntityResinHoleRubber;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiItemBumbles
extends MultiItemRandomWithCompat
implements IItemBumbleBee {
    public IIcon PRINCESS;
    public IIcon QUEEN;
    public IIcon SCANNED;
    public IIcon DEAD;

    public MultiItemBumbles(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
        this.setCreativeTab(new CreativeTab(this.getUnlocalizedName(), "GregTech: Bumblebees", this, 2));
        if (!CS.SHOW_BUMBLEBEES) {
            ST.hide(this);
        }
    }

    @Override
    public void addItems() {
        this.make(0, "Wild Bumblebee", "");
        this.make(10, "Captive Bumblebee", "Is used to enprisonment");
        this.make(20, "Common Bumblebee", "Works hard for its Family");
        this.make(30, "Cultivated Bumblebee", "Drinks Wine while watching Oprah");
        this.make(100, "Surfing Bumblebee", "Too chill to work regularily");
        this.make(110, "Swimming Bumblebee", "");
        this.make(120, "Diving Bumblebee", "Not gonna jump into Green Water");
        this.make(130, "Subnautic Bumblebee", "Its Wings became Air Tanks");
        this.make(200, "Apprentice Bumblebee", "");
        this.make(210, "Magician Bumblebee", "");
        this.make(220, "Wizard Bumblebee", "");
        this.make(230, "Dumblebee", "");
        this.make(300, "Nether Bumblebee", "");
        this.make(310, "Hellish Bumblebee", "");
        this.make(320, "Impish Bumblebee", "");
        this.make(330, "Demonic Bumblebee", "");
        this.make(400, "End Bumblebee", "The End is nigh!");
        this.make(410, "Void Bumblebee", "Voids parts of its work for no reason");
        this.make(420, "Alienated Bumblebee", "Doesn't feel comfortable with Society");
        this.make(430, "Nihilistic Bumblebee", "Who cares? Nothing matters.");
        this.make(500, "Stoned Bumblebee", "Duuuude");
        this.make(510, "Rocking Bumblebee", "");
        this.make(520, "Hard Rock Bumblebee", "");
        this.make(530, "Bumbelvis", "Has left the Building");
        this.make(600, "Jungle Bumblebee", "");
        this.make(610, "Jungle Bumblebee (T2)", "");
        this.make(620, "Jungle Bumblebee (T3)", "");
        this.make(630, "Bumblezan", "BuzzIAH!-IAH!");
        this.make(700, "Frosty Bumblebee", "");
        this.make(710, "North Pole Bumblebee", "");
        this.make(720, "Bumble Elf", "");
        this.make(730, "Bumble Claus", "Ho Ho Ho!");
        this.make(800, "Bumbleshroom", "");
        this.make(810, "Bumble Toad", "");
        this.make(820, "Bumble Bro", "It's a me! Bumblio!");
        this.make(830, "Bumble Peach", "Is in another Castle!");
        this.make(900, "Sandy Bumblebee", "");
        this.make(910, "Sandy Bumblebee (T2)", "");
        this.make(920, "Sandy Bumblebee (T3)", "");
        this.make(930, "Bumbobee", "Shop at Sahara!");
        this.make(10000, "Creative Bumblebee", "Interested in Pottery");
        this.make(10010, "Builder Bumblebee", "Also known as Bumblebob the Builder");
        this.make(10020, "Masonic Bumblebee", "Is free to build Brick Walls");
        this.make(10030, "Illuminumblebee", "Nothing suspicious around here");
        this.make(10100, "Industrial Bumblebee", "Revolutionises Comb Production");
        this.make(10110, "Overseer Bumblebee", "Effectively orders around the Workforce");
        this.make(10120, "Bumble Tycoon", "Taking over the Bumblebeesiness");
        this.make(10130, "Monopolistic Bumblebee", "Owns everything and everyone");
        this.make(10200, "Bumbleknight", "For the King of Bumble Castle!");
        this.make(10210, "Colonial Bumblebee", "For the Queen of Bumbleland!");
        this.make(10220, "Royal Bumblebee", "Member of the Royal Family");
        this.make(10230, "Bumblemonarch", "Ruling over the Bumblecountry");
        this.make(10300, "Bumblegoth", "Hangs around in dark places");
        this.make(10310, "Occult Bumblebee", "Practices occult Rituals");
        this.make(10320, "Antichristumblebee", "Screw Bumblebeesus!");
        this.make(10330, "Satanic Bumblebee", "Heil Bumblesatan!");
        this.make(10400, "Forgetful Bumblebee", "What was I supposed to do again? It slipped my mind.");
        this.make(10410, "Amnesic Bumblebee", "Who are you? And who am I even?");
        this.make(10420, "Bumbleheimers", "Could you get me some Honey? Thanks. Could you get me some Honey?");
        this.make(10430, "Bumble in Black", "You did not see anything unusual. I did not wiggle my Butt.");
        this.make(10500, "Private Bumble", "Reporting for Duty!");
        this.make(10510, "Lt. Bumbleson", "Yes Sir!");
        this.make(10520, "Colonel Bumble O'Beeill", "Leading the Team");
        this.make(10530, "General Bumblemond", "In charge of the Bumblyene Mountain Base");
        this.make(20000, "Blazing Bumblebee", "");
        this.make(20010, "Flaming Bumblebee", "");
        this.make(20020, "Bumbletrantor", "The Last Stormbumble");
        this.make(20030, "Pyro Bumble", "Likes Unicorns, Rainbows and Candy");
        this.make(20100, "Blizzful Bumblebee", "");
        this.make(20110, "Freezing Bumblebee", "");
        this.make(20120, "Mr. Bumblefreeze", "Ice to meet you!");
        this.make(20130, "Cryo Bumble", "Delivered Pizza to I.C.Wiener");
        this.make(20200, "Blitzing Bumblebee", "");
        this.make(20210, "Storming Bumblebee", "");
        this.make(20220, "Bumbleaang", "The Last Bumblebender");
        this.make(20230, "Aero Bumble", "According to the Laws of Fluid Dynamics, this Bumblebee CAN Fly!");
        this.make(20300, "Basalzed Bumblebee", "");
        this.make(20310, "Quakeing Bumblebee", "With a mighty White Beard!");
        this.make(20320, "Earth Bound Bumblebee", "PK Bumble!");
        this.make(20330, "Tera Bumble", "By your Powers combined, I am Captain Bumblebee!");
    }

    @Override
    public ItemStack bumbleProductStack(ItemStack aBumbleBee, short aMetaData, long aStacksize, int aProductIndex) {
        switch (aMetaData / 100) {
            case 0: {
                return IL.Comb_Honey.get(aStacksize, new Object[0]);
            }
            case 1: {
                return IL.Comb_Water.get(aStacksize, new Object[0]);
            }
            case 2: {
                return IL.Comb_Magic.get(aStacksize, new Object[0]);
            }
            case 3: {
                return IL.Comb_Nether.get(aStacksize, new Object[0]);
            }
            case 4: {
                return IL.Comb_End.get(aStacksize, new Object[0]);
            }
            case 5: {
                return IL.Comb_Rock.get(aStacksize, new Object[0]);
            }
            case 6: {
                return IL.Comb_Jungle.get(aStacksize, new Object[0]);
            }
            case 7: {
                return IL.Comb_Frozen.get(aStacksize, new Object[0]);
            }
            case 8: {
                return IL.Comb_Shroom.get(aStacksize, new Object[0]);
            }
            case 9: {
                return IL.Comb_Sandy.get(aStacksize, new Object[0]);
            }
            case 100: {
                return IL.Comb_Clay.get(aStacksize, new Object[0]);
            }
            case 101: {
                return IL.Comb_Sticky.get(aStacksize, new Object[0]);
            }
            case 102: {
                return IL.Comb_Royal.get(aStacksize, new Object[0]);
            }
            case 103: {
                return IL.Comb_Soul.get(aStacksize, new Object[0]);
            }
            case 104: {
                return IL.Comb_Amnesic.get(aStacksize, new Object[0]);
            }
            case 105: {
                return IL.Comb_Military.get(aStacksize, new Object[0]);
            }
            case 200: {
                return IL.Comb_Pyro.get(aStacksize, new Object[0]);
            }
            case 201: {
                return IL.Comb_Cryo.get(aStacksize, new Object[0]);
            }
            case 202: {
                return IL.Comb_Aero.get(aStacksize, new Object[0]);
            }
            case 203: {
                return IL.Comb_Tera.get(aStacksize, new Object[0]);
            }
        }
        return IL.Comb_Honey.get(aStacksize, new Object[0]);
    }

    @Override
    public ChunkCoordinates bumbleCanProduce(World aWorld, int aX, int aY, int aZ, ItemStack aBumbleBee, short aMetaData, int aDistance) {
        int[] tOrderY;
        int[] tOrderX;
        boolean temp = true;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!WD.oxygen(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide])) continue;
            temp = false;
            break;
        }
        if (temp) {
            return null;
        }
        aDistance = Math.abs(aDistance);
        int[] nArray = CS.RNGSUS.nextBoolean() ? (aDistance < CS.SCANS_POS.length ? CS.SCANS_POS[aDistance] : CS.SCANS_POS[CS.SCANS_POS.length - 1]) : (tOrderX = aDistance < CS.SCANS_NEG.length ? CS.SCANS_NEG[aDistance] : CS.SCANS_NEG[CS.SCANS_NEG.length - 1]);
        int[] nArray2 = CS.RNGSUS.nextBoolean() ? (aDistance < CS.SCANS_POS.length ? CS.SCANS_POS[aDistance] : CS.SCANS_POS[CS.SCANS_POS.length - 1]) : (tOrderY = aDistance < CS.SCANS_NEG.length ? CS.SCANS_NEG[aDistance] : CS.SCANS_NEG[CS.SCANS_NEG.length - 1]);
        int[] tOrderZ = CS.RNGSUS.nextBoolean() ? (aDistance < CS.SCANS_POS.length ? CS.SCANS_POS[aDistance] : CS.SCANS_POS[CS.SCANS_POS.length - 1]) : (aDistance < CS.SCANS_NEG.length ? CS.SCANS_NEG[aDistance] : CS.SCANS_NEG[CS.SCANS_NEG.length - 1]);
        switch (aMetaData / 100) {
            case 1: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            if (!WD.anywater((IBlockAccess)aWorld, aX + i, aY + j, aZ + k)) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 2: {
                if (CS.BIOMES_MAGICAL.contains(aWorld.getBiomeGenForCoords((int)aX, (int)aZ).biomeName)) {
                    return new ChunkCoordinates(aX, aY, aZ);
                }
                Block tThaumcraft = ST.block(MD.TC, "blockCustomPlant");
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock == CS.NB) continue;
                            if (tBlock == tThaumcraft) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock != CS.BlocksGT.Leaves_AB || (WD.meta(aWorld, aX + i, aY + j, aZ + k, false) & 7) != 7) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 3: 
            case 200: {
                Block tFireFlower = ST.block(MD.BoP, "flowers2", null);
                Block tWartCrimson = ST.block(MD.NeLi, "CrimsonWartCrop", null);
                Block tWartWarped = ST.block(MD.NeLi, "WarpedWartCrop", null);
                Block tWartSoggy = ST.block(MD.NeLi, "SoggyWartCrop", null);
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock == CS.NB) continue;
                            if (tBlock == Blocks.nether_wart) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock == tWartCrimson) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock == tWartWarped) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock == tWartSoggy) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (IL.NeLi_Wither_Rose.equal(tBlock)) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (IL.EtFu_Wither_Rose.equal(tBlock)) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock != tFireFlower || WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k) != 2) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 4: 
            case 202: {
                Block tChorusFlower = ST.block(MD.EtFu, "chorus_flower", null);
                if (tChorusFlower == null) {
                    if (aWorld.provider.dimensionId == 1 || CS.BIOMES_END.contains(aWorld.getBiomeGenForCoords((int)aX, (int)aZ).biomeName)) {
                        return new ChunkCoordinates(aX, aY, aZ);
                    }
                    for (int j : tOrderY) {
                        for (int i : tOrderX) {
                            for (int k : tOrderZ) {
                                Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                                if (tBlock != Blocks.end_portal && tBlock != Blocks.dragon_egg) continue;
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                        }
                    }
                    return null;
                }
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock != tChorusFlower && tBlock != Blocks.dragon_egg) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 5: 
            case 203: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock == Blocks.mossy_cobblestone || tBlock == Blocks.cobblestone || tBlock == Blocks.stone) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            byte tMeta = WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k);
                            if (tBlock == Blocks.stonebrick && tMeta == 1) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (tBlock instanceof BlockStones && (BlockStones.SPAWNABLE[tMeta] || BlockStones.MOSSY[tMeta])) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (!WD.stone(tBlock, tMeta)) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 6: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            if (WD.block(aWorld, aX + i, aY + j, aZ + k, false) != Blocks.cocoa) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 7: 
            case 201: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock != Blocks.ice && tBlock != Blocks.snow_layer && tBlock != Blocks.snow && tBlock != Blocks.packed_ice) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 8: {
                Block tMushroom = ST.block(MD.BoP, "mushrooms", null);
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock != Blocks.mycelium && tBlock != Blocks.red_mushroom && tBlock != Blocks.brown_mushroom && tBlock != tMushroom && tBlock != Blocks.red_mushroom_block && tBlock != Blocks.brown_mushroom_block) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 9: 
            case 105: {
                Block tCactus1 = ST.block(MD.BoP, "plants", null);
                Block tCactus2 = ST.block(MD.ARS, "desertNova", null);
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            TileEntity tTileEntity;
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock == Blocks.cactus || tBlock == tCactus2 || tBlock == CS.BlocksGT.FlowersB) {
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (!(tBlock == tCactus1 ? WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k) == 12 : tBlock == Blocks.flower_pot && (tTileEntity = WD.te(aWorld, aX + i, aY + j, aZ + k, false)) instanceof TileEntityFlowerPot && Block.getBlockFromItem((Item)((TileEntityFlowerPot)tTileEntity).getFlowerPotItem()) == Blocks.cactus)) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 100: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock != Blocks.clay && (tBlock != CS.BlocksGT.Diggables || !BlockDiggable.IS_CLAY[WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k)])) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 101: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            Block tBlock = WD.block(aWorld, aX + i, aY + j, aZ + k, false);
                            if (tBlock == CS.NB) continue;
                            if (tBlock == IL.IC2_Log_Rubber.block()) {
                                if (WD.meta((IBlockAccess)aWorld, aX + i, aY + j, aZ + k) == 0) continue;
                                return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                            }
                            if (!(tBlock instanceof MultiTileEntityBlock) || !(WD.te(aWorld, aX + i, aY + j, aZ + k, false) instanceof MultiTileEntityResinHoleRubber)) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
            case 103: {
                for (int j : tOrderY) {
                    for (int i : tOrderX) {
                        for (int k : tOrderZ) {
                            if (!OM.is((Object)OD.soulsand, ST.make(WD.block(aWorld, aX + i, aY + j, aZ + k, false), 1L, 32767L))) continue;
                            return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                        }
                    }
                }
                return null;
            }
        }
        if (CS.RNGSUS.nextBoolean()) {
            for (int j : tOrderY) {
                for (int i : tOrderX) {
                    for (int k : tOrderZ) {
                        if (!MultiItemBumbles.checkFlowers(aWorld, aX + i, aY + j, aZ + k)) continue;
                        return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                    }
                }
            }
        } else {
            for (int j : tOrderY) {
                for (int k : tOrderZ) {
                    for (int i : tOrderX) {
                        if (!MultiItemBumbles.checkFlowers(aWorld, aX + i, aY + j, aZ + k)) continue;
                        return new ChunkCoordinates(aX + i, aY + j, aZ + k);
                    }
                }
            }
        }
        return null;
    }

    public String getFlowerTooltip(short aMetaData) {
        switch (aMetaData / 100) {
            case 1: {
                return "Water";
            }
            case 2: {
                return "Magical Biome, Thaumic Flowers or Rainbow Leaves";
            }
            case 3: 
            case 200: {
                return MD.BoP.mLoaded ? "Netherwart or Burning Blossoms" : "Netherwart";
            }
            case 4: 
            case 202: {
                return MD.EtFu.mLoaded ? "Chorus Flower or Dragon Egg" : "End Portal, End Biome or Dragon Egg";
            }
            case 5: 
            case 203: {
                return "Stone, Cobble or Mossy";
            }
            case 6: {
                return "Cocoa";
            }
            case 7: 
            case 201: {
                return "Snow or Ice";
            }
            case 8: {
                return "Mycelium or Mushrooms";
            }
            case 9: 
            case 105: {
                return "Desert Flowers and Cacti (even potted ones work)";
            }
            case 100: {
                return "Raw Clay Blocks";
            }
            case 101: {
                return MD.IC2.mLoaded ? "Rubber Tree Resin Holes (IC2 or GT6)" : "Rubber Tree Resin Holes";
            }
            case 103: {
                return "Soul Sand Blocks";
            }
        }
        return "Flowers (even potted ones work)";
    }

    @Override
    public ItemStack bumbleCombine(ItemStack aBumbleBeeA, short aMetaDataA, ItemStack aBumbleBeeB, short aMetaDataB, byte aBumbleType, Random aRandom) {
        if (aBumbleBeeB.getItem() != CS.ItemsGT.BUMBLEBEES) {
            return ((IItemBumbleBee)aBumbleBeeB.getItem()).bumbleCombine(aBumbleBeeA, aMetaDataA, aBumbleBeeB, aMetaDataB, aBumbleType, aRandom);
        }
        if (aBumbleBeeA.getItem() != CS.ItemsGT.BUMBLEBEES) {
            return ((IItemBumbleBee)aBumbleBeeA.getItem()).bumbleCombine(aBumbleBeeA, aMetaDataA, aBumbleBeeB, aMetaDataB, aBumbleType, aRandom);
        }
        if (aBumbleBeeB.getItem() != this) {
            return ST.copyAmountAndMeta(1L, aMetaDataA / 10 * 10 + aBumbleType, aBumbleBeeA);
        }
        if (aBumbleBeeA.getItem() != this) {
            return ST.copyAmountAndMeta(1L, aMetaDataB / 10 * 10 + aBumbleType, aBumbleBeeB);
        }
        switch (aMetaDataA / 10) {
            case 3: {
                switch (aMetaDataB / 10) {
                    case 13: {
                        return ST.make(this, 1L, (long)(10100 + aBumbleType));
                    }
                    case 53: {
                        return ST.make(this, 1L, (long)(10000 + aBumbleType));
                    }
                    case 93: {
                        return ST.make(this, 1L, (long)(10200 + aBumbleType));
                    }
                }
                break;
            }
            case 13: {
                switch (aMetaDataB / 10) {
                    case 3: {
                        return ST.make(this, 1L, (long)(10100 + aBumbleType));
                    }
                    case 53: {
                        return ST.make(this, 1L, (long)(10400 + aBumbleType));
                    }
                }
                break;
            }
            case 33: {
                switch (aMetaDataB / 10) {
                    case 43: {
                        return ST.make(this, 1L, (long)(10300 + aBumbleType));
                    }
                    case 1053: {
                        return ST.make(this, 1L, (long)(20000 + aBumbleType));
                    }
                }
                break;
            }
            case 43: {
                switch (aMetaDataB / 10) {
                    case 33: {
                        return ST.make(this, 1L, (long)(10300 + aBumbleType));
                    }
                    case 1053: {
                        return ST.make(this, 1L, (long)(20200 + aBumbleType));
                    }
                }
                break;
            }
            case 53: {
                switch (aMetaDataB / 10) {
                    case 3: {
                        return ST.make(this, 1L, (long)(10000 + aBumbleType));
                    }
                    case 13: {
                        return ST.make(this, 1L, (long)(10400 + aBumbleType));
                    }
                    case 1053: {
                        return ST.make(this, 1L, (long)(20300 + aBumbleType));
                    }
                }
                break;
            }
            case 63: {
                switch (aMetaDataB / 10) {
                    case 93: {
                        return ST.make(this, 1L, (long)(10500 + aBumbleType));
                    }
                }
                break;
            }
            case 73: {
                switch (aMetaDataB / 10) {
                    case 1053: {
                        return ST.make(this, 1L, (long)(20100 + aBumbleType));
                    }
                }
                break;
            }
            case 93: {
                switch (aMetaDataB / 10) {
                    case 3: {
                        return ST.make(this, 1L, (long)(10200 + aBumbleType));
                    }
                    case 63: {
                        return ST.make(this, 1L, (long)(10500 + aBumbleType));
                    }
                }
                break;
            }
            case 1053: {
                switch (aMetaDataB / 10) {
                    case 33: {
                        return ST.make(this, 1L, (long)(20000 + aBumbleType));
                    }
                    case 43: {
                        return ST.make(this, 1L, (long)(20200 + aBumbleType));
                    }
                    case 53: {
                        return ST.make(this, 1L, (long)(20300 + aBumbleType));
                    }
                    case 73: {
                        return ST.make(this, 1L, (long)(20100 + aBumbleType));
                    }
                }
            }
        }
        return ST.make(this, 1L, (long)(aMetaDataA / 10 * 10 + aBumbleType));
    }

    @Override
    public boolean bumbleAttack(ItemStack aBumbleBee, short aMetaData, EntityLivingBase aAttacked) {
        if (UT.Entities.isWearingFullInsectHazmat(aAttacked)) {
            return false;
        }
        boolean tSkeleton = aAttacked instanceof EntitySkeleton || aAttacked instanceof EntityHorse && ((EntityHorse)aAttacked).getHorseType() == 4;
        boolean tSnowGolem = aAttacked.getClass() == EntitySnowman.class;
        boolean tIronGolem = aAttacked instanceof EntityIronGolem;
        boolean tPlayer = aAttacked instanceof EntityPlayer;
        switch (aMetaData / 100) {
            default: {
                return !tSkeleton && !tSnowGolem && !tIronGolem && aAttacked.attackEntityFrom(DamageSources.getBumbleDamage(), (float)(1 + aMetaData / 10 % 10));
            }
            case 9: {
                return !tSkeleton && !tSnowGolem && !tIronGolem && aAttacked.attackEntityFrom(DamageSources.getBumbleDamage(), (float)((1 + aMetaData / 10 % 10) * 2));
            }
            case 6: {
                return !tSkeleton && !tSnowGolem && !tIronGolem && aAttacked.attackEntityFrom(DamageSources.getBumbleDamage(), (float)((1 + aMetaData / 10 % 10) * 4));
            }
            case 8: {
                return false;
            }
            case 3: {
                if (!tSkeleton && !tIronGolem && aAttacked.attackEntityFrom(DamageSources.getBumbleDamage().setFireDamage(), (float)((1 + aMetaData / 10 % 10) * 2))) {
                    aAttacked.setFire((1 + aMetaData / 10 % 10) * 10);
                    return true;
                }
                return false;
            }
            case 105: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
        }
        return !tPlayer && aAttacked.attackEntityFrom(DamageSources.getBumbleDamage(), (float)((1 + aMetaData / 10 % 10) * 10));
    }

    @Override
    public int bumbleMutateChance(ItemStack aBumbleBee, short aMetaData) {
        switch (aMetaData / 10 % 10) {
            case 0: {
                return 500;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 250;
            }
            case 3: {
                return 25;
            }
        }
        return 0;
    }

    @Override
    public ItemStack bumbleMutate(ItemStack aBumbleBee, short aMetaData, Random aRandom) {
        switch (aMetaData / 10 % 10) {
            case 0: {
                return ST.copyMeta(aMetaData + 10, aBumbleBee);
            }
            case 1: {
                return ST.copyMeta(aMetaData + (aRandom.nextBoolean() ? 10 : -10), aBumbleBee);
            }
            case 2: {
                return ST.copyMeta(aMetaData + (aRandom.nextBoolean() ? 10 : -10), aBumbleBee);
            }
            case 3: {
                return ST.copyMeta(aMetaData - 10, aBumbleBee);
            }
        }
        return ST.copy(aBumbleBee);
    }

    @Override
    public int bumbleProductChance(ItemStack aBumbleBee, short aMetaData, int aProductIndex) {
        switch (aMetaData / 10 % 10) {
            case 0: {
                return 2500;
            }
            case 1: {
                return 5000;
            }
            case 2: {
                return 7500;
            }
            case 3: {
                return 10000;
            }
        }
        return 10000;
    }

    @Override
    public int bumbleProductCount(ItemStack aBumbleBee, short aMetaData) {
        return 1;
    }

    @Override
    public ChunkCoordinates bumbleCanProduct(World aWorld, int aX, int aY, int aZ, ItemStack aBumbleBee, short aMetaData, int aProductIndex) {
        return new ChunkCoordinates(aX, aY, aZ);
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        short aMeta = ST.meta_(aStack);
        String tTooltip = this.getFlowerTooltip(aMeta);
        if (UT.Code.stringValid(tTooltip)) {
            aList.add(LH.Chat.CYAN + "Requirement:" + LH.Chat._WHITE + tTooltip);
        }
        NBTTagCompound aBumbleTag = null;
        if (aStack.hasTagCompound()) {
            aBumbleTag = aStack.getTagCompound().getCompoundTag("gt.bumble");
        }
        if (aBumbleTag == null || aBumbleTag.hasNoTags()) {
            aList.add(LH.Chat.BLINKING_RED + "No Genetic Data to display");
            aList.add(LH.Chat.CYAN + "Generates random 'Outsider-Plains-Biome' Genes when used");
        } else {
            aList.add(LH.Chat.PURPLE + "Level:" + LH.Chat._PINK + (aMeta / 10 % 10 + 1) + LH.Chat._WHITE + "of" + LH.Chat._PINK + 4);
            if (aMeta % 10 < 5) {
                aList.add(LH.Chat.RED + "Not scanned yet!");
            } else {
                aList.add(LH.Chat.CYAN + "Humidity:" + LH.Chat._WHITE + IItemBumbleBee.Util.getHumidityMin(aBumbleTag) + " to " + IItemBumbleBee.Util.getHumidityMax(aBumbleTag) + LH.Chat.RED + "   Temp:" + LH.Chat._WHITE + IItemBumbleBee.Util.getTemperatureMin(aBumbleTag) + "K to " + IItemBumbleBee.Util.getTemperatureMax(aBumbleTag) + "K");
                aList.add(LH.Chat.GREEN + "Offspring:" + LH.Chat._WHITE + IItemBumbleBee.Util.getOffspring(aBumbleTag) + LH.Chat.ORANGE + "   Life:" + LH.Chat._WHITE + IItemBumbleBee.Util.getLifeSpan(aBumbleTag) + " ticks");
                aList.add(LH.Chat.YELLOW + "Eff:" + LH.Chat._WHITE + LH.percent(IItemBumbleBee.Util.getWorkForce(aBumbleTag)) + "%" + LH.Chat.RED + "   Aggro:" + LH.Chat._WHITE + LH.percent(IItemBumbleBee.Util.getAggressiveness(aBumbleTag)) + "%");
                if (IItemBumbleBee.Util.getDayActive(aBumbleTag)) {
                    if (IItemBumbleBee.Util.getNightActive(aBumbleTag)) {
                        aList.add(LH.Chat.RAINBOW + "Doesn't take breaks");
                    } else {
                        aList.add(LH.Chat.PURPLE + "Works at Day");
                    }
                } else if (IItemBumbleBee.Util.getNightActive(aBumbleTag)) {
                    aList.add(LH.Chat.PURPLE + "Works at Night");
                } else {
                    aList.add(LH.Chat.BLINKING_RED + "Doesn't work at any Time (BUG!!!)");
                }
                if (IItemBumbleBee.Util.getRainproof(aBumbleTag)) {
                    if (IItemBumbleBee.Util.getStormproof(aBumbleTag)) {
                        aList.add(LH.Chat.RAINBOW + "Can fly during any Weather");
                    } else {
                        aList.add(LH.Chat.PURPLE + "Can fly during Rain, but not during Storms");
                    }
                } else if (IItemBumbleBee.Util.getStormproof(aBumbleTag)) {
                    aList.add(LH.Chat.PURPLE + "Can fly during Storms, but not when it Rains");
                } else {
                    aList.add(LH.Chat.RED + "Weak to Weather");
                }
                if (IItemBumbleBee.Util.getOutsideActive(aBumbleTag)) {
                    if (IItemBumbleBee.Util.getInsideActive(aBumbleTag)) {
                        aList.add(LH.Chat.RAINBOW + "Doesn't care whether to bee In- or Outside");
                    } else {
                        aList.add(LH.Chat.PURPLE + "Needs to bee Outside");
                    }
                } else if (IItemBumbleBee.Util.getInsideActive(aBumbleTag)) {
                    aList.add(LH.Chat.PURPLE + "Needs to bee Inside");
                } else {
                    aList.add(LH.Chat.BLINKING_RED + "Doesn't work anywhere (BUG!!!)");
                }
            }
        }
    }

    @Override
    public ItemStack bumbleScan(ItemStack aBumbleBee) {
        ItemStack rStack = ST.copy(aBumbleBee);
        short aMeta = ST.meta_(rStack);
        if (aMeta % 10 < 5) {
            ST.meta_(rStack, aMeta + 5);
        }
        return rStack;
    }

    @Override
    public ItemStack bumbleKill(ItemStack aBumbleBee) {
        ItemStack rStack = ST.copy(aBumbleBee);
        short aMeta = ST.meta_(rStack);
        if (aMeta % 5 != 4) {
            ST.meta_(rStack, aMeta / 5 * 5 + 4);
        }
        return rStack;
    }

    @Override
    public ItemStack bumbleCrown(ItemStack aBumbleBee) {
        ItemStack rStack = ST.copy(aBumbleBee);
        short aMeta = ST.meta_(rStack);
        if (aMeta % 5 != 2) {
            ST.meta_(rStack, aMeta / 5 * 5 + 2);
        }
        return rStack;
    }

    @Override
    public boolean bumbleEqual(ItemStack aBumbleBeeA, short aMetaDataA, ItemStack aBumbleBeeB, short aMetaDataB) {
        return aBumbleBeeA.getItem() == aBumbleBeeB.getItem() && aMetaDataA / 10 == aMetaDataB / 10;
    }

    @Override
    public byte bumbleType(ItemStack aBumbleBee) {
        return (byte)(ST.meta_(aBumbleBee) % 10);
    }

    @Override
    public ItemStack bumbleDrone(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10));
    }

    @Override
    public ItemStack bumblePrincess(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 1));
    }

    @Override
    public ItemStack bumbleQueen(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 2));
    }

    @Override
    public ItemStack bumbleDead(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 4));
    }

    @Override
    public ItemStack bumbleDrone_(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 5));
    }

    @Override
    public ItemStack bumblePrincess_(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 6));
    }

    @Override
    public ItemStack bumbleQueen_(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 7));
    }

    @Override
    public ItemStack bumbleDead_(ItemStack aBumbleBee, short aMetaData) {
        return ST.make(this, 1L, (long)(aMetaData / 10 * 10 + 9));
    }

    @Override
    public int getDefaultStackLimit(ItemStack aStack) {
        return 64;
    }

    public void make(int aSpeciesID, String aName, String aTooltip) {
        for (int i : new int[]{0, 1, 4}) {
            for (String tFluid : CS.FluidsGT.HONEY) {
                if (!FL.exists(tFluid)) continue;
                RM.Bumblelyzer.addFakeRecipe(false, ST.array(ST.make(this, 1L, (long)(aSpeciesID + i)), OP.plateTiny.mat(MT.Paper, 1L)), ST.array(ST.make(this, 1L, (long)(aSpeciesID + i + 5))), null, null, FL.array(FL.make(tFluid, 10L)), null, 64L, 16L, 0L);
            }
            RM.Bumblelyzer.addFakeRecipe(false, ST.array(ST.make(this, 1L, (long)(aSpeciesID + i)), OP.plateTiny.mat(MT.Paper, 1L)), ST.array(ST.make(this, 1L, (long)(aSpeciesID + i + 5))), null, null, FL.array(FL.Honeydew.make(10L)), null, 64L, 16L, 0L);
            RM.Bumblelyzer.addFakeRecipe(false, ST.array(ST.make((Item)this, 1L, (long)(aSpeciesID + i + 5), "Was already scanned, auto-skipping")), ST.array(ST.make((Item)this, 1L, (long)(aSpeciesID + i + 5), "Just passed to the Output")), null, null, null, null, 1L, 16L, 0L);
            RM.Bumblelyzer.addFakeRecipe(false, ST.array(ST.make((Item)this, 1L, (long)(aSpeciesID + i + 5), "Was already scanned, auto-skipping")), ST.array(ST.make((Item)this, 1L, (long)(aSpeciesID + i + 5), "Just passed to the Output")), null, null, null, null, 1L, 16L, 0L);
        }
        this.addItem(aSpeciesID + 0, aName + " Drone", aTooltip, "gt:bumbledrone", TC.stack(TC.BESTIA, 1L));
        this.addItem(aSpeciesID + 1, aName + " Princess", aTooltip, "gt:bumbleprincess", TC.stack(TC.BESTIA, 2L));
        this.addItem(aSpeciesID + 2, aName + " Queen", aTooltip, "gt:bumblequeen", TC.stack(TC.BESTIA, 2L), TD.Creative.HIDDEN);
        this.addItem(aSpeciesID + 4, aName + " (Dead)", aTooltip, "gt:bumbledead", TC.stack(TC.MORTUUS, 1L), TD.Creative.HIDDEN);
        this.addItem(aSpeciesID + 5, aName + " Drone (Scanned)", aTooltip, "gt:bumbledrone", TC.stack(TC.BESTIA, 1L), TC.stack(TC.COGNITIO, 1L), new OreDictItemData(MT.Paper, 0x44BBB40L, new OreDictMaterialStack[0]));
        this.addItem(aSpeciesID + 6, aName + " Princess (Scanned)", aTooltip, "gt:bumbleprincess", TC.stack(TC.BESTIA, 2L), TC.stack(TC.COGNITIO, 1L), new OreDictItemData(MT.Paper, 0x44BBB40L, new OreDictMaterialStack[0]));
        this.addItem(aSpeciesID + 7, aName + " Queen (Scanned)", aTooltip, "gt:bumblequeen", TC.stack(TC.BESTIA, 2L), TC.stack(TC.COGNITIO, 1L), new OreDictItemData(MT.Paper, 0x44BBB40L, new OreDictMaterialStack[0]), TD.Creative.HIDDEN);
        this.addItem(aSpeciesID + 9, aName + " (Dead & Scanned)", aTooltip, "gt:bumbledead", TC.stack(TC.MORTUUS, 1L), TC.stack(TC.COGNITIO, 1L), new OreDictItemData(MT.Paper, 0x44BBB40L, new OreDictMaterialStack[0]), TD.Creative.HIDDEN);
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 0)), ST.make(this, 1L, (long)(aSpeciesID + 2)));
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 1)), ST.make(this, 1L, (long)(aSpeciesID + 2)));
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 4)), ST.make(this, 1L, (long)(aSpeciesID + 2)));
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 5)), ST.make(this, 1L, (long)(aSpeciesID + 7)));
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 6)), ST.make(this, 1L, (long)(aSpeciesID + 7)));
        CS.ItemsGT.addNEIRedirect(ST.make(this, 1L, (long)(aSpeciesID + 9)), ST.make(this, 1L, (long)(aSpeciesID + 7)));
        ItemStack[] tOutputs = new ItemStack[this.bumbleProductCount(CS.NI, (short)(aSpeciesID + 2))];
        long[] tChances = new long[tOutputs.length];
        for (int i = 0; i < tOutputs.length; ++i) {
            tOutputs[i] = this.bumbleProductStack(CS.NI, (short)(aSpeciesID + 2), 1L, i);
            tChances[i] = this.bumbleProductChance(CS.NI, (short)(aSpeciesID + 2), i);
        }
        RM.BumbleQueens.addFakeRecipe(false, ST.array(ST.make(this, 1L, (long)(aSpeciesID + 2)), ST.make(this, 1L, (long)(aSpeciesID + 7))), tOutputs, null, tChances, null, null, 0L, 0L, 0L);
    }

    public static boolean checkFlowers(World aWorld, int aX, int aY, int aZ) {
        Block aBlock = WD.block(aWorld, aX, aY, aZ, false);
        if (aBlock == CS.NB) {
            return false;
        }
        if (aBlock == Blocks.flower_pot) {
            TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, false);
            if (tTileEntity instanceof TileEntityFlowerPot) {
                aBlock = Block.getBlockFromItem((Item)((TileEntityFlowerPot)tTileEntity).getFlowerPotItem());
                return aBlock == Blocks.yellow_flower || aBlock == Blocks.red_flower;
            }
            return false;
        }
        if (aBlock == Blocks.double_plant) {
            byte tMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
            return tMeta != 2 && tMeta != 3;
        }
        if (CS.BlocksGT.FLOWERS.contains(aBlock)) {
            int tZ;
            int tY;
            Block tBlock = WD.block((IBlockAccess)aWorld, aX, aY - 1, aZ);
            if (aBlock == tBlock || aBlock == WD.block((IBlockAccess)aWorld, aX, aY + 1, aZ)) {
                return false;
            }
            int tX = aX + CS.RNGSUS.nextInt(5) - 2;
            if (tBlock == WD.block((IBlockAccess)aWorld, tX, tY = aY + CS.RNGSUS.nextInt(3) - 2, tZ = aZ + CS.RNGSUS.nextInt(5) - 2)) {
                tBlock = WD.block((IBlockAccess)aWorld, tX, ++tY, tZ);
                byte tMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
                if (WD.air(aWorld, tX, tY, tZ, tBlock) || WD.grass(tBlock, tMeta)) {
                    WD.set(aWorld, tX, tY, tZ, aBlock, (long)tMeta, 3L);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IIcon getIconIndex(ItemStack aStack) {
        return this.getIconFromDamage(ST.meta(aStack));
    }

    @Override
    public IIcon getIconFromDamage(int aMetaData) {
        aMetaData /= 10;
        return UT.Code.exists(aMetaData *= 10, this.mIconList) ? this.mIconList[aMetaData][0] : Textures.ItemIcons.RENDERING_ERROR.getIcon(0);
    }

    @Override
    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        return this.getIcon(aStack, aRenderPass);
    }

    @Override
    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.getIconFromDamageForRenderPass(ST.meta_(aStack), aRenderPass);
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int aMetaData) {
        switch (aMetaData % 10) {
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 3;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.PRINCESS = aIconRegister.registerIcon(this.mModID + ":" + this.getUnlocalizedName() + "/overlay_princess");
        this.QUEEN = aIconRegister.registerIcon(this.mModID + ":" + this.getUnlocalizedName() + "/overlay_queen");
        this.SCANNED = aIconRegister.registerIcon(this.mModID + ":" + this.getUnlocalizedName() + "/overlay_scanned");
        this.DEAD = aIconRegister.registerIcon(this.mModID + ":" + this.getUnlocalizedName() + "/overlay_dead");
        short tMaxMeta = (short)this.mEnabledItems.length();
        for (short aMeta = 0; aMeta < tMaxMeta; aMeta = (short)(aMeta + 10)) {
            if (!this.mEnabledItems.get(aMeta)) continue;
            this.mIconList[aMeta][0] = aIconRegister.registerIcon(this.mModID + ":" + this.getUnlocalizedName() + "/" + aMeta);
        }
    }

    @Override
    public IIcon getIconFromDamageForRenderPass(int aMetaData, int aRenderPass) {
        if (aRenderPass == 0) {
            return this.getIconFromDamage(aMetaData);
        }
        if (aRenderPass == 1) {
            switch (aMetaData % 10) {
                case 1: 
                case 6: {
                    return this.PRINCESS;
                }
                case 2: 
                case 7: {
                    return this.QUEEN;
                }
                case 3: 
                case 8: {
                    return this.DEAD;
                }
                case 4: 
                case 9: {
                    return this.DEAD;
                }
            }
        }
        return this.SCANNED;
    }
}

