/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.tool;

import gregapi.block.misc.BlockBaseSpike;
import gregapi.damage.DamageSources;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpikeSharp
extends BlockBaseSpike {
    public BlockSpikeSharp(String aNameInternal) {
        super(aNameInternal, ANY.Steel, MT.Ti);
        LH.add(this.getUnlocalizedName() + ".0", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".1", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".2", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".3", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".4", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".5", "Steel Wall Spike");
        LH.add(this.getUnlocalizedName() + ".6", "Steel Block Spike");
        LH.add(this.getUnlocalizedName() + ".7", "Falling Steel Spike Block");
        LH.add(this.getUnlocalizedName() + ".8", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".9", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".10", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".11", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".12", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".13", "Titanium Wall Spike");
        LH.add(this.getUnlocalizedName() + ".14", "Titanium Block Spike");
        LH.add(this.getUnlocalizedName() + ".15", "Falling Titanium Spike Block");
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        if (aMeta < 8) {
            aList.add(LH.Chat.ORANGE + "Deals average Damage to anything touching it!");
            aList.add(LH.Chat.ORANGE + "Doesn't work on Skeletons, Slimes and Iron Golems.");
        } else {
            aList.add(LH.Chat.ORANGE + "Deals large Damage to anything touching it!");
        }
        if ((aMeta & 7) >= 6) {
            aList.add(LH.Chat.CYAN + "Works in all Directions, but only does half the Wall Spikes Damage!");
        }
    }

    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aEntity instanceof EntityLivingBase) {
            if (aMeta < 8) {
                if (!(aEntity instanceof EntityIronGolem || aEntity instanceof EntitySkeleton || aEntity instanceof EntitySlime)) {
                    aEntity.attackEntityFrom(DamageSources.getSpikeDamage(), (float)CS.TFC_DAMAGE_MULTIPLIER * ((aMeta & 7) < 6 ? 5.0f : 2.5f));
                }
            } else {
                aEntity.attackEntityFrom(DamageSources.getSpikeDamage(), (float)CS.TFC_DAMAGE_MULTIPLIER * ((aMeta & 7) < 6 ? 10.0f : 5.0f));
            }
        }
    }
}

