/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks;

import gregapi.block.misc.BlockBaseBale;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockBaleGrass
extends BlockBaseBale {
    public BlockBaleGrass(String aUnlocalised) {
        super(null, aUnlocalised, Material.grass, soundTypeGrass, 4L, Textures.BlockIcons.BALES_GRASS);
        LH.add(this.getUnlocalizedName() + ".0", "Grass Bale");
        LH.add(this.getUnlocalizedName() + ".4", "Grass Bale");
        LH.add(this.getUnlocalizedName() + ".8", "Grass Bale");
        LH.add(this.getUnlocalizedName() + ".12", "Grass Bale");
        OM.reg(ST.make(this, 1L, 0L), "baleGrass");
        OM.reg(ST.make(this, 1L, 4L), "baleGrass");
        OM.reg(ST.make(this, 1L, 8L), "baleGrass");
        OM.reg(ST.make(this, 1L, 12L), "baleGrass");
        IL.Bale.set(ST.make(this, 1L, 0L));
        LH.add(this.getUnlocalizedName() + ".1", "Dry Grass Bale");
        LH.add(this.getUnlocalizedName() + ".5", "Dry Grass Bale");
        LH.add(this.getUnlocalizedName() + ".9", "Dry Grass Bale");
        LH.add(this.getUnlocalizedName() + ".13", "Dry Grass Bale");
        OM.reg(ST.make(this, 1L, 1L), "baleGrassDry");
        OM.reg(ST.make(this, 1L, 5L), "baleGrassDry");
        OM.reg(ST.make(this, 1L, 9L), "baleGrassDry");
        OM.reg(ST.make(this, 1L, 13L), "baleGrassDry");
        IL.Bale_Dry.set(ST.make(this, 1L, 1L));
        LH.add(this.getUnlocalizedName() + ".2", "Moldy Grass Bale");
        LH.add(this.getUnlocalizedName() + ".6", "Moldy Grass Bale");
        LH.add(this.getUnlocalizedName() + ".10", "Moldy Grass Bale");
        LH.add(this.getUnlocalizedName() + ".14", "Moldy Grass Bale");
        OM.reg(ST.make(this, 1L, 2L), "baleGrassMoldy");
        OM.reg(ST.make(this, 1L, 6L), "baleGrassMoldy");
        OM.reg(ST.make(this, 1L, 10L), "baleGrassMoldy");
        OM.reg(ST.make(this, 1L, 14L), "baleGrassMoldy");
        IL.Bale_Moldy.set(ST.make(this, 1L, 2L));
        LH.add(this.getUnlocalizedName() + ".3", "Rotten Grass Bale");
        LH.add(this.getUnlocalizedName() + ".7", "Rotten Grass Bale");
        LH.add(this.getUnlocalizedName() + ".11", "Rotten Grass Bale");
        LH.add(this.getUnlocalizedName() + ".15", "Rotten Grass Bale");
        OM.reg(ST.make(this, 1L, 3L), "baleGrassRotten");
        OM.reg(ST.make(this, 1L, 7L), "baleGrassRotten");
        OM.reg(ST.make(this, 1L, 11L), "baleGrassRotten");
        OM.reg(ST.make(this, 1L, 15L), "baleGrassRotten");
        IL.Bale_Rotten.set(ST.make(this, 1L, 3L));
    }

    @Override
    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
        if ((WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 1) == 1) {
            return;
        }
        aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2400 + CS.RNGSUS.nextInt(2400));
    }

    @Override
    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        boolean tWet;
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if ((aMeta & 1) == 1) {
            return;
        }
        aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 1100 + CS.RNGSUS.nextInt(200));
        if (aRandom.nextInt(3) > 0) {
            return;
        }
        if (aWorld.provider.isHellWorld && (aMeta & 2) == 0) {
            aWorld.setBlock(aX, aY, aZ, (Block)this, aMeta & 0xC | 1, 3);
            return;
        }
        if (aRandom.nextInt(3) > 0 && WD.envTemp(aWorld, aX, aY, aZ) < 283L) {
            return;
        }
        if (!(aRandom.nextInt(3) <= 0 || aWorld.isDaytime() && !aWorld.isRaining() && aWorld.canBlockSeeTheSky(aX, aY + 2, aZ))) {
            return;
        }
        BiomeGenBase tBiome = aWorld.getBiomeGenForCoords(aX, aZ);
        boolean bl = tWet = tBiome.rainfall > 0.8f || CS.BIOMES_INFINITE_WATER.contains(tBiome.biomeName);
        if (!tWet) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!WD.anywater((IBlockAccess)aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide])) continue;
                tWet = true;
                break;
            }
        }
        if ((aMeta & 3) == 0) {
            if (tWet || aWorld.isRaining() && tBiome.rainfall > 0.0f && aWorld.getPrecipitationHeight(aX, aZ) <= aY + 2) {
                aWorld.setBlock(aX, aY, aZ, (Block)this, aMeta & 0xC | 2, 3);
                return;
            }
            aWorld.setBlock(aX, aY, aZ, (Block)this, aMeta & 0xC | 1, 3);
            return;
        }
        if (tWet || aRandom.nextInt(42) == 0 || aWorld.isRaining() && tBiome.rainfall > 0.0f && aWorld.getPrecipitationHeight(aX, aZ) <= aY + 2) {
            aWorld.setBlock(aX, aY, aZ, (Block)this, aMeta & 0xC | 3, 3);
            return;
        }
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        super.addInformation(aStack, aMeta, aPlayer, aList, aF3_H);
        if ((aMeta & 3) == 0) {
            aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.bale"));
            if (aPlayer != null) {
                if (aPlayer.worldObj.provider.isHellWorld) {
                    aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.bale.dry"));
                } else {
                    int aX = UT.Code.roundDown(aPlayer.posX);
                    int aY = UT.Code.roundDown(aPlayer.posY);
                    int aZ = UT.Code.roundDown(aPlayer.posZ);
                    BiomeGenBase tBiome = aPlayer.worldObj.getBiomeGenForCoords(aX, aZ);
                    if (tBiome.rainfall > 0.8f || aPlayer.worldObj.isRaining() && tBiome.rainfall > 0.0f && aPlayer.worldObj.getPrecipitationHeight(aX, aZ) <= aY + 2) {
                        aList.add(LH.Chat.ORANGE + LH.get("gt.tooltip.bale.rot"));
                    } else {
                        aList.add(LH.Chat.YELLOW + LH.get("gt.tooltip.bale.dry"));
                    }
                }
            }
        }
    }

    static {
        LH.add("gt.tooltip.bale", "Bale dries or rots when placed");
        LH.add("gt.tooltip.bale.dry", "It would dry if placed here at the moment");
        LH.add("gt.tooltip.bale.rot", "It would rot if placed here at the moment");
    }
}

