/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.config.Config;
import gregapi.data.CS;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public abstract class WorldgenObject {
    public boolean mEnabled;
    public boolean mInvalid = false;
    public final String mName;
    public final String mCategory;
    public final Map<Integer, Boolean> mDimEnabled = new HashMap<Integer, Boolean>();

    @SafeVarargs
    public WorldgenObject(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        if (UT.Code.stringInvalid(aName)) {
            throw new IllegalArgumentException("The Name has to be not null and is also not allowed to be an empty String");
        }
        this.mName = aName;
        this.mCategory = "worldgenerator." + this.mName;
        this.mEnabled = this.getConfigFile().get((Object)this.mCategory, "Enabled", aDefault);
        for (List<WorldgenObject> aList : aLists) {
            aList.add(this);
        }
    }

    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        return false;
    }

    public boolean enabled(World aWorld, int aDimType) {
        if (this.mInvalid) {
            return false;
        }
        Boolean tAllowed = this.mDimEnabled.get(aWorld.provider.dimensionId);
        if (tAllowed != null) {
            return tAllowed != false && this.mEnabled;
        }
        boolean tValue = this.getConfigFile().get((Object)(this.mCategory + ".dim"), aWorld.provider.getDimensionName().replaceAll(" ", "_"), true);
        this.mDimEnabled.put(aWorld.provider.dimensionId, tValue);
        return tValue && this.mEnabled;
    }

    public void reset(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
    }

    public boolean checkForMajorWorldgen(World aWorld, int aMinX, int aMinZ, int aMaxX, int aMaxZ) {
        if (aWorld.provider.dimensionId == 0) {
            if (CS.GENERATE_STREETS && (Math.abs(aMinX) < 64 || Math.abs(aMaxX) < 64 || Math.abs(aMinZ) < 64 || Math.abs(aMaxZ) < 64)) {
                return true;
            }
            if (CS.GENERATE_BIOMES && aMinX >= -96 && aMinX <= 80 && aMinZ >= -96 && aMinZ <= 80) {
                return true;
            }
        }
        return false;
    }

    public Config getConfigFile() {
        return CS.ConfigsGT.WORLDGEN;
    }
}

