/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import gregapi.GT_API;
import gregapi.block.IBlockDebugable;
import gregapi.block.IBlockExtendedMetaData;
import gregapi.block.IBlockPlacable;
import gregapi.block.IBlockTileEntity;
import gregapi.block.metatype.BlockMetaType;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.TD;
import gregapi.event.BlockScanningEvent;
import gregapi.item.IItemGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntityRunningPassively;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.blocks.fluids.BlockWaterlike;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.nodes.INode;
import twilightforest.TwilightForestMod;

public class WD {
    public static byte WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD = 0;

    public static ItemStack suck(IHasWorldAndCoords aCoordinates) {
        return WD.suck(aCoordinates.getWorld(), aCoordinates.getX(), aCoordinates.getY(), aCoordinates.getZ());
    }

    public static ItemStack suck(World aWorld, double aX, double aY, double aZ) {
        return WD.suck(aWorld, aX, aY, aZ, 1.0, 1.0, 1.0);
    }

    public static ItemStack suck(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        for (EntityItem tItem : aWorld.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
            if (tItem.isDead) continue;
            aWorld.removeEntity((Entity)tItem);
            ItemStack rStack = tItem.getEntityItem();
            tItem.setEntityItemStack(ST.amount(0L, rStack));
            tItem.setDead();
            return rStack;
        }
        return null;
    }

    public static List<ItemStack> suckAll(IHasWorldAndCoords aCoordinates) {
        return WD.suckAll(aCoordinates.getWorld(), aCoordinates.getX(), aCoordinates.getY(), aCoordinates.getZ());
    }

    public static List<ItemStack> suckAll(World aWorld, double aX, double aY, double aZ) {
        return WD.suckAll(aWorld, aX, aY, aZ, 1.0, 1.0, 1.0);
    }

    public static List<ItemStack> suckAll(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        List tList = aWorld.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)));
        if (tList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayListNoNulls<ItemStack> rOutput = ST.arraylist(new ItemStack[0]);
        for (EntityItem tItem : tList) {
            if (tItem.isDead) continue;
            aWorld.removeEntity((Entity)tItem);
            ItemStack rStack = tItem.getEntityItem();
            tItem.setEntityItemStack(ST.amount(0L, rStack));
            tItem.setDead();
            rOutput.add(rStack);
        }
        return rOutput;
    }

    public static boolean obstructed(World aWorld, int aX, int aY, int aZ, byte aSide) {
        Block tBlock;
        if (!CS.OBSTRUCTION_CHECKS) {
            return false;
        }
        TileEntity tTileEntity = WD.te(aWorld, aX += CS.OFFX[aSide], aY += CS.OFFY[aSide], aZ += CS.OFFZ[aSide], true);
        if (tTileEntity != null) {
            if (tTileEntity instanceof ITileEntityQuickObstructionCheck) {
                return ((ITileEntityQuickObstructionCheck)tTileEntity).isObstructingBlockAt(CS.OPOS[aSide]);
            }
            if (MD.TC.mLoaded && tTileEntity instanceof INode) {
                return false;
            }
        }
        if ((tBlock = aWorld.getBlock(aX, aY, aZ)) instanceof BlockTrapDoor || tBlock instanceof BlockDoor || tBlock instanceof BlockLadder) {
            return false;
        }
        AxisAlignedBB tBoundingBox = tBlock.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        if (tBoundingBox == null) {
            return false;
        }
        switch (aSide) {
            case 0: {
                return tBoundingBox.maxY - (double)aY > (double)CS.PX_N[4] && tBoundingBox.maxX - (double)aX > (double)CS.PX_P[2] && tBoundingBox.minX - (double)aX < (double)CS.PX_N[2] && tBoundingBox.maxZ - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.minZ - (double)aZ < (double)CS.PX_N[2];
            }
            case 1: {
                return tBoundingBox.minY - (double)aY < (double)CS.PX_P[4] && tBoundingBox.maxX - (double)aX > (double)CS.PX_P[2] && tBoundingBox.minX - (double)aX < (double)CS.PX_N[2] && tBoundingBox.maxZ - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.minZ - (double)aZ < (double)CS.PX_N[2];
            }
            case 2: {
                return tBoundingBox.maxZ - (double)aZ > (double)CS.PX_N[4] && tBoundingBox.maxX - (double)aX > (double)CS.PX_P[2] && tBoundingBox.minX - (double)aX < (double)CS.PX_N[2] && tBoundingBox.maxY - (double)aY > (double)CS.PX_P[2] && tBoundingBox.minY - (double)aY < (double)CS.PX_N[2];
            }
            case 3: {
                return tBoundingBox.minZ - (double)aZ < (double)CS.PX_P[4] && tBoundingBox.maxX - (double)aX > (double)CS.PX_P[2] && tBoundingBox.minX - (double)aX < (double)CS.PX_N[2] && tBoundingBox.maxY - (double)aY > (double)CS.PX_P[2] && tBoundingBox.minY - (double)aY < (double)CS.PX_N[2];
            }
            case 4: {
                return tBoundingBox.maxX - (double)aX > (double)CS.PX_N[4] && tBoundingBox.maxZ - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.minZ - (double)aZ < (double)CS.PX_N[2] && tBoundingBox.maxY - (double)aY > (double)CS.PX_P[2] && tBoundingBox.minY - (double)aY < (double)CS.PX_N[2];
            }
            case 5: {
                return tBoundingBox.minX - (double)aX < (double)CS.PX_P[4] && tBoundingBox.maxZ - (double)aZ > (double)CS.PX_P[2] && tBoundingBox.minZ - (double)aZ < (double)CS.PX_N[2] && tBoundingBox.maxY - (double)aY > (double)CS.PX_P[2] && tBoundingBox.minY - (double)aY < (double)CS.PX_N[2];
            }
        }
        return false;
    }

    public static MovingObjectPosition getMOP(World aWorld, EntityPlayer aPlayer, boolean aFlag) {
        Vec3 vec3 = Vec3.createVectorHelper((double)(aPlayer.prevPosX + (aPlayer.posX - aPlayer.prevPosX)), (double)(aPlayer.prevPosY + (aPlayer.posY - aPlayer.prevPosY) + (double)(aWorld.isRemote ? aPlayer.getEyeHeight() - aPlayer.getDefaultEyeHeight() : aPlayer.getEyeHeight())), (double)(aPlayer.prevPosZ + (aPlayer.posZ - aPlayer.prevPosZ)));
        float tPitch = aPlayer.prevRotationPitch + (aPlayer.rotationPitch - aPlayer.prevRotationPitch);
        float tYaw = aPlayer.prevRotationYaw + (aPlayer.rotationYaw - aPlayer.prevRotationYaw);
        float tZ = MathHelper.cos((float)(-tYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float tX = MathHelper.sin((float)(-tYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float tW = -MathHelper.cos((float)(-tPitch * ((float)Math.PI / 180)));
        float tY = MathHelper.sin((float)(-tPitch * ((float)Math.PI / 180)));
        double tReach = aPlayer instanceof EntityPlayerMP ? ((EntityPlayerMP)aPlayer).theItemInWorldManager.getBlockReachDistance() : 5.0;
        return aWorld.func_147447_a(vec3, vec3.addVector((double)(tX * tW) * tReach, (double)tY * tReach, (double)(tZ * tW) * tReach), aFlag, !aFlag, false);
    }

    public static boolean dimOverworldLike(World aWorld) {
        return aWorld != null && WD.dimOverworldLike(aWorld.provider);
    }

    public static boolean dimOverworldLike(WorldProvider aProvider) {
        return aProvider.dimensionId == 0 || WD.dimOverworldLike(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimOverworldLike(WorldProvider aProvider, String aProviderClassName) {
        return aProvider.dimensionId == 0 || WD.dimENVM(aProvider, aProviderClassName) || WD.dimA97(aProvider, aProviderClassName) || WD.dimWTCH(aProvider, aProviderClassName) || WD.dimMYST(aProvider, aProviderClassName) || WD.dimCW2(aProvider, aProviderClassName);
    }

    public static boolean dimPlanet(World aWorld) {
        return aWorld != null && WD.dimPlanet(aWorld.provider);
    }

    public static boolean dimPlanet(WorldProvider aProvider) {
        return Math.abs(aProvider.dimensionId) > 1 && WD.dimPlanet(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimPlanet(WorldProvider aProvider, String aProviderClassName) {
        return Math.abs(aProvider.dimensionId) > 1 && !WD.dimMYST(aProvider, aProviderClassName) && !WD.dimATUM(aProvider, aProviderClassName) && !WD.dimWTCH(aProvider, aProviderClassName) && !WD.dimA97(aProvider, aProviderClassName) && !WD.dimCW2(aProvider, aProviderClassName) && !WD.dimTF(aProvider, aProviderClassName) && !WD.dimERE(aProvider, aProviderClassName) && !WD.dimBTL(aProvider, aProviderClassName) && !WD.dimENVM(aProvider, aProviderClassName) && !WD.dimDD(aProvider, aProviderClassName) && !WD.dimLM(aProvider, aProviderClassName) && !WD.dimAETHER(aProvider, aProviderClassName) && !WD.dimALF(aProvider, aProviderClassName) && !WD.dimTROPIC(aProvider, aProviderClassName) && !WD.dimCANDY(aProvider, aProviderClassName);
    }

    public static boolean dimMYST(World aWorld) {
        return aWorld != null && WD.dimMYST(aWorld.provider);
    }

    public static boolean dimMYST(WorldProvider aProvider) {
        return MD.MYST.mLoaded && aProvider.getClass().getName().toLowerCase().contains("com.xcompwiz.mystcraft");
    }

    public static boolean dimMYST(WorldProvider aProvider, String aProviderClassName) {
        return MD.MYST.mLoaded && aProvider.getClass().getName().toLowerCase().contains("com.xcompwiz.mystcraft");
    }

    public static boolean dimCANDY(World aWorld) {
        return aWorld != null && WD.dimCANDY(aWorld.provider);
    }

    public static boolean dimCANDY(WorldProvider aProvider) {
        return MD.CANDY.mLoaded && WD.dimCANDY(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCANDY(WorldProvider aProvider, String aProviderClassName) {
        return MD.CANDY.mLoaded && "WorldProviderCandy".equalsIgnoreCase(UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimTROPIC(World aWorld) {
        return aWorld != null && WD.dimTROPIC(aWorld.provider);
    }

    public static boolean dimTROPIC(WorldProvider aProvider) {
        return MD.TROPIC.mLoaded && WD.dimTROPIC(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimTROPIC(WorldProvider aProvider, String aProviderClassName) {
        return MD.TROPIC.mLoaded && "WorldProviderTropicraft".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimATUM(World aWorld) {
        return aWorld != null && WD.dimATUM(aWorld.provider);
    }

    public static boolean dimATUM(WorldProvider aProvider) {
        return MD.ATUM.mLoaded && WD.dimATUM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimATUM(WorldProvider aProvider, String aProviderClassName) {
        return MD.ATUM.mLoaded && "AtumWorldProvider".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimTF(World aWorld) {
        return aWorld != null && WD.dimTF(aWorld.provider);
    }

    public static boolean dimTF(WorldProvider aProvider) {
        return MD.TF.mLoaded && aProvider.dimensionId == TwilightForestMod.dimensionID;
    }

    public static boolean dimTF(WorldProvider aProvider, String aProviderClassName) {
        return MD.TF.mLoaded && aProvider.dimensionId == TwilightForestMod.dimensionID;
    }

    public static boolean dimBTL(World aWorld) {
        return aWorld != null && WD.dimBTL(aWorld.provider);
    }

    public static boolean dimBTL(WorldProvider aProvider) {
        return MD.BTL.mLoaded && WD.dimBTL(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimBTL(WorldProvider aProvider, String aProviderClassName) {
        return MD.BTL.mLoaded && "WorldProviderBetweenlands".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimERE(World aWorld) {
        return aWorld != null && WD.dimERE(aWorld.provider);
    }

    public static boolean dimERE(WorldProvider aProvider) {
        return MD.ERE.mLoaded && WD.dimERE(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimERE(WorldProvider aProvider, String aProviderClassName) {
        return MD.ERE.mLoaded && "WorldProviderErebus".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimALF(World aWorld) {
        return aWorld != null && WD.dimALF(aWorld.provider);
    }

    public static boolean dimALF(WorldProvider aProvider) {
        return MD.ALF.mLoaded && WD.dimALF(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimALF(WorldProvider aProvider, String aProviderClassName) {
        return MD.ALF.mLoaded && "WorldProviderAlfheim".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimDD(World aWorld) {
        return aWorld != null && WD.dimDD(aWorld.provider);
    }

    public static boolean dimDD(WorldProvider aProvider) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && WD.dimDD(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimDD(WorldProvider aProvider, String aProviderClassName) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && "WorldProviderUnderdark".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimLM(World aWorld) {
        return aWorld != null && WD.dimLM(aWorld.provider);
    }

    public static boolean dimLM(WorldProvider aProvider) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && WD.dimLM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimLM(WorldProvider aProvider, String aProviderClassName) {
        return (MD.ExU.mLoaded || MD.ExS.mLoaded) && "WorldProviderEndOfTime".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimENVM(World aWorld) {
        return aWorld != null && WD.dimENVM(aWorld.provider);
    }

    public static boolean dimENVM(WorldProvider aProvider) {
        return MD.ENVM.mLoaded && WD.dimENVM(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimENVM(WorldProvider aProvider, String aProviderClassName) {
        return MD.ENVM.mLoaded && "WorldProviderCaves".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimA97(World aWorld) {
        return aWorld != null && WD.dimA97(aWorld.provider);
    }

    public static boolean dimA97(WorldProvider aProvider) {
        return MD.A97_MINING.mLoaded && WD.dimA97(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimA97(WorldProvider aProvider, String aProviderClassName) {
        return MD.A97_MINING.mLoaded && "WorldProviderMiner".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2(World aWorld) {
        return aWorld != null && WD.dimCW2(aWorld.provider);
    }

    public static boolean dimCW2(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2(WorldProvider aProvider, String aProviderClassName) {
        return WD.dimCW2AquaCavern(aProvider, aProviderClassName) || WD.dimCW2Caveland(aProvider, aProviderClassName) || WD.dimCW2Cavenia(aProvider, aProviderClassName) || WD.dimCW2Cavern(aProvider, aProviderClassName) || WD.dimCW2Caveworld(aProvider, aProviderClassName);
    }

    public static boolean dimCW2AquaCavern(World aWorld) {
        return aWorld != null && WD.dimCW2AquaCavern(aWorld.provider);
    }

    public static boolean dimCW2AquaCavern(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2AquaCavern(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2AquaCavern(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderAquaCavern".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Caveland(World aWorld) {
        return aWorld != null && WD.dimCW2Caveland(aWorld.provider);
    }

    public static boolean dimCW2Caveland(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Caveland(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Caveland(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCaveland".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Cavenia(World aWorld) {
        return aWorld != null && WD.dimCW2Cavenia(aWorld.provider);
    }

    public static boolean dimCW2Cavenia(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Cavenia(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Cavenia(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCavenia".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Cavern(World aWorld) {
        return aWorld != null && WD.dimCW2Cavern(aWorld.provider);
    }

    public static boolean dimCW2Cavern(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Cavern(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Cavern(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCavern".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimCW2Caveworld(World aWorld) {
        return aWorld != null && WD.dimCW2Caveworld(aWorld.provider);
    }

    public static boolean dimCW2Caveworld(WorldProvider aProvider) {
        return MD.CW2.mLoaded && WD.dimCW2Caveworld(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimCW2Caveworld(WorldProvider aProvider, String aProviderClassName) {
        return MD.CW2.mLoaded && "WorldProviderCaveworld".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimWTCH(World aWorld) {
        return aWorld != null && WD.dimWTCH(aWorld.provider);
    }

    public static boolean dimWTCH(WorldProvider aProvider) {
        return MD.WTCH.mLoaded && WD.dimWTCH(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimWTCH(WorldProvider aProvider, String aProviderClassName) {
        return MD.WTCH.mLoaded && "WorldProviderDreamWorld".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean dimAETHER(World aWorld) {
        return aWorld != null && WD.dimAETHER(aWorld.provider);
    }

    public static boolean dimAETHER(WorldProvider aProvider) {
        return (MD.AETHER.mLoaded || MD.AETHEL.mLoaded) && WD.dimAETHER(aProvider, UT.Reflection.getLowercaseClass(aProvider));
    }

    public static boolean dimAETHER(WorldProvider aProvider, String aProviderClassName) {
        return MD.AETHEL.mLoaded ? "AetherWorldProvider".equalsIgnoreCase(aProviderClassName) : MD.AETHER.mLoaded && "WorldProviderAether".equalsIgnoreCase(aProviderClassName);
    }

    public static boolean move(Entity aEntity, int aDimension, double aX, double aY, double aZ) {
        WorldServer tTargetWorld = DimensionManager.getWorld((int)aDimension);
        WorldServer tOriginalWorld = DimensionManager.getWorld((int)aEntity.worldObj.provider.dimensionId);
        if (tTargetWorld != null && tOriginalWorld != null && tTargetWorld != tOriginalWorld) {
            if (aEntity.ridingEntity != null) {
                aEntity.mountEntity(null);
            }
            if (aEntity.riddenByEntity != null) {
                aEntity.riddenByEntity.mountEntity(null);
            }
            if (aEntity instanceof EntityPlayerMP) {
                EntityPlayerMP aPlayer = (EntityPlayerMP)aEntity;
                aPlayer.dimension = aDimension;
                aPlayer.playerNetServerHandler.sendPacket((Packet)new S07PacketRespawn(aPlayer.dimension, aPlayer.worldObj.difficultySetting, aPlayer.worldObj.getWorldInfo().getTerrainType(), aPlayer.theItemInWorldManager.getGameType()));
                tOriginalWorld.removePlayerEntityDangerously((Entity)aPlayer);
                aPlayer.isDead = false;
                aPlayer.setWorld((World)tTargetWorld);
                MinecraftServer.getServer().getConfigurationManager().func_72375_a(aPlayer, tOriginalWorld);
                aPlayer.playerNetServerHandler.setPlayerLocation(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.rotationYaw, aPlayer.rotationPitch);
                aPlayer.theItemInWorldManager.setWorld(tTargetWorld);
                MinecraftServer.getServer().getConfigurationManager().updateTimeAndWeatherForPlayer(aPlayer, tTargetWorld);
                MinecraftServer.getServer().getConfigurationManager().syncPlayerInventory(aPlayer);
                for (PotionEffect potioneffect : aPlayer.getActivePotionEffects()) {
                    aPlayer.playerNetServerHandler.sendPacket((Packet)new S1DPacketEntityEffect(aPlayer.getEntityId(), potioneffect));
                }
                aPlayer.playerNetServerHandler.setPlayerLocation(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.rotationYaw, aPlayer.rotationPitch);
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)aPlayer, tOriginalWorld.provider.dimensionId, aDimension);
            } else {
                aEntity.setPosition(aX + 0.5, aY + 0.5, aZ + 0.5);
                aEntity.worldObj.removeEntity(aEntity);
                aEntity.dimension = aDimension;
                aEntity.isDead = false;
                Entity tNewEntity = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)aEntity), (World)tTargetWorld);
                if (tNewEntity != null) {
                    tNewEntity.copyDataFrom(aEntity, true);
                    aEntity.setDead();
                    tNewEntity.isDead = false;
                    boolean temp = tNewEntity.forceSpawn;
                    tNewEntity.forceSpawn = true;
                    tTargetWorld.spawnEntityInWorld(tNewEntity);
                    tNewEntity.forceSpawn = temp;
                    tNewEntity.isDead = false;
                    aEntity = tNewEntity;
                }
            }
            if (aEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)aEntity).setPositionAndUpdate(aX, aY, aZ);
            } else {
                aEntity.setPosition(aX, aY, aZ);
            }
            tOriginalWorld.resetUpdateEntityTick();
            tTargetWorld.resetUpdateEntityTick();
            return true;
        }
        return false;
    }

    public static boolean mark(World aWorld, int aX, int aZ) {
        if (aWorld == null || aWorld.isRemote) {
            return false;
        }
        Chunk aChunk = aWorld.getChunkFromBlockCoords(aX, aZ);
        if (aChunk == null) {
            aWorld.getBlockMetadata(aX, 0, aZ);
            aChunk = aWorld.getChunkFromBlockCoords(aX, aZ);
            if (aChunk == null) {
                CS.ERR.println("Some important Chunk does not exist for some reason at Coordinates X: " + aX + " and Z: " + aZ);
                return false;
            }
        }
        aChunk.setChunkModified();
        return true;
    }

    public static boolean mark(Object aTileEntity) {
        return aTileEntity instanceof TileEntity && WD.mark(((TileEntity)aTileEntity).getWorldObj(), ((TileEntity)aTileEntity).xCoord, ((TileEntity)aTileEntity).zCoord);
    }

    public static DelegatorTileEntity<TileEntity> te(World aWorld, ChunkCoordinates aCoords, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.te(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ, aSide, aLoadUnloadedChunks);
    }

    public static DelegatorTileEntity<TileEntity> te(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, aLoadUnloadedChunks);
        return aTileEntity instanceof ITileEntityDelegating ? ((ITileEntityDelegating)aTileEntity).getDelegateTileEntity(aSide) : new DelegatorTileEntity<TileEntity>(aTileEntity, aWorld, aX, aY, aZ, aSide);
    }

    public static TileEntity te(World aWorld, ChunkCoordinates aCoords, boolean aLoadUnloadedChunks) {
        return WD.te(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ, aLoadUnloadedChunks);
    }

    public static TileEntity te(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        if (aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ)) {
            TileEntity rTileEntity = aWorld.getTileEntity(aX, aY, aZ);
            if (rTileEntity instanceof ITileEntityUnloadable && ((ITileEntityUnloadable)rTileEntity).isDead()) {
                return null;
            }
            if (rTileEntity != null) {
                return rTileEntity;
            }
            rTileEntity = CS.LAST_BROKEN_TILEENTITY.get();
            if (rTileEntity != null && rTileEntity.xCoord == aX && rTileEntity.yCoord == aY && rTileEntity.zCoord == aZ) {
                return rTileEntity;
            }
            Block tBlock = aWorld.getBlock(aX, aY, aZ);
            return tBlock instanceof IBlockTileEntity ? ((IBlockTileEntity)tBlock).getTileEntity((IBlockAccess)aWorld, aX, aY, aZ) : null;
        }
        return null;
    }

    public static TileEntity invalidateTileEntityWithNegativeYCoord(int aX, int aY, int aZ, TileEntity aTileEntity) {
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD == 0) {
            UT.Entities.chat(null, "Please provide the gregtech.log File to Greg, there was a weird Error");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD < 10) {
            CS.ERR.println("===============================");
            CS.ERR.println("X:" + aX);
            CS.ERR.println("Y:" + aY);
            CS.ERR.println("Z:" + aZ);
            CS.ERR.println("Class:" + aTileEntity.getClass());
            new Throwable().printStackTrace(CS.ERR);
            CS.ERR.println("===============================");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD == 9) {
            UT.Entities.chat(null, "Please provide the gregtech.log File to Greg, there was a LOT of weird Errors");
        }
        if (WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD < 99) {
            WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD = (byte)(WARN_ABOUT_TILEENTITY_NEGATIVE_Y_COORD + 1);
        }
        aTileEntity.invalidate();
        aTileEntity.yCoord = 0;
        return aTileEntity;
    }

    public static TileEntity te(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
        if (aY < 0) {
            return WD.invalidateTileEntityWithNegativeYCoord(aX, aY, aZ, aTileEntity);
        }
        if (aCauseTileEntityUpdates) {
            aWorld.setTileEntity(aX, aY, aZ, aTileEntity);
        } else {
            Chunk tChunk = aWorld.getChunkFromChunkCoords(aX >> 4, aZ >> 4);
            if (tChunk != null) {
                aWorld.addTileEntity(aTileEntity);
                tChunk.func_150812_a(aX & 0xF, aY, aZ & 0xF, aTileEntity);
                tChunk.setChunkModified();
            }
        }
        return aTileEntity;
    }

    public static boolean oxygen(World aWorld, int aX, int aY, int aZ) {
        return !MD.GC.mLoaded || !(aWorld.provider instanceof IGalacticraftWorldProvider) || OxygenUtil.checkTorchHasOxygen((World)aWorld, (Block)CS.NB, (int)aX, (int)aY, (int)aZ);
    }

    public static boolean collectable_air(World aWorld, int aX, int aY, int aZ) {
        return (!MD.GC.mLoaded || !(aWorld.provider instanceof IGalacticraftWorldProvider)) && !WD.hasCollide(aWorld, aX, aY, aZ) && !WD.liquid(aWorld, aX, aY, aZ);
    }

    public static long envTemp(World aWorld, int aX, int aY, int aZ) {
        return WD.envTemp(aWorld.getBiomeGenForCoords(aX, aZ), aX, aY, aZ);
    }

    public static long envTemp(BiomeGenBase aBiome, int aX, int aY, int aZ) {
        return Math.max(1L, aBiome == null ? 293L : (long)(270.0f + aBiome.getFloatTemperature(aX, aY, aZ) * 20.0f));
    }

    public static long envTemp(BiomeGenBase aBiome) {
        return Math.max(1L, aBiome == null ? 293L : (long)(270.0f + aBiome.temperature * 20.0f));
    }

    public static int waterLevel(World aWorld) {
        return WD.waterLevel(aWorld.provider, 62);
    }

    public static int waterLevel(WorldProvider aProvider) {
        return WD.waterLevel(aProvider, 62);
    }

    public static int waterLevel(World aWorld, int aDefaultOverworld) {
        return WD.waterLevel(aWorld.provider, aDefaultOverworld);
    }

    public static int waterLevel(WorldProvider aProvider, int aDefaultOverworld) {
        return aProvider.dimensionId == 0 ? WD.waterLevel(aDefaultOverworld) : (aProvider.hasNoSky || WD.dimTF(aProvider) ? 31 : 62);
    }

    public static int waterLevel(int aDefaultOverworld) {
        return MD.TFC.mLoaded || MD.TFCP.mLoaded ? 143 : aDefaultOverworld;
    }

    public static int waterLevel() {
        return WD.waterLevel(62);
    }

    public static long temperature(World aWorld, int aX, int aY, int aZ) {
        long rTemperature = WD.envTemp(aWorld, aX, aY, aZ);
        if (WD.burning(aWorld, aX, aY, aZ)) {
            rTemperature = Math.max(rTemperature, 473L);
        }
        for (ChunkCoordinates tCoords : new ChunkCoordinates[]{new ChunkCoordinates(aX, aY, aZ), new ChunkCoordinates(aX + 1, aY, aZ), new ChunkCoordinates(aX - 1, aY, aZ), new ChunkCoordinates(aX, aY + 1, aZ), new ChunkCoordinates(aX, aY - 1, aZ), new ChunkCoordinates(aX, aY, aZ + 1), new ChunkCoordinates(aX, aY, aZ - 1)}) {
            Block tBlock = WD.block(aWorld, tCoords.posX, tCoords.posY, tCoords.posZ, false);
            if (tBlock == Blocks.lava || tBlock == Blocks.flowing_lava) {
                rTemperature = Math.max(rTemperature, 773L);
                continue;
            }
            if (!(tBlock instanceof BlockFire)) continue;
            rTemperature = Math.max(rTemperature, 473L);
        }
        return rTemperature;
    }

    public static ItemStack stack(World aWorld, int aX, int aY, int aZ) {
        Block tBlock;
        return ST.make(tBlock, 1L, (tBlock = aWorld.getBlock(aX, aY, aZ)) instanceof IBlockExtendedMetaData ? (long)((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX, aY, aZ) : (long)aWorld.getBlockMetadata(aX, aY, aZ));
    }

    public static void update(IBlockAccess aWorld, int aX, int aY, int aZ) {
        EntityPlayer tPlayer;
        ((World)aWorld).markBlockForUpdate(aX, aY, aZ);
        if (CS.CLIENT_BLOCKUPDATE_SOUNDS && CS.CODE_CLIENT && CS.CLIENT_TIME > 100L && (tPlayer = GT_API.api_proxy.getThePlayer()) != null && Math.abs(tPlayer.posX - (double)aX) < 16.0 && Math.abs(tPlayer.posY - (double)aY) < 16.0 && Math.abs(tPlayer.posZ - (double)aZ) < 16.0) {
            UT.Sounds.play("fireworks.launch", 1, 1.0f, 1.0f, aX, aY, aZ);
        }
    }

    public static Block block(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ);
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ) ? aWorld.getBlock(aX, aY, aZ) : CS.NB;
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.block(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static Block block(World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.block((IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static byte meta(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return UT.Code.bind4(aWorld.getBlockMetadata(aX, aY, aZ));
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ) ? UT.Code.bind4(aWorld.getBlockMetadata(aX, aY, aZ)) : (byte)0;
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.meta(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static byte meta(World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.meta((IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static byte meta(long aBitAnd, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return UT.Code.bind4((long)aWorld.getBlockMetadata(aX, aY, aZ) & aBitAnd);
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ) ? UT.Code.bind4((long)aWorld.getBlockMetadata(aX, aY, aZ) & aBitAnd) : (byte)0;
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
        return WD.meta(aBitAnd, aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], aLoadUnloadedChunks);
    }

    public static byte meta(long aBitAnd, World aWorld, int aX, int aY, int aZ, byte aSide) {
        return WD.meta(aBitAnd, (IBlockAccess)aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]);
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta, long aFlags) {
        return WD.set(aWorld, aX, aY, aZ, aBlock, aMeta, aFlags, aBlock.isOpaqueCube());
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta, long aFlags, boolean aRemoveGrassBelow) {
        Block tBlock;
        if (aRemoveGrassBelow && ((tBlock = aWorld.getBlock(aX, aY - 1, aZ)) == Blocks.grass || tBlock == Blocks.mycelium)) {
            aWorld.setBlock(aX, aY - 1, aZ, Blocks.dirt, 0, (int)((byte)aFlags));
        }
        return aWorld.setBlock(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)), (int)((byte)aFlags));
    }

    public static boolean set(Chunk aChunk, int aX, int aY, int aZ, Block aBlock, long aMeta) {
        return aChunk.func_150807_a(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)));
    }

    public static boolean set(Chunk aChunk, int aX, int aY, int aZ, Block aBlock, long aMeta, boolean aRemoveGrassBelow) {
        Block tBlock;
        if (aRemoveGrassBelow && ((tBlock = aChunk.getBlock(aX, aY - 1, aZ)) == Blocks.grass || tBlock == Blocks.mycelium)) {
            aChunk.func_150807_a(aX, aY - 1, aZ, Blocks.dirt, 0);
        }
        return aChunk.func_150807_a(aX, aY, aZ, aBlock, (int)(aBlock == CS.NB ? (byte)0 : UT.Code.bind4(aMeta)));
    }

    public static boolean replace(World aWorld, int aX, int aY, int aZ, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        if (aTargetBlock == null || aReplaceBlock == null) {
            return false;
        }
        if (aReplaceBlock != WD.block((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (aReplaceMeta != 32767L && aReplaceMeta != (long)WD.meta((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        return aWorld.setBlock(aX, aY, aZ, aTargetBlock, (int)UT.Code.bind4(aTargetMeta), 2);
    }

    public static boolean replace(World aWorld, ChunkCoordinates aCoords, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        return WD.replace(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta);
    }

    public static boolean replaceAll(World aWorld, int aX, int aY, int aZ, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        return WD.replaceAll(aWorld, new ChunkCoordinates(aX, aY, aZ), aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta);
    }

    public static boolean replaceAll(World aWorld, ChunkCoordinates aCoords, Block aReplaceBlock, long aReplaceMeta, Block aTargetBlock, long aTargetMeta) {
        if (!WD.replace(aWorld, aCoords, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta)) {
            return false;
        }
        HashSetNoNulls<ChunkCoordinates> tDone = new HashSetNoNulls<ChunkCoordinates>(false, aCoords);
        HashSetNoNulls<Object> tCheck = new HashSetNoNulls<ChunkCoordinates>(false, aCoords);
        HashSetNoNulls<Object> tNext = new HashSetNoNulls();
        while (!tCheck.isEmpty() && tDone.size() < 32768) {
            tNext.clear();
            for (ChunkCoordinates tChecking : tCheck) {
                if (Math.abs(tChecking.posX - aCoords.posX) >= 128 || Math.abs(tChecking.posZ - aCoords.posZ) >= 128) continue;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            ChunkCoordinates tCoords = new ChunkCoordinates(tChecking.posX + i, tChecking.posY + j, tChecking.posZ + k);
                            if (!tDone.add(tCoords) || !WD.replace(aWorld, tCoords, aReplaceBlock, aReplaceMeta, aTargetBlock, aTargetMeta)) continue;
                            tNext.add(tCoords);
                        }
                    }
                }
            }
            HashSetNoNulls tSwap = tNext;
            tNext = tCheck;
            tCheck = tSwap;
        }
        return true;
    }

    public static boolean sign(World aWorld, int aX, int aY, int aZ, byte aSide, long aFlags, String aLine1, String aLine2, String aLine3, String aLine4) {
        aWorld.setBlock(aX, aY, aZ, Blocks.wall_sign, (int)aSide, (int)((byte)aFlags));
        TileEntity tSign = WD.te(aWorld, aX, aY, aZ, true);
        if (!(tSign instanceof TileEntitySign)) {
            return false;
        }
        ((TileEntitySign)tSign).signText[0] = aLine1;
        ((TileEntitySign)tSign).signText[1] = aLine2;
        ((TileEntitySign)tSign).signText[2] = aLine3;
        ((TileEntitySign)tSign).signText[3] = aLine4;
        return true;
    }

    public static Random random(World aWorld, long aChunkX, long aChunkZ) {
        return WD.random(aWorld.getSeed() ^ (long)aWorld.provider.dimensionId, aChunkX >> 4, aChunkZ >> 4);
    }

    public static Random random(long aSeed, long aChunkX, long aChunkZ) {
        int i;
        Random rRandom = new Random(aSeed);
        for (i = 0; i < 50; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        rRandom = new Random(aSeed ^ (rRandom.nextLong() >> 3) * aChunkX + (rRandom.nextLong() >> 3) * aChunkZ);
        for (i = 0; i < 50; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        return rRandom;
    }

    public static int random(World aWorld, int aX, int aY, int aZ, int aBound) {
        return WD.random(aWorld.getSeed() ^ (long)aWorld.provider.dimensionId, aX, aY, aZ, aBound);
    }

    public static int random(long aSeed, int aX, int aY, int aZ, int aBound) {
        int i;
        Random rRandom = new Random(aSeed ^ (long)aY);
        for (i = 0; i < 10; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        rRandom = new Random(aSeed ^ (rRandom.nextLong() >> 3) * (long)aX + (rRandom.nextLong() >> 3) * (long)aZ);
        for (i = 0; i < 10; ++i) {
            rRandom.nextInt(0xFFFFFF);
        }
        return rRandom.nextInt(aBound);
    }

    public static Random random(TileEntity aTileEntity) {
        return new Random(aTileEntity.xCoord ^ aTileEntity.yCoord ^ aTileEntity.zCoord);
    }

    public static int random(TileEntity aTileEntity, int aBound) {
        return WD.random(aTileEntity).nextInt(aBound);
    }

    public static boolean random(TileEntity aTileEntity, int aBound, long aTime) {
        return (long)WD.random(aTileEntity, aBound) == aTime % (long)aBound;
    }

    public static boolean border(int aFromX, int aFromZ, int aToX, int aToZ) {
        return aFromX >> 4 != aToX >> 4 || aFromZ >> 4 != aToZ >> 4;
    }

    public static boolean even(TileEntity aTileEntity) {
        return WD.even(aTileEntity.xCoord, aTileEntity.yCoord, aTileEntity.zCoord);
    }

    public static boolean even(ChunkCoordinates aCoords) {
        return WD.even(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    public static boolean even(int ... aCoords) {
        int i = 0;
        for (int tCoord : aCoords) {
            if (tCoord % 2 != 0) continue;
            ++i;
        }
        return i % 2 == 0;
    }

    public static int evenness(TileEntity aTileEntity) {
        return WD.evenness(aTileEntity.xCoord, aTileEntity.yCoord, aTileEntity.zCoord);
    }

    public static int evenness(ChunkCoordinates aCoords) {
        return WD.evenness(aCoords.posX, aCoords.posY, aCoords.posZ);
    }

    public static int evenness(int ... aCoords) {
        int i = 0;
        for (int tCoord : aCoords) {
            i <<= 1;
            if (tCoord % 2 == 0) continue;
            ++i;
        }
        return i;
    }

    public static boolean setIfDiff(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
        return (aWorld.getBlock(aX, aY, aZ) != aBlock || aWorld.getBlockMetadata(aX, aY, aZ) != aMeta) && aWorld.setBlock(aX, aY, aZ, aBlock, aMeta, aFlags);
    }

    public static boolean set(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        Block tBlock = ST.block(aStack);
        if (tBlock == CS.NB) {
            return false;
        }
        if (tBlock instanceof IBlockPlacable) {
            return ((IBlockPlacable)tBlock).placeBlock(aWorld, aX, aY, aZ, (byte)6, ST.meta_(aStack), aStack.getTagCompound(), true, false);
        }
        if (ST.meta_(aStack) < 16) {
            return aWorld.setBlock(aX, aY, aZ, tBlock, (int)ST.meta_(aStack), 3);
        }
        return false;
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.leafdecay(aWorld, aX, aY, aZ, aBlock, false, false);
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock, boolean aOnlyTopArea) {
        return WD.leafdecay(aWorld, aX, aY, aZ, aBlock, aOnlyTopArea, false);
    }

    public static boolean leafdecay(World aWorld, int aX, int aY, int aZ, Block aBlock, boolean aOnlyTopArea, boolean aTreeCapitator) {
        if (aBlock == null || aBlock.canSustainLeaves((IBlockAccess)aWorld, aX, aY, aZ)) {
            int j;
            int n = j = aOnlyTopArea ? 0 : -7;
            while (j <= 7) {
                for (int i = -7; i <= 7; ++i) {
                    for (int k = -7; k <= 7; ++k) {
                        Block tBlock = aWorld.getBlock(aX + i, aY + j, aZ + k);
                        if (tBlock == CS.NB) continue;
                        if (tBlock == Blocks.brown_mushroom_block || tBlock == Blocks.red_mushroom_block) {
                            if (!aTreeCapitator || Math.abs(i) > 4 || Math.abs(k) > 4 || j > 0 || j < -2) continue;
                            aWorld.func_147480_a(aX + i, aY + j, aZ + k, true);
                            continue;
                        }
                        if (IL.NeLi_Wart_Block_Crimson.equal(tBlock) || IL.NeLi_ShroomLight.equal(tBlock)) {
                            if (!aTreeCapitator || Math.abs(i) > 4 || Math.abs(k) > 4) continue;
                            aWorld.func_147480_a(aX + i, aY + j, aZ + k, true);
                            continue;
                        }
                        if (!tBlock.isLeaves((IBlockAccess)aWorld, aX + i, aY + j, aZ + k)) continue;
                        aWorld.scheduleBlockUpdate(aX + i, aY + j, aZ + k, tBlock, 1 + CS.RNGSUS.nextInt(100));
                    }
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public static boolean liquid(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid(aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean liquid(Block aBlock) {
        return aBlock instanceof BlockLiquid || aBlock instanceof IFluidBlock;
    }

    public static boolean liquid_classic(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_classic(aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean liquid_classic(Block aBlock) {
        return aBlock instanceof BlockLiquid || aBlock instanceof BlockFluidClassic;
    }

    public static boolean liquid_finite(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_finite(aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean liquid_finite(Block aBlock) {
        return aBlock instanceof BlockFluidFinite;
    }

    public static boolean liquid_borken(World aWorld, int aX, int aY, int aZ) {
        return WD.liquid_borken(aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean liquid_borken(Block aBlock) {
        return !(aBlock instanceof IItemGT) && WD.liquid_classic(aBlock);
    }

    public static boolean stone(Block aBlock, short aMeta) {
        if (aBlock == CS.NB) {
            return false;
        }
        if (aBlock == Blocks.obsidian) {
            return true;
        }
        ItemStackContainer tStack = new ItemStackContainer(aBlock, 1L, (long)aMeta);
        return CS.BlocksGT.stoneToNormalOres.containsKey(tStack) || CS.BlocksGT.stoneToBrokenOres.containsKey(tStack) || CS.BlocksGT.stoneToSmallOres.containsKey(tStack);
    }

    public static boolean floor(World aWorld, int aX, int aY, int aZ) {
        return WD.floor(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean floor(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock.isSideSolid((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[1]) || WD.floor(aBlock);
    }

    public static boolean floor(Block aBlock) {
        return aBlock.isOpaqueCube() || aBlock instanceof BlockSlab || aBlock instanceof BlockStairs || aBlock instanceof BlockMetaType;
    }

    public static boolean ore(Block aBlock, short aMeta) {
        return aBlock instanceof IBlockPlacable && (CS.BlocksGT.stoneToBrokenOres.containsValue(aBlock) || CS.BlocksGT.stoneToNormalOres.containsValue(aBlock) || CS.BlocksGT.stoneToSmallOres.containsValue(aBlock)) || OM.prefixcontains(ST.make(aBlock, 1L, (long)aMeta), TD.Prefix.ORE);
    }

    public static boolean ore_stone(Block aBlock, short aMeta) {
        return WD.ore(aBlock, aMeta) || WD.stone(aBlock, aMeta);
    }

    public static boolean visOcc(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return WD.visOpq(aWorld, aX + 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX + 1, aZ), aDefault) && WD.visOpq(aWorld, aX - 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX - 1, aZ), aDefault) && WD.visOpq(aWorld, aX, aY + 1, aZ, true, aDefault) && WD.visOpq(aWorld, aX, aY - 1, aZ, true, aDefault) && WD.visOpq(aWorld, aX, aY, aZ + 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ + 1), aDefault) && WD.visOpq(aWorld, aX, aY, aZ - 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ - 1), aDefault);
    }

    public static boolean visOpq(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ) ? WD.visOpq(aWorld.getBlock(aX, aY, aZ)) : aDefault;
    }

    public static boolean visOpq(Block aBlock) {
        return aBlock.isOpaqueCube() || CS.VISUALLY_OPAQUE_BLOCKS.contains(aBlock);
    }

    public static boolean occ(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return WD.opq(aWorld, aX + 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX + 1, aZ), aDefault) && WD.opq(aWorld, aX - 1, aY, aZ, aLoadUnloadedChunks || !WD.border(aX, aZ, aX - 1, aZ), aDefault) && WD.opq(aWorld, aX, aY + 1, aZ, true, aDefault) && WD.opq(aWorld, aX, aY - 1, aZ, true, aDefault) && WD.opq(aWorld, aX, aY, aZ + 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ + 1), aDefault) && WD.opq(aWorld, aX, aY, aZ - 1, aLoadUnloadedChunks || !WD.border(aX, aZ, aX, aZ - 1), aDefault);
    }

    public static boolean opq(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks, boolean aDefault) {
        return aLoadUnloadedChunks || aWorld.blockExists(aX, aY, aZ) ? WD.opq(aWorld.getBlock(aX, aY, aZ)) : aDefault;
    }

    public static boolean opq(Block aBlock) {
        return aBlock.isOpaqueCube() && !(aBlock instanceof BlockLeaves);
    }

    public static boolean air(World aWorld, int aX, int aY, int aZ) {
        return WD.air(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean air(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == CS.NB || aBlock.isAir((IBlockAccess)aWorld, aX, aY, aZ) && (!MD.TC.mLoaded || aBlock.isOpaqueCube() || !(WD.te(aWorld, aX, aY, aZ, true) instanceof INode));
    }

    public static boolean air(Block aBlock) {
        return aBlock == CS.NB;
    }

    public static boolean lava(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.lava(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean lava(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == Blocks.lava || aBlock == Blocks.flowing_lava;
    }

    public static boolean lava(Block aBlock) {
        return aBlock == Blocks.lava || aBlock == Blocks.flowing_lava;
    }

    public static boolean water(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.water(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean water(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock == Blocks.water || aBlock == Blocks.flowing_water;
    }

    public static boolean water(Block aBlock) {
        return aBlock == Blocks.water || aBlock == Blocks.flowing_water;
    }

    public static boolean waterstream(Block aBlock) {
        return MD.Streams.mLoaded && UT.Code.stringValidate(ST.regName(aBlock)).startsWith("streams:river/tile.water");
    }

    public static boolean anywater(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.anywater(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean anywater(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock instanceof BlockWaterlike || WD.water(aWorld, aX, aY, aZ, aBlock) || WD.waterstream(aBlock);
    }

    public static boolean anywater(Block aBlock) {
        return aBlock instanceof BlockWaterlike || WD.water(aBlock) || WD.waterstream(aBlock);
    }

    public static boolean bedrock(World aWorld, int aX, int aY, int aZ) {
        return WD.bedrock(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean bedrock(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.bedrock(aBlock);
    }

    public static boolean bedrock(Block aBlock) {
        return aBlock == Blocks.bedrock || IL.BTL_Bedrock.equal(aBlock);
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
        return WD.grass(WD.block(aWorld, aX, aY, aZ, aLoadUnloadedChunks), WD.meta(aWorld, aX, aY, aZ, aLoadUnloadedChunks));
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ) {
        return WD.grass(WD.block((IBlockAccess)aWorld, aX, aY, aZ), WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public static boolean grass(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta) {
        return WD.grass(aBlock, aMeta);
    }

    public static boolean grass(Block aBlock, long aMeta) {
        if (aBlock == Blocks.tallgrass) {
            return true;
        }
        if (aBlock == Blocks.double_plant) {
            return aMeta == 2L || aMeta == 3L;
        }
        if (IL.TF_Tall_Grass.equal(aBlock)) {
            return aMeta == 8L || aMeta == 10L;
        }
        return IL.AETHER_Tall_Grass.equal(aBlock);
    }

    public static boolean irrelevant(World aWorld, int aX, int aY, int aZ) {
        return WD.irrelevant(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean irrelevant(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.air(aWorld, aX, aY, aZ, aBlock) || aBlock == Blocks.vine || aBlock == Blocks.snow_layer || aBlock == Blocks.fire || WD.grass(aWorld, aX, aY, aZ) || WD.anywater(aBlock);
    }

    public static boolean easyRep(World aWorld, int aX, int aY, int aZ) {
        return WD.easyRep(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean easyRep(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return WD.air(aWorld, aX, aY, aZ, aBlock) || aBlock instanceof BlockBush || aBlock instanceof BlockSnow || aBlock instanceof BlockFire || aBlock.isLeaves((IBlockAccess)aWorld, aX, aY, aZ) || aBlock.canBeReplacedByLeaves((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public static boolean infiniteWater(World aWorld, int aX, int aY, int aZ) {
        int tLevel = WD.waterLevel(aWorld);
        return UT.Code.inside(tLevel - 15, tLevel, aY) && CS.BIOMES_RIVER_LAKE.contains(aWorld.getBiomeGenForCoords((int)aX, (int)aZ).biomeName);
    }

    public static boolean infiniteWater(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        int tLevel = WD.waterLevel(aWorld);
        return WD.waterstream(aBlock) || (aBlock == Blocks.water || aBlock == Blocks.flowing_water) && UT.Code.inside(tLevel - 15, tLevel, aY) && CS.BIOMES_RIVER_LAKE.contains(aWorld.getBiomeGenForCoords((int)aX, (int)aZ).biomeName);
    }

    public static boolean hasCollide(World aWorld, int aX, int aY, int aZ) {
        return WD.hasCollide(aWorld, aX, aY, aZ, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean hasCollide(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        return aBlock.isOpaqueCube() || aBlock.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) != null;
    }

    public static boolean hasCollide(World aWorld, ChunkCoordinates aCoords) {
        return WD.hasCollide(aWorld, aCoords, aWorld.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ));
    }

    public static boolean hasCollide(World aWorld, ChunkCoordinates aCoords, Block aBlock) {
        return aBlock.isOpaqueCube() || aBlock.getCollisionBoundingBoxFromPool(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ) != null;
    }

    public static boolean flaming(World aWorld, int aX, int aY, int aZ) {
        return WD.block(aWorld, aX, aY, aZ, false) instanceof BlockFire;
    }

    public static boolean burning(World aWorld, int aX, int aY, int aZ) {
        return WD.flaming(aWorld, aX, aY, aZ) || WD.flaming(aWorld, aX + 1, aY, aZ) || WD.flaming(aWorld, aX - 1, aY, aZ) || WD.flaming(aWorld, aX, aY + 1, aZ) || WD.flaming(aWorld, aX, aY - 1, aZ) || WD.flaming(aWorld, aX, aY, aZ + 1) || WD.flaming(aWorld, aX, aY, aZ - 1);
    }

    public static void burn(World aWorld, ChunkCoordinates aCoords, boolean aReplaceCenter, boolean aCheckFlammability) {
        for (byte tSide : aReplaceCenter ? CS.ALL_SIDES_MIDDLE_UP : CS.ALL_SIDES_VALID) {
            WD.fire(aWorld, aCoords.posX + CS.OFFX[tSide], aCoords.posY + CS.OFFY[tSide], aCoords.posZ + CS.OFFZ[tSide], aCheckFlammability);
        }
    }

    public static void burn(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter, boolean aCheckFlammability) {
        for (byte tSide : aReplaceCenter ? CS.ALL_SIDES_MIDDLE_UP : CS.ALL_SIDES_VALID) {
            WD.fire(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], aCheckFlammability);
        }
    }

    public static boolean fire(World aWorld, ChunkCoordinates aCoords, boolean aCheckFlammability) {
        return WD.fire(aWorld, aCoords.posX, aCoords.posY, aCoords.posZ, aCheckFlammability);
    }

    public static boolean fire(World aWorld, int aX, int aY, int aZ, boolean aCheckFlammability) {
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        if (tBlock.getMaterial() == Material.lava || tBlock.getMaterial() == Material.fire) {
            return false;
        }
        if (tBlock.getMaterial() == Material.carpet || tBlock.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) == null) {
            if (MD.TC.mLoaded && WD.te(aWorld, aX, aY, aZ, true) instanceof INode) {
                return false;
            }
            if (tBlock.getFlammability((IBlockAccess)aWorld, aX, aY, aZ, CS.FORGE_DIR[6]) > 0) {
                return aWorld.setBlock(aX, aY, aZ, (Block)Blocks.fire, 0, 3);
            }
            if (tBlock instanceof IItemGT) {
                return false;
            }
            if (aCheckFlammability) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    Block tAdjacent = WD.block(aWorld, aX, aY, aZ, tSide);
                    if (tAdjacent == Blocks.chest || tAdjacent == Blocks.trapped_chest) {
                        return aWorld.setBlock(aX, aY, aZ, (Block)Blocks.fire);
                    }
                    if (tAdjacent.getFlammability((IBlockAccess)aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], CS.FORGE_DIR_OPPOSITES[tSide]) <= 0) continue;
                    return aWorld.setBlock(aX, aY, aZ, (Block)Blocks.fire);
                }
            } else {
                return aWorld.setBlock(aX, aY, aZ, (Block)Blocks.fire, 0, 3);
            }
        }
        return false;
    }

    public static boolean oreGenReplaceable(World aWorld, int aX, int aY, int aZ, boolean aAllowAir) {
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return aAllowAir;
        }
        byte aMeta = (byte)aWorld.getBlockMetadata(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        if (CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return true;
        }
        if (Blocks.stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.stone)) {
            return true;
        }
        if (Blocks.gravel != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.gravel)) {
            return true;
        }
        if (Blocks.sand != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.sand)) {
            return true;
        }
        if (Blocks.netherrack != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.netherrack)) {
            return true;
        }
        return Blocks.end_stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.end_stone);
    }

    public static boolean setOre(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && WD.setOre(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setOre(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return false;
        }
        byte aMeta = (byte)aWorld.getBlockMetadata(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        IBlockPlacable tBlock = CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(aBlock, 1L, (long)aMeta));
        if (tBlock == null) {
            if (Blocks.stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.stone)) {
                tBlock = CS.BlocksGT.ore;
            } else if (Blocks.gravel != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.gravel)) {
                tBlock = CS.BlocksGT.oreGravel;
            } else if (Blocks.sand != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.sand)) {
                tBlock = CS.BlocksGT.oreSand;
            } else if (Blocks.netherrack != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.netherrack)) {
                tBlock = CS.BlocksGT.oreNetherrack;
            } else if (Blocks.end_stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.end_stone)) {
                tBlock = CS.BlocksGT.oreEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean setSmallOre(World aWorld, int aX, int aY, int aZ, OreDictMaterial aMaterial) {
        return aMaterial != null && WD.setSmallOre(aWorld, aX, aY, aZ, aMaterial.mID);
    }

    public static boolean setSmallOre(World aWorld, int aX, int aY, int aZ, short aID) {
        if (aID <= 0 && aID == Short.MAX_VALUE) {
            return false;
        }
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB || WD.bedrock(aBlock)) {
            return false;
        }
        byte aMeta = (byte)aWorld.getBlockMetadata(aX, aY, aZ);
        if (CS.BlocksGT.sDontGenerateOresIn.contains(new ItemStackContainer(aBlock, 1L, (long)aMeta))) {
            return false;
        }
        IBlockPlacable tBlock = CS.BlocksGT.stoneToSmallOres.get(new ItemStackContainer(aBlock, 1L, (long)aMeta));
        if (tBlock == null) {
            if (Blocks.stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.stone)) {
                tBlock = CS.BlocksGT.oreSmall;
            } else if (Blocks.gravel != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.gravel)) {
                tBlock = CS.BlocksGT.oreSmallGravel;
            } else if (Blocks.sand != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.sand)) {
                tBlock = CS.BlocksGT.oreSmallSand;
            } else if (Blocks.netherrack != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.netherrack)) {
                tBlock = CS.BlocksGT.oreSmallNetherrack;
            } else if (Blocks.end_stone != aBlock && aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.end_stone)) {
                tBlock = CS.BlocksGT.oreSmallEndstone;
            }
        }
        return tBlock != null && tBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, aID, null, false, true);
    }

    public static boolean removeBedrock(World aWorld, int aX, int aY, int aZ) {
        Block tStone;
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        Block block = tStone = aWorld.provider.dimensionId == -1 ? Blocks.netherrack : Blocks.stone;
        if (tBlock == CS.NB || WD.bedrock(tBlock)) {
            for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                for (int i = 1; i < 7; ++i) {
                    int tMetaData;
                    tBlock = aWorld.getBlock(aX + CS.OFFX[tSide] * i, aY + CS.OFFY[tSide] * i, aZ + CS.OFFZ[tSide] * i);
                    if (tBlock == CS.NB || tBlock == tStone || WD.bedrock(tBlock) || !CS.BlocksGT.stoneToNormalOres.containsKey(new ItemStackContainer(tBlock, 1L, (long)(tMetaData = aWorld.getBlockMetadata(aX + CS.OFFX[tSide] * i, aY + CS.OFFY[tSide] * i, aZ + CS.OFFZ[tSide] * i))))) continue;
                    return aWorld.setBlock(aX, aY, aZ, tBlock, tMetaData, 0);
                }
            }
            return aWorld.setBlock(aX, aY, aZ, tStone, 0, 0);
        }
        return false;
    }

    public static List<ChunkCoordinates> line(Vec3 aStart, Vec3 aEnd) {
        ArrayListNoNulls<ChunkCoordinates> rList = new ArrayListNoNulls<ChunkCoordinates>();
        if (Double.isNaN(aStart.xCoord) || Double.isNaN(aStart.yCoord) || Double.isNaN(aStart.zCoord) || Double.isNaN(aEnd.xCoord) || Double.isNaN(aEnd.yCoord) || Double.isNaN(aEnd.zCoord)) {
            return rList;
        }
        Vec3 tPoint = Vec3.createVectorHelper((double)aStart.xCoord, (double)aStart.yCoord, (double)aStart.zCoord);
        int sx = UT.Code.roundDown(tPoint.xCoord);
        int sy = UT.Code.roundDown(tPoint.yCoord);
        int sz = UT.Code.roundDown(tPoint.zCoord);
        int ex = UT.Code.roundDown(aEnd.xCoord);
        int ey = UT.Code.roundDown(aEnd.yCoord);
        int ez = UT.Code.roundDown(aEnd.zCoord);
        rList.add(new ChunkCoordinates(sx, sy, sz));
        int maxAttempts = 2000;
        while (maxAttempts-- >= 0) {
            int whereTo;
            if (Double.isNaN(tPoint.xCoord) || Double.isNaN(tPoint.yCoord) || Double.isNaN(tPoint.zCoord)) {
                return rList;
            }
            if (sx == ex && sy == ey && sz == ez) {
                return rList;
            }
            boolean performx = true;
            boolean performy = true;
            boolean performz = true;
            double nx = 999.0;
            double ny = 999.0;
            double nz = 999.0;
            double ndx = 999.0;
            double ndy = 999.0;
            double ndz = 999.0;
            double distx = aEnd.xCoord - tPoint.xCoord;
            double disty = aEnd.yCoord - tPoint.yCoord;
            double distz = aEnd.zCoord - tPoint.zCoord;
            if (ex > sx) {
                nx = (double)sx + 1.0;
            } else if (ex < sx) {
                nx = (double)sx + 0.0;
            } else {
                performx = false;
            }
            if (ey > sy) {
                ny = (double)sy + 1.0;
            } else if (ey < sy) {
                ny = (double)sy + 0.0;
            } else {
                performy = false;
            }
            if (ez > sz) {
                nz = (double)sz + 1.0;
            } else if (ez < sz) {
                nz = (double)sz + 0.0;
            } else {
                performz = false;
            }
            if (performx) {
                ndx = (nx - tPoint.xCoord) / distx;
            }
            if (performy) {
                ndy = (ny - tPoint.yCoord) / disty;
            }
            if (performz) {
                ndz = (nz - tPoint.zCoord) / distz;
            }
            if (ndx < ndy && ndx < ndz) {
                whereTo = ex > sx ? 4 : 5;
                tPoint.xCoord = nx;
                tPoint.yCoord += disty * ndx;
                tPoint.zCoord += distz * ndx;
            } else if (ndy < ndz) {
                whereTo = ey > sy ? 0 : 1;
                tPoint.xCoord += distx * ndy;
                tPoint.yCoord = ny;
                tPoint.zCoord += distz * ndy;
            } else {
                whereTo = ez > sz ? 2 : 3;
                tPoint.xCoord += distx * ndz;
                tPoint.yCoord += disty * ndz;
                tPoint.zCoord = nz;
            }
            sx = UT.Code.roundDown(tPoint.xCoord);
            sy = UT.Code.roundDown(tPoint.yCoord);
            sz = UT.Code.roundDown(tPoint.zCoord);
            if (whereTo == 5) {
                --sx;
            }
            if (whereTo == 1) {
                --sy;
            }
            if (whereTo == 3) {
                --sz;
            }
            rList.add(new ChunkCoordinates(sx, sy, sz));
        }
        return rList;
    }

    public static long scan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, byte aSide, float aClickX, float aClickY, float aClickZ) {
        if (aList == null) {
            return 0L;
        }
        ArrayListNoNulls<String> rList = new ArrayListNoNulls<String>();
        long rEUAmount = 0L;
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        byte aMeta = (byte)aWorld.getBlockMetadata(aX, aY, aZ);
        TileEntity aTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        ((ArrayList)rList).add("--- X: " + aX + " Y: " + aY + " Z: " + aZ + " ---");
        try {
            ((ArrayList)rList).add("Name: " + (aTileEntity instanceof IInventory && UT.Code.stringValid(((IInventory)aTileEntity).getInventoryName()) ? ((IInventory)aTileEntity).getInventoryName() : aBlock.getUnlocalizedName()) + "  MetaData: " + aMeta);
            ((ArrayList)rList).add("Registry: " + ST.regName(aBlock));
            if (aScanLevel >= 10) {
                ((ArrayList)rList).add("Block Class: " + aBlock.getClass());
                if (aTileEntity != null) {
                    ((ArrayList)rList).add("TileEntity Class: " + aTileEntity.getClass());
                }
            }
            float tResistance = aBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.posX, aPlayer.posY, aPlayer.posZ);
            ((ArrayList)rList).add("Hardness: " + aBlock.getBlockHardness(aWorld, aX, aY, aZ) + " - " + LH.getToolTipBlastResistance(aBlock, tResistance));
            int tHarvestLevel = aBlock.getHarvestLevel((int)aMeta);
            String tHarvestTool = aBlock.getHarvestTool((int)aMeta);
            ((ArrayList)rList).add(tHarvestLevel == 0 && aBlock.getMaterial().isAdventureModeExempt() ? "Hand-Harvestable, but " + (UT.Code.stringValid(tHarvestTool) ? UT.Code.capitalise(tHarvestTool) : "None") + " is faster" : "Tool to Harvest: " + (UT.Code.stringValid(tHarvestTool) ? UT.Code.capitalise(tHarvestTool) : "None") + " (" + tHarvestLevel + ")");
            if (aBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                ((ArrayList)rList).add("Is usable for Beacon Pyramids");
            }
            if (MD.GC.mLoaded && aBlock instanceof IPartialSealableBlock) {
                ((ArrayList)rList).add(((IPartialSealableBlock)aBlock).isSealed(aWorld, aX, aY, aZ, CS.FORGE_DIR[aSide ^ 1]) ? "Is Sealable on this Side" : "Is not Sealable on this Side");
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aTileEntity != null) {
            try {
                if (aTileEntity instanceof ITileEntityWeight && ((ITileEntityWeight)aTileEntity).getWeightValue(aSide) > 0.0) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Weight: " + ((ITileEntityWeight)aTileEntity).getWeightValue(aSide) + " kg");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityTemperature && ((ITileEntityTemperature)aTileEntity).getTemperatureMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Temperature: " + ((ITileEntityTemperature)aTileEntity).getTemperatureValue(aSide) + " / " + ((ITileEntityTemperature)aTileEntity).getTemperatureMax(aSide) + " K");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityGibbl && ((ITileEntityGibbl)aTileEntity).getGibblMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Pressure: " + ((ITileEntityGibbl)aTileEntity).getGibblValue(aSide) + " / " + ((ITileEntityGibbl)aTileEntity).getGibblMax(aSide) + " Gibbl");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityProgress && ((ITileEntityProgress)aTileEntity).getProgressMax(aSide) > 0L) {
                    rEUAmount += CS.V[3];
                    ((ArrayList)rList).add("Progress: " + ((ITileEntityProgress)aTileEntity).getProgressValue(aSide) + " / " + ((ITileEntityProgress)aTileEntity).getProgressMax(aSide));
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            String rState = "";
            try {
                if (aTileEntity instanceof ITileEntitySwitchableOnOff) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "State: " + (((ITileEntitySwitchableOnOff)aTileEntity).getStateOnOff() ? "ON" : "OFF");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntitySwitchableMode) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Mode: " + ((ITileEntitySwitchableMode)aTileEntity).getStateMode();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityRunningSuccessfully) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningSuccessfully() ? "Successfully" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningActively() ? "Actively" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningSuccessfully)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible"))));
                } else if (aTileEntity instanceof ITileEntityRunningActively) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningActively)aTileEntity).getStateRunningActively() ? "Actively" : (((ITileEntityRunningActively)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningActively)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible")));
                } else if (aTileEntity instanceof ITileEntityRunningPassively) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningPassively)aTileEntity).getStateRunningPassively() ? "Passively" : (((ITileEntityRunningPassively)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible"));
                } else if (aTileEntity instanceof ITileEntityRunningPossible) {
                    if (UT.Code.stringValid(rState)) {
                        rState = rState + " --- ";
                    }
                    rEUAmount += CS.V[3];
                    rState = rState + "Running: " + (((ITileEntityRunningPossible)aTileEntity).getStateRunningPossible() ? "Possible" : "Not Possible");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (UT.Code.stringValid(rState)) {
                ((ArrayList)rList).add(rState);
            }
            try {
                if (aTileEntity instanceof ITileEntityEnergy) {
                    rEUAmount += CS.V[3];
                    for (TagData tEnergyType : ((ITileEntityEnergy)aTileEntity).getEnergyTypes(aSide)) {
                        ((ArrayList)rList).add("Input: " + ((ITileEntityEnergy)aTileEntity).getEnergySizeInputMin(tEnergyType, aSide) + " to " + ((ITileEntityEnergy)aTileEntity).getEnergySizeInputMax(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                        ((ArrayList)rList).add("Output: " + ((ITileEntityEnergy)aTileEntity).getEnergySizeOutputMin(tEnergyType, aSide) + " to " + ((ITileEntityEnergy)aTileEntity).getEnergySizeOutputMax(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof ITileEntityEnergyDataCapacitor) {
                    rEUAmount += CS.V[3];
                    for (TagData tEnergyType : ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyCapacitorTypes(aSide)) {
                        ((ArrayList)rList).add("Stored: " + ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyStored(tEnergyType, aSide) + " of " + ((ITileEntityEnergyDataCapacitor)aTileEntity).getEnergyCapacity(tEnergyType, aSide) + tEnergyType.getLocalisedNameShort());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            try {
                if (aTileEntity instanceof IFluidHandler) {
                    rEUAmount += CS.V[3];
                    FluidTankInfo[] tTanks = ((IFluidHandler)aTileEntity).getTankInfo(CS.FORGE_DIR[aSide]);
                    if (tTanks != null) {
                        for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                            ((ArrayList)rList).add("Tank " + i + ": " + (tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + " / " + tTanks[i].capacity + " " + FL.name(tTanks[i].fluid, true));
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (!(aTileEntity instanceof ITileEntity)) {
                try {
                    if (aTileEntity instanceof IReactorChamber) {
                        rEUAmount += CS.V[4];
                        aTileEntity = (TileEntity)((IReactorChamber)aTileEntity).getReactor();
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IReactor) {
                        rEUAmount += CS.V[4];
                        ((ArrayList)rList).add("Heat: " + ((IReactor)aTileEntity).getHeat() + "/" + ((IReactor)aTileEntity).getMaxHeat() + "  HEM: " + ((IReactor)aTileEntity).getHeatEffectModifier() + "  Base IC2-EU Output: " + ((IReactor)aTileEntity).getReactorEUEnergyOutput());
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IWrenchable) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Facing: " + ((IWrenchable)aTileEntity).getFacing() + " / IC2 Wrench Drop Chance: " + (((IWrenchable)aTileEntity).wrenchCanRemove(aPlayer) ? ((IWrenchable)aTileEntity).getWrenchDropRate() * 100.0f : 0.0f) + "%");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergySink) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Demanded Energy: " + ((IEnergySink)aTileEntity).getDemandedEnergy() + " IC2-EU");
                        ((ArrayList)rList).add("Max Safe Input: " + CS.V[((IEnergySink)aTileEntity).getSinkTier()] + " IC2-EU/t");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergySource) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Max Energy Output: " + CS.V[((IEnergySource)aTileEntity).getSourceTier()] + " IC2-EU/t");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergyConductor) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Conduction Loss: " + ((IEnergyConductor)aTileEntity).getConductionLoss() + " IC2-EU/m");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                try {
                    if (aTileEntity instanceof IEnergyStorage) {
                        rEUAmount += CS.V[3];
                        ((ArrayList)rList).add("Contained Energy: " + ((IEnergyStorage)aTileEntity).getStored() + " of " + ((IEnergyStorage)aTileEntity).getCapacity() + " IC2-EU");
                        ((ArrayList)rList).add(((IEnergyStorage)aTileEntity).isTeleporterCompatible(CS.FORGE_DIR[aSide]) ? "Teleporter Compatible" : "Not Teleporter Compatible");
                    }
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        try {
            if (aBlock instanceof IBlockDebugable) {
                rEUAmount += CS.V[3];
                ArrayList<String> temp = ((IBlockDebugable)aBlock).getDebugInfo(aPlayer, aX, aY, aZ, aScanLevel);
                if (temp != null) {
                    ((ArrayList)rList).addAll(temp);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, aSide, aScanLevel, aBlock, aTileEntity, rList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount;
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(rList);
        }
        return tEvent.mEUCost;
    }
}

