/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.GT_API;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ModData;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.RM;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.enchants.Enchantment_Radioactivity;
import gregapi.fluid.FluidGT;
import gregapi.fluid.FluidTankGT;
import gregapi.lang.LanguageHandler;
import gregapi.network.packets.PacketSound;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.player.EntityFoodTracker;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.IIconContainer;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.WD;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExt;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import mods.railcraft.common.items.enchantment.RailcraftEnchantments;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class UT {
    public static synchronized boolean removeSimpleIC2MachineRecipe(ItemStack aInput, Map aRecipeList, ItemStack aOutput) {
        if (!MD.IC2.mLoaded || ST.invalid(aInput) && ST.invalid(aOutput) || aRecipeList == null || aRecipeList.isEmpty()) {
            return false;
        }
        boolean rReturn = false;
        Iterator tIterator = aRecipeList.entrySet().iterator();
        aOutput = OM.get_(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry tEntry = tIterator.next();
            if (aInput != null && !((IRecipeInput)tEntry.getKey()).matches(aInput) || (tList = ((RecipeOutput)tEntry.getValue()).items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (!ST.invalid(aOutput) && !ST.equal(OM.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static boolean addSimpleIC2MachineRecipe(IMachineRecipeManager aRecipeManager, ItemStack aInput, NBTTagCompound aNBT, Object ... aOutput) {
        if (!MD.IC2.mLoaded || ST.invalid(aInput) || aOutput == null || aRecipeManager == null) {
            return false;
        }
        try {
            aOutput = Code.getWithoutNulls(aOutput).toArray(CS.ZL);
            if (aOutput.length == 0) {
                return false;
            }
            OreDictItemData tOreName = OM.association_(aInput);
            if (aRecipeManager instanceof IMachineRecipeManagerExt) {
                if (tOreName != null && !tOreName.mBlackListed && !OreDictManager.INSTANCE.isBlacklisted(aInput)) {
                    ((IMachineRecipeManagerExt)aRecipeManager).addRecipe((IRecipeInput)CS.COMPAT_IC2.makeInput(tOreName.toString(), aInput.stackSize), aNBT, true, OreDictManager.INSTANCE.getStackArray(true, aOutput));
                } else {
                    ((IMachineRecipeManagerExt)aRecipeManager).addRecipe((IRecipeInput)CS.COMPAT_IC2.makeInput(aInput), aNBT, true, OreDictManager.INSTANCE.getStackArray(true, aOutput));
                }
            } else if (tOreName != null && !tOreName.mBlackListed && !OreDictManager.INSTANCE.isBlacklisted(aInput)) {
                aRecipeManager.addRecipe((IRecipeInput)CS.COMPAT_IC2.makeInput(tOreName.toString(), aInput.stackSize), aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput));
            } else {
                aRecipeManager.addRecipe((IRecipeInput)CS.COMPAT_IC2.makeInput(aInput), aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addSimpleIC2MachineRecipe(ItemStack aInput, Map aRecipeList, NBTTagCompound aNBT, Object ... aOutput) {
        if (!MD.IC2.mLoaded || ST.invalid(aInput) || aOutput.length == 0 || aRecipeList == null) {
            return false;
        }
        OreDictItemData tOreName = OM.association_(aInput);
        if (tOreName != null) {
            aRecipeList.put(CS.COMPAT_IC2.makeInput(tOreName.toString(), aInput.stackSize), CS.COMPAT_IC2.makeOutput(aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput)));
        } else {
            aRecipeList.put(CS.COMPAT_IC2.makeInput(aInput), CS.COMPAT_IC2.makeOutput(aNBT, OreDictManager.INSTANCE.getStackArray(true, aOutput)));
        }
        return true;
    }

    public static class LoadingBar {
        public static boolean mEnabled = true;
        public static Object mBar = null;
        public static int mSize = 0;
        public static int mCount = 0;
        public static Field mMessage = null;
        public static Field mStep = null;

        public static boolean start(String aTitle, int aSize) {
            if (mBar == null && mEnabled && aSize > 0) {
                try {
                    mBar = ProgressManager.push((String)aTitle, (int)aSize, (boolean)false);
                    mMessage = Reflection.getField(mBar, "message", true, true);
                    mStep = Reflection.getField(mBar, "step", true, true);
                    mSize = aSize;
                    mCount = 0;
                    return true;
                }
                catch (NoClassDefFoundError e) {
                    mEnabled = false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            return false;
        }

        public static boolean step(Object aStepName) {
            if (mBar != null && mEnabled) {
                if (mCount++ < mSize) {
                    try {
                        mMessage.set(mBar, aStepName == null ? "Error: NULL" : aStepName.toString());
                        mStep.setInt(mBar, mCount);
                        return true;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                        return false;
                    }
                }
                CS.ERR.println("ERROR: Progress Bar needed a forced Finish, because of too many Steps.");
                LoadingBar.finish();
                return false;
            }
            return false;
        }

        public static boolean finish() {
            if (mBar != null && mEnabled) {
                if (mCount != mSize) {
                    CS.ERR.println("ERROR: Progress Bar needed a forced Finish, because of too few Steps.");
                }
                try {
                    ProgressManager.pop((ProgressManager.ProgressBar)((ProgressManager.ProgressBar)mBar));
                    mBar = null;
                    mSize = 0;
                    mCount = 0;
                    return true;
                }
                catch (NoClassDefFoundError e) {
                    mEnabled = false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                mBar = null;
                mSize = 0;
                mCount = 0;
                return false;
            }
            return false;
        }
    }

    @Deprecated
    public static class Crafting {
        @Deprecated
        public static boolean shaped(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
            return CR.shaped(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe);
        }

        @Deprecated
        public static boolean shaped(ItemStack aResult, Object[] aRecipe) {
            return CR.shaped(aResult, aRecipe);
        }

        @Deprecated
        public static boolean shaped(ItemStack aResult, long aBitMask, Object[] aRecipe) {
            return CR.shaped(aResult, aBitMask, aRecipe);
        }

        @Deprecated
        public static boolean shapeless(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
            return CR.shapeless(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe);
        }

        @Deprecated
        public static boolean shapeless(ItemStack aResult, Object[] aRecipe) {
            return CR.shapeless(aResult, aRecipe);
        }

        @Deprecated
        public static boolean shapeless(ItemStack aResult, long aBitMask, Object[] aRecipe) {
            return CR.shapeless(aResult, aBitMask, aRecipe);
        }

        @Deprecated
        public static ItemStack getany(World aWorld, ItemStack ... aRecipe) {
            return CR.getany(aWorld, aRecipe);
        }

        @Deprecated
        public static ItemStack get(ItemStack ... aRecipe) {
            return CR.get(aRecipe);
        }

        @Deprecated
        public static ItemStack get(boolean aUncopiedStack, ItemStack ... aRecipe) {
            return CR.get(aUncopiedStack, aRecipe);
        }

        @Deprecated
        public static boolean has(ItemStack aOutput) {
            return CR.has(aOutput);
        }

        @Deprecated
        public static boolean remout(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers, boolean aDontRemoveDyeingRecipes) {
            return CR.remout(aOutput, aIgnoreNBT, aNotRemoveShapelessRecipes, aOnlyRemoveNativeHandlers, aDontRemoveDyeingRecipes);
        }

        @Deprecated
        public static boolean remout(ItemStack aOutput) {
            return CR.remout(aOutput);
        }

        @Deprecated
        public static boolean remout(ModData aMod, String ... aNames) {
            return CR.remout(aMod, aNames);
        }

        @Deprecated
        public static boolean remout(ModData aMod, String aName, int aMetaData) {
            return CR.remout(aMod, aName, aMetaData);
        }

        @Deprecated
        public static ItemStack remove(ItemStack ... aRecipe) {
            return CR.remove(aRecipe);
        }

        @Deprecated
        public static class Bits {
            @Deprecated
            public static final long NONE = 0L;
            @Deprecated
            public static final long MIR = CS.B[0];
            @Deprecated
            public static final long BUF = CS.B[1];
            @Deprecated
            public static final long REV = CS.B[5];
            @Deprecated
            public static final long KEEPNBT = CS.B[2];
            @Deprecated
            public static final long DISMANTLE = CS.B[3];
            @Deprecated
            public static final long NO_REM = CS.B[4];
            @Deprecated
            public static final long NO_AUTO = CS.B[14];
            @Deprecated
            public static final long NO_COLLISION_CHECK = CS.B[10];
            @Deprecated
            public static final long DEL_OTHER_RECIPES = CS.B[6];
            @Deprecated
            public static final long DEL_OTHER_RECIPES_IF_SAME_NBT = CS.B[7];
            @Deprecated
            public static final long DEL_OTHER_SHAPED_RECIPES = CS.B[8];
            @Deprecated
            public static final long DEL_OTHER_NATIVE_RECIPES = CS.B[9];
            @Deprecated
            public static final long DEL_IF_NO_DYES = CS.B[13];
            @Deprecated
            public static final long ONLY_IF_HAS_OTHER_RECIPES = CS.B[11];
            @Deprecated
            public static final long ONLY_IF_HAS_RESULT = CS.B[12];
            @Deprecated
            public static final long DEFAULT = BUF | NO_REM;
            @Deprecated
            public static final long DEFAULT_MIR = DEFAULT | MIR;
            @Deprecated
            public static final long DEFAULT_REV = DEFAULT | REV;
            @Deprecated
            public static final long DEFAULT_NCC = DEFAULT | NO_COLLISION_CHECK;
            @Deprecated
            public static final long DEFAULT_REV_NCC = DEFAULT_REV | NO_COLLISION_CHECK;
            @Deprecated
            public static final long DEFAULT_NAC = DEFAULT | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_NAC_NCC = DEFAULT_NCC | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_NAC_REV = DEFAULT_REV | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_NAC_REV_NCC = DEFAULT_REV_NCC | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_REM = DEFAULT | DEL_OTHER_RECIPES;
            @Deprecated
            public static final long DEFAULT_REM_REV = DEFAULT_REM | REV;
            @Deprecated
            public static final long DEFAULT_REM_NCC = DEFAULT_REM | NO_COLLISION_CHECK;
            @Deprecated
            public static final long DEFAULT_REM_REV_NCC = DEFAULT_REM_REV | NO_COLLISION_CHECK;
            @Deprecated
            public static final long DEFAULT_REM_NAC = DEFAULT_REM | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_REM_NAC_NCC = DEFAULT_REM_NCC | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_REM_NAC_REV = DEFAULT_REM_REV | NO_AUTO;
            @Deprecated
            public static final long DEFAULT_REM_NAC_REV_NCC = DEFAULT_REM_REV_NCC | NO_AUTO;
        }
    }

    @Deprecated
    public static class Stacks {
        @Deprecated
        public static boolean debugItem(ItemStack aStack) {
            return ST.debug(aStack);
        }

        @Deprecated
        public static ItemStack update(ItemStack aStack) {
            return ST.update(aStack);
        }

        @Deprecated
        public static ItemStack update_(ItemStack aStack) {
            return ST.update_(aStack);
        }

        @Deprecated
        public static boolean inList(Collection<ItemStack> aList, ItemStack aStack, boolean aTrueIfListEmpty, boolean aInvertFilter) {
            return ST.listed(aList, aStack, aTrueIfListEmpty, aInvertFilter);
        }

        @Deprecated
        public static ItemStack set(Object aSetStack, Object aToStack) {
            return ST.set((ItemStack)aSetStack, (ItemStack)aToStack);
        }

        @Deprecated
        public static ItemStack set(Object aSetStack, Object aToStack, boolean aCheckStacksize, boolean aCheckNBT) {
            return ST.set((ItemStack)aSetStack, (ItemStack)aToStack, aCheckStacksize, aCheckNBT);
        }

        @Deprecated
        public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            return ST.container(aStack, aCheckIFluidContainerItems);
        }

        @Deprecated
        public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems, int aStacksize) {
            return ST.container(aStack, aCheckIFluidContainerItems, aStacksize);
        }

        @Deprecated
        public static boolean equal(ItemStack aStack1, ItemStack aStack2) {
            return ST.equal(aStack1, aStack2);
        }

        @Deprecated
        public static boolean equalTools(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return ST.equalTools(aStack1, aStack2, aIgnoreNBT);
        }

        @Deprecated
        public static boolean equalTools_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return ST.equalTools_(aStack1, aStack2, aIgnoreNBT);
        }

        @Deprecated
        public static boolean equal(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return ST.equal(aStack1, aStack2, aIgnoreNBT);
        }

        @Deprecated
        public static boolean equal_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
            return ST.equal_(aStack1, aStack2, aIgnoreNBT);
        }

        @Deprecated
        public static short id(Item aItem) {
            return ST.id(aItem);
        }

        @Deprecated
        public static short id(ItemStack aStack) {
            return ST.id(aStack);
        }

        @Deprecated
        public static Item item(ItemStack aStack) {
            return ST.item(aStack);
        }

        @Deprecated
        public static short meta(ItemStack aStack) {
            return ST.meta_(aStack);
        }

        @Deprecated
        public static ItemStack meta(ItemStack aStack, long aMeta) {
            return ST.meta_(aStack, aMeta);
        }

        @Deprecated
        public static boolean rotten(ItemStack aStack) {
            return ST.rotten(aStack);
        }

        @Deprecated
        public static int food(ItemStack aStack) {
            return ST.food(aStack);
        }

        @Deprecated
        public static float saturation(ItemStack aStack) {
            return ST.saturation(aStack);
        }

        @Deprecated
        public static ItemStack fuel(ItemStack aStack, short aValue) {
            return ST.fuel(aStack, aValue);
        }

        @Deprecated
        public static long fuel(ItemStack aStack) {
            return ST.fuel(aStack);
        }

        @Deprecated
        public static ItemStack makeIC2(String aItem, long aAmount, ItemStack aReplacement) {
            return ST.mkic(aItem, aAmount, aReplacement);
        }

        @Deprecated
        public static ItemStack makeIC2(String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            return ST.mkic(aItem, aAmount, aMeta, aReplacement);
        }

        @Deprecated
        public static ItemStack makeIC2(String aItem, long aAmount, int aMeta) {
            return ST.mkic(aItem, aAmount, aMeta);
        }

        @Deprecated
        public static ItemStack makeIC2(String aItem, long aAmount) {
            return ST.mkic(aItem, aAmount);
        }

        @Deprecated
        public static Item item(ModData aModID, String aItem) {
            return Stacks.item(Stacks.make(aModID, aItem, 1L, null));
        }

        @Deprecated
        public static Item item(ModData aModID, String aItem, Item aReplacement) {
            Item rItem = Stacks.item(aModID, aItem);
            return rItem == null ? aReplacement : rItem;
        }

        @Deprecated
        public static Item item(String aModID, String aItem) {
            return Stacks.item(Stacks.make(aModID, aItem, 1L, null));
        }

        @Deprecated
        public static Item item(String aModID, String aItem, Item aReplacement) {
            Item rItem = Stacks.item(aModID, aItem);
            return rItem == null ? aReplacement : rItem;
        }

        @Deprecated
        public static Block block(ModData aModID, String aBlock) {
            return Stacks.block(Stacks.make(aModID, aBlock, 1L, null));
        }

        @Deprecated
        public static Block block(ModData aModID, String aBlock, Block aReplacement) {
            Block rBlock = Stacks.block(aModID, aBlock);
            return rBlock == CS.NB ? aReplacement : rBlock;
        }

        @Deprecated
        public static Block block(String aModID, String aBlock) {
            return Stacks.block(Stacks.make(aModID, aBlock, 1L, null));
        }

        @Deprecated
        public static Block block(String aModID, String aBlock, Block aReplacement) {
            Block rBlock = Stacks.block(aModID, aBlock);
            return rBlock == CS.NB ? aReplacement : rBlock;
        }

        @Deprecated
        public static ItemStack make(ModData aModID, String aItem, long aAmount) {
            return Stacks.make(aModID, aItem, aAmount, null);
        }

        @Deprecated
        public static ItemStack make(ModData aModID, String aItem, long aAmount, ItemStack aReplacement) {
            if (!aModID.mLoaded || Code.stringInvalid(aItem) || !CS.GAPI_POST.mStartedPreInit) {
                return null;
            }
            if (aItem.length() > 5 && aItem.charAt(0) == 't' && aItem.charAt(1) == 'i' && aItem.charAt(2) == 'l' && aItem.charAt(3) == 'e' && aItem.charAt(4) == '.') {
                return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID.mID, (String)aItem, (int)((int)aAmount)), GameRegistry.findItemStack((String)aModID.mID, (String)aItem.substring(5), (int)((int)aAmount)), aReplacement);
            }
            return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID.mID, (String)aItem, (int)((int)aAmount)), aReplacement);
        }

        @Deprecated
        public static ItemStack make(ModData aModID, String aItem, long aAmount, int aMeta) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        @Deprecated
        public static ItemStack make(ModData aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount, aReplacement);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        @Deprecated
        public static ItemStack make(String aModID, String aItem, long aAmount) {
            return Stacks.make(aModID, aItem, aAmount, null);
        }

        @Deprecated
        public static ItemStack make(String aModID, String aItem, long aAmount, ItemStack aReplacement) {
            if (Code.stringInvalid(aItem) || !CS.GAPI_POST.mStartedPreInit) {
                return null;
            }
            if (aItem.length() > 5 && aItem.charAt(0) == 't' && aItem.charAt(1) == 'i' && aItem.charAt(2) == 'l' && aItem.charAt(3) == 'e' && aItem.charAt(4) == '.') {
                return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), GameRegistry.findItemStack((String)aModID, (String)aItem.substring(5), (int)((int)aAmount)), aReplacement);
            }
            return Stacks.amount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), aReplacement);
        }

        @Deprecated
        public static ItemStack make(String aModID, String aItem, long aAmount, int aMeta) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        @Deprecated
        public static ItemStack make(String aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
            ItemStack rStack = Stacks.make(aModID, aItem, aAmount, aReplacement);
            if (rStack == null) {
                return null;
            }
            Stacks.meta(rStack, aMeta);
            return rStack;
        }

        @Deprecated
        public static ItemStack make(long aItemID, long aStacksize, long aMetaData) {
            return aItemID == 0L ? null : Stacks.make(Item.getItemById((int)((int)aItemID)), aStacksize, aMetaData);
        }

        @Deprecated
        public static ItemStack make(Item aItem, long aStacksize, long aMetaData) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), null);
        }

        @Deprecated
        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), null);
        }

        @Deprecated
        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aItemID == 0L ? null : Stacks.make(Item.getItemById((int)((int)aItemID)), aStacksize, aMetaData, aNBT);
        }

        @Deprecated
        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aNBT);
        }

        @Deprecated
        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, NBTTagCompound aNBT) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aNBT);
        }

        @Deprecated
        public static ItemStack make(ItemStack aStack, NBTTagCompound aNBT) {
            return Stacks.make(aStack, null, aNBT);
        }

        @Deprecated
        public static ItemStack make(ItemStackContainer aStack, NBTTagCompound aNBT) {
            return Stacks.make(aStack, null, aNBT);
        }

        @Deprecated
        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, String aName) {
            return aItemID == 0L ? null : Stacks.make(Item.getItemById((int)((int)aItemID)), aStacksize, aMetaData, aName);
        }

        @Deprecated
        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, String aName) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aName, null);
        }

        @Deprecated
        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, String aName) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aName, null);
        }

        @Deprecated
        public static ItemStack make(long aItemID, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aItemID == 0L ? null : Stacks.make(Item.getItemById((int)((int)aItemID)), aStacksize, aMetaData, aName, aNBT);
        }

        @Deprecated
        public static ItemStack make(Item aItem, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aItem == null ? null : Stacks.make(new ItemStack(aItem, Code.bindInt(aStacksize), (int)aMetaData), aName, aNBT);
        }

        @Deprecated
        public static ItemStack make(Block aBlock, long aStacksize, long aMetaData, String aName, NBTTagCompound aNBT) {
            return aBlock == null || aBlock == CS.NB ? null : Stacks.make(new ItemStack(aBlock, Code.bindInt(aStacksize), (int)aMetaData), aName, aNBT);
        }

        @Deprecated
        public static ItemStack make(ItemStack aStack, String aName, NBTTagCompound aNBT) {
            if (aStack == null) {
                return null;
            }
            aStack = aStack.copy();
            NBT.set(aStack, aNBT);
            if (aName != null) {
                aStack.setStackDisplayName(aName);
            }
            return aStack;
        }

        @Deprecated
        public static ItemStack make(ItemStackContainer aStack, String aName, NBTTagCompound aNBT) {
            if (aStack == null) {
                return null;
            }
            ItemStack rStack = aStack.toStack();
            if (rStack == null) {
                return null;
            }
            NBT.set(rStack, aNBT);
            if (aName != null) {
                rStack.setStackDisplayName(aName);
            }
            return rStack;
        }

        @Deprecated
        public static ItemStack[] copyArray(Object ... aStacks) {
            return ST.copyArray((ItemStack[])aStacks);
        }

        @Deprecated
        public static ItemStack copy(Object ... aStacks) {
            return ST.copyFirst(aStacks);
        }

        @Deprecated
        public static ItemStack amount(long aAmount, Object ... aStacks) {
            return ST.amount(aAmount, (ItemStack)aStacks[0]);
        }

        @Deprecated
        public static ItemStack copyAmount(long aAmount, Object ... aStacks) {
            return ST.amount(aAmount, (ItemStack)aStacks[0]);
        }

        @Deprecated
        public static ItemStack copyMeta(long aMetaData, Object ... aStacks) {
            return Stacks.copyMeta(aMetaData, aStacks);
        }

        @Deprecated
        public static ItemStack copyAmountAndMeta(long aAmount, long aMetaData, Object ... aStacks) {
            return ST.copyAmountAndMeta(aAmount, aMetaData, (ItemStack)aStacks[0]);
        }

        @Deprecated
        public static ItemStack mul(long aMultiplier, Object ... aStacks) {
            return ST.mul(aMultiplier, (ItemStack)aStacks[0]);
        }

        @Deprecated
        public static ItemStack div(long aDivider, Object ... aStacks) {
            return ST.div(aDivider, (ItemStack)aStacks[0]);
        }

        @Deprecated
        public static int toInt(ItemStack aStack) {
            return ST.toInt(aStack);
        }

        @Deprecated
        public static int toIntWildcard(ItemStack aStack) {
            return ST.toInt(aStack, 32767L);
        }

        @Deprecated
        public static ItemStack toStack(int aStack) {
            return ST.toStack(aStack);
        }

        @Deprecated
        public static Integer[] toIntegerArray(ItemStack ... aStacks) {
            return ST.toIntegerArray(aStacks);
        }

        @Deprecated
        public static int[] toIntArray(ItemStack ... aStacks) {
            return ST.toIntArray(aStacks);
        }

        @Deprecated
        public static Block block(Object aStack) {
            return ST.block((ItemStack)aStack);
        }

        @Deprecated
        public static Block block_(Object aStack) {
            return ST.block_((ItemStack)aStack);
        }

        @Deprecated
        public static boolean valid(Object aStack) {
            return ST.valid((ItemStack)aStack);
        }

        @Deprecated
        public static boolean invalid(Object aStack) {
            return ST.invalid((ItemStack)aStack);
        }

        @Deprecated
        public static String configName(ItemStack aStack) {
            return ST.configName(aStack);
        }

        @Deprecated
        public static String configNames(ItemStack ... aStacks) {
            return ST.configNames(aStacks);
        }

        @Deprecated
        public static String regName(ItemStack aStack) {
            return ST.regName(aStack);
        }

        @Deprecated
        public static String names(ItemStack ... aStacks) {
            return ST.names(aStacks);
        }

        @Deprecated
        public static String namesAndSizes(ItemStack ... aStacks) {
            return ST.namesAndSizes(aStacks);
        }

        @Deprecated
        public static void hide(Item aItem) {
            ST.hide(aItem);
        }

        @Deprecated
        public static void hide(Item aItem, long aMetaData) {
            ST.hide(aItem, aMetaData);
        }

        @Deprecated
        public static void hide(Block aBlock) {
            ST.hide(aBlock);
        }

        @Deprecated
        public static void hide(Block aBlock, long aMetaData) {
            ST.hide(aBlock, aMetaData);
        }

        @Deprecated
        public static void hide(ItemStack aStack) {
            ST.hide(aStack);
        }

        @Deprecated
        public static ItemStack load(NBTTagCompound aNBT, String aTagName) {
            return ST.load(aNBT, aTagName);
        }

        @Deprecated
        public static ItemStack load(NBTTagCompound aNBT) {
            return ST.load(aNBT);
        }

        @Deprecated
        public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, ItemStack aStack) {
            return ST.save(aNBT, aTagName, aStack);
        }

        @Deprecated
        public static NBTTagCompound save(ItemStack aStack) {
            return ST.save(aStack);
        }
    }

    @Deprecated
    public static class Worlds {
        @Deprecated
        public static ItemStack suckOneItemStackAt(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
            return WD.suck(aWorld, aX, aY, aZ, aL, aH, aW);
        }

        @Deprecated
        public static boolean isSideObstructed(World aWorld, int aX, int aY, int aZ, byte aSide) {
            return WD.obstructed(aWorld, aX, aY, aZ, aSide);
        }

        @Deprecated
        public static MovingObjectPosition getMovingObjectPositionFromPlayer(World aWorld, EntityPlayer aPlayer, boolean aFlag) {
            return WD.getMOP(aWorld, aPlayer, aFlag);
        }

        @Deprecated
        public static boolean isRealDimension(int aDimensionID) {
            return true;
        }

        @Deprecated
        public static boolean moveEntityToDimensionAtCoords(Entity aEntity, int aDimension, double aX, double aY, double aZ) {
            return WD.move(aEntity, aDimension, aX, aY, aZ);
        }

        @Deprecated
        public static DelegatorTileEntity<TileEntity> getTileEntity(World aWorld, ChunkCoordinates aCoords, byte aSide, boolean aLoadUnloadedChunks) {
            return WD.te(aWorld, aCoords, aSide, aLoadUnloadedChunks);
        }

        @Deprecated
        public static DelegatorTileEntity<TileEntity> getTileEntity(World aWorld, int aX, int aY, int aZ, byte aSide, boolean aLoadUnloadedChunks) {
            return WD.te(aWorld, aX, aY, aZ, aSide, aLoadUnloadedChunks);
        }

        @Deprecated
        public static TileEntity getTileEntity(World aWorld, ChunkCoordinates aCoords, boolean aLoadUnloadedChunks) {
            return WD.te(aWorld, aCoords, aLoadUnloadedChunks);
        }

        @Deprecated
        public static TileEntity getTileEntity(World aWorld, int aX, int aY, int aZ, boolean aLoadUnloadedChunks) {
            return WD.te(aWorld, aX, aY, aZ, aLoadUnloadedChunks);
        }

        @Deprecated
        public static TileEntity setTileEntity(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity, boolean aCauseTileEntityUpdates) {
            return WD.te(aWorld, aX, aY, aZ, aTileEntity, aCauseTileEntityUpdates);
        }

        @Deprecated
        public static long getEnvironmentalTemperature(World aWorld, int aX, int aY, int aZ) {
            return WD.envTemp(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static long getTemperature(World aWorld, int aX, int aY, int aZ) {
            return WD.temperature(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static ItemStack getStack(World aWorld, int aX, int aY, int aZ) {
            return WD.stack(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static Block getBlock(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks) {
            return WD.block(aWorld, aX, aY, aZ, aIgnoreUnloadedChunks);
        }

        @Deprecated
        public static boolean setBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, long aMeta, long aFlags) {
            return WD.set(aWorld, aX, aY, aZ, aBlock, aMeta, aFlags);
        }

        @Deprecated
        public static boolean crossedChunkBorder(int aFromX, int aFromZ, int aToX, int aToZ) {
            return WD.border(aFromX, aFromZ, aToX, aToZ);
        }

        @Deprecated
        public static boolean areCoordsEven(TileEntity aTileEntity) {
            return WD.even(aTileEntity);
        }

        @Deprecated
        public static boolean areCoordsEven(ChunkCoordinates aCoords) {
            return WD.even(aCoords);
        }

        @Deprecated
        public static boolean areCoordsEven(int ... aCoords) {
            return WD.even(aCoords);
        }

        @Deprecated
        public static boolean setBlockIfDifferent(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetaData, int aFlags) {
            return WD.setIfDiff(aWorld, aX, aY, aZ, aBlock, aMetaData, aFlags);
        }

        @Deprecated
        public static boolean setBlock(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
            return WD.set(aWorld, aX, aY, aZ, aStack);
        }

        @Deprecated
        public static boolean isRegularStoneBlock(Block aBlock, short aMetaData) {
            return WD.stone(aBlock, aMetaData);
        }

        @Deprecated
        public static boolean isOreBlock(Block aBlock, short aMetaData) {
            return WD.ore(aBlock, aMetaData);
        }

        @Deprecated
        public static boolean isOreOrRegularStoneBlock(Block aBlock, short aMetaData) {
            return WD.ore_stone(aBlock, aMetaData);
        }

        @Deprecated
        public static boolean isVisuallyOccluded(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return WD.visOcc(aWorld, aX, aY, aZ, aIgnoreUnloadedChunks, aDefault);
        }

        @Deprecated
        public static boolean isVisuallyOpaque(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return WD.visOpq(aWorld, aX, aY, aZ, aIgnoreUnloadedChunks, aDefault);
        }

        @Deprecated
        public static boolean isVisuallyOpaque(Block aBlock) {
            return WD.visOpq(aBlock);
        }

        @Deprecated
        public static boolean isOccluded(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return WD.occ(aWorld, aX, aY, aZ, aIgnoreUnloadedChunks, aDefault);
        }

        @Deprecated
        public static boolean isOpaque(World aWorld, int aX, int aY, int aZ, boolean aIgnoreUnloadedChunks, boolean aDefault) {
            return WD.opq(aWorld, aX, aY, aZ, aIgnoreUnloadedChunks, aDefault);
        }

        @Deprecated
        public static boolean isAir(World aWorld, int aX, int aY, int aZ) {
            return WD.air(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean isEasilyReplaceable(World aWorld, int aX, int aY, int aZ) {
            return WD.easyRep(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean hasCollisionBox(World aWorld, int aX, int aY, int aZ) {
            return aWorld.getBlock(aX, aY, aZ).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) != null;
        }

        @Deprecated
        public static void setOnFire(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter, boolean aCheckFlammability) {
            WD.burn(aWorld, aX, aY, aZ, aReplaceCenter, aCheckFlammability);
        }

        @Deprecated
        public static void setOnFire(World aWorld, ChunkCoordinates aCoords, boolean aReplaceCenter, boolean aCheckFlammability) {
            WD.burn(aWorld, aCoords, aReplaceCenter, aCheckFlammability);
        }

        @Deprecated
        public static boolean setToFire(World aWorld, int aX, int aY, int aZ, boolean aCheckFlammability) {
            return WD.fire(aWorld, aX, aY, aZ, aCheckFlammability);
        }

        @Deprecated
        public static boolean setToFire(World aWorld, ChunkCoordinates aCoords, boolean aCheckFlammability) {
            return WD.fire(aWorld, aCoords, aCheckFlammability);
        }

        @Deprecated
        public static boolean getCoordsOnFire(World aWorld, int aX, int aY, int aZ) {
            return WD.burning(aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static long getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, byte aSide, float aClickX, float aClickY, float aClickZ) {
            return WD.scan(aList, aPlayer, aWorld, aScanLevel, aX, aY, aZ, aSide, aClickX, aClickY, aClickZ);
        }
    }

    public static class Entities {
        public static void sendchat(Object aPlayer, String ... aChatMessages) {
            if (aPlayer instanceof EntityPlayerMP) {
                for (String aMessage : aChatMessages) {
                    ((EntityPlayerMP)aPlayer).addChatComponentMessage((IChatComponent)new ChatComponentText(aMessage));
                }
            }
        }

        public static void sendchat(Object aPlayer, IChatComponent ... aChatMessages) {
            if (aPlayer instanceof EntityPlayerMP) {
                for (IChatComponent aMessage : aChatMessages) {
                    ((EntityPlayerMP)aPlayer).addChatComponentMessage(aMessage);
                }
            }
        }

        public static void sendchat(Object aPlayer, List aChatMessages, boolean aSkipFirst) {
            if (aChatMessages != null && aPlayer instanceof EntityPlayerMP) {
                for (Object aMessage : aChatMessages) {
                    if (aSkipFirst) {
                        aSkipFirst = false;
                        continue;
                    }
                    ((EntityPlayerMP)aPlayer).addChatComponentMessage((IChatComponent)(aMessage instanceof IChatComponent ? (IChatComponent)aMessage : new ChatComponentText(aMessage.toString())));
                }
            }
        }

        public static void chat(Object aPlayer, String ... aChatMessages) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aPlayer instanceof EntityPlayer) {
                for (String aMessage : aChatMessages) {
                    ((EntityPlayer)aPlayer).addChatComponentMessage((IChatComponent)new ChatComponentText(aMessage));
                }
            }
        }

        public static void chat(Object aPlayer, IChatComponent ... aChatMessages) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aPlayer instanceof EntityPlayer) {
                for (IChatComponent aMessage : aChatMessages) {
                    ((EntityPlayer)aPlayer).addChatComponentMessage(aMessage);
                }
            }
        }

        public static void chat(Object aPlayer, List aChatMessages, boolean aSkipFirst) {
            if (aPlayer == null) {
                aPlayer = GT_API.api_proxy.getThePlayer();
            }
            if (aChatMessages != null && aPlayer instanceof EntityPlayer) {
                for (Object aMessage : aChatMessages) {
                    if (aSkipFirst) {
                        aSkipFirst = false;
                        continue;
                    }
                    ((EntityPlayer)aPlayer).addChatComponentMessage((IChatComponent)(aMessage instanceof IChatComponent ? (IChatComponent)aMessage : new ChatComponentText(aMessage.toString())));
                }
            }
        }

        public static boolean isWearingFullFrostHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity)) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_FROST.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullHeatHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity) || aEntity.getClass() == EntityWither.class || aEntity.getClass() == EntityBlaze.class || aEntity.getClass() == EntityPigZombie.class || aEntity.getClass() == EntityMagmaCube.class || aEntity.getClass() == EntityGhast.class) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_HEAT.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullBioHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity) || aEntity.getClass() == EntityWither.class || aEntity.getClass() == EntityIronGolem.class) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_BIO.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullChemHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity)) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_CHEM.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullInsectHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity) || aEntity.getClass() == EntityWither.class || aEntity.getClass() == EntityIronGolem.class) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_INSECTS.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullRadioHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity) || aEntity.getClass() == EntityWither.class || aEntity.getClass() == EntityIronGolem.class) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_RADIOACTIVE.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullElectroHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity)) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_LIGHTNING.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isWearingFullGasHazmat(EntityLivingBase aEntity) {
            if (Entities.isCreative(aEntity) || aEntity.getClass() == EntityWither.class || aEntity.getClass() == EntityIronGolem.class) {
                return true;
            }
            for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
                if (CS.ArmorsGT.HAZMATS_GAS.contains(aEntity.getEquipmentInSlot(i), true)) continue;
                return false;
            }
            return true;
        }

        public static boolean isSlimeCreature(Entity aEntity) {
            return aEntity instanceof EntitySlime || Reflection.getLowercaseClass(aEntity).contains("slime");
        }

        public static boolean isEnderCreature(Entity aEntity) {
            return aEntity instanceof EntityEnderman || Reflection.getLowercaseClass(aEntity).contains("ender");
        }

        public static boolean isZombieCreature(Entity aEntity) {
            return aEntity instanceof EntityZombie || Reflection.getLowercaseClass(aEntity).contains("zombie");
        }

        public static boolean isCreeperCreature(Entity aEntity) {
            return aEntity instanceof EntityCreeper || Reflection.getLowercaseClass(aEntity).contains("creeper");
        }

        public static boolean isGhastCreature(Entity aEntity) {
            return aEntity instanceof EntityCreeper || Reflection.getLowercaseClass(aEntity).contains("ghast");
        }

        public static boolean isExplosiveCreature(Entity aEntity) {
            return Entities.isGhastCreature(aEntity) || Entities.isCreeperCreature(aEntity) || Reflection.getLowercaseClass(aEntity).contains("firebeetle");
        }

        public static boolean isWereCreature(EntityLivingBase aEntity) {
            if (aEntity instanceof EntityPlayer) {
                if ("Bear989Sr".equalsIgnoreCase(aEntity.getCommandSenderName())) {
                    return true;
                }
                IExtendedEntityProperties tWerewolfProperty = aEntity.getExtendedProperties("WerewolfPlayer");
                if (tWerewolfProperty == null) {
                    return false;
                }
                Object tReturned = Reflection.callPublicMethod(tWerewolfProperty, "getWerewolf", new Object[0]);
                return tReturned instanceof Boolean && (Boolean)tReturned != false;
            }
            if (aEntity.getClass().getName().indexOf(".") < 0) {
                return false;
            }
            String tClassName = Reflection.getLowercaseClass(aEntity);
            return tClassName.contains("wwolf") || tClassName.contains("yeti") || tClassName.contains("villagerwere") || tClassName.contains("wolfman") || tClassName.contains("werewolf") || tClassName.contains("alphawolf") || tClassName.contains("tamewere") || tClassName.contains("minotaur") || tClassName.contains("minoshroom");
        }

        public static float getHeatDamageFromItem(ItemStack aStack) {
            OreDictItemData tData = OM.anydata(aStack);
            return tData == null ? 0.0f : (tData.mPrefix == null ? 0.0f : tData.mPrefix.mHeatDamage) + (tData.validMaterial() ? tData.mMaterial.mMaterial.mHeatDamage : 0.0f);
        }

        public static int getRadioactivityLevel(ItemStack aStack) {
            return Entities.getRadioactivityLevel(aStack, OM.anydata(aStack));
        }

        public static int getRadioactivityLevel(ItemStack aStack, OreDictItemData aData) {
            long rLevel = 0L;
            if (aData != null && aData.validMaterial()) {
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentTools) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentWeapons) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentAmmo) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentRanged) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentFishing) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
                for (ObjectStack<Enchantment> tEnchantment : aData.mMaterial.mMaterial.mEnchantmentArmors) {
                    if (!(tEnchantment.mObject instanceof Enchantment_Radioactivity)) continue;
                    rLevel = Math.max(rLevel, tEnchantment.mAmount);
                }
            }
            rLevel = Math.max(rLevel, (long)EnchantmentHelper.getEnchantmentLevel((int)Enchantment_Radioactivity.INSTANCE.effectId, (ItemStack)aStack));
            return Code.bindInt(rLevel);
        }

        public static boolean isImmuneToBreathingGases(EntityLivingBase aEntity) {
            return Entities.isWearingFullGasHazmat(aEntity);
        }

        public static boolean applyTemperatureDamage(Entity aEntity, long aTemperature) {
            return Entities.applyTemperatureDamage(aEntity, aTemperature, 1.0f);
        }

        public static boolean applyTemperatureDamage(Entity aEntity, long aTemperature, float aMultiplier) {
            if (aTemperature > 320L) {
                return Entities.applyHeatDamage(aEntity, aMultiplier * (float)(aTemperature - 300L) / 50.0f);
            }
            if (aTemperature < 260L) {
                return Entities.applyFrostDamage(aEntity, aMultiplier * (float)(270L - aTemperature) / 25.0f);
            }
            return false;
        }

        public static boolean applyTemperatureDamage(Entity aEntity, long aTemperature, float aMultiplier, float aCap) {
            if (aTemperature > 320L) {
                return Entities.applyHeatDamage(aEntity, Math.max(1.0f, Math.min(aCap, aMultiplier * (float)(aTemperature - 300L) / 50.0f)));
            }
            if (aTemperature < 260L) {
                return Entities.applyFrostDamage(aEntity, Math.max(1.0f, Math.min(aCap, aMultiplier * (float)(270L - aTemperature) / 25.0f)));
            }
            return false;
        }

        public static boolean applyChemDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && aEntity.getClass() != EntitySkeleton.class && !Entities.isWearingFullChemHazmat((EntityLivingBase)aEntity)) {
                aEntity.attackEntityFrom(DamageSources.getChemDamage(), (float)CS.TFC_DAMAGE_MULTIPLIER * aDamage);
                PotionEffect tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.poison);
                ((EntityLivingBase)aEntity).addPotionEffect(new PotionEffect(Potion.poison.id, Math.max(20, (int)(aDamage * 100.0f + (float)Math.max(0, tEffect == null ? 0 : tEffect.getDuration()))), 1));
                return true;
            }
            return false;
        }

        public static boolean applyHeatDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && aEntity.getClass() != EntityBlaze.class && ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.fireResistance) == null && !Entities.isWearingFullHeatHazmat((EntityLivingBase)aEntity)) {
                aEntity.attackEntityFrom(DamageSources.getHeatDamage(), (float)CS.TFC_DAMAGE_MULTIPLIER * aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyFrostDamage(Entity aEntity, float aDamage) {
            if (aDamage > 0.0f && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && !Entities.isWearingFullFrostHazmat((EntityLivingBase)aEntity)) {
                aEntity.attackEntityFrom(DamageSources.getFrostDamage(), (float)CS.TFC_DAMAGE_MULTIPLIER * aDamage);
                return true;
            }
            return false;
        }

        public static boolean applyElectricityDamage(Entity aEntity, long aVoltage, long aAmperage) {
            long aDamage = (long)Code.tierMax(aVoltage) * aAmperage * 4L;
            if (aDamage > 0L && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && !Entities.isWearingFullElectroHazmat((EntityLivingBase)aEntity)) {
                aEntity.attackEntityFrom(DamageSources.getElectricDamage(), (float)((long)CS.TFC_DAMAGE_MULTIPLIER * aDamage));
                return true;
            }
            return false;
        }

        public static boolean applyElectricityDamage(Entity aEntity, long aWattage) {
            long aDamage = Code.tierMax(aWattage) * 4;
            if (aDamage > 0L && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && !Entities.isWearingFullElectroHazmat((EntityLivingBase)aEntity)) {
                aEntity.attackEntityFrom(DamageSources.getElectricDamage(), (float)((long)CS.TFC_DAMAGE_MULTIPLIER * aDamage));
                return true;
            }
            return false;
        }

        public static boolean applyRadioactivity(Entity aEntity, int aLevel, int aAmountOfItems) {
            if (aLevel > 0 && aEntity instanceof EntityLivingBase && aEntity.isEntityAlive() && ((EntityLivingBase)aEntity).getCreatureAttribute() != EnumCreatureAttribute.UNDEAD && ((EntityLivingBase)aEntity).getCreatureAttribute() != EnumCreatureAttribute.ARTHROPOD && !Entities.isWearingFullRadioHazmat((EntityLivingBase)aEntity)) {
                EntityFoodTracker tTracker = EntityFoodTracker.get(aEntity);
                if (tTracker != null) {
                    tTracker.changeRadiation(aLevel * aAmountOfItems);
                    return true;
                }
                PotionEffect tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.moveSlowdown);
                Entities.applyPotion(aEntity, Potion.moveSlowdown, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.digSlowdown);
                Entities.applyPotion(aEntity, Potion.digSlowdown, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.confusion);
                Entities.applyPotion(aEntity, Potion.confusion, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.weakness);
                Entities.applyPotion(aEntity, Potion.weakness, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.hunger);
                Entities.applyPotion(aEntity, Potion.hunger, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                if (CS.PotionsGT.ID_RADIATION >= 0) {
                    tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.potionTypes[CS.PotionsGT.ID_RADIATION]);
                    Entities.applyPotion(aEntity, CS.PotionsGT.ID_RADIATION, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 4L, 5L * (long)aLevel / 7L), false);
                } else {
                    tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(Potion.wither);
                    Entities.applyPotion(aEntity, Potion.wither, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), (int)Code.bind(0L, 5L, 5L * (long)aLevel / 7L), false);
                }
                return true;
            }
            return false;
        }

        public static boolean applyPotion(Entity aEntity, Potion aPotion, int aDuration, int aLevel, boolean aInvisibleParticles) {
            return aPotion != null && Entities.applyPotion(aEntity, aPotion.id, aDuration, aLevel, aInvisibleParticles);
        }

        public static boolean applyPotion(Entity aEntity, int aID, int aDuration, int aLevel, boolean aInvisibleParticles) {
            if (aDuration <= 0 || !(aEntity instanceof EntityLivingBase)) {
                return false;
            }
            if (aID < -1) {
                switch (aID) {
                    case -2: {
                        aID = CS.PotionsGT.ID_RADIATION;
                        break;
                    }
                    case -3: {
                        aID = CS.PotionsGT.ID_HYPOTHERMIA;
                        break;
                    }
                    case -4: {
                        aID = CS.PotionsGT.ID_HEATSTROKE;
                        break;
                    }
                    case -5: {
                        aID = CS.PotionsGT.ID_FROSTBITE;
                        break;
                    }
                    case -6: {
                        aID = CS.PotionsGT.ID_DEHYDRATION;
                        break;
                    }
                    case -7: {
                        aID = CS.PotionsGT.ID_INSANITY;
                        break;
                    }
                    case -8: {
                        aID = CS.PotionsGT.ID_FLAMMABLE;
                        break;
                    }
                    case -9: {
                        aID = CS.PotionsGT.ID_SLIPPERY;
                        break;
                    }
                    case -10: {
                        aID = CS.PotionsGT.ID_CONDUCTIVE;
                        break;
                    }
                    case -11: {
                        aID = CS.PotionsGT.ID_STICKY;
                    }
                }
            }
            if (aID < 0) {
                return false;
            }
            if (aLevel >= 0) {
                ((EntityLivingBase)aEntity).addPotionEffect(new PotionEffect(aID, aDuration, aLevel, aInvisibleParticles));
                return true;
            }
            ((EntityLivingBase)aEntity).removePotionEffect(aID);
            return true;
        }

        public static byte pot(Object aEntity, Potion aPotion) {
            if (aPotion != null && aEntity instanceof EntityLivingBase) {
                PotionEffect tEffect = ((EntityLivingBase)aEntity).getActivePotionEffect(aPotion);
                return tEffect == null ? (byte)-1 : Code.bind6(tEffect.getAmplifier());
            }
            return -1;
        }

        public static byte pot0(Object aEntity, Potion aPotion) {
            return (byte)(Entities.pot(aEntity, aPotion) + 1);
        }

        public static byte pot1(Object aEntity, Potion aPotion) {
            return (byte)(Entities.pot(aEntity, aPotion) + 2);
        }

        public static byte pot2(Object aEntity, Potion aPotion) {
            return (byte)(Entities.pot(aEntity, aPotion) + 3);
        }

        public static byte potStrength(Object aEntity) {
            return Entities.pot(aEntity, Potion.damageBoost);
        }

        public static byte potWeakness(Object aEntity) {
            return Entities.pot(aEntity, Potion.weakness);
        }

        public static byte potHaste(Object aEntity) {
            return Entities.pot(aEntity, Potion.digSpeed);
        }

        public static byte potFatique(Object aEntity) {
            return Entities.pot(aEntity, Potion.digSlowdown);
        }

        public static byte potSpeed(Object aEntity) {
            return Entities.pot(aEntity, Potion.moveSpeed);
        }

        public static byte potSlowness(Object aEntity) {
            return Entities.pot(aEntity, Potion.moveSlowdown);
        }

        public static byte pot0Strength(Object aEntity) {
            return Entities.pot0(aEntity, Potion.damageBoost);
        }

        public static byte pot0Weakness(Object aEntity) {
            return Entities.pot0(aEntity, Potion.weakness);
        }

        public static byte pot0Haste(Object aEntity) {
            return Entities.pot0(aEntity, Potion.digSpeed);
        }

        public static byte pot0Fatique(Object aEntity) {
            return Entities.pot0(aEntity, Potion.digSlowdown);
        }

        public static byte pot0Speed(Object aEntity) {
            return Entities.pot0(aEntity, Potion.moveSpeed);
        }

        public static byte pot0Slowness(Object aEntity) {
            return Entities.pot0(aEntity, Potion.moveSlowdown);
        }

        public static byte pot1Strength(Object aEntity) {
            return Entities.pot1(aEntity, Potion.damageBoost);
        }

        public static byte pot1Weakness(Object aEntity) {
            return Entities.pot1(aEntity, Potion.weakness);
        }

        public static byte pot1Haste(Object aEntity) {
            return Entities.pot1(aEntity, Potion.digSpeed);
        }

        public static byte pot1Fatique(Object aEntity) {
            return Entities.pot1(aEntity, Potion.digSlowdown);
        }

        public static byte pot1Speed(Object aEntity) {
            return Entities.pot1(aEntity, Potion.moveSpeed);
        }

        public static byte pot1Slowness(Object aEntity) {
            return Entities.pot1(aEntity, Potion.moveSlowdown);
        }

        public static byte pot2Strength(Object aEntity) {
            return Entities.pot2(aEntity, Potion.damageBoost);
        }

        public static byte pot2Weakness(Object aEntity) {
            return Entities.pot2(aEntity, Potion.weakness);
        }

        public static byte pot2Haste(Object aEntity) {
            return Entities.pot2(aEntity, Potion.digSpeed);
        }

        public static byte pot2Fatique(Object aEntity) {
            return Entities.pot2(aEntity, Potion.digSlowdown);
        }

        public static byte pot2Speed(Object aEntity) {
            return Entities.pot2(aEntity, Potion.moveSpeed);
        }

        public static byte pot2Slowness(Object aEntity) {
            return Entities.pot2(aEntity, Potion.moveSlowdown);
        }

        public static byte potStrengthWeakness(Object aEntity) {
            return Code.bindByte(Entities.pot0(aEntity, Potion.damageBoost) - Entities.pot0(aEntity, Potion.weakness));
        }

        public static byte potHasteFatique(Object aEntity) {
            return Code.bindByte(Entities.pot0(aEntity, Potion.digSpeed) - Entities.pot0(aEntity, Potion.digSlowdown));
        }

        public static byte potSpeedSlowness(Object aEntity) {
            return Code.bindByte(Entities.pot0(aEntity, Potion.moveSpeed) - Entities.pot0(aEntity, Potion.moveSlowdown));
        }

        public static long getDurabilityUse(Object aEntity, long aOriginalDurabilityUsed) {
            return Code.divup(aOriginalDurabilityUsed * (long)Entities.pot1Fatique(aEntity), Entities.pot1Haste(aEntity));
        }

        public static boolean exhaust(Object aPlayer) {
            return Entities.exhaust(aPlayer, 0.1);
        }

        public static boolean exhaust(Object aPlayer, double aExhaustion) {
            if (aPlayer instanceof EntityPlayer) {
                if (Entities.isInvincible(aPlayer)) {
                    return true;
                }
                ((EntityPlayer)aPlayer).addExhaustion((float)aExhaustion * (float)Entities.pot1Fatique(aPlayer));
                return true;
            }
            return false;
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(IHasWorldAndCoords aTarget) {
            return Entities.getPlayersWithLastTarget(6L, aTarget);
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(World aWorld, int aX, int aY, int aZ) {
            return Entities.getPlayersWithLastTarget(6L, aWorld, aX, aY, aZ);
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(World aWorld, ChunkCoordinates aCoords) {
            return Entities.getPlayersWithLastTarget(6L, aWorld, aCoords);
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(long aRange, IHasWorldAndCoords aTarget) {
            return Entities.getPlayersWithLastTarget(aRange, aTarget.getWorld(), aTarget.getCoords());
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(long aRange, World aWorld, int aX, int aY, int aZ) {
            return Entities.getPlayersWithLastTarget(aRange, aWorld, new ChunkCoordinates(aX, aY, aZ));
        }

        public static Collection<EntityPlayer> getPlayersWithLastTarget(long aRange, World aWorld, ChunkCoordinates aCoords) {
            ArrayListNoNulls<EntityPlayer> rList = new ArrayListNoNulls<EntityPlayer>();
            for (Map.Entry<EntityPlayer, ChunkCoordinates> tEntry : CS.PLAYER_LAST_CLICKED.entrySet()) {
                if (tEntry.getKey().isDead || aWorld != tEntry.getKey().worldObj || !aCoords.equals((Object)tEntry.getValue()) || !Entities.isCreative(tEntry.getKey()) && !(tEntry.getKey().getDistanceSq((double)aCoords.posX + 0.5, (double)aCoords.posY + 0.5, (double)aCoords.posZ + 0.5) <= (double)(aRange * aRange))) continue;
                rList.add(tEntry.getKey());
            }
            return rList;
        }

        public static boolean canEdit(Object aPlayer, int aX, int aY, int aZ) {
            return !(aPlayer instanceof EntityPlayer) || ((EntityPlayer)aPlayer).canPlayerEdit(aX, aY, aZ, 1, CS.NI);
        }

        public static boolean canEdit(Object aPlayer, int aX, int aY, int aZ, ItemStack aStack) {
            return !(aPlayer instanceof EntityPlayer) || ((EntityPlayer)aPlayer).canPlayerEdit(aX, aY, aZ, 1, aStack);
        }

        public static boolean canEdit(Object aPlayer, int aX, int aY, int aZ, int aSide, ItemStack aStack) {
            return !(aPlayer instanceof EntityPlayer) || ((EntityPlayer)aPlayer).canPlayerEdit(aX, aY, aZ, aSide, aStack);
        }

        public static boolean isPlayer(Object aPlayer) {
            return aPlayer instanceof EntityPlayerMP && !(aPlayer instanceof FakePlayer);
        }

        public static boolean isSpectator(Object aPlayer) {
            return aPlayer instanceof EntityPlayerMP && ((EntityPlayerMP)aPlayer).theItemInWorldManager.getGameType().getName().equalsIgnoreCase("spectator");
        }

        public static boolean isCreative(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode;
        }

        public static boolean isInvincible(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode;
        }

        public static boolean hasInfiniteItems(Object aPlayer) {
            return aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode;
        }

        public static boolean consumeCurrentItem(EntityPlayer aPlayer) {
            if (aPlayer == null) {
                return false;
            }
            if (Entities.hasInfiniteItems(aPlayer)) {
                return true;
            }
            ItemStack aStack = aPlayer.inventory.getStackInSlot(aPlayer.inventory.currentItem);
            if (ST.invalid(aStack)) {
                return false;
            }
            if (aStack.stackSize != 111 && --aStack.stackSize <= 0) {
                aPlayer.inventory.setInventorySlotContents(aPlayer.inventory.currentItem, CS.NI);
            }
            ST.give((Entity)aPlayer, ST.container(aStack, true), false);
            return true;
        }
    }

    public static class Sounds {
        public static List<PlayedSound> sPlayedSounds = new ArrayListNoNulls<PlayedSound>();
        public static List<SoundWithLocation> sSoundsToPlay = new ArrayListNoNulls<SoundWithLocation>();

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume) {
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSound, aTimeUntilNextSound, aVolume, (Entity)GT_API.api_proxy.getThePlayer());
        }

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume, Entity aEntity) {
            if (!CS.CODE_CLIENT || aEntity == null || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSound, aTimeUntilNextSound, aVolume, Code.roundDown(aEntity.posX), Code.roundDown(aEntity.posY), Code.roundDown(aEntity.posZ));
        }

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume, int aX, int aY, int aZ) {
            return Sounds.play(aSound, aTimeUntilNextSound, aVolume, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume, ChunkCoordinates aCoords) {
            if (aCoords == null) {
                return Sounds.play(aSound, aTimeUntilNextSound, aVolume);
            }
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            return Sounds.play(aSound, aTimeUntilNextSound, aVolume, 0.9f + CS.RNGSUS.nextFloat() * 0.2f, aCoords.posX, aCoords.posY, aCoords.posZ);
        }

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume, float aPitch, int aX, int aY, int aZ) {
            return Sounds.play(aSound, aTimeUntilNextSound, aVolume, aPitch, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean play(String aSound, int aTimeUntilNextSound, float aVolume, float aPitch, ChunkCoordinates aCoords) {
            float f;
            if (!CS.CODE_CLIENT || FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                return false;
            }
            EntityPlayer aPlayer = GT_API.api_proxy.getThePlayer();
            if (aPlayer == null || !aPlayer.worldObj.isRemote || Code.stringInvalid(aSound)) {
                return false;
            }
            World world = aPlayer.worldObj;
            int n = Code.roundDown(aCoords.posX);
            int n2 = Code.roundDown(aCoords.posY);
            int n3 = Code.roundDown(aCoords.posZ);
            if (Float.isNaN(aPitch) || aPitch == CS.SFX.RANDOM_PITCH) {
                CS.SFX.PITCH_INDEX = (CS.SFX.PITCH_INDEX + 1) % CS.SFX._7_GRAND_DAD_.length;
                f = CS.SFX._7_GRAND_DAD_[CS.SFX.PITCH_INDEX];
            } else {
                f = aPitch;
            }
            sSoundsToPlay.add(new SoundWithLocation(world, n, n2, n3, aTimeUntilNextSound, aSound, aVolume, f));
            return true;
        }

        public static boolean send(String aSound, IHasWorldAndCoords aTileEntity) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, IHasWorldAndCoords aTileEntity, boolean aIDontWannaFuckingCastThisShitAllTheTime) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, TileEntity aTileEntity) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aTileEntity.getWorldObj(), new ChunkCoordinates(aTileEntity.xCoord, aTileEntity.yCoord, aTileEntity.zCoord));
        }

        public static boolean send(String aSound, Entity aEntity) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aEntity.worldObj, new ChunkCoordinates(Code.roundDown(aEntity.posX), Code.roundDown(aEntity.posY), Code.roundDown(aEntity.posZ)));
        }

        public static boolean send(String aSound, World aWorld, int aX, int aY, int aZ) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aWorld, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean send(String aSound, World aWorld, ChunkCoordinates aCoords) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aWorld, aCoords);
        }

        public static boolean send(String aSound, float aVolume, IHasWorldAndCoords aTileEntity) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, float aVolume, IHasWorldAndCoords aTileEntity, boolean aIDontWannaFuckingCastThisShitAllTheTime) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, float aVolume, TileEntity aTileEntity) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aTileEntity.getWorldObj(), new ChunkCoordinates(aTileEntity.xCoord, aTileEntity.yCoord, aTileEntity.zCoord));
        }

        public static boolean send(String aSound, float aVolume, Entity aEntity) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aEntity.worldObj, new ChunkCoordinates(Code.roundDown(aEntity.posX), Code.roundDown(aEntity.posY), Code.roundDown(aEntity.posZ)));
        }

        public static boolean send(String aSound, float aVolume, World aWorld, int aX, int aY, int aZ) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aWorld, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean send(String aSound, float aVolume, World aWorld, ChunkCoordinates aCoords) {
            return Sounds.send(aSound, aVolume, CS.SFX.RANDOM_PITCH, aWorld, aCoords);
        }

        public static boolean send(String aSound, float aVolume, float aPitch, IHasWorldAndCoords aTileEntity) {
            return Sounds.send(aSound, aVolume, aPitch, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, float aVolume, float aPitch, IHasWorldAndCoords aTileEntity, boolean aIDontWannaFuckingCastThisShitAllTheTime) {
            return Sounds.send(aSound, aVolume, aPitch, aTileEntity.getWorld(), aTileEntity.getCoords());
        }

        public static boolean send(String aSound, float aVolume, float aPitch, TileEntity aTileEntity) {
            return Sounds.send(aSound, aVolume, aPitch, aTileEntity.getWorldObj(), new ChunkCoordinates(aTileEntity.xCoord, aTileEntity.yCoord, aTileEntity.zCoord));
        }

        public static boolean send(String aSound, float aVolume, float aPitch, Entity aEntity) {
            return Sounds.send(aSound, aVolume, aPitch, aEntity.worldObj, new ChunkCoordinates(Code.roundDown(aEntity.posX), Code.roundDown(aEntity.posY), Code.roundDown(aEntity.posZ)));
        }

        public static boolean send(String aSound, float aVolume, float aPitch, World aWorld, int aX, int aY, int aZ) {
            return Sounds.send(aSound, aVolume, aPitch, aWorld, new ChunkCoordinates(aX, aY, aZ));
        }

        public static boolean send(String aSound, float aVolume, float aPitch, World aWorld, ChunkCoordinates aCoords) {
            if (Code.stringInvalid(aSound) || aWorld == null || aWorld.isRemote) {
                return false;
            }
            CS.NW_API.sendToAllPlayersInRange(new PacketSound(aSound, aVolume, aPitch, aCoords), aWorld, aCoords);
            return true;
        }

        @Deprecated
        public static boolean send(World aWorld, String aSound, int aX, int aY, int aZ) {
            return Sounds.send(aSound, 1.0f, CS.SFX.RANDOM_PITCH, aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean send(World aWorld, String aSound, float aVolume, float aPitch, int aX, int aY, int aZ) {
            return Sounds.send(aSound, aVolume, aPitch, aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean send(World aWorld, String aSound, float aVolume, float aPitch, Entity aEntity) {
            return Sounds.send(aSound, aVolume, aPitch, aEntity);
        }

        @Deprecated
        public static boolean send(World aWorld, String aSound, float aVolume, float aPitch, ChunkCoordinates aCoords) {
            return Sounds.send(aSound, aVolume, aPitch, aWorld, aCoords);
        }

        public static class SoundWithLocation {
            public final int mX;
            public final int mY;
            public final int mZ;
            public final int mTimeUntilNextSound;
            public final World mWorld;
            public final String mSound;
            public final float mVolume;
            public final float mPitch;

            public SoundWithLocation(World aWorld, int aX, int aY, int aZ, int aTimeUntilNextSound, String aSound, float aVolume, float aPitch) {
                this.mWorld = aWorld;
                this.mX = aX;
                this.mY = aY;
                this.mZ = aZ;
                this.mTimeUntilNextSound = aTimeUntilNextSound;
                this.mSound = aSound;
                this.mVolume = aVolume;
                this.mPitch = aPitch;
            }

            public void play() {
                PlayedSound tSound = new PlayedSound(this.mSound, this.mX, this.mY, this.mZ, this.mTimeUntilNextSound);
                if (!sPlayedSounds.contains(tSound)) {
                    try {
                        sPlayedSounds.add(tSound);
                        this.mWorld.playSound((double)this.mX + 0.5, (double)this.mY + 0.5, (double)this.mZ + 0.5, this.mSound, this.mVolume, this.mPitch, true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        public static class PlayedSound {
            public final String mSoundName;
            public final int mX;
            public final int mY;
            public final int mZ;
            public int mTimer = 0;

            public PlayedSound(String aSound, int aX, int aY, int aZ, int aTimer) {
                this.mSoundName = aSound == null ? "" : aSound;
                this.mTimer = aTimer;
                this.mX = aX;
                this.mY = aY;
                this.mZ = aZ;
            }

            public boolean equals(Object aObject) {
                if (aObject instanceof PlayedSound) {
                    return ((PlayedSound)aObject).mX == this.mX && ((PlayedSound)aObject).mY == this.mY && ((PlayedSound)aObject).mZ == this.mZ && ((PlayedSound)aObject).mSoundName.equals(this.mSoundName);
                }
                return false;
            }

            public int hashCode() {
                return this.mX + this.mY + this.mZ + this.mSoundName.hashCode();
            }
        }
    }

    @Deprecated
    public static class Inventories {
        @Deprecated
        public static boolean isConnectableNonInventoryPipe(Object aTileEntity, int aSide) {
            return false;
        }

        @Deprecated
        public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTarget, int[] aGrabSlots, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            return 0;
        }

        @Deprecated
        public static byte moveStackFromSlotAToSlotB(IInventory aTileEntity, IInventory aTarget, int aGrabFrom, int aPutTo, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            return 0;
        }

        @Deprecated
        public static boolean isAllowedToTakeFromSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack) {
            return false;
        }

        @Deprecated
        public static boolean isAllowedToPutIntoSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack, int aMaxStackSize) {
            return false;
        }

        @Deprecated
        public static byte moveOneItemStack(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo) {
            return 0;
        }

        @Deprecated
        public static byte moveOneItemStack(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            return 0;
        }

        @Deprecated
        public static byte moveOneItemStackIntoSlot(Object aTileEntity1, Object aTarget, byte aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            return 0;
        }

        @Deprecated
        public static byte moveFromSlotToSlot(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, int aMaxTargetStackSize, int aMinTargetStackSize, int aMaxMoveAtOnce, int aMinMoveAtOnce) {
            return 0;
        }

        @Deprecated
        public static void removeNullStacksFromInventory(IInventory aInventory) {
            ST.denull(aInventory);
        }

        @Deprecated
        public static boolean unlockAchievement(EntityPlayer aPlayer, Achievement aAchievement) {
            return ST.achieve((Entity)aPlayer, aAchievement);
        }

        @Deprecated
        public static boolean checkAchievements(EntityPlayer aPlayer, ItemStack aStack) {
            return ST.check((Entity)aPlayer, aStack);
        }

        @Deprecated
        public static boolean addStackToPlayerInventory(EntityPlayer aPlayer, ItemStack aStack) {
            return ST.add((Entity)aPlayer, aStack);
        }

        @Deprecated
        public static boolean addStackToPlayerInventory(EntityPlayer aPlayer, ItemStack aStack, boolean aCurrentSlotFirst) {
            return ST.add((Entity)aPlayer, aStack, aCurrentSlotFirst);
        }

        @Deprecated
        public static boolean addStackToPlayerInventory(EntityPlayer aPlayer, IInventory aInventory, ItemStack aStack, boolean aCurrentSlotFirst) {
            return ST.add((Entity)aPlayer, aInventory, aStack, aCurrentSlotFirst);
        }

        @Deprecated
        public static boolean addStackToPlayerInventoryOrDrop(EntityPlayer aPlayer, ItemStack aStack) {
            return ST.give((Entity)aPlayer, aStack);
        }

        @Deprecated
        public static boolean addStackToPlayerInventoryOrDrop(EntityPlayer aPlayer, ItemStack aStack, boolean aCurrentSlotFirst) {
            return ST.give((Entity)aPlayer, aStack, aCurrentSlotFirst);
        }

        @Deprecated
        public static boolean addStackToPlayerInventoryOrDrop(EntityPlayer aPlayer, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
            return ST.give((Entity)aPlayer, aStack, aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean addStackToPlayerInventoryOrDrop(EntityPlayer aPlayer, ItemStack aStack, boolean aCurrentSlotFirst, World aWorld, double aX, double aY, double aZ) {
            return ST.give((Entity)aPlayer, aStack, aCurrentSlotFirst, aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static boolean addStackToPlayerInventoryOrDrop(EntityPlayer aPlayer, IInventory aInventory, ItemStack aStack, boolean aCurrentSlotFirst, World aWorld, double aX, double aY, double aZ) {
            return ST.give((Entity)aPlayer, aInventory, aStack, aCurrentSlotFirst, aWorld, aX, aY, aZ);
        }

        @Deprecated
        public static ItemStack getProjectile(TagData aProjectileType, IInventory aInventory) {
            return ST.projectile(aInventory, aProjectileType);
        }
    }

    public static class Reflection {
        public static String getClassName(Object aObject) {
            return aObject == null ? "" : aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1);
        }

        public static String getLowercaseClass(Object aObject) {
            return aObject == null ? "" : aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1).toLowerCase();
        }

        public static Field getPublicField(Object aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getClass().getDeclaredField(aField);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Field setField(Object aObject, String aField, Object aValue) {
            return Reflection.setField(aObject.getClass(), aObject, aField, aValue, true);
        }

        public static Field setField(Object aObject, String aField, Object aValue, boolean aLogErrors) {
            return Reflection.setField(aObject.getClass(), aObject, aField, aValue, aLogErrors);
        }

        public static Field setField(Class<?> aClass, Object aObject, String aField, Object aValue) {
            return Reflection.setField(aClass, aObject, aField, aValue, true);
        }

        public static Field setField(Class<?> aClass, Object aObject, String aField, Object aValue, boolean aLogErrors) {
            Field rField;
            block2: {
                rField = null;
                try {
                    rField = aClass.getDeclaredField(aField);
                    rField.setAccessible(true);
                    rField.set(aObject, aValue);
                }
                catch (Throwable e) {
                    if (!aLogErrors) break block2;
                    e.printStackTrace(CS.ERR);
                }
            }
            return rField;
        }

        public static Field getField(Object aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getClass().getDeclaredField(aField);
                rField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Field getField(Class<?> aObject, String aField) {
            Field rField = null;
            try {
                rField = aObject.getDeclaredField(aField);
                rField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rField;
        }

        public static Method getMethod(Class<?> aObject, String aMethod, Class<?> ... aParameterTypes) {
            Method rMethod = null;
            try {
                rMethod = aObject.getMethod(aMethod, aParameterTypes);
                rMethod.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rMethod;
        }

        public static Method getMethod(Object aObject, String aMethod, Class<?> ... aParameterTypes) {
            Method rMethod = null;
            try {
                rMethod = aObject.getClass().getMethod(aMethod, aParameterTypes);
                rMethod.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return rMethod;
        }

        public static Field getField(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField;
                Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                return tField;
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return null;
            }
        }

        public static Object getFieldContent(Object aObject, String aField) {
            return Reflection.getFieldContent(aObject, aField, true, true);
        }

        public static Object getFieldContent(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField;
                Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                return tField.get(aObject instanceof Class || aObject instanceof String ? null : aObject);
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return null;
            }
        }

        public static boolean setFieldContent(Object aObject, String aField, Object aValue) {
            return Reflection.setFieldContent(aObject, aField, aValue, true, true);
        }

        public static boolean setFieldContent(Object aObject, String aField, Object aValue, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField;
                Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                tField.set(aObject instanceof Class || aObject instanceof String ? null : aObject, aValue);
                return true;
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return false;
            }
        }

        public static boolean setFieldContent(Class<?> aClass, Object aObject, String aField, Object aValue) {
            return Reflection.setFieldContent(aClass, aObject, aField, aValue, true, true);
        }

        public static boolean setFieldContent(Class<?> aClass, Object aObject, String aField, Object aValue, boolean aPrivate, boolean aLogErrors) {
            try {
                Field tField = aClass.getDeclaredField(aField);
                if (aPrivate) {
                    tField.setAccessible(true);
                }
                tField.set(aObject, aValue);
                return true;
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return false;
            }
        }

        public static Object callPublicMethod(Object aObject, String aMethod, Object ... aParameters) {
            return Reflection.callMethod(aObject, aMethod, false, false, true, aParameters);
        }

        public static Object callPrivateMethod(Object aObject, String aMethod, Object ... aParameters) {
            return Reflection.callMethod(aObject, aMethod, true, false, true, aParameters);
        }

        public static Object callMethod(Object aObject, String aMethod, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
            return Reflection.callMethod(aObject, new String[]{aMethod}, aPrivate, aUseUpperCasedDataTypes, aLogErrors, aParameters);
        }

        public static Object callMethod(Object aObject, String[] aMethods, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
            block15: {
                try {
                    Class[] tParameterTypes = new Class[aParameters.length];
                    for (int i = 0; i < aParameters.length; i = (int)((byte)(i + 1))) {
                        if (aParameters[i] instanceof Class) {
                            tParameterTypes[i] = (Class)aParameters[i];
                            aParameters[i] = null;
                        } else {
                            tParameterTypes[i] = aParameters[i].getClass();
                        }
                        if (aUseUpperCasedDataTypes) continue;
                        if (tParameterTypes[i] == Boolean.class) {
                            tParameterTypes[i] = Boolean.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] == Byte.class) {
                            tParameterTypes[i] = Byte.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] == Short.class) {
                            tParameterTypes[i] = Short.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] == Integer.class) {
                            tParameterTypes[i] = Integer.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] == Long.class) {
                            tParameterTypes[i] = Long.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] == Float.class) {
                            tParameterTypes[i] = Float.TYPE;
                            continue;
                        }
                        if (tParameterTypes[i] != Double.class) continue;
                        tParameterTypes[i] = Double.TYPE;
                    }
                    for (String aMethod : aMethods) {
                        try {
                            Method tMethod;
                            Method method = aPrivate ? (aObject instanceof Class ? ((Class)aObject).getDeclaredMethod(aMethod, tParameterTypes) : aObject.getClass().getDeclaredMethod(aMethod, tParameterTypes)) : (tMethod = aObject instanceof Class ? ((Class)aObject).getMethod(aMethod, tParameterTypes) : aObject.getClass().getMethod(aMethod, tParameterTypes));
                            if (aPrivate) {
                                tMethod.setAccessible(true);
                            }
                            return tMethod.invoke(aObject, aParameters);
                        }
                        catch (Throwable e) {
                            if (!aLogErrors) continue;
                            e.printStackTrace(CS.ERR);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!aLogErrors) break block15;
                    e.printStackTrace(CS.ERR);
                }
            }
            return null;
        }

        public static Object callConstructor(String aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
            try {
                return Reflection.callConstructor(Class.forName(aClass), aConstructorIndex, aReplacementObject, aLogErrors, aParameters);
            }
            catch (Throwable e) {
                if (aLogErrors) {
                    e.printStackTrace(CS.ERR);
                }
                return aReplacementObject;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Object callConstructor(Class<?> aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
            if (aConstructorIndex < 0) {
                try {
                    for (Constructor<?> tConstructor : aClass.getConstructors()) {
                        try {
                            return tConstructor.newInstance(aParameters);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    return aReplacementObject;
                }
                catch (Throwable e) {
                    if (!aLogErrors) return aReplacementObject;
                    e.printStackTrace(CS.ERR);
                    return aReplacementObject;
                }
            } else {
                try {
                    return aClass.getConstructors()[aConstructorIndex].newInstance(aParameters);
                }
                catch (Throwable e) {
                    if (!aLogErrors) return aReplacementObject;
                    e.printStackTrace(CS.ERR);
                }
            }
            return aReplacementObject;
        }
    }

    public static class Enchantments {
        private static final BullshitIteratorA mBullshitIteratorA = new BullshitIteratorA();
        private static final BullshitIteratorB mBullshitIteratorB = new BullshitIteratorB();

        private static void applyBullshit(IBullshit aBullshitModifier, ItemStack aStack) {
            NBTTagList nbttaglist;
            if (aStack != null && (nbttaglist = aStack.getEnchantmentTagList()) != null) {
                for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                    try {
                        short short1 = nbttaglist.getCompoundTagAt(i).getShort("id");
                        short short2 = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                        if (Enchantment.enchantmentsList[short1] == null) continue;
                        aBullshitModifier.calculateModifier(Enchantment.enchantmentsList[short1], short2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        private static void applyArrayOfBullshit(IBullshit aBullshitModifier, ItemStack[] aStacks) {
            for (int i = 0; i < aStacks.length; ++i) {
                Enchantments.applyBullshit(aBullshitModifier, aStacks[i]);
            }
        }

        public static void applyBullshitA(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            Enchantments.mBullshitIteratorA.mPlayer = aPlayer;
            Enchantments.mBullshitIteratorA.mEntity = aEntity;
            if (aPlayer != null) {
                Enchantments.applyArrayOfBullshit(mBullshitIteratorA, aPlayer.getLastActiveItems());
            }
            if (aStack != null) {
                Enchantments.applyBullshit(mBullshitIteratorA, aStack);
            }
        }

        public static void applyBullshitB(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            Enchantments.mBullshitIteratorB.mPlayer = aPlayer;
            Enchantments.mBullshitIteratorB.mEntity = aEntity;
            if (aPlayer != null) {
                Enchantments.applyArrayOfBullshit(mBullshitIteratorB, aPlayer.getLastActiveItems());
            }
            if (aStack != null) {
                Enchantments.applyBullshit(mBullshitIteratorB, aStack);
            }
        }

        static interface IBullshit {
            public void calculateModifier(Enchantment var1, int var2);
        }

        static final class BullshitIteratorB
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorB() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151368_a(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static final class BullshitIteratorA
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorA() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151367_b(this.mPlayer, this.mEntity, aLevel);
            }
        }
    }

    public static class NBT {
        public static NBTTagCompound make() {
            return new NBTTagCompound();
        }

        public static NBTTagCompound make(String aFirstKey, Object aFirstValue, Object ... aTags) {
            NBTTagCompound rNBT = NBT.make();
            if (aFirstValue != null) {
                if (aFirstValue instanceof Boolean) {
                    rNBT.setBoolean(aFirstKey, ((Boolean)aFirstValue).booleanValue());
                } else if (aFirstValue instanceof Byte) {
                    rNBT.setByte(aFirstKey, ((Byte)aFirstValue).byteValue());
                } else if (aFirstValue instanceof Short) {
                    rNBT.setShort(aFirstKey, ((Short)aFirstValue).shortValue());
                } else if (aFirstValue instanceof Integer) {
                    rNBT.setInteger(aFirstKey, ((Integer)aFirstValue).intValue());
                } else if (aFirstValue instanceof Long) {
                    rNBT.setLong(aFirstKey, ((Long)aFirstValue).longValue());
                } else if (aFirstValue instanceof Float) {
                    rNBT.setFloat(aFirstKey, ((Float)aFirstValue).floatValue());
                } else if (aFirstValue instanceof Double) {
                    rNBT.setDouble(aFirstKey, ((Double)aFirstValue).doubleValue());
                } else if (aFirstValue instanceof String) {
                    rNBT.setString(aFirstKey, (String)aFirstValue);
                } else if (aFirstValue instanceof NBTBase) {
                    rNBT.setTag(aFirstKey, (NBTBase)aFirstValue);
                } else if (aFirstValue instanceof FluidStack) {
                    rNBT.setTag(aFirstKey, (NBTBase)FL.save((FluidStack)aFirstValue));
                } else if (aFirstValue instanceof OreDictMaterial) {
                    rNBT.setString(aFirstKey, ((OreDictMaterial)aFirstValue).mNameInternal);
                } else if (aFirstValue instanceof Recipe.RecipeMap) {
                    rNBT.setString(aFirstKey, ((Recipe.RecipeMap)aFirstValue).mNameInternal);
                } else {
                    rNBT.setString(aFirstKey, aFirstValue.toString());
                }
            }
            for (int i = 1; i < aTags.length; i += 2) {
                if (aTags[i] == null) continue;
                if (aTags[i] instanceof Boolean) {
                    rNBT.setBoolean(aTags[i - 1].toString(), ((Boolean)aTags[i]).booleanValue());
                    continue;
                }
                if (aTags[i] instanceof Byte) {
                    rNBT.setByte(aTags[i - 1].toString(), ((Byte)aTags[i]).byteValue());
                    continue;
                }
                if (aTags[i] instanceof Short) {
                    rNBT.setShort(aTags[i - 1].toString(), ((Short)aTags[i]).shortValue());
                    continue;
                }
                if (aTags[i] instanceof Integer) {
                    rNBT.setInteger(aTags[i - 1].toString(), ((Integer)aTags[i]).intValue());
                    continue;
                }
                if (aTags[i] instanceof Long) {
                    rNBT.setLong(aTags[i - 1].toString(), ((Long)aTags[i]).longValue());
                    continue;
                }
                if (aTags[i] instanceof Float) {
                    rNBT.setFloat(aTags[i - 1].toString(), ((Float)aTags[i]).floatValue());
                    continue;
                }
                if (aTags[i] instanceof Double) {
                    rNBT.setDouble(aTags[i - 1].toString(), ((Double)aTags[i]).doubleValue());
                    continue;
                }
                if (aTags[i] instanceof String) {
                    rNBT.setString(aTags[i - 1].toString(), (String)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof NBTBase) {
                    rNBT.setTag(aTags[i - 1].toString(), (NBTBase)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof FluidStack) {
                    rNBT.setTag(aTags[i - 1].toString(), (NBTBase)FL.save((FluidStack)aTags[i]));
                    continue;
                }
                if (aTags[i] instanceof OreDictMaterial) {
                    rNBT.setString(aTags[i - 1].toString(), ((OreDictMaterial)aTags[i]).mNameInternal);
                    continue;
                }
                if (aTags[i] instanceof Recipe.RecipeMap) {
                    rNBT.setString(aTags[i - 1].toString(), ((Recipe.RecipeMap)aTags[i]).mNameInternal);
                    continue;
                }
                rNBT.setString(aTags[i - 1].toString(), aTags[i].toString());
            }
            return rNBT;
        }

        public static NBTTagCompound make(NBTTagCompound aNBT, Object ... aTags) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            for (int i = 1; i < aTags.length; i += 2) {
                if (aTags[i] == null) continue;
                if (aTags[i] instanceof Boolean) {
                    aNBT.setBoolean(aTags[i - 1].toString(), ((Boolean)aTags[i]).booleanValue());
                    continue;
                }
                if (aTags[i] instanceof Byte) {
                    aNBT.setByte(aTags[i - 1].toString(), ((Byte)aTags[i]).byteValue());
                    continue;
                }
                if (aTags[i] instanceof Short) {
                    aNBT.setShort(aTags[i - 1].toString(), ((Short)aTags[i]).shortValue());
                    continue;
                }
                if (aTags[i] instanceof Integer) {
                    aNBT.setInteger(aTags[i - 1].toString(), ((Integer)aTags[i]).intValue());
                    continue;
                }
                if (aTags[i] instanceof Long) {
                    aNBT.setLong(aTags[i - 1].toString(), ((Long)aTags[i]).longValue());
                    continue;
                }
                if (aTags[i] instanceof Float) {
                    aNBT.setFloat(aTags[i - 1].toString(), ((Float)aTags[i]).floatValue());
                    continue;
                }
                if (aTags[i] instanceof Double) {
                    aNBT.setDouble(aTags[i - 1].toString(), ((Double)aTags[i]).doubleValue());
                    continue;
                }
                if (aTags[i] instanceof String) {
                    aNBT.setString(aTags[i - 1].toString(), (String)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof NBTBase) {
                    aNBT.setTag(aTags[i - 1].toString(), (NBTBase)aTags[i]);
                    continue;
                }
                if (aTags[i] instanceof FluidStack) {
                    aNBT.setTag(aTags[i - 1].toString(), (NBTBase)FL.save((FluidStack)aTags[i]));
                    continue;
                }
                if (aTags[i] instanceof OreDictMaterial) {
                    aNBT.setString(aTags[i - 1].toString(), ((OreDictMaterial)aTags[i]).mNameInternal);
                    continue;
                }
                if (aTags[i] instanceof Recipe.RecipeMap) {
                    aNBT.setString(aTags[i - 1].toString(), ((Recipe.RecipeMap)aTags[i]).mNameInternal);
                    continue;
                }
                aNBT.setString(aTags[i - 1].toString(), aTags[i].toString());
            }
            return aNBT;
        }

        public static NBTTagCompound fuse(NBTTagCompound aNBT1, NBTTagCompound aNBT2) {
            if (aNBT1 == null) {
                return aNBT2 == null ? NBT.make() : (NBTTagCompound)aNBT2.copy();
            }
            NBTTagCompound rNBT = (NBTTagCompound)aNBT1.copy();
            if (aNBT2 == null) {
                return rNBT;
            }
            for (Object tKey : aNBT2.func_150296_c()) {
                if (rNBT.hasKey(tKey.toString())) continue;
                rNBT.setTag(tKey.toString(), aNBT2.getTag(tKey.toString()));
            }
            return rNBT;
        }

        public static NBTTagList makeInv(ItemStack ... aStacks) {
            NBTTagList rInventory = new NBTTagList();
            for (int i = 0; i < aStacks.length; ++i) {
                if (!ST.valid(aStacks[i])) continue;
                rInventory.appendTag((NBTBase)NBT.makeShort(ST.save(aStacks[i]), "s", (short)i));
            }
            return rInventory;
        }

        public static NBTTagCompound makeBool(Object aTag, boolean aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setBoolean(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeBool(NBTTagCompound aNBT, Object aTag, boolean aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setBoolean(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeByte(Object aTag, byte aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setByte(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setByte(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeShort(Object aTag, short aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setShort(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeShort(NBTTagCompound aNBT, Object aTag, short aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setShort(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeInt(Object aTag, int aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setInteger(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeInt(NBTTagCompound aNBT, Object aTag, int aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setInteger(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeLong(Object aTag, long aValue) {
            NBTTagCompound aNBT = NBT.make();
            NBT.setNumber(aNBT, aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeLong(NBTTagCompound aNBT, Object aTag, long aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            NBT.setNumber(aNBT, aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeFloat(Object aTag, float aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setFloat(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setFloat(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeDouble(Object aTag, double aValue) {
            NBTTagCompound aNBT = NBT.make();
            aNBT.setDouble(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            aNBT.setDouble(aTag.toString(), aValue);
            return aNBT;
        }

        public static NBTTagCompound makeString(Object aTag, Object aValue) {
            NBTTagCompound aNBT = NBT.make();
            if (aValue == null) {
                return aNBT;
            }
            aNBT.setString(aTag.toString(), aValue.toString());
            return aNBT;
        }

        public static NBTTagCompound makeString(NBTTagCompound aNBT, Object aTag, Object aValue) {
            if (aNBT == null) {
                aNBT = NBT.make();
            }
            if (aValue == null) {
                return aNBT;
            }
            aNBT.setString(aTag.toString(), aValue.toString());
            return aNBT;
        }

        @Deprecated
        public static NBTTagCompound getNBTs(NBTTagCompound aNBT, Object ... aTags) {
            return NBT.make(aNBT, aTags);
        }

        @Deprecated
        public static NBTTagCompound getNBTBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
            return NBT.makeBool(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
            return NBT.makeByte(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTShort(NBTTagCompound aNBT, Object aTag, short aValue) {
            return NBT.makeShort(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTInteger(NBTTagCompound aNBT, Object aTag, int aValue) {
            return NBT.makeInt(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTLong(NBTTagCompound aNBT, Object aTag, long aValue) {
            return NBT.makeLong(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
            return NBT.makeFloat(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
            return NBT.makeDouble(aNBT, aTag, aValue);
        }

        @Deprecated
        public static NBTTagCompound getNBTString(NBTTagCompound aNBT, Object aTag, Object aValue) {
            return NBT.makeString(aNBT, aTag, aValue);
        }

        public static NBTTagCompound setBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
            if (aValue) {
                aNBT.setBoolean(aTag.toString(), aValue);
            } else {
                aNBT.removeTag(aTag.toString());
            }
            return aNBT;
        }

        public static NBTTagCompound setNumber(NBTTagCompound aNBT, Object aTag, long aValue) {
            if (aValue == 0L) {
                aNBT.removeTag(aTag.toString());
                return aNBT;
            }
            if (aValue > Integer.MAX_VALUE || aValue < Integer.MIN_VALUE) {
                aNBT.setLong(aTag.toString(), aValue);
                return aNBT;
            }
            if (aValue > 32767L || aValue < -32768L) {
                aNBT.setInteger(aTag.toString(), (int)aValue);
                return aNBT;
            }
            if (aValue > 127L || aValue < -128L) {
                aNBT.setShort(aTag.toString(), (short)aValue);
                return aNBT;
            }
            aNBT.setByte(aTag.toString(), (byte)aValue);
            return aNBT;
        }

        public static NBTTagCompound setPosNum(NBTTagCompound aNBT, Object aTag, long aValue) {
            if (aValue <= 0L) {
                aNBT.removeTag(aTag.toString());
                return aNBT;
            }
            if (aValue > Integer.MAX_VALUE) {
                aNBT.setLong(aTag.toString(), aValue);
                return aNBT;
            }
            if (aValue > 32767L) {
                aNBT.setInteger(aTag.toString(), (int)aValue);
                return aNBT;
            }
            if (aValue > 127L) {
                aNBT.setShort(aTag.toString(), (short)aValue);
                return aNBT;
            }
            aNBT.setByte(aTag.toString(), (byte)aValue);
            return aNBT;
        }

        public static ItemStack check(ItemStack aStack) {
            return NBT.set(aStack, aStack.getTagCompound());
        }

        public static ItemStack set(ItemStack aStack, NBTTagCompound aNBT) {
            if (aNBT == null || aNBT.hasNoTags()) {
                aStack.setTagCompound(null);
                return aStack;
            }
            ArrayListNoNulls<String> tTagsToRemove = new ArrayListNoNulls<String>();
            for (Object e : aNBT.func_150296_c()) {
                NBTBase tValue = aNBT.getTag((String)e);
                if (!(tValue == null || tValue instanceof NBTTagCompound && ((NBTTagCompound)tValue).hasNoTags() || tValue instanceof NBTBase.NBTPrimitive && ((NBTBase.NBTPrimitive)tValue).func_150291_c() == 0L) && (!(tValue instanceof NBTTagString) || !Code.stringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
                ((ArrayList)tTagsToRemove).add((String)e);
            }
            for (Object e : tTagsToRemove) {
                aNBT.removeTag((String)e);
            }
            aStack.setTagCompound(aNBT.hasNoTags() ? null : aNBT);
            return aStack;
        }

        public static NBTTagCompound getNBT(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.getTagCompound();
            return rNBT == null ? NBT.make() : rNBT;
        }

        public static NBTTagCompound getOrCreate(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.getTagCompound();
            if (rNBT == null) {
                rNBT = NBT.make();
                aStack.setTagCompound(rNBT);
            }
            return rNBT;
        }

        public static NBTTagCompound setPunchCardData(ItemStack aStack, String aPunchCardData) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setString("gt.punchcard", aPunchCardData);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static String getPunchCardData(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.getString("gt.punchcard");
        }

        public static NBTTagCompound setPunchCardData(NBTTagCompound aNBT, String aPunchCardData) {
            aNBT.setString("gt.punchcard", aPunchCardData);
            return aNBT;
        }

        public static String getPunchCardData(NBTTagCompound aNBT) {
            return aNBT.getString("gt.punchcard");
        }

        public static NBTTagCompound setBlueprintCrafting(ItemStack aStack, ItemStack ... aBlueprint) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            NBT.setBlueprintCrafting(tNBT, aBlueprint);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static ItemStack[] getBlueprintCrafting(ItemStack aStack) {
            return NBT.getBlueprintCrafting(NBT.getNBT(aStack));
        }

        public static NBTTagCompound setBlueprintCrafting(NBTTagCompound aNBT, ItemStack ... aBlueprint) {
            NBTTagCompound tList = NBT.make();
            boolean temp = false;
            for (int i = 0; i < aBlueprint.length; ++i) {
                if (!ST.valid(aBlueprint[i])) continue;
                ST.save(tList, "" + i, ST.amount(1L, aBlueprint[i]));
                temp = true;
            }
            if (temp) {
                aNBT.setTag("gt.blueprint.craft", (NBTBase)tList);
            }
            return aNBT;
        }

        public static ItemStack[] getBlueprintCrafting(NBTTagCompound aNBT) {
            NBTTagCompound tList;
            NBTTagCompound nBTTagCompound = tList = aNBT.hasKey("gt.blueprint.craft") ? aNBT.getCompoundTag("gt.blueprint.craft") : null;
            if (tList != null) {
                ItemStack[] rRecipe = new ItemStack[9];
                for (int i = 0; i < rRecipe.length; ++i) {
                    rRecipe[i] = ST.amount(1L, ST.load(tList, "" + i));
                }
                return rRecipe;
            }
            return CS.ZL_IS;
        }

        public static NBTTagCompound setLighterFuel(ItemStack aStack, long aFuel) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            NBT.setNumber(tNBT, "gt.lighter", aFuel);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static long getLighterFuel(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.getLong("gt.lighter");
        }

        public static NBTTagCompound setLighterFuel(NBTTagCompound aNBT, long aFuel) {
            NBT.setNumber(aNBT, "gt.lighter", aFuel);
            return aNBT;
        }

        public static long getLighterFuel(NBTTagCompound aNBT) {
            return aNBT.getLong("gt.lighter");
        }

        public static NBTTagCompound setMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setShort("map_id", aMapID);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static short getMapID(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.hasKey("map_id")) {
                return -1;
            }
            return tNBT.getShort("map_id");
        }

        public static NBTTagCompound setMapID(NBTTagCompound aNBT, short aMapID) {
            aNBT.setShort("map_id", aMapID);
            return aNBT;
        }

        public static short getMapID(NBTTagCompound aNBT) {
            if (!aNBT.hasKey("map_id")) {
                return -1;
            }
            return aNBT.getShort("map_id");
        }

        public static NBTTagCompound setMagicMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setShort("magic_map_id", aMapID);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static short getMagicMapID(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.hasKey("magic_map_id")) {
                return -1;
            }
            return tNBT.getShort("magic_map_id");
        }

        public static NBTTagCompound setMagicMapID(NBTTagCompound aNBT, short aMapID) {
            aNBT.setShort("magic_map_id", aMapID);
            return aNBT;
        }

        public static short getMagicMapID(NBTTagCompound aNBT) {
            if (!aNBT.hasKey("magic_map_id")) {
                return -1;
            }
            return aNBT.getShort("magic_map_id");
        }

        public static NBTTagCompound setMazeMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setShort("maze_map_id", aMapID);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static short getMazeMapID(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.hasKey("maze_map_id")) {
                return -1;
            }
            return tNBT.getShort("maze_map_id");
        }

        public static NBTTagCompound setMazeMapID(NBTTagCompound aNBT, short aMapID) {
            aNBT.setShort("maze_map_id", aMapID);
            return aNBT;
        }

        public static short getMazeMapID(NBTTagCompound aNBT) {
            if (!aNBT.hasKey("maze_map_id")) {
                return -1;
            }
            return aNBT.getShort("maze_map_id");
        }

        public static NBTTagCompound setOreMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setShort("ore_map_id", aMapID);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static short getOreMapID(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.hasKey("ore_map_id")) {
                return -1;
            }
            return tNBT.getShort("ore_map_id");
        }

        public static NBTTagCompound setOreMapID(NBTTagCompound aNBT, short aMapID) {
            aNBT.setShort("ore_map_id", aMapID);
            return aNBT;
        }

        public static short getOreMapID(NBTTagCompound aNBT) {
            if (!aNBT.hasKey("ore_map_id")) {
                return -1;
            }
            return aNBT.getShort("ore_map_id");
        }

        public static NBTTagCompound setBookMapping(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setString("book", aTitle);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static String getBookMapping(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.getString("book");
        }

        public static NBTTagCompound setBookMapping(NBTTagCompound aNBT, String aTitle) {
            aNBT.setString("book", aTitle);
            return aNBT;
        }

        public static String getBookMapping(NBTTagCompound aNBT) {
            return aNBT.getString("book");
        }

        public static NBTTagCompound setBookTitle(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setString("title", aTitle);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static String getBookTitle(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.getString("title");
        }

        public static NBTTagCompound setBookTitle(NBTTagCompound aNBT, String aTitle) {
            aNBT.setString("title", aTitle);
            return aNBT;
        }

        public static String getBookTitle(NBTTagCompound aNBT) {
            return aNBT.getString("title");
        }

        public static NBTTagCompound setBookAuthor(ItemStack aStack, String aAuthor) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            tNBT.setString("author", aAuthor);
            NBT.set(aStack, tNBT);
            return tNBT;
        }

        public static String getBookAuthor(ItemStack aStack) {
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            return tNBT.getString("author");
        }

        public static NBTTagCompound setBookAuthor(NBTTagCompound aNBT, String aAuthor) {
            aNBT.setString("author", aAuthor);
            return aNBT;
        }

        public static String getBookAuthor(NBTTagCompound aNBT) {
            return aNBT.getString("author");
        }

        public static List<String> getDataToolTip(NBTTagCompound aData, List<String> aList, boolean aAllDetails) {
            if (aData.hasKey("gt.reactor.setup")) {
                aList.add(LH.Chat.CYAN + "Reactor Setup: " + aData.getString("gt.reactor.setup.name"));
                return aList;
            }
            if (aData.hasKey("gt.canvas.block")) {
                aList.add(LH.Chat.CYAN + "Block Image: " + ST.names(ST.make(Block.getBlockById((int)aData.getInteger("gt.canvas.block")), 1L, (long)aData.getInteger("gt.canvas.meta"))));
                return aList;
            }
            if (aData.hasKey("gt.replicator.data")) {
                short tIndex = aData.getShort("gt.replicator.data");
                if (Code.exists(tIndex, OreDictMaterial.MATERIAL_ARRAY)) {
                    OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[tIndex];
                    if (tMaterial.contains(TD.Processing.UUM)) {
                        if (aAllDetails) {
                            aList.add(LH.Chat.CYAN + "Material Data: " + LH.Chat.WHITE + tMaterial.getLocal());
                            aList.add(LH.Chat.CYAN + "Can be Replicated using");
                            if (tMaterial.contains(TD.Atomic.ANTIMATTER)) {
                                aList.add(LH.Chat.WHITE + "Neutral Antimatter: " + LH.Chat.YELLOW + tMaterial.mNeutrons);
                                aList.add(LH.Chat.WHITE + "Charged Antimatter: " + LH.Chat.RED + tMaterial.mProtons);
                            } else {
                                aList.add(LH.Chat.WHITE + "Neutral Matter: " + LH.Chat.YELLOW + tMaterial.mNeutrons);
                                aList.add(LH.Chat.WHITE + "Charged Matter: " + LH.Chat.RED + tMaterial.mProtons);
                            }
                            aList.add(LH.Chat.WHITE + "Energy: " + TD.Energy.QU.getChatFormat() + (tMaterial.mNeutrons + tMaterial.mProtons) * 65536L + " " + TD.Energy.QU.getLocalisedNameShort());
                        } else {
                            aList.add(LH.Chat.CYAN + "Mat Data: " + LH.Chat.WHITE + tMaterial.getLocal() + (aAllDetails ? "" : " (" + LH.Chat.YELLOW + tMaterial.mNeutrons + LH.Chat.WHITE + "/" + LH.Chat.RED + tMaterial.mProtons + LH.Chat.WHITE + "/" + TD.Energy.QU.getChatFormat() + (tMaterial.mNeutrons + tMaterial.mProtons) * 65536L + LH.Chat.WHITE + ")"));
                        }
                    } else {
                        aList.add(LH.Chat.CYAN + "Material Data: " + LH.Chat.WHITE + tMaterial.getLocal() + LH.Chat.ORANGE + " (Not Replicatable)");
                    }
                }
                return aList;
            }
            if (IL.GC_Schematic_1.exists() && aData.hasKey("gc_schematics_1")) {
                aList.add(LH.Chat.CYAN + IL.GC_Schematic_1.getWithMeta(1L, aData.getShort("gc_schematics_1"), new Object[0]).getDisplayName());
                return aList;
            }
            if (IL.GC_Schematic_2.exists() && aData.hasKey("gc_schematics_2")) {
                aList.add(LH.Chat.CYAN + IL.GC_Schematic_2.getWithMeta(1L, aData.getShort("gc_schematics_2"), new Object[0]).getDisplayName());
                return aList;
            }
            if (IL.GC_Schematic_3.exists() && aData.hasKey("gc_schematics_3")) {
                aList.add(LH.Chat.CYAN + IL.GC_Schematic_3.getWithMeta(1L, aData.getShort("gc_schematics_3"), new Object[0]).getDisplayName());
                return aList;
            }
            if (IL.IE_Blueprint_Projectiles_Common.exists() && aData.hasKey("ie_blueprint")) {
                short tMeta = aData.getShort("ie_blueprint");
                aList.add(LH.Chat.CYAN + IL.IE_Blueprint_Projectiles_Common.getWithMeta(1L, tMeta, new Object[0]).getDisplayName());
                switch (tMeta) {
                    case 0: {
                        aList.add(LH.Chat.GREEN + "Common Projectiles");
                        break;
                    }
                    case 1: {
                        aList.add(LH.Chat.GREEN + "Specialized Projectiles");
                        break;
                    }
                    case 2: {
                        aList.add(LH.Chat.GREEN + "Arc Furnace Electrodes");
                    }
                }
                return aList;
            }
            String tString = NBT.getBookTitle(aData);
            if (Code.stringValid(tString)) {
                aList.add(LH.Chat.CYAN + "Book: " + tString);
                if (aAllDetails && Code.stringValid(tString = NBT.getBookAuthor(aData))) {
                    aList.add(LH.Chat.CYAN + "by " + tString);
                }
                return aList;
            }
            short tMapID = NBT.getMapID(aData);
            if (tMapID >= 0) {
                aList.add(LH.Chat.CYAN + "Map ID: " + tMapID);
                return aList;
            }
            tMapID = NBT.getMagicMapID(aData);
            if (tMapID >= 0) {
                aList.add(LH.Chat.CYAN + "Magic Map ID: " + tMapID);
                return aList;
            }
            tMapID = NBT.getMazeMapID(aData);
            if (tMapID >= 0) {
                aList.add(LH.Chat.CYAN + "Maze Map ID: " + tMapID);
                return aList;
            }
            tMapID = NBT.getOreMapID(aData);
            if (tMapID >= 0) {
                aList.add(LH.Chat.CYAN + "Ore Map ID: " + tMapID);
                return aList;
            }
            tString = NBT.getPunchCardData(aData);
            if (Code.stringValid(tString)) {
                aList.add(LH.Chat.CYAN + "Punch Card Data");
                if (aAllDetails) {
                    int j = tString.length();
                    for (int i = 0; i < j; i += 64) {
                        aList.add(LH.Chat.GREEN + tString.substring(i, Math.min(i + 64, j)));
                    }
                }
                return aList;
            }
            ItemStack[] tBlueprint = NBT.getBlueprintCrafting(aData);
            if (tBlueprint != CS.ZL_IS) {
                ItemStack tCrafted = CR.getany((World)CS.DW, tBlueprint);
                if (ST.invalid(tCrafted)) {
                    aList.add(LH.Chat.CYAN + "Blueprint with random Items");
                } else if (aAllDetails) {
                    aList.add(LH.Chat.CYAN + "Blueprint for " + tCrafted.getDisplayName());
                } else {
                    aList.add(LH.Chat.CYAN + "Blueprint: " + tCrafted.getDisplayName());
                }
                return aList;
            }
            return aList;
        }

        public static int getEnchantmentLevelDestruction(ItemStack aStack) {
            return MD.RC.mLoaded ? NBT.getEnchantmentLevel(RailcraftEnchantments.destruction, aStack) : 0;
        }

        public static int getEnchantmentLevelWrecking(ItemStack aStack) {
            return MD.RC.mLoaded ? NBT.getEnchantmentLevel(RailcraftEnchantments.wrecking, aStack) : 0;
        }

        public static int getEnchantmentLevelImplosion(ItemStack aStack) {
            return MD.RC.mLoaded ? NBT.getEnchantmentLevel(RailcraftEnchantments.implosion, aStack) : 0;
        }

        public static int getEnchantmentLevelLootingFortune(ItemStack aStack) {
            return Math.max(NBT.getEnchantmentLevel(Enchantment.fortune, aStack), NBT.getEnchantmentLevel(Enchantment.looting, aStack));
        }

        public static int getEnchantmentLevel(Enchantment aEnchantment, ItemStack aStack) {
            if (aEnchantment == null || aEnchantment.effectId < 0) {
                return 0;
            }
            return EnchantmentHelper.getEnchantmentLevel((int)aEnchantment.effectId, (ItemStack)aStack);
        }

        public static int getEnchantmentXP(ItemStack aStack) {
            if (ST.invalid(aStack) || !aStack.hasTagCompound() || ST.isGT_(aStack) || CS.COMPAT_EU_ITEM != null && CS.COMPAT_EU_ITEM.is(aStack)) {
                return 0;
            }
            return NBT.getEnchantmentXP(NBT.getNBT(aStack));
        }

        public static int getEnchantmentXP(NBTTagCompound aNBT) {
            if (!aNBT.hasKey("ench", 9)) {
                return 0;
            }
            int rXP = 0;
            NBTTagList aList = aNBT.getTagList("ench", 10);
            for (int i = 0; i < aList.tagCount(); ++i) {
                NBTTagCompound tEnchantmentTag = aList.getCompoundTagAt(i);
                Enchantment tEnchantment = Enchantment.enchantmentsList[tEnchantmentTag.getShort("id")];
                if (Reflection.getLowercaseClass(tEnchantment).contains("curse")) {
                    return 0;
                }
                rXP += tEnchantment.getMinEnchantability((int)tEnchantmentTag.getShort("lvl"));
            }
            return Code.bindInt(Code.divup(rXP, 2L));
        }

        public static ItemStack removeEnchantments(ItemStack aStack) {
            NBT.removeEnchantments(NBT.getOrCreate(aStack));
            return NBT.check(aStack);
        }

        public static void removeEnchantments(NBTTagCompound aNBT) {
            aNBT.removeTag("ench");
        }

        public static ItemStack addEnchantment(ItemStack aStack, Enchantment aEnchantment, long aLevel) {
            NBTTagCompound tEnchantmentTag;
            NBTTagCompound tNBT = NBT.getNBT(aStack);
            if (!tNBT.hasKey("ench", 9)) {
                tNBT.setTag("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList tList = tNBT.getTagList("ench", 10);
            boolean temp = true;
            for (int i = 0; i < tList.tagCount(); ++i) {
                tEnchantmentTag = tList.getCompoundTagAt(i);
                if (tEnchantmentTag.getShort("id") != aEnchantment.effectId) continue;
                tEnchantmentTag.setShort("id", (short)aEnchantment.effectId);
                tEnchantmentTag.setShort("lvl", (short)((byte)aLevel));
                temp = false;
                break;
            }
            if (temp) {
                tEnchantmentTag = NBT.make();
                tEnchantmentTag.setShort("id", (short)aEnchantment.effectId);
                tEnchantmentTag.setShort("lvl", (short)((byte)aLevel));
                tList.appendTag((NBTBase)tEnchantmentTag);
            }
            return NBT.set(aStack, tNBT);
        }
    }

    public static class Code {
        private static final DateFormat sDateFormat = DateFormat.getInstance();
        public static final int[][] ASCENDING_ARRAYS = new int[1024][];

        public static byte averageBytes(byte ... aBytes) {
            if (aBytes == null || aBytes.length <= 0) {
                return 0;
            }
            return (byte)(Code.sum(aBytes) / (long)aBytes.length);
        }

        public static byte averageUnsignedBytes(byte ... aBytes) {
            if (aBytes == null || aBytes.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (byte aByte : aBytes) {
                rValue += (long)Code.unsignB(aByte);
            }
            return (byte)(rValue / (long)aBytes.length);
        }

        public static short averageShorts(short ... aShorts) {
            if (aShorts == null || aShorts.length <= 0) {
                return 0;
            }
            return (short)(Code.sum(aShorts) / (long)aShorts.length);
        }

        public static short averageUnsignedShorts(short ... aShorts) {
            if (aShorts == null || aShorts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (short aShort : aShorts) {
                rValue += (long)Code.unsignS(aShort);
            }
            return (short)(rValue / (long)aShorts.length);
        }

        public static int averageInts(int ... aInts) {
            if (aInts == null || aInts.length <= 0) {
                return 0;
            }
            return Code.bindInt(Code.sum(aInts) / (long)aInts.length);
        }

        public static int averageUnsignedInts(int ... aInts) {
            if (aInts == null || aInts.length <= 0) {
                return 0;
            }
            long rValue = 0L;
            for (int aInt : aInts) {
                rValue += Code.unsignI(aInt);
            }
            return Code.bindInt(rValue / (long)aInts.length);
        }

        public static long averageLongs(long ... aLongs) {
            if (aLongs == null || aLongs.length <= 0) {
                return 0L;
            }
            return Code.sum(aLongs) / (long)aLongs.length;
        }

        public static int roundDown(double aNumber) {
            int rRounded = (int)aNumber;
            return (double)rRounded > aNumber ? rRounded - 1 : rRounded;
        }

        public static int roundUp(double aNumber) {
            int rRounded = (int)aNumber;
            return (double)rRounded < aNumber ? rRounded + 1 : rRounded;
        }

        public static short unsignB(byte aByte) {
            return aByte < 0 ? (short)(aByte + 256) : (short)aByte;
        }

        public static int unsignS(short aShort) {
            return aShort < 0 ? aShort + 65536 : aShort;
        }

        public static long unsignI(int aInteger) {
            return aInteger < 0 ? (long)aInteger + 0x100000000L : (long)aInteger;
        }

        public static byte toByteS(short aValue, int aIndex) {
            return (byte)(aValue >> (aIndex << 3));
        }

        public static byte toByteI(int aValue, int aIndex) {
            return (byte)(aValue >> (aIndex << 3));
        }

        public static byte toByteL(long aValue, int aIndex) {
            return (byte)(aValue >> (aIndex << 3));
        }

        public static short combine(byte aValue1, byte aValue2) {
            return (short)(0xFF & aValue1 | aValue2 << 8);
        }

        public static int combine(byte aValue1, byte aValue2, byte aValue3, byte aValue4) {
            return 0xFF & aValue1 | (0xFF & aValue2) << 8 | (0xFF & aValue3) << 16 | aValue4 << 24;
        }

        public static long combine(byte aValue1, byte aValue2, byte aValue3, byte aValue4, byte aValue5, byte aValue6, byte aValue7, byte aValue8) {
            return (long)aValue1 & 0xFFL | ((long)aValue2 & 0xFFL) << 8 | ((long)aValue3 & 0xFFL) << 16 | ((long)aValue4 & 0xFFL) << 24 | ((long)aValue5 & 0xFFL) << 32 | ((long)aValue6 & 0xFFL) << 40 | ((long)aValue7 & 0xFFL) << 48 | (long)aValue8 << 56;
        }

        public static long getBits(boolean ... aBits) {
            long rBits = 0L;
            for (int i = 0; i < 64 && i < aBits.length; ++i) {
                if (!aBits[i]) continue;
                rBits |= (long)(1 << i);
            }
            return rBits;
        }

        public static boolean[] getBitsB(byte aBits) {
            boolean[] rBits = new boolean[8];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsS(short aBits) {
            boolean[] rBits = new boolean[16];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsI(int aBits) {
            boolean[] rBits = new boolean[32];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & 1 << i) == 0) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static boolean[] getBitsL(long aBits) {
            boolean[] rBits = new boolean[64];
            for (int i = 0; i < rBits.length; ++i) {
                if ((aBits & (long)(1 << i)) == 0L) continue;
                rBits[i] = true;
            }
            return rBits;
        }

        public static ItemStack toStack(int aStack) {
            Item tItem = Item.getItemById((int)(aStack & 0xFFFF));
            if (tItem != null) {
                return ST.make(tItem, 1L, (long)(aStack >>> 16));
            }
            return null;
        }

        public static UUID getUUID(byte[] aData, int aOffset) {
            return aData.length - aOffset < 16 ? null : new UUID(Code.combine(aData[aOffset], aData[aOffset + 1], aData[aOffset + 2], aData[aOffset + 3], aData[aOffset + 4], aData[aOffset + 5], aData[aOffset + 6], aData[aOffset + 7]), Code.combine(aData[aOffset + 8], aData[aOffset + 9], aData[aOffset + 10], aData[aOffset + 11], aData[aOffset + 12], aData[aOffset + 13], aData[aOffset + 14], aData[aOffset + 15]));
        }

        public static byte[] getBytes(UUID aData, int aOffset) {
            if (aData == null) {
                return new byte[aOffset];
            }
            byte[] rData = new byte[aOffset + 16];
            for (int i = 0; i < 8; ++i) {
                rData[aOffset + i] = Code.toByteL(aData.getMostSignificantBits(), i);
                rData[aOffset + 8 + i] = Code.toByteL(aData.getLeastSignificantBits(), i);
            }
            return rData;
        }

        public static String makeString(long aNumber) {
            if (aNumber > -10000L && aNumber < 10000L) {
                return Long.toString(aNumber);
            }
            StringBuilder rString = new StringBuilder();
            if (aNumber < 0L) {
                aNumber *= -1L;
                rString.append('-');
            }
            boolean temp = true;
            for (long i = 1000000000000000000L; i > 0L; i /= 10L) {
                long tDigit = aNumber / i % 10L;
                if (temp && tDigit != 0L) {
                    temp = false;
                }
                if (temp) continue;
                rString.append(tDigit);
                if (i == 1L) continue;
                for (long j = i; j > 0L; j /= 1000L) {
                    if (j != 1L) continue;
                    rString.append('_');
                }
            }
            return rString.toString();
        }

        @SafeVarargs
        public static <E> boolean contains(E aTarget, E ... aArray) {
            if (aArray != null) {
                for (E tValue : aArray) {
                    if (tValue != aTarget && (tValue == null || aTarget == null || !tValue.equals(aTarget))) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean containsBoolean(boolean aTarget, boolean ... aArray) {
            if (aArray != null) {
                for (boolean tValue : aArray) {
                    if (tValue != aTarget) continue;
                    return true;
                }
            }
            return false;
        }

        @SafeVarargs
        public static <E> boolean containsSomething(E ... aArray) {
            if (aArray != null) {
                for (E tObject : aArray) {
                    if (tObject == null) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean[] swap(int aIndexA, int aIndexB, boolean[] aArray) {
            boolean tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static byte[] swap(int aIndexA, int aIndexB, byte[] aArray) {
            byte tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static short[] swap(int aIndexA, int aIndexB, short[] aArray) {
            short tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static int[] swap(int aIndexA, int aIndexB, int[] aArray) {
            int tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static long[] swap(int aIndexA, int aIndexB, long[] aArray) {
            long tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static <E> E[] swap(int aIndexA, int aIndexB, E[] aArray) {
            E tSwap = aArray[aIndexA];
            aArray[aIndexA] = aArray[aIndexB];
            aArray[aIndexB] = tSwap;
            return aArray;
        }

        public static <E> E[] fill(E aToFillIn, E[] rArray) {
            Arrays.fill(rArray, aToFillIn);
            return rArray;
        }

        @SafeVarargs
        public static <E> E[] makeArray(E[] rArray, E ... aArray) {
            for (int i = 0; i < rArray.length && i < aArray.length; ++i) {
                rArray[i] = aArray[i];
            }
            return rArray;
        }

        @SafeVarargs
        public static <E> long getNonNulls(E ... aArray) {
            long rAmount = 0L;
            if (aArray != null) {
                for (E tObject : aArray) {
                    if (tObject == null) continue;
                    ++rAmount;
                }
            }
            return rAmount;
        }

        @SafeVarargs
        public static <E> ArrayList<E> getWithoutNulls(E ... aArray) {
            if (aArray == null) {
                return new ArrayListNoNulls();
            }
            ArrayListNoNulls<E> rList = new ArrayListNoNulls<E>(Arrays.asList(aArray));
            return rList;
        }

        @SafeVarargs
        public static <E> ArrayList<E> getWithoutTrailingNulls(E ... aArray) {
            if (aArray == null) {
                return new ArrayList(1);
            }
            ArrayList<E> rList = new ArrayList<E>(Arrays.asList(aArray));
            int i = rList.size() - 1;
            while (i >= 0 && rList.get(i) == null) {
                rList.remove(i--);
            }
            return rList;
        }

        @SafeVarargs
        public static <E> E getFirstNonNull(E ... aArray) {
            if (aArray != null) {
                for (E tObject : aArray) {
                    if (tObject == null) continue;
                    return tObject;
                }
            }
            return null;
        }

        public static String dateAndTime() {
            return sDateFormat.format(new Date());
        }

        public static byte tier(long aSize) {
            return Code.tierMax(aSize);
        }

        public static byte tierMax(long aSize) {
            byte i = -1;
            aSize = Math.abs(aSize);
            while ((i = (byte)((byte)(i + 1))) < CS.V.length) {
                if (aSize > CS.V[i]) continue;
                return i;
            }
            return i;
        }

        public static byte tierMin(long aSize) {
            byte i = -1;
            aSize = Math.abs(aSize);
            while ((i = (byte)((byte)(i + 1))) < CS.V.length) {
                if (aSize >= CS.V[i]) continue;
                return (byte)Math.max(0, i - 1);
            }
            i = (byte)(i - 1);
            return i;
        }

        public static long voltMax(long aSize) {
            aSize = Math.abs(aSize);
            for (int i = 0; i < CS.VMAX.length; ++i) {
                if (aSize >= CS.VMAX[i]) continue;
                return CS.VMAX[i];
            }
            return CS.VMAX[CS.VMAX.length - 1];
        }

        public static long voltMin(long aSize) {
            aSize = Math.abs(aSize);
            for (int i = 0; i < CS.VMAX.length; ++i) {
                if (aSize >= CS.VMAX[i]) continue;
                return CS.VMIN[i];
            }
            return CS.VMIN[CS.VMIN.length - 1];
        }

        public static boolean haveOneCommonElement(Iterable<?> aCollection1, Collection<?> aCollection2) {
            if (aCollection1 == aCollection2) {
                return true;
            }
            for (Object tObject : aCollection1) {
                if (!aCollection2.contains(tObject)) continue;
                return true;
            }
            return false;
        }

        public static <X, Y> Map<X, Y> reMap(Map<X, Y> aMap) {
            HashMap<X, Y> tMap = new HashMap<X, Y>();
            tMap.putAll(aMap);
            aMap.clear();
            aMap.putAll(tMap);
            return aMap;
        }

        public static <X> Set<X> reMap(Set<X> aSet) {
            HashSet<X> tSet = new HashSet<X>();
            tSet.addAll(aSet);
            aSet.clear();
            aSet.addAll(aSet);
            return aSet;
        }

        public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesAcending(Map<X, Y> aMap) {
            LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
            Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

                @Override
                public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                    return ((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
                }
            });
            LinkedHashMap rMap = new LinkedHashMap();
            for (Map.Entry entry : tEntrySet) {
                rMap.put(entry.getKey(), entry.getValue());
            }
            return rMap;
        }

        public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesDescending(Map<X, Y> aMap) {
            LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
            Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

                @Override
                public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                    return -((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
                }
            });
            LinkedHashMap rMap = new LinkedHashMap();
            for (Map.Entry entry : tEntrySet) {
                rMap.put(entry.getKey(), entry.getValue());
            }
            return rMap;
        }

        public static <E> E select(long aIndex, E aReplacement, List<E> aList) {
            if (aList == null || aList.isEmpty()) {
                return aReplacement;
            }
            if (aIndex >= (long)aList.size()) {
                return aReplacement == null ? aList.get(aList.size() - 1) : aReplacement;
            }
            if (aIndex < 0L) {
                return aReplacement == null ? aList.get(0) : aReplacement;
            }
            return aList.get((int)aIndex);
        }

        public static <E> E select(E aReplacement, List<E> aList) {
            return aList == null || aList.isEmpty() ? aReplacement : Code.select((long)CS.RNGSUS.nextInt(aList.size()), aReplacement, aList);
        }

        @SafeVarargs
        public static <E> E select(long aIndex, E aReplacement, E ... aArray) {
            if (aArray == null || aArray.length <= 0) {
                return aReplacement;
            }
            if (aIndex >= (long)aArray.length) {
                return aReplacement == null ? aArray[aArray.length - 1] : aReplacement;
            }
            if (aIndex < 0L) {
                return aReplacement == null ? aArray[0] : aReplacement;
            }
            return aArray[(int)aIndex];
        }

        @SafeVarargs
        public static <E> E select(E aReplacement, E ... aArray) {
            return aArray == null || aArray.length <= 0 ? aReplacement : Code.select((long)CS.RNGSUS.nextInt(aArray.length), aReplacement, aArray);
        }

        public static boolean inArray(Object aObject, Object ... aObjects) {
            return Code.inList(aObject, Arrays.asList(aObjects));
        }

        public static boolean inList(Object aObject, Collection<?> aObjects) {
            if (aObjects == null) {
                return false;
            }
            return aObjects.contains(aObject);
        }

        public static int[] getAscendingArray(int aLength) {
            if (aLength <= 0) {
                return CS.ZL_INTEGER;
            }
            if (aLength < ASCENDING_ARRAYS.length) {
                if (ASCENDING_ARRAYS[aLength] == null) {
                    Code.ASCENDING_ARRAYS[aLength] = new int[aLength];
                    for (int i = 0; i < aLength; ++i) {
                        Code.ASCENDING_ARRAYS[aLength][i] = i;
                    }
                }
                return ASCENDING_ARRAYS[aLength];
            }
            int[] rArray = new int[aLength];
            for (int i = 0; i < aLength; ++i) {
                rArray[i] = i;
            }
            return rArray;
        }

        public static String stringValidate(Object aString) {
            return Code.stringValidate(aString, "");
        }

        public static String stringValidate(Object aString, String aReplacement) {
            if (aString == null) {
                return aReplacement;
            }
            if (aString instanceof BiomeGenBase) {
                return ((BiomeGenBase)aString).biomeName;
            }
            String rString = aString.toString();
            return rString == null || rString.isEmpty() ? aReplacement : rString;
        }

        public static boolean stringValid(Object aString) {
            return aString != null && !aString.toString().isEmpty();
        }

        public static boolean stringInvalid(Object aString) {
            return aString == null || aString.toString().isEmpty();
        }

        public static byte side(ForgeDirection aDirection) {
            return (byte)(aDirection == null ? 6 : aDirection.ordinal());
        }

        public static byte side(int aSide) {
            return aSide > 5 || aSide < 0 ? (byte)6 : (byte)aSide;
        }

        public static <E> boolean exists(int aIndex, E[] aArray) {
            return aIndex >= 0 && aIndex < aArray.length && aArray[aIndex] != null;
        }

        public static long scale(long aValue, long aMax, long aScale, boolean aInvert) {
            long rScale = aValue <= 0L ? 0L : (aValue >= aMax ? aScale : (aScale <= 2L ? 1L : 1L + aValue * (aScale - 1L) / aMax));
            return aInvert ? aScale - rScale : rScale;
        }

        public static long scale(long aValue, long aMin, long aMax, long aScale, boolean aInvert) {
            return Code.scale(aValue - aMin, aMax - aMin, aScale, aInvert);
        }

        public static long bind(long aMin, long aMax, long aBoundValue) {
            return aMin > aMax ? Math.max(aMax, Math.min(aMin, aBoundValue)) : Math.max(aMin, Math.min(aMax, aBoundValue));
        }

        public static long bind_(long aMin, long aMax, long aBoundValue) {
            return Math.max(aMin, Math.min(aMax, aBoundValue));
        }

        public static float bindF(float aBoundValue) {
            return Math.max(0.0f, Math.min(1.0f, aBoundValue));
        }

        public static double bindD(double aBoundValue) {
            return Math.max(0.0, Math.min(1.0, aBoundValue));
        }

        public static byte bind1(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(1L, aBoundValue));
        }

        public static byte bind2(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(3L, aBoundValue));
        }

        public static byte bind3(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(7L, aBoundValue));
        }

        public static byte bind4(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(15L, aBoundValue));
        }

        public static byte bind5(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(31L, aBoundValue));
        }

        public static byte bind6(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(63L, aBoundValue));
        }

        public static byte bind7(long aBoundValue) {
            return (byte)Math.max(0L, Math.min(127L, aBoundValue));
        }

        public static short bind8(long aBoundValue) {
            return (short)Math.max(0L, Math.min(255L, aBoundValue));
        }

        public static short bind15(long aBoundValue) {
            return (short)Math.max(0L, Math.min(32767L, aBoundValue));
        }

        public static int bind16(long aBoundValue) {
            return (int)Math.max(0L, Math.min(65535L, aBoundValue));
        }

        public static int bind24(long aBoundValue) {
            return (int)Math.max(0L, Math.min(0xFFFFFFL, aBoundValue));
        }

        public static int bind31(long aBoundValue) {
            return (int)Math.max(0L, Math.min(Integer.MAX_VALUE, aBoundValue));
        }

        public static int bindInt(long aBoundValue) {
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, aBoundValue));
        }

        public static short bindShort(long aBoundValue) {
            return (short)Math.max(-32768L, Math.min(32767L, aBoundValue));
        }

        public static byte bindByte(long aBoundValue) {
            return (byte)Math.max(-128L, Math.min(127L, aBoundValue));
        }

        public static byte bindStack(long aBoundValue) {
            return (byte)Math.max(1L, Math.min(64L, aBoundValue));
        }

        public static short[] bindRGBa(short[] aColors) {
            if (aColors == null) {
                return new short[]{255, 255, 255, 255};
            }
            for (int i = 0; i < aColors.length; ++i) {
                aColors[i] = Code.bind8(aColors[i]);
            }
            return aColors;
        }

        public static int mixRGBInt(int aRGB1, int aRGB2) {
            return Code.getRGBInt(new short[]{(short)(Code.getR(aRGB1) + Code.getR(aRGB2) >> 1), (short)(Code.getG(aRGB1) + Code.getG(aRGB2) >> 1), (short)(Code.getB(aRGB1) + Code.getB(aRGB2) >> 1)});
        }

        public static int getRGBInt(short[] aColors) {
            return aColors == null ? 0xFFFFFF : Code.bind8(aColors[0]) << 16 | Code.bind8(aColors[1]) << 8 | Code.bind8(aColors[2]);
        }

        public static int getRGBaInt(short[] aColors) {
            return aColors == null ? 0xFFFFFF : Code.bind8(aColors[0]) << 16 | Code.bind8(aColors[1]) << 8 | Code.bind8(aColors[2]) | Code.bind8(aColors[3]) << 24;
        }

        public static int getRGBInt(long aR, long aG, long aB) {
            return Code.bind8(aR) << 16 | Code.bind8(aG) << 8 | Code.bind8(aB);
        }

        public static int getRGBaInt(long aR, long aG, long aB, long aA) {
            return Code.bind8(aR) << 16 | Code.bind8(aG) << 8 | Code.bind8(aB) | Code.bind8(aA) << 24;
        }

        public static short[] getRGBaArray(int aColors) {
            return new short[]{(short)(aColors >>> 16 & 0xFF), (short)(aColors >>> 8 & 0xFF), (short)(aColors & 0xFF), (short)(aColors >>> 24 & 0xFF)};
        }

        public static short getR(int aColors) {
            return (short)(aColors >>> 16 & 0xFF);
        }

        public static short getG(int aColors) {
            return (short)(aColors >>> 8 & 0xFF);
        }

        public static short getB(int aColors) {
            return (short)(aColors & 0xFF);
        }

        public static short getA(int aColors) {
            return (short)(aColors >>> 24 & 0xFF);
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(ItemStack aStack) {
            if (ST.invalid(aStack)) {
                return CS.UNCOLOURED;
            }
            IIcon tIcon = null;
            try {
                tIcon = aStack.getIconIndex();
            }
            catch (Throwable e) {
                return CS.UNCOLOURED;
            }
            if (tIcon == null) {
                return CS.UNCOLOURED;
            }
            String tResourceLocation = tIcon.getIconName();
            if (Code.stringInvalid(tResourceLocation)) {
                return CS.UNCOLOURED;
            }
            short[] rColor = Code.color(tResourceLocation);
            if (rColor == null) {
                return CS.UNCOLOURED;
            }
            short[] rModulation = Code.getRGBaArray(aStack.getItem().getColorFromItemStack(aStack, 0));
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                rColor[i] = (short)(rColor[i] * rModulation[i] / 255);
            }
            return rColor;
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(String aResourceLocation) {
            ResourceLocation aux = null;
            if (aResourceLocation.contains(":")) {
                String[] modid_itemid = aResourceLocation.split(":");
                aux = new ResourceLocation(modid_itemid[0], "textures/items/" + modid_itemid[1] + ".png");
            } else {
                aux = new ResourceLocation("minecraft", "textures/items/" + aResourceLocation + ".png");
            }
            BufferedImage tIcon = null;
            try {
                tIcon = ImageIO.read(Minecraft.getMinecraft().getResourceManager().getResource(aux).getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return tIcon == null ? null : Code.color(tIcon);
        }

        @SideOnly(value=Side.CLIENT)
        public static short[] color(BufferedImage icon) {
            long tR = 0L;
            long tG = 0L;
            long tB = 0L;
            long tPixels = 0L;
            for (int tWidth = 0; tWidth < icon.getWidth(); ++tWidth) {
                for (int tHeight = 0; tHeight < icon.getHeight(); ++tHeight) {
                    int tPixel = icon.getRGB(tWidth, tHeight);
                    if ((tPixel >>> 24 & 0xFF) <= 128) continue;
                    tR += (long)(tPixel >>> 16 & 0xFF);
                    tG += (long)(tPixel >>> 8 & 0xFF);
                    tB += (long)(tPixel & 0xFF);
                    ++tPixels;
                }
            }
            return new short[]{(short)(tR / tPixels), (short)(tG / tPixels), (short)(tB / tPixels)};
        }

        public static String capitalise(String aString) {
            return aString == null ? "" : (aString.length() <= 1 ? aString.toUpperCase() : aString.substring(0, 1).toUpperCase() + aString.substring(1));
        }

        public static String capitaliseWords(String aString) {
            StringBuilder rString = new StringBuilder();
            for (String tString : aString.split(" ")) {
                if (tString.isEmpty()) continue;
                rString.append(Code.capitalise(tString)).append(" ");
            }
            return rString.toString().trim();
        }

        public static byte opposite(int aSide) {
            return aSide < CS.OPOS.length && aSide >= 0 ? CS.OPOS[aSide] : (byte)6;
        }

        public static String displayUnits(long aAmount) {
            if (aAmount < 0L) {
                return "?.???";
            }
            long tDigits = aAmount % 648648000L * 1000L / 648648000L;
            return aAmount / 648648000L + "." + (tDigits < 1L ? "000" : (tDigits < 10L ? "00" + tDigits : (tDigits < 100L ? "0" + tDigits : Long.valueOf(tDigits))));
        }

        public static long units(long aAmount, long aOriginalUnit, long aTargetUnit, boolean aRoundUp) {
            if (aTargetUnit == 0L) {
                return 0L;
            }
            if (aOriginalUnit == aTargetUnit || aOriginalUnit == 0L) {
                return aAmount;
            }
            if (aOriginalUnit % aTargetUnit == 0L) {
                aOriginalUnit /= aTargetUnit;
                aTargetUnit = 1L;
            } else if (aTargetUnit % aOriginalUnit == 0L) {
                aTargetUnit /= aOriginalUnit;
                aOriginalUnit = 1L;
            }
            return Math.max(0L, aAmount * aTargetUnit / aOriginalUnit + (long)(aRoundUp && aAmount * aTargetUnit % aOriginalUnit > 0L ? 1 : 0));
        }

        public static long units_(long aAmount, long aOriginalUnit, long aTargetUnit, boolean aRoundUp) {
            if (aTargetUnit == 0L) {
                return 0L;
            }
            if (aOriginalUnit == aTargetUnit || aOriginalUnit == 0L) {
                return aAmount;
            }
            if (aOriginalUnit % aTargetUnit == 0L) {
                aOriginalUnit /= aTargetUnit;
                aTargetUnit = 1L;
            } else if (aTargetUnit % aOriginalUnit == 0L) {
                aTargetUnit /= aOriginalUnit;
                aOriginalUnit = 1L;
            } else {
                if (aOriginalUnit % 648L == 0L && aTargetUnit % 648L == 0L) {
                    aOriginalUnit /= 648L;
                    aTargetUnit /= 648L;
                }
                if (aOriginalUnit % 1000L == 0L && aTargetUnit % 1000L == 0L) {
                    aOriginalUnit /= 1000L;
                    aTargetUnit /= 1000L;
                }
            }
            return Math.max(0L, aAmount * aTargetUnit / aOriginalUnit + (long)(aRoundUp && aAmount * aTargetUnit % aOriginalUnit > 0L ? 1 : 0));
        }

        public static long divup(long aNumber, long aDivider) {
            return aNumber / aDivider + (long)(aNumber % aDivider == 0L ? 0 : 1);
        }

        public static long sum(byte ... aArray) {
            long rAmount = 0L;
            for (byte tNumber : aArray) {
                rAmount += (long)tNumber;
            }
            return rAmount;
        }

        public static long sum(short ... aArray) {
            long rAmount = 0L;
            for (short tNumber : aArray) {
                rAmount += (long)tNumber;
            }
            return rAmount;
        }

        public static long sum(int ... aArray) {
            long rAmount = 0L;
            for (int tNumber : aArray) {
                rAmount += (long)tNumber;
            }
            return rAmount;
        }

        public static long sum(long ... aArray) {
            long rAmount = 0L;
            for (long tNumber : aArray) {
                rAmount += tNumber;
            }
            return rAmount;
        }

        public static boolean abs_greater(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) > Math.abs(aAmount2);
        }

        public static boolean abs_smaller(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) < Math.abs(aAmount2);
        }

        public static boolean abs_greater_equal(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) >= Math.abs(aAmount2);
        }

        public static boolean abs_smaller_equal(long aAmount1, long aAmount2) {
            return Math.abs(aAmount1) <= Math.abs(aAmount2);
        }

        public static boolean inside(long aMin, long aMax, long aNumber) {
            return aMin < aMax ? aMin <= aNumber && aNumber <= aMax : aMax <= aNumber && aNumber <= aMin;
        }

        public static boolean inside_(double aMin, double aMax, double aNumber) {
            return aMin < aMax ? aMin <= aNumber && aNumber <= aMax : aMax <= aNumber && aNumber <= aMin;
        }

        public static float[] getFacingCoordsClicked(byte aSide, float aHitX, float aHitY, float aHitZ) {
            switch (aSide) {
                case 0: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitZ))};
                }
                case 1: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitX)), Math.min(0.99f, Math.max(0.0f, aHitZ))};
                }
                case 2: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aHitX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 3: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 4: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, aHitZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
                case 5: {
                    return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aHitZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aHitY))};
                }
            }
            return new float[]{0.5f, 0.5f};
        }

        public static byte getSideForPlayerPlacing(Entity aPlayer) {
            if (aPlayer.rotationPitch >= 65.0f) {
                return 1;
            }
            if (aPlayer.rotationPitch <= -65.0f) {
                return 0;
            }
            return Code.getHorizontalForPlayerPlacing(aPlayer);
        }

        public static byte getHorizontalForPlayerPlacing(Entity aPlayer) {
            return CS.COMPASS_DIRECTIONS[Code.roundDown((double)(4.0f * aPlayer.rotationYaw / 360.0f) + 0.5) & 3];
        }

        public static byte getSideForPlayerPlacing(Entity aPlayer, byte aDefaultFacing, boolean[] aAllowedFacings) {
            if (aPlayer.rotationPitch >= 65.0f && aAllowedFacings[1]) {
                return 1;
            }
            if (aPlayer.rotationPitch <= -65.0f && aAllowedFacings[0]) {
                return 0;
            }
            byte rFacing = Code.getHorizontalForPlayerPlacing(aPlayer);
            if (aAllowedFacings[rFacing]) {
                return rFacing;
            }
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!aAllowedFacings[tSide]) continue;
                return tSide;
            }
            return aDefaultFacing;
        }

        public static byte getOppositeSideForPlayerPlacing(Entity aPlayer, byte aDefaultFacing, boolean[] aAllowedFacings) {
            if (aPlayer.rotationPitch >= 65.0f && aAllowedFacings[0]) {
                return 0;
            }
            if (aPlayer.rotationPitch <= -65.0f && aAllowedFacings[1]) {
                return 1;
            }
            byte rFacing = CS.OPOS[Code.getHorizontalForPlayerPlacing(aPlayer)];
            if (aAllowedFacings[rFacing]) {
                return rFacing;
            }
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!aAllowedFacings[tSide]) continue;
                return tSide;
            }
            return aDefaultFacing;
        }

        public static byte getSideWrenching(byte aSide, float aHitX, float aHitY, float aHitZ) {
            switch (aSide) {
                case 0: 
                case 1: {
                    if ((double)aHitX < 0.25) {
                        return (byte)((double)aHitZ < 0.25 || (double)aHitZ > 0.75 ? CS.OPOS[aSide] : 4);
                    }
                    if ((double)aHitX > 0.75) {
                        return (byte)((double)aHitZ < 0.25 || (double)aHitZ > 0.75 ? CS.OPOS[aSide] : 5);
                    }
                    if ((double)aHitZ < 0.25) {
                        return 2;
                    }
                    if ((double)aHitZ > 0.75) {
                        return 3;
                    }
                    return aSide;
                }
                case 2: 
                case 3: {
                    if ((double)aHitX < 0.25) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPOS[aSide] : 4);
                    }
                    if ((double)aHitX > 0.75) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPOS[aSide] : 5);
                    }
                    if ((double)aHitY < 0.25) {
                        return 0;
                    }
                    if ((double)aHitY > 0.75) {
                        return 1;
                    }
                    return aSide;
                }
                case 4: 
                case 5: {
                    if ((double)aHitZ < 0.25) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPOS[aSide] : 2);
                    }
                    if ((double)aHitZ > 0.75) {
                        return (byte)((double)aHitY < 0.25 || (double)aHitY > 0.75 ? CS.OPOS[aSide] : 3);
                    }
                    if ((double)aHitY < 0.25) {
                        return 0;
                    }
                    if ((double)aHitY > 0.75) {
                        return 1;
                    }
                    return aSide;
                }
            }
            return 6;
        }
    }

    public static class Books {
        public static final Map<String, ItemStack> BOOK_MAP = new HashMap<String, ItemStack>();
        public static final List<String> BOOK_LIST = new ArrayListNoNulls<String>();
        public static final List<String> MATERIAL_DICTIONARIES = new ArrayListNoNulls<String>();

        public static void display(EntityPlayer aPlayer, ItemStack aStack) {
            String aMapping = NBT.getBookMapping(aStack);
            if (Code.stringValid(aMapping)) {
                Books.display(aPlayer, aMapping);
            } else {
                Books.display(aPlayer, false, aStack);
            }
        }

        public static void display(EntityPlayer aPlayer, String aMapping) {
            aPlayer.displayGUIBook(Books.getWrittenBook(aMapping, true, ST.make(Items.written_book, 1L, 0L)));
        }

        public static void display(EntityPlayer aPlayer, boolean aWritable, ItemStack aStack) {
            if (ST.invalid(aStack)) {
                return;
            }
            Books.display(aPlayer, aWritable, aStack.getTagCompound());
        }

        public static void display(EntityPlayer aPlayer, boolean aWritable, NBTTagCompound aNBT) {
            if (aNBT == null || Code.stringInvalid(NBT.getBookTitle(aNBT))) {
                return;
            }
            aPlayer.displayGUIBook(ST.make(aWritable ? Items.writable_book : Items.written_book, 1L, 0L, aNBT));
        }

        @Deprecated
        public static ItemStack getWrittenBook(String aMapping) {
            return Books.getWrittenBook(aMapping, false, null);
        }

        @Deprecated
        public static ItemStack getWrittenBook(String aMapping, ItemStack aStackToPutNBT) {
            return Books.getWrittenBook(aMapping, false, aStackToPutNBT);
        }

        public static ItemStack getWrittenBook(String aMapping, boolean aForceRecreation) {
            return Books.getWrittenBook(aMapping, aForceRecreation, null);
        }

        public static ItemStack getWrittenBook(String aMapping, boolean aForceRecreation, ItemStack aStackToPutNBT) {
            ItemStack tStack;
            if (Code.stringInvalid(aMapping)) {
                return null;
            }
            if (aForceRecreation && aMapping.startsWith("Material_Dictionary_")) {
                Books.createMaterialDictionary(OreDictMaterial.MATERIAL_MAP.get(aMapping.replaceFirst("Material_Dictionary_", "")), CS.NI, CS.NI);
            }
            if ((tStack = BOOK_MAP.get(aMapping)) == null) {
                return aStackToPutNBT == null ? ST.make(Items.written_book, 1L, 0L) : aStackToPutNBT;
            }
            if (aStackToPutNBT == null) {
                aStackToPutNBT = ST.copy(tStack);
            }
            return NBT.set(aStackToPutNBT, (NBTTagCompound)tStack.getTagCompound().copy());
        }

        public static ItemStack getBookWithTitle(String aMapping) {
            return Books.getBookWithTitle(aMapping, null);
        }

        public static ItemStack getBookWithTitle(String aMapping, ItemStack aStackToPutNBT) {
            ItemStack tStack = BOOK_MAP.get(aMapping);
            if (tStack == null) {
                return aStackToPutNBT == null ? ST.make(Items.written_book, 1L, 0L) : aStackToPutNBT;
            }
            if (aStackToPutNBT == null) {
                aStackToPutNBT = ST.copy(tStack);
            }
            return NBT.set(aStackToPutNBT, NBT.make("title", (Object)NBT.getBookTitle(tStack), "author", NBT.getBookAuthor(tStack), "book", aMapping));
        }

        public static ItemStack createWrittenBook(String aMapping, String aTitle, String aAuthor, ItemStack aDefaultBook, String ... aPages) {
            for (int i = 0; i < aPages.length; ++i) {
                aPages[i] = LanguageHandler.langfile("written.book." + aMapping + ".page." + i, aPages[i]);
            }
            return Books.createWrittenBook(aMapping, aTitle, aAuthor, aDefaultBook, true, aPages);
        }

        public static ItemStack createWrittenBook(String aMapping, String aTitle, String aAuthor, ItemStack aDefaultBook, boolean aLogging, String ... aPages) {
            if (Code.stringInvalid(aMapping)) {
                return null;
            }
            ItemStack rStack = BOOK_MAP.get(aMapping);
            if (rStack == null) {
                ItemStack itemStack = rStack = aDefaultBook == null ? ST.make(Items.written_book, 1L, 0L) : ST.amount(1L, aDefaultBook);
            }
            if (Code.stringInvalid(aTitle) || Code.stringInvalid(aAuthor) || aPages.length <= 0) {
                return null;
            }
            NBTTagCompound rNBT = NBT.make();
            rNBT.setString("title", aTitle);
            rNBT.setString("author", aAuthor);
            NBTTagList tNBTList = new NBTTagList();
            for (int i = 0; i < aPages.length; i = (int)((short)(i + 1))) {
                if (aPages[i].length() < 256) {
                    tNBTList.appendTag((NBTBase)new NBTTagString(aPages[i].replaceAll("\u00b6", "\n")));
                    continue;
                }
                if (!aLogging) continue;
                CS.ERR.println("WARNING: String for Page of written Book too long! ->\n" + aPages[i]);
            }
            rNBT.setTag("pages", (NBTBase)tNBTList);
            NBT.set(rStack, rNBT);
            BOOK_MAP.put(aMapping, ST.copy(rStack));
            if (!BOOK_LIST.contains(aMapping)) {
                BOOK_LIST.add(aMapping);
            }
            return ST.copy(rStack);
        }

        public static ItemStack addMaterialDictionary(OreDictMaterial aMat) {
            boolean temp = false;
            int tCounter = 0;
            int tPages = 6 + aMat.mAlloyCreationRecipes.size();
            if (aMat.mComponents == null && !aMat.contains(TD.Atomic.ELEMENT)) {
                --tPages;
            }
            if (!aMat.mByProducts.isEmpty()) {
                ++tPages;
            }
            if (aMat.mToolTypes > 0) {
                ++tPages;
            }
            if (!aMat.mEnchantmentTools.isEmpty()) {
                ++tPages;
            }
            if (!aMat.mEnchantmentWeapons.isEmpty()) {
                ++tPages;
            }
            if (!aMat.mEnchantmentAmmo.isEmpty()) {
                ++tPages;
            }
            if (!aMat.mEnchantmentRanged.isEmpty()) {
                ++tPages;
            }
            if (!aMat.mEnchantmentFishing.isEmpty()) {
                ++tPages;
            }
            if (!aMat.mEnchantmentArmors.isEmpty()) {
                ++tPages;
            }
            if (aMat.mDescription != null) {
                for (int i = 0; i < aMat.mDescription.length; ++i) {
                    if (!Code.stringValid(aMat.mDescription[i])) continue;
                    ++tPages;
                }
            }
            for (TagData tTag : TD.Properties.ALL_RELEVANTS) {
                if (!aMat.contains(tTag)) continue;
                ++tPages;
                break;
            }
            for (TagData tTag : TD.Processing.ALL_MACHINES) {
                if (!aMat.contains(tTag)) continue;
                ++tPages;
                break;
            }
            for (TagData tTag : TD.Processing.ALL_ORES) {
                if (!aMat.contains(tTag)) continue;
                ++tPages;
                break;
            }
            tCounter = 0;
            block4: for (OreDictMaterial tMat : OreDictMaterial.MATERIAL_MAP.values()) {
                if (tMat.mComponents == null || !tMat.contains(TD.Compounds.DECOMPOSABLE)) continue;
                for (OreDictMaterialStack tMt2 : tMat.mComponents.getUndividedComponents()) {
                    if (tMt2.mMaterial != aMat) continue;
                    if (temp = tCounter++ % 6 != 5) continue block4;
                    ++tPages;
                    continue block4;
                }
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : OreDictMaterial.MATERIAL_MAP.values()) {
                if (!tMat.mByProducts.contains(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedSmelting) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetSmelting.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedSolidifying) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetSolidifying.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedBurning) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetBurning.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedPulver) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetPulver.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedBending) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetBending.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedCompressing) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetCompressing.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedCrushing) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetCrushing.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedCutting) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetCutting.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedForging) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetForging.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedSmashing) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetSmashing.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            tCounter = 0;
            for (OreDictMaterial tMat : aMat.mTargetedWorking) {
                if (tMat.mTargetRegistration != tMat || tMat == aMat || !tMat.mTargetWorking.has(aMat) || (temp = tCounter++ % 6 != 5)) continue;
                ++tPages;
            }
            if (temp) {
                ++tPages;
                temp = false;
            }
            for (OreDictMaterial tMat : aMat.mAlloyComponentReferences) {
                block19: for (IOreDictConfigurationComponent tConfig : tMat.mAlloyCreationRecipes) {
                    for (OreDictMaterialStack tMatStack : tConfig.getUndividedComponents()) {
                        if (tMatStack.mMaterial != aMat) continue;
                        ++tPages;
                        continue block19;
                    }
                }
            }
            MATERIAL_DICTIONARIES.add("Material_Dictionary_" + aMat.mNameInternal);
            Books.createWrittenBook("Material_Dictionary_" + aMat.mNameInternal, aMat.getLocal(), "Material Dictionary Foundation", ST.make(CS.ItemsGT.BOOKS, 1L, tPages <= 50 ? 32002L : 32003L), false, "If you can read this in a legitimate Material Dictionary, even if it is old, then this is a Bug, please report this to me!\n\nGregorius\nTechneticies\n\n2021");
            aMat.mDictionaryBook = ST.book("Material_Dictionary_" + aMat.mNameInternal);
            return ST.copy(aMat.mDictionaryBook);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean createMaterialDictionary(OreDictMaterial aMat, ItemStack aDefaultBook, ItemStack aDefaultLargeBook) {
            if (aMat == null) {
                return false;
            }
            String tPage = "";
            ArrayListNoNulls<String> tBook = new ArrayListNoNulls<String>();
            boolean temp = false;
            int tCounter = 0;
            tBook.add("===================\n" + aMat.getLocal() + "\n===================\nID: " + (aMat.mID < 0 ? "NONE" : Short.valueOf(aMat.mID)) + "\nMelting: " + aMat.mMeltingPoint + " K\nBoiling: " + aMat.mBoilingPoint + " K\nPlasma: " + aMat.mPlasmaPoint + " K\n===================\nDensity:\n" + (aMat.mGramPerCubicCentimeter == 0.0 ? "???" : Double.valueOf(aMat.mGramPerCubicCentimeter)) + " g/cm3\n" + aMat.getWeight(648648000L) + " kg/unit\n===================\n");
            if (aMat.mComponents == null) {
                if (aMat.contains(TD.Atomic.ELEMENT)) {
                    temp = true;
                    tPage = "Atomic Structure:\nProtons: " + aMat.mProtons + "\nElectrons: " + aMat.mElectrons + "\nNeutrons: " + aMat.mNeutrons + "\nMass: " + aMat.mMass + "\n===================\n";
                    for (TagData tagData : TD.Atomic.ALL) {
                        if (tagData == TD.Atomic.ELEMENT || tagData == TD.Atomic.NONMETAL || !aMat.contains(tagData)) continue;
                        tPage = tPage + tagData.getLocalisedNameLong() + "\n";
                    }
                }
            } else {
                temp = true;
                tPage = "Components per " + aMat.mComponents.getCommonDivider() + "\n===================\n";
                for (OreDictMaterialStack oreDictMaterialStack : aMat.mComponents.getUndividedComponents()) {
                    tPage = tPage + oreDictMaterialStack.mAmount / 648648000L + " " + oreDictMaterialStack.mMaterial.getLocal() + "\n";
                }
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            if (aMat.mToolTypes > 0) {
                tPage = "Tool Properties\n===================\n";
                tPage = tPage + "Durability:\n" + aMat.mToolDurability;
                tPage = tPage + "\nQuality:\n" + aMat.mToolQuality;
                tPage = tPage + "\nSpeed:\n" + aMat.mToolSpeed;
                tPage = tPage + "\nHandle:\n" + aMat.mHandleMaterial.getLocal() + "\n";
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentTools.isEmpty()) {
                tPage = "Tool Enchantments\n===================\n";
                for (ObjectStack<Object> objectStack : aMat.mEnchantmentTools) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentWeapons.isEmpty()) {
                tPage = "Weapon Enchantments\n===================\n";
                for (ObjectStack<Object> objectStack : aMat.mEnchantmentWeapons) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentAmmo.isEmpty()) {
                tPage = "Ammo Enchantments\n===================\n";
                for (ObjectStack<Object> objectStack : aMat.mEnchantmentAmmo) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentRanged.isEmpty()) {
                tPage = "Ranged Enchantments\n===================\n";
                for (ObjectStack<Object> objectStack : aMat.mEnchantmentRanged) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentFishing.isEmpty()) {
                tPage = "Fishing Enchantments\n===================\n";
                for (ObjectStack objectStack : aMat.mEnchantmentFishing) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            if (!aMat.mEnchantmentArmors.isEmpty()) {
                tPage = "Armor Enchantments\n===================\n";
                for (ObjectStack objectStack : aMat.mEnchantmentArmors) {
                    tPage = tPage + ((Enchantment)objectStack.mObject).getTranslatedName((int)objectStack.mAmount) + "\n";
                }
                tBook.add(tPage + "===================\n");
            }
            tPage = "Properties\n===================\n";
            for (TagData tagData : TD.Properties.ALL_RELEVANTS) {
                if (!aMat.contains(tagData)) continue;
                temp = true;
                tPage = tPage + tagData.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Machine Processing\n===================\n";
            for (TagData tagData : TD.Processing.ALL_MACHINES) {
                if (!aMat.contains(tagData)) continue;
                temp = true;
                tPage = tPage + tagData.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Materials which can be decomposed to this\n===================\n";
            tCounter = 0;
            block10: for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (oreDictMaterial.mComponents == null || !oreDictMaterial.contains(TD.Compounds.DECOMPOSABLE)) continue;
                for (OreDictMaterialStack tMt2 : oreDictMaterial.mComponents.getUndividedComponents()) {
                    if (tMt2.mMaterial != aMat) continue;
                    temp = tCounter++ % 6 != 5;
                    tPage = tPage + oreDictMaterial.getLocal() + "\n";
                    if (temp) continue block10;
                    tBook.add(tPage);
                    tPage = "Materials which can be decomposed to this\n===================\n";
                    continue block10;
                }
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ore Processing\n===================\n";
            for (TagData tagData : TD.Processing.ALL_ORES) {
                if (!aMat.contains(tagData)) continue;
                temp = true;
                tPage = tPage + tagData.getLocalisedNameLong() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ore Byproducts\n===================\n";
            for (OreDictMaterial oreDictMaterial : aMat.mByProducts) {
                temp = true;
                tPage = tPage + oreDictMaterial.getLocal() + "\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Ores with this as Byproduct\n===================\n";
            tCounter = 0;
            for (OreDictMaterial oreDictMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
                if (!oreDictMaterial.mByProducts.contains(aMat)) continue;
                temp = tCounter++ % 6 != 5;
                tPage = tPage + oreDictMaterial.getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Ores with this as Byproduct\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Smelting:\n" + aMat.mTargetSmelting.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetSmelting.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetSmelting.mAmount <= 0L ? "nothing" : (aMat.mTargetSmelting.mMaterial == aMat ? "itself" : aMat.mTargetSmelting.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Solidifying:\n" + aMat.mTargetSolidifying.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetSolidifying.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetSolidifying.mAmount <= 0L ? "nothing" : (aMat.mTargetSolidifying.mMaterial == aMat ? "itself" : aMat.mTargetSolidifying.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Burning:\n" + aMat.mTargetBurning.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetBurning.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetBurning.mAmount <= 0L ? "nothing" : (aMat.mTargetBurning.mMaterial == aMat ? "itself" : aMat.mTargetBurning.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Pulverising:\n" + aMat.mTargetPulver.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetPulver.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetPulver.mAmount <= 0L ? "nothing" : (aMat.mTargetPulver.mMaterial == aMat ? "itself" : aMat.mTargetPulver.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Crushing:\n" + aMat.mTargetCrushing.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetCrushing.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetCrushing.mAmount <= 0L ? "nothing" : (aMat.mTargetCrushing.mMaterial == aMat ? "itself" : aMat.mTargetCrushing.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Bending:\n" + aMat.mTargetBending.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetBending.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetBending.mAmount <= 0L ? "nothing" : (aMat.mTargetBending.mMaterial == aMat ? "itself" : aMat.mTargetBending.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Compressing:\n" + aMat.mTargetCompressing.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetCompressing.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetCompressing.mAmount <= 0L ? "nothing" : (aMat.mTargetCompressing.mMaterial == aMat ? "itself" : aMat.mTargetCompressing.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Cutting:\n" + aMat.mTargetCutting.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetCutting.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetCutting.mAmount <= 0L ? "nothing" : (aMat.mTargetCutting.mMaterial == aMat ? "itself" : aMat.mTargetCutting.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Forging:\n" + aMat.mTargetForging.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetForging.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetForging.mAmount <= 0L ? "nothing" : (aMat.mTargetForging.mMaterial == aMat ? "itself" : aMat.mTargetForging.mMaterial.getLocal())) + "\n";
            tPage = tPage + "Smashing:\n" + aMat.mTargetSmashing.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetSmashing.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetSmashing.mAmount <= 0L ? "nothing" : (aMat.mTargetSmashing.mMaterial == aMat ? "itself" : aMat.mTargetSmashing.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Processing Data\n===================\n";
            tPage = tPage + "Working:\n" + aMat.mTargetWorking.mAmount / 648648000L + "." + (int)((double)(aMat.mTargetWorking.mAmount % 648648000L) / 6.48648E8 * 1000.0) + " " + (aMat.mTargetWorking.mAmount <= 0L ? "nothing" : (aMat.mTargetWorking.mMaterial == aMat ? "itself" : aMat.mTargetWorking.mMaterial.getLocal())) + "\n";
            tBook.add(tPage);
            tPage = "Thaumaturgic Data\n===================\nAspects:\n";
            if (aMat.mAspects.isEmpty()) {
                tPage = tPage + "None\n";
            } else {
                for (TC.TC_AspectStack tC_AspectStack : aMat.mAspects) {
                    tPage = tPage + tC_AspectStack.mAmount + "x " + tC_AspectStack.mAspect.mName + "\n";
                }
            }
            tPage = tPage + "===================\n";
            tBook.add(tPage);
            HashMap<OreDictMaterial, Long> tMap = new HashMap<OreDictMaterial, Long>();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedSmelting) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetSmelting.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetSmelting.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to smelt for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to smelt for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedSolidifying) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetSolidifying.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetSolidifying.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to smelt and solidify for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to smelt and solidify for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedBurning) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetBurning.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetBurning.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to burn for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to burn for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedPulver) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetPulver.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetPulver.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to pulverise for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to pulverise for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedBending) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetBending.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetBending.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to bend for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to bend for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedCompressing) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetCompressing.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCompressing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to compress for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to compress for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedCrushing) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetCrushing.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCrushing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to crush for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to crush for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedCutting) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetCutting.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetCutting.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to cut for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to cut for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedForging) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetForging.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetForging.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to forge for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to forge for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedSmashing) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetSmashing.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetSmashing.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to smash for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to smash for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            tMap = new HashMap();
            for (OreDictMaterial oreDictMaterial : aMat.mTargetedWorking) {
                if (oreDictMaterial.mTargetRegistration != oreDictMaterial || oreDictMaterial == aMat || !oreDictMaterial.mTargetWorking.has(aMat)) continue;
                tMap.put(oreDictMaterial, oreDictMaterial.mTargetWorking.mAmount);
            }
            tMap = Code.sortByValuesDescending(tMap);
            tPage = "Resources to use in other ways for getting " + aMat.getLocal() + "\n===================\n";
            tCounter = 0;
            for (Map.Entry entry : tMap.entrySet()) {
                temp = tCounter++ % 6 != 5;
                tPage = tPage + (Long)entry.getValue() / 648648000L + "." + (int)((double)((Long)entry.getValue() % 648648000L) / 6.48648E8 * 1000.0) + " from 1 " + ((OreDictMaterial)entry.getKey()).getLocal() + "\n";
                if (temp) continue;
                tBook.add(tPage);
                tPage = "Resources to use in other ways for getting " + aMat.getLocal() + "\n===================\n";
            }
            if (temp) {
                tBook.add(tPage);
                temp = false;
            }
            for (IOreDictConfigurationComponent iOreDictConfigurationComponent : aMat.mAlloyCreationRecipes) {
                tPage = "Alloy:\n" + aMat.getLocal() + "\n===================\nMelting: " + aMat.mMeltingPoint + " K\nBoiling: " + aMat.mBoilingPoint + " K\n===================\nComponents per " + iOreDictConfigurationComponent.getCommonDivider() + "\n";
                for (OreDictMaterialStack tMt2 : iOreDictConfigurationComponent.getUndividedComponents()) {
                    tPage = tPage + tMt2.mAmount / 648648000L + " " + tMt2.mMaterial.getLocal() + "\n";
                }
                tBook.add(tPage);
            }
            for (OreDictMaterial oreDictMaterial : aMat.mAlloyComponentReferences) {
                block41: for (IOreDictConfigurationComponent tConfig : oreDictMaterial.mAlloyCreationRecipes) {
                    for (OreDictMaterialStack tMatStack : tConfig.getUndividedComponents()) {
                        if (tMatStack.mMaterial != aMat) continue;
                        tPage = "Alloy:\n" + oreDictMaterial.getLocal() + "\n===================\nMelting: " + oreDictMaterial.mMeltingPoint + " K\nBoiling: " + oreDictMaterial.mBoilingPoint + " K\n===================\nComponents per " + tConfig.getCommonDivider() + "\n";
                        for (OreDictMaterialStack tMt2 : tConfig.getUndividedComponents()) {
                            tPage = tPage + tMt2.mAmount / 648648000L + " " + tMt2.mMaterial.getLocal() + "\n";
                        }
                        tBook.add(tPage);
                        continue block41;
                    }
                }
            }
            if (aMat.mDescription != null) {
                void var8_62;
                boolean bl = false;
                boolean bl2 = false;
                while (var8_62 < aMat.mDescription.length) {
                    if (Code.stringValid(aMat.mDescription[var8_62])) {
                        void var9_113;
                        tBook.add("Description Pg " + (int)(++var9_113) + "\n===================\n" + aMat.mDescription[var8_62]);
                    }
                    ++var8_62;
                }
            }
            return null != Books.createWrittenBook("Material_Dictionary_" + aMat.mNameInternal, aMat.getLocal(), "Material Dictionary Foundation", tBook.size() <= 50 ? (ST.valid(aDefaultBook) ? ST.amount(1L, aDefaultBook) : ST.make(CS.ItemsGT.BOOKS, 1L, 32002L)) : (ST.valid(aDefaultLargeBook) ? ST.amount(1L, aDefaultLargeBook) : ST.make(CS.ItemsGT.BOOKS, 1L, 32003L)), false, tBook.toArray(CS.ZL_STRING));
        }
    }

    @Deprecated
    public static class Fluids {
        @Deprecated
        public static final Map<ItemStackContainer, FluidContainerRegistry.FluidContainerData> sFilled2Data = FL.FULL_TO_DATA;
        @Deprecated
        public static final Map<ItemStackContainer, Map<String, FluidContainerRegistry.FluidContainerData>> sEmpty2Fluid2Data = FL.EMPTY_TO_FLUID_TO_DATA;

        @Deprecated
        public static int id(IFluidTank aTank) {
            return aTank == null ? -1 : Fluids.id_(aTank);
        }

        @Deprecated
        public static int id_(IFluidTank aTank) {
            return Fluids.id(aTank.getFluid());
        }

        @Deprecated
        public static int id(FluidStack aFluid) {
            return aFluid == null ? -1 : Fluids.id_(aFluid);
        }

        @Deprecated
        public static int id_(FluidStack aFluid) {
            return Fluids.id(aFluid.getFluid());
        }

        @Deprecated
        public static int id(Fluid aFluid) {
            return aFluid == null ? -1 : Fluids.id_(aFluid);
        }

        @Deprecated
        public static int id_(Fluid aFluid) {
            return FluidRegistry.getFluidID((Fluid)aFluid);
        }

        @Deprecated
        public static Fluid fluid(int aID) {
            return aID < 0 ? null : FluidRegistry.getFluid((int)aID);
        }

        @Deprecated
        public static Fluid fluid(String aFluidName) {
            return Code.stringInvalid(aFluidName) ? null : Fluids.fluid_(aFluidName);
        }

        @Deprecated
        public static Fluid fluid_(String aFluidName) {
            return FluidRegistry.getFluid((String)aFluidName);
        }

        @Deprecated
        public static boolean equal(FluidStack aFluid1, FluidStack aFluid2) {
            return Fluids.equal(aFluid1, aFluid2, false);
        }

        @Deprecated
        public static boolean equal(FluidStack aFluid1, FluidStack aFluid2, boolean aIgnoreNBT) {
            return aFluid1 != null && aFluid2 != null && aFluid1.getFluid() == aFluid2.getFluid() && (aIgnoreNBT || aFluid1.tag == null == (aFluid2.tag == null) && (aFluid1.tag == null || aFluid1.tag.equals((Object)aFluid2.tag)));
        }

        @Deprecated
        public static boolean is(IFluidTank aTank, String ... aNames) {
            return Fluids.is(aTank.getFluid(), aNames);
        }

        @Deprecated
        public static boolean is(FluidStack aFluid, String ... aNames) {
            return aFluid != null && Fluids.is(aFluid.getFluid(), aNames);
        }

        @Deprecated
        public static boolean is(Fluid aFluid, String ... aNames) {
            if (aFluid != null) {
                for (String aName : aNames) {
                    if (!aFluid.getName().equalsIgnoreCase(aName)) continue;
                    return true;
                }
            }
            return false;
        }

        @Deprecated
        public static ItemStack display(Fluid aFluid) {
            return aFluid == null ? null : Fluids.display(Fluids.make(aFluid, 0L), false, false);
        }

        @Deprecated
        public static ItemStack display(FluidStack aFluid, boolean aUseStackSize, boolean aLimitStackSize) {
            return Fluids.display(aFluid, aFluid == null ? 0L : (long)aFluid.amount, aUseStackSize, aLimitStackSize);
        }

        @Deprecated
        public static ItemStack display(FluidTankGT aTank, boolean aUseStackSize, boolean aLimitStackSize) {
            return Fluids.display(aTank.getFluid(), aTank.amount(), aUseStackSize, aLimitStackSize);
        }

        @Deprecated
        public static ItemStack display(FluidStack aFluid, long aAmount, boolean aUseStackSize, boolean aLimitStackSize) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return null;
            }
            ItemStack rStack = IL.Display_Fluid.getWithMeta(aUseStackSize ? (aLimitStackSize ? (long)Code.bind7(aAmount / 1000L) : aAmount / 1000L) : 1L, Fluids.id_(aFluid), new Object[0]);
            if (rStack == null) {
                return null;
            }
            NBTTagCompound tNBT = NBT.makeString("f", aFluid.getFluid().getName());
            if (aAmount != 0L) {
                NBT.setNumber(tNBT, "a", aAmount);
            }
            NBT.setNumber(tNBT, "h", Fluids.temperature(aFluid));
            NBT.setBoolean(tNBT, "s", Fluids.gas(aFluid));
            return NBT.set(rStack, tNBT);
        }

        @Deprecated
        public static boolean water(IFluidTank aFluid) {
            return aFluid != null && Fluids.water(aFluid.getFluid());
        }

        @Deprecated
        public static boolean water(FluidStack aFluid) {
            return aFluid != null && Fluids.water(aFluid.getFluid());
        }

        @Deprecated
        public static boolean water(Fluid aFluid) {
            return aFluid != null && (aFluid == FluidRegistry.WATER || FL.DistW.is(aFluid));
        }

        @Deprecated
        public static boolean distw(IFluidTank aFluid) {
            return aFluid != null && Fluids.distw(aFluid.getFluid());
        }

        @Deprecated
        public static boolean distw(FluidStack aFluid) {
            return aFluid != null && Fluids.distw(aFluid.getFluid());
        }

        @Deprecated
        public static boolean distw(Fluid aFluid) {
            return aFluid != null && FL.DistW.is(aFluid);
        }

        @Deprecated
        public static boolean lava(IFluidTank aFluid) {
            return aFluid != null && Fluids.lava(aFluid.getFluid());
        }

        @Deprecated
        public static boolean lava(FluidStack aFluid) {
            return aFluid != null && Fluids.lava(aFluid.getFluid());
        }

        @Deprecated
        public static boolean lava(Fluid aFluid) {
            return aFluid != null && aFluid == FluidRegistry.LAVA;
        }

        @Deprecated
        public static boolean steam(IFluidTank aFluid) {
            return aFluid != null && Fluids.steam(aFluid.getFluid());
        }

        @Deprecated
        public static boolean steam(FluidStack aFluid) {
            return aFluid != null && Fluids.steam(aFluid.getFluid());
        }

        @Deprecated
        public static boolean steam(Fluid aFluid) {
            return aFluid != null && FL.Steam.is(aFluid);
        }

        @Deprecated
        public static boolean milk(IFluidTank aFluid) {
            return aFluid != null && Fluids.milk(aFluid.getFluid());
        }

        @Deprecated
        public static boolean milk(FluidStack aFluid) {
            return aFluid != null && Fluids.milk(aFluid.getFluid());
        }

        @Deprecated
        public static boolean milk(Fluid aFluid) {
            return aFluid != null && (FL.Milk.is(aFluid) || FL.MilkGrC.is(aFluid));
        }

        @Deprecated
        public static boolean soym(IFluidTank aFluid) {
            return aFluid != null && Fluids.soym(aFluid.getFluid());
        }

        @Deprecated
        public static boolean soym(FluidStack aFluid) {
            return aFluid != null && Fluids.soym(aFluid.getFluid());
        }

        @Deprecated
        public static boolean soym(Fluid aFluid) {
            return aFluid != null && FL.MilkSoy.is(aFluid);
        }

        @Deprecated
        public static boolean anysteam(IFluidTank aFluid) {
            return aFluid != null && Fluids.steam(aFluid.getFluid());
        }

        @Deprecated
        public static boolean anysteam(FluidStack aFluid) {
            return aFluid != null && Fluids.steam(aFluid.getFluid());
        }

        @Deprecated
        public static boolean anysteam(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.STEAM.contains(aFluid.getName());
        }

        @Deprecated
        public static boolean powerconducting(IFluidTank aFluid) {
            return aFluid != null && Fluids.powerconducting(aFluid.getFluid());
        }

        @Deprecated
        public static boolean powerconducting(FluidStack aFluid) {
            return aFluid != null && Fluids.powerconducting(aFluid.getFluid());
        }

        @Deprecated
        public static boolean powerconducting(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.POWER_CONDUCTING.contains(aFluid.getName());
        }

        @Deprecated
        public static boolean simple(IFluidTank aFluid) {
            return aFluid != null && Fluids.simple(aFluid.getFluid());
        }

        @Deprecated
        public static boolean simple(FluidStack aFluid) {
            return aFluid != null && Fluids.simple(aFluid.getFluid());
        }

        @Deprecated
        public static boolean simple(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.SIMPLE.contains(aFluid.getName());
        }

        @Deprecated
        public static boolean acid(IFluidTank aFluid) {
            return aFluid != null && Fluids.acid(aFluid.getFluid());
        }

        @Deprecated
        public static boolean acid(FluidStack aFluid) {
            return aFluid != null && Fluids.acid(aFluid.getFluid());
        }

        @Deprecated
        public static boolean acid(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.ACID.contains(aFluid.getName());
        }

        @Deprecated
        public static boolean plasma(IFluidTank aFluid) {
            return aFluid != null && Fluids.plasma(aFluid.getFluid());
        }

        @Deprecated
        public static boolean plasma(FluidStack aFluid) {
            return aFluid != null && Fluids.plasma(aFluid.getFluid());
        }

        @Deprecated
        public static boolean plasma(Fluid aFluid) {
            return aFluid != null && CS.FluidsGT.PLASMA.contains(aFluid.getName());
        }

        @Deprecated
        public static boolean gas(IFluidTank aFluid, boolean aDefault) {
            return Fluids.gas(aFluid.getFluid(), aDefault);
        }

        @Deprecated
        public static boolean gas(IFluidTank aFluid) {
            return Fluids.gas(aFluid.getFluid(), false);
        }

        @Deprecated
        public static boolean gas(FluidStack aFluid, boolean aDefault) {
            return aFluid == null || aFluid.getFluid() == null ? aDefault : !CS.FluidsGT.LIQUID.contains(aFluid.getFluid().getName()) && (aFluid.getFluid().isGaseous(aFluid) || CS.FluidsGT.GAS.contains(aFluid.getFluid().getName()));
        }

        @Deprecated
        public static boolean gas(FluidStack aFluid) {
            return Fluids.gas(aFluid, false);
        }

        @Deprecated
        public static boolean gas(Fluid aFluid, boolean aDefault) {
            return aFluid == null ? aDefault : !CS.FluidsGT.LIQUID.contains(aFluid.getName()) && (aFluid.isGaseous() || CS.FluidsGT.GAS.contains(aFluid.getName()));
        }

        @Deprecated
        public static boolean gas(Fluid aFluid) {
            return Fluids.gas(aFluid, false);
        }

        @Deprecated
        public static boolean lighter(BlockFluidBase aFluid) {
            return aFluid != null && Fluids.lighter(aFluid.getFluid());
        }

        @Deprecated
        public static boolean lighter(IFluidTank aFluid) {
            return aFluid != null && Fluids.lighter(aFluid.getFluid());
        }

        @Deprecated
        public static boolean lighter(FluidStack aFluid) {
            return aFluid != null && aFluid.getFluid() != null && aFluid.getFluid().getDensity(aFluid) < 0;
        }

        @Deprecated
        public static boolean lighter(Fluid aFluid) {
            return aFluid != null && aFluid.getDensity(Fluids.make(aFluid, 1000L)) < 0;
        }

        @Deprecated
        public static int dir(BlockFluidBase aFluid) {
            return Fluids.lighter(aFluid) ? 1 : -1;
        }

        @Deprecated
        public static int dir(IFluidTank aFluid) {
            return Fluids.lighter(aFluid) ? 1 : -1;
        }

        @Deprecated
        public static int dir(FluidStack aFluid) {
            return Fluids.lighter(aFluid) ? 1 : -1;
        }

        @Deprecated
        public static int dir(Fluid aFluid) {
            return Fluids.lighter(aFluid) ? 1 : -1;
        }

        @Deprecated
        public static long temperature(IFluidTank aFluid) {
            return Fluids.temperature(aFluid.getFluid());
        }

        @Deprecated
        public static long temperature(IFluidTank aFluid, long aDefault) {
            return Fluids.temperature(aFluid.getFluid(), aDefault);
        }

        @Deprecated
        public static long temperature(Fluid aFluid) {
            return Fluids.temperature(aFluid, 293L);
        }

        @Deprecated
        public static long temperature(Fluid aFluid, long aDefault) {
            if (aFluid == null) {
                return aDefault;
            }
            if (aFluid.getName().equals("steam")) {
                return 373L;
            }
            return aFluid.getTemperature(Fluids.make(aFluid, 1L));
        }

        @Deprecated
        public static long temperature(FluidStack aFluid) {
            return Fluids.temperature(aFluid, 293L);
        }

        @Deprecated
        public static long temperature(FluidStack aFluid, long aDefault) {
            if (aFluid == null || aFluid.getFluid() == null) {
                return aDefault;
            }
            if (aFluid.getFluid().getName().equals("steam")) {
                return 373L;
            }
            return aFluid.getFluid().getTemperature(aFluid);
        }

        @Deprecated
        public static FluidStack water(long aAmount) {
            return Fluids.make(FluidRegistry.WATER, aAmount);
        }

        @Deprecated
        public static FluidStack distw(long aAmount) {
            return Fluids.make("ic2distilledwater", aAmount);
        }

        @Deprecated
        public static FluidStack lava(long aAmount) {
            return Fluids.make(FluidRegistry.LAVA, aAmount);
        }

        @Deprecated
        public static FluidStack steam(long aAmount) {
            return Fluids.make("steam", aAmount);
        }

        @Deprecated
        public static FluidStack milk(long aAmount) {
            return Fluids.make("milk", aAmount);
        }

        @Deprecated
        public static FluidStack soym(long aAmount) {
            return Fluids.make("soymilk", aAmount);
        }

        @Deprecated
        public static boolean distilledwater(FluidStack aFluid) {
            return Fluids.distw(aFluid);
        }

        @Deprecated
        public static boolean distilledwater(Fluid aFluid) {
            return Fluids.distw(aFluid);
        }

        @Deprecated
        public static FluidStack distilledwater(long aAmount) {
            return Fluids.distw(aAmount);
        }

        @Deprecated
        public static boolean soymilk(FluidStack aFluid) {
            return Fluids.soym(aFluid);
        }

        @Deprecated
        public static boolean soymilk(Fluid aFluid) {
            return Fluids.soym(aFluid);
        }

        @Deprecated
        public static FluidStack soymilk(long aAmount) {
            return Fluids.soym(aAmount);
        }

        @Deprecated
        public static boolean exists(String aFluidName) {
            return FluidRegistry.getFluid((String)aFluidName) != null;
        }

        @Deprecated
        public static FluidStack make(FL aFluid, long aAmount) {
            return aFluid.make(aAmount);
        }

        @Deprecated
        public static FluidStack make_(FL aFluid, long aAmount) {
            return aFluid.make_(aAmount);
        }

        @Deprecated
        public static FluidStack make(FL aFluid, long aAmount, FL aReplacementFluid) {
            return aFluid.make(aAmount, aReplacementFluid);
        }

        @Deprecated
        public static FluidStack make_(FL aFluid, long aAmount, FL aReplacementFluid) {
            return aFluid.make_(aAmount, aReplacementFluid);
        }

        @Deprecated
        public static FluidStack make(FL aFluid, long aAmount, String aReplacementFluidName) {
            return aFluid.make(aAmount, aReplacementFluidName);
        }

        @Deprecated
        public static FluidStack make_(FL aFluid, long aAmount, String aReplacementFluidName) {
            return aFluid.make_(aAmount, aReplacementFluidName);
        }

        @Deprecated
        public static FluidStack make(FL aFluid, long aAmount, FL aReplacementFluid, long aReplacementAmount) {
            return aFluid.make(aAmount, aReplacementFluid, aReplacementAmount);
        }

        @Deprecated
        public static FluidStack make_(FL aFluid, long aAmount, FL aReplacementFluid, long aReplacementAmount) {
            return aFluid.make_(aAmount, aReplacementFluid, aReplacementAmount);
        }

        @Deprecated
        public static FluidStack make(FL aFluid, long aAmount, String aReplacementFluidName, long aReplacementAmount) {
            return aFluid.make(aAmount, aReplacementFluidName, aReplacementAmount);
        }

        @Deprecated
        public static FluidStack make_(FL aFluid, long aAmount, String aReplacementFluidName, long aReplacementAmount) {
            return aFluid.make_(aAmount, aReplacementFluidName, aReplacementAmount);
        }

        @Deprecated
        public static FluidStack make(int aFluid, long aAmount) {
            return aFluid < 0 ? null : new FluidStack(Fluids.fluid(aFluid), Code.bindInt(aAmount));
        }

        @Deprecated
        public static FluidStack make(Fluid aFluid, long aAmount) {
            return aFluid == null ? null : new FluidStack(aFluid, Code.bindInt(aAmount));
        }

        @Deprecated
        public static FluidStack make(String aFluidName, long aAmount) {
            return Fluids.make(FluidRegistry.getFluid((String)aFluidName), aAmount);
        }

        @Deprecated
        public static FluidStack make(String aFluidName, long aAmount, String aReplacementFluidName) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make(aReplacementFluidName, aAmount) : rFluid;
        }

        @Deprecated
        public static FluidStack make(String aFluidName, long aAmount, String aReplacementFluidName, long aReplacementAmount) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make(aReplacementFluidName, aReplacementAmount) : rFluid;
        }

        @Deprecated
        public static FluidStack make(String aFluidName, long aAmount, FluidStack aReplacementFluid) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? aReplacementFluid : rFluid;
        }

        @Deprecated
        public static FluidStack make_(int aFluid, long aAmount) {
            return aFluid < 0 ? FL.Error.make(0L) : new FluidStack(Fluids.fluid(aFluid), Code.bindInt(aAmount));
        }

        @Deprecated
        public static FluidStack make_(Fluid aFluid, long aAmount) {
            return aFluid == null ? FL.Error.make(0L) : new FluidStack(aFluid, Code.bindInt(aAmount));
        }

        @Deprecated
        public static FluidStack make_(String aFluidName, long aAmount) {
            return Fluids.make_(FluidRegistry.getFluid((String)aFluidName), aAmount);
        }

        @Deprecated
        public static FluidStack make_(String aFluidName, long aAmount, String aReplacementFluidName) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make_(aReplacementFluidName, aAmount) : rFluid;
        }

        @Deprecated
        public static FluidStack make_(String aFluidName, long aAmount, String aReplacementFluidName, long aReplacementAmount) {
            FluidStack rFluid = Fluids.make(aFluidName, aAmount);
            return rFluid == null ? Fluids.make_(aReplacementFluidName, aReplacementAmount) : rFluid;
        }

        @Deprecated
        public static FluidStack amount(FluidStack aFluid, long aAmount) {
            return aFluid == null ? null : new FluidStack(aFluid, Code.bindInt(aAmount));
        }

        @Deprecated
        public static FluidStack mul(FluidStack aFluid, long aMultiplier) {
            return aFluid == null ? null : Fluids.amount(aFluid, (long)aFluid.amount * aMultiplier);
        }

        @Deprecated
        public static FluidStack mul(FluidStack aFluid, long aMultiplier, long aDivider, boolean aRoundUp) {
            return aFluid == null ? null : Fluids.amount(aFluid, Code.units(aFluid.amount, aDivider, aMultiplier, aRoundUp));
        }

        @Deprecated
        public static long fill(DelegatorTileEntity aDelegator, FluidStack aFluid, boolean aDoFill) {
            return aDelegator != null && aDelegator.mTileEntity instanceof IFluidHandler && aFluid != null ? Fluids.fill_(aDelegator, aFluid, aDoFill) : 0L;
        }

        @Deprecated
        public static long fill_(DelegatorTileEntity aDelegator, FluidStack aFluid, boolean aDoFill) {
            return Fluids.fill_((IFluidHandler)aDelegator.mTileEntity, aDelegator.mSideOfTileEntity, aFluid, aDoFill);
        }

        @Deprecated
        public static long fill(IFluidHandler aFluidHandler, byte aSide, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler != null && aFluid != null ? Fluids.fill_(aFluidHandler, aSide, aFluid, aDoFill) : 0L;
        }

        @Deprecated
        public static long fill_(IFluidHandler aFluidHandler, byte aSide, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler.fill(CS.FORGE_DIR[aSide], aFluid, aDoFill);
        }

        @Deprecated
        public static long fill(IFluidHandler aFluidHandler, byte[] aSides, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler != null && aFluid != null ? Fluids.fill_(aFluidHandler, aSides, aFluid, aDoFill) : 0L;
        }

        @Deprecated
        public static long fill_(IFluidHandler aFluidHandler, byte[] aSides, FluidStack aFluid, boolean aDoFill) {
            for (byte tSide : aSides) {
                long rFilled = aFluidHandler.fill(CS.FORGE_DIR[tSide], aFluid, aDoFill);
                if (rFilled <= 0L) continue;
                return rFilled;
            }
            return 0L;
        }

        @Deprecated
        public static boolean fillAll(DelegatorTileEntity aDelegator, FluidStack aFluid, boolean aDoFill) {
            return aDelegator != null && aDelegator.mTileEntity instanceof IFluidHandler && aFluid != null && Fluids.fillAll_(aDelegator, aFluid, aDoFill);
        }

        @Deprecated
        public static boolean fillAll_(DelegatorTileEntity aDelegator, FluidStack aFluid, boolean aDoFill) {
            return Fluids.fillAll_((IFluidHandler)aDelegator.mTileEntity, aDelegator.mSideOfTileEntity, aFluid, aDoFill);
        }

        @Deprecated
        public static boolean fillAll(IFluidHandler aFluidHandler, byte aSide, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler != null && aFluid != null && Fluids.fillAll_(aFluidHandler, aSide, aFluid, aDoFill);
        }

        @Deprecated
        public static boolean fillAll_(IFluidHandler aFluidHandler, byte aSide, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler.fill(CS.FORGE_DIR[aSide], aFluid, false) == aFluid.amount && (!aDoFill || aFluidHandler.fill(CS.FORGE_DIR[aSide], aFluid, true) > 0);
        }

        @Deprecated
        public static boolean fillAll(IFluidHandler aFluidHandler, byte[] aSides, FluidStack aFluid, boolean aDoFill) {
            return aFluidHandler != null && aFluid != null && Fluids.fillAll_(aFluidHandler, aSides, aFluid, aDoFill);
        }

        @Deprecated
        public static boolean fillAll_(IFluidHandler aFluidHandler, byte[] aSides, FluidStack aFluid, boolean aDoFill) {
            for (byte tSide : aSides) {
                if (aFluidHandler.fill(CS.FORGE_DIR[tSide], aFluid, false) != aFluid.amount || aDoFill && aFluidHandler.fill(CS.FORGE_DIR[tSide], aFluid, true) <= 0) continue;
                return true;
            }
            return false;
        }

        @Deprecated
        public static long move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo) {
            return Fluids.move(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move_(DelegatorTileEntity aFrom, DelegatorTileEntity aTo) {
            return Fluids.move_(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            return aFrom != null && aFrom.mTileEntity instanceof IFluidHandler && aTo != null && aTo.mTileEntity instanceof IFluidHandler ? Fluids.move_(aFrom, aTo, aMaxMoved) : 0L;
        }

        @Deprecated
        public static long move_(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            if (aMaxMoved <= 0L) {
                return 0L;
            }
            FluidStack tDrained = ((IFluidHandler)aFrom.mTileEntity).drain(aFrom.getForgeSideOfTileEntity(), Code.bindInt(aMaxMoved), false);
            if (tDrained == null || tDrained.amount <= 0) {
                return 0L;
            }
            tDrained.amount = Code.bindInt(Fluids.fill_(aTo, tDrained.copy(), true));
            if (tDrained.amount <= 0) {
                return 0L;
            }
            ((IFluidHandler)aFrom.mTileEntity).drain(aFrom.getForgeSideOfTileEntity(), tDrained, true);
            return tDrained.amount;
        }

        @Deprecated
        public static long move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, FluidStack aMoved) {
            return aFrom != null && aFrom.mTileEntity instanceof IFluidHandler && aTo != null && aTo.mTileEntity instanceof IFluidHandler ? Fluids.move_(aFrom, aTo, aMoved) : 0L;
        }

        @Deprecated
        public static long move_(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, FluidStack aMoved) {
            if (aMoved == null || aMoved.amount <= 0) {
                return 0L;
            }
            FluidStack tDrained = ((IFluidHandler)aFrom.mTileEntity).drain(aFrom.getForgeSideOfTileEntity(), aMoved, false);
            if (tDrained == null || tDrained.amount <= 0) {
                return 0L;
            }
            tDrained.amount = Code.bindInt(Fluids.fill_(aTo, tDrained.copy(), true));
            if (tDrained.amount <= 0) {
                return 0L;
            }
            ((IFluidHandler)aFrom.mTileEntity).drain(aFrom.getForgeSideOfTileEntity(), tDrained, true);
            return tDrained.amount;
        }

        @Deprecated
        public static long move(IFluidTank aFrom, DelegatorTileEntity aTo) {
            return Fluids.move(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move_(IFluidTank aFrom, DelegatorTileEntity aTo) {
            return Fluids.move_(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move(IFluidTank aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            return aFrom != null && aTo != null && aTo.mTileEntity instanceof IFluidHandler ? Fluids.move_(aFrom, aTo, aMaxMoved) : 0L;
        }

        @Deprecated
        public static long move_(IFluidTank aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            if (aMaxMoved <= 0L) {
                return 0L;
            }
            FluidStack tDrained = aFrom.drain(Code.bindInt(aMaxMoved), false);
            if (tDrained == null || tDrained.amount <= 0) {
                return 0L;
            }
            tDrained.amount = Code.bindInt(Fluids.fill_(aTo, tDrained.copy(), true));
            if (tDrained.amount <= 0) {
                return 0L;
            }
            aFrom.drain(tDrained.amount, true);
            return tDrained.amount;
        }

        @Deprecated
        public static long move(IFluidTank[] aFrom, DelegatorTileEntity aTo) {
            return Fluids.move(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move_(IFluidTank[] aFrom, DelegatorTileEntity aTo) {
            return Fluids.move_(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move(IFluidTank[] aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            return aFrom != null && aTo != null && aTo.mTileEntity instanceof IFluidHandler ? Fluids.move_(aFrom, aTo, aMaxMoved) : 0L;
        }

        @Deprecated
        public static long move_(IFluidTank[] aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            if (aMaxMoved <= 0L) {
                return 0L;
            }
            long rAmount = 0L;
            for (IFluidTank tFrom : aFrom) {
                if (tFrom == null) continue;
                rAmount += Fluids.move_(tFrom, aTo, aMaxMoved);
            }
            return rAmount;
        }

        @Deprecated
        public static long move(Iterable aFrom, DelegatorTileEntity aTo) {
            return Fluids.move(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move_(Iterable aFrom, DelegatorTileEntity aTo) {
            return Fluids.move_(aFrom, aTo, Integer.MAX_VALUE);
        }

        @Deprecated
        public static long move(Iterable aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            return aFrom != null && aTo != null && aTo.mTileEntity instanceof IFluidHandler ? Fluids.move_(aFrom, aTo, aMaxMoved) : 0L;
        }

        @Deprecated
        public static long move_(Iterable aFrom, DelegatorTileEntity aTo, long aMaxMoved) {
            if (aMaxMoved <= 0L) {
                return 0L;
            }
            long rAmount = 0L;
            for (Object tFrom : aFrom) {
                if (!(tFrom instanceof IFluidTank)) continue;
                rAmount += Fluids.move_((IFluidTank)tFrom, aTo, aMaxMoved);
            }
            return rAmount;
        }

        @Deprecated
        public static String configName(FluidStack aFluid) {
            return aFluid == null || aFluid.getFluid() == null ? "" : aFluid.getFluid().getName();
        }

        @Deprecated
        public static String configNames(FluidStack ... aFluids) {
            String rString = "";
            for (FluidStack tFluid : aFluids) {
                rString = rString + (tFluid == null ? "null;" : Fluids.configName(tFluid) + ";");
            }
            return rString;
        }

        @Deprecated
        public static String name(Fluid aFluid, boolean aLocalized) {
            if (aFluid == null) {
                return "";
            }
            if (!aLocalized) {
                return aFluid.getUnlocalizedName();
            }
            if (aFluid instanceof FluidGT) {
                return LH.get(aFluid.getUnlocalizedName());
            }
            String rName = aFluid.getLocalizedName(Fluids.make(aFluid, 0L));
            if (rName.contains("fluid.") || rName.contains("tile.")) {
                return Code.capitalise(rName.replaceAll("fluid.", "").replaceAll("tile.", ""));
            }
            return rName;
        }

        @Deprecated
        public static String name(FluidStack aFluid, boolean aLocalized) {
            return aFluid == null ? "" : Fluids.name(aFluid.getFluid(), aLocalized);
        }

        @Deprecated
        public static String name(IFluidTank aTank, boolean aLocalized) {
            return aTank == null ? "" : Fluids.name(aTank.getFluid(), aLocalized);
        }

        @Deprecated
        public static FluidStack[] copyArray(FluidStack ... aFluids) {
            FluidStack[] rStacks = new FluidStack[aFluids.length];
            for (int i = 0; i < aFluids.length; ++i) {
                if (aFluids[i] == null) continue;
                rStacks[i] = aFluids[i].copy();
            }
            return rStacks;
        }

        @Deprecated
        public static void registerFluidContainer(FluidStack aFluid, ItemStack aFull, ItemStack aEmpty) {
            Fluids.registerFluidContainer(aFluid, aFull, aEmpty, false);
        }

        @Deprecated
        public static void registerFluidContainer(FluidStack aFluid, ItemStack aFull, ItemStack aEmpty, boolean aOverrideFillingEmpty, boolean aOverrideDrainingFull) {
            Fluids.registerFluidContainer(aFluid, aFull, aEmpty, false, aOverrideFillingEmpty, aOverrideDrainingFull);
        }

        @Deprecated
        public static void registerFluidContainer(FluidStack aFluid, ItemStack aFull, ItemStack aEmpty, boolean aNullEmpty) {
            Fluids.registerFluidContainer(aFluid, aFull, aEmpty, aNullEmpty, false, false);
        }

        @Deprecated
        public static void registerFluidContainer(FluidStack aFluid, ItemStack aFull, ItemStack aEmpty, boolean aNullEmpty, boolean aOverrideFillingEmpty, boolean aOverrideDrainingFull) {
            if (aFluid == null || ST.invalid(aFull)) {
                return;
            }
            Fluids.registerFluidContainer(new FluidContainerRegistry.FluidContainerData(aFluid, aFull, aEmpty, aNullEmpty), aOverrideFillingEmpty, aOverrideDrainingFull);
        }

        @Deprecated
        public static void registerFluidContainer(FluidContainerRegistry.FluidContainerData aData) {
            Fluids.setFluidContainerData(aData);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)aData);
        }

        @Deprecated
        public static void registerFluidContainer(FluidContainerRegistry.FluidContainerData aData, boolean aOverrideFillingEmpty, boolean aOverrideDrainingFull) {
            Fluids.setFluidContainerData(aData, aOverrideFillingEmpty, aOverrideDrainingFull);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)aData);
        }

        @Deprecated
        public static void setFluidContainerData(FluidContainerRegistry.FluidContainerData aData) {
            Fluids.setFluidContainerData(aData, false, false);
        }

        @Deprecated
        public static void setFluidContainerData(FluidContainerRegistry.FluidContainerData aData, boolean aOverrideFillingEmpty, boolean aOverrideDrainingFull) {
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToData;
            ItemStackContainer tFilled = new ItemStackContainer(aData.filledContainer);
            ItemStackContainer tEmpty = new ItemStackContainer(aData.emptyContainer);
            if (aOverrideDrainingFull || !sFilled2Data.containsKey(tFilled)) {
                sFilled2Data.put(tFilled, aData);
            }
            if ((tFluidToData = sEmpty2Fluid2Data.get(tEmpty)) == null) {
                tFluidToData = new HashMap<String, FluidContainerRegistry.FluidContainerData>();
                sEmpty2Fluid2Data.put(tEmpty, tFluidToData);
            }
            String tFluidName = aData.fluid.getFluid().getName();
            if (aOverrideFillingEmpty || !tFluidToData.containsKey(tFluidName)) {
                tFluidToData.put(tFluidName, aData);
            }
        }

        @Deprecated
        public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
            return Fluids.fillFluidContainer(aFluid, aStack, aRemoveFluidDirectly, aCheckIFluidContainerItems, false, true);
        }

        @Deprecated
        public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems, boolean aAllowPartialFilling) {
            return Fluids.fillFluidContainer(aFluid, aStack, aRemoveFluidDirectly, aCheckIFluidContainerItems, aAllowPartialFilling, true);
        }

        @Deprecated
        public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems, boolean aAllowPartialFilling, boolean aIsNonCannerCheck) {
            if (ST.invalid(aStack) || aFluid == null) {
                return CS.NI;
            }
            if (aFluid.getFluid() == FluidRegistry.WATER && ST.equal(aStack, Items.glass_bottle)) {
                if (aFluid.amount >= 250) {
                    if (aRemoveFluidDirectly) {
                        aFluid.amount -= 250;
                    }
                    return ST.make((Item)Items.potionitem, 1L, 0L);
                }
                return CS.NI;
            }
            if (aIsNonCannerCheck && IL.GC_Canister.exists() && (IL.GC_Canister.equal(aStack, true, true) || ST.equal(ST.container(aStack, true), IL.GC_Canister.wild(1L, new Object[0])))) {
                return aStack;
            }
            if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0 && (((IFluidContainerItem)aStack.getItem()).getFluid(aStack) == null || Fluids.equal(((IFluidContainerItem)aStack.getItem()).getFluid(aStack), aFluid) && ((IFluidContainerItem)aStack.getItem()).getFluid((ItemStack)aStack).amount < ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack)) && (aAllowPartialFilling || ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) <= aFluid.amount)) {
                if (IL.Cell_Universal_Fluid.equal(aStack, true, true) && (Fluids.temperature(aFluid, 293L) > MT.Sn.mMeltingPoint || !Fluids.simple(aFluid) || Fluids.acid(aFluid) || Fluids.powerconducting(aFluid))) {
                    return aStack;
                }
                if (aRemoveFluidDirectly) {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                    aStack = ST.amount(1L, aStack);
                    aFluid.amount -= iFluidContainerItem.fill(aStack, aFluid, true);
                } else {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                    aStack = ST.amount(1L, aStack);
                    iFluidContainerItem.fill(aStack, aFluid, true);
                }
                return aStack;
            }
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmpty2Fluid2Data.get(new ItemStackContainer(aStack));
            if (tFluidToContainer == null) {
                return CS.NI;
            }
            FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid().getName());
            if (tData == null || tData.fluid.amount > aFluid.amount) {
                return CS.NI;
            }
            if (aRemoveFluidDirectly) {
                aFluid.amount -= tData.fluid.amount;
            }
            return ST.amount(1L, tData.filledContainer);
        }

        @Deprecated
        public static ItemStack fillFluidContainer(IFluidTank aTank, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
            return Fluids.fillFluidContainer(aTank, aStack, aRemoveFluidDirectly, aCheckIFluidContainerItems, false, true);
        }

        @Deprecated
        public static ItemStack fillFluidContainer(IFluidTank aTank, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems, boolean aAllowPartialFilling) {
            return Fluids.fillFluidContainer(aTank, aStack, aRemoveFluidDirectly, aCheckIFluidContainerItems, aAllowPartialFilling, true);
        }

        @Deprecated
        public static ItemStack fillFluidContainer(IFluidTank aTank, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems, boolean aAllowPartialFilling, boolean aIsNonCannerCheck) {
            if (aTank == null) {
                return CS.NI;
            }
            FluidStack aFluid = aTank.getFluid();
            if (ST.invalid(aStack) || aFluid == null) {
                return CS.NI;
            }
            if (aFluid.getFluid() == FluidRegistry.WATER && ST.equal(aStack, Items.glass_bottle)) {
                if (aFluid.amount >= 250) {
                    if (aRemoveFluidDirectly) {
                        aTank.drain(250, true);
                    }
                    return ST.make((Item)Items.potionitem, 1L, 0L);
                }
                return CS.NI;
            }
            if (aIsNonCannerCheck && IL.GC_Canister.exists() && (IL.GC_Canister.equal(aStack, true, true) || ST.equal(ST.container(aStack, true), IL.GC_Canister.wild(1L, new Object[0])))) {
                return aStack;
            }
            if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0 && (((IFluidContainerItem)aStack.getItem()).getFluid(aStack) == null || Fluids.equal(((IFluidContainerItem)aStack.getItem()).getFluid(aStack), aFluid) && ((IFluidContainerItem)aStack.getItem()).getFluid((ItemStack)aStack).amount < ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack)) && (aAllowPartialFilling || ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) <= aFluid.amount)) {
                if (IL.Cell_Universal_Fluid.equal(aStack, true, true) && (Fluids.temperature(aFluid, 293L) > MT.Sn.mMeltingPoint || !Fluids.simple(aFluid) || Fluids.acid(aFluid) || Fluids.powerconducting(aFluid))) {
                    return aStack;
                }
                if (aRemoveFluidDirectly) {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                    aStack = ST.amount(1L, aStack);
                    aTank.drain(iFluidContainerItem.fill(aStack, aFluid, true), true);
                } else {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                    aStack = ST.amount(1L, aStack);
                    iFluidContainerItem.fill(aStack, aFluid, true);
                }
                return aStack;
            }
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmpty2Fluid2Data.get(new ItemStackContainer(aStack));
            if (tFluidToContainer == null) {
                return CS.NI;
            }
            FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid().getName());
            if (tData == null || tData.fluid.amount > aFluid.amount) {
                return CS.NI;
            }
            if (aRemoveFluidDirectly) {
                aTank.drain(tData.fluid.amount, true);
            }
            return ST.amount(1L, tData.filledContainer);
        }

        @Deprecated
        public static boolean containsFluid(ItemStack aStack, FluidStack aFluid, boolean aCheckIFluidContainerItems) {
            if (ST.invalid(aStack) || aFluid == null) {
                return false;
            }
            if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                aStack = ST.amount(1L, aStack);
                return aFluid.isFluidEqual(iFluidContainerItem.getFluid(aStack));
            }
            FluidContainerRegistry.FluidContainerData tData = sFilled2Data.get(new ItemStackContainer(aStack));
            return tData != null && tData.fluid.isFluidEqual(aFluid);
        }

        @Deprecated
        public static FluidStack getFluidForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            if (ST.invalid(aStack)) {
                return null;
            }
            if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
                FluidStack rFluid = ((IFluidContainerItem)aStack.getItem()).drain(ST.amount(1L, aStack), Integer.MAX_VALUE, true);
                if (IL.Cell_Universal_Fluid.equal(aStack, true, true) && (Fluids.temperature(rFluid, 293L) > MT.Sn.mMeltingPoint || !Fluids.simple(rFluid) || Fluids.acid(rFluid) || Fluids.powerconducting(rFluid))) {
                    return CS.NF;
                }
                return rFluid;
            }
            FluidContainerRegistry.FluidContainerData tData = sFilled2Data.get(new ItemStackContainer(aStack));
            return tData == null ? CS.NF : tData.fluid.copy();
        }

        @Deprecated
        public static ItemStack getContainerForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
            if (ST.invalid(aStack)) {
                return CS.NI;
            }
            FluidContainerRegistry.FluidContainerData tData = sFilled2Data.get(new ItemStackContainer(aStack));
            if (tData != null) {
                return ST.amount(1L, tData.emptyContainer);
            }
            if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                aStack = ST.amount(1L, aStack);
                iFluidContainerItem.drain(aStack, Integer.MAX_VALUE, true);
                if (aStack.getTagCompound() == null) {
                    return aStack;
                }
                if (aStack.getTagCompound().hasNoTags()) {
                    aStack.setTagCompound(null);
                }
                return aStack;
            }
            return CS.NI;
        }

        @Deprecated
        public static FluidStack load(NBTTagCompound aNBT, String aTagName) {
            return FL.load(aNBT, aTagName);
        }

        @Deprecated
        public static FluidStack load(NBTTagCompound aNBT) {
            return FL.load(aNBT);
        }

        @Deprecated
        public static FluidStack load_(NBTTagCompound aNBT) {
            return FL.load_(aNBT);
        }

        @Deprecated
        public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, FluidStack aFluid) {
            return FL.save(aNBT, aTagName, aFluid);
        }

        @Deprecated
        public static NBTTagCompound save(FluidStack aFluid) {
            return FL.save(aFluid);
        }

        @Deprecated
        public static NBTTagCompound save_(FluidStack aFluid) {
            return FL.save_(aFluid);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createLiquid(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
            return Fluids.createLiquid(aMaterial, aMaterial.mTextureSetsBlock.get(CS.IconsGT.INDEX_BLOCK_MOLTEN), aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createLiquid(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.create(aMaterial.mNameInternal.toLowerCase(), aTexture, aMaterial.mNameLocal, aMaterial, aMaterial.mRGBaLiquid, 1, 1000L, aMaterial.mMeltingPoint <= 0L ? 1000L : (aMaterial.mMeltingPoint < 300L ? Math.min(300L, aMaterial.mBoilingPoint - 1L) : aMaterial.mMeltingPoint), null, null, 0, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createMolten(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
            return Fluids.createMolten(aMaterial, 144L, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createMolten(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.createMolten(aMaterial, 144L, aTexture, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createMolten(OreDictMaterial aMaterial, long aAmount, Set<String> ... aFluidList) {
            return Fluids.createMolten(aMaterial, aAmount, aMaterial.mTextureSetsBlock.get(CS.IconsGT.INDEX_BLOCK_MOLTEN), aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createMolten(OreDictMaterial aMaterial, long aAmount, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.create("molten." + aMaterial.mNameInternal.toLowerCase(), aTexture, "Molten " + aMaterial.mNameLocal, aMaterial, aMaterial.mRGBaLiquid, 1, aAmount, aMaterial.mMeltingPoint <= 0L ? 1000L : (aMaterial.mMeltingPoint < 300L ? Math.min(300L, aMaterial.mBoilingPoint - 1L) : aMaterial.mMeltingPoint), null, null, 0, aFluidList).setLuminosity(10);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createGas(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
            return Fluids.createGas(aMaterial, aMaterial.mTextureSetsBlock.get(CS.IconsGT.INDEX_BLOCK_GAS), aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createGas(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.create(aMaterial.mNameInternal.toLowerCase(), aTexture, aMaterial.mNameLocal, aMaterial, aMaterial.mRGBaGas, 2, 1000L, aMaterial.mBoilingPoint <= 0L ? 3000L : (aMaterial.mBoilingPoint < 300L ? Math.min(300L, aMaterial.mPlasmaPoint - 1L) : aMaterial.mBoilingPoint), null, null, 0, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createVapour(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
            return Fluids.createVapour(aMaterial, aMaterial.mTextureSetsBlock.get(CS.IconsGT.INDEX_BLOCK_GAS), aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createVapour(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.create("vapor." + aMaterial.mNameInternal.toLowerCase(), aTexture, "Vaporized " + aMaterial.mNameLocal, aMaterial, aMaterial.mRGBaGas, 2, 1152L, aMaterial.mBoilingPoint <= 0L ? 3000L : (aMaterial.mBoilingPoint < 300L ? Math.min(300L, aMaterial.mPlasmaPoint - 1L) : aMaterial.mBoilingPoint), null, null, 0, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createPlasma(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
            return Fluids.createPlasma(aMaterial, aMaterial.mTextureSetsBlock.get(CS.IconsGT.INDEX_BLOCK_PLASMA), aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid createPlasma(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
            return Fluids.create("plasma." + aMaterial.mNameInternal.toLowerCase(), aTexture, aMaterial.mNameLocal + " Plasma", aMaterial, aMaterial.mRGBaPlasma, 3, 20736L, aMaterial.mPlasmaPoint <= 0L ? 10000L : Math.max(300L, aMaterial.mPlasmaPoint), null, null, 0, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid create(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, Set<String> ... aFluidList) {
            return Fluids.create(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, null, null, 0, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid create(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
            return Fluids.create(aName, new Textures.BlockIcons.CustomIcon("fluids/" + aName.toLowerCase()), aLocalized, aMaterial, null, aState, aAmountPerUnit, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aFluidList);
        }

        @Deprecated
        @SafeVarargs
        public static Fluid create(String aName, IIconContainer aTexture, String aLocalized, OreDictMaterial aMaterial, short[] aRGBa, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
            aName = aName.toLowerCase();
            FluidGT rFluid = new FluidGT(aName, aTexture, aRGBa == null ? CS.UNCOLOURED : aRGBa, aTemperatureK, aState == 2 || aState == 3);
            LH.add(rFluid.getUnlocalizedName(), aLocalized == null ? aName : aLocalized);
            for (Set<String> tSet : aFluidList) {
                tSet.add(aName);
            }
            switch (aState) {
                case 0: {
                    rFluid.setViscosity(10000);
                    break;
                }
                case 1: {
                    rFluid.setViscosity(1000);
                    CS.FluidsGT.LIQUID.add(aName);
                    break;
                }
                case 2: {
                    rFluid.setViscosity(200);
                    rFluid.setDensity(-100);
                    CS.FluidsGT.GAS.add(aName);
                    break;
                }
                case 3: {
                    rFluid.setViscosity(10);
                    rFluid.setDensity(-100000);
                    rFluid.setLuminosity(15);
                    CS.FluidsGT.PLASMA.add(aName);
                    break;
                }
                case 4: {
                    rFluid.setViscosity(1000);
                }
            }
            if (!FluidRegistry.registerFluid((Fluid)rFluid)) {
                rFluid = FluidRegistry.getFluid((String)aName);
                LH.add(rFluid.getUnlocalizedName(), aLocalized == null ? aName : aLocalized);
                if (rFluid.getTemperature() == new Fluid("test").getTemperature() || rFluid.getTemperature() <= 0) {
                    rFluid.setTemperature(Code.bindInt(aTemperatureK));
                }
                rFluid.setGaseous(aState == 2 || aState == 3);
            }
            if (aMaterial != null) {
                if (aMaterial.contains(TD.Properties.ACID)) {
                    CS.FluidsGT.ACID.add(aName);
                }
                if (aMaterial.contains(TD.Properties.GLOWING)) {
                    rFluid.setLuminosity(Math.max(rFluid.getLuminosity(), 5));
                }
                if (aMaterial.contains(TD.Properties.LIGHTING)) {
                    rFluid.setLuminosity(Math.max(rFluid.getLuminosity(), 15));
                }
                switch (aState) {
                    case 1: {
                        aMaterial.liquid(Fluids.make(rFluid, (long)Code.bindInt(aAmountPerUnit)));
                        break;
                    }
                    case 2: {
                        aMaterial.gas(Fluids.make(rFluid, (long)Code.bindInt(aAmountPerUnit)));
                        break;
                    }
                    case 3: {
                        aMaterial.plasma(Fluids.make(rFluid, (long)Code.bindInt(aAmountPerUnit)));
                    }
                }
                if (aMaterial.mGramPerCubicCentimeter > 0.0 && (aState == 1 || aState == 2)) {
                    if (aMaterial.mGramPerCubicCentimeter > 0.0012) {
                        rFluid.setDensity(Code.bindInt((long)(1000.0 * aMaterial.mGramPerCubicCentimeter)));
                    } else if (aMaterial.mGramPerCubicCentimeter < 0.0012) {
                        rFluid.setDensity(Code.bindInt((long)(-0.1 / aMaterial.mGramPerCubicCentimeter)));
                    } else {
                        rFluid.setDensity(0);
                    }
                }
            }
            if (aFullContainer != null && aEmptyContainer != null && !FluidContainerRegistry.registerFluidContainer((FluidStack)Fluids.make(rFluid, (long)aFluidAmount), (ItemStack)aFullContainer, (ItemStack)aEmptyContainer)) {
                RM.Canner.addRecipe1(true, 16L, (long)Math.max(aFluidAmount / 64, 16), aFullContainer, CS.NF, Fluids.make(rFluid, (long)aFluidAmount), ST.container(aFullContainer, false));
            }
            return rFluid;
        }
    }
}

