/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import buildcraft.api.transport.IInjectable;
import codechicken.nei.api.API;
import cofh.api.transport.IItemDuct;
import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.block.ItemBlockBase;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.IItemContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.code.TagData;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OD;
import gregapi.data.TD;
import gregapi.item.IItemGT;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.IItemProjectile;
import gregapi.item.IItemUpdatable;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.util.OM;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.wooddict.WoodDictionary;
import gregtech.worldgen.TwilightTreasureReplacer;
import ic2.api.item.IC2Items;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidContainerItem;
import twilightforest.TFAchievementPage;
import twilightforest.TFTreasure;

public class ST {
    public static boolean TE_PIPES = false;
    public static boolean BC_PIPES = false;
    public static boolean TF_TREASURE = false;
    private static final Map<String, ItemStack> sIC2ItemMap = new HashMap<String, ItemStack>();
    public static final Collection<ItemStack> REVERT_TO_BOOK_TO_FIX_STUPID = ST.arraylist(new ItemStack[0]);
    public static final List<String> LOOT_TABLES = new ArrayListNoNulls<String>(false, "dungeonChest", "villageBlacksmith", "mineshaftCorridor", "strongholdLibrary", "strongholdCrossing", "strongholdCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "bonusChest");
    public static final List<String> LOOT_TABLES_VANILLA = new ArrayListNoNulls<String>(false, "dungeonChest", "villageBlacksmith", "mineshaftCorridor", "strongholdLibrary", "strongholdCrossing", "strongholdCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "bonusChest");

    public static void checkAvailabilities() {
        try {
            IItemDuct.class.getCanonicalName();
            TE_PIPES = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IInjectable.class.getCanonicalName();
            BC_PIPES = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            TFTreasure.class.getCanonicalName();
            TF_TREASURE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean equal(ItemStack aStack1, ItemStack aStack2) {
        return ST.equal(aStack1, aStack2, false);
    }

    public static boolean equal(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return aStack1 != null && aStack2 != null && ST.equal_(aStack1, aStack2, aIgnoreNBT);
    }

    public static boolean equal_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return ST.item_(aStack1) == ST.item_(aStack2) && ST.equal(ST.meta_(aStack1), ST.meta_(aStack2)) && (aIgnoreNBT || ST.nbt_(aStack1) == null == (ST.nbt_(aStack2) == null) && (ST.nbt_(aStack1) == null || ST.nbt_(aStack1).equals((Object)ST.nbt_(aStack2))));
    }

    public static boolean equal(ItemStack aStack, Item aItem) {
        return aStack != null && aItem != null && ST.equal_(aStack, aItem);
    }

    public static boolean equal(ItemStack aStack, Block aBlock) {
        return aStack != null && aBlock != null && ST.equal_(aStack, aBlock);
    }

    public static boolean equal_(ItemStack aStack, Item aItem) {
        return ST.item_(aStack) == aItem;
    }

    public static boolean equal_(ItemStack aStack, Block aBlock) {
        return ST.block_(aStack) == aBlock;
    }

    public static boolean equal(ItemStack aStack, Item aItem, long aMeta) {
        return aStack != null && aItem != null && ST.equal_(aStack, aItem, aMeta);
    }

    public static boolean equal(ItemStack aStack, Block aBlock, long aMeta) {
        return aStack != null && aBlock != null && ST.equal_(aStack, aBlock, aMeta);
    }

    public static boolean equal_(ItemStack aStack, Item aItem, long aMeta) {
        return ST.equal(ST.meta_(aStack), aMeta) && ST.item_(aStack) == aItem;
    }

    public static boolean equal_(ItemStack aStack, Block aBlock, long aMeta) {
        return ST.equal(ST.meta_(aStack), aMeta) && ST.block_(aStack) == aBlock;
    }

    public static boolean equal(ItemStack aStack, ModData aModID, String aItem) {
        return ST.equal(aStack, GameRegistry.findItem((String)aModID.mID, (String)aItem));
    }

    public static boolean equal(ItemStack aStack, ModData aModID, String aItem, long aMeta) {
        return ST.equal(aStack, GameRegistry.findItem((String)aModID.mID, (String)aItem), aMeta);
    }

    public static boolean equal(ItemStack aStack, Item aItem, boolean aAllowNBT) {
        return aStack != null && aItem != null && ST.equal_(aStack, aItem, aAllowNBT);
    }

    public static boolean equal(ItemStack aStack, Block aBlock, boolean aAllowNBT) {
        return aStack != null && aBlock != null && ST.equal_(aStack, aBlock, aAllowNBT);
    }

    public static boolean equal_(ItemStack aStack, Item aItem, boolean aAllowNBT) {
        return ST.item_(aStack) == aItem && aAllowNBT == aStack.hasTagCompound();
    }

    public static boolean equal_(ItemStack aStack, Block aBlock, boolean aAllowNBT) {
        return ST.block_(aStack) == aBlock && aAllowNBT == aStack.hasTagCompound();
    }

    public static boolean equal(ItemStack aStack, Item aItem, long aMeta, boolean aAllowNBT) {
        return aStack != null && aItem != null && ST.equal_(aStack, aItem, aMeta, aAllowNBT);
    }

    public static boolean equal(ItemStack aStack, Block aBlock, long aMeta, boolean aAllowNBT) {
        return aStack != null && aBlock != null && ST.equal_(aStack, aBlock, aMeta, aAllowNBT);
    }

    public static boolean equal_(ItemStack aStack, Item aItem, long aMeta, boolean aAllowNBT) {
        return ST.equal(ST.meta_(aStack), aMeta) && ST.item_(aStack) == aItem && aAllowNBT == aStack.hasTagCompound();
    }

    public static boolean equal_(ItemStack aStack, Block aBlock, long aMeta, boolean aAllowNBT) {
        return ST.equal(ST.meta_(aStack), aMeta) && ST.block_(aStack) == aBlock && aAllowNBT == aStack.hasTagCompound();
    }

    public static boolean equal(ItemStack aStack, ModData aModID, String aItem, boolean aAllowNBT) {
        return ST.equal(aStack, GameRegistry.findItem((String)aModID.mID, (String)aItem), aAllowNBT);
    }

    public static boolean equal(ItemStack aStack, ModData aModID, String aItem, long aMeta, boolean aAllowNBT) {
        return ST.equal(aStack, GameRegistry.findItem((String)aModID.mID, (String)aItem), aMeta, aAllowNBT);
    }

    public static boolean equal(long aMeta1, long aMeta2) {
        return aMeta1 == aMeta2 || aMeta1 == 32767L || aMeta2 == 32767L;
    }

    public static boolean equalTools(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return aStack1 != null && aStack2 != null && ST.equalTools_(aStack1, aStack2, aIgnoreNBT);
    }

    public static boolean equalTools_(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return ST.item_(aStack1) == ST.item_(aStack2) && ST.equal(ST.meta_(aStack1), ST.meta_(aStack2)) && (aIgnoreNBT || ST.item_(aStack1) instanceof IItemGTContainerTool || ST.nbt_(aStack1) == null == (ST.nbt_(aStack2) == null) && (ST.nbt_(aStack1) == null || ST.nbt_(aStack1).equals((Object)ST.nbt_(aStack2))));
    }

    public static boolean identical(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == aStack2 || aStack1 != null && aStack2 != null && ST.identical_(aStack1, aStack2);
    }

    public static boolean identical_(ItemStack aStack1, ItemStack aStack2) {
        return aStack1.stackSize == aStack2.stackSize && ST.equal_(aStack1, aStack2, false);
    }

    public static boolean isGT(Item aItem) {
        return aItem instanceof IItemGT;
    }

    public static boolean isGT(Block aBlock) {
        return aBlock instanceof IItemGT;
    }

    public static boolean isGT(ItemStack aStack) {
        return aStack != null && ST.isGT_(aStack);
    }

    public static boolean isGT_(ItemStack aStack) {
        return ST.isGT(aStack.getItem());
    }

    public static boolean valid(Block aBlock) {
        return aBlock != null && aBlock != CS.NB;
    }

    public static boolean invalid(Block aBlock) {
        return aBlock == null || aBlock == CS.NB;
    }

    public static boolean valid(ItemStack aStack) {
        return aStack != null && aStack.stackSize >= 0 && ST.item_(aStack) != null;
    }

    public static boolean invalid(ItemStack aStack) {
        return aStack == null || aStack.stackSize < 0 || ST.item_(aStack) == null;
    }

    public static ItemStack validate(ItemStack aStack) {
        return ST.valid(aStack) ? aStack : null;
    }

    public static ItemStack valisize(ItemStack aStack) {
        return ST.valid(aStack) && aStack.stackSize > 0 ? aStack : null;
    }

    public static short id(Item aItem) {
        return aItem == null ? (short)0 : ST.id_(aItem);
    }

    public static short id_(Item aItem) {
        return (short)Item.getIdFromItem((Item)aItem);
    }

    public static short id(Block aBlock) {
        return aBlock == null ? (short)0 : ST.id_(aBlock);
    }

    public static short id_(Block aBlock) {
        return aBlock == CS.NB ? (short)0 : (short)Block.getIdFromBlock((Block)aBlock);
    }

    public static short id(ItemStack aStack) {
        return aStack == null ? (short)0 : ST.id(ST.item_(aStack));
    }

    public static Item item(ModData aModID, String aItem) {
        return ST.item(ST.make(aModID, aItem, 1L, 0L));
    }

    public static Item item(ModData aModID, String aItem, Item aReplacement) {
        Item rItem = ST.item(aModID, aItem);
        return rItem == null ? aReplacement : rItem;
    }

    public static Item item(Block aBlock) {
        return aBlock == null ? null : ST.item_(aBlock);
    }

    public static Item item_(Block aBlock) {
        return aBlock == CS.NB ? null : Item.getItemFromBlock((Block)aBlock);
    }

    public static Item item(ItemStack aStack) {
        return aStack == null ? null : ST.item_(aStack);
    }

    public static Item item_(ItemStack aStack) {
        return aStack.getItem();
    }

    public static Item item(long aID) {
        return aID > 0L && aID < 65536L ? ST.item_(aID) : null;
    }

    public static Item item_(long aID) {
        return Item.getItemById((int)((int)aID));
    }

    public static Block block(ModData aModID, String aBlock) {
        return ST.block(ST.make(aModID, aBlock, 1L, 0L));
    }

    public static Block block(ModData aModID, String aBlock, Block aReplacement) {
        Block rBlock = ST.block(aModID, aBlock);
        return rBlock == CS.NB ? aReplacement : rBlock;
    }

    public static Block block(Item aItem) {
        return aItem != null ? ST.block_(aItem) : CS.NB;
    }

    public static Block block_(Item aItem) {
        return Block.getBlockFromItem((Item)aItem);
    }

    public static Block block(ItemStack aStack) {
        return aStack != null ? ST.block(ST.item_(aStack)) : CS.NB;
    }

    public static Block block_(ItemStack aStack) {
        return ST.block_(ST.item_(aStack));
    }

    public static Block block(long aID) {
        return aID > 0L && aID < 65536L ? ST.block_(aID) : CS.NB;
    }

    public static Block block_(long aID) {
        return Block.getBlockById((int)((int)aID));
    }

    public static short meta(ItemStack aStack) {
        return aStack == null ? (short)0 : ST.meta_(aStack);
    }

    public static short meta_(ItemStack aStack) {
        return (short)Items.feather.getDamage(aStack);
    }

    public static ItemStack meta(ItemStack aStack, long aMeta) {
        return aStack == null ? null : ST.meta_(aStack, aMeta);
    }

    public static ItemStack meta_(ItemStack aStack, long aMeta) {
        Items.feather.setDamage(aStack, (int)((short)aMeta));
        return aStack;
    }

    public static byte size(ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null || aStack.stackSize < 0 ? (byte)0 : UT.Code.bindByte(aStack.stackSize);
    }

    public static ItemStack size(long aSize, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.size_(aSize, aStack);
    }

    public static ItemStack size_(long aSize, ItemStack aStack) {
        aStack.stackSize = (int)aSize;
        return aStack;
    }

    public static byte maxsize(ItemStack aStack) {
        return (byte)(aStack == null || ST.item_(aStack) == null ? 64 : ST.item_(aStack).getItemStackLimit(aStack));
    }

    public static ItemStack copy(ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.copy_(aStack);
    }

    public static ItemStack copy_(ItemStack aStack) {
        return aStack.copy();
    }

    public static ItemStack name(ItemStack aStack, String aName) {
        return aStack == null || aName == null ? aStack : ST.name_(aStack, aName);
    }

    public static ItemStack name_(ItemStack aStack, String aName) {
        aStack.setStackDisplayName(aName);
        return aStack;
    }

    public static NBTTagCompound nbt(ItemStack aStack) {
        return aStack == null ? null : ST.nbt_(aStack);
    }

    public static NBTTagCompound nbt_(ItemStack aStack) {
        return aStack.getTagCompound();
    }

    public static ItemStack nbt(ItemStack aStack, NBTTagCompound aNBT) {
        return aStack == null ? null : ST.nbt_(aStack, aNBT);
    }

    public static ItemStack nbt_(ItemStack aStack, NBTTagCompound aNBT) {
        return UT.NBT.set(aStack, aNBT);
    }

    public static ItemStack amount(long aSize, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.amount_(aSize, aStack);
    }

    public static ItemStack amount_(long aSize, ItemStack aStack) {
        return ST.size_(aSize, ST.copy_(aStack));
    }

    public static ItemStack mul(long aMultiplier, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.mul_(aMultiplier, aStack);
    }

    public static ItemStack mul_(long aMultiplier, ItemStack aStack) {
        return ST.amount_((long)aStack.stackSize * aMultiplier, aStack);
    }

    public static ItemStack div(long aDivider, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.div_(aDivider, aStack);
    }

    public static ItemStack div_(long aDivider, ItemStack aStack) {
        return ST.amount_((long)aStack.stackSize / aDivider, aStack);
    }

    public static ItemStack validMeta(long aSize, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.validMeta_(aSize, aStack);
    }

    public static ItemStack validMeta_(long aSize, ItemStack aStack) {
        return ST.size_(aSize, ST.validMeta_(aStack));
    }

    public static ItemStack validMeta(ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.validMeta_(aStack);
    }

    public static ItemStack validMeta_(ItemStack aStack) {
        return ST.meta_(aStack) == Short.MAX_VALUE ? ST.meta_(ST.copy_(aStack), 0L) : ST.copy_(aStack);
    }

    public static Block nullair(Block aBlock) {
        return aBlock != CS.NB ? aBlock : null;
    }

    public static int toInt(Item aItem, long aMeta) {
        return aItem == null ? 0 : ST.id_(aItem) | (short)aMeta << 16;
    }

    public static int toInt(ItemStack aStack) {
        return aStack != null ? ST.toInt(ST.item_(aStack), (long)ST.meta_(aStack)) : 0;
    }

    public static int toInt(ItemStack aStack, long aMeta) {
        return aStack != null ? ST.toInt(ST.item_(aStack), aMeta) : 0;
    }

    public static ItemStack toStack(int aStack) {
        return ST.make(ST.toItem(aStack), 1L, (long)ST.toMeta(aStack));
    }

    public static Block toBlock(int aStack) {
        return ST.block(aStack & 0xFFFF);
    }

    public static Item toItem(int aStack) {
        return ST.item(aStack & 0xFFFF);
    }

    public static short toMeta(int aStack) {
        return (short)(aStack >>> 16);
    }

    public static String regName(ItemStack aStack) {
        return ST.regName(ST.item(aStack));
    }

    public static String regName(Block aBlock) {
        return ST.regName(ST.item(aBlock));
    }

    public static String regName(Item aItem) {
        return aItem == null ? null : ST.regName_(aItem);
    }

    public static String regName_(Item aItem) {
        return Item.itemRegistry.getNameForObject((Object)aItem);
    }

    public static String regMeta(ItemStack aStack) {
        return ST.invalid(aStack) ? "" : ST.regName(ST.item_(aStack)) + ":" + ST.meta_(aStack);
    }

    public static String regMeta(Block aBlock) {
        return aBlock == null ? "" : ST.regName(ST.item_(aBlock)) + ":0";
    }

    public static String regMeta(Item aItem) {
        return aItem == null ? "" : ST.regName(aItem) + ":0";
    }

    public static String regMeta_(Item aItem) {
        return ST.regName(aItem) + ":0";
    }

    public static boolean ownedBy(ModData aMod, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aMod.mLoaded && ST.ownedBy(aMod.mID, aWorld, aX, aY, aZ);
    }

    public static boolean ownedBy(ModData aMod, ItemStack aStack) {
        return aMod.mLoaded && ST.ownedBy(aMod.mID, aStack);
    }

    public static boolean ownedBy(ModData aMod, Block aBlock) {
        return aMod.mLoaded && ST.ownedBy(aMod.mID, aBlock);
    }

    public static boolean ownedBy(ModData aMod, Item aItem) {
        return aMod.mLoaded && ST.ownedBy(aMod.mID, aItem);
    }

    public static boolean ownedBy(ModData aMod, String aRegName) {
        return aMod.mLoaded && ST.ownedBy(aMod.mID, aRegName);
    }

    public static boolean ownedBy(String aMod, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return ST.ownedBy(aMod, aWorld.getBlock(aX, aY, aZ));
    }

    public static boolean ownedBy(String aMod, ItemStack aStack) {
        return ST.ownedBy(aMod, ST.regName(aStack));
    }

    public static boolean ownedBy(String aMod, Block aBlock) {
        return ST.ownedBy(aMod, ST.regName(aBlock));
    }

    public static boolean ownedBy(String aMod, Item aItem) {
        return ST.ownedBy(aMod, ST.regName(aItem));
    }

    public static boolean ownedBy(String aMod, String aRegName) {
        return aRegName != null && aMod != null && ST.ownedBy_(aMod, aRegName);
    }

    public static boolean ownedBy_(String aMod, String aRegName) {
        return aRegName.startsWith(aMod);
    }

    public static void register(Item aItem, String aRegistryName) {
        GameRegistry.registerItem((Item)aItem, (String)aRegistryName);
    }

    public static void register(Block aBlock, String aRegistryName) {
        ST.register(aBlock, aRegistryName, null);
    }

    public static void register(Block aBlock, String aRegistryName, Class<? extends ItemBlock> aItemClass) {
        GameRegistry.registerBlock((Block)aBlock, aItemClass == null ? ItemBlockBase.class : aItemClass, (String)aRegistryName);
        if (CS.COMPAT_IC2 != null) {
            CS.COMPAT_IC2.addToExplosionWhitelist(aBlock);
        }
    }

    public static ItemStack set(ItemStack aSetStack, ItemStack aToStack) {
        return ST.set(aSetStack, aToStack, true, true);
    }

    public static ItemStack set(ItemStack aSetStack, ItemStack aToStack, boolean aCheckStacksize, boolean aCheckNBT) {
        if (ST.invalid(aSetStack) || ST.invalid(aToStack)) {
            return null;
        }
        aSetStack.func_150996_a(ST.item_(aToStack));
        if (aCheckStacksize) {
            aSetStack.stackSize = aToStack.stackSize;
        }
        ST.meta_(aSetStack, ST.meta_(aToStack));
        if (aCheckNBT) {
            aSetStack.setTagCompound(aToStack.getTagCompound());
        }
        return aSetStack;
    }

    public static ItemStack update(ItemStack aStack) {
        return ST.invalid(aStack) ? aStack : ST.update_(aStack);
    }

    public static ItemStack update_(ItemStack aStack) {
        if (aStack.hasTagCompound() && aStack.getTagCompound().hasNoTags()) {
            aStack.setTagCompound(null);
        }
        if (ST.item_(aStack) instanceof IItemUpdatable) {
            ((IItemUpdatable)ST.item_(aStack)).updateItemStack(aStack);
        }
        return aStack;
    }

    public static ItemStack update(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        return ST.invalid(aStack) ? aStack : ST.update_(aStack, aWorld, aX, aY, aZ);
    }

    public static ItemStack update_(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        if (aStack.hasTagCompound() && aStack.getTagCompound().hasNoTags()) {
            aStack.setTagCompound(null);
        }
        if (ST.item_(aStack) instanceof IItemUpdatable) {
            ((IItemUpdatable)ST.item_(aStack)).updateItemStack(aStack, aWorld, aX, aY, aZ);
        }
        return aStack;
    }

    public static ItemStack update(ItemStack aStack, Entity aEntity) {
        return ST.update(aStack, aEntity.worldObj, UT.Code.roundDown(aEntity.posX), UT.Code.roundDown(aEntity.posY), UT.Code.roundDown(aEntity.posZ));
    }

    public static ItemStack update_(ItemStack aStack, Entity aEntity) {
        return ST.update_(aStack, aEntity.worldObj, UT.Code.roundDown(aEntity.posX), UT.Code.roundDown(aEntity.posY), UT.Code.roundDown(aEntity.posZ));
    }

    public static boolean update(Entity aPlayer) {
        if (aPlayer instanceof EntityPlayer && !aPlayer.worldObj.isRemote && ((EntityPlayer)aPlayer).openContainer != null) {
            ((EntityPlayer)aPlayer).openContainer.detectAndSendChanges();
        }
        return true;
    }

    public static boolean use(Entity aPlayer, ItemStack aStack) {
        return ST.use(aPlayer, false, true, aStack, 1L);
    }

    public static boolean use(Entity aPlayer, ItemStack aStack, long aAmount) {
        return ST.use(aPlayer, false, true, aStack, aAmount);
    }

    public static boolean use(Entity aPlayer, boolean aRemove, ItemStack aStack) {
        return ST.use(aPlayer, aRemove, true, aStack, 1L);
    }

    public static boolean use(Entity aPlayer, boolean aRemove, ItemStack aStack, long aAmount) {
        return ST.use(aPlayer, aRemove, true, aStack, aAmount);
    }

    public static boolean use(Entity aPlayer, boolean aRemove, boolean aTriggerEvent, ItemStack aStack, long aAmount) {
        if (UT.Entities.hasInfiniteItems(aPlayer)) {
            return true;
        }
        if (ST.invalid(aStack)) {
            return false;
        }
        if ((long)aStack.stackSize < aAmount) {
            return false;
        }
        aStack.stackSize = (int)((long)aStack.stackSize - aAmount);
        if (!(aPlayer instanceof EntityPlayer)) {
            return true;
        }
        if (aStack.stackSize <= 0) {
            if (aTriggerEvent) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)aPlayer), (ItemStack)aStack);
            }
            if (aRemove) {
                for (int i = 0; i < ((EntityPlayer)aPlayer).inventory.mainInventory.length; ++i) {
                    if (((EntityPlayer)aPlayer).inventory.mainInventory[i] != aStack) continue;
                    ((EntityPlayer)aPlayer).inventory.mainInventory[i] = null;
                    break;
                }
            }
        }
        ST.update(aPlayer);
        return true;
    }

    public static ItemStack[] copyArray(ItemStack ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = ST.copy(aStacks[i]);
        }
        return rStacks;
    }

    public static ItemStack copyFirst(Object ... aStacks) {
        return ST.copy(ST.get(aStacks));
    }

    public static ItemStack copyMeta(long aMeta, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.meta_(ST.copy_(aStack), aMeta);
    }

    public static ItemStack copyAmountAndMeta(long aSize, long aMeta, ItemStack aStack) {
        return aStack == null || ST.item_(aStack) == null ? null : ST.meta_(ST.amount_(aSize, aStack), aMeta);
    }

    public static ItemStack get(Object ... aStacks) {
        for (Object aStack : aStacks) {
            ItemStack rStack;
            if (aStack instanceof ItemStack) {
                if (!ST.valid((ItemStack)aStack)) continue;
                return (ItemStack)aStack;
            }
            if (aStack instanceof Item) {
                return ST.make_((Item)aStack, 1L, 0L);
            }
            if (aStack instanceof Block) {
                return ST.make((Block)aStack, 1L, 0L);
            }
            if (!(aStack instanceof IItemContainer ? ST.valid(rStack = ((IItemContainer)aStack).get(1L, new Object[0])) : aStack instanceof ItemStackContainer && ST.valid(rStack = ((ItemStackContainer)aStack).toStack()))) continue;
            return rStack;
        }
        return null;
    }

    public static boolean hasValid(ItemStack ... aStacks) {
        if (aStacks != null) {
            for (ItemStack aStack : aStacks) {
                if (!ST.valid(aStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStackSet<ItemStackContainer> hashset(ItemStack ... aStacks) {
        return new ItemStackSet<ItemStackContainer>(aStacks);
    }

    public static ArrayListNoNulls<ItemStack> arraylist(ItemStack ... aStacks) {
        return new ArrayListNoNulls<ItemStack>(false, aStacks);
    }

    public static ItemStack[] array(ItemStack ... aStacks) {
        return aStacks;
    }

    public static ItemStack[] array(int aLength) {
        return new ItemStack[aLength];
    }

    public static ItemStack make_(Item aItem, long aSize, long aMeta) {
        return new ItemStack(aItem, UT.Code.bindInt(aSize), (int)UT.Code.bindShort(aMeta));
    }

    public static ItemStack make_(Block aBlock, long aSize, long aMeta) {
        return new ItemStack(aBlock, UT.Code.bindInt(aSize), (int)UT.Code.bindShort(aMeta));
    }

    public static ItemStack make(ModData aModID, String aItem, long aSize) {
        if (!aModID.mLoaded || UT.Code.stringInvalid(aItem) || !CS.GAPI_POST.mStartedPreInit) {
            return null;
        }
        ItemStack rStack = GameRegistry.findItemStack((String)aModID.mID, (String)aItem, (int)((int)aSize));
        if (ST.valid(rStack)) {
            return rStack;
        }
        if (aItem.length() < 5 || aItem.charAt(4) != '.' || !aItem.startsWith("tile")) {
            return null;
        }
        return ST.validate(GameRegistry.findItemStack((String)aModID.mID, (String)aItem.substring(5), (int)((int)aSize)));
    }

    public static ItemStack mkic(String aItem, long aSize) {
        if (UT.Code.stringInvalid(aItem) || !CS.GAPI_POST.mStartedPreInit) {
            return null;
        }
        if (!sIC2ItemMap.containsKey(aItem)) {
            try {
                ItemStack tStack = ST.validate(IC2Items.getItem((String)aItem));
                sIC2ItemMap.put(aItem, tStack);
                if (tStack == null && MD.IC2.mLoaded && !aItem.startsWith("rubber")) {
                    CS.ERR.println(aItem + " is not found in the IC2 Items!");
                }
            }
            catch (Throwable e) {
                sIC2ItemMap.put(aItem, null);
            }
        }
        return ST.amount(aSize, sIC2ItemMap.get(aItem));
    }

    public static ItemStack mkic(String aItem, long aSize, long aMeta) {
        return ST.meta(ST.mkic(aItem, aSize), aMeta);
    }

    public static ItemStack mkic(String aItem, long aSize, ItemStack aReplacement) {
        return ST.get(ST.mkic(aItem, aSize), aReplacement);
    }

    public static ItemStack mkic(String aItem, long aSize, long aMeta, Object aReplacement) {
        return ST.get(ST.meta(ST.mkic(aItem, aSize), aMeta), aReplacement);
    }

    public static ItemStack make(ModData aModID, String aItem, long aSize, long aMeta) {
        return ST.meta(ST.make(aModID, aItem, aSize), aMeta);
    }

    public static ItemStack make(ModData aModID, String aItem, long aSize, long aMeta, Object aReplacement) {
        return ST.get(ST.meta(ST.make(aModID, aItem, aSize), aMeta), aReplacement);
    }

    public static ItemStack make(long aItemID, long aSize, long aMeta) {
        return ST.make(ST.item(aItemID), aSize, aMeta);
    }

    public static ItemStack make(long aItemID, long aSize, long aMeta, NBTTagCompound aNBT) {
        return ST.make(ST.item(aItemID), aSize, aMeta, aNBT);
    }

    public static ItemStack make(long aItemID, long aSize, long aMeta, String aName) {
        return ST.make(ST.item(aItemID), aSize, aMeta, aName);
    }

    public static ItemStack make(long aItemID, long aSize, long aMeta, String aName, NBTTagCompound aNBT) {
        return ST.make(ST.item(aItemID), aSize, aMeta, aName, aNBT);
    }

    public static ItemStack make(Item aItem, long aSize, long aMeta) {
        return aItem == null ? null : ST.make_(aItem, aSize, aMeta);
    }

    public static ItemStack make(Block aBlock, long aSize, long aMeta) {
        return aBlock == null || aBlock == CS.NB ? null : ST.make_(aBlock, aSize, aMeta);
    }

    public static ItemStack make(Item aItem, long aSize, long aMeta, NBTTagCompound aNBT) {
        return aItem == null ? null : ST.nbt(ST.make_(aItem, aSize, aMeta), aNBT);
    }

    public static ItemStack make(Block aBlock, long aSize, long aMeta, NBTTagCompound aNBT) {
        return aBlock == null || aBlock == CS.NB ? null : ST.nbt(ST.make_(aBlock, aSize, aMeta), aNBT);
    }

    public static ItemStack make(Item aItem, long aSize, long aMeta, String aName) {
        return aItem == null ? null : ST.name(ST.make_(aItem, aSize, aMeta), aName);
    }

    public static ItemStack make(Block aBlock, long aSize, long aMeta, String aName) {
        return aBlock == null || aBlock == CS.NB ? null : ST.name(ST.make_(aBlock, aSize, aMeta), aName);
    }

    public static ItemStack make(Item aItem, long aSize, long aMeta, String aName, NBTTagCompound aNBT) {
        return aItem == null ? null : ST.name(ST.nbt(ST.make_(aItem, aSize, aMeta), aNBT), aName);
    }

    public static ItemStack make(Block aBlock, long aSize, long aMeta, String aName, NBTTagCompound aNBT) {
        return aBlock == null || aBlock == CS.NB ? null : ST.name(ST.nbt(ST.make_(aBlock, aSize, aMeta), aNBT), aName);
    }

    public static ItemStack make(ItemStack aStack, NBTTagCompound aNBT) {
        return aStack == null ? null : ST.nbt_(aStack.copy(), aNBT);
    }

    public static ItemStack make(ItemStack aStack, String aName) {
        return aStack == null ? null : ST.name(aStack.copy(), aName);
    }

    public static ItemStack make(ItemStack aStack, String aName, NBTTagCompound aNBT) {
        return aStack == null ? null : ST.name(ST.nbt_(aStack.copy(), aNBT), aName);
    }

    public static ItemStack make(ItemStackContainer aStack, NBTTagCompound aNBT) {
        return ST.nbt(aStack.toStack(), aNBT);
    }

    public static ItemStack make(ItemStackContainer aStack, String aName) {
        return ST.name(aStack.toStack(), aName);
    }

    public static ItemStack make(ItemStackContainer aStack, String aName, NBTTagCompound aNBT) {
        return ST.name(ST.nbt(aStack.toStack(), aNBT), aName);
    }

    public static EntityItem place(World aWorld, double aX, double aY, double aZ, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, double aX, double aY, double aZ, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, double aX, double aY, double aZ, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, double aX, double aY, double aZ, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, double aX, double aY, double aZ, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, double aX, double aY, double aZ, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, double aX, double aY, double aZ, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, double aX, double aY, double aZ, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, double aX, double aY, double aZ, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, double aX, double aY, double aZ, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aX, aY, aZ, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem entity(World aWorld, double aX, double aY, double aZ, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aX, aY, aZ, rStack);
    }

    public static EntityItem entity(World aWorld, double aX, double aY, double aZ, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aX, aY, aZ, rStack);
    }

    public static EntityItem entity(World aWorld, double aX, double aY, double aZ, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aX, aY, aZ, rStack);
    }

    public static EntityItem entity(World aWorld, double aX, double aY, double aZ, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aX, aY, aZ, rStack);
    }

    public static EntityItem entity(World aWorld, double aX, double aY, double aZ, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aX, aY, aZ, rStack);
    }

    public static EntityItem entity_(World aWorld, double aX, double aY, double aZ, ItemStack aStack) {
        return new EntityItem(aWorld, aX, aY, aZ, ST.update_(aStack, aWorld, UT.Code.roundDown(aX), UT.Code.roundDown(aY), UT.Code.roundDown(aZ)));
    }

    public static EntityItem place(Entity aEntity, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(Entity aEntity, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(Entity aEntity, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(Entity aEntity, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(Entity aEntity, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(Entity aEntity, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(Entity aEntity, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(Entity aEntity, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(Entity aEntity, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(Entity aEntity, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aEntity, rStack);
        return aEntity.worldObj.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem entity(Entity aEntity, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aEntity, rStack);
    }

    public static EntityItem entity(Entity aEntity, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aEntity, rStack);
    }

    public static EntityItem entity(Entity aEntity, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aEntity, rStack);
    }

    public static EntityItem entity(Entity aEntity, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aEntity, rStack);
    }

    public static EntityItem entity(Entity aEntity, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aEntity, rStack);
    }

    public static EntityItem entity_(Entity aEntity, ItemStack aStack) {
        return new EntityItem(aEntity.worldObj, aEntity.posX, aEntity.posY, aEntity.posZ, ST.update_(aStack, aEntity));
    }

    public static EntityItem place(World aWorld, ChunkCoordinates aCoords, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, ChunkCoordinates aCoords, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, ChunkCoordinates aCoords, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, ChunkCoordinates aCoords, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem place(World aWorld, ChunkCoordinates aCoords, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        rEntity.motionZ = 0.0;
        rEntity.motionY = 0.0;
        rEntity.motionX = 0.0;
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, ChunkCoordinates aCoords, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, ChunkCoordinates aCoords, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, ChunkCoordinates aCoords, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, ChunkCoordinates aCoords, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem drop(World aWorld, ChunkCoordinates aCoords, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        EntityItem rEntity = ST.entity_(aWorld, aCoords, rStack);
        return aWorld.spawnEntityInWorld((Entity)rEntity) ? rEntity : null;
    }

    public static EntityItem entity(World aWorld, ChunkCoordinates aCoords, ModData aModID, String aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aModID, aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aCoords, rStack);
    }

    public static EntityItem entity(World aWorld, ChunkCoordinates aCoords, Item aItem, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aItem, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aCoords, rStack);
    }

    public static EntityItem entity(World aWorld, ChunkCoordinates aCoords, Block aBlock, long aSize, long aMeta) {
        ItemStack rStack = ST.make(aBlock, aSize, aMeta);
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aCoords, rStack);
    }

    public static EntityItem entity(World aWorld, ChunkCoordinates aCoords, ItemStackContainer aStack) {
        ItemStack rStack = aStack.toStack();
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aCoords, rStack);
    }

    public static EntityItem entity(World aWorld, ChunkCoordinates aCoords, ItemStack aStack) {
        ItemStack rStack = aStack;
        if (ST.invalid(rStack)) {
            return null;
        }
        return ST.entity_(aWorld, aCoords, rStack);
    }

    public static EntityItem entity_(World aWorld, ChunkCoordinates aCoords, ItemStack aStack) {
        return new EntityItem(aWorld, (double)aCoords.posX + 0.5, (double)aCoords.posY + 0.5, (double)aCoords.posZ + 0.5, ST.update_(aStack, aWorld, aCoords.posX, aCoords.posY, aCoords.posZ));
    }

    public static int move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo) {
        return ST.move(aFrom, aTo, null, false, false, false, true, 64, 1, 64, 1);
    }

    public static int move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aIgnoreSideTo, boolean aInvertFilter, boolean aEjectItems, int aMaxSize, int aMinSize, int aMaxMove, int aMinMove) {
        int[] aSlotsFrom;
        if (!(aFrom.mTileEntity instanceof IInventory)) {
            return 0;
        }
        aFrom = ST.getPotentialDoubleChest(aFrom);
        int[] nArray = aSlotsFrom = !aIgnoreSideFrom && aFrom.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aFrom.mTileEntity).getAccessibleSlotsFromSide((int)aFrom.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aFrom.mTileEntity).getSizeInventory());
        if (!(aTo.mTileEntity instanceof IInventory)) {
            return ST.put(aFrom, aSlotsFrom, aTo, aFilter, aIgnoreSideFrom, aInvertFilter, aEjectItems, aMaxMove, aMinMove);
        }
        aTo = ST.getPotentialDoubleChest(aTo);
        int[] aSlotsTo = !aIgnoreSideTo && aTo.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aTo.mTileEntity).getAccessibleSlotsFromSide((int)aTo.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aTo.mTileEntity).getSizeInventory());
        for (int aSlotFrom : aSlotsFrom) {
            ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
            if (aStackFrom == null || aStackFrom.stackSize < aMinMove || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) continue;
            int[] nArray2 = aSlotsTo;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                ItemStack aStackTo;
                int aSlotTo;
                int tMovable = Math.min(aMaxMove, ST.canPut((IInventory)aTo.mTileEntity, aIgnoreSideTo ? (byte)6 : (byte)aTo.mSideOfTileEntity, aTo.mSideOfTileEntity, aSlotTo = nArray2[i], aStackFrom, aStackTo = ((IInventory)aTo.mTileEntity).getStackInSlot(aSlotTo), Math.min(aMaxSize, aStackFrom.getMaxStackSize())));
                if (tMovable < aMinMove || tMovable + (aStackTo == null ? 0 : aStackTo.stackSize) < aMinSize) continue;
                return ST.move_((IInventory)aFrom.mTileEntity, (IInventory)aTo.mTileEntity, aStackFrom, aStackTo, aSlotFrom, aSlotTo, tMovable);
            }
        }
        return 0;
    }

    public static int moveAll(DelegatorTileEntity aFrom, DelegatorTileEntity aTo) {
        return ST.moveAll(aFrom, aTo, null, false, false, false, true, 64, 1, 64, 1);
    }

    public static int moveAll(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aIgnoreSideTo, boolean aInvertFilter, boolean aEjectItems, int aMaxSize, int aMinSize, int aMaxMove, int aMinMove) {
        int[] aSlotsFrom;
        if (!(aFrom.mTileEntity instanceof IInventory)) {
            return 0;
        }
        aFrom = ST.getPotentialDoubleChest(aFrom);
        int[] nArray = aSlotsFrom = !aIgnoreSideFrom && aFrom.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aFrom.mTileEntity).getAccessibleSlotsFromSide((int)aFrom.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aFrom.mTileEntity).getSizeInventory());
        if (!(aTo.mTileEntity instanceof IInventory)) {
            return ST.put(aFrom, aSlotsFrom, aTo, aFilter, aIgnoreSideFrom, aInvertFilter, aEjectItems, aMaxMove, aMinMove);
        }
        aTo = ST.getPotentialDoubleChest(aTo);
        int[] aSlotsTo = !aIgnoreSideTo && aTo.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aTo.mTileEntity).getAccessibleSlotsFromSide((int)aTo.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aTo.mTileEntity).getSizeInventory());
        int rMoved = 0;
        block0: for (int aSlotFrom : aSlotsFrom) {
            ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
            if (aStackFrom == null || aStackFrom.stackSize < aMinMove || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) continue;
            int[] nArray2 = aSlotsTo;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                ItemStack aStackTo;
                int aSlotTo;
                int tMovable = Math.min(aMaxMove, ST.canPut((IInventory)aTo.mTileEntity, aIgnoreSideTo ? (byte)6 : (byte)aTo.mSideOfTileEntity, aTo.mSideOfTileEntity, aSlotTo = nArray2[i], aStackFrom, aStackTo = ((IInventory)aTo.mTileEntity).getStackInSlot(aSlotTo), Math.min(aMaxSize, aStackFrom.getMaxStackSize())));
                if (tMovable < aMinMove || tMovable + (aStackTo == null ? 0 : aStackTo.stackSize) < aMinSize) continue;
                rMoved += ST.move_((IInventory)aFrom.mTileEntity, (IInventory)aTo.mTileEntity, aStackFrom, aStackTo, aSlotFrom, aSlotTo, tMovable);
                aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                if (ST.size(aStackFrom) < 1) continue block0;
            }
        }
        return rMoved;
    }

    public static int moveFrom(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotFrom) {
        return ST.moveFrom(aFrom, aTo, aSlotFrom, null, false, false, false, true, 64, 1, 64, 1);
    }

    public static int moveFrom(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotFrom, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aIgnoreSideTo, boolean aInvertFilter, boolean aEjectItems, int aMaxSize, int aMinSize, int aMaxMove, int aMinMove) {
        if (aSlotFrom < 0) {
            return 0;
        }
        if (!(aFrom.mTileEntity instanceof IInventory)) {
            return 0;
        }
        aFrom = ST.getPotentialDoubleChest(aFrom);
        if (aSlotFrom >= ((IInventory)aFrom.mTileEntity).getSizeInventory()) {
            return 0;
        }
        if (!(aTo.mTileEntity instanceof IInventory)) {
            return ST.put(aFrom, new int[]{aSlotFrom}, aTo, aFilter, aIgnoreSideFrom, aInvertFilter, aEjectItems, aMaxMove, aMinMove);
        }
        aTo = ST.getPotentialDoubleChest(aTo);
        int[] aSlotsTo = !aIgnoreSideTo && aTo.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aTo.mTileEntity).getAccessibleSlotsFromSide((int)aTo.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aTo.mTileEntity).getSizeInventory());
        ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
        if (aStackFrom == null || aStackFrom.stackSize < aMinMove || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) {
            return 0;
        }
        int[] nArray = aSlotsTo;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            ItemStack aStackTo;
            int aSlotTo;
            int tMovable = Math.min(aMaxMove, ST.canPut((IInventory)aTo.mTileEntity, aIgnoreSideTo ? (byte)6 : (byte)aTo.mSideOfTileEntity, aTo.mSideOfTileEntity, aSlotTo = nArray[i], aStackFrom, aStackTo = ((IInventory)aTo.mTileEntity).getStackInSlot(aSlotTo), Math.min(aMaxSize, aStackFrom.getMaxStackSize())));
            if (tMovable < aMinMove || tMovable + (aStackTo == null ? 0 : aStackTo.stackSize) < aMinSize) continue;
            return ST.move_((IInventory)aFrom.mTileEntity, (IInventory)aTo.mTileEntity, aStackFrom, aStackTo, aSlotFrom, aSlotTo, tMovable);
        }
        return 0;
    }

    public static int moveTo(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotTo) {
        return ST.moveTo(aFrom, aTo, aSlotTo, null, false, false, false, true, 64, 1, 64, 1);
    }

    public static int moveTo(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotTo, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aIgnoreSideTo, boolean aInvertFilter, boolean aEjectItems, int aMaxSize, int aMinSize, int aMaxMove, int aMinMove) {
        int[] aSlotsFrom;
        if (aSlotTo < 0) {
            return 0;
        }
        if (!(aFrom.mTileEntity instanceof IInventory)) {
            return 0;
        }
        aFrom = ST.getPotentialDoubleChest(aFrom);
        int[] nArray = aSlotsFrom = !aIgnoreSideFrom && aFrom.mTileEntity instanceof ISidedInventory ? ((ISidedInventory)aFrom.mTileEntity).getAccessibleSlotsFromSide((int)aFrom.mSideOfTileEntity) : UT.Code.getAscendingArray(((IInventory)aFrom.mTileEntity).getSizeInventory());
        if (!(aTo.mTileEntity instanceof IInventory)) {
            return ST.put(aFrom, aSlotsFrom, aTo, aFilter, aIgnoreSideFrom, aInvertFilter, aEjectItems, aMaxMove, aMinMove);
        }
        aTo = ST.getPotentialDoubleChest(aTo);
        if (aSlotTo >= ((IInventory)aTo.mTileEntity).getSizeInventory()) {
            return 0;
        }
        for (int aSlotFrom : aSlotsFrom) {
            ItemStack aStackTo;
            int tMovable;
            ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
            if (aStackFrom == null || aStackFrom.stackSize < aMinMove || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom) || (tMovable = Math.min(aMaxMove, ST.canPut((IInventory)aTo.mTileEntity, aIgnoreSideTo ? (byte)6 : (byte)aTo.mSideOfTileEntity, aTo.mSideOfTileEntity, aSlotTo, aStackFrom, aStackTo = ((IInventory)aTo.mTileEntity).getStackInSlot(aSlotTo), Math.min(aMaxSize, aStackFrom.getMaxStackSize())))) < aMinMove || tMovable + (aStackTo == null ? 0 : aStackTo.stackSize) < aMinSize) continue;
            return ST.move_((IInventory)aFrom.mTileEntity, (IInventory)aTo.mTileEntity, aStackFrom, aStackTo, aSlotFrom, aSlotTo, tMovable);
        }
        return 0;
    }

    public static int move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotFrom, int aSlotTo) {
        return ST.move(aFrom, aTo, aSlotFrom, aSlotTo, null, false, false, false, true, 64, 1, 64, 1);
    }

    public static int move(DelegatorTileEntity aFrom, DelegatorTileEntity aTo, int aSlotFrom, int aSlotTo, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aIgnoreSideTo, boolean aInvertFilter, boolean aEjectItems, int aMaxSize, int aMinSize, int aMaxMove, int aMinMove) {
        if (aSlotFrom < 0 || aSlotTo < 0) {
            return 0;
        }
        if (aFrom.mTileEntity instanceof IInventory) {
            aFrom = ST.getPotentialDoubleChest(aFrom);
            if (aSlotFrom >= ((IInventory)aFrom.mTileEntity).getSizeInventory()) {
                return 0;
            }
            if (aTo.mTileEntity instanceof IInventory) {
                ItemStack aStackTo;
                aTo = ST.getPotentialDoubleChest(aTo);
                if (aSlotTo >= ((IInventory)aTo.mTileEntity).getSizeInventory()) {
                    return 0;
                }
                ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                if (aStackFrom == null || aStackFrom.stackSize < aMinMove || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) {
                    return 0;
                }
                int tMovable = Math.min(aMaxMove, ST.canPut((IInventory)aTo.mTileEntity, aIgnoreSideTo ? (byte)6 : (byte)aTo.mSideOfTileEntity, aTo.mSideOfTileEntity, aSlotTo, aStackFrom, aStackTo = ((IInventory)aTo.mTileEntity).getStackInSlot(aSlotTo), Math.min(aMaxSize, aStackFrom.getMaxStackSize())));
                if (tMovable < aMinMove || tMovable + (aStackTo == null ? 0 : aStackTo.stackSize) < aMinSize) {
                    return 0;
                }
                return ST.move_((IInventory)aFrom.mTileEntity, (IInventory)aTo.mTileEntity, aStackFrom, aStackTo, aSlotFrom, aSlotTo, tMovable);
            }
            return ST.put(aFrom, new int[]{aSlotFrom}, aTo, aFilter, aIgnoreSideFrom, aInvertFilter, aEjectItems, Math.min(aMaxSize, aMaxMove), Math.max(aMinSize, aMinMove));
        }
        return 0;
    }

    public static int move(IInventory aInv, int aSlotFrom, int aSlotTo) {
        if (aSlotFrom == aSlotTo) {
            return 0;
        }
        ItemStack aStackFrom = aInv.getStackInSlot(aSlotFrom);
        ItemStack aStackTo = aInv.getStackInSlot(aSlotTo);
        return aStackFrom != null && (aStackTo == null || ST.equal_(aStackFrom, aStackTo, false)) ? ST.move_(aInv, aStackFrom, aStackTo, aSlotFrom, aSlotTo, Math.min(aStackFrom.stackSize, Math.min(aInv.getInventoryStackLimit(), aStackTo == null ? aStackFrom.getMaxStackSize() : aStackTo.getMaxStackSize() - aStackTo.stackSize))) : 0;
    }

    public static int move(IInventory aInv, int aSlotFrom, int aSlotTo, int aCount) {
        return ST.move(aInv, aInv.getStackInSlot(aSlotFrom), aInv.getStackInSlot(aSlotTo), aSlotFrom, aSlotTo, aCount);
    }

    public static int move(IInventory aInv, ItemStack aStackFrom, ItemStack aStackTo, int aSlotFrom, int aSlotTo, int aCount) {
        return aStackFrom != null && (aStackTo == null || ST.equal_(aStackFrom, aStackTo, false)) ? ST.move_(aInv, aStackFrom, aStackTo, aSlotFrom, aSlotTo, aCount) : 0;
    }

    public static int move_(IInventory aInv, ItemStack aStackFrom, ItemStack aStackTo, int aSlotFrom, int aSlotTo, int aCount) {
        if ((aCount = Math.min(aCount, aStackFrom.stackSize)) < 0) {
            return 0;
        }
        ItemStack tStack = aInv.decrStackSize(aSlotFrom, aCount);
        if (tStack == null || tStack.stackSize <= 0) {
            return 0;
        }
        aCount = Math.min(aCount, tStack.stackSize);
        if (aStackTo == null) {
            aInv.setInventorySlotContents(aSlotTo, ST.amount(aCount, aStackFrom));
        } else {
            aStackTo.stackSize += aCount;
        }
        aInv.markDirty();
        WD.mark(aInv);
        return aCount;
    }

    public static int move(IInventory aFrom, IInventory aTo, int aSlotFrom, int aSlotTo) {
        ItemStack aStackFrom = aFrom.getStackInSlot(aSlotFrom);
        ItemStack aStackTo = aTo.getStackInSlot(aSlotTo);
        return aStackFrom != null && (aStackTo == null || ST.equal_(aStackFrom, aStackTo, false)) ? ST.move_(aFrom, aTo, aStackFrom, aStackTo, aSlotFrom, aSlotTo, Math.min(aStackFrom.stackSize, Math.min(aTo.getInventoryStackLimit(), aStackTo == null ? aStackFrom.getMaxStackSize() : aStackTo.getMaxStackSize() - aStackTo.stackSize))) : 0;
    }

    public static int move(IInventory aFrom, IInventory aTo, int aSlotFrom, int aSlotTo, int aCount) {
        return ST.move(aFrom, aTo, aFrom.getStackInSlot(aSlotFrom), aTo.getStackInSlot(aSlotTo), aSlotFrom, aSlotTo, aCount);
    }

    public static int move(IInventory aFrom, IInventory aTo, ItemStack aStackFrom, ItemStack aStackTo, int aSlotFrom, int aSlotTo, int aCount) {
        return aStackFrom != null && (aStackTo == null || ST.equal_(aStackFrom, aStackTo, false)) ? ST.move_(aFrom, aTo, aStackFrom, aStackTo, aSlotFrom, aSlotTo, aCount) : 0;
    }

    public static int move_(IInventory aFrom, IInventory aTo, ItemStack aStackFrom, ItemStack aStackTo, int aSlotFrom, int aSlotTo, int aCount) {
        if (aStackFrom == aStackTo) {
            return 0;
        }
        if (aFrom == aTo && aSlotFrom == aSlotTo) {
            return 0;
        }
        if ((aCount = Math.min(aCount, aStackFrom.stackSize)) < 0) {
            return 0;
        }
        ItemStack tStack = aFrom.decrStackSize(aSlotFrom, aCount);
        if (tStack == null || tStack.stackSize <= 0) {
            return 0;
        }
        aCount = Math.min(aCount, tStack.stackSize);
        if (aStackTo == null) {
            aTo.setInventorySlotContents(aSlotTo, ST.amount(aCount, aStackFrom));
        } else {
            aStackTo.stackSize += aCount;
        }
        aFrom.markDirty();
        aTo.markDirty();
        WD.mark(aFrom);
        WD.mark(aTo);
        return aCount;
    }

    public static DelegatorTileEntity getPotentialDoubleChest(DelegatorTileEntity aPotentialChest) {
        if (aPotentialChest.mTileEntity instanceof TileEntityChest) {
            TileEntity tAdjacentChest;
            Block aChestBlock = aPotentialChest.getBlock();
            if (aPotentialChest.getBlockAtSide((byte)4) == aChestBlock && (tAdjacentChest = aPotentialChest.getTileEntityAtSideAndDistance((byte)4, 1)) instanceof TileEntityChest) {
                return new DelegatorTileEntity<InventoryLargeChest>(new InventoryLargeChest("fucking mojang hax", (IInventory)tAdjacentChest, (IInventory)aPotentialChest.mTileEntity), aPotentialChest);
            }
            if (aPotentialChest.getBlockAtSide((byte)5) == aChestBlock && (tAdjacentChest = aPotentialChest.getTileEntityAtSideAndDistance((byte)5, 1)) instanceof TileEntityChest) {
                return new DelegatorTileEntity<InventoryLargeChest>(new InventoryLargeChest("fucking mojang hax", (IInventory)aPotentialChest.mTileEntity, (IInventory)tAdjacentChest), aPotentialChest);
            }
            if (aPotentialChest.getBlockAtSide((byte)2) == aChestBlock && (tAdjacentChest = aPotentialChest.getTileEntityAtSideAndDistance((byte)2, 1)) instanceof TileEntityChest) {
                return new DelegatorTileEntity<InventoryLargeChest>(new InventoryLargeChest("fucking mojang hax", (IInventory)tAdjacentChest, (IInventory)aPotentialChest.mTileEntity), aPotentialChest);
            }
            if (aPotentialChest.getBlockAtSide((byte)3) == aChestBlock && (tAdjacentChest = aPotentialChest.getTileEntityAtSideAndDistance((byte)3, 1)) instanceof TileEntityChest) {
                return new DelegatorTileEntity<InventoryLargeChest>(new InventoryLargeChest("fucking mojang hax", (IInventory)aPotentialChest.mTileEntity, (IInventory)tAdjacentChest), aPotentialChest);
            }
        }
        return aPotentialChest;
    }

    public static boolean canConnect(DelegatorTileEntity aDelegator) {
        if (aDelegator.mTileEntity == null) {
            return false;
        }
        if (TE_PIPES && aDelegator.mTileEntity instanceof IItemDuct) {
            return true;
        }
        if (BC_PIPES && aDelegator.mTileEntity instanceof IInjectable) {
            return ((IInjectable)aDelegator.mTileEntity).canInjectItems(aDelegator.getForgeSideOfTileEntity());
        }
        if (aDelegator.mTileEntity instanceof ITileEntityCanDelegate && ((ITileEntityCanDelegate)aDelegator.mTileEntity).isExtender(aDelegator.mSideOfTileEntity)) {
            return true;
        }
        return aDelegator.mTileEntity instanceof IInventory && ((IInventory)aDelegator.mTileEntity).getSizeInventory() > 0;
    }

    @Deprecated
    public static boolean canTake(IInventory aFrom, byte aSideFrom, int aSlotFrom, ItemStack aStackFrom) {
        return ST.canTake(aFrom, aSideFrom, aSideFrom, aSlotFrom, aStackFrom);
    }

    @Deprecated
    public static boolean canTake_(ISidedInventory aFrom, byte aSideFrom, int aSlotFrom, ItemStack aStackFrom) {
        return ST.canTake((IInventory)aFrom, aSideFrom, aSideFrom, aSlotFrom, aStackFrom);
    }

    public static boolean canTake(IInventory aFrom, byte aSideFrom, byte aSideFallbackFrom, int aSlotFrom, ItemStack aStackFrom) {
        if (aFrom instanceof ISidedInventory) {
            if (CS.SIDES_VALID[aSideFrom]) {
                return ((ISidedInventory)aFrom).canExtractItem(aSlotFrom, aStackFrom, (int)aSideFrom);
            }
            for (byte tSideFrom : CS.ALL_SIDES_VALID) {
                if (!((ISidedInventory)aFrom).canExtractItem(aSlotFrom, aStackFrom, (int)tSideFrom)) continue;
                ((ISidedInventory)aFrom).canExtractItem(aSlotFrom, aStackFrom, (int)aSideFallbackFrom);
                return true;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static int canPut(IInventory aTo, byte aSideTo, int aSlotTo, ItemStack aStackFrom) {
        return ST.canPut(aTo, aSideTo, aSlotTo, aStackFrom, aStackFrom.getMaxStackSize());
    }

    @Deprecated
    public static int canPut(IInventory aTo, byte aSideTo, int aSlotTo, ItemStack aStackFrom, int aMaxSize) {
        return ST.canPut(aTo, aSideTo, aSlotTo, aStackFrom, aTo.getStackInSlot(aSlotTo));
    }

    @Deprecated
    public static int canPut(IInventory aTo, byte aSideTo, int aSlotTo, ItemStack aStackFrom, ItemStack aStackTo) {
        return ST.canPut(aTo, aSideTo, aSlotTo, aStackFrom, aStackTo, aStackFrom.getMaxStackSize());
    }

    @Deprecated
    public static int canPut(IInventory aTo, byte aSideTo, int aSlotTo, ItemStack aStackFrom, ItemStack aStackTo, int aMaxSize) {
        return ST.canPut(aTo, aSideTo, aSideTo, aSlotTo, aStackFrom, aStackTo, aMaxSize);
    }

    public static int canPut(IInventory aTo, byte aSideTo, byte aSideFallbackTo, int aSlotTo, ItemStack aStackFrom) {
        return ST.canPut(aTo, aSideTo, aSideFallbackTo, aSlotTo, aStackFrom, aStackFrom.getMaxStackSize());
    }

    public static int canPut(IInventory aTo, byte aSideTo, byte aSideFallbackTo, int aSlotTo, ItemStack aStackFrom, int aMaxSize) {
        return ST.canPut(aTo, aSideTo, aSideFallbackTo, aSlotTo, aStackFrom, aTo.getStackInSlot(aSlotTo));
    }

    public static int canPut(IInventory aTo, byte aSideTo, byte aSideFallbackTo, int aSlotTo, ItemStack aStackFrom, ItemStack aStackTo) {
        return ST.canPut(aTo, aSideTo, aSideFallbackTo, aSlotTo, aStackFrom, aStackTo, aStackFrom.getMaxStackSize());
    }

    public static int canPut(IInventory aTo, byte aSideTo, byte aSideFallbackTo, int aSlotTo, ItemStack aStackFrom, ItemStack aStackTo, int aMaxSize) {
        int rMaxMove;
        int n = aStackTo == null ? Math.min(aMaxSize, aTo.getInventoryStackLimit()) : (rMaxMove = ST.equal_(aStackTo, aStackFrom, false) ? Math.min(aMaxSize, aTo.getInventoryStackLimit()) - aStackTo.stackSize : 0);
        if (rMaxMove <= 0 || !aTo.isItemValidForSlot(aSlotTo, aStackFrom)) {
            return 0;
        }
        if (!(aTo instanceof ISidedInventory)) {
            return rMaxMove;
        }
        if (CS.SIDES_VALID[aSideTo]) {
            return ((ISidedInventory)aTo).canInsertItem(aSlotTo, aStackFrom, (int)aSideTo) ? rMaxMove : 0;
        }
        for (byte tSideTo : CS.ALL_SIDES_VALID) {
            if (!((ISidedInventory)aTo).canInsertItem(aSlotTo, aStackFrom, (int)tSideTo)) continue;
            ((ISidedInventory)aTo).canInsertItem(aSlotTo, aStackFrom, (int)aSideFallbackTo);
            return rMaxMove;
        }
        return 0;
    }

    public static int put(DelegatorTileEntity<IInventory> aFrom, int[] aSlotsFrom, DelegatorTileEntity aTo, ItemStackSet<ItemStackContainer> aFilter, boolean aIgnoreSideFrom, boolean aInvertFilter, boolean aEjectItems, int aMaxMove, int aMinMove) {
        block7: {
            Block aBlock;
            block8: {
                if (aTo.mTileEntity != null) {
                    if (TE_PIPES && aTo.mTileEntity instanceof IItemDuct) {
                        for (int aSlotFrom : aSlotsFrom) {
                            ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                            if (aStackFrom == null || aMinMove > aStackFrom.stackSize || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) continue;
                            ItemStack tStackMoved = ST.amount(Math.min(aStackFrom.stackSize, aMaxMove), aStackFrom);
                            ItemStack rStackMoved = ((IItemDuct)aTo.mTileEntity).insertItem(aTo.getForgeSideOfTileEntity(), ST.copy(tStackMoved));
                            int rMoved = tStackMoved.stackSize - (rStackMoved == null ? 0 : rStackMoved.stackSize);
                            if (rMoved <= 0) continue;
                            ((IInventory)aFrom.mTileEntity).decrStackSize(aSlotFrom, rMoved);
                            ((IInventory)aFrom.mTileEntity).markDirty();
                            WD.mark(aFrom);
                            WD.mark(aTo);
                            return rMoved;
                        }
                        return 0;
                    }
                    if (BC_PIPES && aTo.mTileEntity instanceof IInjectable) {
                        for (int aSlotFrom : aSlotsFrom) {
                            ItemStack tStackMoved;
                            int rMoved;
                            ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                            if (aStackFrom == null || aMinMove > aStackFrom.stackSize || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom) || (rMoved = ((IInjectable)aTo.mTileEntity).injectItem(ST.copy(tStackMoved = ST.amount(Math.min(aStackFrom.stackSize, aMaxMove), aStackFrom)), false, aTo.getForgeSideOfTileEntity(), null)) < aMinMove) continue;
                            rMoved = ((IInjectable)aTo.mTileEntity).injectItem(ST.amount(rMoved, tStackMoved), true, aTo.getForgeSideOfTileEntity(), null);
                            ((IInventory)aFrom.mTileEntity).decrStackSize(aSlotFrom, rMoved);
                            ((IInventory)aFrom.mTileEntity).markDirty();
                            WD.mark(aFrom);
                            WD.mark(aTo);
                            return rMoved;
                        }
                        return 0;
                    }
                }
                if ((aBlock = aTo.getBlock()) instanceof BlockRailBase) break block7;
                if (aBlock.getMaterial() != Material.lava && !(aBlock instanceof BlockFire) && (!ST.invalid(aBlock) || aTo.mY >= 1)) break block8;
                for (int aSlotFrom : aSlotsFrom) {
                    ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                    if (aStackFrom == null || aMinMove > aStackFrom.stackSize || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) continue;
                    int rMoved = CS.GarbageGT.trash(ST.amount(Math.min(aStackFrom.stackSize, aMaxMove), aStackFrom));
                    ((IInventory)aFrom.mTileEntity).decrStackSize(aSlotFrom, rMoved);
                    ((IInventory)aFrom.mTileEntity).markDirty();
                    WD.mark(aFrom);
                    return rMoved;
                }
                break block7;
            }
            if (WD.hasCollide(aTo.mWorld, aTo.mX, aTo.mY, aTo.mZ, aBlock) || !aEjectItems) break block7;
            for (int aSlotFrom : aSlotsFrom) {
                ItemStack aStackFrom = ((IInventory)aFrom.mTileEntity).getStackInSlot(aSlotFrom);
                if (aStackFrom == null || aMinMove > aStackFrom.stackSize || aFilter != null && aFilter.contains(aStackFrom, true) == aInvertFilter || !ST.canTake((IInventory)aFrom.mTileEntity, aIgnoreSideFrom ? (byte)6 : (byte)aFrom.mSideOfTileEntity, aFrom.mSideOfTileEntity, aSlotFrom, aStackFrom)) continue;
                ItemStack tStack = ST.amount(Math.min(aStackFrom.stackSize, aMaxMove), aStackFrom);
                ST.place(aTo.mWorld, (double)aTo.mX + 0.5, (double)aTo.mY + 0.5, (double)aTo.mZ + 0.5, tStack);
                ((IInventory)aFrom.mTileEntity).decrStackSize(aSlotFrom, tStack.stackSize);
                ((IInventory)aFrom.mTileEntity).markDirty();
                WD.mark(aFrom);
                return tStack.stackSize;
            }
        }
        return 0;
    }

    public static ItemStack emptySlot() {
        return IL.Empty_Slot.get(0L, new Object[0]);
    }

    public static ItemStack tag(long aNumber) {
        return IL.Circuit_Selector.getWithDamage(0L, aNumber, new Object[0]);
    }

    public static ItemStack skull(Entity aPlayer) {
        return ST.skull(aPlayer == null ? "" : aPlayer.getCommandSenderName());
    }

    public static ItemStack skull(String aPlayer) {
        return ST.make(Items.skull, 1L, 3L, UT.Code.stringValid(aPlayer) ? UT.NBT.makeString("SkullOwner", aPlayer) : null);
    }

    public static ItemStack book(String aMapping) {
        return UT.Books.getBookWithTitle(aMapping);
    }

    public static ItemStack book(String aMapping, ItemStack aBook) {
        return UT.Books.getBookWithTitle(aMapping, aBook);
    }

    public static boolean debug(ItemStack aStack) {
        return CS.ItemsGT.DEBUG_ITEMS.contains(aStack, true);
    }

    public static boolean instaharvest(Block aBlock) {
        return ST.torch(aBlock) || CS.BlocksGT.instaharvest.contains(aBlock);
    }

    public static boolean instaharvest(Block aBlock, long aMeta) {
        return ST.torch(aBlock, aMeta) || CS.BlocksGT.instaharvest.contains(aBlock);
    }

    public static boolean torch(Block aBlock) {
        return ST.torch(aBlock, 1L);
    }

    public static boolean torch(Block aBlock, long aMeta) {
        if (IL.TFC_Torch.equal(aBlock) || IL.NePl_Torch.equal(aBlock) || IL.GC_Torch_Glowstone.equal(aBlock) || IL.AETHER_Torch_Ambrosium.equal(aBlock) || IL.AE_Torch_Quartz.equal(aBlock) || IL.TF_Firefly_Jar.equal(aBlock) || IL.TF_Firefly.equal(aBlock) || aMeta == 1L && IL.TC_Block_Air.equal(aBlock)) {
            return true;
        }
        return aBlock instanceof BlockTorch && !(aBlock instanceof BlockRedstoneTorch);
    }

    public static boolean torch(ItemStack aStack) {
        return IL.TC_Nitor.equal(aStack, false, true) || ST.torch(ST.block(aStack), ST.meta(aStack));
    }

    public static boolean ammo(ItemStack aStack) {
        if (CS.ItemsGT.AMMO_ITEMS.contains(aStack, true)) {
            return true;
        }
        OreDictItemData tData = OM.anydata(aStack);
        return tData != null && tData.nonemptyData() && tData.mPrefix.contains(TD.Prefix.AMMO_ALIKE);
    }

    public static boolean nonautoinsert(ItemStack aStack) {
        if (CS.ItemsGT.NON_AUTO_INSERT_ITEMS.contains(aStack, true) || ST.torch(aStack)) {
            return true;
        }
        OreDictItemData tData = OM.anydata(aStack);
        return tData != null && tData.nonemptyData() && tData.mPrefix.contains(TD.Prefix.AMMO_ALIKE);
    }

    public static boolean listed(Collection<ItemStack> aList, ItemStack aStack, boolean aTrueIfListEmpty, boolean aInvertFilter) {
        if (aStack == null || aStack.stackSize < 1) {
            return false;
        }
        if (aList == null) {
            return aTrueIfListEmpty;
        }
        while (aList.contains(null)) {
            aList.remove(null);
        }
        if (aList.size() < 1) {
            return aTrueIfListEmpty;
        }
        Iterator<ItemStack> tIterator = aList.iterator();
        ItemStack tStack = null;
        while (tIterator.hasNext()) {
            tStack = tIterator.next();
            if (tStack == null || !ST.equal(aStack, tStack)) continue;
            return !aInvertFilter;
        }
        return aInvertFilter;
    }

    public static boolean ingredable(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return false;
        }
        if (ST.item_(aStack) instanceof IItemGTContainerTool) {
            return false;
        }
        if (ST.item_(aStack) instanceof IFluidContainerItem && ((IFluidContainerItem)ST.item_(aStack)).getCapacity(aStack) > 0) {
            return false;
        }
        if (ST.item_(aStack).hasContainerItem(aStack)) {
            return false;
        }
        if (CS.ItemsGT.CONTAINER_DURABILITY.contains(aStack, true)) {
            return false;
        }
        if (IL.Cell_Empty.equal(aStack, false, true) || IL.SC2_Teapot_Empty.equal(aStack, false, true) || IL.SC2_Teacup_Empty.equal(aStack, false, true)) {
            return true;
        }
        return !IL.Cell_Empty.equal(aStack, true, true) && !IL.SC2_Teapot_Empty.equal(aStack, true, true) && !IL.SC2_Teacup_Empty.equal(aStack, true, true);
    }

    public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (ST.invalid(aStack)) {
            return CS.NI;
        }
        if (CS.ItemsGT.CONTAINER_DURABILITY.contains(aStack, true)) {
            return ST.copyMeta(ST.meta_(aStack) + 1, aStack);
        }
        if (ST.item_(aStack).hasContainerItem(aStack)) {
            return ST.copy(ST.item_(aStack).getContainerItem(aStack));
        }
        if (IL.Cell_Empty.exists()) {
            if (IL.Cell_Empty.equal(aStack, false, true)) {
                return CS.NI;
            }
            if (IL.Cell_Empty.equal(aStack, true, true)) {
                return IL.Cell_Empty.get(1L, new Object[0]);
            }
        }
        if (IL.SC2_Teapot_Empty.exists()) {
            if (IL.SC2_Teapot_Empty.equal(aStack, false, true)) {
                return CS.NI;
            }
            if (IL.SC2_Teapot_Empty.equal(aStack, true, true)) {
                return IL.SC2_Teapot_Empty.get(1L, new Object[0]);
            }
        }
        if (IL.SC2_Teacup_Empty.exists()) {
            if (IL.SC2_Teacup_Empty.equal(aStack, false, true)) {
                return CS.NI;
            }
            if (IL.SC2_Teacup_Empty.equal(aStack, true, true)) {
                return IL.SC2_Teacup_Empty.get(1L, new Object[0]);
            }
        }
        if (aCheckIFluidContainerItems && ST.item_(aStack) instanceof IFluidContainerItem && ((IFluidContainerItem)ST.item_(aStack)).getCapacity(aStack) > 0) {
            ItemStack tStack = ST.amount(1L, aStack);
            ((IFluidContainerItem)ST.item_(aStack)).drain(tStack, Integer.MAX_VALUE, true);
            if (tStack.stackSize <= 0) {
                return CS.NI;
            }
            if (tStack.getTagCompound() == null) {
                return tStack;
            }
            if (tStack.getTagCompound().hasNoTags()) {
                tStack.setTagCompound(null);
            }
            return tStack;
        }
        return CS.NI;
    }

    public static ItemStack container(ItemStack aStack, boolean aCheckIFluidContainerItems, int aSize) {
        return ST.amount(aSize, ST.container(aStack, aCheckIFluidContainerItems));
    }

    public static boolean rotten(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return false;
        }
        if (ST.item_(aStack) instanceof MultiItemRandom) {
            IFoodStat tStat = ((MultiItemRandom)ST.item_((ItemStack)aStack)).mFoodStats.get(ST.meta_(aStack));
            return tStat != null && tStat.isRotten(ST.item_(aStack), aStack, null);
        }
        return ST.item_(aStack) == Items.rotten_flesh || OM.materialcontained(aStack, MT.MeatRotten, MT.FishRotten);
    }

    public static boolean edible(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return false;
        }
        if (ST.item_(aStack) instanceof MultiItemRandom) {
            return ((MultiItemRandom)ST.item_((ItemStack)aStack)).mFoodStats.get(ST.meta_(aStack)) != null;
        }
        return ST.item_(aStack) instanceof ItemFood;
    }

    public static int food(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return 0;
        }
        if (ST.item_(aStack) instanceof ItemFood) {
            try {
                return ((ItemFood)ST.item_(aStack)).func_150905_g(aStack);
            }
            catch (Throwable e) {
                return 1;
            }
        }
        if (ST.item_(aStack) instanceof MultiItemRandom) {
            IFoodStat tStat = ((MultiItemRandom)ST.item_((ItemStack)aStack)).mFoodStats.get(ST.meta_(aStack));
            return tStat == null ? 0 : tStat.getFoodLevel(ST.item_(aStack), aStack, null);
        }
        return 0;
    }

    public static float saturation(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return 0.0f;
        }
        if (ST.item_(aStack) instanceof ItemFood) {
            try {
                return ((ItemFood)ST.item_(aStack)).func_150906_h(aStack);
            }
            catch (Throwable e) {
                return 0.5f;
            }
        }
        if (ST.item_(aStack) instanceof MultiItemRandom) {
            IFoodStat tStat = ((MultiItemRandom)ST.item_((ItemStack)aStack)).mFoodStats.get(ST.meta_(aStack));
            return tStat == null ? 0.0f : tStat.getSaturation(ST.item_(aStack), aStack, null);
        }
        return 0.0f;
    }

    public static float hydration(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return 0.0f;
        }
        if (ST.item_(aStack) instanceof MultiItemRandom) {
            IFoodStat tStat = ((MultiItemRandom)ST.item_((ItemStack)aStack)).mFoodStats.get(ST.meta_(aStack));
            return tStat == null ? 0.0f : tStat.getHydration(ST.item_(aStack), aStack, null);
        }
        return 0.0f;
    }

    public static ItemStack fuel(ItemStack aStack, short aValue) {
        aStack.setTagCompound(UT.NBT.makeShort(aStack.getTagCompound(), "gt.fuelvalue", aValue));
        return aStack;
    }

    public static long fuel(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return 0L;
        }
        long rFuelValue = GameRegistry.getFuelValue((ItemStack)aStack);
        if (rFuelValue > 0L) {
            return rFuelValue;
        }
        Item tItem = ST.item_(aStack);
        if (tItem instanceof ItemTool && ((ItemTool)tItem).getToolMaterialName().equals("WOOD")) {
            return 200L;
        }
        if (tItem instanceof ItemSword && ((ItemSword)tItem).getToolMaterialName().equals("WOOD")) {
            return 200L;
        }
        if (tItem instanceof ItemHoe && ((ItemHoe)tItem).getToolMaterialName().equals("WOOD")) {
            return 200L;
        }
        if (tItem == Items.stick) {
            return 100L;
        }
        if (tItem == Items.coal) {
            return 1600L;
        }
        if (tItem == Items.blaze_rod) {
            return 2400L;
        }
        if (tItem == Items.lava_bucket) {
            return 20000L;
        }
        Block tBlock = ST.block_(tItem);
        if (tBlock == Blocks.sapling) {
            return 100L;
        }
        if (tBlock == Blocks.wooden_slab) {
            return 150L;
        }
        if (tBlock == Blocks.coal_block) {
            return 16000L;
        }
        if (tBlock.getMaterial() == Material.wood) {
            return 300L;
        }
        return 0L;
    }

    public static Integer[] toIntegerArray(ItemStack ... aStacks) {
        Integer[] rArray = new Integer[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = ST.toInt(aStacks[i]);
        }
        return rArray;
    }

    public static int[] toIntArray(ItemStack ... aStacks) {
        int[] rArray = new int[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = ST.toInt(aStacks[i]);
        }
        return rArray;
    }

    public static String configName(ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return "";
        }
        Object rName = OreDictManager.INSTANCE.getAssociation_(aStack, true);
        if (rName != null) {
            return rName.toString();
        }
        try {
            rName = aStack.getUnlocalizedName();
            if (UT.Code.stringValid(rName)) {
                return rName.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ST.item_(aStack) + "." + ST.meta_(aStack);
    }

    public static String configNames(ItemStack ... aStacks) {
        String rString = "";
        for (ItemStack tStack : aStacks) {
            rString = rString + (tStack == null ? "null;" : ST.configName(tStack) + ";");
        }
        return rString;
    }

    public static String names(ItemStack ... aStacks) {
        String rString = "";
        for (ItemStack tStack : aStacks) {
            rString = rString + (tStack == null ? "null; " : tStack.getDisplayName() + "; ");
        }
        return rString;
    }

    public static String namesAndSizes(ItemStack ... aStacks) {
        String rString = "";
        for (ItemStack tStack : aStacks) {
            rString = rString + (tStack == null ? "null; " : tStack.getDisplayName() + " " + tStack.stackSize + "; ");
        }
        return rString;
    }

    public static void hide(Item aItem) {
        for (int i = 0; i < 16; ++i) {
            ST.hide(aItem, (long)i);
        }
        ST.hide(aItem, 32767L);
    }

    public static void hide(Item aItem, long aMeta) {
        ST.hide(ST.make(aItem, 1L, aMeta));
    }

    public static void hide(Block aBlock) {
        for (int i = 0; i < 16; ++i) {
            ST.hide(aBlock, (long)i);
        }
        ST.hide(aBlock, 32767L);
    }

    public static void hide(Block aBlock, long aMeta) {
        ST.hide(ST.make(aBlock, 1L, aMeta));
    }

    public static void hide(ItemStack aStack) {
        if (aStack != null) {
            try {
                API.hideItem((ItemStack)aStack);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean forceProperMaxStacksizes() {
        Items.potionitem.setMaxStackSize(1);
        Items.glass_bottle.setMaxStackSize(64);
        Items.bed.setMaxStackSize(64);
        Items.cake.setMaxStackSize(64);
        Items.wooden_door.setMaxStackSize(8);
        Items.iron_door.setMaxStackSize(8);
        Items.written_book.setMaxStackSize(64);
        Items.writable_book.setMaxStackSize(64);
        Items.enchanted_book.setMaxStackSize(64);
        return true;
    }

    public static void fixBookStacks() {
        for (ItemStack tStack : REVERT_TO_BOOK_TO_FIX_STUPID) {
            ST.set(tStack, ST.make(Items.book, 1L, 0L), true, true);
        }
    }

    public static ItemStack generateOneVanillaLoot() {
        return ChestGenHooks.getOneItem((String)UT.Code.select("dungeonChest", LOOT_TABLES_VANILLA), (Random)CS.RNGSUS);
    }

    public static boolean generateLoot(Random aRandom, String aLoot, IInventory aInv) {
        try {
            if (aLoot.startsWith("twilightforest:")) {
                if (!TF_TREASURE) {
                    return false;
                }
                TwilightTreasureReplacer.generate(aInv, aLoot);
            } else {
                WeightedRandomChestContent.generateChestContents((Random)aRandom, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)aLoot, (Random)aRandom), (IInventory)aInv, (int)ChestGenHooks.getCount((String)aLoot, (Random)aRandom));
            }
            int j = aInv.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = aInv.getStackInSlot(i);
                if (ST.invalid(tStack)) continue;
                if (IL.TC_Gold_Coin.exists()) {
                    if (ST.item_(tStack) == Items.gold_nugget) {
                        ST.set(tStack, IL.TC_Gold_Coin.get(tStack.stackSize, new Object[0]));
                    }
                    if (ST.item_(tStack) == Items.gold_ingot && tStack.stackSize <= 7) {
                        ST.set(tStack, IL.TC_Gold_Coin.get((long)tStack.stackSize * 9L, new Object[0]));
                    }
                }
                if (IL.EtFu_Sus_Stew.exists() && ST.item_(tStack) == Items.mushroom_stew) {
                    NBTTagList tList = new NBTTagList();
                    switch (CS.RNGSUS.nextInt(9)) {
                        case 1: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.field_76443_y.id, "EffectDuration", 7));
                            break;
                        }
                        case 2: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.fireResistance.id, "EffectDuration", 80));
                            break;
                        }
                        case 3: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.nightVision.id, "EffectDuration", 100));
                            break;
                        }
                        case 4: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.weakness.id, "EffectDuration", 180));
                            break;
                        }
                        case 5: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.regeneration.id, "EffectDuration", 160));
                            break;
                        }
                        case 6: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.jump.id, "EffectDuration", 120));
                            break;
                        }
                        case 7: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.poison.id, "EffectDuration", 240));
                            break;
                        }
                        case 8: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.wither.id, "EffectDuration", 160));
                            break;
                        }
                        default: {
                            tList.appendTag((NBTBase)UT.NBT.make("EffectId", (Object)Potion.blindness.id, "EffectDuration", 160));
                        }
                    }
                    ST.nbt(ST.set(tStack, IL.EtFu_Sus_Stew.get(tStack.stackSize, new Object[0])), UT.NBT.make("Effects", (Object)tList, new Object[0]));
                }
                aInv.setInventorySlotContents(i, ST.update_(OM.get_(tStack)));
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            return false;
        }
    }

    public static boolean add(Entity aPlayer, ItemStack aStack) {
        return ST.add(aPlayer, aStack, false);
    }

    public static boolean add(Entity aPlayer, ItemStack aStack, boolean aCurrentSlotFirst) {
        return aPlayer instanceof EntityPlayer && ST.add(aPlayer, (IInventory)((EntityPlayer)aPlayer).inventory, aStack, aCurrentSlotFirst);
    }

    public static boolean add(Entity aPlayer, IInventory aInv, ItemStack aStack, boolean aCurrentSlotFirst) {
        if (aInv != null && ST.valid(aStack)) {
            ItemStack tStack;
            int i;
            ST.check(aPlayer, aStack);
            for (i = 0; i < 36; ++i) {
                if (aPlayer instanceof EntityPlayer && i == ((EntityPlayer)aPlayer).inventory.currentItem || !ST.equal(tStack = aInv.getStackInSlot(i), aStack) || aStack.stackSize + tStack.stackSize > tStack.getMaxStackSize()) continue;
                tStack.stackSize += aStack.stackSize;
                ST.update(aPlayer);
                return true;
            }
            if (aCurrentSlotFirst && aPlayer instanceof EntityPlayer) {
                ItemStack tStack2 = aInv.getStackInSlot(((EntityPlayer)aPlayer).inventory.currentItem);
                if (tStack2 == null || tStack2.stackSize == 0) {
                    aInv.setInventorySlotContents(((EntityPlayer)aPlayer).inventory.currentItem, aStack);
                    ST.update(aPlayer);
                    return true;
                }
                if (ST.equal(tStack2, aStack) && aStack.stackSize + tStack2.stackSize <= tStack2.getMaxStackSize()) {
                    tStack2.stackSize += aStack.stackSize;
                    ST.update(aPlayer);
                    return true;
                }
            }
            for (i = 0; i < 36; ++i) {
                if (aPlayer instanceof EntityPlayer && i == ((EntityPlayer)aPlayer).inventory.currentItem || (tStack = aInv.getStackInSlot(i)) != null && tStack.stackSize > 0) continue;
                aInv.setInventorySlotContents(i, aStack);
                ST.update(aPlayer);
                return true;
            }
            if (!aCurrentSlotFirst && aPlayer instanceof EntityPlayer) {
                ItemStack tStack3 = aInv.getStackInSlot(((EntityPlayer)aPlayer).inventory.currentItem);
                if (tStack3 == null || tStack3.stackSize == 0) {
                    aInv.setInventorySlotContents(((EntityPlayer)aPlayer).inventory.currentItem, aStack);
                    ST.update(aPlayer);
                    return true;
                }
                if (ST.equal(tStack3, aStack) && aStack.stackSize + tStack3.stackSize <= tStack3.getMaxStackSize()) {
                    tStack3.stackSize += aStack.stackSize;
                    ST.update(aPlayer);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean give(Entity aPlayer, ItemStack aStack) {
        return ST.give(aPlayer, aStack, false, aPlayer.worldObj, aPlayer.posX, aPlayer.posY, aPlayer.posZ);
    }

    public static boolean give(Entity aPlayer, ItemStack aStack, boolean aCurrentSlotFirst) {
        return ST.give(aPlayer, aStack, aCurrentSlotFirst, aPlayer.worldObj, aPlayer.posX, aPlayer.posY, aPlayer.posZ);
    }

    public static boolean give(Entity aPlayer, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        return ST.give(aPlayer, aStack, false, aWorld, aX, aY, aZ);
    }

    public static boolean give(Entity aPlayer, ItemStack aStack, boolean aCurrentSlotFirst, World aWorld, double aX, double aY, double aZ) {
        if (ST.valid(aStack) && !ST.add(aPlayer, aStack, aCurrentSlotFirst)) {
            ST.drop(aWorld, aX, aY, aZ, aStack);
        }
        return true;
    }

    public static boolean give(Entity aPlayer, IInventory aInv, ItemStack aStack, boolean aCurrentSlotFirst, World aWorld, double aX, double aY, double aZ) {
        if (ST.valid(aStack) && !ST.add(aPlayer, aInv, aStack, aCurrentSlotFirst)) {
            ST.drop(aWorld, aX, aY, aZ, aStack);
        }
        return true;
    }

    public static boolean achieve(Entity aPlayer, Achievement aAchievement) {
        if (aAchievement == null || !(aPlayer instanceof EntityPlayer) || aPlayer.worldObj == null || aPlayer.worldObj.isRemote) {
            return false;
        }
        ST.achieve(aPlayer, aAchievement.parentAchievement);
        ((EntityPlayer)aPlayer).triggerAchievement((StatBase)aAchievement);
        return true;
    }

    public static boolean check(Entity aPlayer, ItemStack aStack) {
        if (!(aPlayer instanceof EntityPlayer) || aPlayer.worldObj == null || aPlayer.worldObj.isRemote) {
            return false;
        }
        if (aPlayer.worldObj.provider.dimensionId == -1) {
            ST.achieve(aPlayer, AchievementList.portal);
        }
        if (ST.invalid(aStack)) {
            return false;
        }
        OreDictItemData tData = OM.association_(aStack);
        Item aItem = ST.item(aStack);
        Block aBlock = ST.block(aItem);
        String aRegName = ST.regName(aItem);
        if (WoodDictionary.WOODS.containsKey(aStack, true) || WoodDictionary.BEAMS.containsKey(aStack, true) || WoodDictionary.PLANKS_ANY.containsKey(aStack, true) || OD.logWood.is_(aStack) || OD.logRubber.is_(aStack)) {
            ST.achieve(aPlayer, AchievementList.mineWood);
        }
        if (aItem instanceof ItemHoe) {
            ST.achieve(aPlayer, AchievementList.buildHoe);
        } else if (aItem instanceof ItemSword) {
            ST.achieve(aPlayer, AchievementList.buildSword);
        } else if (aItem instanceof ItemPickaxe) {
            ST.achieve(aPlayer, aItem != Items.wooden_pickaxe ? AchievementList.buildBetterPickaxe : AchievementList.buildPickaxe);
        }
        if (MD.MC.owns(aRegName)) {
            if (aItem == Items.cooked_fished) {
                ST.achieve(aPlayer, AchievementList.cookFish);
            } else if (aItem == Items.bread) {
                ST.achieve(aPlayer, AchievementList.makeBread);
            } else if (aItem == Items.leather || aItem == Items.beef || aItem == Items.cooked_beef || aItem == Items.saddle) {
                ST.achieve(aPlayer, AchievementList.killCow);
            } else if (aBlock == Blocks.cake || aItem == Items.cake) {
                ST.achieve(aPlayer, AchievementList.bakeCake);
            } else if (aBlock == Blocks.furnace || aBlock == Blocks.lit_furnace) {
                ST.achieve(aPlayer, AchievementList.buildFurnace);
            } else if (aItem == Items.ghast_tear) {
                ST.achieve(aPlayer, AchievementList.portal);
            } else if (aItem == Items.brewing_stand || aBlock == Blocks.brewing_stand || aItem == Items.blaze_rod || aItem == Items.blaze_powder || aItem == Items.ender_eye) {
                ST.achieve(aPlayer, AchievementList.blazeRod);
            } else if (aBlock == Blocks.enchanting_table) {
                ST.achieve(aPlayer, AchievementList.enchantments);
            } else if (aBlock == Blocks.bookshelf) {
                ST.achieve(aPlayer, AchievementList.bookcase);
            }
        }
        if (MD.TF.owns(aRegName)) {
            if (IL.TF_Trophy_Naga.equal(aStack, false, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressNaga);
            } else if (IL.TF_Trophy_Lich.equal(aStack, false, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressLich);
            } else if (IL.TF_Trophy_Hydra.equal(aStack, false, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressHydra);
            } else if (IL.TF_Trophy_Urghast.equal(aStack, false, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressUrghast);
            } else if (IL.TF_Trophy_Snowqueen.equal(aStack, false, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressGlacier);
            } else if (IL.TF_Lamp_of_Cinders.equal(aStack, true, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressThorns);
            } else if (IL.TF_Cube_of_Annihilation.equal(aStack, true, true)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressCastle);
            }
        }
        if (tData != null && !tData.mPrefix.containsAny(TD.Prefix.ORE_PROCESSING_BASED, TD.Prefix.ORE)) {
            if (ANY.Diamond.mToThis.contains(tData.mMaterial.mMaterial) && tData.mPrefix.contains(TD.Prefix.GEM_BASED)) {
                ST.achieve(aPlayer, AchievementList.diamonds);
            }
            if (ANY.Iron.mToThis.contains(tData.mMaterial.mMaterial)) {
                ST.achieve(aPlayer, AchievementList.acquireIron);
            }
            if (MD.TF.mLoaded && tData.mMaterial.mMaterial.mOriginalMod == MD.TF && tData.mMaterial.mMaterial.contains(TD.Properties.MAZEBREAKER)) {
                ST.achieve(aPlayer, TFAchievementPage.twilightProgressHydra);
            }
        }
        return true;
    }

    public static void denull(Entity aPlayer) {
        if (aPlayer instanceof EntityPlayer) {
            ST.denull((IInventory)((EntityPlayer)aPlayer).inventory);
        }
    }

    public static void denull(IInventory aInv) {
        if (aInv != null) {
            int j = aInv.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = aInv.getStackInSlot(i);
                if (tStack == null || tStack.stackSize != 0 && tStack.getItem() != null) continue;
                aInv.setInventorySlotContents(i, null);
            }
        }
    }

    public static ItemStack projectile(Entity aPlayer, TagData aType) {
        if (aPlayer instanceof EntityPlayer) {
            return ST.projectile((IInventory)((EntityPlayer)aPlayer).inventory, aType);
        }
        return null;
    }

    public static ItemStack projectile(IInventory aInv, TagData aType) {
        if (aInv != null) {
            int j = aInv.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                ItemStack rStack = aInv.getStackInSlot(i);
                if (!ST.valid(rStack) || !(rStack.getItem() instanceof IItemProjectile) || !((IItemProjectile)rStack.getItem()).hasProjectile(aType, rStack)) continue;
                return ST.update(rStack);
            }
        }
        return null;
    }

    public static ItemStack load(NBTTagCompound aNBT, String aTagName) {
        return aNBT == null ? null : ST.load(aNBT.getCompoundTag(aTagName), CS.NI);
    }

    public static ItemStack load(NBTTagCompound aNBT, String aTagName, ItemStack aDefault) {
        return aNBT == null ? null : ST.load(aNBT.getCompoundTag(aTagName), aDefault);
    }

    public static ItemStack load(NBTTagCompound aNBT) {
        return ST.load(aNBT, CS.NI);
    }

    public static ItemStack load(NBTTagCompound aNBT, ItemStack aDefault) {
        if (aNBT == null || aNBT.hasNoTags()) {
            return null;
        }
        ItemStack rStack = ST.make(Item.getItemById((int)aNBT.getShort("id")), (long)aNBT.getInteger("Count"), (long)aNBT.getShort("Damage"));
        if (rStack == null) {
            if (aNBT.hasKey("od")) {
                rStack = OreDictManager.INSTANCE.getStack(aNBT.getString("od"), aNBT.getInteger("Count"));
                if (rStack == null) {
                    return aDefault == null ? null : ST.update_(OM.get_(aDefault));
                }
            } else {
                return aDefault == null ? null : ST.update_(OM.get_(aDefault));
            }
        }
        rStack.setTagCompound(aNBT.hasKey("tag", 10) ? aNBT.getCompoundTag("tag") : null);
        return ST.update_(OM.get_(rStack));
    }

    public static NBTTagCompound save(String aTagName, Block aBlock) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aBlock, 1L, 0L));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, Block aBlock, long aStackSize) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aBlock, aStackSize, 0L));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, Block aBlock, long aStackSize, long aMeta) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aBlock, aStackSize, aMeta));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, Item aItem) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aItem, 1L, 0L));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, Item aItem, long aStackSize) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aItem, aStackSize, 0L));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, Item aItem, long aStackSize, long aMeta) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(ST.make(aItem, aStackSize, aMeta));
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(String aTagName, ItemStack aStack) {
        NBTTagCompound aNBT = UT.NBT.make();
        NBTTagCompound tNBT = ST.save(aStack);
        if (tNBT == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Block aBlock) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aBlock, 1L, 0L))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Block aBlock, long aStackSize) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aBlock, aStackSize, 0L))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Block aBlock, long aStackSize, long aMeta) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aBlock, aStackSize, aMeta))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Item aItem) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aItem, 1L, 0L))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Item aItem, long aStackSize) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aItem, aStackSize, 0L))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, Item aItem, long aStackSize, long aMeta) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(ST.make(aItem, aStackSize, aMeta))) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(NBTTagCompound aNBT, String aTagName, ItemStack aStack) {
        NBTTagCompound tNBT;
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if ((tNBT = ST.save(aStack)) == null) {
            aNBT.removeTag(aTagName);
        } else {
            aNBT.setTag(aTagName, (NBTBase)tNBT);
        }
        return aNBT;
    }

    public static NBTTagCompound save(ItemStack aStack) {
        OreDictItemData tData;
        if (aStack == null || ST.item_(aStack) == null || aStack.stackSize < 0) {
            return null;
        }
        NBTTagCompound rNBT = UT.NBT.make();
        aStack = OM.get_(aStack);
        rNBT.setShort("id", ST.id(aStack));
        UT.NBT.setNumber(rNBT, "Count", aStack.stackSize);
        UT.NBT.setNumber(rNBT, "Damage", ST.meta_(aStack));
        if (aStack.hasTagCompound()) {
            rNBT.setTag("tag", (NBTBase)aStack.getTagCompound());
        }
        if ((tData = OM.anyassociation_(aStack)) != null) {
            rNBT.setString("od", tData.toString());
        }
        return rNBT;
    }
}

