/*
 * Decompiled with CFR 0.152.
 */
package gregapi.util;

import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.IItemContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.data.CS;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.recipes.AdvancedCraftingShaped;
import gregapi.recipes.AdvancedCraftingShapeless;
import gregapi.recipes.AdvancedCraftingTool;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CR {
    public static final HashSetNoNulls<String> CLASSES_NATIVE = new HashSetNoNulls<String>(false, ShapedRecipes.class.getName(), ShapedOreRecipe.class.getName(), AdvancedCraftingShaped.class.getName(), ShapelessRecipes.class.getName(), ShapelessOreRecipe.class.getName(), AdvancedCraftingShapeless.class.getName(), "ic2.core.AdvRecipe", "ic2.core.AdvShapelessRecipe", "appeng.recipes.game.ShapedRecipe", "appeng.recipes.game.ShapelessRecipe", "forestry.core.utils.ShapedRecipeCustom", "mekanism.common.recipe.ShapedMekanismRecipe", "mekanism.common.recipe.ShapelessMekanismRecipe");
    public static final HashSetNoNulls<String> CLASSES_SPECIAL = new HashSetNoNulls<String>(false, AdvancedCraftingTool.class.getName(), RecipeFireworks.class.getName(), RecipesArmorDyes.class.getName(), RecipeBookCloning.class.getName(), RecipesMapCloning.class.getName(), RecipesMapExtending.class.getName(), "jds.bibliocraft.BiblioSpecialRecipes", "dan200.qcraft.shared.EntangledQBlockRecipe", "dan200.qcraft.shared.EntangledQuantumComputerRecipe", "dan200.qcraft.shared.QBlockRecipe", "appeng.recipes.game.FacadeRecipe", "appeng.recipes.game.DisassembleRecipe", "mods.railcraft.common.carts.LocomotivePaintingRecipe", "mods.railcraft.common.util.crafting.RotorRepairRecipe", "mods.railcraft.common.util.crafting.RoutingTableCopyRecipe", "mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe", "mods.railcraft.common.util.crafting.TankCartFilterRecipe", "mods.railcraft.common.emblems.LocomotiveEmblemRecipe", "mods.railcraft.common.emblems.EmblemPostColorRecipe", "mods.railcraft.common.emblems.EmblemPostEmblemRecipe", "mods.immibis.redlogic.interaction.RecipeDyeLumarButton", "thaumcraft.common.items.armor.RecipesRobeArmorDyes", "thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes", "thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe", "twilightforest.item.TFMapCloningRecipe", "forestry.lepidopterology.MatingRecipe", "micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes", "shedar.mods.ic2.nuclearcontrol.StorageArrayRecipe");
    private static final ArrayListNoNulls<List<ItemStack>> OREDICT_DYE_LISTS = new ArrayListNoNulls();
    public static final ItemStackSet<ItemStackContainer> RECIPES_TO_DELATE;
    public static boolean BUFFERING;
    public static final List<IRecipe> BUFFER;
    public static final String DELATE = "gt:delate";
    public static final long NONE = 0L;
    public static final long MIR;
    public static final long BUF;
    public static final long REV;
    public static final long KEEPNBT;
    public static final long DISMANTLE;
    public static final long NO_REM;
    public static final long NO_AUTO;
    public static final long NO_COLLISION_CHECK;
    public static final long DEL_OTHER_RECIPES;
    public static final long DEL_OTHER_RECIPES_IF_SAME_NBT;
    public static final long DEL_OTHER_SHAPED_RECIPES;
    public static final long DEL_OTHER_NATIVE_RECIPES;
    public static final long DEL_IF_NO_DYES;
    public static final long ONLY_IF_HAS_OTHER_RECIPES;
    public static final long ONLY_IF_HAS_RESULT;
    public static final long DEF;
    public static final long DEF_MIR;
    public static final long DEF_REV;
    public static final long DEF_REV_MIR;
    public static final long DEF_NCC;
    public static final long DEF_NCC_MIR;
    public static final long DEF_REV_NCC;
    public static final long DEF_REV_NCC_MIR;
    public static final long DEF_NAC;
    public static final long DEF_NAC_MIR;
    public static final long DEF_NAC_NCC;
    public static final long DEF_NAC_NCC_MIR;
    public static final long DEF_NAC_REV;
    public static final long DEF_NAC_REV_MIR;
    public static final long DEF_NAC_REV_NCC;
    public static final long DEF_NAC_REV_NCC_MIR;
    public static final long DEF_REM;
    public static final long DEF_REM_REV;
    public static final long DEF_REM_NCC;
    public static final long DEF_REM_REV_NCC;
    public static final long DEF_REM_REV_NCC_MIR;
    public static final long DEF_REM_NAC;
    public static final long DEF_REM_NAC_NCC;
    public static final long DEF_REM_NAC_REV;
    public static final long DEF_REM_NAC_REV_MIR;
    public static final long DEF_REM_NAC_REV_NCC;
    public static final long DEF_REM_NAC_REV_NCC_MIR;
    public static IRecipe sLastRecipe;

    public static void stopBuffering() {
        BUFFERING = false;
        List<IRecipe> tList = CR.list();
        for (int i = 0; i < tList.size(); ++i) {
            IRecipe tRecipe = tList.get(i);
            if (tRecipe == null || tRecipe instanceof ICraftingRecipeGT && !((ICraftingRecipeGT)tRecipe).isRemovableByGT() || CLASSES_SPECIAL.contains(tRecipe.getClass().getName()) || !RECIPES_TO_DELATE.contains(tRecipe.getRecipeOutput(), true)) continue;
            tList.set(i, null);
        }
        tList.removeAll(Arrays.asList(new IRecipe[]{null}));
        if (!CS.DISABLE_GT6_CRAFTING_RECIPES) {
            for (IRecipe tRecipe : BUFFER) {
                GameRegistry.addRecipe((IRecipe)tRecipe);
            }
        }
        BUFFER.clear();
    }

    public static boolean shaped(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return CR.shaped(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, aRecipe);
    }

    public static boolean shaped(ItemStack aResult, Object[] aRecipe) {
        return CR.shaped(aResult, DEF, aRecipe);
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return CR.shaped(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & MIR) != 0L, (aBitMask & BUF) != 0L, (aBitMask & KEEPNBT) != 0L, (aBitMask & DISMANTLE) != 0L, (aBitMask & NO_REM) == 0L, (aBitMask & REV) != 0L, (aBitMask & DEL_OTHER_RECIPES) != 0L, (aBitMask & DEL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & DEL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & DEL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & NO_COLLISION_CHECK) == 0L, (aBitMask & ONLY_IF_HAS_OTHER_RECIPES) != 0L, (aBitMask & ONLY_IF_HAS_RESULT) != 0L, (aBitMask & DEL_IF_NO_DYES) != 0L, (aBitMask & NO_AUTO) != 0L, aRecipe);
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5, char aC6, Object aO6, char aC7, Object aO7, char aC8, Object aO8, char aC9, Object aO9) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5, Character.valueOf(aC6), aO6, Character.valueOf(aC7), aO7, Character.valueOf(aC8), aO8, Character.valueOf(aC9), aO9});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5, char aC6, Object aO6, char aC7, Object aO7, char aC8, Object aO8) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5, Character.valueOf(aC6), aO6, Character.valueOf(aC7), aO7, Character.valueOf(aC8), aO8});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5, char aC6, Object aO6, char aC7, Object aO7) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5, Character.valueOf(aC6), aO6, Character.valueOf(aC7), aO7});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5, char aC6, Object aO6) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5, Character.valueOf(aC6), aO6});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1, char aC2, Object aO2) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, String aRecipeC, char aC1, Object aO1) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, aRecipeC, Character.valueOf(aC1), aO1});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5, char aC6, Object aO6) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5, Character.valueOf(aC6), aO6});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4, char aC5, Object aO5) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4, Character.valueOf(aC5), aO5});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3, char aC4, Object aO4) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3, Character.valueOf(aC4), aO4});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1, char aC2, Object aO2) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, String aRecipeB, char aC1, Object aO1) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, aRecipeB, Character.valueOf(aC1), aO1});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, char aC1, Object aO1, char aC2, Object aO2, char aC3, Object aO3) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2, Character.valueOf(aC3), aO3});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, char aC1, Object aO1, char aC2, Object aO2) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, Character.valueOf(aC1), aO1, Character.valueOf(aC2), aO2});
    }

    public static boolean shaped(ItemStack aResult, long aBitMask, String aRecipeA, char aC1, Object aO1) {
        return CR.shaped(aResult, aBitMask, new Object[]{aRecipeA, Character.valueOf(aC1), aO1});
    }

    private static boolean shaped(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, boolean aDeleteOnlyIfNoDyeInvolved, boolean aNotAutoCraftable, Object[] aRecipe) {
        if (aOnlyAddIfResultIsNotNull && ST.invalid(aResult)) {
            return false;
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        boolean tThereWasARecipe = false;
        aResult = ST.validMeta(OM.get(aResult));
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] == null) continue;
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                if (aRecipe[i] != null) continue;
                return false;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] instanceof Item) {
                aRecipe[i] = ST.make((Item)aRecipe[i], 1L, 32767L);
                continue;
            }
            if (aRecipe[i] instanceof Block) {
                aRecipe[i] = ST.make((Block)aRecipe[i], 1L, 32767L);
                continue;
            }
            if (aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof OreDictItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            String shape = "";
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while (aRecipe[idx] instanceof String) {
                String s = (String)aRecipe[idx++];
                shape = shape + s;
                while (s.length() < 3) {
                    s = s + " ";
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block30: for (char c : s.toCharArray()) {
                    switch (c) {
                        case 'a': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolAxe");
                            continue block30;
                        }
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBlade");
                            continue block30;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolCrowbar");
                            continue block30;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolScrewdriver");
                            continue block30;
                        }
                        case 'e': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolDrill");
                            continue block30;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolFile");
                            continue block30;
                        }
                        case 'g': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolHandDrill");
                            continue block30;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolHardHammer");
                            continue block30;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSolderingIron");
                            continue block30;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSolderingMetal");
                            continue block30;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolKnife");
                            continue block30;
                        }
                        case 'l': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolMagnifyingGlass");
                            continue block30;
                        }
                        case 'n': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolMonkeyWrench");
                            continue block30;
                        }
                        case 'o': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBendingCylinderSmall");
                            continue block30;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolDrawplate");
                            continue block30;
                        }
                        case 'q': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolScissors");
                            continue block30;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSoftHammer");
                            continue block30;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSaw");
                            continue block30;
                        }
                        case 'v': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSawAxe");
                            continue block30;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolWrench");
                            continue block30;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolWireCutter");
                            continue block30;
                        }
                        case 'y': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolChisel");
                            continue block30;
                        }
                        case 'z': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBendingCylinder");
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, OreDictItemData> tItemDataMap = new HashMap<Character, OreDictItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    CS.ERR.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.getDisplayName()));
                    for (Object tContent : aRecipe) {
                        CS.ERR.println(tContent);
                    }
                    return false;
                }
                Character tChar = (Character)aRecipe[idx];
                Object tInput = aRecipe[idx + 1];
                if (tInput instanceof ItemStack) {
                    tItemStackMap.put(tChar, ST.copy_((ItemStack)tInput));
                    tItemDataMap.put(tChar, OM.data_((ItemStack)tInput));
                } else {
                    ItemStack tStack;
                    String tInputString = tInput.toString();
                    if (tInput instanceof OreDictItemData) {
                        tItemDataMap.put(tChar, (OreDictItemData)tInput);
                        if (UT.Code.stringInvalid(tInputString)) {
                            throw new IllegalArgumentException();
                        }
                    } else if (UT.Code.stringValid(tInputString)) {
                        tItemDataMap.put(tChar, OreDictManager.INSTANCE.getAutomaticItemData(tInputString));
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if ((tStack = OreDictManager.INSTANCE.getFirstOre(tInputString, 1L)) == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(tChar, tStack);
                    }
                    aRecipe[idx + 1] = tInputString;
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                OreDictItemData[] tData = new OreDictItemData[9];
                int x = -1;
                for (char chr : shape.toCharArray()) {
                    tData[++x] = (OreDictItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (UT.Code.containsSomething(tData)) {
                    OM.data(aResult, new OreDictItemData(tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || ST.meta_(tRecipe[x]) != Short.MAX_VALUE) continue;
                    ST.meta_(tRecipe[x], 0L);
                }
                tThereWasARecipe = CR.remove(tRecipe) != null || tThereWasARecipe;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aResult == null || aResult.stackSize <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            boolean bl = tThereWasARecipe = CR.remout(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes, aDeleteOnlyIfNoDyeInvolved) || tThereWasARecipe;
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tThereWasARecipe) {
            List<IRecipe> tList = CR.list();
            for (int i = 0; i < tList.size(); ++i) {
                IRecipe tRecipe = tList.get(i);
                if (CLASSES_SPECIAL.contains(tRecipe.getClass().getName()) || !ST.equal(OM.get(tRecipe.getRecipeOutput()), aResult, true)) continue;
                tThereWasARecipe = true;
                break;
            }
        }
        aResult = ST.update_(aResult);
        if (tThereWasARecipe || !aOnlyAddIfThereIsAnyRecipeOutputtingThis) {
            if (BUFFERING && aBuffered) {
                BUFFER.add((IRecipe)new AdvancedCraftingShaped(ST.copy_(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            } else {
                GameRegistry.addRecipe((IRecipe)new AdvancedCraftingShaped(ST.copy_(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            }
        }
        return true;
    }

    public static boolean shapeless(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return CR.shapeless(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, true, false, false, false, false, false, false, false, false, aRecipe);
    }

    public static boolean shapeless(ItemStack aResult, Object[] aRecipe) {
        return CR.shapeless(aResult, DEF, aRecipe);
    }

    public static boolean shapeless(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return CR.shapeless(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & BUF) != 0L, (aBitMask & KEEPNBT) != 0L, (aBitMask & DISMANTLE) != 0L, (aBitMask & NO_REM) == 0L, (aBitMask & NO_AUTO) != 0L, (aBitMask & DEL_OTHER_RECIPES) != 0L, (aBitMask & DEL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & DEL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & DEL_OTHER_NATIVE_RECIPES) != 0L, aRecipe);
    }

    private static boolean shapeless(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aNotAutoCraftable, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, Object[] aRecipe) {
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        if (aRecipe.length > 9) {
            throw new IllegalArgumentException("Shapeless Recipe has more than 9 Inputs! This would crash NEI!");
        }
        aResult = ST.validMeta(OM.get(aResult));
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] == null) continue;
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                if (aRecipe[i] != null) continue;
                return false;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] instanceof Item) {
                aRecipe[i] = ST.make((Item)aRecipe[i], 1L, 32767L);
                continue;
            }
            if (aRecipe[i] instanceof Block) {
                aRecipe[i] = ST.make((Block)aRecipe[i], 1L, 32767L);
                continue;
            }
            if (aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            ItemStack[] tRecipe = new ItemStack[9];
            int i = 0;
            for (Object tObject : aRecipe) {
                if (tObject == null) {
                    CS.ERR.println("WARNING: Missing Item for shapeless Recipe: " + (aResult == null ? "null" : aResult.getDisplayName()));
                    for (Object tContent : aRecipe) {
                        CS.ERR.println(tContent);
                    }
                    return false;
                }
                if (tObject instanceof ItemStack) {
                    tRecipe[i] = (ItemStack)tObject;
                } else if (tObject instanceof String) {
                    tRecipe[i] = OreDictManager.INSTANCE.getFirstOre(tObject, 1L);
                    if (tRecipe[i] == null) {
                        break;
                    }
                } else if (!(tObject instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            CR.remove(tRecipe);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aResult == null || aResult.stackSize <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            CR.remout(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes, true);
        }
        ST.update(aResult);
        if (BUFFERING && aBuffered) {
            BUFFER.add(new AdvancedCraftingShapeless(ST.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new AdvancedCraftingShapeless(ST.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        }
        return true;
    }

    public static ItemStack getany(World aWorld, ItemStack ... aRecipe) {
        return CR.getany(aWorld, true, aRecipe);
    }

    public static ItemStack getany(World aWorld, boolean aAllowCache, ItemStack ... aRecipe) {
        if (!ST.hasValid(aRecipe)) {
            return null;
        }
        if (aWorld == null) {
            aWorld = CS.DW;
        }
        InventoryCrafting aCrafting = CR.crafting(aRecipe);
        if (aAllowCache && sLastRecipe != null && sLastRecipe.matches(aCrafting, aWorld)) {
            return sLastRecipe.getCraftingResult(aCrafting);
        }
        List<IRecipe> tList = CR.list();
        for (int i = 0; i < tList.size(); ++i) {
            if (!tList.get(i).matches(aCrafting, aWorld)) continue;
            sLastRecipe = tList.get(i);
            return sLastRecipe.getCraftingResult(aCrafting);
        }
        int tIndex = 0;
        ItemStack tStack1 = null;
        ItemStack tStack2 = null;
        int j = aCrafting.getSizeInventory();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = aCrafting.getStackInSlot(i);
            if (tStack == null) continue;
            if (tIndex == 0) {
                tStack1 = tStack;
            }
            if (tIndex == 1) {
                tStack2 = tStack;
            }
            ++tIndex;
        }
        if (tIndex == 2) {
            assert (tStack1 != null && tStack2 != null);
            if (tStack1.getItem() == tStack2.getItem() && tStack1.getItem().isRepairable()) {
                int tNewDamage = ST.meta_(tStack1) + ST.meta_(tStack2) + tStack1.getMaxDamage() / -20 - tStack1.getMaxDamage();
                return ST.make(tStack1.getItem(), 1L, tNewDamage < 0 ? 0L : (long)tNewDamage);
            }
        }
        return null;
    }

    public static ItemStack get(ItemStack ... aRecipe) {
        return CR.get(false, aRecipe);
    }

    public static ItemStack get(boolean aUncopiedStack, ItemStack ... aRecipe) {
        if (!ST.hasValid(aRecipe)) {
            return null;
        }
        InventoryCrafting aCrafting = CR.crafting(aRecipe);
        List<IRecipe> tList = CR.list();
        for (int i = 0; i < tList.size(); ++i) {
            try {
                if (!tList.get(i).matches(aCrafting, (World)CS.DW)) continue;
                return aUncopiedStack ? ST.valisize(tList.get(i).getRecipeOutput()) : ST.copy(ST.valisize(tList.get(i).getCraftingResult(aCrafting)));
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return null;
    }

    public static List<ItemStack> outputs(ItemStack ... aRecipe) {
        return CR.outputs(CR.list(), false, aRecipe);
    }

    public static List<ItemStack> outputs(List<IRecipe> aList, boolean aDeleteFromList, ItemStack ... aRecipe) {
        if (aList == null || !ST.hasValid(aRecipe)) {
            return Collections.emptyList();
        }
        InventoryCrafting aCrafting = CR.crafting(aRecipe);
        ArrayListNoNulls<ItemStack> rList = ST.arraylist(new ItemStack[0]);
        for (int i = 0; i < aList.size(); ++i) {
            try {
                if (!aList.get(i).matches(aCrafting, (World)CS.DW)) continue;
                ((ArrayList)rList).add(ST.copy(ST.valisize((aDeleteFromList ? aList.remove(i--) : aList.get(i)).getCraftingResult(aCrafting))));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return rList;
    }

    public static InventoryCrafting crafting(ItemStack ... aRecipe) {
        InventoryCrafting rCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            rCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        return rCrafting;
    }

    public static List<IRecipe> list() {
        return CraftingManager.getInstance().getRecipeList();
    }

    public static boolean has(ItemStack aOutput) {
        if (ST.invalid(aOutput)) {
            return false;
        }
        List<IRecipe> tList = CR.list();
        for (int i = 0; i < tList.size(); ++i) {
            if (!ST.equal(OM.get(tList.get(i).getRecipeOutput()), aOutput, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean remout(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers, boolean aDontRemoveDyeingRecipes) {
        if (ST.invalid(aOutput)) {
            return false;
        }
        boolean rReturn = false;
        List<IRecipe> tList = CR.list();
        aOutput = OM.get_(aOutput);
        for (int i = 0; i < tList.size(); ++i) {
            IRecipe tRecipe = tList.get(i);
            if (tRecipe instanceof ICraftingRecipeGT && !((ICraftingRecipeGT)tRecipe).isRemovableByGT() || aNotRemoveShapelessRecipes && (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) || (!aOnlyRemoveNativeHandlers ? CLASSES_SPECIAL.contains(tRecipe.getClass().getName()) : !CLASSES_NATIVE.contains(tRecipe.getClass().getName())) || !ST.equal(OM.get(tRecipe.getRecipeOutput()), aOutput, aIgnoreNBT)) continue;
            if (aDontRemoveDyeingRecipes) {
                boolean temp;
                if (tRecipe instanceof ShapedOreRecipe) {
                    temp = false;
                    for (Object tObject : ((ShapedOreRecipe)tRecipe).getInput()) {
                        if (!OREDICT_DYE_LISTS.contains(tObject)) continue;
                        temp = true;
                        break;
                    }
                    if (temp) continue;
                }
                if (tRecipe instanceof ShapelessOreRecipe) {
                    temp = false;
                    for (Object tObject : ((ShapelessOreRecipe)tRecipe).getInput()) {
                        if (!OREDICT_DYE_LISTS.contains(tObject)) continue;
                        temp = true;
                        break;
                    }
                    if (temp) continue;
                }
            }
            tList.remove(i--);
            rReturn = true;
        }
        return rReturn;
    }

    public static boolean remout(ItemStack aOutput) {
        return CR.remout(aOutput, true, false, false, false);
    }

    public static boolean remout(ModData aMod, String ... aNames) {
        if (aMod.mLoaded) {
            for (String aName : aNames) {
                CR.remout(aMod, aName, Short.MAX_VALUE);
            }
        }
        return aMod.mLoaded;
    }

    public static boolean remout(ModData aMod, String aName, int aMetaData) {
        return CR.remout(ST.make(aMod, aName, 1L, aMetaData));
    }

    public static void delate(ItemStack aOutput) {
        if (BUFFERING) {
            RECIPES_TO_DELATE.add(aOutput);
        } else {
            CR.remout(aOutput);
        }
    }

    public static void delate(ModData aMod, String ... aNames) {
        if (aMod.mLoaded) {
            for (String aName : aNames) {
                CR.delate(aMod, aName, Short.MAX_VALUE, new int[0]);
            }
        }
    }

    public static void delate(ModData aMod, String aName, int aMetaData, int ... aOtherMetaData) {
        Item aItem = ST.item(aMod, aName);
        if (aItem == null) {
            return;
        }
        CR.delate(ST.make(aItem, 1L, (long)aMetaData));
        for (int tMetaData : aOtherMetaData) {
            CR.delate(ST.make(aItem, 1L, (long)tMetaData));
        }
    }

    public static ItemStack remove(ItemStack ... aRecipe) {
        if (!ST.hasValid(aRecipe)) {
            return null;
        }
        ItemStack rReturn = null;
        ItemStack tReturn = null;
        InventoryCrafting aCrafting = CR.crafting(aRecipe);
        List<IRecipe> tList = CR.list();
        for (int i = 0; i < tList.size(); ++i) {
            try {
                while (i < tList.size()) {
                    if ((!(tList.get(i) instanceof ICraftingRecipeGT) || ((ICraftingRecipeGT)tList.get(i)).isRemovableByGT()) && tList.get(i).matches(aCrafting, (World)CS.DW) && (tReturn = tList.get(i).getCraftingResult(aCrafting)) != null) {
                        rReturn = tReturn;
                        tList.remove(i--);
                    }
                    ++i;
                }
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return rReturn;
    }

    static {
        for (String tDye : CS.DYE_OREDICTS) {
            OREDICT_DYE_LISTS.add(OreDictionary.getOres((String)tDye));
        }
        RECIPES_TO_DELATE = ST.hashset(new ItemStack[0]);
        BUFFERING = true;
        BUFFER = new ArrayListNoNulls<IRecipe>(1000);
        MIR = CS.B[0];
        BUF = CS.B[1];
        REV = CS.B[5];
        KEEPNBT = CS.B[2];
        DISMANTLE = CS.B[3];
        NO_REM = CS.B[4];
        NO_AUTO = CS.B[14];
        NO_COLLISION_CHECK = CS.B[10];
        DEL_OTHER_RECIPES = CS.B[6];
        DEL_OTHER_RECIPES_IF_SAME_NBT = CS.B[7];
        DEL_OTHER_SHAPED_RECIPES = CS.B[8];
        DEL_OTHER_NATIVE_RECIPES = CS.B[9];
        DEL_IF_NO_DYES = CS.B[13];
        ONLY_IF_HAS_OTHER_RECIPES = CS.B[11];
        ONLY_IF_HAS_RESULT = CS.B[12];
        DEF = BUF | NO_REM;
        DEF_MIR = DEF | MIR;
        DEF_REV = DEF | REV;
        DEF_REV_MIR = DEF_REV | MIR;
        DEF_NCC = DEF | NO_COLLISION_CHECK;
        DEF_NCC_MIR = DEF_NCC | MIR;
        DEF_REV_NCC = DEF_REV | NO_COLLISION_CHECK;
        DEF_REV_NCC_MIR = DEF_REV_NCC | MIR;
        DEF_NAC = DEF | NO_AUTO;
        DEF_NAC_MIR = DEF_NAC | MIR;
        DEF_NAC_NCC = DEF_NCC | NO_AUTO;
        DEF_NAC_NCC_MIR = DEF_NAC_NCC | MIR;
        DEF_NAC_REV = DEF_REV | NO_AUTO;
        DEF_NAC_REV_MIR = DEF_NAC_REV | MIR;
        DEF_NAC_REV_NCC = DEF_REV_NCC | NO_AUTO;
        DEF_NAC_REV_NCC_MIR = DEF_NAC_REV_NCC | MIR;
        DEF_REM = DEF | DEL_OTHER_RECIPES;
        DEF_REM_REV = DEF_REM | REV;
        DEF_REM_NCC = DEF_REM | NO_COLLISION_CHECK;
        DEF_REM_REV_NCC = DEF_REM_REV | NO_COLLISION_CHECK;
        DEF_REM_REV_NCC_MIR = DEF_REM_REV_NCC | MIR;
        DEF_REM_NAC = DEF_REM | NO_AUTO;
        DEF_REM_NAC_NCC = DEF_REM_NCC | NO_AUTO;
        DEF_REM_NAC_REV = DEF_REM_REV | NO_AUTO;
        DEF_REM_NAC_REV_MIR = DEF_REM_NAC_REV | MIR;
        DEF_REM_NAC_REV_NCC = DEF_REM_REV_NCC | NO_AUTO;
        DEF_REM_NAC_REV_NCC_MIR = DEF_REM_NAC_REV_NCC | MIR;
        sLastRecipe = null;
    }
}

