/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.GT_API;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase10MultiBlockBase
extends TileEntityBase09FacingSingle
implements ITileEntityMultiBlockController {
    public boolean mStructureChanged = false;
    public boolean mStructureOkay = false;
    public IIconContainer[] mTextures = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesFront = CS.L6_IICONCONTAINER;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.state.str")) {
            this.mStructureOkay = aNBT.getBoolean("gt.state.str");
        }
        if (CS.CODE_CLIENT) {
            if (GT_API.sBlockIcons == null && aNBT.hasKey("gt.texture")) {
                String tTextureName = aNBT.getString("gt.texture");
                this.mTextures = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay/side")};
                this.mTexturesFront = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/colored_front/side"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/bottom"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/top"), new Textures.BlockIcons.CustomIcon("machines/multiblockmains/" + tTextureName + "/overlay_front/side")};
            } else {
                TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), (int)this.getMultiTileEntityID());
                if (tCanonicalTileEntity instanceof TileEntityBase10MultiBlockBase) {
                    this.mTextures = ((TileEntityBase10MultiBlockBase)tCanonicalTileEntity).mTextures;
                    this.mTexturesFront = ((TileEntityBase10MultiBlockBase)tCanonicalTileEntity).mTexturesFront;
                }
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.state.str", this.mStructureOkay);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.builder.wand.to.ease.building"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        this.checkStructure(true);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide) {
            this.checkStructure(true);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mTimer % 600L == 5L) {
            if (!this.checkStructure(false)) {
                this.checkStructure(true);
            }
            this.doDefaultStructuralChecks();
        }
    }

    @Override
    public long onToolClickMultiBlock(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        if (aTool.equals("builderwand")) {
            if (this.isClientSide()) {
                return 0L;
            }
            this.checkStructure2(aFrom, aPlayer, aPlayerInventory);
            this.checkStructure(true);
            return 10L;
        }
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("builderwand")) {
            if (this.isClientSide()) {
                return 0L;
            }
            this.checkStructure2(this.getCoords(), aPlayer, aPlayerInventory);
            this.checkStructure(true);
            return 10L;
        }
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                this.onMagnifyingGlass(aChatReturn);
            }
            return 1L;
        }
        return 0L;
    }

    public void onMagnifyingGlass(List<String> aChatReturn) {
        if (this.checkStructure(false)) {
            this.onMagnifyingGlass2(aChatReturn);
        } else if (this.checkStructure(true)) {
            aChatReturn.add("Structure did form just now!");
        } else {
            aChatReturn.add("Structure did not form!");
        }
    }

    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add("Structure is formed already!");
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (this.isClientSide()) {
            return this.mStructureOkay;
        }
        if ((this.mStructureChanged || aForceReset) && this.mStructureOkay != this.checkStructure2(null, null, null)) {
            this.mStructureOkay = !this.mStructureOkay;
            this.updateClientData();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.onStructureChange();
    }

    @Override
    public final byte getDirectionData() {
        return (byte)(this.mFacing & 7 | (this.mStructureOkay ? 8 : 0));
    }

    @Override
    public final void setDirectionData(byte aData) {
        this.mFacing = (byte)(aData & 7);
        this.mStructureOkay = (aData & 8) != 0;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get((aSide == this.mFacing ? this.mTexturesFront : this.mTextures)[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get((aSide == this.mFacing ? this.mTexturesFront : this.mTextures)[CS.FACES_TBS[aSide] + 3])) : null;
    }

    @Override
    public boolean doDefaultStructuralChecks() {
        return true;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        return this.checkStructure2();
    }

    @Deprecated
    public boolean checkStructure2() {
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable2(aSide, aFluidToFill);
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable2(aSide, aFluidToDrain);
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks2(aSide);
    }

    public int[] getAccessibleSlotsFromSide(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getAccessibleSlotsFromSide2(aSide);
    }

    public boolean canInsertItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canInsertItem2(aSlot, aStack, aSide);
    }

    public boolean canExtractItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canExtractItem2(aSlot, aStack, aSide);
    }

    public int getSizeInventory(MultiTileEntityMultiBlockPart aPart) {
        return this.getSizeInventory();
    }

    public ItemStack getStackInSlot(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.getStackInSlot(aSlot);
    }

    public ItemStack decrStackSize(MultiTileEntityMultiBlockPart aPart, int aSlot, int aDecrement) {
        return this.decrStackSize(aSlot, aDecrement);
    }

    public ItemStack getStackInSlotOnClosing(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.getStackInSlotOnClosing(aSlot);
    }

    public void setInventorySlotContents(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        this.setInventorySlotContents(aSlot, aStack);
    }

    public String getInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.getInventoryName();
    }

    public boolean hasCustomInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.hasCustomInventoryName();
    }

    public int getInventoryStackLimit(MultiTileEntityMultiBlockPart aPart) {
        return this.getInventoryStackLimit();
    }

    public void markDirty(MultiTileEntityMultiBlockPart aPart) {
        this.markDirty();
    }

    public boolean isUseableByPlayer(MultiTileEntityMultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.isUseableByPlayer(aPlayer);
    }

    public void openInventory(MultiTileEntityMultiBlockPart aPart) {
        this.openInventory();
    }

    public void closeInventory(MultiTileEntityMultiBlockPart aPart) {
        this.closeInventory();
    }

    public boolean isItemValidForSlot(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.isItemValidForSlot(aSlot, aStack);
    }
}

