/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase10FacingDouble;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public abstract class MultiTileEntitySensor
extends TileEntityBase10FacingDouble
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SyncDataShort {
    protected byte mMode = 0;
    protected int mDisplayedNumber = 0;
    protected int oDisplayedNumber = 0;
    protected int mSetNumber = 0;
    protected byte mRedstone = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mode")) {
            this.mMode = aNBT.getByte("gt.mode");
        }
        if (aNBT.hasKey("gt.visual")) {
            this.mDisplayedNumber = UT.Code.unsignS(aNBT.getShort("gt.visual"));
        }
        this.mSetNumber = aNBT.hasKey("gt.value") ? UT.Code.unsignS(aNBT.getShort("gt.value")) : this.mDisplayedNumber;
        if (aNBT.hasKey("gt.connection")) {
            this.mSecondFacing = aNBT.getByte("gt.connection");
        }
        if (aNBT.hasKey("gt.redstone")) {
            this.mRedstone = aNBT.getByte("gt.redstone");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.setShort("gt.visual", (short)this.mDisplayedNumber);
        aNBT.setShort("gt.value", (short)this.mSetNumber);
        aNBT.setByte("gt.mode", this.mMode);
        aNBT.setByte("gt.redstone", this.mRedstone);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.setShort("gt.value", (short)this.mSetNumber);
        aNBT.setByte("gt.mode", this.mMode);
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.getSensorDescription());
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.buttons"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.display"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.sensor.screwdrive.modes"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.set.input.side"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.facing.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.facing.post"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte aTargetSide;
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("wrench") && CS.SIDES_VALID[aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ)]) {
            this.mFacing = aTargetSide;
            this.mSecondFacing = CS.OPOS[this.mFacing];
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        if (aTool.equals("monkeywrench") && CS.SIDES_VALID[aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ)] && aTargetSide != this.mFacing) {
            this.mSecondFacing = aTargetSide;
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        this.mDisplayedNumber = UT.Code.bind16(this.mDisplayedNumber);
        return super.onTickCheck(aTimer) || Math.abs(this.mDisplayedNumber - this.oDisplayedNumber) > (CS.SYNC_SECOND ? 0 : 49);
    }

    @Override
    public void onTickChecked(long aTimer) {
        super.onTickChecked(aTimer);
        this.oDisplayedNumber = this.mDisplayedNumber;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, UT.Code.toByteS((short)this.mDisplayedNumber, 0), UT.Code.toByteS((short)this.mDisplayedNumber, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mMode);
        }
        return this.getClientDataPacketShort(false, (short)this.mDisplayedNumber);
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedNumber = UT.Code.unsignS(aData);
        return true;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedNumber = UT.Code.unsignS(UT.Code.combine(aData[0], aData[1]));
        if (aData.length >= 7) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
            this.setDirectionData(aData[5]);
            this.mMode = aData[6];
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            this.box(aBlock, CS.PX_P[4 == this.mFacing ? 14 : 0], CS.PX_P[0 == this.mFacing ? 14 : 0], CS.PX_P[2 == this.mFacing ? 14 : 0], CS.PX_N[5 == this.mFacing ? 14 : 0], CS.PX_N[1 == this.mFacing ? 14 : 0], CS.PX_N[3 == this.mFacing ? 14 : 0]);
            return true;
        }
        if (this.mFacing == 4) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[2], CS.PX_N[0], CS.PX_N[2], CS.PX_N[12]);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[4], CS.PX_N[0], CS.PX_N[2], CS.PX_N[10]);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[6], CS.PX_N[0], CS.PX_N[2], CS.PX_N[8]);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[8], CS.PX_N[0], CS.PX_N[2], CS.PX_N[6]);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[10], CS.PX_N[0], CS.PX_N[2], CS.PX_N[4]);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_P[12], CS.PX_N[0], CS.PX_N[2], CS.PX_N[2]);
                    return true;
                }
            }
        }
        if (this.mFacing == 5) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[12], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[2]);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[10], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[4]);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[8], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[6]);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[6], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[8]);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[4], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[10]);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[0], CS.PX_P[12], CS.PX_P[2], CS.PX_N[14] + 0.005f, CS.PX_N[2], CS.PX_N[12]);
                    return true;
                }
            }
        }
        if (this.mFacing == 2) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[12], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[2], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[10], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[4], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[8], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[6], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[6], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[8], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[4], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[10], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_N[12], CS.PX_N[2], CS.PX_N[0]);
                    return true;
                }
            }
        }
        if (this.mFacing == 3) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[2], CS.PX_P[12], CS.PX_P[0], CS.PX_N[12], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[4], CS.PX_P[12], CS.PX_P[0], CS.PX_N[10], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[6], CS.PX_P[12], CS.PX_P[0], CS.PX_N[8], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[8], CS.PX_P[12], CS.PX_P[0], CS.PX_N[6], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[10], CS.PX_P[12], CS.PX_P[0], CS.PX_N[4], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[12], CS.PX_P[12], CS.PX_P[0], CS.PX_N[2], CS.PX_N[2], CS.PX_N[14] + 0.005f);
                    return true;
                }
            }
        }
        if (this.mFacing == 0) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[2], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[12], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[4], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[10], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[6], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[8], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[8], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[6], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[10], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[4], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[12], CS.PX_P[14] - 0.005f, CS.PX_P[12], CS.PX_N[2], CS.PX_N[0], CS.PX_N[2]);
                    return true;
                }
            }
        }
        if (this.mFacing == 1) {
            switch (aRenderPass) {
                case 1: {
                    this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
                case 2: {
                    this.box(aBlock, CS.PX_P[4], CS.PX_P[0], CS.PX_P[2], CS.PX_N[10], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
                case 3: {
                    this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[2], CS.PX_N[8], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
                case 4: {
                    this.box(aBlock, CS.PX_P[8], CS.PX_P[0], CS.PX_P[2], CS.PX_N[6], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
                case 5: {
                    this.box(aBlock, CS.PX_P[10], CS.PX_P[0], CS.PX_P[2], CS.PX_N[4], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
                case 6: {
                    this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[14] + 0.005f, CS.PX_N[12]);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aSide == this.mFacing) {
            if (aRenderPass == 0) {
                return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureFront(), this.mRGBa), BlockTextureDefault.get(this.getOverlayFront()));
            }
            return BlockTextureDefault.get(this.getCharacterIcon(aRenderPass - 1), this.getCharacterColor(aRenderPass - 1), false, true, true, true);
        }
        if (aShouldSideBeRendered[aSide] && aRenderPass == 0) {
            if (aSide == CS.OPOS[this.mFacing]) {
                return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureBack(), this.mRGBa), BlockTextureDefault.get(this.getOverlayBack()));
            }
            return BlockTextureMulti.get(BlockTextureDefault.get(this.getTextureSide(), this.mRGBa), BlockTextureDefault.get(this.getOverlaySide()));
        }
        return null;
    }

    public boolean hasHitDisplay(byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
        return tCoords[0] >= CS.PX_P[2] && tCoords[0] <= CS.PX_N[2] && tCoords[1] >= CS.PX_P[2] && tCoords[1] <= CS.PX_P[4];
    }

    public short[] getCharacterColor(int aIndex) {
        return CS.CA_WHITE;
    }

    public abstract IIconContainer getCharacterIcon(int var1);

    public abstract IIconContainer getTextureFront();

    public abstract IIconContainer getTextureBack();

    public abstract IIconContainer getTextureSide();

    public abstract IIconContainer getOverlayFront();

    public abstract IIconContainer getOverlayBack();

    public abstract IIconContainer getOverlaySide();

    public abstract String getSensorDescription();

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return aSide == CS.OPOS[this.mSecondFacing] ? (byte)0 : this.mRedstone;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? 14 : 0], CS.PX_P[0 == this.mFacing ? 14 : 0], CS.PX_P[2 == this.mFacing ? 14 : 0], CS.PX_N[5 == this.mFacing ? 14 : 0], CS.PX_N[1 == this.mFacing ? 14 : 0], CS.PX_N[3 == this.mFacing ? 14 : 0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? 14 : 0], CS.PX_P[0 == this.mFacing ? 14 : 0], CS.PX_P[2 == this.mFacing ? 14 : 0], CS.PX_N[5 == this.mFacing ? 14 : 0], CS.PX_N[1 == this.mFacing ? 14 : 0], CS.PX_N[3 == this.mFacing ? 14 : 0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? 14 : 0], CS.PX_P[0 == this.mFacing ? 14 : 0], CS.PX_P[2 == this.mFacing ? 14 : 0], CS.PX_N[5 == this.mFacing ? 14 : 0], CS.PX_N[1 == this.mFacing ? 14 : 0], CS.PX_N[3 == this.mFacing ? 14 : 0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? CS.PX_N[2] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean[] getValidSecondSides() {
        return CS.SIDES_ANY_BUT[this.mFacing];
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    static {
        LH.add("gt.tooltip.sensor.screwdrive.buttons", "Use Screwdriver on Buttons to enable Averaging Mode.");
        LH.add("gt.tooltip.sensor.screwdrive.display", "Use Screwdriver on Display toggle Hexadecimal Display.");
        LH.add("gt.tooltip.sensor.screwdrive.modes", "Use Screwdriver on anything else to switch Modes.");
    }
}

