/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.behavior;

import gregapi.code.TagData;
import gregapi.data.LH;
import gregapi.tileentity.behavior.TE_Behavior_Energy;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Capacitor;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TE_Behavior_Energy_Stats
extends TE_Behavior_Energy {
    public long mRec;
    public long mMin;
    public long mMax;
    public boolean mOverloaded = false;
    public TE_Behavior_Energy_Capacitor mStorage;

    public TE_Behavior_Energy_Stats(TileEntity aTileEntity, NBTTagCompound aNBT, TagData aEnergyType, TE_Behavior_Energy_Capacitor aStorage, long aSizeMin, long aSizeRec, long aSizeMax) {
        super(aTileEntity, aNBT, aEnergyType);
        this.mStorage = aStorage;
        this.mMin = Math.abs(aSizeMin);
        this.mRec = Math.abs(aSizeRec);
        this.mMax = Math.abs(aSizeMax);
    }

    public boolean isType(TagData aEnergyType) {
        return this.mType == aEnergyType;
    }

    public long sizeMin(TagData aEnergyType) {
        return this.mType != aEnergyType ? 0L : this.mMin;
    }

    public long sizeRec(TagData aEnergyType) {
        return this.mType != aEnergyType ? 0L : this.mRec;
    }

    public long sizeMax(TagData aEnergyType) {
        return this.mType != aEnergyType ? 0L : this.mMax;
    }

    public Collection<TagData> getTypes() {
        return this.mType.AS_LIST;
    }

    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H, String aSides, boolean aEmitting) {
        aList.add((aEmitting ? LH.Chat.RED + LH.get("gt.lang.energy.output") : LH.Chat.GREEN + LH.get("gt.lang.energy.input")) + ": " + LH.Chat.WHITE + this.mRec + " " + this.mType.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t (" + (this.mMin > 1L ? this.mMin + " to " : "up to ") + this.mMax + (UT.Code.stringInvalid(aSides) ? "" : ", " + aSides) + ")");
        aList.add(aEmitting ? LH.getToolTipRedstoneFluxEmit(this.mType) : LH.getToolTipRedstoneFluxAccept(this.mType));
    }

    public long doInject(long aSize, long aAmount, boolean aDoInject) {
        if ((aSize = Math.abs(aSize)) > this.mMax) {
            if (aDoInject) {
                this.mOverloaded = true;
            }
            return aAmount;
        }
        if (this.mStorage == null || this.mStorage.mEnergy >= this.mStorage.mCapacity) {
            return 0L;
        }
        long tInput = Math.min(this.mStorage.mCapacity - this.mStorage.mEnergy, aSize * aAmount);
        long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
        if (aDoInject) {
            this.mStorage.mEnergy += tConsumed * aSize;
        }
        return tConsumed;
    }
}

