/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.cover.CoverData;
import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.network.packets.covers.PacketSyncDataByteAndIDsAndCovers;
import gregapi.network.packets.covers.PacketSyncDataByteArrayAndIDsAndCovers;
import gregapi.network.packets.covers.PacketSyncDataIDsAndCovers;
import gregapi.network.packets.covers.PacketSyncDataIntegerAndIDsAndCovers;
import gregapi.network.packets.covers.PacketSyncDataLongAndIDsAndCovers;
import gregapi.network.packets.covers.PacketSyncDataShortAndIDsAndCovers;
import gregapi.network.packets.covervisuals.PacketSyncDataByteAndCoverVisuals;
import gregapi.network.packets.covervisuals.PacketSyncDataByteArrayAndCoverVisuals;
import gregapi.network.packets.covervisuals.PacketSyncDataCoverVisuals;
import gregapi.network.packets.covervisuals.PacketSyncDataIntegerAndCoverVisuals;
import gregapi.network.packets.covervisuals.PacketSyncDataLongAndCoverVisuals;
import gregapi.network.packets.covervisuals.PacketSyncDataShortAndCoverVisuals;
import gregapi.network.packets.data.PacketSyncDataByte;
import gregapi.network.packets.data.PacketSyncDataByteArray;
import gregapi.network.packets.data.PacketSyncDataInteger;
import gregapi.network.packets.data.PacketSyncDataLong;
import gregapi.network.packets.data.PacketSyncDataShort;
import gregapi.network.packets.ids.PacketSyncDataByteAndIDs;
import gregapi.network.packets.ids.PacketSyncDataByteArrayAndIDs;
import gregapi.network.packets.ids.PacketSyncDataIDs;
import gregapi.network.packets.ids.PacketSyncDataIntegerAndIDs;
import gregapi.network.packets.ids.PacketSyncDataLongAndIDs;
import gregapi.network.packets.ids.PacketSyncDataShortAndIDs;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase05Inventories;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.render.ITileEntityOnDrawBlockHighlight;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase06Covers
extends TileEntityBase05Inventories
implements ITileEntityCoverable,
ISidedInventory,
ITileEntitySurface,
ITileEntityOnDrawBlockHighlight,
IMultiTileEntity.IMTE_ShouldCheckWeakPower,
IMultiTileEntity.IMTE_IsSealable,
IMultiTileEntity.IMTE_OnWalkOver,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_SyncDataCovers,
IMultiTileEntity.IMTE_OnToolClick,
IMultiTileEntity.IMTE_AddCollisionBoxesToList,
IMultiTileEntity.IMTE_IsProvidingWeakPower,
IMultiTileEntity.IMTE_IsProvidingStrongPower {
    public CoverData mCovers = null;
    private int mInternalRenderPasses = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.covers")) {
            this.mCovers = CoverRegistry.coverdata(this, aNBT.getCompoundTag("gt.covers"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.hasCovers()) {
            aNBT.setTag("gt.covers", (NBTBase)this.mCovers.writeToNBT(UT.NBT.make(), true));
        }
    }

    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        return aNBT;
    }

    @Override
    public final NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(this.writeItemNBT2(aNBT));
        if (this.hasCovers()) {
            aNBT.setTag("gt.covers", (NBTBase)this.mCovers.writeToNBT(UT.NBT.make(), false));
        }
        return aNBT;
    }

    @Override
    public boolean receiveDataCovers(short[] aCoverVisuals, boolean[] aVisualsToSync, INetworkHandler aNetworkHandler) {
        if (!this.hasCovers()) {
            return false;
        }
        for (int i = 0; i < this.mCovers.mVisuals.length; i = (int)((byte)(i + 1))) {
            if (!aVisualsToSync[i]) continue;
            this.mCovers.mVisuals[i] = aCoverVisuals[i];
        }
        return true;
    }

    @Override
    public boolean receiveDataCovers(short[] aCoverIDs, short[] aCoverMetas, INetworkHandler aNetworkHandler) {
        if (aCoverIDs == null) {
            this.mCovers = null;
        } else {
            if (this.mCovers == null) {
                this.mCovers = CoverRegistry.coverdata(this, null);
            }
            this.mCovers.setIDs(aCoverIDs, aCoverMetas);
        }
        return true;
    }

    @Override
    public final boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte tSide;
        if (CS.SIDES_INVALID[aSide] || aPlayer == null || !this.allowInteraction((Entity)aPlayer)) {
            return this.onBlockActivated3(aPlayer, aSide, aHitX, aHitY, aHitZ);
        }
        byte by = tSide = this.usePipePlacementMode(aSide) ? UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ) : aSide;
        if (this.hasCovers()) {
            if (this.mCovers.mBehaviours[aSide] != null) {
                if (this.mCovers.mBehaviours[aSide].onCoverClickedRight(aSide, this.mCovers, (Entity)aPlayer, aSide, aHitX, aHitY, aHitZ)) {
                    return true;
                }
                if (this.mCovers.mBehaviours[aSide].interceptClickRight(aSide, this.mCovers, (Entity)aPlayer, aSide, aHitX, aHitY, aHitZ)) {
                    return false;
                }
            } else if (this.mCovers.mBehaviours[tSide] != null) {
                if (this.mCovers.mBehaviours[tSide].onCoverClickedRight(tSide, this.mCovers, (Entity)aPlayer, aSide, aHitX, aHitY, aHitZ)) {
                    return true;
                }
                if (this.mCovers.mBehaviours[tSide].interceptClickRight(tSide, this.mCovers, (Entity)aPlayer, aSide, aHitX, aHitY, aHitZ)) {
                    return false;
                }
            }
        }
        if (this.attachCoversFirst(aSide)) {
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            if (aStack != null && aStack.stackSize > 0 && this.setCoverItem(tSide, aStack, (Entity)aPlayer, false, true)) {
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    --aStack.stackSize;
                }
                return true;
            }
            return this.onBlockActivated3(aPlayer, aSide, aHitX, aHitY, aHitZ);
        }
        if (this.onBlockActivated3(aPlayer, aSide, aHitX, aHitY, aHitZ)) {
            return true;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        if (aStack != null && aStack.stackSize > 0 && this.setCoverItem(tSide, aStack, (Entity)aPlayer, false, true)) {
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
            return true;
        }
        return false;
    }

    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public final long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (!this.allowInteraction(aPlayer)) {
            return 0L;
        }
        if (this.checkObstruction(aPlayer instanceof EntityPlayer ? (EntityPlayer)aPlayer : null, aSide, aHitX, aHitY, aHitZ)) {
            return 0L;
        }
        if (CS.SIDES_VALID[aSide] && this.hasCovers()) {
            byte tSide;
            byte by = tSide = this.usePipePlacementMode(aSide) && this.mCovers.mIDs[aSide] == 0 ? UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ) : aSide;
            if (aTool.equals("crowbar") && this.isServerSide()) {
                ItemStack tStack = this.getCoverItem(tSide);
                ICover tCover = this.mCovers.mBehaviours[tSide];
                if (tStack != null && this.setCoverItem(tSide, null, aPlayer, false, true)) {
                    if (!ST.add(aPlayer, tStack, false)) {
                        ST.place(this.worldObj, (double)this.getOffsetX(aSide) + 0.5, (double)this.getOffsetY(aSide) + 0.5, (double)this.getOffsetZ(aSide) + 0.5, tStack);
                    }
                    if (tCover != null) {
                        tCover.onAfterCrowbar(this);
                    }
                    return 10000L;
                }
            }
            if (this.mCovers.mBehaviours[tSide] != null) {
                long rDamage;
                if (tSide != aSide && (rDamage = this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ)) > 0L) {
                    return rDamage;
                }
                return this.mCovers.mBehaviours[tSide].onToolClick(tSide, this.mCovers, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
            }
        }
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return 0L;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), this.mCovers) : new PacketSyncDataIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID())) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataCoverVisuals(this.getCoords(), this.mCovers) : null);
    }

    @Override
    public IPacket getClientDataPacketByte(boolean aSendAll, byte aByte) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataByteAndIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByte, this.mCovers) : new PacketSyncDataByteAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByte)) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataByteAndCoverVisuals(this.getCoords(), aByte, this.mCovers) : new PacketSyncDataByte(this.getCoords(), aByte));
    }

    @Override
    public IPacket getClientDataPacketShort(boolean aSendAll, short aShort) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataShortAndIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aShort, this.mCovers) : new PacketSyncDataShortAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aShort)) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataShortAndCoverVisuals(this.getCoords(), aShort, this.mCovers) : new PacketSyncDataShort(this.getCoords(), aShort));
    }

    @Override
    public IPacket getClientDataPacketInteger(boolean aSendAll, int aInteger) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataIntegerAndIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aInteger, this.mCovers) : new PacketSyncDataIntegerAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aInteger)) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataIntegerAndCoverVisuals(this.getCoords(), aInteger, this.mCovers) : new PacketSyncDataInteger(this.getCoords(), aInteger));
    }

    @Override
    public IPacket getClientDataPacketLong(boolean aSendAll, long aLong) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataLongAndIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aLong, this.mCovers) : new PacketSyncDataLongAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aLong)) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataLongAndCoverVisuals(this.getCoords(), aLong, this.mCovers) : new PacketSyncDataLong(this.getCoords(), aLong));
    }

    @Override
    public IPacket getClientDataPacketByteArray(boolean aSendAll, byte ... aByteArray) {
        return aSendAll ? (this.hasCovers() ? new PacketSyncDataByteArrayAndIDsAndCovers(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByteArray, this.mCovers) : new PacketSyncDataByteArrayAndIDs(this.getCoords(), this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), aByteArray)) : (this.hasCovers() && this.mCovers.requiresSync() ? new PacketSyncDataByteArrayAndCoverVisuals(this.getCoords(), aByteArray, this.mCovers) : new PacketSyncDataByteArray(this.getCoords(), aByteArray));
    }

    @Override
    public void onTickChecked(long aTimer) {
        super.onTickChecked(aTimer);
        if (this.hasCovers()) {
            this.mCovers.resetSync();
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.hasCovers() && this.mCovers.requiresSync() || super.onTickCheck(aTimer);
    }

    @Override
    public final void onTickFirst(boolean aIsServerSide) {
        super.onTickFirst(aIsServerSide);
        this.checkCoverValidity();
        this.onTickFirst2(aIsServerSide);
    }

    public void onTickFirst2(boolean aIsServerSide) {
    }

    @Override
    public final void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (this.hasCovers()) {
            this.mCovers.tickPre(aTimer, aIsServerSide, this.mBlockUpdated, this.mInventoryChanged);
        }
        this.onTick2(aTimer, aIsServerSide);
        if (this.hasCovers()) {
            this.mCovers.tickPost(aTimer, aIsServerSide, this.mBlockUpdated, this.mInventoryChanged);
        }
    }

    public void onTick2(long aTimer, boolean aIsServerSide) {
    }

    public void checkCoverValidity() {
        if (this.worldObj != null && this.isServerSide() && this.hasCovers()) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.allowCovers(tSide)) continue;
                ItemStack tStack = this.getCoverItem(tSide);
                if (!this.setCoverItem(tSide, null, null, true, true)) continue;
                ST.place(this.worldObj, this.getOffset(tSide, 1), tStack);
                UT.Sounds.send("random.break", 1.0f, -1.0f, this, false);
            }
        }
    }

    @Override
    public boolean isFireProof(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isOpaque(aSide, this.mCovers);
    }

    @Override
    public boolean isRainProof(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isOpaque(aSide, this.mCovers);
    }

    @Override
    public boolean isWaterProof(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isOpaque(aSide, this.mCovers);
    }

    @Override
    public boolean isThunderProof(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isOpaque(aSide, this.mCovers);
    }

    public boolean allowCover(byte aSide, ICover aCover) {
        return this.allowCovers(aSide);
    }

    public boolean allowCovers(byte aSide) {
        return true;
    }

    public boolean allowCoverHolders(byte aSide) {
        return true;
    }

    public boolean attachCoversFirst(byte aSide) {
        return true;
    }

    public boolean isCoverSurface(byte aSide) {
        return this.getSurfaceSize(aSide) == 1.0f && this.getSurfaceDistance(aSide) == 0.0f;
    }

    public boolean isCoverSurface(byte aSide, int aRenderpass) {
        return this.isCoverSurface(aSide);
    }

    public boolean hasCovers() {
        return this.mCovers != null;
    }

    public boolean isCovered(byte aSide) {
        return this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null;
    }

    public boolean usePipePlacementMode(byte aSide) {
        return false;
    }

    @Override
    public void updateCoverVisuals() {
    }

    @Override
    public boolean canTick() {
        return true;
    }

    @Override
    public void openCoverGUI(byte aSide, EntityPlayer aPlayer) {
        this.openGUI(aPlayer, -aSide - 1);
    }

    @Override
    public CoverData getCoverData() {
        return this.hasCovers() ? this.mCovers : null;
    }

    @Override
    public ItemStack getCoverItem(byte aSide) {
        return this.hasCovers() && CS.SIDES_VALID[aSide] ? this.mCovers.getCoverItem(aSide) : null;
    }

    @Override
    public boolean setCoverItem(byte aSide, ItemStack aStack, Entity aPlayer, boolean aForce, boolean aBlockUpdate) {
        if (CS.SIDES_INVALID[aSide] || !this.allowCovers(aSide) && aStack != null) {
            return false;
        }
        if (aStack == null && this.getCoverItem(aSide) == null) {
            return false;
        }
        if (this.mCovers == null) {
            this.mCovers = CoverRegistry.coverdata(this, null);
        }
        if (!aForce) {
            if (aStack == null) {
                if (this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptCoverRemoval(aSide, this.mCovers, aPlayer)) {
                    return !this.checkIfCoversEmptyAndDeleteIfNeeded();
                }
            } else {
                if (this.mCovers.mBehaviours[aSide] != null) {
                    return !this.checkIfCoversEmptyAndDeleteIfNeeded();
                }
                ICover tCover = CoverRegistry.get(aStack);
                if (tCover == null || !this.allowCover(aSide, tCover) || tCover.interceptCoverPlacement(aSide, this.mCovers, aPlayer)) {
                    return !this.checkIfCoversEmptyAndDeleteIfNeeded();
                }
            }
        }
        if (this.mCovers.mBehaviours[aSide] != null) {
            this.mCovers.mBehaviours[aSide].onCoverRemove(aSide, this.mCovers, aPlayer);
        }
        this.mCovers.set(aSide, aStack);
        if (this.mCovers.mBehaviours[aSide] != null) {
            this.mCovers.mBehaviours[aSide].onCoverPlaced(aSide, this.mCovers, aPlayer, aStack);
        }
        if (aBlockUpdate) {
            this.causeBlockUpdate();
        }
        this.updateClientData();
        return this.checkIfCoversEmptyAndDeleteIfNeeded();
    }

    private boolean checkIfCoversEmptyAndDeleteIfNeeded() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.mCovers.mBehaviours[tSide] == null) continue;
            return true;
        }
        this.mCovers = null;
        return true;
    }

    public final int[] getAccessibleSlotsFromSide(int aSide) {
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].getAccessibleSlotsFromSideOverride(UT.Code.side(aSide), this.mCovers, UT.Code.side(aSide))) {
            return this.mCovers.mBehaviours[aSide].getAccessibleSlotsFromSide(UT.Code.side(aSide), this.mCovers, UT.Code.side(aSide), this.getAccessibleSlotsFromSide2(UT.Code.side(aSide)));
        }
        return this.getAccessibleSlotsFromSide2(UT.Code.side(aSide));
    }

    public final boolean canInsertItem(int aSlot, ItemStack aStack, int aSide) {
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null) {
            if (this.mCovers.mBehaviours[aSide].interceptItemInsert(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide))) {
                return false;
            }
            if (this.mCovers.mBehaviours[aSide].canInsertItemOverride(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide))) {
                return this.mCovers.mBehaviours[aSide].canInsertItem(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide)) && this.canInsertItem2(aSlot, aStack, UT.Code.side(aSide));
            }
        }
        return this.canInsertItem2(aSlot, aStack, UT.Code.side(aSide));
    }

    public final boolean canExtractItem(int aSlot, ItemStack aStack, int aSide) {
        if (ST.invalid(aStack)) {
            aStack = this.slot(aSlot);
        }
        if (ST.debug(aStack)) {
            return false;
        }
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null) {
            if (this.mCovers.mBehaviours[aSide].interceptItemExtract(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide))) {
                return false;
            }
            if (this.mCovers.mBehaviours[aSide].canExtractItemOverride(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide))) {
                return this.mCovers.mBehaviours[aSide].canExtractItem(UT.Code.side(aSide), this.mCovers, aSlot, aStack, UT.Code.side(aSide)) && this.canExtractItem2(aSlot, aStack, UT.Code.side(aSide));
            }
        }
        return this.canExtractItem2(aSlot, aStack, UT.Code.side(aSide));
    }

    @Override
    protected final IFluidTank getFluidTankFillable(byte aSide, FluidStack aFluidToFill) {
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null) {
            if (this.mCovers.mBehaviours[aSide].getFluidTankFillableOverride(aSide, this.mCovers, aSide, aFluidToFill)) {
                return this.mCovers.mBehaviours[aSide].getFluidTankFillable(aSide, this.mCovers, aSide, aFluidToFill, this.getFluidTankFillable2(aSide, aFluidToFill));
            }
            if (this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluidToFill)) {
                return null;
            }
        }
        return this.getFluidTankFillable2(aSide, aFluidToFill);
    }

    @Override
    protected final IFluidTank getFluidTankDrainable(byte aSide, FluidStack aFluidToDrain) {
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null) {
            if (this.mCovers.mBehaviours[aSide].getFluidTankDrainableOverride(aSide, this.mCovers, aSide, aFluidToDrain)) {
                return this.mCovers.mBehaviours[aSide].getFluidTankDrainable(aSide, this.mCovers, aSide, aFluidToDrain, this.getFluidTankDrainable2(aSide, aFluidToDrain));
            }
            if (aFluidToDrain == null) {
                IFluidTank rTank = this.getFluidTankDrainable2(aSide, null);
                if (rTank == null) {
                    return null;
                }
                if (this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.mul(rTank.getFluid(), 1L))) {
                    return null;
                }
                return rTank;
            }
            if (this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluidToDrain)) {
                return null;
            }
        }
        return this.getFluidTankDrainable2(aSide, aFluidToDrain);
    }

    @Override
    protected final IFluidTank[] getFluidTanks(byte aSide) {
        if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].getFluidTanksOverride(aSide, this.mCovers, aSide)) {
            return this.mCovers.mBehaviours[aSide].getFluidTanks(aSide, this.mCovers, aSide, this.getFluidTanks2(aSide));
        }
        return this.getFluidTanks2(aSide);
    }

    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(this.getSizeInventory());
    }

    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return CS.ZL_FT;
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        super.onNeighborBlockChange(aWorld, aBlock);
        if (this.hasCovers()) {
            this.mCovers.onBlockUpdate();
        }
    }

    @Override
    public void receiveBlockUpdateFromCover() {
        this.mBlockUpdated = true;
        if (this.hasCovers()) {
            this.mCovers.onBlockUpdate();
        }
    }

    @Override
    public void sendBlockUpdateFromCover() {
        this.causeBlockUpdate();
    }

    @Override
    public final byte getRedstoneIncoming(byte aSide) {
        if (!this.hasCovers()) {
            return super.getRedstoneIncoming(aSide);
        }
        if (CS.SIDES_INVALID[aSide]) {
            byte rRedstone = 0;
            for (byte tSide : CS.ALL_SIDES_VALID) {
                rRedstone = this.mCovers.mBehaviours[tSide] == null ? (byte)Math.max(rRedstone, this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(tSide), this.getOffsetY(tSide), this.getOffsetZ(tSide), (int)tSide)) : (byte)Math.max(rRedstone, this.mCovers.mBehaviours[tSide].getRedstoneIn(tSide, this.mCovers));
                if (rRedstone < 15) continue;
                return 15;
            }
            return rRedstone;
        }
        return this.mCovers.mBehaviours[aSide] == null ? UT.Code.bind4(this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)aSide)) : this.mCovers.mBehaviours[aSide].getRedstoneIn(aSide, this.mCovers);
    }

    @Override
    public final int isProvidingWeakPower(byte aOppositeSide) {
        byte tActualSide = CS.OPOS[aOppositeSide];
        if (this.hasCovers() && CS.SIDES_VALID[tActualSide] && this.mCovers.mBehaviours[tActualSide] != null) {
            return this.mCovers.mBehaviours[tActualSide].getRedstoneOutWeak(tActualSide, this.mCovers, this.isProvidingWeakPower2(aOppositeSide));
        }
        return this.isProvidingWeakPower2(aOppositeSide);
    }

    @Override
    public final int isProvidingStrongPower(byte aOppositeSide) {
        byte tActualSide = CS.OPOS[aOppositeSide];
        if (this.hasCovers() && CS.SIDES_VALID[tActualSide] && this.mCovers.mBehaviours[tActualSide] != null) {
            return this.mCovers.mBehaviours[tActualSide].getRedstoneOutStrong(tActualSide, this.mCovers, this.isProvidingStrongPower2(aOppositeSide));
        }
        return this.isProvidingStrongPower2(aOppositeSide);
    }

    public byte isProvidingWeakPower2(byte aSide) {
        return 0;
    }

    public byte isProvidingStrongPower2(byte aSide) {
        return 0;
    }

    @Override
    public final boolean isSealable(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isSealable(aSide, this.mCovers) || this.isSealable2(aSide);
    }

    @Override
    public final boolean isSideSolid(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isSolid(aSide, this.mCovers) || this.isSideSolid2(aSide);
    }

    @Override
    public final boolean isSurfaceOpaque(byte aSide) {
        return this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isOpaque(aSide, this.mCovers) || this.isSurfaceOpaque2(aSide);
    }

    public boolean isSealable2(byte aSide) {
        return false;
    }

    public boolean isSideSolid2(byte aSide) {
        return this.isSurfaceSolid(aSide);
    }

    public boolean isSurfaceOpaque2(byte aSide) {
        return true;
    }

    @Override
    public final void onWalkOver(EntityLivingBase aEntity) {
        if (!this.hasCovers() || this.mCovers.mBehaviours[1] == null || !this.mCovers.mBehaviours[1].onWalkOver((byte)1, this.mCovers, (Entity)aEntity)) {
            this.onWalkOver2(aEntity);
        }
    }

    public void onWalkOver2(EntityLivingBase aEntity) {
    }

    @Override
    public final int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mInternalRenderPasses = this.getRenderPasses2(aBlock, aShouldSideBeRendered);
        return this.mInternalRenderPasses + (this.hasCovers() ? 12 : 0);
    }

    @Override
    public final boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass < this.mInternalRenderPasses ? this.usesRenderPass2(aRenderPass, aShouldSideBeRendered) : this.mCovers.mBehaviours[(aRenderPass - this.mInternalRenderPasses) / 2] != null && ((aRenderPass - this.mInternalRenderPasses) % 2 != 0 || this.allowCoverHolders((byte)((aRenderPass - this.mInternalRenderPasses) / 2))) && !this.isCoverSurface((byte)((aRenderPass - this.mInternalRenderPasses) / 2));
    }

    @Override
    public final boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < this.mInternalRenderPasses) {
            return this.setBlockBounds2(aBlock, aRenderPass, aShouldSideBeRendered);
        }
        int tRenderPass = aRenderPass - this.mInternalRenderPasses;
        return this.box(aBlock, tRenderPass % 2 == 0 ? this.mCovers.mBehaviours[tRenderPass / 2].getHolderBounds((byte)(tRenderPass / 2), this.mCovers) : this.mCovers.mBehaviours[tRenderPass / 2].getCoverBounds((byte)(tRenderPass / 2), this.mCovers));
    }

    @Override
    public final ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < this.mInternalRenderPasses) {
            if (this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.isCoverSurface(aSide, aRenderPass)) {
                return BlockTextureMulti.get(this.getTexture2(aBlock, aRenderPass, aSide, aShouldSideBeRendered), this.mCovers.mBehaviours[aSide].getCoverTextureSurface(aSide, this.mCovers));
            }
            return this.getTexture2(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }
        int tRenderPass = aRenderPass - this.mInternalRenderPasses;
        if (tRenderPass % 2 == 0) {
            return CS.ALONG_AXIS[aSide][tRenderPass /= 2] ? null : this.mCovers.mBehaviours[tRenderPass].getCoverTextureHolder((byte)tRenderPass, this.mCovers, aSide);
        }
        return !CS.ALONG_AXIS[aSide][tRenderPass /= 2] && (this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].isFullTexture(aSide, this.mCovers) || this.isCoverSurface(aSide, aRenderPass)) ? null : (aSide == CS.OPOS[tRenderPass] || aShouldSideBeRendered[aSide] ? this.mCovers.mBehaviours[tRenderPass].getCoverTextureAttachment((byte)tRenderPass, this.mCovers, aSide) : null);
    }

    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return false;
    }

    public abstract ITexture getTexture2(Block var1, int var2, byte var3, boolean[] var4);

    @Override
    public final void addCollisionBoxesToList(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        if (this.addDefaultCollisionBoxToList()) {
            this.box(this.getCollisionBoundingBoxFromPool(), aAABB, aList);
        }
        if (this.hasCovers()) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mCovers.mBehaviours[tSide] == null) continue;
                this.mCovers.mBehaviours[tSide].getCollisions(tSide, this.mCovers, aAABB, aList, aEntity);
            }
        }
        this.addCollisionBoxesToList2(aAABB, aList, aEntity);
    }

    public boolean addDefaultCollisionBoxToList() {
        return true;
    }

    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final Object getGUIClient(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID <= -1 && aGUIID >= -6 ? (this.hasCovers() && this.mCovers.mBehaviours[-aGUIID - 1] != null ? this.mCovers.mBehaviours[-aGUIID - 1].getGUIServer((byte)(-aGUIID - 1), this.mCovers, aPlayer) : null) : this.getGUIClient2(aGUIID, aPlayer);
    }

    @Override
    public final Object getGUIServer(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID <= -1 && aGUIID >= -6 ? (this.hasCovers() && this.mCovers.mBehaviours[-aGUIID - 1] != null ? this.mCovers.mBehaviours[-aGUIID - 1].getGUIClient((byte)(-aGUIID - 1), this.mCovers, aPlayer) : null) : this.getGUIServer2(aGUIID, aPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        if (CS.ToolsGT.contains("magnifyingglass", aStack)) {
            return true;
        }
        if (!this.usePipePlacementMode(aSide)) {
            return false;
        }
        if (CoverRegistry.get(aStack) != null) {
            return true;
        }
        if (this.hasCovers() && this.mCovers.mBehaviours[aSide] != null) {
            return false;
        }
        return CS.ToolsGT.contains("crowbar", aStack);
    }
}

