/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gregapi.data.FL;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class RendererBlockFluid
implements ISimpleBlockRenderingHandler {
    public static int RENDER_ID = FluidRegistry.renderIdFluid;
    public static RendererBlockFluid INSTANCE;
    private static final float MAX_FLUID_HEIGHT = 0.8888889f;
    private static final float LIGHT_Y_NEG = 0.5f;
    private static final float LIGHT_Y_POS = 1.0f;
    private static final float LIGHT_XZ_NEG = 0.8f;
    private static final float LIGHT_XZ_POS = 0.6f;
    static final double RENDER_OFFSET = (double)0.001f;

    public RendererBlockFluid(int aRenderID) {
        INSTANCE = this;
        RENDER_ID = aRenderID;
    }

    public float getFluidHeightAverage(float[] aFlow) {
        float total = 0.0f;
        float end = 0.0f;
        int count = 0;
        for (int i = 0; i < aFlow.length; ++i) {
            if (aFlow[i] >= 0.8888889f && end != 1.0f) {
                end = aFlow[i];
            }
            if (!(aFlow[i] >= 0.0f)) continue;
            total += aFlow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(IBlockAccess aWorld, int aX, int aY, int aZ, BlockFluidBase aFluidBlock, Block aBlock) {
        if (aBlock == null) {
            aBlock = aWorld.getBlock(aX, aY, aZ);
        }
        if (aBlock == aFluidBlock) {
            Block tBlockAbove = aWorld.getBlock(aX, aY - FL.dir(aFluidBlock), aZ);
            if (tBlockAbove.getMaterial().isLiquid() || tBlockAbove instanceof IFluidBlock) {
                return 1.0f;
            }
            return UT.Code.bindF(aFluidBlock.getQuantaPercentage(aWorld, aX, aY, aZ)) * 0.8888889f;
        }
        return !aBlock.getMaterial().isSolid() && aWorld.getBlock(aX, aY - FL.dir(aFluidBlock), aZ) == aFluidBlock ? 1.0f : UT.Code.bindF(aFluidBlock.getQuantaPercentage(aWorld, aX, aY, aZ)) * 0.8888889f;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        if (!(aBlock instanceof BlockFluidBase)) {
            return false;
        }
        BlockFluidBase aFluid = (BlockFluidBase)aBlock;
        Tessellator tTesselator = Tessellator.instance;
        int color = aFluid.colorMultiplier(aWorld, aX, aY, aZ);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int bMeta = aWorld.getBlockMetadata(aX, aY, aZ);
        int aDir = FL.dir(aFluid);
        boolean renderTop = aWorld.getBlock(aX, aY - aDir, aZ) != aFluid;
        boolean renderBottom = aFluid.shouldSideBeRendered(aWorld, aX, aY + aDir, aZ, 0) && aWorld.getBlock(aX, aY + aDir, aZ) != aFluid;
        boolean[] renderSides = new boolean[]{aFluid.shouldSideBeRendered(aWorld, aX, aY, aZ - 1, 2), aFluid.shouldSideBeRendered(aWorld, aX, aY, aZ + 1, 3), aFluid.shouldSideBeRendered(aWorld, aX - 1, aY, aZ, 4), aFluid.shouldSideBeRendered(aWorld, aX + 1, aY, aZ, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        float flow11 = this.getFluidHeightForRender(aWorld, aX, aY, aZ, aFluid, (Block)aFluid);
        boolean rRendered = false;
        if (flow11 != 1.0f) {
            float flow00 = this.getFluidHeightForRender(aWorld, aX - 1, aY, aZ - 1, aFluid, null);
            float flow01 = this.getFluidHeightForRender(aWorld, aX - 1, aY, aZ, aFluid, null);
            float flow02 = this.getFluidHeightForRender(aWorld, aX - 1, aY, aZ + 1, aFluid, null);
            float flow10 = this.getFluidHeightForRender(aWorld, aX, aY, aZ - 1, aFluid, null);
            float flow12 = this.getFluidHeightForRender(aWorld, aX, aY, aZ + 1, aFluid, null);
            float flow20 = this.getFluidHeightForRender(aWorld, aX + 1, aY, aZ - 1, aFluid, null);
            float flow21 = this.getFluidHeightForRender(aWorld, aX + 1, aY, aZ, aFluid, null);
            float flow22 = this.getFluidHeightForRender(aWorld, aX + 1, aY, aZ + 1, aFluid, null);
            heightNW = this.getFluidHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            heightSW = this.getFluidHeightAverage(new float[]{flow01, flow02, flow12, flow11});
            heightSE = this.getFluidHeightAverage(new float[]{flow12, flow21, flow22, flow11});
            heightNE = this.getFluidHeightAverage(new float[]{flow10, flow20, flow21, flow11});
        } else {
            heightNW = flow11;
            heightSW = flow11;
            heightSE = flow11;
            heightNE = flow11;
        }
        if (aRenderer.renderAllFaces || renderTop) {
            double v3;
            double u3;
            double v4;
            double u4;
            double v1;
            double u1;
            double v2;
            double u2;
            rRendered = true;
            IIcon iconStill = aFluid.getIcon(1, bMeta);
            float flowDir = (float)BlockFluidBase.getFlowDirection((IBlockAccess)aWorld, (int)aX, (int)aY, (int)aZ);
            if (flowDir > -999.0f) {
                iconStill = aFluid.getIcon(2, bMeta);
            }
            if (iconStill == null) {
                iconStill = Blocks.water.getIcon(0, 0);
            }
            heightNW -= (double)0.001f;
            heightSW -= (double)0.001f;
            heightSE -= (double)0.001f;
            heightNE -= (double)0.001f;
            if (flowDir < -999.0f) {
                u2 = iconStill.getInterpolatedU(0.0);
                v2 = iconStill.getInterpolatedV(0.0);
                u1 = u2;
                v1 = iconStill.getInterpolatedV(16.0);
                u4 = iconStill.getInterpolatedU(16.0);
                v4 = v1;
                u3 = u4;
                v3 = v2;
            } else {
                float xFlow = MathHelper.sin((float)flowDir) * 0.25f;
                float zFlow = MathHelper.cos((float)flowDir) * 0.25f;
                u2 = iconStill.getInterpolatedU((double)(8.0f + (-zFlow - xFlow) * 16.0f));
                v2 = iconStill.getInterpolatedV((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                u1 = iconStill.getInterpolatedU((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                v1 = iconStill.getInterpolatedV((double)(8.0f + (zFlow + xFlow) * 16.0f));
                u4 = iconStill.getInterpolatedU((double)(8.0f + (zFlow + xFlow) * 16.0f));
                v4 = iconStill.getInterpolatedV((double)(8.0f + (zFlow - xFlow) * 16.0f));
                u3 = iconStill.getInterpolatedU((double)(8.0f + (zFlow - xFlow) * 16.0f));
                v3 = iconStill.getInterpolatedV((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            }
            tTesselator.setBrightness(aFluid.getMixedBrightnessForBlock(aWorld, aX, aY, aZ));
            tTesselator.setColorOpaque_F(1.0f * red, 1.0f * green, 1.0f * blue);
            if (aDir < 0) {
                tTesselator.addVertexWithUV((double)(aX + 0), (double)aY + heightNW, (double)(aZ + 0), u2, v2);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)aY + heightSW, (double)(aZ + 1), u1, v1);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)aY + heightSE, (double)(aZ + 1), u4, v4);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)aY + heightNE, (double)(aZ + 0), u3, v3);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)aY + heightNW, (double)(aZ + 0), u2, v2);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)aY + heightNE, (double)(aZ + 0), u3, v3);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)aY + heightSE, (double)(aZ + 1), u4, v4);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)aY + heightSW, (double)(aZ + 1), u1, v1);
            } else {
                tTesselator.addVertexWithUV((double)(aX + 1), (double)(aY + 1) - heightNE, (double)(aZ + 0), u3, v3);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)(aY + 1) - heightSE, (double)(aZ + 1), u4, v4);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)(aY + 1) - heightSW, (double)(aZ + 1), u1, v1);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)(aY + 1) - heightNW, (double)(aZ + 0), u2, v2);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)(aY + 1) - heightNE, (double)(aZ + 0), u3, v3);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)(aY + 1) - heightNW, (double)(aZ + 0), u2, v2);
                tTesselator.addVertexWithUV((double)(aX + 0), (double)(aY + 1) - heightSW, (double)(aZ + 1), u1, v1);
                tTesselator.addVertexWithUV((double)(aX + 1), (double)(aY + 1) - heightSE, (double)(aZ + 1), u4, v4);
            }
        }
        if (aRenderer.renderAllFaces || renderBottom) {
            rRendered = true;
            tTesselator.setBrightness(aFluid.getMixedBrightnessForBlock(aWorld, aX, aY - 1, aZ));
            if (aDir < 0) {
                tTesselator.setColorOpaque_F(0.5f * red, 0.5f * green, 0.5f * blue);
                aRenderer.renderFaceYNeg((Block)aFluid, (double)aX, (double)aY + (double)0.001f, (double)aZ, aFluid.getIcon(0, bMeta));
            } else {
                tTesselator.setColorOpaque_F(1.0f * red, 1.0f * green, 1.0f * blue);
                aRenderer.renderFaceYPos((Block)aFluid, (double)aX, (double)aY + (double)0.001f, (double)aZ, aFluid.getIcon(1, bMeta));
            }
        }
        for (int side = 0; side < 4; ++side) {
            double tz2;
            double tz1;
            double tx2;
            double tx1;
            double ty2;
            double ty1;
            int x2 = aX;
            int z2 = aZ;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                }
            }
            IIcon iconFlow = aFluid.getIcon(side + 2, bMeta);
            if (!aRenderer.renderAllFaces && !renderSides[side]) continue;
            rRendered = true;
            if (side == 0) {
                ty1 = heightNW;
                ty2 = heightNE;
                tx1 = aX;
                tx2 = aX + 1;
                tz1 = (double)aZ + (double)0.001f;
                tz2 = (double)aZ + (double)0.001f;
            } else if (side == 1) {
                ty1 = heightSE;
                ty2 = heightSW;
                tx1 = aX + 1;
                tx2 = aX;
                tz1 = (double)(aZ + 1) - (double)0.001f;
                tz2 = (double)(aZ + 1) - (double)0.001f;
            } else if (side == 2) {
                ty1 = heightSW;
                ty2 = heightNW;
                tx1 = (double)aX + (double)0.001f;
                tx2 = (double)aX + (double)0.001f;
                tz1 = aZ + 1;
                tz2 = aZ;
            } else {
                ty1 = heightNE;
                ty2 = heightSE;
                tx1 = (double)(aX + 1) - (double)0.001f;
                tx2 = (double)(aX + 1) - (double)0.001f;
                tz1 = aZ;
                tz2 = aZ + 1;
            }
            float u1Flow = iconFlow.getInterpolatedU(0.0);
            float u2Flow = iconFlow.getInterpolatedU(8.0);
            float v1Flow = iconFlow.getInterpolatedV((1.0 - ty1) * 16.0 * 0.5);
            float v2Flow = iconFlow.getInterpolatedV((1.0 - ty2) * 16.0 * 0.5);
            float v3Flow = iconFlow.getInterpolatedV(8.0);
            tTesselator.setBrightness(aFluid.getMixedBrightnessForBlock(aWorld, x2, aY, z2));
            float sideLighting = side < 2 ? 0.8f : 0.6f;
            tTesselator.setColorOpaque_F(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            if (aDir < 0) {
                tTesselator.addVertexWithUV(tx1, (double)aY + ty1, tz1, (double)u1Flow, (double)v1Flow);
                tTesselator.addVertexWithUV(tx2, (double)aY + ty2, tz2, (double)u2Flow, (double)v2Flow);
                tTesselator.addVertexWithUV(tx2, (double)(aY + 0), tz2, (double)u2Flow, (double)v3Flow);
                tTesselator.addVertexWithUV(tx1, (double)(aY + 0), tz1, (double)u1Flow, (double)v3Flow);
                tTesselator.addVertexWithUV(tx1, (double)aY + ty1, tz1, (double)u1Flow, (double)v1Flow);
                tTesselator.addVertexWithUV(tx1, (double)(aY + 0), tz1, (double)u1Flow, (double)v3Flow);
                tTesselator.addVertexWithUV(tx2, (double)(aY + 0), tz2, (double)u2Flow, (double)v3Flow);
                tTesselator.addVertexWithUV(tx2, (double)aY + ty2, tz2, (double)u2Flow, (double)v2Flow);
                continue;
            }
            tTesselator.addVertexWithUV(tx1, (double)(aY + 1 - 0), tz1, (double)u1Flow, (double)v3Flow);
            tTesselator.addVertexWithUV(tx2, (double)(aY + 1 - 0), tz2, (double)u2Flow, (double)v3Flow);
            tTesselator.addVertexWithUV(tx2, (double)(aY + 1) - ty2, tz2, (double)u2Flow, (double)v2Flow);
            tTesselator.addVertexWithUV(tx1, (double)(aY + 1) - ty1, tz1, (double)u1Flow, (double)v1Flow);
            tTesselator.addVertexWithUV(tx1, (double)(aY + 1 - 0), tz1, (double)u1Flow, (double)v3Flow);
            tTesselator.addVertexWithUV(tx1, (double)(aY + 1) - ty1, tz1, (double)u1Flow, (double)v1Flow);
            tTesselator.addVertexWithUV(tx2, (double)(aY + 1) - ty2, tz2, (double)u2Flow, (double)v2Flow);
            tTesselator.addVertexWithUV(tx2, (double)(aY + 1 - 0), tz2, (double)u2Flow, (double)v3Flow);
        }
        aRenderer.renderMinY = 0.0;
        aRenderer.renderMaxY = 1.0;
        return rRendered;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return RENDER_ID;
    }
}

